/**
 * PURPOSE : Validation and Itemchange for Perl Claim verification
 * AUTHOR : Kunal Mandhre
 * DATE : 03/10/2012
 */

package ibase.webitm.ejb.adm;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.*;
import java.util.*;

import org.w3c.dom.*;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

@javax.ejb.Stateless
public class PerkClaimIC extends ValidatorEJB implements PerkClaimICLocal, PerkClaimICRemote  
{


	public String wfValData(String currFrmXmlStr, String hdrFrmXmlStr,String allFrmXmlStr, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = "";
		System.out.println("curr xml="+currFrmXmlStr);
		System.out.println("hdr xml="+hdrFrmXmlStr);
		System.out.println("all xml="+allFrmXmlStr);

		try
		{	
			// Modified by Piyush on 12/02/2016 [To validate the previous date pending claim from 3rd form before itm_default of 3rd form].Start
			if (objContext != null && !objContext.trim().equals("2"))
			{
			// Modified by Piyush on 12/02/2016 [To validate the previous date pending claim from 3rd form before itm_default of 3rd form].End
				if(currFrmXmlStr != null && currFrmXmlStr.trim().length()!=0)
				{
					currDom = parseString(currFrmXmlStr); 
				}
				if(hdrFrmXmlStr != null && hdrFrmXmlStr.trim().length()!=0)
				{
					hdrDom = parseString(hdrFrmXmlStr); 
				}
				if(allFrmXmlStr != null && allFrmXmlStr.trim().length()!=0)
				{
					allDom = parseString(allFrmXmlStr);
				}
				errString = wfValData(currDom,hdrDom,allDom,objContext,editFlag,xtraParams);
			}
		}//end of try
		catch(Exception e)
		{
			System.out.println("Exception : [PerkClaimIc][wfValData(String currFrmXmlStr)] : ==>\n"+e.getMessage());
			e.printStackTrace();			
			throw new ITMException(e);
		}
		return (errString); 
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of specified fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currDom contains the current form data as a document object model
	 * @param hdrDom contains all the header information
	 * @param allDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	public String wfValData(Document currDom, Document hdrDom, Document allDom, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 	
	{
		String errString = "";
		String columnValue = "";
		String sql = "";	
		String adCode = "" , balOpt = "" ,payable = "" , varValue = "" , empCode = "", bankCode = "";
		String adjLoan = "", fullAmt = "" , paySite = "" ,cadre = "" ,grade = "";
		String payrollVoucher = "",payrollPrd = "";
		String childNodeName = "";
		//String invStat = "";
		int noOfChilds = 0;
		int noOfParent = 0;                            
		int count = 0;    

		//double balanceAmt = 0;
		java.util.Date claimDate = null; 
		Timestamp relieveDate = null;

		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "";
		ArrayList errList = new ArrayList();
		ArrayList errFields = new ArrayList();
		AdmCommon admCommon = new AdmCommon(); 
		SimpleDateFormat simpleDateFormat = null;

		try
		{

			int currentFormNo = 0, cnt = 0;		

			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			// Modified by Piyush on 12/02/2016 [To support date format settings]
			// simpleDateFormat = new SimpleDateFormat("dd/MM/yy");
			simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());

			Node childNode =null;

			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}

			NodeList parentList = currDom.getElementsByTagName( "Detail" + currentFormNo );
			NodeList childList = null;	
			noOfParent = parentList.getLength();

			switch(currentFormNo)
			{
			case 1 :
			{
				System.out.println("Case 1 Validation");
				childList = parentList.item( 0 ).getChildNodes();
				noOfChilds = childList.getLength();
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{	
					childNode = childList.item( ctr );
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = childNode.getNodeName();						
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
					if ( "ad_code".equalsIgnoreCase( childNodeName ) )
					{
						adCode = checkNull(genericUtility.getColumnValue( "ad_code", currDom ));
						System.out.println("adCode="+adCode);
						//ls_var_val = gf_getenv("999999" , "CLAIMAD_WO_LOANADJ")
						// Modified by Piyush on 30/06/2015[To make the validation proper and resolve the issues of ad code not getting validated against the parameter].Start
						/*
						varValue =  admCommon.getEnv("999999", "CLAIMAD_WO_LOANADJ", conn);
						System.out.println("varValue="+varValue);
						if(varValue != null && varValue.trim().length() > 0 && "NULLFOUND".equalsIgnoreCase(varValue))
						{
							varValue = varValue.trim()+",";
							if(varValue.indexOf(adCode.trim()+",") > 0 )
							{
								//errcode = "VPPERKAD1~tThis type of perk can not be claimed using this option, use claim without loan adjustment option"
								errList.add( "VPPERKAD1" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						*/

						String adCodeForClaimWOLoanAdj = checkNull(admCommon.getEnv("999999","CLAIMAD_WO_LOANADJ", conn));
						System.out.println("CLAIMAD_WO_LOANADJ....["+adCodeForClaimWOLoanAdj+"]");
						if (adCodeForClaimWOLoanAdj.length() > 0)
						{
							ArrayList adCodeListForClaimWOLoanAdj = new ArrayList(Arrays.asList(adCodeForClaimWOLoanAdj.split(",")));
							if (adCodeListForClaimWOLoanAdj.contains(adCode.trim()))
							{
								System.out.println("AD Code for loan without adjustment:::");
																
								errList.add( "VPPERKAD1" );
								errFields.add( "ad_code");
							}
						}

						// Modified by Piyush on 30/06/2015[To make the validation proper and resolve the issues of ad code not getting validated against the parameter].End

						sql = " select count(*) from allwdedn where ad_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, adCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							cnt = rs.getInt(1);
						}							
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						if(cnt == 0)
						{
							errList.add( "VMADC1" );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							sql = " select bal_opt,payable from allwdedn where ad_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, adCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								balOpt = checkNull(rs.getString("bal_opt"));
								payable = checkNull(rs.getString("payable"));
							}							
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if("D".equalsIgnoreCase(payable))
							{
								errList.add( "VTADTYPE" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}
					else if ( "claim_date".equalsIgnoreCase( childNodeName ) )
					{
						System.out.println("claim date = "+genericUtility.getColumnValue( "claim_date", currDom ) == null);
						if(genericUtility.getColumnValue( "claim_date", currDom ) == null)
						{
							errList.add( "VMDATENULL" );
							errFields.add( childNodeName.toLowerCase() );
						}
						// Modified by Piyush on 12/02/2016 [To Check period status].Start
						else
						{
							empCode = checkNull(genericUtility.getColumnValue( "emp_code", currDom ));
							System.out.println("empCode="+empCode);
							try
							{
								claimDate =  simpleDateFormat.parse(genericUtility.getColumnValue("claim_date", currDom));
							}
							catch (Exception e0)
							{
								errCode = "VMDATENULL";
								errList.add( "VMDATENULL" );
								errFields.add( childNodeName.toLowerCase() );
							}
							if (empCode != null && empCode.trim().length() > 0 && (errCode == null || errCode.trim().length() == 0))
							{
								String acctSite = "";
								paySite = "";
								sql = "SELECT A.PAY_SITE AS PAY_SITE, B.SITE_CODE__ACCT AS SITE_CODE__ACCT FROM EMPLOYEE A, SITE B WHERE A.EMP_CODE = ? AND B.SITE_CODE = A.PAY_SITE";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, empCode);
								rs = pstmt.executeQuery();
								cnt = 0;
								if (rs.next())
								{
									cnt = 1;
									paySite = rs.getString("PAY_SITE");
									acctSite = rs.getString("SITE_CODE__ACCT");
								}							
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								if(cnt > 0)
								{
									if (acctSite == null || acctSite.trim().length() == 0)
									{
										acctSite = paySite;
									}
									String errCode1 = nfCheckPeriod("ADM",claimDate,acctSite);
									if(errCode1 == null || errCode1.trim().length() == 0)
									{
										errCode1 = nfCheckPeriod("FIN",claimDate,acctSite);
									}
									if (errCode1 != null && errCode1.trim().length() > 0)
									{
										errList.add( errCode1 );
										errFields.add( childNodeName.toLowerCase() );
									}
								}
							}

						}
						// Modified by Piyush on 12/02/2016 [To Check period status].End
					}
					else if ( "bank_code".equalsIgnoreCase( childNodeName ) )
					{
						bankCode = checkNull(genericUtility.getColumnValue( "bank_code", currDom ));
						System.out.println("bankCode="+bankCode);

						if(bankCode != null && bankCode.trim().length() > 0)
						{
						sql = " select count(*) from bank where bank_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, bankCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							cnt = rs.getInt(1);
						}							
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if(cnt == 0)
						{
							errList.add( "VMBANK1" );
							errFields.add( childNodeName.toLowerCase() );
						}
						}
					}
					else if ( "emp_code".equalsIgnoreCase( childNodeName ) )
					{
						empCode = checkNull(genericUtility.getColumnValue( "emp_code", currDom ));
						System.out.println("empCode="+empCode);

						sql = " select count(*) from employee where emp_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, empCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							cnt = rs.getInt(1);
						}							
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						if(cnt == 0)
						{
							errList.add( "VMEMP1" );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							sql = " Select count(*)  from loans   Where emp_code = ?  "
									+"	and (status = 'U' or (status = 'A' and start_dedn <> 'Y')) 	and accrual_amt > 0 ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,empCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}							
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt > 0)
							{
								errList.add( "VTLOAN7" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						System.out.println("case 1 val for process tab");
						empCode = checkNull(genericUtility.getColumnValue("emp_code",currDom));
						adCode = checkNull(genericUtility.getColumnValue("ad_code",currDom));
						fullAmt = checkNull(genericUtility.getColumnValue("full_amt",currDom)) ; 
						adjLoan = checkNull(genericUtility.getColumnValue("adjust_loan",currDom));
						System.out.println("empCode="+empCode);
						System.out.println("adCode="+adCode);
						System.out.println("fullAmt="+fullAmt);
						System.out.println("adjLoan="+adjLoan);
						if(genericUtility.getColumnValue("claim_date", currDom) == null)
						{
							claimDate = null;
						}
						else
						{
							claimDate =  simpleDateFormat.parse(genericUtility.getColumnValue("claim_date", currDom));
						}
						System.out.println("claimDate="+claimDate);
						/*
						if("Y".equalsIgnoreCase(adjLoan))
						{
							//loan tab enable
							sql = "select sum(balance_amt) 	from allowdedn_bal,loans where ref_no = loan_no "
									+" and allowdedn_bal.emp_code = ?  and ad_code between '0' and 'z' and amt_bal > 0 	and ref_type = 'L' 	and adjustable = 'Y'";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, empCode );						
							rs = pstmt.executeQuery();	
							if( rs.next() )
							{
								balanceAmt = rs.getDouble(1);
							}
							rs.close();rs = null;
							pstmt.close();pstmt = null;
						}
						else
						{
							//loan tab disable
						}
						*/

						sql = "select relieve_date,pay_site,cadre,grade " 
								+" from employee where emp_code = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, empCode );						
						rs = pstmt.executeQuery();	
						if( rs.next() )
						{
							relieveDate = rs.getTimestamp("relieve_date");
							paySite = checkNull(rs.getString("pay_site"));
							cadre = checkNull(rs.getString("cadre"));
							grade = checkNull(rs.getString("grade"));
						}
						rs.close();rs = null;
						pstmt.close();pstmt = null;

						String envName = adCode.trim().toUpperCase()+"_CLAIMCURRPRD";
						System.out.println("envName="+envName);
						//ls_can_claim_in_sameyear = gf_get_admenv(ls_site , ls_cadre , ls_grade , & 
						//	ls_env_name , ld_claim)
						// Modified by Piyush on 02/04/2015[Should be claim date and not relieve date].Start
						// String canClaimInsameYear = admCommon.getAdmEnv(paySite, cadre, grade, envName, relieveDate, conn);
						Timestamp tsClaimDate = null;
						tsClaimDate = new Timestamp(claimDate.getTime());
						String canClaimInsameYear = admCommon.getAdmEnv(paySite, cadre, grade, envName, tsClaimDate, conn);
						// Modified by Piyush on 02/04/2015[Should be claim date and not relieve date].End
						System.out.println("canClaimInsameYear="+canClaimInsameYear);

						if("NULLFOUND".equalsIgnoreCase(canClaimInsameYear))
						{
							canClaimInsameYear = admCommon.getEnv("999999", envName, conn);
							System.out.println("canClaimInsameYear="+canClaimInsameYear);
							if("NULLFOUND".equalsIgnoreCase(canClaimInsameYear))
							{
								errList.add( "VSENVAR1" );
								errFields.add( childNodeName.toLowerCase() );
								//ls_errcode = 'VSENVAR1~t Variable (" + ls_env_name + ") is not defined properly'
							}
						}
						/*else if() elseif left(ls_can_claim_in_sameyear , 4) = "ERR~t" then
						{
							ls_errcode = mid(ls_can_claim_in_sameyear , 5) + &
									'Could not fetch environment (' + ls_env_name + ') from site_env table'
						}*/

					}
					else if ( "payroll_voucher".equalsIgnoreCase( childNodeName ) )
					{
						payrollVoucher = checkNull(genericUtility.getColumnValue( "payroll_voucher", currDom ));
						payrollPrd = checkNull(genericUtility.getColumnValue( "payroll_prd", currDom ));
						if("P".equalsIgnoreCase(payrollVoucher))
						{
							if(payrollPrd == null || payrollPrd.trim().length() == 0 )
							{
								errList.add( "VMPRDCD" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						//Modified by Ahmed on 27/Jul/2017[To validate when payroll_voucher is P and adjust_loan is yes][start]
						String adjustLoan = checkNull(genericUtility.getColumnValue("adjust_loan", currDom));
						System.out.println("payrollvoucher>>"+payrollVoucher);
						System.out.println("adjustLoan>>"+adjustLoan);
						if("P".equalsIgnoreCase(payrollVoucher) && !"N".equalsIgnoreCase(adjustLoan))
						{
							errList.add("VMPRKPAYV1");
							errFields.add(childNodeName.toLowerCase());
						}
						//Modified by Ahmed on 27/Jul/2017[To validate when payroll_voucher is P and adjust_loan is yes][end]						
					}
					//Modified By Hemlata on [29/05/2015][To validate payroll period in period table][Start]
					else if ( "payroll_prd".equalsIgnoreCase( childNodeName ) )
					{
						payrollPrd = checkNull(genericUtility.getColumnValue( "payroll_prd", currDom ));
						System.out.println("payrollPrd="+payrollPrd);

						if(payrollPrd != null && payrollPrd.trim().length() > 0)
						{
							sql = "select count(*) as period_count from period where code  = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, payrollPrd);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt("period_count");
							}							
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							System.out.println("Payroll period cnt:::::["+cnt+"]");
							
							if(cnt == 0)
							{
								errList.add( "VMINVPRDCD" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}
					//Modified By Hemlata on [29/05/2015][To validate payroll period in period table][End]
					
					/*else
					{
						System.out.println("case 1 val else");
						empCode = checkNull(genericUtility.getColumnValue("emp_code",currDom));
						adCode = checkNull(genericUtility.getColumnValue("ad_code",currDom));
						fullAmt = checkNull(genericUtility.getColumnValue("full_amt",currDom)) ; 
						adjLoan = checkNull(genericUtility.getColumnValue("adjust_loan",currDom));
						System.out.println("empCode="+empCode);
						System.out.println("adCode="+adCode);
						System.out.println("fullAmt="+fullAmt);
						System.out.println("adjLoan="+adjLoan);
						if(genericUtility.getColumnValue("claim_date", currDom) == null)
						{
							claimDate = null;
						}
						else
						{
							claimDate =  simpleDateFormat.parse(genericUtility.getColumnValue("claim_date", currDom));
						}
						System.out.println("claimDate="+claimDate);
						if("Y".equalsIgnoreCase(adjLoan))
						{
							//loan tab enable
							sql = "select sum(balance_amt) 	from allowdedn_bal,loans where ref_no = loan_no "
									+" and allowdedn_bal.emp_code = ?  and ad_code between '0' and 'z' and amt_bal > 0 	and ref_type = 'L' 	and adjustable = 'Y'";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, empCode );						
							rs = pstmt.executeQuery();	
							if( rs.next() )
							{
								balanceAmt = rs.getDouble(1);
							}
							rs.close();rs = null;
							pstmt.close();pstmt = null;
						}
						else
						{
							//loan tab disable
						}

						sql = "select relieve_date,pay_site,cadre,grade " 
								+" from employee where emp_code = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, empCode );						
						rs = pstmt.executeQuery();	
						if( rs.next() )
						{
							relieveDate = rs.getTimestamp("relieve_date");
							paySite = checkNull(rs.getString("pay_site"));
							cadre = checkNull(rs.getString("cadre"));
							grade = checkNull(rs.getString("grade"));
						}
						rs.close();rs = null;
						pstmt.close();pstmt = null;

						String envName = adCode.trim().toUpperCase()+"_CLAIMCURRPRD";
						System.out.println("envName="+envName);
						//ls_can_claim_in_sameyear = gf_get_admenv(ls_site , ls_cadre , ls_grade , & 
						//	ls_env_name , ld_claim)
						String canClaimInsameYear = admCommon.getAdmEnv(paySite, cadre, grade, envName, relieveDate, conn);
						System.out.println("canClaimInsameYear="+canClaimInsameYear);

						if("NULLFOUND".equalsIgnoreCase(canClaimInsameYear))
						{
							canClaimInsameYear = admCommon.getEnv("999999", envName, conn);
							System.out.println("canClaimInsameYear="+canClaimInsameYear);
							if("NULLFOUND".equalsIgnoreCase(canClaimInsameYear))
							{
								errList.add( "VSENVAR1" );
								errFields.add( childNodeName.toLowerCase() );
								//ls_errcode = 'VSENVAR1~t Variable (" + ls_env_name + ") is not defined properly'
							}
						}
						//else if() elseif left(ls_can_claim_in_sameyear , 4) = "ERR~t" then
						//{
							//ls_errcode = mid(ls_can_claim_in_sameyear , 5) + &
								//	'Could not fetch environment (' + ls_env_name + ') from site_env table'
						//}
					}*/


				}// for loop end
			}//case 1 end
			break;
			case 2 :
			{
				System.out.println("Case 2 Validation");
				NodeList parentNodeList = null;
				Node parentNode = null;
				int parentNodeListLength = 0;
				double claimAmount = 0,balAmount = 0;
				// Modified by Piyush on 02/04/2015.Start
				ArrayList startDateList = new ArrayList();
				ArrayList balAmtList = new ArrayList();
				ArrayList claimAmtList = new ArrayList();
				java.util.Date startDate = null; 
				java.util.Date maxStartDate = null; 
				
				int recNo = 0;
				// Modified by Piyush on 02/04/2015.End

				parentNodeList = allDom.getElementsByTagName("Detail2");
				parentNodeListLength = parentNodeList.getLength();
				System.out.println("Detail2 length = "+parentNodeListLength);
				if(parentNodeListLength < 1)
				{
					errList.add( "VTNOSEL" );
					errFields.add( " " );
				}
				else
				{
					fullAmt =  checkNull(genericUtility.getColumnValue("full_amt", hdrDom));
					for(int ctr = 0; ctr < parentNodeListLength ; ctr++ )
					{
						System.out.println("TEST LENGTH="+parentNodeListLength);
						parentNode = parentNodeList.item(ctr);
						//Element  parentNode1 = (Element)parentNodeList.item(ctr);
						//claimAmount = Double.parseDouble(genericUtility.getColumnValue("claim_amt", dom, "2")== null?"0":genericUtility.getColumnValue("claim_amt", dom, "2"));
						claimAmount = Double.parseDouble(genericUtility.getColumnValueFromNode( "claim_amt", parentNodeList.item(ctr) )== null?"0":genericUtility.getColumnValueFromNode( "claim_amt", parentNodeList.item(ctr) ));
						balAmount = Double.parseDouble(genericUtility.getColumnValueFromNode( "amt_bal", parentNodeList.item(ctr) )== null?"0":genericUtility.getColumnValueFromNode( "amt_bal", parentNodeList.item(ctr) ));
						//balAmount = Double.parseDouble(genericUtility.getColumnValue("amt_bal", dom, "2")== null?"0":genericUtility.getColumnValue("amt_bal", dom, "2"));
						System.out.println("Full amy=="+fullAmt+"   "+balAmount+"   "+claimAmount);
						if("Y".equalsIgnoreCase(fullAmt))
						{
							if(balAmount != claimAmount)
							{
								errList.add( "VTPERK1" );
								errFields.add( "claim_amt" );
							}
						}
						else
						{
							if(claimAmount > balAmount)
							{
								errList.add( "VMADJAMT2" );
								errFields.add( "claim_amt" );
							}
						}
						// Modified by Piyush on 02/04/2015[For not allow skipping of claim].Start
						// Modified by Piyush on 12/02/2016 [To check skipped claim]
						// startDate =  simpleDateFormat.parse(genericUtility.getColumnValue("start_date", currDom));
						startDate =  simpleDateFormat.parse(genericUtility.getColumnValueFromNode( "start_date", parentNodeList.item(ctr) ));
						if (ctr == 0 || startDate.compareTo(maxStartDate) > 0)
						{
							maxStartDate = startDate;
						}
						startDateList.add(new Timestamp(startDate.getTime()));
						balAmtList.add(balAmount - claimAmount);
						// Modified by Piyush on 02/04/2015[For not allow skipping of claim].End

					}
					// Modified by Piyush on 02/04/2015[For not allow skipping of claim].Start
					String empCode1 = checkNull(genericUtility.getColumnValue("emp_code",hdrDom));
					String adCode1 = checkNull(genericUtility.getColumnValue("ad_code",hdrDom));
					Timestamp claimDate1 =  new Timestamp((simpleDateFormat.parse(genericUtility.getColumnValue("claim_date", hdrDom))).getTime());
					boolean isSkipped = checkSkipping(empCode1 , adCode1 , claimDate1 , startDateList , new Timestamp(maxStartDate.getTime()), balAmtList , conn);
					if (isSkipped)
					{
						errList.add( "VTPERK1" );
						errFields.add( "claim_amt" );
					}
					// Modified by Piyush on 02/04/2015[For not allow skipping of claim].End

				}

			// for loop end
			}//case 2 end
			break;
			case 3:
			{
				System.out.println("Case 3 Validation");
				childList = parentList.item( 0 ).getChildNodes();
				noOfChilds = childList.getLength();
				for ( int ctr = 0; ctr < noOfChilds; ctr++ )  //Loop for each node of current detail
				{	
					childNode = childList.item( ctr );
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
					if( "xyz".equalsIgnoreCase( childNodeName ) )
					{


					}//End of case "loc_code__to"

				}//End of inner for loop

			}//case3 end
			} //switch end
			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = (String)errList.get(cnt);
					errFldName = (String)errFields.get(cnt);
					System.out.println("errCode .........."+errCode);
					//String errMsg = hashMap.get(errCode)!=null ? hashMap.get(errCode).toString():"";
					//System.out.println("errMsg .........."+errMsg);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString;//+"<trace>"+errMsg+"</trace>";
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;

				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			errString = errStringXml.toString();
		}//try block end
		catch(Exception e)
		{
			// Modified by Piyush on 12/02/2016 [Spel correction]
			// System.out.println("Exception in PerlClaimIc  == >");
			System.out.println("Exception in PerkClaimIc  == >");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
				}
			}
			catch(Exception e)
			{
				// Modified by Piyush on 12/02/2016 [Spel correction]
				// System.out.println( "Exception :PerlClaimIc:wfValData :==>\n"+e.getMessage());
				System.out.println( "Exception :PerkClaimIc:wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return errString;
	}
	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";

			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}


	/**
	 * The public method is used for converting the current form data into a document(dom)
	 * The currDom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param currFrmXmlStr contains the current form data in XML format
	 * @param hdrFrmXmlStr contains all the header information in the XML format
	 * @param allFrmXmlStr contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param currentColumn represents the value of current field.
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	public String itemChanged(String currFrmXmlStr, String hdrFrmXmlStr, String allFrmXmlStr, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;

		String errString = null;
		System.out.println("currFrmXmlStr::"+currFrmXmlStr);
		System.out.println("hdrFrmXmlStr::"+hdrFrmXmlStr);
		System.out.println("allFrmXmlStr::"+allFrmXmlStr);

		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			if (currFrmXmlStr != null && currFrmXmlStr.trim().length()!=0)
			{
				currDom = genericUtility.parseString(currFrmXmlStr); 
			}
			if (hdrFrmXmlStr != null && hdrFrmXmlStr.trim().length()!=0)
			{
				hdrDom = genericUtility.parseString(hdrFrmXmlStr); 
			}
			if (allFrmXmlStr != null && allFrmXmlStr.trim().length()!=0)
			{
				allDom = genericUtility.parseString(allFrmXmlStr); 
			}
			errString = itemChanged( currDom, hdrDom, allDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			// Modified by Piyush on 12/02/2016 [Spel correction]
			// System.out.println ( "Exception : PerlClaimIc:defaul_ItemChanged(String,String):" + e.getMessage() + ":" );
			System.out.println ( "Exception : PerkClaimIc:defaul_ItemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		// Modified by Piyush on 12/02/2016 [Spel correction]
		// System.out.println ( "returning from PerlClaimIc default_Itemchanged" );
		System.out.println ( "returning from PerkClaimIc default_Itemchanged" );
		return errString;
	}	

	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currDom contains the current form data as a document object model
	 * @param hdrDom contains all the header information
	 * @param allDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param currentColumn represents the current field 
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information
	 * 
	 */
	public String itemChanged( Document currDom, Document hdrDom, Document allDom, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		String retValue = "";
		try
		{
			retValue = default_ItemChanged( currDom, hdrDom, allDom,  objContext, currentColumn, editFlag, xtraParams );
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retValue;

	}
	public String default_ItemChanged( Document currDom, Document hdrDom, Document allDom, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		String sql = "";
		String empCode = "", adCode = "" , adjLoan = "" ,paySite = "" ,cadre = "" ,grade = "",descr = "";
		String adDescr = "", payMode = "", bankCode = "", payrollVoucher = "", payrollPrd = "";
		String fullAmt = "" ,fName = "",lName = "";
		String loanRefNo = "", loanAdCode = "", schemeNo = "";
		String loanNo = "";
		int currentFormNo = 0;
		int domID = 0;	
		int count = 0;
		double  balanceAmt = 0 , claimAmount = 0,amount = 0 ,balAmount = 0;
		double loanAdjPerc = 0,loanBalAmt = 0, loanMonInst = 0, loanInterest = 0, loanAmt = 0;
		java.util.Date claimDate = null,startDate = null , endDate = null ;
		Timestamp  relieveDate = null;
		NodeList parentNodeList = null;
		Node parentNode = null;
		int parentNodeListLength = 0;
		ResultSet rs = null,rs1 = null;
		Connection conn = null;
		PreparedStatement pstmt = null,pstmt1 = null;
		StringBuffer valueXmlString = new StringBuffer();		
		
		//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][Start]
		String amount1 ="";
		String balAmount1 ="";
		String claimAmount1 = "";
		String balanceAmt1 = "";
		String loanAdjPerc1 = "";
		String loanAmt1 = "";
		String loanBalAmt1 = "";
		String loanMonInst1 = "";
		String loanInterest1 = "";
		//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][End]
		
		GenericUtility genericUtility = GenericUtility.getInstance();
		AdmCommon admCommon = new AdmCommon();
		try
		{
			//String dbDateFormat = genericUtility.getDBDateFormat();
			String applDateFormat = genericUtility.getApplDateFormat();
			SimpleDateFormat sdf = new SimpleDateFormat(applDateFormat);

			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][Start]
			 DecimalFormat df = new DecimalFormat("0.00"); 
			//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][End]
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag>\r\n</Header>\r\n" );

			switch ( currentFormNo )
			{
			case 1:
			{
				System.out.println("case 1 IC...");
				//valueXmlString.append( "<Detail1 domID='1'>\r\n" );
				valueXmlString.append( "<Detail1 domID='1' selected=\"Y\">\r\n" );
				valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n");
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )							
				{	
					valueXmlString.append("<claim_date><![CDATA["+ sdf.format(new java.util.Date()).toString() +"]]></claim_date>");
				}
				else if( currentColumn.trim().equalsIgnoreCase( "emp_code" ) )
				{
					empCode = checkNull(genericUtility.getColumnValue("emp_code",currDom));
					valueXmlString.append( "<emp_code><![CDATA[" ).append( empCode ).append( "]]></emp_code>\r\n" );
					empCode = checkNull(genericUtility.getColumnValue("claim_date",currDom));
					valueXmlString.append( "<claim_date><![CDATA[" ).append( empCode ).append( "]]></claim_date>\r\n" );
					adCode = checkNull(genericUtility.getColumnValue("ad_code",currDom));
					valueXmlString.append( "<ad_code><![CDATA[" ).append( adCode ).append( "]]></ad_code>\r\n" );
					adjLoan= checkNull(genericUtility.getColumnValue("adjust_loan",currDom));
					valueXmlString.append( "<adjust_loan><![CDATA[" ).append( adjLoan ).append( "]]></adjust_loan>\r\n" );
					fullAmt = checkNull(genericUtility.getColumnValue("full_amt",currDom));
					valueXmlString.append( "<full_amt><![CDATA[" ).append( fullAmt ).append( "]]></full_amt>\r\n" );
					payrollVoucher = checkNull(genericUtility.getColumnValue("payroll_voucher",currDom));
					valueXmlString.append( "<payroll_voucher><![CDATA[" ).append( payrollVoucher ).append( "]]></payroll_voucher>\r\n" );
					payrollPrd = checkNull(genericUtility.getColumnValue("payroll_prd",currDom));
					valueXmlString.append( "<payroll_prd><![CDATA[" ).append( payrollPrd ).append( "]]></payroll_prd>\r\n" );
					bankCode = checkNull(genericUtility.getColumnValue("bank_code",currDom));
					valueXmlString.append( "<bank_code><![CDATA[" ).append( bankCode ).append( "]]></bank_code>\r\n" );
					payMode = checkNull(genericUtility.getColumnValue("pay_mode",currDom));
					valueXmlString.append( "<pay_mode><![CDATA[" ).append( payMode ).append( "]]></pay_mode>\r\n" );
					adDescr = checkNull(genericUtility.getColumnValue("ad_descr",currDom));
					valueXmlString.append( "<ad_descr><![CDATA[" ).append( adDescr ).append( "]]></ad_descr>\r\n" );
					
					descr = "";
					empCode = genericUtility.getColumnValue("emp_code",currDom);
					// Modify by Piyush on 02/04/2015 [To show employee's first and last name as per ITM].Start
					/*
					sql = " select emp_fname from employee where emp_code = ? ";
					System.out.println("empCode ="+empCode);
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						descr = checkNull(rs.getString("emp_fname"));
					}
					*/
					String empFname = "";
					String empLname = "";
					sql = "SELECT EMP_FNAME , EMP_LNAME FROM EMPLOYEE WHERE EMP_CODE = ? ";
					System.out.println("empCode ="+empCode);
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						empFname = checkNull(rs.getString("EMP_FNAME"));
						empLname = checkNull(rs.getString("EMP_LNAME"));
					}
					descr = (empFname.trim() + " " + empLname.trim()).trim();
					// Modify by Piyush on 02/04/2015 [To show employee's first and last name as per ITM].End
					rs.close();rs = null;
					pstmt.close();pstmt = null;
					
					valueXmlString.append( "<emp_name><![CDATA[" ).append( descr ).append( "]]></emp_name>\r\n" );
				}
				else if( currentColumn.trim().equalsIgnoreCase( "ad_code" ) )
				{
					empCode = checkNull(genericUtility.getColumnValue("emp_code",currDom));
					valueXmlString.append( "<emp_code><![CDATA[" ).append( empCode ).append( "]]></emp_code>\r\n" );
					empCode = checkNull(genericUtility.getColumnValue("claim_date",currDom));
					valueXmlString.append( "<claim_date><![CDATA[" ).append( empCode ).append( "]]></claim_date>\r\n" );
					adCode = checkNull(genericUtility.getColumnValue("ad_code",currDom));
					valueXmlString.append( "<ad_code><![CDATA[" ).append( adCode ).append( "]]></ad_code>\r\n" );
					adjLoan= checkNull(genericUtility.getColumnValue("adjust_loan",currDom));
					valueXmlString.append( "<adjust_loan><![CDATA[" ).append( adjLoan ).append( "]]></adjust_loan>\r\n" );
					fullAmt = checkNull(genericUtility.getColumnValue("full_amt",currDom));
					valueXmlString.append( "<full_amt><![CDATA[" ).append( fullAmt ).append( "]]></full_amt>\r\n" );
					payrollVoucher = checkNull(genericUtility.getColumnValue("payroll_voucher",currDom));
					valueXmlString.append( "<payroll_voucher><![CDATA[" ).append( payrollVoucher ).append( "]]></payroll_voucher>\r\n" );
					payrollPrd = checkNull(genericUtility.getColumnValue("payroll_prd",currDom));
					valueXmlString.append( "<payroll_prd><![CDATA[" ).append( payrollPrd ).append( "]]></payroll_prd>\r\n" );
					bankCode = checkNull(genericUtility.getColumnValue("bank_code",currDom));
					valueXmlString.append( "<bank_code><![CDATA[" ).append( bankCode ).append( "]]></bank_code>\r\n" );
					payMode = checkNull(genericUtility.getColumnValue("pay_mode",currDom));
					valueXmlString.append( "<pay_mode><![CDATA[" ).append( payMode ).append( "]]></pay_mode>\r\n" );
					descr = checkNull(genericUtility.getColumnValue("emp_name",currDom));
					valueXmlString.append( "<emp_name><![CDATA[" ).append( descr ).append( "]]></emp_name>\r\n" );
					
					adDescr = "";
					adCode = genericUtility.getColumnValue("ad_code",currDom);
					sql = " select descr from allwdedn where ad_code = ? ";
					System.out.println("adCode ="+adCode);
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, adCode);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						adDescr = checkNull(rs.getString("descr"));
					}
					rs.close();rs = null;
					pstmt.close();pstmt = null;
					valueXmlString.append( "<ad_descr><![CDATA[" ).append( adDescr ).append( "]]></ad_descr>\r\n" );
				}//end ad_code
				else if( currentColumn.trim().equalsIgnoreCase( "payroll_voucher" ) )
				{
					empCode = checkNull(genericUtility.getColumnValue("emp_code",currDom));
					valueXmlString.append( "<emp_code><![CDATA[" ).append( empCode ).append( "]]></emp_code>\r\n" );
					empCode = checkNull(genericUtility.getColumnValue("claim_date",currDom));
					valueXmlString.append( "<claim_date><![CDATA[" ).append( empCode ).append( "]]></claim_date>\r\n" );
					adCode = checkNull(genericUtility.getColumnValue("ad_code",currDom));
					valueXmlString.append( "<ad_code><![CDATA[" ).append( adCode ).append( "]]></ad_code>\r\n" );
					adjLoan= checkNull(genericUtility.getColumnValue("adjust_loan",currDom));
					valueXmlString.append( "<adjust_loan><![CDATA[" ).append( adjLoan ).append( "]]></adjust_loan>\r\n" );
					fullAmt = checkNull(genericUtility.getColumnValue("full_amt",currDom));
					valueXmlString.append( "<full_amt><![CDATA[" ).append( fullAmt ).append( "]]></full_amt>\r\n" );
					
					
					bankCode = checkNull(genericUtility.getColumnValue("bank_code",currDom));
					valueXmlString.append( "<bank_code><![CDATA[" ).append( bankCode ).append( "]]></bank_code>\r\n" );
					payMode = checkNull(genericUtility.getColumnValue("pay_mode",currDom));
					valueXmlString.append( "<pay_mode><![CDATA[" ).append( payMode ).append( "]]></pay_mode>\r\n" );
					descr = checkNull(genericUtility.getColumnValue("emp_name",currDom));
					valueXmlString.append( "<emp_name><![CDATA[" ).append( descr ).append( "]]></emp_name>\r\n" );
					
					adDescr = "";
					adCode = genericUtility.getColumnValue("ad_code",currDom);
					sql = " select descr from allwdedn where ad_code = ? ";
					System.out.println("adCode ="+adCode);
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, adCode);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						adDescr = checkNull(rs.getString("descr"));
					}
					rs.close();rs = null;
					pstmt.close();pstmt = null;
					valueXmlString.append( "<ad_descr><![CDATA[" ).append( adDescr ).append( "]]></ad_descr>\r\n" );
					
					payrollVoucher = checkNull(genericUtility.getColumnValue("payroll_voucher",currDom));
					payrollPrd = checkNull(genericUtility.getColumnValue("payroll_prd",currDom));
					
					if("V".equalsIgnoreCase(payrollVoucher))
					{
						valueXmlString.append( "<payroll_prd protect = '1'><![CDATA[" ).append( "" ).append( "]]></payroll_prd>\r\n" );
					}
					else
					{
						valueXmlString.append( "<payroll_prd protect = '0'><![CDATA[" ).append( payrollPrd ).append( "]]></payroll_prd>\r\n" );
					}
					valueXmlString.append( "<payroll_voucher><![CDATA[" ).append( payrollVoucher ).append( "]]></payroll_voucher>\r\n" );
					
				}//end payroll_voucher
				valueXmlString.append("</Detail1>\r\n");
			}//case 1 end here
			break;
			case 2:
			{
				System.out.println("case 2 IC...");
				//valueXmlString.append( "<Detail2 domID='1'>\r\n" );
				
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )							
				{	
					empCode = checkNull(genericUtility.getColumnValue("emp_code",hdrDom));
					adCode = checkNull(genericUtility.getColumnValue("ad_code",hdrDom));
					fullAmt = checkNull(genericUtility.getColumnValue("full_amt",hdrDom)) ; 
					adjLoan = checkNull(genericUtility.getColumnValue("adjust_loan",hdrDom));
					System.out.println("empCode="+empCode);
					System.out.println("adCode="+adCode);
					System.out.println("fullAmt="+fullAmt);
					System.out.println("adjLoan="+adjLoan);
					if(genericUtility.getColumnValue("claim_date", hdrDom) == null)
					{
						claimDate = null;
					}
					else
					{
						claimDate =  sdf.parse(genericUtility.getColumnValue("claim_date", hdrDom));
					}
					System.out.println("claimDate="+claimDate);
					if("Y".equalsIgnoreCase(adjLoan))
					{
						//loan tab enable
						sql = "select sum(balance_amt) 	from allowdedn_bal,loans where ref_no = loan_no "
								+" and allowdedn_bal.emp_code = ?  and ad_code between '0' and 'z' and amt_bal > 0 	and ref_type = 'L' 	and adjustable = 'Y'";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, empCode );						
						rs = pstmt.executeQuery();	
						if( rs.next() )
						{
							balanceAmt = rs.getDouble(1);
						}
						rs.close();rs = null;
						pstmt.close();pstmt = null;
					}
					else
					{
						//loan tab diable
						System.out.println("loan tab diable");
					}

					sql = "select relieve_date,pay_site,cadre,grade " 
							+" from employee where emp_code = ? ";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, empCode );						
					rs = pstmt.executeQuery();	
					if( rs.next() )
					{
						relieveDate = rs.getTimestamp("relieve_date");
						paySite = checkNull(rs.getString("pay_site"));
						cadre = checkNull(rs.getString("cadre"));
						grade = checkNull(rs.getString("grade"));
					}
					rs.close();rs = null;
					pstmt.close();pstmt = null;

					String envName = adCode.trim().toUpperCase()+"_CLAIMCURRPRD";
					//ls_can_claim_in_sameyear = gf_get_admenv(ls_site , ls_cadre , ls_grade , & 
					//	ls_env_name , ld_claim)
					String canClaimInsameYear = admCommon.getAdmEnv(paySite, cadre, grade, envName, relieveDate, conn);
					/*
					if ls_can_claim_in_sameyear = "ERR~t<NULLFOUND>" then
							ls_can_claim_in_sameyear = gf_getenv('999999', ls_env_name) 
							if ls_can_claim_in_sameyear = "NULLFOUND" then
								ls_errcode = 'VSENVAR1~t Variable (" + ls_env_name + ") is not defined properly'
								exit
							end if
						elseif left(ls_can_claim_in_sameyear , 4) = "ERR~t" then
							ls_errcode = mid(ls_can_claim_in_sameyear , 5) + &
								'Could not fetch environment (' + ls_env_name + ') from site_env table' 
							exit
						end if
					 */
					if("NULLFOUND".equalsIgnoreCase(canClaimInsameYear))
					{
						canClaimInsameYear = admCommon.getEnv("999999", envName, conn);
						if("NULLFOUND".equalsIgnoreCase(canClaimInsameYear))
						{
							//ls_errcode = 'VSENVAR1~t Variable (" + ls_env_name + ") is not defined properly'
						}
					}
					/*else if() elseif left(ls_can_claim_in_sameyear , 4) = "ERR~t" then
					{
						ls_errcode = mid(ls_can_claim_in_sameyear , 5) + &
								'Could not fetch environment (' + ls_env_name + ') from site_env table'
					}*/
					/*
					if("Y".equalsIgnoreCase(fullAmt))
					{
						valueXmlString.append( "<claim_amt protect ='1'><![CDATA[" ).append( checkNull( "" )).append( "]]></claim_amt>\r\n" );
					}
					else
					{
						valueXmlString.append( "<claim_amt protect ='0'><![CDATA[" ).append( checkNull( "" )).append( "]]></claim_amt>\r\n" );
					}
					*/
					/*
					ls_can_claim_in_sameyear = upper(trim(ls_can_claim_in_sameyear))
							if ls_can_claim_in_sameyear <> 'Y' then ls_can_claim_in_sameyear = 'N'
							if not isnull(ld_relieve) then ls_can_claim_in_sameyear = 'Y'
							ll_rows = dw_claim.retrieve(ls_emp, ls_ad_code, ld_claim , ls_can_claim_in_sameyear )

							if ll_rows = 1 then
								dw_claim.selectrow(1, true)
							end if
					 */
					canClaimInsameYear = canClaimInsameYear.trim().toUpperCase();
					if(!"Y".equals(canClaimInsameYear))
					{
						canClaimInsameYear = "N";
					}
					if(relieveDate != null)
					{
						canClaimInsameYear = "Y";
					}

					sql =  " SELECT allowdedn_bal.emp_code, employee.emp_fname, employee.emp_lname, allowdedn_bal.ad_code, allowdedn_bal.start_date, allowdedn_bal.end_date, "    
							+" allowdedn_bal.amount, allowdedn_bal.amt_bal, amt_bal claim_amt   FROM allowdedn_bal, employee "  
							+" WHERE ( allowdedn_bal.emp_code = employee.emp_code ) and   ( allowdedn_bal.emp_code = ? ) AND  ( allowdedn_bal.ad_code = ? ) AND "
							+" ( allowdedn_bal.amt_bal <> 0 ) AND  ( allowdedn_bal.ref_type = 'K' ) AND    ( decode(?,'Y',allowdedn_bal.start_date,allowdedn_bal.end_date)  < ? ) AND "
							+" (allowdedn_bal.exp_date is null OR   allowdedn_bal.exp_date >= ? )   ORDER BY allowdedn_bal.start_date ASC   ";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, empCode );
					pstmt.setString( 2, adCode );
					pstmt.setString( 3, canClaimInsameYear );
					pstmt.setDate( 4,new java.sql.Date(claimDate.getTime()));
					pstmt.setDate( 5, new java.sql.Date(claimDate.getTime()));
					rs = pstmt.executeQuery();	
					while( rs.next() )
					{
						empCode = checkNull(rs.getString("emp_code"));
						fName = checkNull(rs.getString("emp_fname"));
						lName = checkNull(rs.getString("emp_lname"));
						adCode = checkNull(rs.getString("ad_code"));
						startDate = rs.getDate("start_date");
						endDate = rs.getDate("end_date");
						amount = rs.getDouble("amount");
						balAmount = rs.getDouble("amt_bal");
						claimAmount = rs.getDouble("claim_amt");

						//relieveDate = rs.getTimestamp("relieve_date");
						//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][Start]
						amount1 = df.format(amount);
						System.out.println("amount1....["+amount1+"]");
						
						balAmount1 = df.format(balAmount);
						System.out.println("balAmount....["+balAmount+"]");
						
						claimAmount1 = df.format(claimAmount);
						System.out.println("claimAmount1....["+claimAmount1+"]");
						//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][End]
						domID++;

						valueXmlString.append( "<Detail2 domID='"+ domID +"'  selected=\"N\">\r\n" );
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\"  status=\"N\" pkNames=\"\" />\r\n");
						valueXmlString.append( "<emp_code><![CDATA[" ).append(  empCode ).append( "]]></emp_code>\r\n" );
						valueXmlString.append( "<emp_fname><![CDATA[" ).append( fName).append( "]]></emp_fname>\r\n" );
						valueXmlString.append( "<emp_lname><![CDATA[" ).append(  lName).append( "]]></emp_lname>\r\n" );
						//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][Start]
						// valueXmlString.append( "<amount><![CDATA[" ).append( amount).append( "]]></amount>\r\n" );
						// valueXmlString.append( "<amt_bal><![CDATA[" ).append( balAmount).append( "]]></amt_bal>\r\n" );
						valueXmlString.append( "<amount><![CDATA[" ).append(amount1).append( "]]></amount>\r\n" );
						valueXmlString.append( "<amt_bal><![CDATA[" ).append(balAmount1).append( "]]></amt_bal>\r\n" );
						if("Y".equalsIgnoreCase(fullAmt))
						{
							// valueXmlString.append( "<claim_amt protect ='1'><![CDATA[" ).append( claimAmount).append( "]]></claim_amt>\r\n" );
							valueXmlString.append( "<claim_amt protect ='1'><![CDATA[" ).append(claimAmount1).append( "]]></claim_amt>\r\n" );
						}
						else
						{
							// valueXmlString.append( "<claim_amt protect ='0'><![CDATA[" ).append( claimAmount).append( "]]></claim_amt>\r\n" );
							valueXmlString.append( "<claim_amt protect ='0'><![CDATA[" ).append(claimAmount1).append( "]]></claim_amt>\r\n" );
						}
						//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][End]
						valueXmlString.append( "<start_date><![CDATA[" ).append( sdf.format(startDate)).append( "]]></start_date>\r\n" );
						valueXmlString.append( "<end_date><![CDATA[" ).append( sdf.format(endDate)).append( "]]></end_date>\r\n" );
						// Modified By Hemlata [19/05/2015][To protect un protect claim amount in xsl][Start]
						valueXmlString.append( "<full_amt><![CDATA[" ).append(fullAmt).append( "]]></full_amt>\r\n" );
						// Modified By Hemlata [19/05/2015][To protect un protect claim amount in xsl][End]
						valueXmlString.append("</Detail2>\r\n");
					}
					rs.close();rs = null;
					pstmt.close();pstmt = null;


				}

			}//case 2 end here
			break;
			case 3:
			{
				System.out.println("case 3 IC...");
				domID = 0;
				double temp = 0;
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )							
				{

					// Modified by Piyush on 12/02/2016 [To validate the previous date pending claim from 3rd form before itm_default of 3rd form].Start
					String wfValDataReturnStr = wfValData(currDom,hdrDom,allDom,"2",editFlag,xtraParams);
					if (wfValDataReturnStr != null && wfValDataReturnStr.trim().length() > 0)
					{
						return wfValDataReturnStr;
					}
					// Modified by Piyush on 12/02/2016 [To validate the previous date pending claim from 3rd form before itm_default of 3rd form].Start

					//lpnNo = checkNull(genericUtility.getColumnValue("lpn_no", allDom, "2"));
					adjLoan = checkNull(genericUtility.getColumnValue("adjust_loan",hdrDom));
					System.out.println("adjLoan"+adjLoan);
					if("Y".equalsIgnoreCase(adjLoan))
					{
						empCode = checkNull(genericUtility.getColumnValue("emp_code",hdrDom));
						adCode = checkNull(genericUtility.getColumnValue("ad_code",hdrDom));
						if(genericUtility.getColumnValue("claim_date", hdrDom) == null)
						{
							claimDate = null;
						}
						else
						{
							claimDate =  sdf.parse(genericUtility.getColumnValue("claim_date", hdrDom));
						}
						parentNodeList = allDom.getElementsByTagName("Detail2");
						parentNodeListLength = parentNodeList.getLength();
						double claimTotalAmt = 0.0; 
						int case1 = 0;
						int case2 = 0;
						System.out.println("DETAIL2 TEST LENGTH="+parentNodeListLength);
						// Modified by Piyush on 02/04/2015[To validate in case of no row selected in 2nd form].Start
						if (parentNodeListLength <= 0)
						{
							String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
							String errString = getErrorString( "", "VTNOSEL", userId );
							return errString;
						}
						// Modified by Piyush on 02/04/2015[To validate in case of no row selected in 2nd form].End
						
						//Modified By Hemlata on[25/05/2015][To calculate detail2's claim amount and Formate values in two decimal point][Start]
						
						/*	for(int ctr = 0; ctr < parentNodeListLength ; ctr++ )
								{
									
									parentNode = parentNodeList.item(ctr);
									Element  parentNode1 = (Element)parentNodeList.item(ctr);
									//String selected = parentNode1.getAttribute("selected");//change by Kunal on 31/08/12
								
											System.out.println("Claim amt="+genericUtility.getColumnValue("claim_amt", allDom, "2"));
											claimAmount = Double.parseDouble(genericUtility.getColumnValue("claim_amt", allDom, "2")== null?"0":genericUtility.getColumnValue("claim_amt", allDom, "2"));
											//System.out.println("Claim amt="+columnValue);
											//	claimAmount = Double.parseDouble(columnValue== null?"0":columnValue);
											System.out.println("claimAmount="+claimAmount);
											claimTotalAmt = claimTotalAmt + claimAmount;
									//	}
								//	}
								}*/
		
						claimTotalAmt = getSelectedRowValue(allDom,"2","claim_amt",0);
						System.out.println(" totalAmt of selected rows of detail2:::::: "+ claimTotalAmt);
						
						System.out.println("claimTotalAmount="+claimTotalAmt);
						balanceAmt = claimTotalAmt ;
						
						/*balanceAmt1 = df.format(balanceAmt);
						System.out.println(" balanceAmt1. Formatting...["+balanceAmt1+"]");
						
						balanceAmt = Double.parseDouble(balanceAmt1);
						System.out.println(" balanceAmt After Formatting....["+balanceAmt+"]");*/
						//Modified By Hemlata on[25/05/2015][To calculate detail2's claim amount and Formate values in two decimal point][End]

						sql = "select loan_no from 	loans where emp_code = ? and "
								+" loans.balance_amt > 0  and loans.adjustable = 'Y' and status ='A' ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, empCode );						
						rs = pstmt.executeQuery();	
						if(rs == null)
						{
							valueXmlString.append( "<Detail3 domID='1' selected=\"N\">n</Detail3>" );
						}
						while( rs.next() )
						{
							loanNo = checkNull(rs.getString("loan_no"));

							sql = "select count(*)   from loan_adj 	where loan_no = ? ";
							pstmt1 = conn.prepareStatement( sql );
							pstmt1.setString( 1,loanNo );						
							rs1 = pstmt1.executeQuery();	
							if( rs1.next() )
							{
								count = rs1.getInt(1);
							}
							rs1.close();rs1 = null;
							pstmt1.close();pstmt1 = null;

							if(count > 0)
							{
								sql = " Select allowdedn_bal.ad_code, loan_adj.adj_perc, allowdedn_bal.ref_no,	allowdedn_bal.start_date, allowdedn_bal.end_date, " 
										+" loans.scheme_no, loans.loan_amt, loans.balance_amt,		loans.mon_inst,loans.interest "
										+" from allowdedn_bal,loans,loan_adj			where (allowdedn_bal.ref_no = loans.loan_no) "
										+" and (loans.loan_no = loan_adj.loan_no)		and (allowdedn_bal.ref_no = ? ) "
										+" and (loan_adj.ad_code = ? )  	and (allowdedn_bal.ad_code between '0' and 'Z') "
										+" and  ( ?  between loan_adj.eff_date and loan_adj.exp_date) 		and (allowdedn_bal.amt_bal > 0) "
										+" and (allowdedn_bal.ref_type = 'L') 	and (loans.adjustable = 'Y') 	Order by end_date ";
								pstmt1 = conn.prepareStatement( sql );
								pstmt1.setString( 1,loanNo );						
								pstmt1.setString( 2,adCode );
								pstmt1.setDate( 3,new java.sql.Date(claimDate.getTime()) );
								case1++;
							}
							else
							{
								sql = " Select ad_code, adj_perc, ref_no, start_date, end_date, "
										+" scheme_no, loan_amt, balance_amt, mon_inst, interest "
										+" from allowdedn_bal,loans Where ref_no = loan_no and allowdedn_bal.ref_no = ? and ad_code between '0' and 'z' "
										+" and amt_bal > 0 	and ref_type = 'L' 		and adjustable = 'Y' 		Order by start_date ";
								pstmt1 = conn.prepareStatement( sql );
								pstmt1.setString( 1,loanNo );						
								case2++;
							}
							rs1 = pstmt1.executeQuery();	
							/*li_xx = 0
								lc_adj = 0*/
							//double adjAmt = 0;
							//double adjAmtTemp = 0;
							while( rs1.next() )
							{
								domID++;
								loanAdCode = rs1.getString("ad_code");
								loanAdjPerc = rs1.getDouble("adj_perc");
								loanRefNo = rs1.getString("ref_no");
								startDate = rs1.getDate("start_date");
								endDate = rs1.getDate("end_date");
								schemeNo = rs1.getString("scheme_no");
								loanAmt = rs1.getDouble("loan_amt");
								loanBalAmt = rs1.getDouble("balance_amt");
								loanMonInst = rs1.getDouble("mon_inst");
								loanInterest = rs1.getDouble("interest");
								//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][Start]			
								loanAdjPerc1 = df.format(loanAdjPerc);
								System.out.println(" loanAdjPerc1 after. Formatting...["+loanAdjPerc1+"]");
								
								loanAmt1 = df.format(loanAmt);
								System.out.println(" loanAmt1 after. Formatting...["+loanAmt1+"]");
								
								loanBalAmt1 = df.format(loanBalAmt);
								System.out.println(" loanBalAmt1 after. Formatting...["+loanBalAmt1+"]");
								
								loanMonInst1 = df.format(loanMonInst);
								System.out.println(" loanMonInst1 after. Formatting...["+loanMonInst1+"]");
								
								loanInterest1 = df.format(loanInterest);
								System.out.println(" loanInterest1 after. Formatting...["+loanInterest1+"]");
								
								//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][End]
								valueXmlString.append( "<Detail3 domID='"+domID+"' selected=\"Y\">\r\n" );  
								valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n"); 
								valueXmlString.append( "<tran_id/>" );
								valueXmlString.append( "<ref_no><![CDATA[" ).append( loanRefNo).append( "]]></ref_no>\r\n" );
								valueXmlString.append( "<ad_code><![CDATA[" ).append( loanAdCode).append( "]]></ad_code>\r\n" );
								valueXmlString.append( "<eff_date><![CDATA[" ).append( sdf.format(startDate)).append( "]]></eff_date>\r\n" );
								//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][Start]
								// valueXmlString.append( "<bal_amt><![CDATA[" ).append(  loanBalAmt).append( "]]></bal_amt>\r\n" );
								 valueXmlString.append( "<bal_amt><![CDATA[" ).append(loanBalAmt1).append( "]]></bal_amt>\r\n" );
								//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][End]
								// double temp;
								
								if(balanceAmt > 0)
								{
									// Modified By Hemlata 
									if(domID == 1)
									{
										temp = (claimTotalAmt * loanAdjPerc) / 100;
										System.out.println("temp in domID 1=="+temp);
									}
									else
									{
										temp = balanceAmt;
										System.out.println("temp in domID != 1==="+temp);
									}
										// Modified By Hemlata 
								//	temp = (claimTotalAmt * loanAdjPerc) / 100;
									if(temp > loanBalAmt)
										temp = loanBalAmt ;
									if(temp >= balanceAmt)
									{
										//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][Start]
									//	valueXmlString.append( "<adj_amt><![CDATA[" ).append(balanceAmt).append( "]]></adj_amt>\r\n" );
										balanceAmt1 = df.format(balanceAmt);
										System.out.println(" balanceAmt1. Formatting...["+balanceAmt1+"]");
										valueXmlString.append( "<adj_amt><![CDATA[" ).append(balanceAmt1).append( "]]></adj_amt>\r\n" );
										//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][End]
										//adjAmtTemp = balanceAmt;
									}
									else
									{
										//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][Start]
										String temp1 = df.format(temp);
										System.out.println(" temp1 after. Formatting...["+temp1+"]");
										// valueXmlString.append( "<adj_amt><![CDATA[" ).append(temp).append( "]]></adj_amt>\r\n" );
										valueXmlString.append( "<adj_amt><![CDATA[" ).append(temp1).append( "]]></adj_amt>\r\n" );
										//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][eND]

										//adjAmtTemp = temp;
									}
									balanceAmt = balanceAmt - temp ;
									System.out.println("balanceAmt"+balanceAmt);
								}								
								else
								{
									valueXmlString.append( "<adj_amt><![CDATA[0.00]]></adj_amt>\r\n" );
									//adjAmtTemp = 0;
								}
								
								valueXmlString.append( "<line_no><![CDATA[" ).append(  domID ).append( "]]></line_no>\r\n" );
								
								valueXmlString.append( "<ref_type><![CDATA[" ).append( "L").append( "]]></ref_type>\r\n" );
								valueXmlString.append( "<scheme_no><![CDATA[" ).append( schemeNo).append( "]]></scheme_no>\r\n" );
								
								valueXmlString.append( "<start_date><![CDATA[" ).append( sdf.format(startDate)).append( "]]></start_date>\r\n" );
								valueXmlString.append( "<end_date><![CDATA[" ).append( sdf.format(endDate)).append( "]]></end_date>\r\n" );
								//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][Start]
								valueXmlString.append( "<loan_amt><![CDATA[" ).append(loanAmt1).append( "]]></loan_amt>\r\n" );
								valueXmlString.append( "<adj_perc><![CDATA[" ).append(loanAdjPerc1).append( "]]></adj_perc>\r\n" );
								valueXmlString.append( "<mon_inst><![CDATA[" ).append(loanMonInst1).append( "]]></mon_inst>\r\n" );
								valueXmlString.append( "<interest><![CDATA[" ).append(loanInterest1).append( "]]></interest>\r\n" );
								
								//MOdified By Hemlata [19/05/2015][To show selected records total claim amount][Start]
								Double totalAmt = getSelectedRowValue(allDom,"2","claim_amt",0);
								System.out.println(" totalAmt of selected rows of detail2:::::: "+ totalAmt);
								String totalAmt1 = df.format(totalAmt);
								System.out.println(" totalAmt1 after. Formatting...["+totalAmt1+"]");
								valueXmlString.append( "<total_amt><![CDATA[" ).append(totalAmt1).append( "]]></total_amt>\r\n" );
								//Modified By Hemlata [19/05/2015][To show selected records total claim amount][End]
								
								//Modified By Hemlata on[25/05/2015][To Formate values in two decimal point][Start]
								
								//							adjAmt = adjAmt + adjAmtTemp;
								//							lc_adj = lc_adj + dw_1.getitemdecimal(ll_row,"adj_amt")
								valueXmlString.append("</Detail3>\r\n");	

							}
							rs1.close();rs1 = null;
							pstmt1.close();pstmt1 = null;

						}
						rs.close();rs = null;
						pstmt.close();pstmt = null;

					}
					else //loan tab disable
					{
						System.out.println("loan tab diable");
						valueXmlString.append( "<Detail3 domID='1' selected=\"N\">n</Detail3>" );
					}
				}
				break;				  		
			}// case 3
			}//switch  end
		}//try block end
		catch(Exception e)
		{
			// Modified by Piyush on 12/02/2016 [Spel correction]
			// System.out.println( "Exception :PerlClaimIc :default_ItemChanged(Document,String):" + e.getMessage() + ":" );
			System.out.println( "Exception :PerkClaimIc :default_ItemChanged(Document,String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				// Modified by Piyush on 12/02/2016 [Spel correction]
				// System.out.println( "Exception :PerlClaimIc:default_ItemChanged :==>\n"+e.getMessage());
				System.out.println( "Exception :PerkClaimIc:default_ItemChanged :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );	
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}

	private String checkNull( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal;
	}
	private String getAttribValue(Node detailNode, String nodeName, String attribStr)
	{
		String attribValue = "";
		try
		{
			String domStr = GenericUtility.getInstance().serializeDom(detailNode);
			Document dom = GenericUtility.getInstance().parseString(domStr);
			if( dom != null /*&& dom.getAttributes() != null*/)
			{
				Node attributeNode = dom.getElementsByTagName( nodeName ).item(0);
				attribValue = getAttribValue(attributeNode, attribStr);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}

	private String getAttribValue(Node detailNode, String attribStr)
	{
		String attribValue = "";
		try
		{
			if( detailNode != null && detailNode.getAttributes() != null)
			{
				Node attribNode = detailNode.getAttributes().getNamedItem( attribStr );
				if( attribNode != null )
				{
					attribValue = checkNull( attribNode.getNodeValue() );
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}

	// Modified by Piyush on 02/04/2015[For not allow skipping of claim].Start
	private boolean checkSkipping(String empCode , String adCode , Timestamp claimDate , ArrayList startDateList , Timestamp maxStartDate , ArrayList balAmtList , Connection conn )throws RemoteException,ITMException
	{
		String sql = "";
		Timestamp dbStartDate = null;
		double balAmt = 0d;
		PreparedStatement pst = null;
		ResultSet rs = null;
		Timestamp stDate = null;
		int listSize = 0;
		int sno = 0;
		boolean isSkipped = false;

		try
		{

			System.out.println("startDateList :" + startDateList);

			sql = "SELECT START_DATE FROM ALLOWDEDN_BAL WHERE EMP_CODE = ? AND AD_CODE = ? AND START_DATE < ? AND AMT_BAL > 0 ORDER BY START_DATE ";
			pst = conn.prepareStatement( sql );
			pst.setString(1 , empCode);
			pst.setString(2 , adCode);
			pst.setTimestamp(3 , maxStartDate);
			rs = pst.executeQuery();
			while (rs.next())
			{
				dbStartDate = rs.getTimestamp("START_DATE");
				System.out.println("dbStartDate :" + dbStartDate);
				if (startDateList.contains(dbStartDate))
				{
					sno = startDateList.indexOf(dbStartDate);
					System.out.println("sno in checkSkipping :" + sno);
					if (sno != -1)
					{
						balAmt = ((Double) balAmtList.get(sno)).doubleValue();
						if (balAmt != 0)
						{
							isSkipped = true;
							break;
						}
					}
					else
					{
						isSkipped = true;
						break;
					}
				}
				else
				{
					isSkipped = true;
					break;
				}

			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pst != null)
			{
				pst.close();
				pst = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : checkSkipping :" + e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pst != null)
				{
					pst.close();
					pst = null;
				}
				
			}
			catch(Exception e1)
			{
				System.out.println("Exception : checkSkipping :" + e1.getMessage());
				throw new ITMException(e1);
			}
		}
		return isSkipped;
	}
	// Modified by Piyush on 02/04/2015[For not allow skipping of claim].End
	
	//Modified By Hemlata on [19/05/2015][	To retrieve selected row value of second detail ][Start]
	public Double getSelectedRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null; 
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;
		Double totalAmt = 0d;
		Double totalAmt1 = 0d;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			//Modified by Abhishek on [23/04/2012][To resolve the issue at live server of getting nullpointer exception][Start]
			if (detailList == null || detailList.getLength() == 0)
			{
				return 0d;
			}			
			//Modified by Abhishek on [23/04/2012][To resolve the issue at live server of getting nullpointer exception][End]
			detailListLength = detailList.getLength();
			System.out.println("detailListLength::::"+detailListLength);
		//	parentNode = detailList.item(rowNo);
		//	elementAttr = (Element)parentNode;
			for ( int prtcnt = 0; prtcnt < detailListLength; prtcnt++)
			{
				parentNode = detailList.item(prtcnt);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();	
				System.out.println("noOfChilds::::"+noOfChilds);
			
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{	
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(colName) )
					{							
						if(childNode.getFirstChild()!=null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();	
							break;
						}
					}
				}
				if(columnValue != null && columnValue.trim().length() > 0)
				{
					totalAmt = Double.parseDouble(columnValue);
					System.out.println("totalAmt::"+totalAmt);
				}
				totalAmt1 = totalAmt1 +totalAmt;
				System.out.println("totalAmt1::"+totalAmt1);
			}
			
			if(columnValue == null)
				columnValue = "";
						
		}
		catch( Exception exp )
		{
			exp.printStackTrace();
		}

	return totalAmt1;
	}
	//Modified By Hemlata on [19/05/2015][	To retrieve selected row value of second detail ][End]

}
