/**
* PURPOSE : Pre Save Logic implementation for Picking component.
* AUTHOR : Gulzar on 15/09/11
*/

package ibase.webitm.ejb.wms;

import ibase.webitm.ejb.*;
import ibase.webitm.utility.ITMException;
import ibase.utility.E12GenericUtility;

import java.rmi.RemoteException;
import java.sql.*;

import org.w3c.dom.*;

import javax.ejb.*;

@javax.ejb.Stateless
public class PickIssPrs extends ValidatorEJB //implements PoRcpPrsLocal, PoRcpPrsRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String preSave() throws RemoteException,ITMException
	{
		return "";
	}

	public String preSave(String xmlString, String editFlag, String xtraParams, Connection conn)throws RemoteException,ITMException
	{

		System.out.println("PickIssPrs EJB called");
		Document dom = null;
		try
		{
			System.out.println("xmlString in PickIssPrs : preSaveRec \n"+xmlString);			
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = genericUtility.parseString(xmlString);
				executepreSave( dom, editFlag, xtraParams, conn );
			}			
		}
		catch(Exception e)
		{
			System.out.println("Exception :PickIssPrs :" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return "";
	}

	private String executepreSave( Document dom, String editFlag, String xtraParams, Connection conn ) throws RemoteException, ITMException
	{
		String sql = "";			
		String tranId = "";
		String transMode = "";
		
		int deleteCount = 0;
		
		ResultSet rs = null;
		PreparedStatement pstmt = null;

		try
		{			
			conn.setAutoCommit(false); 
			E12GenericUtility genericUtility = new E12GenericUtility();
			
			tranId = checkNull(genericUtility.getColumnValue( "tran_id", dom, "2" ));
			//transMode = checkNull(genericUtility.getColumnValue( "trans_mode", dom, "1" ));
			
			//if( tranId.trim().length() > 0 && transMode.equalsIgnoreCase("E") )
			if( tranId.trim().length() > 0 )
			{
				sql = "DELETE FROM PICK_ISS_DET WHERE TRAN_ID = ?";	
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				deleteCount = pstmt.executeUpdate();						
				if( deleteCount > 0 )
				{
					System.out.println( "Row with Tran_ID " + tranId + " deleted from PICK_ISS_DET table" );
				}						
				pstmt.close();
				pstmt = null;
				
				sql = "DELETE FROM PICK_ISS_HDR WHERE TRAN_ID = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				deleteCount = pstmt.executeUpdate();						
				if( deleteCount > 0 )
				{
					System.out.println( "Row with Tran_ID " + tranId + " deleted from PICK_ISS_HDR table" );
				}						
				pstmt.close();
				pstmt = null;

			}
		}
		catch (SQLException sqe)
		{
			System.out.println("The SQLException occurs in PickIssPrs :"+sqe);
			sqe.printStackTrace();
			throw new ITMException(sqe);
		}
		catch(Exception e)
		{
			System.out.println("The Exception occurs in PickIssPrs :"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :PickIssPrs :\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return "";
	}
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}		
}
