/**
 * 
 */
package ibase.webitm.bean.appraisal;

import java.util.ArrayList;
import java.util.Properties;

import javax.naming.InitialContext;

import org.w3c.dom.Document;

import ibase.system.config.AppConnectParm;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.PopUpDataAccessLocal;
import ibase.webitm.utility.PopUpProperties;

/**
 * @author base
 *
 */
public class AppraisalSpecBean 
{
	private String apprSpec, apprSpecDetails, apprSpecDescr, autoCalc, calcMethod, methodType, methodInput, sql, sqlInput, 
		formula, calcPattern, specCategory, specType, denominator, valueType, apprSpecParent, ratingType, ratingValues, trackingType, detailXml;
	
	private UserInfoBean userInfoBean;
	
	private E12GenericUtility genericUtility = new E12GenericUtility();

	/**
	 * 
	 */
	public AppraisalSpecBean() 
	{
		
	}

	/**
	 * @return the apprSpec
	 */
	public String getApprSpec() {
		return apprSpec;
	}

	/**
	 * @param apprSpec the apprSpec to set
	 */
	public void setApprSpec(String apprSpec) {
		this.apprSpec = apprSpec;
	}

	/**
	 * @return the apprSpecDetails
	 */
	public String getApprSpecDetails() {
		return apprSpecDetails;
	}

	/**
	 * @param apprSpecDetails the apprSpecDetails to set
	 */
	public void setApprSpecDetails(String apprSpecDetails) {
		this.apprSpecDetails = apprSpecDetails;
	}

	/**
	 * @return the apprSpecDescr
	 */
	public String getApprSpecDescr() {
		return apprSpecDescr;
	}

	/**
	 * @param apprSpecDescr the apprSpecDescr to set
	 */
	public void setApprSpecDescr(String apprSpecDescr) {
		this.apprSpecDescr = apprSpecDescr;
	}

	/**
	 * @return the autoCalc
	 */
	public String getAutoCalc() {
		return autoCalc;
	}

	/**
	 * @param autoCalc the autoCalc to set
	 */
	public void setAutoCalc(String autoCalc) {
		this.autoCalc = autoCalc;
	}

	/**
	 * @return the calcMethod
	 */
	public String getCalcMethod() {
		return calcMethod;
	}

	/**
	 * @param calcMethod the calcMethod to set
	 */
	public void setCalcMethod(String calcMethod) {
		this.calcMethod = calcMethod;
	}

	/**
	 * @return the methodType
	 */
	public String getMethodType() {
		return methodType;
	}

	/**
	 * @param methodType the methodType to set
	 */
	public void setMethodType(String methodType) {
		this.methodType = methodType;
	}

	/**
	 * @return the methodInput
	 */
	public String getMethodInput() {
		return methodInput;
	}

	/**
	 * @param methodInput the methodInput to set
	 */
	public void setMethodInput(String methodInput) {
		this.methodInput = methodInput;
	}

	/**
	 * @return the sql
	 */
	public String getSql() {
		return sql;
	}

	/**
	 * @param sql the sql to set
	 */
	public void setSql(String sql) {
		this.sql = sql;
	}

	/**
	 * @return the sqlInput
	 */
	public String getSqlInput() {
		return sqlInput;
	}

	/**
	 * @param sqlInput the sqlInput to set
	 */
	public void setSqlInput(String sqlInput) {
		this.sqlInput = sqlInput;
	}

	/**
	 * @return the formula
	 */
	public String getFormula() {
		return formula;
	}

	/**
	 * @param formula the formula to set
	 */
	public void setFormula(String formula) {
		this.formula = formula;
	}

	/**
	 * @return the calcPattern
	 */
	public String getCalcPattern() {
		return calcPattern;
	}

	/**
	 * @param calcPattern the calcPattern to set
	 */
	public void setCalcPattern(String calcPattern) {
		this.calcPattern = calcPattern;
	}

	/**
	 * @return the specCategory
	 */
	public String getSpecCategory() {
		return specCategory;
	}

	/**
	 * @param specCategory the specCategory to set
	 */
	public void setSpecCategory(String specCategory) {
		this.specCategory = specCategory;
	}

	/**
	 * @return the specType
	 */
	public String getSpecType() {
		return specType;
	}

	/**
	 * @param specType the specType to set
	 */
	public void setSpecType(String specType) {
		this.specType = specType;
	}

	/**
	 * @return the denominator
	 */
	public String getDenominator() {
		return denominator;
	}

	/**
	 * @param denominator the denominator to set
	 */
	public void setDenominator(String denominator) {
		this.denominator = denominator;
	}

	/**
	 * @return the valueType
	 */
	public String getValueType() {
		return valueType;
	}

	/**
	 * @param valueType the valueType to set
	 */
	public void setValueType(String valueType) {
		this.valueType = valueType;
	}

	/**
	 * @return the apprSpecParent
	 */
	public String getApprSpecParent() {
		return apprSpecParent;
	}

	/**
	 * @param apprSpecParent the apprSpecParent to set
	 */
	public void setApprSpecParent(String apprSpecParent) {
		this.apprSpecParent = apprSpecParent;
	}

	/**
	 * @return the ratingType
	 */
	public String getRatingType() {
		return ratingType;
	}

	/**
	 * @param ratingType the ratingType to set
	 */
	public void setRatingType(String ratingType) {
		this.ratingType = ratingType;
	}

	/**
	 * @return the ratingValues
	 */
	public String getRatingValues() {
		return ratingValues;
	}

	/**
	 * @param ratingValues the ratingValues to set
	 */
	public void setRatingValues(String ratingValues) {
		this.ratingValues = ratingValues;
	}

	/**
	 * @return the trackingType
	 */
	public String getTrackingType() {
		return trackingType;
	}

	/**
	 * @param trackingType the trackingType to set
	 */
	public void setTrackingType(String trackingType) {
		this.trackingType = trackingType;
	}
	
	/**
	 * @return the detailXml
	 */
	public String getDetailXml() {
		return detailXml;
	}

	/**
	 * @param detailXml the detailXml to set
	 */
	public void setDetailXml(String detailXml) {
		this.detailXml = detailXml;
	}

	/**
	 * @return the userInfoBean
	 */
	public UserInfoBean getUserInfoBean() {
		return userInfoBean;
	}

	/**
	 * @param userInfoBean the userInfoBean to set
	 */
	public void setUserInfoBean(UserInfoBean userInfoBean) {
		this.userInfoBean = userInfoBean;
	}

	public String toString()
	{
		String result = "";
		if ( getSql().length() > 0 && getMethodType().equals("S"))
		{
			System.out.println("Inside ( getSql().length() > 0 && getMethodType().equals(S))");
			result = getSQLData();
		}
		return result;
	}
	
	private String getSQLData()
	{
		String[] parameters = null;
		String pophelpData = "";
				
		try
		{
			PopUpProperties popUpProperties = new PopUpProperties();

			String userinfoStr = getUserInfoBean().toString();
			
			ArrayList<String> inputList = genericUtility.getTokenList( sqlInput, "," );
			
			Document detailDom = null;
			detailXml = genericUtility.checkNull( detailXml );
			if ( detailXml.length() > 0 )
			{
				System.out.println( "detailXml - ["+ detailXml +"]" );
				detailDom = genericUtility.parseString( detailXml );
			}
			int paramSize = inputList.size();
			parameters = new String[ paramSize ];
			for ( int i = 0; i < inputList.size(); i++ )
			{
				System.out.println( "inputList.get("+ i +") - ["+ inputList.get( i ) +"]" );
				String inputName = inputList.get( i );
				String objContext = "0";
				if ( inputName.indexOf( "." ) != -1 )
				{
					objContext = genericUtility.checkNull( inputName.substring( inputName.indexOf(":") + 1, inputName.indexOf(".") ) );
				}
				if( objContext.equals("0") )
				{
					objContext = "1";
				}
				System.out.println("objContext  - ["+objContext+"]");
				inputName = ( inputName.indexOf( "." ) != -1 ) ? inputName.substring( inputName.indexOf( "." ) + 1 ) : inputName;
				inputName = ( inputName.indexOf( ":" ) != -1 ) ? inputName.substring( inputName.indexOf( ":" ) + 1 ) : inputName;
				System.out.println("inputName ["+inputName+"]");
				
				String inputValue = genericUtility.getColumnValue( inputName, detailDom, objContext, "" );
				inputValue = genericUtility.checkNull( inputValue );
				
				System.out.println( "inputName - ["+ inputName +"], inputValue - ["+ inputValue +"]" );

				if ( inputName.indexOf( "date" ) != -1 )
				{
					try
					{
						inputValue = genericUtility.getValidDateTimeString( inputValue, genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat() );
					}
					catch( Exception e )
					{
						inputValue = inputValue;
					}
					System.out.println( "For Date - inputName - ["+ inputName +"], inputValue - ["+ inputValue +"]" );
				}
				parameters[ i ] = inputValue;
			}
			
			AppConnectParm appConnect = new AppConnectParm();
			Properties props = appConnect.getProperty();
			InitialContext ctx = new InitialContext(props);
			
			PopUpDataAccessLocal popUpDataAccess = (PopUpDataAccessLocal)ctx.lookup("ibase/PopUpDataAccessEJB/local");
			popUpProperties.setDEFAULT_COL("1");
			popUpProperties.setTHUMB_ALT_COL("");
			popUpProperties.setTHUMB_IMAGE_COL("");
			popUpProperties.setTHUMB_OBJ("");
			
			pophelpData = popUpDataAccess.getPopUpData( sql, parameters, popUpProperties, userinfoStr );
			pophelpData = genericUtility.checkNull( pophelpData );
			System.out.println( "executeSQL :==>" + pophelpData +"]" );
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception in getPophelpData()"+ e.getMessage() ); 
			pophelpData = null;
		}
		return pophelpData;
	}
}