<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/asnWizardPopup.js"></script>
<link href="/ibase/webitm/css/theme/galaxy-theme.css" rel="stylesheet" />
<link href="/ibase/webitm/css/Standard/default.css" rel="stylesheet" />
<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet" />

<script language="JavaScript" type="text/javascript">
<![CDATA[
	$(function() {
	
		selectedCode = [];
		
		for( dbID = 1; dbID <= maxId; dbID++)
		{
			objCurr = document.getElementById("DetailITCode."+ dbID +".selectbox");
			
			if( objCurr.value == 'true' )
			{
				if ($.inArray( dbID, selectedCode ))
				{
					selectedCode.push( dbID );
				}
			}
		}
	});
	
]]>
</script>

<body onload="setUserTheme()">

	<form name="Wizard_Activity" id="Wizard_Activity">

	<table class="tableClass" id="Details" border="0" cellspacing="1" cellpadding="1">
	<thead class="table-head">
		<tr>
			<th class="thClass" nowrap="true" width="5%">
				<input type="checkbox" id="chkAll" onclick="return checkAllPopup(this)"/>
			</th>
			<!--<th class="thClass" nowrap="true" valign="bottom" width="20%">
				<strong>Code</strong>
			</th>
			<th class="thClass" nowrap="true" valign="bottom" width="75%">
				<strong>Description</strong>
			</th>	
		-->
		<xsl:for-each select="//Headers">
				<xsl:variable name="headName"><xsl:value-of select="headName"/></xsl:variable>
				<xsl:variable name="headSize"><xsl:value-of select="headSize"/></xsl:variable>
				<th class="tHeader" nowrap="true" valign="bottom" width="{$headSize}%">
					<xsl:value-of select="headName" />
				</th>
			</xsl:for-each>	
		</tr>
	</thead>
	<tbody class="table-body"> 
	
		<xsl:for-each select="//List">
		<xsl:variable name="fieldId"><xsl:value-of select="fieldId"/></xsl:variable>
		<xsl:variable name="fieldValue"><xsl:value-of select="fieldValue"/></xsl:variable>
		<xsl:variable name="otherField"><xsl:value-of select="otherField"/></xsl:variable>
		<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
		<SCRIPT>
			<![CDATA[ var qtyR; qtyR ="]]>	<xsl:value-of select="$dbID"/>
			<![CDATA[";maxId= qtyR; ]]>
		</SCRIPT>
		
		<xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable>
		<tr>
			<td>
				<xsl:choose>
					<xsl:when test="$chkbox ='Y'">
						<input type="checkbox" name="selectbox" id="DetailITCode.{normalize-space($dbID)}.selectbox" checked='true' value="true" onClick="setCheckedPopup(this)"/>
					</xsl:when>	
					<xsl:otherwise>
						<input type="checkbox" name="selectbox" id="DetailITCode.{normalize-space($dbID)}.selectbox" value="false" onClick="setCheckedPopup(this)"/>
					</xsl:otherwise>
				</xsl:choose>	
			</td>
			<td id="{normalize-space($dbID)}" onclick="setCheckedRow(event, this)">
				<xsl:value-of select="fieldId"/>
				<input type="hidden" name="Detail3.{normalize-space($dbID)}.fieldId" id="DetailITCode.{normalize-space($dbID)}.fieldId" 
					value="{normalize-space($fieldId)}" />
			</td>
			<td id="{normalize-space($dbID)}" onclick="setCheckedRow(event, this)">
				<xsl:value-of select="fieldValue"/>
				<input type="hidden" name="Detail3.{normalize-space($dbID)}.fieldValue" id="DetailITCode.{normalize-space($dbID)}.fieldValue" 
					value="{normalize-space($fieldValue)}" />
			</td>
			<input type="hidden" name="Detail3.{normalize-space($dbID)}.otherField" id="DetailITCode.{normalize-space($dbID)}.otherField" 
					value="{normalize-space($otherField)}" />
			
		</tr>
	</xsl:for-each>
		
	</tbody>		
	</table>
	</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
