package ibase.dashboard.sfa.ejb;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.ejb.Stateless;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;
/**
 * Session Bean implementation class SalesPersonSales
 */
@Stateless
public class Compliance extends ValidatorEJB implements ComplianceLocal, ComplianceRemote
{
	public Compliance() {
        // TODO Auto-generated constructor stub
    }
	
	 GenericUtility genericUtility = GenericUtility.getInstance();
    @SuppressWarnings("unchecked")
	@Override
    public JSONObject getComplianceDetails(String loginId,String dataSourceName,String period) throws RemoteException, ITMException
    {
		JSONObject rawDataComplianceDtlJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			System.out.println(" Inside ComplianceEJB for getComplianceDetails Data Soruc Name ="+dataSourceName+" loginId=:"+ loginId+"---- month=:"+ period);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			
			sql =   " SELECT FHCODE ,FHNAME ,FHDESG ,NSMCODE ,NSMNAME ,NSMDESG ,SMCODE ,SMNAME ,SMDESG ,RSECODE ,RSENAME ,RSEDESG ,REPCODE ,REPNAME ,REPDESG ,REP_NONREP , COUNT(*) CNT FROM (SELECT DISTINCT FHCODE ,FHNAME ,FHDESG ,NSMCODE ,NSMNAME ,NSMDESG ,SMCODE ,SMNAME ,SMDESG ,RSECODE ,RSENAME ,RSEDESG ,REPCODE ,REPNAME ,REPDESG ,AVAILABLE_DY ,ACTIVITY_CODE ,REP_NONREP ,CUSTOMER_NAME FROM ( SELECT FHCODE ,FHNAME ,FHDESG ,NSMCODE ,NSMNAME ,NSMDESG ,SMCODE ,SMNAME ,SMDESG ,RSECODE ,RSENAME ,RSEDESG ,REPCODE ,REPNAME ,REPDESG ,SALES_PERS_AV.AVAILABLE_DY ,SPRS_ACT_TRAN.ACTIVITY_CODE ,( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) = 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN 'R' WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN '-' ELSE 'NR' END ) AS REP_NONREP ,NVL(STRG_CUSTOMER.FIRST_NAME, '') || NVL(STRG_CUSTOMER.MIDDLE_NAME, '') || NVL(STRG_CUSTOMER.LAST_NAME, '') AS CUSTOMER_NAME FROM ( SELECT VW_SALES_HIER_JJ.REPCODE AS SALESPERS ,AV_DATES.available_dy AS AVAILABLE_DY FROM ( SELECT REPCODE ,'a' AS a FROM VW_SALES_HIER_JJ ) VW_SALES_HIER_JJ ,( SELECT dt AS available_dy ,'a' AS a FROM sfa_time WHERE dt BETWEEN trunc(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'MM') AND trunc(last_day(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'))) ) AV_DATES WHERE VW_SALES_HIER_JJ.a = AV_DATES.a MINUS SELECT EMPLOYEE.EMP_CODE AS SALESPERS ,holiday.hol_date AS AVAILABLE_DY FROM holiday ,EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno AND holiday.hol_date BETWEEN trunc(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'MM') AND trunc(last_day(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'))) AND NOT EXISTS ( SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code AND s.event_date = holiday.hol_date ) ) SALES_PERS_AV LEFT OUTER JOIN ( SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' AND S.CONFIRMED = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS = SALES_PERS_AV.SALESPERS AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY LEFT OUTER JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS = STRG_MEET.SALES_PERS AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID = STRG_MEET.DCR_ID LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE ,VW_SALES_HIER_JJ WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER_JJ.REPCODE AND VW_SALES_HIER_JJ.FHCODE = '"+loginId+"' " +
					" union all SELECT '' AS FHCODE ,'' AS FHNAME ,'' AS FHDESG ,NSMCODE ,NSMNAME ,NSMDESG ,SMCODE ,SMNAME ,SMDESG ,RSECODE ,RSENAME ,RSEDESG ,REPCODE ,REPNAME ,REPDESG ,SALES_PERS_AV.AVAILABLE_DY ,SPRS_ACT_TRAN.ACTIVITY_CODE ,( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) = 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN 'R' WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN '-' ELSE 'NR' END ) AS REP_NONREP ,NVL(STRG_CUSTOMER.FIRST_NAME, '') || NVL(STRG_CUSTOMER.MIDDLE_NAME, '') || NVL(STRG_CUSTOMER.LAST_NAME, '') AS CUSTOMER_NAME FROM ( SELECT VW_SALES_HIER_JJ.REPCODE AS SALESPERS ,AV_DATES.available_dy AS AVAILABLE_DY FROM ( SELECT REPCODE ,'a' AS a FROM VW_SALES_HIER_JJ ) VW_SALES_HIER_JJ ,( SELECT dt AS available_dy ,'a' AS a FROM sfa_time WHERE dt BETWEEN trunc(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'MM') AND trunc(last_day(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'))) ) AV_DATES WHERE VW_SALES_HIER_JJ.a = AV_DATES.a MINUS SELECT EMPLOYEE.EMP_CODE AS SALESPERS ,holiday.hol_date AS AVAILABLE_DY FROM holiday ,EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno AND holiday.hol_date BETWEEN trunc(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'MM') AND trunc(last_day(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'))) AND NOT EXISTS ( SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code AND s.event_date = holiday.hol_date ) ) SALES_PERS_AV LEFT OUTER JOIN ( SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' AND S.CONFIRMED = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS = SALES_PERS_AV.SALESPERS AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY LEFT OUTER JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS = STRG_MEET.SALES_PERS AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID = STRG_MEET.DCR_ID LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE ,VW_SALES_HIER_JJ WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER_JJ.REPCODE AND VW_SALES_HIER_JJ.NSMCODE = '"+loginId+"' " +
					" union all SELECT '' AS FHCODE ,'' AS FHNAME ,'' AS FHDESG ,'' AS NSMCODE ,'' AS NSMNAME ,'' AS NSMDESG ,SMCODE ,SMNAME ,SMDESG ,RSECODE ,RSENAME ,RSEDESG ,REPCODE ,REPNAME ,REPDESG ,SALES_PERS_AV.AVAILABLE_DY ,SPRS_ACT_TRAN.ACTIVITY_CODE ,( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) = 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN 'R' WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN '-' ELSE 'NR' END ) AS REP_NONREP ,NVL(STRG_CUSTOMER.FIRST_NAME, '') || NVL(STRG_CUSTOMER.MIDDLE_NAME, '') || NVL(STRG_CUSTOMER.LAST_NAME, '') AS CUSTOMER_NAME FROM ( SELECT VW_SALES_HIER_JJ.REPCODE AS SALESPERS ,AV_DATES.available_dy AS AVAILABLE_DY FROM ( SELECT REPCODE ,'a' AS a FROM VW_SALES_HIER_JJ ) VW_SALES_HIER_JJ ,( SELECT dt AS available_dy ,'a' AS a FROM sfa_time WHERE dt BETWEEN trunc(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'MM') AND trunc(last_day(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'))) ) AV_DATES WHERE VW_SALES_HIER_JJ.a = AV_DATES.a MINUS SELECT EMPLOYEE.EMP_CODE AS SALESPERS ,holiday.hol_date AS AVAILABLE_DY FROM holiday ,EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno AND holiday.hol_date BETWEEN trunc(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'MM') AND trunc(last_day(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'))) AND NOT EXISTS ( SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code AND s.event_date = holiday.hol_date ) ) SALES_PERS_AV LEFT OUTER JOIN ( SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' AND S.CONFIRMED = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS = SALES_PERS_AV.SALESPERS AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY LEFT OUTER JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS = STRG_MEET.SALES_PERS AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID = STRG_MEET.DCR_ID LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE ,VW_SALES_HIER_JJ WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER_JJ.REPCODE AND VW_SALES_HIER_JJ.SMCODE = '"+loginId+"' " +
					" union all SELECT '' AS FHCODE ,'' AS FHNAME ,'' AS FHDESG ,'' AS NSMCODE ,'' AS NSMNAME ,'' AS NSMDESG ,'' AS SMCODE ,'' AS SMNAME ,'' AS SMDESG ,RSECODE ,RSENAME ,RSEDESG ,REPCODE ,REPNAME ,REPDESG ,SALES_PERS_AV.AVAILABLE_DY ,SPRS_ACT_TRAN.ACTIVITY_CODE ,( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) = 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN 'R' WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN '-' ELSE 'NR' END ) AS REP_NONREP ,NVL(STRG_CUSTOMER.FIRST_NAME, '') || NVL(STRG_CUSTOMER.MIDDLE_NAME, '') || NVL(STRG_CUSTOMER.LAST_NAME, '') AS CUSTOMER_NAME FROM ( SELECT VW_SALES_HIER_JJ.REPCODE AS SALESPERS ,AV_DATES.available_dy AS AVAILABLE_DY FROM ( SELECT REPCODE ,'a' AS a FROM VW_SALES_HIER_JJ ) VW_SALES_HIER_JJ ,( SELECT dt AS available_dy ,'a' AS a FROM sfa_time WHERE dt BETWEEN trunc(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'MM') AND trunc(last_day(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'))) ) AV_DATES WHERE VW_SALES_HIER_JJ.a = AV_DATES.a MINUS SELECT EMPLOYEE.EMP_CODE AS SALESPERS ,holiday.hol_date AS AVAILABLE_DY FROM holiday ,EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno AND holiday.hol_date BETWEEN trunc(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'MM') AND trunc(last_day(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'))) AND NOT EXISTS ( SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code AND s.event_date = holiday.hol_date ) ) SALES_PERS_AV LEFT OUTER JOIN ( SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' AND S.CONFIRMED = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS = SALES_PERS_AV.SALESPERS AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY LEFT OUTER JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS = STRG_MEET.SALES_PERS AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID = STRG_MEET.DCR_ID LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE ,VW_SALES_HIER_JJ WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER_JJ.REPCODE AND VW_SALES_HIER_JJ.RSECODE = '"+loginId+"' " +
					" UNION ALL SELECT '' AS FHCODE ,'' AS FHNAME ,'' AS FHDESG ,'' AS NSMCODE ,'' AS NSMNAME ,'' AS NSMDESG ,'' AS SMCODE ,'' AS SMNAME ,'' AS SMDESG ,'' AS RSECODE ,'' AS RSENAME ,'' AS RSEDESG ,REPCODE ,REPNAME ,REPDESG ,SALES_PERS_AV.AVAILABLE_DY ,SPRS_ACT_TRAN.ACTIVITY_CODE ,( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) = 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN 'R' WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN '-' ELSE 'NR' END ) AS REP_NONREP ,NVL(STRG_CUSTOMER.FIRST_NAME, '') || NVL(STRG_CUSTOMER.MIDDLE_NAME, '') || NVL(STRG_CUSTOMER.LAST_NAME, '') AS CUSTOMER_NAME FROM ( SELECT VW_SALES_HIER_JJ.REPCODE AS SALESPERS ,AV_DATES.available_dy AS AVAILABLE_DY FROM ( SELECT REPCODE ,'a' AS a FROM VW_SALES_HIER_JJ ) VW_SALES_HIER_JJ ,( SELECT dt AS available_dy ,'a' AS a FROM sfa_time WHERE dt BETWEEN trunc(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'MM') AND trunc(last_day(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'))) ) AV_DATES WHERE VW_SALES_HIER_JJ.a = AV_DATES.a MINUS SELECT EMPLOYEE.EMP_CODE AS SALESPERS ,holiday.hol_date AS AVAILABLE_DY FROM holiday ,EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno AND holiday.hol_date BETWEEN trunc(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'MM') AND trunc(last_day(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'))) AND NOT EXISTS ( SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code AND s.event_date = holiday.hol_date ) ) SALES_PERS_AV LEFT OUTER JOIN ( SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' AND S.CONFIRMED = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS = SALES_PERS_AV.SALESPERS AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY LEFT OUTER JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS = STRG_MEET.SALES_PERS AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID = STRG_MEET.DCR_ID LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE ,VW_SALES_HIER_JJ WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER_JJ.REPCODE AND VW_SALES_HIER_JJ.REPCODE = '"+loginId+"' ) where REP_NONREP <>  '-') " +
					" GROUP BY FHCODE ,FHNAME ,FHDESG ,NSMCODE ,NSMNAME ,NSMDESG ,SMCODE ,SMNAME ,SMDESG ,RSECODE ,RSENAME ,RSEDESG ,REPCODE ,REPNAME ,REPDESG ,REP_NONREP " +
					" ORDER BY FHCODE ,NSMCODE ,SMCODE ,RSECODE ,REPCODE ";
			
			
			
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;	
			while (rs.next())
			{
				rowData = new JSONObject();

				rowData.put("fhcode", checkNull(rs.getString("FHCODE")).trim());		
				rowData.put("fhname", checkNull(rs.getString("FHNAME")).trim());
				rowData.put("fhdesg", checkNull(rs.getString("FHDESG")).trim());		

				rowData.put("nsmcode", checkNull(rs.getString("NSMCODE")).trim());
				rowData.put("nsmname", checkNull(rs.getString("NSMNAME")).trim());
				rowData.put("nsmdesg", checkNull(rs.getString("NSMDESG")).trim());
				
				rowData.put("smcode", checkNull(rs.getString("SMCODE")).trim());		
				rowData.put("smname", checkNull(rs.getString("SMNAME")).trim());		
				rowData.put("smdesg", checkNull(rs.getString("SMDESG")).trim());		
				
				rowData.put("rsecode", checkNull(rs.getString("RSECODE")).trim());
				rowData.put("rsename", checkNull(rs.getString("RSENAME")).trim());
				rowData.put("rsedesg", checkNull(rs.getString("RSEDESG")).trim());
				
				rowData.put("repcode", checkNull(rs.getString("REPCODE")).trim());
				rowData.put("repname", checkNull(rs.getString("REPNAME")).trim());
				rowData.put("repdesg", checkNull(rs.getString("REPDESG")).trim());
				
				rowData.put("rep_nonrep", checkNull(rs.getString("REP_NONREP")).trim());
				
				rowData.put("count", rs.getString("CNT"));
				
	
				rawDataComplianceDtlJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :ComplianceEJB:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		//System.out.println("ComplianceEJB JSON String======>>"+rawDataComplianceDtlJson.toString());
		return rawDataComplianceDtlJson;
		
	}
    @SuppressWarnings("unchecked")
    @Override
    public JSONObject getComplianceCustDetails(String firstVal, String cellVal, String dataSourceName) throws RemoteException, ITMException
    {
    	JSONObject rawDataComplianceCustDtlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			System.out.println(" Inside ComplianceEJB for getComplianceCustDetails Data Soruc Name ="+dataSourceName+" firstVal=:"+ firstVal + "===cellVal :"+ cellVal);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			SimpleDateFormat gridDateFormat = new SimpleDateFormat( "dd-MMM-yy");
			SimpleDateFormat convrtToTimStmDate= new SimpleDateFormat("dd/MM/yy");
			if(cellVal!=null && cellVal.length()>0)	
			{
			cellVal = gridDateFormat.format(convrtToTimStmDate.parse(cellVal));
			}
			System.out.println("cellVal :"+cellVal);
			
			//sql = "Select 'DH' as STRG_TYPE, 'Dhanendra' as CUST_NAME from Dual";
			
			sql="SELECT SM.STRG_TYPE, (SC.FIRST_NAME ||' '||SC.MIDDLE_NAME ||' '||SC.LAST_NAME) AS CUST_NAME FROM STRG_MEET SM " +
				"INNER JOIN STRG_CUSTOMER SC ON SM.STRG_CODE = SC.SC_CODE INNER JOIN VW_SALES_HIER_JJ VW ON SM.SALES_PERS = VW.REPCODE " +
				"WHERE SM.EVENT_DATE ='"+cellVal+"' AND VW.REPNAME = '"+firstVal.trim()+"' ";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;		
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("customer_name", checkNull(rs.getString("CUST_NAME")));
				rowData.put("strg_type", checkNull(rs.getString("STRG_TYPE")));
				rawDataComplianceCustDtlJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
		}
		catch (Exception e)/* sql = " Select FHCODE , FHNAME, FHDESG, NSMCODE, NSMNAME, NSMDESG, SMCODE," +
		" SMNAME, SMDESG, RSECODE, RSENAME, RSEDESG, REPCODE, " +
		" REPNAME, REPDESG, REP_NONREP,CNT " +
		" FROM Temp_SALES_HIER_JJ_CNT ORDER BY fhcode , nsmcode ,smcode,rsecode, repcode";
		*/
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :ComplianceEJB:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		System.out.println("ComplianceEJB rawDataComplianceCustDtlJson String======>>"+rawDataComplianceCustDtlJson.toString());
	    return rawDataComplianceCustDtlJson;
    }
 
	@SuppressWarnings("unchecked")
    @Override
    public JSONObject getComplianceGrid(String period, String personName, String dataSourceName) throws RemoteException, ITMException
    {

    	JSONObject rawDataComplianceGridJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			System.out.println(" Inside ComplianceEJB for getComplianceCustDetails Data Soruc Name ="+dataSourceName+" period=:"+ period + "=== personName :"+ personName);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			
			//sql = "Select '01/10/2015' as AVAILABLE_DY, 'FW' as ACTIVITY_CODE from Dual";
			
			sql=" SELECT REPCODE ,REPNAME ,REPDESG ,REP_NONREP ,to_char(AVAILABLE_DY,'dd/mm/yy') AS AVAILABLE_DY ,ACTIVITY_CODE " +
				" FROM( SELECT distinct REPCODE ,REPNAME ,REPDESG ,SALES_PERS_AV.AVAILABLE_DY ,SPRS_ACT_TRAN.ACTIVITY_CODE ," +
				" ( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY ORDER BY REPCODE ,AVAILABLE_DY ) ) = 1 " +
				" AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN 'R' WHEN ( ROW_NUMBER() OVER ( PARTITION BY REPCODE ,AVAILABLE_DY " +
				" ORDER BY REPCODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS IS NOT NULL THEN '-' ELSE 'NR' END ) AS REP_NONREP ," +
				" NVL(STRG_CUSTOMER.FIRST_NAME, '') || NVL(STRG_CUSTOMER.MIDDLE_NAME, '') || NVL(STRG_CUSTOMER.LAST_NAME, '') AS CUSTOMER_NAME " +
				" FROM ( SELECT VW_SALES_HIER_JJ.REPCODE AS SALESPERS ,AV_DATES.available_dy AS AVAILABLE_DY " +
				" FROM ( SELECT REPCODE ,'a' AS a FROM VW_SALES_HIER_JJ ) VW_SALES_HIER_JJ ,( SELECT dt AS available_dy ,'a' AS a " +
				" FROM sfa_time WHERE dt BETWEEN trunc(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'MM') " +
				" AND trunc(last_day(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'))) ) AV_DATES " +
				" WHERE VW_SALES_HIER_JJ.a = AV_DATES.a MINUS SELECT EMPLOYEE.EMP_CODE AS SALESPERS ,holiday.hol_date AS AVAILABLE_DY " +
				" FROM holiday ,EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno AND holiday.hol_date BETWEEN trunc(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'MM') " +
				" AND trunc(last_day(TO_DATE(to_char(TO_DATE('01-' || SUBSTR('"+period+"', 5, 6) || '-' || SUBSTR('"+period+"', 1, 4), 'DD-MM-YYYY'), 'DD-MM-YYYY'), 'DD-MM-YYYY'))) " +
				" AND NOT EXISTS ( SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code AND s.event_date = holiday.hol_date ) ) SALES_PERS_AV " +
				" LEFT OUTER JOIN ( SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' AND S.CONFIRMED = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS = SALES_PERS_AV.SALESPERS " +
				" AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY LEFT OUTER JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS = STRG_MEET.SALES_PERS " +
				" AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID = STRG_MEET.DCR_ID LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE ,VW_SALES_HIER_JJ " +
				" WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER_JJ.REPCODE AND UPPER(TRIM(VW_SALES_HIER_JJ.REPNAME)) = UPPER(TRIM('"+personName+"')) ) where REP_NONREP <>  '-' " +
				" ORDER BY AVAILABLE_DY ";
			

			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;	
			String activityCode = "";
			while (rs.next())
			{
				rowData = new JSONObject();
				
				rowData.put("repcode", checkNull(rs.getString("REPCODE")).trim());
				rowData.put("repname", checkNull(rs.getString("REPNAME")).trim());
				rowData.put("repdesg", checkNull(rs.getString("REPDESG")).trim());
				rowData.put("rep_nonrep", checkNull(rs.getString("REP_NONREP")).trim());
				
				rowData.put("available_dy", checkNull(rs.getString("AVAILABLE_DY")).trim());
				
				activityCode = rs.getString("ACTIVITY_CODE");
				System.out.println("activityCode :"+activityCode);
				if(activityCode == null)
				{
					rowData.put("activity_code", "Not-Reported");
				}else
				{
					rowData.put("activity_code", rs.getString("ACTIVITY_CODE"));	
				}
				
				rawDataComplianceGridJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :ComplianceEJB: getComplianceGrid " + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataComplianceGridJson;
    
    }

	/*Added New Compliance summary from date method for client PerkinElmer on dated 08-11-2016 by Nikhil*/
	 @SuppressWarnings("unchecked")
	 @Override
	public JSONObject getComplianceSummaryFrmDate(String loginId,String dataSourceName,String frmDate,String toDate) throws RemoteException, ITMException
	    {
			JSONObject rawDataComplianceSummJson = new JSONObject();
			JSONObject rowData = null;
			String sql         = "";
			ResultSet rs       = null;
			PreparedStatement pstmt = null;
			Connection conn         = null;
			ConnDriver connDriver   = new ConnDriver();
			SimpleDateFormat convertToDBDate  = null;
			Calendar calendar                 = null;
			try
			{
				System.out.println(" Inside ComplianceEJB for getComplianceSummaryFrmDate Data Soruc Name ="+dataSourceName+" loginId=:"+ loginId+"---- frmDate=:"+ frmDate+"----toDate=:"+toDate);
				conn = connDriver.getConnectDB(dataSourceName);
				connDriver = null;	
				
				
				//Add code of MTD for default on loading case
				
				if((frmDate==null) ||(frmDate.equals("")) && (toDate==null) || (toDate.equals("")))
				{ 				
				   
					  convertToDBDate = new SimpleDateFormat(genericUtility.getApplDateFormat());
					  calendar = Calendar.getInstance();
					  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
					  frmDate  = convertToDBDate.format(calendar.getTime());
					  toDate    = convertToDBDate.format(Calendar.getInstance().getTime());
					  System.out.println("Login code==="+loginId +"frmDate ====" + frmDate+" toDate==="+toDate);				
				  }
			  	 
			   //End the code of MTD format
							
				sql =   " SELECT PRDCODE, PRDNAME, PRDDESG, BUCODE, BUNAME, BUDESG, DGMCODE , DGMNAME , DGMDESG , RSMCODE , RSMNAME , RSMDESG , ASMCODE , ASMNAME , ASMDESG , ASECODE , ASENAME , ASEDESG , REP_NONREP , COUNT(*) CNT FROM (SELECT DISTINCT PRDCODE, PRDNAME, PRDDESG, BUCODE, BUNAME, BUDESG, DGMCODE , DGMNAME , DGMDESG , RSMCODE , RSMNAME , RSMDESG , ASMCODE , ASMNAME , ASMDESG , ASECODE , ASENAME , ASEDESG , AVAILABLE_DY , ACTIVITY_CODE , REP_NONREP , CUSTOMER_NAME FROM ( SELECT PRDCODE, PRDNAME, PRDDESG, BUCODE, BUNAME, BUDESG, DGMCODE , DGMNAME , DGMDESG , RSMCODE , RSMNAME , RSMDESG , ASMCODE , ASMNAME , ASMDESG , ASECODE , ASENAME , ASEDESG , SALES_PERS_AV.AVAILABLE_DY , SPRS_ACT_TRAN.ACTIVITY_CODE , ( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY ASECODE ,AVAILABLE_DY ORDER BY ASECODE ,AVAILABLE_DY ) ) = 1 AND SPRS_ACT_TRAN.SALES_PERS                                                                    IS NOT NULL THEN 'R' WHEN ( ROW_NUMBER() OVER ( PARTITION BY ASECODE ,AVAILABLE_DY ORDER BY ASECODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS                                                                     IS NOT NULL THEN '-' ELSE 'NR' END ) AS REP_NONREP , NVL(STRG_CUSTOMER.FIRST_NAME, '') || NVL(STRG_CUSTOMER.MIDDLE_NAME, '') || NVL(STRG_CUSTOMER.LAST_NAME, '') AS CUSTOMER_NAME FROM (SELECT VW_SALES_HIER.ASECODE AS SALESPERS , AV_DATES.available_dy       AS AVAILABLE_DY FROM ( SELECT ASECODE ,'a' AS a FROM VW_SALES_HIER ) VW_SALES_HIER , (SELECT dt AS available_dy , 'a' AS a FROM sfa_time WHERE DT BETWEEN '"+frmDate+"'  AND '"+toDate+"'     ) AV_DATES WHERE VW_SALES_HIER.a = AV_DATES.a MINUS SELECT EMPLOYEE.EMP_CODE AS SALESPERS , holiday.hol_date       AS AVAILABLE_DY FROM holiday , EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno AND holiday.hol_date BETWEEN '"+frmDate+"'  AND '"+toDate+"' AND NOT EXISTS (SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code AND s.event_date   = holiday.hol_date ) ) SALES_PERS_AV LEFT OUTER JOIN (SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' AND S.CONFIRMED = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS  = SALES_PERS_AV.SALESPERS AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY LEFT OUTER JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS  = STRG_MEET.SALES_PERS AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID     = STRG_MEET.DCR_ID LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE , VW_SALES_HIER WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER.ASECODE AND VW_SALES_HIER.DGMCODE = '"+loginId+"'  " +
						" UNION ALL  SELECT PRDCODE, PRDNAME, PRDDESG, BUCODE, BUNAME, BUDESG, DGMCODE , DGMNAME , DGMDESG , RSMCODE , RSMNAME , RSMDESG , ASMCODE , ASMNAME , ASMDESG , ASECODE , ASENAME , ASEDESG , SALES_PERS_AV.AVAILABLE_DY , SPRS_ACT_TRAN.ACTIVITY_CODE , ( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY ASECODE ,AVAILABLE_DY ORDER BY ASECODE ,AVAILABLE_DY ) ) = 1 AND SPRS_ACT_TRAN.SALES_PERS                                                                    IS NOT NULL THEN 'R' WHEN ( ROW_NUMBER() OVER ( PARTITION BY ASECODE ,AVAILABLE_DY ORDER BY ASECODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS                                                                     IS NOT NULL THEN '-' ELSE 'NR' END ) AS REP_NONREP , NVL(STRG_CUSTOMER.FIRST_NAME, '') || NVL(STRG_CUSTOMER.MIDDLE_NAME, '') || NVL(STRG_CUSTOMER.LAST_NAME, '') AS CUSTOMER_NAME FROM (SELECT VW_SALES_HIER.ASECODE AS SALESPERS , AV_DATES.available_dy       AS AVAILABLE_DY FROM ( SELECT ASECODE ,'a' AS a FROM VW_SALES_HIER ) VW_SALES_HIER , (SELECT dt AS available_dy , 'a'      AS a FROM sfa_time WHERE dt BETWEEN '"+frmDate+"'  AND '"+toDate+"' ) AV_DATES WHERE VW_SALES_HIER.a = AV_DATES.a MINUS SELECT EMPLOYEE.EMP_CODE AS SALESPERS , holiday.hol_date       AS AVAILABLE_DY FROM holiday , EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno AND holiday.hol_date BETWEEN '"+frmDate+"'  AND '"+toDate+"' AND NOT EXISTS (SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code AND s.event_date   = holiday.hol_date ) ) SALES_PERS_AV LEFT OUTER JOIN (SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' AND S.CONFIRMED        = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS  = SALES_PERS_AV.SALESPERS AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY LEFT OUTER JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS  = STRG_MEET.SALES_PERS AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID     = STRG_MEET.DCR_ID LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE , VW_SALES_HIER WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER.ASECODE AND VW_SALES_HIER.RSMCODE  = '"+loginId+"'  " +
						" UNION ALL  SELECT PRDCODE, PRDNAME, PRDDESG, BUCODE, BUNAME, BUDESG, DGMCODE , DGMNAME , DGMDESG , RSMCODE , RSMNAME , RSMDESG , ASMCODE , ASMNAME , ASMDESG , ASECODE , ASENAME , ASEDESG , SALES_PERS_AV.AVAILABLE_DY , SPRS_ACT_TRAN.ACTIVITY_CODE , ( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY ASECODE ,AVAILABLE_DY ORDER BY ASECODE ,AVAILABLE_DY ) ) = 1 AND SPRS_ACT_TRAN.SALES_PERS                                                                    IS NOT NULL THEN 'R' WHEN ( ROW_NUMBER() OVER ( PARTITION BY ASECODE ,AVAILABLE_DY ORDER BY ASECODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS                                                                     IS NOT NULL THEN '-' ELSE 'NR' END ) AS REP_NONREP , NVL(STRG_CUSTOMER.FIRST_NAME, '') || NVL(STRG_CUSTOMER.MIDDLE_NAME, '') || NVL(STRG_CUSTOMER.LAST_NAME, '') AS CUSTOMER_NAME FROM (SELECT VW_SALES_HIER.ASECODE AS SALESPERS , AV_DATES.available_dy       AS AVAILABLE_DY FROM ( SELECT ASECODE ,'a' AS a FROM VW_SALES_HIER ) VW_SALES_HIER , (SELECT dt AS available_dy , 'a'      AS a FROM sfa_time WHERE dt BETWEEN '"+frmDate+"'  AND '"+toDate+"' ) AV_DATES WHERE VW_SALES_HIER.a = AV_DATES.a MINUS SELECT EMPLOYEE.EMP_CODE AS SALESPERS , holiday.hol_date       AS AVAILABLE_DY FROM holiday , EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno AND holiday.hol_date BETWEEN '"+frmDate+"'  AND '"+toDate+"' AND NOT EXISTS (SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code AND s.event_date   = holiday.hol_date ) ) SALES_PERS_AV LEFT OUTER JOIN (SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' AND S.CONFIRMED        = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS  = SALES_PERS_AV.SALESPERS AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY LEFT OUTER JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS  = STRG_MEET.SALES_PERS AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID     = STRG_MEET.DCR_ID LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE , VW_SALES_HIER WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER.ASECODE AND VW_SALES_HIER.ASMCODE   = '"+loginId+"'  " +
						" UNION ALL  SELECT PRDCODE, PRDNAME, PRDDESG, BUCODE, BUNAME, BUDESG, DGMCODE , DGMNAME , DGMDESG , RSMCODE , RSMNAME , RSMDESG , ASMCODE , ASMNAME , ASMDESG , ASECODE , ASENAME , ASEDESG , SALES_PERS_AV.AVAILABLE_DY , SPRS_ACT_TRAN.ACTIVITY_CODE , ( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY ASECODE ,AVAILABLE_DY ORDER BY ASECODE ,AVAILABLE_DY ) ) = 1 AND SPRS_ACT_TRAN.SALES_PERS                                                                    IS NOT NULL THEN 'R' WHEN ( ROW_NUMBER() OVER ( PARTITION BY ASECODE ,AVAILABLE_DY ORDER BY ASECODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS                                                                     IS NOT NULL THEN '-' ELSE 'NR' END ) AS REP_NONREP , NVL(STRG_CUSTOMER.FIRST_NAME, '') || NVL(STRG_CUSTOMER.MIDDLE_NAME, '') || NVL(STRG_CUSTOMER.LAST_NAME, '') AS CUSTOMER_NAME FROM (SELECT VW_SALES_HIER.ASECODE AS SALESPERS , AV_DATES.available_dy       AS AVAILABLE_DY FROM ( SELECT ASECODE ,'a' AS a FROM VW_SALES_HIER ) VW_SALES_HIER , (SELECT dt AS available_dy , 'a'      AS a FROM sfa_time WHERE dt BETWEEN '"+frmDate+"'  AND '"+toDate+"' ) AV_DATES WHERE VW_SALES_HIER.a = AV_DATES.a MINUS SELECT EMPLOYEE.EMP_CODE AS SALESPERS , holiday.hol_date       AS AVAILABLE_DY FROM holiday , EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno AND holiday.hol_date BETWEEN '"+frmDate+"'  AND '"+toDate+"' AND NOT EXISTS (SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code AND s.event_date   = holiday.hol_date ) ) SALES_PERS_AV LEFT OUTER JOIN (SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' AND S.CONFIRMED        = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS  = SALES_PERS_AV.SALESPERS AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY LEFT OUTER JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS  = STRG_MEET.SALES_PERS AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID     = STRG_MEET.DCR_ID LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE , VW_SALES_HIER WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER.ASECODE AND VW_SALES_HIER.PRDCODE   = '"+loginId+"'  " +
						" UNION ALL  SELECT PRDCODE, PRDNAME, PRDDESG, BUCODE, BUNAME, BUDESG, DGMCODE , DGMNAME , DGMDESG , RSMCODE , RSMNAME , RSMDESG , ASMCODE , ASMNAME , ASMDESG , ASECODE , ASENAME , ASEDESG , SALES_PERS_AV.AVAILABLE_DY , SPRS_ACT_TRAN.ACTIVITY_CODE , ( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY ASECODE ,AVAILABLE_DY ORDER BY ASECODE ,AVAILABLE_DY ) ) = 1 AND SPRS_ACT_TRAN.SALES_PERS                                                                    IS NOT NULL THEN 'R' WHEN ( ROW_NUMBER() OVER ( PARTITION BY ASECODE ,AVAILABLE_DY ORDER BY ASECODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS                                                                     IS NOT NULL THEN '-' ELSE 'NR' END ) AS REP_NONREP , NVL(STRG_CUSTOMER.FIRST_NAME, '') || NVL(STRG_CUSTOMER.MIDDLE_NAME, '') || NVL(STRG_CUSTOMER.LAST_NAME, '') AS CUSTOMER_NAME FROM (SELECT VW_SALES_HIER.ASECODE AS SALESPERS , AV_DATES.available_dy       AS AVAILABLE_DY FROM ( SELECT ASECODE ,'a' AS a FROM VW_SALES_HIER ) VW_SALES_HIER , (SELECT dt AS available_dy , 'a'      AS a FROM sfa_time WHERE dt BETWEEN '"+frmDate+"'  AND '"+toDate+"' ) AV_DATES WHERE VW_SALES_HIER.a = AV_DATES.a MINUS SELECT EMPLOYEE.EMP_CODE AS SALESPERS , holiday.hol_date       AS AVAILABLE_DY FROM holiday , EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno AND holiday.hol_date BETWEEN '"+frmDate+"'  AND '"+toDate+"' AND NOT EXISTS (SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code AND s.event_date   = holiday.hol_date ) ) SALES_PERS_AV LEFT OUTER JOIN (SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' AND S.CONFIRMED        = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS  = SALES_PERS_AV.SALESPERS AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY LEFT OUTER JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS  = STRG_MEET.SALES_PERS AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID     = STRG_MEET.DCR_ID LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE , VW_SALES_HIER WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER.ASECODE AND VW_SALES_HIER.ASECODE   = '"+loginId+"'   " +
						" UNION ALL  SELECT PRDCODE, PRDNAME, PRDDESG, BUCODE, BUNAME, BUDESG, DGMCODE , DGMNAME , DGMDESG , RSMCODE , RSMNAME , RSMDESG , ASMCODE , ASMNAME , ASMDESG , ASECODE , ASENAME , ASEDESG , SALES_PERS_AV.AVAILABLE_DY , SPRS_ACT_TRAN.ACTIVITY_CODE , ( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY ASECODE ,AVAILABLE_DY ORDER BY ASECODE ,AVAILABLE_DY ) ) = 1 AND SPRS_ACT_TRAN.SALES_PERS                                                                    IS NOT NULL THEN 'R' WHEN ( ROW_NUMBER() OVER ( PARTITION BY ASECODE ,AVAILABLE_DY ORDER BY ASECODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS                                                                     IS NOT NULL THEN '-' ELSE 'NR' END ) AS REP_NONREP , NVL(STRG_CUSTOMER.FIRST_NAME, '') || NVL(STRG_CUSTOMER.MIDDLE_NAME, '') || NVL(STRG_CUSTOMER.LAST_NAME, '') AS CUSTOMER_NAME FROM (SELECT VW_SALES_HIER.ASECODE AS SALESPERS , AV_DATES.available_dy       AS AVAILABLE_DY FROM ( SELECT ASECODE ,'a' AS a FROM VW_SALES_HIER ) VW_SALES_HIER , (SELECT dt AS available_dy , 'a'      AS a FROM sfa_time WHERE dt BETWEEN '"+frmDate+"'  AND '"+toDate+"' ) AV_DATES WHERE VW_SALES_HIER.a = AV_DATES.a MINUS SELECT EMPLOYEE.EMP_CODE AS SALESPERS , holiday.hol_date       AS AVAILABLE_DY FROM holiday , EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno AND holiday.hol_date BETWEEN '"+frmDate+"'  AND '"+toDate+"' AND NOT EXISTS (SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code AND s.event_date   = holiday.hol_date ) ) SALES_PERS_AV LEFT OUTER JOIN (SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' AND S.CONFIRMED        = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS  = SALES_PERS_AV.SALESPERS AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY LEFT OUTER JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS  = STRG_MEET.SALES_PERS AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID     = STRG_MEET.DCR_ID LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE , VW_SALES_HIER WHERE SALES_PERS_AV.SALESPERS = VW_SALES_HIER.ASECODE AND VW_SALES_HIER.BUCODE   = '"+loginId+"' ) WHERE REP_NONREP <> '-' ) GROUP BY PRDCODE, PRDNAME, PRDDESG, BUCODE, BUNAME, BUDESG, DGMCODE , DGMNAME , DGMDESG , RSMCODE , RSMNAME , RSMDESG , ASMCODE , ASMNAME , ASMDESG , ASECODE , ASENAME , ASEDESG , REP_NONREP ORDER BY PRDCODE,  BUCODE, DGMCODE , RSMCODE , ASMCODE , ASECODE , ASECODE ";
			
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				int count = 0;	
				while (rs.next())
				{
					rowData = new JSONObject();

					rowData.put("prdcode",     checkNull(rs.getString("PRDCODE")).trim());		
					rowData.put("prdname",     checkNull(rs.getString("PRDNAME")).trim());
					rowData.put("prdnamedesg", checkNull(rs.getString("PRDDESG")).trim());		
					rowData.put("bucode",      checkNull(rs.getString("BUCODE")).trim());
					rowData.put("buname",      checkNull(rs.getString("BUNAME")).trim());
					rowData.put("bunamedesg",  checkNull(rs.getString("BUDESG")).trim());					
					rowData.put("dgmcode",     checkNull(rs.getString("DGMCODE")).trim());		
					rowData.put("dgmname",     checkNull(rs.getString("DGMNAME")).trim());		
					rowData.put("dgmnamedesg", checkNull(rs.getString("DGMDESG")).trim());		
					
					rowData.put("rsmcode",     checkNull(rs.getString("RSMCODE")).trim());
					rowData.put("rsmname",     checkNull(rs.getString("RSMNAME")).trim());
					rowData.put("rsmnamedesg", checkNull(rs.getString("RSMDESG")).trim());
					
					rowData.put("asmcode",     checkNull(rs.getString("ASMCODE")).trim());
					rowData.put("asmname",     checkNull(rs.getString("ASMNAME")).trim());
					rowData.put("asmnamedesg", checkNull(rs.getString("ASMDESG")).trim());
					
					rowData.put("asecode",     checkNull(rs.getString("ASECODE")).trim());
					rowData.put("asename",     checkNull(rs.getString("ASENAME")).trim());
					rowData.put("asenamedesg", checkNull(rs.getString("ASEDESG")).trim());
					
					rowData.put("rep_nonrep", checkNull(rs.getString("REP_NONREP")).trim());					
					rowData.put("count", rs.getString("CNT"));		
					rawDataComplianceSummJson.put(count, rowData);
					count++;
				}
				rs.close();
				rs=null;
				pstmt.close();
				pstmt=null;
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
			finally
			{
				try
				{
					if (conn != null)
					{
						if (rs != null)
						rs.close();
						rs = null;
						if (pstmt != null)
						pstmt.close();
						pstmt = null;
						conn.close();
						conn = null;
					}
					conn = null;
				} catch (Exception d)
				{
					d.printStackTrace();
					System.out.println("Exception in :ComplianceEJB:" + d.getMessage());
					throw new ITMException(d);
				}
			}
			return rawDataComplianceSummJson;
			
		}
	
	/*Ended New Compliance summary from date method for client PerkinElmer on dated 08-11-2016 by Nikhil*/
	
	 /*Added New Compliance Detail from date method for client PerkinElmer on dated 08-11-2016 by Nikhil*/
		
	    @SuppressWarnings("unchecked")
	    @Override
	public JSONObject getComplianceDetailFrmDate(String frmDate,String toDate ,String personName, String dataSourceName) throws RemoteException, ITMException
	    {

	    	JSONObject rawDataComplianceDetJson = new JSONObject();
			JSONObject rowData = null;
			String sql = "";
			ResultSet rs = null;
			PreparedStatement pstmt = null;
			Connection conn = null;
			ConnDriver connDriver = new ConnDriver();
			SimpleDateFormat convertToDBDate  = null;
			Calendar calendar = null;
			try
			{
				System.out.println(" Inside ComplianceEJB for getComplianceDetailFrmDate Data Soruc Name ="+dataSourceName+" frmDate=:"+ frmDate + "=== personName :"+ personName);
				conn = connDriver.getConnectDB(dataSourceName);
				connDriver = null;
				
                    //Add code of MTD for default on loading case
				
				if((frmDate==null) ||(frmDate.equals("")) && (toDate==null) || (toDate.equals("")))
				{ 				
				   
					  convertToDBDate = new SimpleDateFormat(genericUtility.getApplDateFormat());
					  calendar = Calendar.getInstance();
					  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
					  frmDate  = convertToDBDate.format(calendar.getTime());
					  toDate    = convertToDBDate.format(Calendar.getInstance().getTime());
					  System.out.println("frmDate ====" + frmDate+" toDate==="+toDate);				
				  }
			  	 
			   //End the code of MTD format
				
				
				sql=    " SELECT ASECODE , ASENAME , ASEDESG , REP_NONREP , TO_CHAR(AVAILABLE_DY,'dd/mm/yy') AS AVAILABLE_DY , ACTIVITY_CODE FROM ( SELECT DISTINCT ASECODE , ASENAME , ASEDESG , SALES_PERS_AV.AVAILABLE_DY , SPRS_ACT_TRAN.ACTIVITY_CODE , ( CASE WHEN ( ROW_NUMBER() OVER ( PARTITION BY ASECODE ,AVAILABLE_DY ORDER BY ASECODE ,AVAILABLE_DY ) ) = 1 AND SPRS_ACT_TRAN.SALES_PERS                                                                    " +
						" IS NOT NULL THEN 'R' WHEN ( ROW_NUMBER() OVER ( PARTITION BY ASECODE ,AVAILABLE_DY ORDER BY ASECODE ,AVAILABLE_DY ) ) <> 1 AND SPRS_ACT_TRAN.SALES_PERS                                                                     " +
						" IS NOT NULL THEN '-' ELSE 'NR' END ) AS REP_NONREP , NVL(STRG_CUSTOMER.FIRST_NAME, '') || NVL(STRG_CUSTOMER.MIDDLE_NAME, '') || NVL(STRG_CUSTOMER.LAST_NAME, '') AS CUSTOMER_NAME FROM (SELECT VW_SALES_HIER.ASECODE AS SALESPERS , AV_DATES.available_dy          " +
						" AS AVAILABLE_DY FROM ( SELECT ASECODE ,'a' AS a FROM VW_SALES_HIER ) VW_SALES_HIER , (SELECT dt AS available_dy , 'a'      AS a FROM sfa_time " +
						" WHERE dt BETWEEN '"+frmDate+"' AND '"+toDate+"' ) AV_DATES " +
						" WHERE VW_SALES_HIER.a = AV_DATES.a MINUS SELECT EMPLOYEE.EMP_CODE AS SALESPERS , holiday.hol_date " +
						" AS AVAILABLE_DY FROM holiday , EMPLOYEE WHERE holiday.hol_tblno = EMPLOYEE.hol_tblno AND holiday.hol_date  " +
						" BETWEEN '"+frmDate+"' AND '"+toDate+"' AND NOT EXISTS (SELECT * FROM sprs_act_tran s WHERE s.sales_pers = employee.emp_code AND s.event_date   = holiday.hol_date ) ) SALES_PERS_AV LEFT OUTER JOIN (SELECT S.* FROM SPRS_ACT_TRAN S WHERE S.ACTIVITY_CODE <> 'PR' AND S.CONFIRMED        = 'Y' ) SPRS_ACT_TRAN ON SPRS_ACT_TRAN.SALES_PERS  = SALES_PERS_AV.SALESPERS AND SPRS_ACT_TRAN.EVENT_DATE = SALES_PERS_AV.AVAILABLE_DY LEFT OUTER JOIN ( SELECT S.* FROM STRG_MEET S WHERE S.EVENT_TYPE <> 'PR' ) STRG_MEET ON SPRS_ACT_TRAN.SALES_PERS  = STRG_MEET.SALES_PERS AND SPRS_ACT_TRAN.EVENT_DATE = STRG_MEET.EVENT_DATE AND SPRS_ACT_TRAN.DCR_ID     = STRG_MEET.DCR_ID LEFT OUTER JOIN STRG_CUSTOMER ON STRG_MEET.STRG_CODE = STRG_CUSTOMER.SC_CODE , VW_SALES_HIER WHERE SALES_PERS_AV.SALESPERS             = VW_SALES_HIER.ASECODE " +
						" AND UPPER(TRIM(VW_SALES_HIER.ASENAME)) = UPPER(TRIM('"+personName+"')) ) " +
						" WHERE REP_NONREP <> '-' ORDER BY AVAILABLE_DY ";
				

				pstmt = conn.prepareStatement(sql);
				rs    = pstmt.executeQuery();
				int count           = 0;	
				String activityCode = "";
				while (rs.next())
				{
					rowData = new JSONObject();
					
					rowData.put("asecode",    checkNull(rs.getString("ASECODE")).trim());
					rowData.put("asename",    checkNull(rs.getString("ASENAME")).trim());
					rowData.put("asedesg",    checkNull(rs.getString("ASEDESG")).trim());
					rowData.put("rep_nonrep", checkNull(rs.getString("REP_NONREP")).trim());
					
					rowData.put("available_dy", checkNull(rs.getString("AVAILABLE_DY")).trim());
					
					activityCode = rs.getString("ACTIVITY_CODE");
					System.out.println("activityCode :"+activityCode);
					if(activityCode == null)
					{
						rowData.put("activity_code", "Not-Reported");
					}else
					{
						rowData.put("activity_code", rs.getString("ACTIVITY_CODE"));	
					}
					
					rawDataComplianceDetJson.put(count, rowData);
					count++;
				}
				rs.close();
				rs=null;
				pstmt.close();
				pstmt=null;
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
			finally
			{
				try
				{
					if (conn != null)
					{
						if (rs != null)
						rs.close();
						rs = null;
						if (pstmt != null)
						pstmt.close();
						pstmt = null;
						conn.close();
						conn = null;
					}
					conn = null;
				} catch (Exception d)
				{
					d.printStackTrace();
					System.out.println("Exception in :ComplianceEJB: getComplianceDetailFrmDate " + d.getMessage());
					throw new ITMException(d);
				}
			}
			return rawDataComplianceDetJson;
	    
	    }
	    /*Ended New Compliance Detail from date method for client PerkinElmer on dated 08-11-2016 by Nikhil*/
	
	
	/*Added New Personal Detail  method for client PerkinElmer on dated 08-11-2016 by Nikhil*/
	    @SuppressWarnings("unchecked")
	    @Override
	public JSONObject getPersonalDetFrmDate(String firstVal, String cellVal, String dataSourceName) throws RemoteException, ITMException
	    {
	    	JSONObject rawDataCompliancePerDetJson = new JSONObject();
			JSONObject rowData         = null;
			String sql                 = "";
			ResultSet rs               = null;
			PreparedStatement pstmt    = null;
			Connection conn            = null;
			ConnDriver connDriver      = new ConnDriver();
			SimpleDateFormat convertToDBDate  = null;
			Calendar calendar          = null;
			String fromDate            = "";
			String toDate              = "";
			try
			{
				System.out.println(" Inside ComplianceEJB for getPersonalDetFrmDate Data Soruc Name ="+dataSourceName+" firstVal=:"+ firstVal + "===cellVal :"+ cellVal);
				conn       = connDriver.getConnectDB(dataSourceName);
				connDriver = null;
				SimpleDateFormat gridDateFormat      = new SimpleDateFormat( "dd-MMM-yy");
				SimpleDateFormat convrtToTimStmDate  = new SimpleDateFormat("dd/MM/yy");
				if(cellVal!=null && cellVal.length()>0)	
				{
				cellVal = gridDateFormat.format(convrtToTimStmDate.parse(cellVal));
				}
				System.out.println("cellVal :"+cellVal);
				
			    //Add code of MTD for default on loading case
				
				if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
				{ 				
				   
					  convertToDBDate = new SimpleDateFormat(genericUtility.getApplDateFormat());
					  calendar = Calendar.getInstance();
					  calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
					  fromDate  = convertToDBDate.format(calendar.getTime());
					  toDate    = convertToDBDate.format(Calendar.getInstance().getTime());
					  System.out.println("frmDate ====" + fromDate+" toDate==="+toDate);				
				  }
						  	 
				//End the code of MTD format
				
				
				sql=" SELECT SM.STRG_TYPE, (SC.FIRST_NAME ||' '||SC.MIDDLE_NAME ||' '||SC.LAST_NAME) AS CUST_NAME FROM STRG_MEET SM INNER JOIN STRG_CUSTOMER SC ON SM.STRG_CODE = SC.SC_CODE INNER JOIN VW_SALES_HIER VW ON SM.SALES_PERS = VW.ASECODE " +
					" WHERE SM.EVENT_DATE ='"+cellVal+"' AND VW.ASENAME = '"+firstVal.trim()+"' ";
				
				pstmt = conn.prepareStatement(sql);
				rs    = pstmt.executeQuery();
				int count = 0;		
				while (rs.next())
				{
					rowData = new JSONObject();
					rowData.put("customer_name", checkNull(rs.getString("CUST_NAME")));
					rowData.put("strg_type",     checkNull(rs.getString("STRG_TYPE")));
					rawDataCompliancePerDetJson.put(count, rowData);
					count++;
				}
				rs.close();
				rs=null;
				pstmt.close();
				pstmt=null;
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
			finally
			{
				try
				{
					if (conn != null)
					{
						if (rs != null)
						rs.close();
						rs = null;
						if (pstmt != null)
						pstmt.close();
						pstmt = null;
						conn.close();
						conn = null;
					}
					conn = null;
				} catch (Exception d)
				{
					d.printStackTrace();
					System.out.println("Exception in :ComplianceEJB:" + d.getMessage());
					throw new ITMException(d);
				}
			}
			System.out.println("ComplianceEJB rawDataCompliancePerDetJson String======>>"+rawDataCompliancePerDetJson.toString());
		    return rawDataCompliancePerDetJson;
	    }
	    
	/*Ended New Personal Detail method for client PerkinElmer on dated 08-11-2016 by Nikhil*/
	
	private String checkNull(String str)
   	{
   		if(str == null)
   		{
   			return "";
   		}
   		else
   		{
   			return str ;
   		}

   	}	
}
