/*
 * Developed by	: Hemlata Waikar
 */

package ibase.webitm.ejb.adm;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
@SuppressWarnings({"rawtypes", "unused"})
public class PerkClaimProcess extends ValidatorEJB implements
		PerkClaimProcessLocal, PerkClaimProcessRemote {
	
	

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams)
			throws RemoteException, ITMException {
		Document dom = null, dom1 = null, dom2 = null;
		String retStr = null;
		E12GenericUtility genericUtility = new E12GenericUtility();

		try {
			System.out.println("\n\tPerkClaimProcess xmlString in itemChanged..::[" + xmlString + "]"
							+ "\n\tPerkClaimProcess xmlString1 in itemChanged..:: [" + xmlString1 + "]"
							+ "\n\tPerkClaimProcess xmlString2 in itemChanged..:: [" + xmlString2 + "]");
			if (xmlString != null && xmlString.length() > 0) {
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.length() > 0) {
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.length() > 0) {
				dom2 = genericUtility.parseString(xmlString2);
			}
			retStr = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		} catch (Exception e) {
			System.out.println("Exception in " + this.getClass().getSimpleName() + " -itemChange(S) [" + e.getMessage() + "]");
			retStr = genericUtility.createErrorString(e);
		}
		System.out.println("Returning from " + this.getClass().getSimpleName() + " -itemChange (S) [" + retStr + "]");
		return retStr;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams)
			throws RemoteException, ITMException {
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String sql = "", sql1 = "", sql2 = "", sql3 = "", sql4 = "", sql5 = "";
		PreparedStatement pstmt = null, prestmt = null, pstmt2 = null, pstmt3 = null, pstmt4 = null, pstmt5 = null;
		ResultSet rs = null, rs1 = null, rs2 = null, rs3 = null, rs4 = null, rs5 = null;

		String empCodeFrom = "", empFName = "", empMName = "", empLName = "", empName = "", empCodeTo = "", adCode = "", adCode1 = "", adCodeDescr = "",
				siteCodeFrom = "", siteCodeFromDescr = "", siteCodeTo = "", siteCodeToDescr = "", procGroupFrom = "", procGroupFromDescr = "", procGroupTo = "",
				procGroupToDescr = "", prdCode = "", resigned = "", fullAmt = "", fromDate = "", claimDate = "", unappLoans = "", contVouch = "", adjustLoan = "",
				lsAd1 = "", lsAd2 = "", startDate = "", startDate3 = "", endDate3 = "", fname = "", lname = "", suppCodeCon = "", paySite = "", cadre = "",
				grade = "", userLevel = "", description = "", loanAdjamt = "0", canClaimInSameYear = "", lsEnvName = "", endDate = "", amtBal = "0", lsEmp = "",
				loanNo = "", adjPerc = "0", ref_no = "", schemeNo = "", loanAmt = "", monInst = "", interest = "", balanceAmt = "0", lineNo = "", loanAdjust = "0", 
				balAmt = "0", lcTemp = "0", amtAdj = "0", adjAmount = "0", payrollvoucher = "", lcClaimamt = "0", objNameDefault = "", loginEmpCode = "", loginCode = "",
				loginSiteCode = "";
		
		java.util.Date dateFrom = null, startDate1 = null, endDate1 = null, startDate2 = null, endDate2 = null;

		long llCurFlag = 0, llCurrFlag = 0;
		int li_xx1 = 0, li_xx = 0, lc_adj = 0, ll_ctr = 0, count = 0, domId = 1, domId1 = 1, currentFormNo = 0;
		double claimAmt = 0.0d, adjPercentage = 0.0d, temp = 0.0d, lcBalanceAmt = 0.0d, balAmount = 0.0d, lcAdj = 0.0d, loanAdj = 0.0d,firstLoanAdjust = 0.0d;
		
		boolean isNo = false;
		
		StringBuffer valueXmlString = new StringBuffer();

		E12GenericUtility genericUtility = new E12GenericUtility();
		AdmCommon admCommon = new AdmCommon();

		loginEmpCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
		loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
		loginSiteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
		
		if (objContext != null && objContext.trim().length() > 0) {
			currentFormNo = Integer.parseInt(objContext);
		}

		try {
			conn = connDriver.getConnectDB("Driver");
			conn.setAutoCommit(false);

			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			objNameDefault = checkNull(getObjName(dom, "1"));
			SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());
			Date currentDate = new Date();
			String curDate = sdf.format(currentDate);
			switch (currentFormNo) {
			case 1: {
				valueXmlString.append("<Detail1 domID='1' dbID='' objContext='1' objName='"+ objNameDefault + "' selected='Y'>\r\n");
				if (currentColumn.equalsIgnoreCase("itm_default")) {
					valueXmlString.append("<prd_code><![CDATA[").append("").append("]]></prd_code>\r\n");
					valueXmlString.append("<date_from><![CDATA[").append("").append("]]></date_from>\r\n");
					valueXmlString.append("<claim_date><![CDATA[").append(curDate).append("]]></claim_date>\r\n");
					valueXmlString.append("<emp_code__from><![CDATA[").append("00").append("]]></emp_code__from>\r\n");
					valueXmlString.append("<emp_name__from><![CDATA[").append("").append("]]></emp_name__from>\r\n");
					valueXmlString.append("<emp_code__to><![CDATA[").append("ZZ").append("]]></emp_code__to>\r\n");
					valueXmlString.append("<emp_name__to><![CDATA[").append("").append("]]></emp_name__to>\r\n");
					valueXmlString.append("<ad_code><![CDATA[").append("").append("]]></ad_code>\r\n");
					valueXmlString.append("<ad_descr><![CDATA[").append("").append("]]></ad_descr>\r\n");
					sql = "SELECT USR_LEV FROM USERS WHERE CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, loginCode);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						userLevel = checkNull(rs.getString("USR_LEV"));
					}
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}
					valueXmlString.append("<user_id><![CDATA[").append(loginCode).append("]]></user_id>\r\n");
					valueXmlString.append("<user_level><![CDATA[").append(userLevel).append("]]></user_level>\r\n");

					sql = "SELECT DESCR FROM SITE WHERE SITE_CODE  = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, loginSiteCode);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						description = checkNull(rs.getString("DESCR"));
					}
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}

					if (Integer.parseInt(userLevel) > 1) {

						valueXmlString.append("<site_code__from protect=\"0\"><![CDATA[").append(loginSiteCode).append("]]></site_code__from>\r\n");

						valueXmlString.append("<site_descr__from protect=\"1\"><![CDATA[").append(description).append("]]></site_descr__from>\r\n");
						valueXmlString.append("<site_code__to protect=\"1\"><![CDATA[").append(loginSiteCode).append("]]></site_code__to>\r\n");
						valueXmlString.append("<site_descr__to protect=\"1\"><![CDATA[").append(description).append("]]></site_descr__to>\r\n");
					} else {
						valueXmlString.append("<site_code__from protect=\"0\"><![CDATA[").append(loginSiteCode).append("]]></site_code__from>\r\n");
						valueXmlString.append("<site_descr__from protect=\"0\"><![CDATA[").append(description).append("]]></site_descr__from>\r\n");
						valueXmlString.append("<site_code__to protect=\"0\"><![CDATA[").append(loginSiteCode).append("]]></site_code__to>\r\n");
						valueXmlString.append("<site_descr__to protect=\"0\"><![CDATA[").append(description).append("]]></site_descr__to>\r\n");
					}

					valueXmlString.append("<site_descr__from><![CDATA[").append("").append("]]></site_descr__from>\r\n");
					valueXmlString.append("<site_descr__to><![CDATA[").append("").append("]]></site_descr__to>\r\n");
					valueXmlString.append("<proc_group__from><![CDATA[").append("").append("]]></proc_group__from>\r\n");
					valueXmlString.append("<proc_group__fr_t><![CDATA[").append("").append("]]></proc_group__fr_t>\r\n");
					valueXmlString.append("<proc_group__to><![CDATA[").append("").append("]]></proc_group__to>\r\n");
					valueXmlString.append("<proc_group__to_t><![CDATA[").append("").append("]]></proc_group__to_t>\r\n");
					valueXmlString.append("<adjust_loan><![CDATA[").append("Y").append("]]></adjust_loan>\r\n");
					valueXmlString.append("<full_amt><![CDATA[").append("Y").append("]]></full_amt>\r\n");
					valueXmlString.append("<unapp_loans><![CDATA[").append("Y").append("]]></unapp_loans>\r\n");
					valueXmlString.append("<resigned><![CDATA[").append("N").append("]]></resigned>\r\n");
					valueXmlString.append("<payroll_voucher><![CDATA[").append("V").append("]]></payroll_voucher>\r\n");
					valueXmlString.append("<payroll_prd protect=\"1\"><![CDATA[").append("").append("]]></payroll_prd>\r\n");
					valueXmlString.append("<bank_code><![CDATA[").append("").append("]]></bank_code>\r\n");
					valueXmlString.append("<cont_vouch><![CDATA[").append("Y").append("]]></cont_vouch>\r\n");
					valueXmlString.append("<pay_mode><![CDATA[").append("").append("]]></pay_mode>\r\n");

					valueXmlString.append("<user_xtra_parms><![CDATA[").append(xtraParams).append("]]></user_xtra_parms>\r\n");
				} else if (currentColumn.equalsIgnoreCase("prd_code")) {
					prdCode = checkNull(genericUtility.getColumnValue("prd_code", dom, "1"));
					if (prdCode.trim().length() > 0) {
						sql = "SELECT FR_DATE FROM PERIOD WHERE CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, prdCode);
						rs = pstmt.executeQuery();
						if (rs.next()) {
							dateFrom = rs.getDate("FR_DATE");
						}
						if (rs != null) {
							rs.close();
							rs = null;
						}
						if (pstmt != null) {
							pstmt.close();
							pstmt = null;
						}
						if (dateFrom != null) {
							fromDate = sdf.format(dateFrom);
						}
						valueXmlString.append("<date_from><![CDATA[").append(fromDate).append("]]></date_from>\r\n");
					}
				} else if (currentColumn.equalsIgnoreCase("emp_code__from")) {
					empCodeFrom = checkNull(genericUtility.getColumnValue("emp_code__from", dom, "1"));
					sql = "SELECT EMP_FNAME, EMP_MNAME, EMP_LNAME FROM EMPLOYEE WHERE EMP_CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCodeFrom);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						empFName = rs.getString("EMP_FNAME");
						empMName = rs.getString("EMP_MNAME");
						empLName = rs.getString("EMP_LNAME");
					}
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}
					empName = empFName.concat(" ").concat(empMName).concat(" ").concat(empLName);
					valueXmlString.append("<emp_name__from><![CDATA[").append(empName).append("]]></emp_name__from>\r\n");
					valueXmlString.append("<emp_code__to><![CDATA[").append(empCodeFrom).append("]]></emp_code__to>\r\n");
					valueXmlString.append("<emp_name__to><![CDATA[").append(empName).append("]]></emp_name__to>\r\n");
				} else if (currentColumn.equalsIgnoreCase("emp_code__to")) {
					empCodeTo = checkNull(genericUtility.getColumnValue("emp_code__to", dom, "1"));
					sql = "SELECT EMP_FNAME, EMP_MNAME, EMP_LNAME FROM EMPLOYEE WHERE EMP_CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCodeTo);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						empFName = rs.getString("EMP_FNAME");
						empMName = rs.getString("EMP_MNAME");
						empLName = rs.getString("EMP_LNAME");
					}
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}
					empName = empFName.concat(" ").concat(empMName).concat(" ").concat(empLName);
					valueXmlString.append("<emp_name__to><![CDATA[").append(empName).append("]]></emp_name__to>\r\n");
				} else if (currentColumn.equalsIgnoreCase("ad_code")) {
					adCode = checkNull(genericUtility.getColumnValue("ad_code", dom, "1"));

					sql = "SELECT DESCR FROM ALLWDEDN WHERE AD_CODE  = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, adCode);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						adCodeDescr = checkNull(rs.getString("DESCR"));
					}
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}

					valueXmlString.append("<ad_descr><![CDATA[").append(adCodeDescr).append("]]></ad_descr>\r\n");
				} else if (currentColumn.equalsIgnoreCase("site_code__from")) {
					siteCodeFrom = checkNull(genericUtility.getColumnValue("site_code__from", dom, "1"));
					sql = "SELECT DESCR FROM SITE WHERE SITE_CODE  = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCodeFrom);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						siteCodeFromDescr = checkNull(rs.getString("DESCR"));
					}
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}

					valueXmlString.append("<site_descr__from><![CDATA[").append(siteCodeFromDescr).append("]]></site_descr__from>\r\n");

					valueXmlString.append("<site_code__to><![CDATA[").append(siteCodeFrom).append("]]></site_code__to>\r\n");
					valueXmlString.append("<site_descr__to><![CDATA[").append(siteCodeFromDescr).append("]]></site_descr__to>\r\n");

				} else if (currentColumn.equalsIgnoreCase("site_code__to")) {
					siteCodeTo = checkNull(genericUtility.getColumnValue("site_code__to", dom, "1"));

					sql = "SELECT DESCR FROM SITE WHERE SITE_CODE  = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCodeTo);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						siteCodeToDescr = checkNull(rs.getString("DESCR"));
					}
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}

					valueXmlString.append("<site_descr__to><![CDATA[").append(siteCodeToDescr).append("]]></site_descr__to>\r\n");
				} else if (currentColumn.equalsIgnoreCase("payroll_voucher")) {
					payrollvoucher = checkNull(genericUtility.getColumnValue("payroll_voucher", dom, "1"));

					if (payrollvoucher.equalsIgnoreCase("V")) {
						valueXmlString.append("<payroll_prd protect=\"1\"><![CDATA[").append("").append("]]></payroll_prd>\r\n");
					} else {
						valueXmlString.append("<payroll_prd protect=\"0\"><![CDATA[").append("").append("]]></payroll_prd>\r\n");
					}
				} else if (currentColumn.equalsIgnoreCase("proc_group__from")) {
					procGroupFrom = checkNull(genericUtility.getColumnValue("proc_group__from", dom, "1"));

					adjPercentage = Double.parseDouble(adjPerc);
					lcBalanceAmt = Double.parseDouble(balanceAmt);
					balAmount = Double.parseDouble(amtBal);

					temp = (claimAmt * adjPercentage) / 100;
					System.out.println("temp:::::::" + temp);

					if (temp > lcBalanceAmt) {
						temp = lcBalanceAmt;
					}
					System.out.println("temp:::::::" + temp);
					if (balAmount < 0) {
						System.out.println("balAmount < 0:::::::"
										+ balAmount);
						balAmount = 0;
					}
					balAmt = String.valueOf(balAmount);

					lcTemp = String.valueOf(temp);

					if (temp >= balAmount) 
					{
						valueXmlString.append("<adj_amt><![CDATA[").append(balAmt).append("]]></adj_amt>\r\n");
						valueXmlString.append("<loan_adjamt><![CDATA[").append(balAmt).append("]]></loan_adjamt>\r\n");
						adjAmount = balAmt;
					} 
					else 
					{
						valueXmlString.append("<adj_amt><![CDATA[").append(lcTemp).append("]]></adj_amt>\r\n");
						valueXmlString.append("<loan_adjamt><![CDATA[").append(lcTemp).append("]]></loan_adjamt>\r\n");
						adjAmount = lcTemp;
					}

					double adjAmt = Double.parseDouble(adjAmount);

					lcAdj = lcAdj + adjAmt;
					balAmount = balAmount - adjAmt;
					sql = "SELECT DESCR FROM GENCODES WHERE FLD_NAME = 'PROC_GROUP' AND MOD_NAME = 'X' AND FLD_VALUE = ? AND ACTIVE = 'Y' ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, procGroupFrom);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						procGroupFromDescr = checkNull(rs.getString("DESCR"));
					}
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}

					valueXmlString.append("<proc_group__fr_t><![CDATA[").append(procGroupFromDescr).append("]]></proc_group__fr_t>\r\n");
				} else if (currentColumn.equalsIgnoreCase("proc_group__to")) {
					procGroupTo = checkNull(genericUtility.getColumnValue("proc_group__to", dom, "1"));

					sql = "SELECT DESCR FROM GENCODES WHERE FLD_NAME = 'PROC_GROUP' AND MOD_NAME = 'X' AND FLD_VALUE = ? AND ACTIVE = 'Y' ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, procGroupTo);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						procGroupToDescr = checkNull(rs.getString("DESCR"));
					}
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}
					System.out.println("procGroupToDescr....[" + procGroupToDescr.toString());
					valueXmlString.append("<proc_group__to_t><![CDATA[").append(procGroupToDescr).append("]]></proc_group__to_t>\r\n");
				}
				valueXmlString.append("</Detail1>\r\n");
			}
			break;
			case 2: {
				DecimalFormat df = new DecimalFormat("0.00");
				if (currentColumn.equalsIgnoreCase("itm_default")) {
					empCodeFrom = checkNull(genericUtility.getColumnValue("emp_code__from", dom1, "1"));
					empCodeTo = checkNull(genericUtility.getColumnValue("emp_code__to", dom1, "1"));
					siteCodeFrom = checkNull(genericUtility.getColumnValue("site_code__from", dom1, "1"));
					siteCodeTo = checkNull(genericUtility.getColumnValue("site_code__to", dom1, "1"));
					procGroupFrom = checkNull(genericUtility.getColumnValue("proc_group__from", dom1, "1"));
					procGroupTo = checkNull(genericUtility.getColumnValue("proc_group__to", dom1, "1"));
					adCode = checkNull(genericUtility.getColumnValue("ad_code", dom1, "1"));
					resigned = checkNull(genericUtility.getColumnValue("resigned", dom1, "1"));
					fullAmt = checkNull(genericUtility.getColumnValue("full_amt", dom1, "1"));
					fromDate = checkNull(genericUtility.getColumnValue("date_from", dom1, "1"));
					claimDate = checkNull(genericUtility.getColumnValue("claim_date", dom1, "1"));
					unappLoans = checkNull(genericUtility.getColumnValue("unapp_loans", dom1, "1"));
					contVouch = checkNull(genericUtility.getColumnValue("cont_vouch", dom1, "1"));
					adjustLoan = checkNull(genericUtility.getColumnValue("adjust_loan", dom1, "1"));

					if (empCodeFrom == null || empCodeFrom.length() == 0) {
						empCodeFrom = "0";
					}
					if (empCodeTo == null || empCodeTo.length() == 0) {
						empCodeTo = "ZZZZZZZZZZ";
					}
					if (siteCodeFrom == null || siteCodeFrom.length() == 0) {
						siteCodeFrom = "0";
					}
					if (siteCodeTo == null || siteCodeTo.length() == 0) {
						siteCodeTo = "ZZZZZ";
					}
					if (procGroupFrom == null || procGroupFrom.length() == 0) {
						procGroupFrom = "0";
					}
					if (procGroupTo == null || procGroupTo.length() == 0) {
						procGroupTo = "ZZZZZ";
					}
					if (resigned.equalsIgnoreCase("Y")) {
						resigned = "S";
					} else {
						resigned = " ";
					}
					
					if (fullAmt.equalsIgnoreCase("N")) {
						isNo = true;
					}
					fromDate = genericUtility.getValidDateTimeString(fromDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
					claimDate = genericUtility.getValidDateTimeString(claimDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());

					if (adjustLoan.equalsIgnoreCase("Y")) {
						lsAd1 = checkNull(admCommon.getEnv("999999", "LOAN_FROM", conn));
						
						if (!(lsAd1.equalsIgnoreCase("NULLFOUND"))) {
							lsAd2 = checkNull(admCommon.getEnv("999999", "LOAN_TO", conn));
						}
						
					}

					sql = "select allowdedn_bal.emp_code, ad_code, start_date, end_date, amt_bal, "
							+ " emp_fname, emp_lname, pay_site, employee.cadre , employee.grade, employee.supp_code__con "
							+ " from allowdedn_bal,employee where allowdedn_bal.emp_code = employee.emp_code "
							+ " and allowdedn_bal.emp_code between ? and ? and ad_code = ? and start_date = ? "
							+ " and amt_bal <> 0 and ref_type = 'K' and pay_site between ? and ? and proc_group between ? and ? "
							+ " and case when relieve_date is null then ' ' else 'S' end = ? "
							+ " and case when status is null then ' ' else status end <> 'S' and (exp_date is null or exp_date >= ? ) ";

					if (contVouch.equalsIgnoreCase("Y")) {
						sql = sql.concat(" and employee.supp_code__con is not null");
					} else {
						sql = sql.concat(" and employee.supp_code__con is null");
					}
					sql = sql.concat(" Order by allowdedn_bal.emp_code");

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCodeFrom);
					pstmt.setString(2, empCodeTo);
					pstmt.setString(3, adCode);
					pstmt.setTimestamp(4, java.sql.Timestamp.valueOf(fromDate));
					pstmt.setString(5, siteCodeFrom);
					pstmt.setString(6, siteCodeTo);
					pstmt.setString(7, procGroupFrom);
					pstmt.setString(8, procGroupTo);
					pstmt.setString(9, resigned);
					pstmt.setTimestamp(10, java.sql.Timestamp.valueOf(claimDate));
					System.out.println("sql" + sql);
					rs = pstmt.executeQuery();
					int minDbId = 0, maxDbId = 0;
					while (rs.next()) {
						minDbId = 0; maxDbId = 0;
						lcAdj = 0;
						lsEmp = checkNull(rs.getString("emp_code"));
						adCode = checkNull(rs.getString("ad_code"));
						startDate1 = rs.getDate("start_date");
						endDate1 = rs.getDate("end_date");
						
						amtBal = checkNull(rs.getString("amt_bal"));
						fname = checkNull(rs.getString("emp_fname"));
						lname = checkNull(rs.getString("emp_lname"));
						suppCodeCon = checkNull(rs.getString("supp_code__con"));
						paySite = checkNull(rs.getString("pay_site"));
						cadre = checkNull(rs.getString("cadre"));
						grade = checkNull(rs.getString("grade"));
						suppCodeCon = checkNull(rs.getString("supp_code__con"));

						startDate = sdf.format(startDate1);

						endDate = sdf.format(endDate1);

						Double amountBal = Double.parseDouble(amtBal);
						double tempAmt = rs.getDouble("amt_bal");
						amtBal = df.format(amountBal);

						String startDate4 = genericUtility.getValidDateTimeString(startDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());

						sql1 = "Select count(1) as li_count from allowdedn_bal Where emp_code = ? "
								+ "and ad_code = ? and start_date < ? and end_date < ? and amt_bal <> 0	";
						prestmt = conn.prepareStatement(sql1);
						prestmt.setString(1, lsEmp);
						prestmt.setString(2, adCode);
						prestmt.setTimestamp(3, java.sql.Timestamp.valueOf(startDate4));
						prestmt.setTimestamp(4, java.sql.Timestamp.valueOf(startDate4));
						
						rs1 = prestmt.executeQuery();
						if (rs1.next()) {
							count = rs1.getInt("li_count");
						}
						if (rs1 != null) {
							rs1.close();
							rs1 = null;
						}
						if (prestmt != null) {
							prestmt.close();
							prestmt = null;
						}
						
						if (count > 0) {
							continue;
						}
						lsEnvName = adCode.toUpperCase() + "_CLAIMCURRPRD";

						Timestamp claimDate2 = Timestamp.valueOf(claimDate);
						canClaimInSameYear = checkNull(admCommon.getAdmEnv(paySite, cadre, grade, lsEnvName, claimDate2, conn));
						
						if (canClaimInSameYear.equalsIgnoreCase("NULLFOUND")) {
							
							canClaimInSameYear = checkNull(admCommon.getEnv("999999", lsEnvName, conn));
							

							if (canClaimInSameYear.equalsIgnoreCase("NULLFOUND")) {
								
								continue;
							}
						} else if (canClaimInSameYear == null || canClaimInSameYear.length() == 0) {
							System.out.println("Errcode = ''Employee ' " + lsEmp + " ' not processed due to Could not fetch environment  (' " + lsEnvName + "') from site_env table'");
							continue;
						} else {
							canClaimInSameYear = canClaimInSameYear.trim().toUpperCase();
							if (!(resigned.equalsIgnoreCase("S"))) {
								if (!(canClaimInSameYear.equalsIgnoreCase("Y")) && (endDate1.after(claimDate2))) {
									System.out.println("Errcode = Employee ' " + lsEmp + " ' not processed because of could not claim after claim date' ");
									continue;
								}
							}
						}

						
						llCurFlag = 0;
						llCurrFlag = 0;
						lcClaimamt = amtBal;  // Modified on 07/04/2017
						claimAmt = Double.parseDouble(lcClaimamt);  // Modified on 07/04/2017
						balAmount = Double.parseDouble(amtBal);  // Modified on 07/04/2017
						lcAdj = 0; //Modified by Ahmed on 07/04/2017
						if (adjustLoan.equalsIgnoreCase("Y")) {
							li_xx = 0;
							sql1 = "Select loan_no from loans where emp_code = ? and loans.balance_amt > 0 and loans.adjustable = 'Y' and status= 'A' ";
							prestmt = conn.prepareStatement(sql1);
							prestmt.setString(1, lsEmp);
							rs1 = prestmt.executeQuery();
							while (rs1.next()) {
								loanNo = checkNull(rs1.getString("loan_no"));
								System.out.println("loanNo....[" + loanNo + "]");

								//lcClaimamt = amtBal; // Modified on 07/04/2017

								lc_adj = 0;
								ll_ctr = 0;
								
								//lcAdj = 0; // Modified by Ahmed on 07/04/2017

								sql2 = "select count(1) as ll_ctr from loan_adj where loan_no = ? ";
								pstmt2 = conn.prepareStatement(sql2);
								pstmt2.setString(1, loanNo);

								rs2 = pstmt2.executeQuery();

								if (rs2.next()) {
									ll_ctr = rs2.getInt("ll_ctr");
								}
								if (rs2 != null) {
									rs2.close();
									rs2 = null;
								}
								if (pstmt2 != null) {
									pstmt2.close();
									pstmt2 = null;
								}
								System.out.println("ll_ctr....[" + ll_ctr + "]");
								if (ll_ctr > 0) {
									sql3 = "Select allowdedn_bal.ad_code, loan_adj.adj_perc, allowdedn_bal.ref_no, allowdedn_bal.start_date,"
											+ "allowdedn_bal.end_date, loans.scheme_no, loans.loan_amt, loans.mon_inst, loans.interest, loans.balance_amt "
											+ " from allowdedn_bal, loans, loan_adj "
											+ "where (allowdedn_bal.ref_no = loans.loan_no)"
											+ "and (loans.loan_no = loan_adj.loan_no)	"
											+ "and (allowdedn_bal.ref_no = ? )"
											+ "and (loan_adj.ad_code = ? )"
											+ "and (allowdedn_bal.ad_code between ? and ? )"
											+ "and  (? between loan_adj.eff_date and loan_adj.exp_date)"
											+ "and (allowdedn_bal.amt_bal > 0)	"
											+ "and (allowdedn_bal.ref_type = 'L')"
											+ "and (loans.adjustable = 'Y')"
											+ "Order by end_date  ";

									pstmt3 = conn.prepareStatement(sql3);
									pstmt3.setString(1, loanNo);
									pstmt3.setString(2, adCode);
									pstmt3.setString(3, lsAd1);
									pstmt3.setString(4, lsAd2);
									pstmt3.setTimestamp(5, java.sql.Timestamp.valueOf(claimDate));

									rs3 = pstmt3.executeQuery();

									llCurFlag = llCurFlag + 1;

									while (rs3.next()) {
										adCode1 = checkNull(rs3.getString("ad_code"));
										adjPerc = checkNull(rs3.getString("adj_perc"));
										ref_no = checkNull(rs3.getString("ref_no"));
										startDate2 = rs3.getDate("start_date");
										endDate2 = rs3.getDate("end_date");
										schemeNo = checkNull(rs3.getString("scheme_no"));
										loanAmt = checkNull(rs3.getString("loan_amt"));
										monInst = checkNull(rs3.getString("mon_inst"));
										interest = checkNull(rs3.getString("interest"));
										balanceAmt = checkNull(rs3.getString("balance_amt"));

										double balAmt1 = Double.parseDouble(balanceAmt);
										balanceAmt = df.format(balAmt1);

										startDate3 = sdf.format(startDate2);

										endDate3 = sdf.format(endDate2);

										sql4 = "SELECT DESCR FROM ALLWDEDN WHERE AD_CODE = ? ";

										pstmt4 = conn.prepareStatement(sql4);
										pstmt4.setString(1, adCode1);
										rs4 = pstmt4.executeQuery();
										String adDescr = "";

										if (rs4.next()) {
											adDescr = rs4.getString("DESCR");
										}
										if (rs4 != null) {
											rs4.close();
											rs4 = null;
										}
										if (pstmt4 != null) {
											pstmt4.close();
											pstmt4 = null;
										}

										li_xx = li_xx + 1;
										lineNo = String.valueOf(li_xx);
										if(minDbId == 0) {
											minDbId = domId;
										}
										
										if(maxDbId < domId) {
											maxDbId = domId;
										}
										System.out.println("lineNo in If Detail3 : " + lineNo);
										valueXmlString.append("<Detail3 domID='" + domId + "' dbID='' objContext='3' objName='" + objNameDefault + "' selected='Y'>\r\n");
										valueXmlString.append("<tran_id><![CDATA[").append(lsEmp).append("]]></tran_id>\r\n");
										valueXmlString.append("<line_no><![CDATA[").append(lineNo).append("]]></line_no>\r\n");
										valueXmlString.append("<ad_code><![CDATA[").append(adCode1).append("]]></ad_code>\r\n");
										valueXmlString.append("<eff_date><![CDATA[").append(startDate3).append("]]></eff_date>\r\n");
										valueXmlString.append("<end_date><![CDATA[").append(endDate3).append("]]></end_date>\r\n");
										valueXmlString.append("<bal_amt><![CDATA[").append(balanceAmt).append("]]></bal_amt>\r\n");
										valueXmlString.append("<ref_no><![CDATA[").append(ref_no).append("]]></ref_no>\r\n");
										valueXmlString.append("<ref_type><![CDATA[").append("L").append("]]></ref_type>\r\n");
										valueXmlString.append("<start_date><![CDATA[").append(startDate3).append("]]></start_date>\r\n");
										valueXmlString.append("<scheme_no><![CDATA[").append(schemeNo).append("]]></scheme_no>\r\n");
										valueXmlString.append("<interest><![CDATA[").append(interest).append("]]></interest>\r\n");
										valueXmlString.append("<mon_inst><![CDATA[").append(monInst).append("]]></mon_inst>\r\n");
										valueXmlString.append("<loan_amt><![CDATA[").append(loanAmt).append("]]></loan_amt>\r\n");
										valueXmlString.append("<adj_perc><![CDATA[").append(adjPerc).append("]]></adj_perc>\r\n");

										valueXmlString.append("<claim_amt><![CDATA[").append(amtBal).append("]]></claim_amt>\r\n");
										 
										valueXmlString.append("<ad_descr><![CDATA[").append(adDescr).append("]]></ad_descr>\r\n");

										// claimAmt = Double.parseDouble(lcClaimamt); // Modified on 07/04/2017
										adjPercentage = Double.parseDouble(adjPerc);
										lcBalanceAmt = Double.parseDouble(balanceAmt);
										// balAmount = Double.parseDouble(amtBal); // Modified on 07/04/2017



										temp = (claimAmt * adjPercentage) / 100;
										System.out.println("temp:::::::" + temp);

										if (temp > lcBalanceAmt) {
											temp = lcBalanceAmt;
										}
										System.out.println("temp:::::::" + temp);
										if (balAmount < 0) {
											System.out.println("balAmount < 0:::::::"
															+ balAmount);
											balAmount = 0;
										}
										balAmt = String.valueOf(balAmount);


										lcTemp = String.valueOf(temp);


										if (temp >= balAmount) 
										{

											valueXmlString.append("<adj_amt><![CDATA[").append(balAmt).append("]]></adj_amt>\r\n");
											valueXmlString.append("<loan_adjamt><![CDATA[").append(balAmt).append("]]></loan_adjamt>\r\n");
											adjAmount = balAmt;
										} 
										else 
										{
											valueXmlString.append("<adj_amt><![CDATA[").append(lcTemp).append("]]></adj_amt>\r\n");
											valueXmlString.append("<loan_adjamt><![CDATA[").append(lcTemp).append("]]></loan_adjamt>\r\n");
											adjAmount = lcTemp;
										}

										double adjAmt = Double.parseDouble(adjAmount);

										lcAdj = lcAdj + adjAmt;
										balAmount = balAmount - adjAmt;
										System.out.println("balAmount AFTER ADJUSTMENT:::::::["+balAmount+"]");
										
										valueXmlString.append("</Detail3>\r\n");
										domId = domId + 1;
									}
									if (rs3 != null) {
										rs3.close();
										rs3 = null;
									}
									if (pstmt3 != null) {
										pstmt3.close();
										pstmt3 = null;
									}
								} else {
									
									sql4 = "select allowdedn_bal.ad_code, allwdedn.descr, loans.adj_perc, allowdedn_bal.ref_no, allowdedn_bal.start_date, allowdedn_bal.end_date, loans.scheme_no, loans.loan_amt, loans.mon_inst, loans.interest, nvl(balance_amt, 0) as balance_amt "
											+ " from allowdedn_bal, loans, allwdedn "
											+ " where allowdedn_bal.ref_no = loans.loan_no and allowdedn_bal.ad_code = allwdedn.ad_code "
											+ " and allowdedn_bal.ref_no   = ? and allowdedn_bal.ad_code between ? and ? "
											+ " and allowdedn_bal.amt_bal    > 0 and allowdedn_bal.ref_type   = 'L' AND loans.adjustable = 'Y' ORDER BY end_date";

									pstmt4 = conn.prepareStatement(sql4);
									pstmt4.setString(1, loanNo);
									pstmt4.setString(2, lsAd1);
									pstmt4.setString(3, lsAd2);

									rs4 = pstmt4.executeQuery();

									llCurrFlag = llCurrFlag + 1;

									while (rs4.next()) {
										String adDescr = checkNull(rs4.getString("descr"));
										adCode1 = checkNull(rs4.getString("ad_code"));
										adjPerc = checkNull(rs4.getString("adj_perc"));
										ref_no = checkNull(rs4.getString("ref_no"));
										startDate2 = rs4.getDate("start_date");
										endDate2 = rs4.getDate("end_date");
										schemeNo = checkNull(rs4.getString("scheme_no"));
										loanAmt = checkNull(rs4.getString("loan_amt"));
										monInst = checkNull(rs4.getString("mon_inst"));
										interest = checkNull(rs4.getString("interest"));
										balanceAmt = checkNull(rs4.getString("balance_amt"));
										System.out.println("adCode1....["+adCode1 +"]");
										System.out.println("adjPerc....["+adjPerc+"]");
										System.out.println("ref_no::::::"+ref_no+"]");
										 System.out.println("startDate2....["+startDate2+"]");
										 System.out.println("endDate2....["+endDate2+"]");
										 System.out.println("schemeNo....["+schemeNo+"]");
										 System.out.println("loanAmt....["+loanAmt+"]");
										 System.out.println("monInst::::::"+monInst+"]");
										 System.out.println("interest....["+interest+"]");
										 System.out.println("balanceAmt:::::::["+balanceAmt+"]");
										 


										double balAmt1 = Double.parseDouble(balanceAmt);
										balanceAmt = df.format(balAmt1);

										startDate3 = sdf.format(startDate2);


										endDate3 = sdf.format(endDate2);

										li_xx = li_xx + 1;
										lineNo = String.valueOf(li_xx);
										
										if(minDbId == 0) 
										{
											minDbId = domId;
										}
										
										if(maxDbId < domId) {
											maxDbId = domId;
										}
										
										System.out.println("lineNo from Else Detail3 " + lineNo);
										valueXmlString.append("<Detail3 domID='" + domId + "' dbID='' objContext='3' objName='" + objNameDefault + "' selected='Y'>\r\n");
										valueXmlString.append("<tran_id><![CDATA[").append(lsEmp).append("]]></tran_id>\r\n");
										valueXmlString.append("<line_no><![CDATA[").append(lineNo).append("]]></line_no>\r\n");
										valueXmlString.append("<ad_code><![CDATA[").append(adCode1).append("]]></ad_code>\r\n");
										valueXmlString.append("<eff_date><![CDATA[").append(startDate3).append("]]></eff_date>\r\n");
										valueXmlString.append("<end_date><![CDATA[").append(endDate3).append("]]></end_date>\r\n");
										valueXmlString.append("<bal_amt><![CDATA[").append(balanceAmt).append("]]></bal_amt>\r\n");
										valueXmlString.append("<ref_no><![CDATA[").append(ref_no).append("]]></ref_no>\r\n");
										valueXmlString.append("<ref_type><![CDATA[").append("L").append("]]></ref_type>\r\n");
										valueXmlString.append("<start_date><![CDATA[").append(startDate3).append("]]></start_date>\r\n");
										valueXmlString.append("<scheme_no><![CDATA[").append(schemeNo).append("]]></scheme_no>\r\n");
										valueXmlString.append("<interest><![CDATA[").append(interest).append("]]></interest>\r\n");
										valueXmlString.append("<mon_inst><![CDATA[").append(monInst).append("]]></mon_inst>\r\n");
										valueXmlString.append("<loan_amt><![CDATA[").append(loanAmt).append("]]></loan_amt>\r\n");
										valueXmlString.append("<adj_perc><![CDATA[").append(adjPerc).append("]]></adj_perc>\r\n");
										
										valueXmlString.append("<claim_amt><![CDATA[").append(amtBal).append("]]></claim_amt>\r\n");
										valueXmlString.append("<ad_descr><![CDATA[").append(adDescr).append("]]></ad_descr>\r\n");
										
										//claimAmt = Double.parseDouble(lcClaimamt); // Modified on 07/04/2017
										adjPercentage = Double.parseDouble(adjPerc);
										lcBalanceAmt = Double.parseDouble(balanceAmt);
										//balAmount = Double.parseDouble(amtBal); // Modified on 07/04/2017


										temp = (claimAmt * adjPercentage) / 100;
										System.out.println("temp:::::::" + temp);

										if (temp > lcBalanceAmt) {
											temp = lcBalanceAmt;
										}
										System.out.println("temp:::::::" + temp);
										if (balAmount < 0) {
											System.out.println("balAmount < 0:::::::"+ balAmount);
											balAmount = 0;
										}
										balAmt = String.valueOf(balAmount);

										lcTemp = String.valueOf(temp);

										if (temp >= balAmount) 
										{
											valueXmlString.append("<adj_amt><![CDATA[").append(balAmt).append("]]></adj_amt>\r\n");
											valueXmlString.append("<loan_adjamt><![CDATA[").append(balAmt).append("]]></loan_adjamt>\r\n");
											adjAmount = balAmt;
										} 
										else 
										{
											valueXmlString.append("<adj_amt><![CDATA[").append(lcTemp).append("]]></adj_amt>\r\n");
											valueXmlString.append("<loan_adjamt><![CDATA[").append(lcTemp).append("]]></loan_adjamt>\r\n");
											adjAmount = lcTemp;
										}

										double adjAmt = Double.parseDouble(adjAmount);

										lcAdj = lcAdj + adjAmt;
										// Modified on 07/04/2017.Start
										/*
										claimAmt = claimAmt - adjAmt;  
										lcClaimamt = df.format(claimAmt);
										System.out.println("lcClaimamt AFTER ADJUSTMENT:::::::["+lcClaimamt+"]");
										*/
										balAmount = balAmount - adjAmt;
										System.out.println("balAmount AFTER ADJUSTMENT:::::::["+balAmount+"]");
										
										valueXmlString.append("</Detail3>\r\n");
										domId = domId + 1;
									}
								}
							}
							loanAdj = 0.0;

							if (rs1 != null) {
								rs1.close();
								rs1 = null;
							}
							if (prestmt != null) {
								prestmt.close();
								prestmt = null;
							}
						}


						li_xx1 = li_xx1 + 1;
						lineNo = String.valueOf(li_xx1);

						System.out.println("lineNo::::::::::" + lineNo);
						HashMap detailHashMap = new HashMap();
						valueXmlString.append("<Detail2 domID='" + domId1 + "' dbID='' objContext='2' objName='" + objNameDefault + "' selected='Y'>\r\n");
						valueXmlString.append("<emp_code><![CDATA[").append(lsEmp).append("]]></emp_code>\r\n");
						valueXmlString.append("<fname><![CDATA[").append(fname).append("]]></fname>\r\n");
						valueXmlString.append("<lname><![CDATA[").append(lname).append("]]></lname>\r\n");
						valueXmlString.append("<ad_code><![CDATA[").append(adCode).append("]]></ad_code>\r\n");
						valueXmlString.append("<eff_date><![CDATA[").append(startDate).append("]]></eff_date>\r\n");
						valueXmlString.append("<bal_amt><![CDATA[").append(amtBal).append("]]></bal_amt>\r\n");
						
						valueXmlString.append("<claim_amt protect=\"1\"><![CDATA[").append(amtBal).append("]]></claim_amt>\r\n");

						loanAdjust = df.format(lcAdj);
						valueXmlString.append("<loan_adjamt><![CDATA[").append(loanAdjust).append("]]></loan_adjamt>\r\n");

						firstLoanAdjust = 0.0;
						loanAdj = 0.0d;

						if (adjustLoan != null && adjustLoan.equalsIgnoreCase("Y") && llCurFlag + llCurrFlag > 0) {
							valueXmlString.append("<adjust_loan><![CDATA[").append("Y").append("]]></adjust_loan>\r\n");
						} else {
							valueXmlString.append("<adjust_loan><![CDATA[").append("N").append("]]></adjust_loan>\r\n");
						}
						loanAdjust = "";

						valueXmlString.append("<contcode><![CDATA[").append(suppCodeCon).append("]]></contcode>\r\n");
						valueXmlString.append("<tran_id><![CDATA[").append(lsEmp).append("]]></tran_id>\r\n");
						valueXmlString.append("<full_amt><![CDATA[").append(fullAmt).append("]]></full_amt>\r\n");
						valueXmlString.append("<line_no><![CDATA[").append(lineNo).append("]]></line_no>\r\n");
						valueXmlString.append("<payroll_voucher><![CDATA[").append("").append("]]></payroll_voucher>\r\n");
						valueXmlString.append("<chg_date><![CDATA[").append("").append("]]></chg_date>\r\n");
						valueXmlString.append("<chg_user><![CDATA[").append("").append("]]></chg_user>\r\n");
						valueXmlString.append("<chg_term><![CDATA[").append("").append("]]></chg_term>\r\n");
						valueXmlString.append("<ref_no><![CDATA[").append("").append("]]></ref_no>\r\n");
						valueXmlString.append("<end_date><![CDATA[").append(endDate).append("]]></end_date>\r\n");
						valueXmlString.append("<tran_date><![CDATA[").append(curDate).append("]]></tran_date>\r\n");
						
						valueXmlString.append("<minDbId><![CDATA[").append(minDbId).append("]]></minDbId>\r\n");
						valueXmlString.append("<maxDbId><![CDATA[").append(maxDbId).append("]]></maxDbId>\r\n");
						valueXmlString.append("</Detail2>\r\n");
						domId1 = domId1 + 1;

					}
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}
				}

			}
				break;

			}
		}
		catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception in "
					+ this.getClass().getSimpleName() + " -itemChange(D) ["
					+ e.getMessage() + "]");
			throw new ITMException(e);
		}
		finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
				if (rs1 != null) {
					rs1.close();
					rs1 = null;
				}
				if (prestmt != null) {
					prestmt.close();
					prestmt = null;
				}
				if (rs2 != null) {
					rs2.close();
					rs2 = null;
				}
				if (pstmt2 != null) {
					pstmt2.close();
					pstmt2 = null;
				}
				if (rs3 != null) {
					rs3.close();
					rs3 = null;
				}
				if (pstmt3 != null) {
					pstmt3.close();
					pstmt3 = null;
				}

			} catch (Exception e) {
				System.out
						.println("[PerkClaimProcess][itemChanged]Exception ::"
								+ e);
				e.printStackTrace();
			}
		}

		valueXmlString.append("</Root>\r\n");
		System.out.println("valueXmlString....[" + valueXmlString.toString());
		return valueXmlString.toString();

	}

	
	public String wfValData() throws RemoteException, ITMException {
		return "";
	}

	public String wfValData(String xmlString, String xmlString1,
			String xmlString2, String objContext, String editFlag,
			String xtraParams) throws RemoteException, ITMException {
		System.out.println("Came Inside 1 wfValData:::");

		E12GenericUtility genericUtility = new E12GenericUtility();

		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		System.out.println("xmlString [" + xmlString + "]");
		System.out.println("xmlString1[" + xmlString1 + "]");
		System.out.println("xmlString2[" + xmlString2 + "]");
		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				dom = parseString(xmlString);
			} else {
				System.out.println("xmlstring is null");
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) {
				dom1 = parseString(xmlString1);
			} else {
				System.out.println("xmlstring1 is null");
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				dom2 = parseString(xmlString2);
			} else {
				System.out.println("xmlstring2 is null");
			}
			System.out.println("Before call valdata");
			errString = wfValData(dom, dom1, dom2, objContext, editFlag,
					xtraParams);
		} catch (Exception e) {
			System.out
					.println("Exception : [PerkClaimProcess][wfValData(String xmlString)] : ==>\n"
							+ e.getMessage());
			e.printStackTrace();
			errString = genericUtility.createErrorString(e);

		}
		return (errString);
	}

	@SuppressWarnings("unchecked")
	public String wfValData(Document dom, Document dom1, Document dom2,
			String objContext, String editFlag, String xtraParams)
			throws RemoteException, ITMException {

		Node parentNode = null;
		Node childNode = null;

		NodeList parentNodeList = null;
		NodeList childNodeList = null;

		String errString = "";
		String childNodeName = "";

		int currentFormNo = 0;
		int childNodeListLength = 0;

		String msgType = "";
		String errCode = "";
		String errFldName = "";
		StringBuffer errStringXml = new StringBuffer(
				"<?xml version=\"1.0\"?>\r\n<Root><Errors>");

		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		ArrayList<String> errListEmp = new ArrayList<String>();

		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		String sql1 = "";
		PreparedStatement prestmt = null;
		ResultSet rs1 = null;

		String sql2 = "";
		PreparedStatement pstmt2 = null;
		ResultSet rs2 = null;

		int cnt = 0;
		int ctr = 0;
		int count = 0;

		String userId = "";
		String empCodeFrom = "";
		String empCodeTo = "";
		String siteCodeFrom = "";
		String siteCodeTo = "";
		String procGroupFrom = "";
		String procGroupTo = "";
		String adCode = "";
		String resigned = "";
		String fullAmt = "";
		String fromDate = "";
		String claimDate = "";
		String unappLoans = "";
		String contVouch = "";
		String adjustLoan = "";
		String lsAd1 = "";
		String lsAd2 = "";
		String lsEmp = "";
		String startDate = "";
		String endDate = "";
		String amtBal = "";
		String paySite = "";
		String cadre = "";
		String grade = "";
		String suppCodeCon = "";
		String prdCode = "";
		String payrollvoucher = "";

		java.util.Date startDate1 = null;
		java.util.Date endDate1 = null;
		String lsEnvName = "";
		String canClaimInSameYear = "";
		String claimDate1 = "";
		java.util.Date claimDate3 = null;

		E12GenericUtility genericUtility = new E12GenericUtility();
		AdmCommon admCommon = new AdmCommon();

		Connection conn = null;

		try {

			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			conn.setAutoCommit(false);

			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}

			SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());

			switch (currentFormNo) {
			case 1: {
				parentNodeList = dom.getElementsByTagName("Detail"
						+ currentFormNo);
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				
				detail1Loop:
				for (ctr = 0; ctr < childNodeListLength; ctr++) {
					childNode = childNodeList.item(ctr);

					System.out.println("childNode" + childNode);
					if (childNode.getNodeType() != Node.ELEMENT_NODE) {
						continue;
					}

					childNodeName = childNode.getNodeName();

					if (childNodeName.equalsIgnoreCase("site_code__to")) {
						count = 0;
						prdCode = checkNull(genericUtility.getColumnValue(
								"prd_code", dom1, objContext));
						System.out.println("prdCode:::::" + prdCode);

						if (prdCode == null || prdCode.length() == 0) {
							System.out.println("period code null:::");

							errList.add("VPINVPRD1");
							errFields.add("prd_code");

							msgType = errorType(conn, "VPINVPRD1");
							if (msgType.equalsIgnoreCase("E")) {
								break;
							}
						} else {
							sql = "SELECT COUNT(1) AS PRD_COUNT FROM PERIOD WHERE CODE = ? ";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, prdCode);

							rs = pstmt.executeQuery();

							if (rs.next()) {
								count = rs.getInt("PRD_COUNT");
							}
							if (rs != null) {
								rs.close();
								rs = null;
							}
							if (pstmt != null) {
								pstmt.close();
								pstmt = null;
							}

							System.out.println("count::::::::[" + count + "]");

							if (count <= 0) {
								System.out
										.println("period code not present in period master:::");

								errList.add("VPINVPRDCD");
								errFields.add("prd_code");

								msgType = errorType(conn, "VPINVPRDCD");
								if (msgType.equalsIgnoreCase("E")) {
									break;
								}
							}
						}

						count = 0;
						empCodeFrom = checkNull(genericUtility.getColumnValue(
								"emp_code__from", dom1, objContext));
						System.out.println("empCodeFrom:::::" + empCodeFrom);

						if (empCodeFrom == null || empCodeFrom.length() == 0) {
							System.out.println("empCodeFrom code null:::");

							errList.add("VPINVEMP3");
							errFields.add("emp_code__from");

							msgType = errorType(conn, "VPINVEMP3");
							if (msgType.equalsIgnoreCase("E")) {
								break;
							}
						}

						count = 0;
						empCodeTo = checkNull(genericUtility.getColumnValue(
								"emp_code__to", dom1, objContext));
						System.out.println("empCodeTo:::::" + empCodeTo);

						if (empCodeTo == null || empCodeTo.length() == 0) {
							System.out.println("empCodeTo code null:::");

							errList.add("VPINVEMP4");
							errFields.add("emp_code__to");

							msgType = errorType(conn, "VPINVEMP4");
							if (msgType.equalsIgnoreCase("E")) {
								break;
							}
						}

						count = 0;
						adCode = checkNull(genericUtility.getColumnValue(
								"ad_code", dom1, objContext));
						System.out.println("adCode:::::" + adCode);

						if (adCode == null || adCode.length() == 0) {
							System.out.println("adCode code null:::");

							errList.add("VPINVADCD1");
							errFields.add("ad_code");

							msgType = errorType(conn, "VPINVADCD1");
							if (msgType.equalsIgnoreCase("E")) {
								break;
							}
						} else {
							sql = "SELECT COUNT(1) AS ADCODE_COUNT FROM ALLWDEDN WHERE AD_CODE = ? ";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, adCode);

							rs = pstmt.executeQuery();

							if (rs.next()) {
								count = rs.getInt("ADCODE_COUNT");
							}
							if (rs != null) {
								rs.close();
								rs = null;
							}
							if (pstmt != null) {
								pstmt.close();
								pstmt = null;
							}
							System.out.println("count::::::::[" + count + "]");

							if (count <= 0) {
								System.out
										.println("ADCODE not present in allwdedn master:::");

								errList.add("VPINVADCD");
								errFields.add("ad_code");

								msgType = errorType(conn, "VPINVADCD");
								if (msgType.equalsIgnoreCase("E")) {
									break;
								}
							}
							String adCodeForClaimWOLoanAdj = checkNull(admCommon
									.getEnv("999999", "CLAIMAD_WO_LOANADJ",
											conn));
							System.out.println("CLAIMAD_WO_LOANADJ....["
									+ adCodeForClaimWOLoanAdj + "]");
							if (adCodeForClaimWOLoanAdj.length() > 0) {
								ArrayList adCodeListForClaimWOLoanAdj = new ArrayList(
										Arrays.asList(adCodeForClaimWOLoanAdj
												.split(",")));
								if (adCodeListForClaimWOLoanAdj
										.contains(adCode)) {
									System.out
											.println("AD Code for loan without adjustment:::");

									errList.add("VPPERKAD1");
									errFields.add("ad_code");

									msgType = errorType(conn, "VPPERKAD1");
									break;
								}
							}
						}
						count = 0;
						siteCodeFrom = checkNull(genericUtility.getColumnValue(
								"site_code__from", dom1, objContext));
						System.out.println("siteCodeFrom:::::" + siteCodeFrom);

						if (siteCodeFrom == null || siteCodeFrom.length() == 0) {
							System.out.println("siteCodeFrom code null:::");

							errList.add("VPINVSITE2");
							errFields.add("site_code__from");

							msgType = errorType(conn, "VPINVSITE2");
							if (msgType.equalsIgnoreCase("E")) {
								break;
							}
						}

						count = 0;
						siteCodeTo = checkNull(genericUtility.getColumnValue(
								"site_code__to", dom1, objContext));
						System.out.println("siteCodeTo:::::" + siteCodeTo);

						if (siteCodeTo == null || siteCodeTo.length() == 0) {
							System.out.println("siteCodeFrom code null:::");

							errList.add("VPINVSITE3");
							errFields.add("site_code__to");

							msgType = errorType(conn, "VPINVSITE3");
							if (msgType.equalsIgnoreCase("E")) {
								break;
							}
						}

						payrollvoucher = checkNull(genericUtility
								.getColumnValue("payroll_voucher", dom1,
										objContext));
						System.out.println("payrollvoucher:::::"
								+ payrollvoucher);

						if (payrollvoucher.equalsIgnoreCase("P")) {
							String payrollPrd = checkNull(genericUtility
									.getColumnValue("payroll_prd", dom1,
											objContext));
							System.out.println("payrollPrd:::::" + payrollPrd);

							if (payrollPrd == null || payrollPrd.length() == 0) {
								System.out.println("payrollPrd blank:::");

								errList.add("VPINPAYPRD");
								errFields.add("payroll_prd");

								msgType = errorType(conn, "VPINPAYPRD");
								if (msgType.equalsIgnoreCase("E")) {
									break;
								}
							} else {
								sql = "SELECT COUNT(1) AS PRD_COUNT FROM PERIOD WHERE CODE = ? ";

								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, payrollPrd);

								rs = pstmt.executeQuery();

								if (rs.next()) {
									count = rs.getInt("PRD_COUNT");
								}
								if (rs != null) {
									rs.close();
									rs = null;
								}
								if (pstmt != null) {
									pstmt.close();
									pstmt = null;
								}

								System.out.println("count::::::::[" + count
										+ "]");

								if (count <= 0) {
									System.out
											.println("period code not present in period master:::");

									errList.add("VPINVPRDCD");
									errFields.add("payroll_prd");

									msgType = errorType(conn, "VPINVPRDCD");
									if (msgType.equalsIgnoreCase("E")) {
										break;
									}
								}
							}
						}

						String bankCode = genericUtility.getColumnValue(
								"bank_code", dom1, objContext);
						System.out.println("bankCode:::::" + bankCode);

						if (bankCode != null && bankCode.length() > 0) {
							sql = "SELECT COUNT(*) AS BANK_CNT FROM BANK WHERE BANK_CODE = ?  ";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, bankCode);

							rs = pstmt.executeQuery();

							if (rs.next()) {
								count = rs.getInt("BANK_CNT");
							}
							if (rs != null) {
								rs.close();
								rs = null;
							}
							if (pstmt != null) {
								pstmt.close();
								pstmt = null;
							}
							System.out.println("count::::::::[" + count + "]");

							if (count <= 0) {
								System.out
										.println("bankCode not present in bank master :::");

								errList.add("VPINVBNKCD");
								errFields.add("bank_code");

								msgType = errorType(conn, "VPINVBNKCD");
								if (msgType.equalsIgnoreCase("E")) {
									break;
								}
							}

						}


						empCodeFrom = checkNull(genericUtility.getColumnValue(
								"emp_code__from", dom1, objContext));
						empCodeTo = checkNull(genericUtility.getColumnValue(
								"emp_code__to", dom1, objContext));
						siteCodeFrom = checkNull(genericUtility.getColumnValue(
								"site_code__from", dom1, objContext));
						siteCodeTo = checkNull(genericUtility.getColumnValue(
								"site_code__to", dom1, objContext));
						procGroupFrom = checkNull(genericUtility
								.getColumnValue("proc_group__from", dom1,
										objContext));
						procGroupTo = checkNull(genericUtility.getColumnValue(
								"proc_group__to", dom1, objContext));
						adCode = checkNull(genericUtility.getColumnValue(
								"ad_code", dom1, objContext));
						resigned = checkNull(genericUtility.getColumnValue(
								"resigned", dom1, objContext));
						fullAmt = checkNull(genericUtility.getColumnValue(
								"full_amt", dom1, objContext));
						fromDate = checkNull(genericUtility.getColumnValue(
								"date_from", dom1, objContext));
						claimDate = checkNull(genericUtility.getColumnValue(
								"claim_date", dom1, objContext));
						unappLoans = checkNull(genericUtility.getColumnValue(
								"unapp_loans", dom1, objContext));
						contVouch = checkNull(genericUtility.getColumnValue(
								"cont_vouch", dom1, objContext));
						adjustLoan = checkNull(genericUtility.getColumnValue(
								"adjust_loan", dom1, objContext));

						System.out.println("empCodeFrom....["
								+ empCodeFrom.toString());
						System.out.println("empCodeTo....["
								+ empCodeTo.toString());
						System.out.println("siteCodeFrom....["
								+ siteCodeFrom.toString());
						System.out.println("siteCodeTo....["
								+ siteCodeTo.toString());
						System.out.println("procGroupFrom....["
								+ procGroupFrom.toString());
						System.out.println("procGroupTo....["
								+ procGroupTo.toString());
						System.out.println("adCode....[" + adCode.toString());
						System.out.println("resigned....["
								+ resigned.toString());
						System.out.println("fullAmt....[" + fullAmt.toString());
						System.out.println("fromDate....["
								+ fromDate.toString());
						System.out.println("claimDate....["
								+ claimDate.toString());
						System.out.println("unappLoans....["
								+ unappLoans.toString());
						System.out.println("contVouch....["
								+ contVouch.toString());
						System.out.println("adjustLoan....["
								+ adjustLoan.toString());

						if (empCodeFrom == null || empCodeFrom.length() == 0) {
							empCodeFrom = "0";
						}
						if (empCodeTo == null || empCodeTo.length() == 0) {
							empCodeTo = "ZZZZZZZZZZ";
						}
						if (siteCodeFrom == null || siteCodeFrom.length() == 0) {
							siteCodeFrom = "0";
						}
						if (siteCodeTo == null || siteCodeTo.length() == 0) {
							siteCodeTo = "ZZZZZ";
						}
						if (procGroupFrom == null
								|| procGroupFrom.length() == 0) {
							procGroupFrom = "0";
						}
						if (procGroupTo == null || procGroupTo.length() == 0) {
							procGroupTo = "ZZZZZ";
						}

						if (adjustLoan.equalsIgnoreCase("Y")) {
							lsAd1 = checkNull(admCommon.getEnv("999999",
									"LOAN_FROM", conn));
							System.out.println("lsAd1....[" + lsAd1 + "]");

							if (!(lsAd1.equalsIgnoreCase("NULLFOUND"))) {
								lsAd2 = checkNull(admCommon.getEnv("999999",
										"LOAN_TO", conn));
								System.out.println("lsAd2....[" + lsAd2 + "]");

								if (lsAd2.equalsIgnoreCase("NULLFOUND")) {
									System.out.println("lsAd2 code null");

									errList.add("VSENVAR1");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VSENVAR1");
									if (msgType.equalsIgnoreCase("E")) {
										break;
									}
								}
							} else {
								System.out.println("lsAd1 code null");

								errList.add("VSENVAR1");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VSENVAR1");
								if (msgType.equalsIgnoreCase("E")) {
									break;
								}
							}
						}

						if (resigned.equalsIgnoreCase("Y")) {
							resigned = "S";
						} else {
							resigned = " ";
						}

						if (fromDate != null && fromDate.length() > 0) {
							fromDate = genericUtility.getValidDateTimeString(
									fromDate,
									genericUtility.getApplDateFormat(),
									genericUtility.getDBDateFormat());
							System.out
									.println("fromDate....[" + fromDate + "]");
						}
						if (claimDate != null && claimDate.length() > 0) {
							claimDate1 = genericUtility.getValidDateTimeString(
									claimDate,
									genericUtility.getApplDateFormat(),
									genericUtility.getDBDateFormat());
							System.out.println("claimDate....[" + claimDate1
									+ "]");
						}
						if (fromDate != null && fromDate.length() > 0
								&& claimDate != null && claimDate.length() > 0) {
							sql = "Select count(1) as allow_count from allowdedn_bal,employee "
									+ "Where allowdedn_bal.emp_code = employee.emp_code "
									+ "and allowdedn_bal.emp_code between ? and ? "
									+ "and ad_code = ? "
									+ "and start_date = ? "
									+ "and amt_bal <> 0 "
									+ "and ref_type = 'K' "
									+ "and pay_site between ? and ? "
									+ "and proc_group between ? and ? "
									+ "and case when relieve_date is null then ' ' else 'S' end = ? "
									+ "and case when status is null then ' ' else status end <> 'S' "
									+ "and (exp_date is null or exp_date >= ? ) ";

							if (contVouch.equalsIgnoreCase("Y")) {
								System.out
										.println("contVouch.equalsIgnoreCase(Y)");
								sql = sql
										.concat(" and employee.supp_code__con is not null");
							} else {
								sql = sql
										.concat(" and employee.supp_code__con is null");
							}
							sql = sql
									.concat(" Order by allowdedn_bal.emp_code");

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, empCodeFrom);
							pstmt.setString(2, empCodeTo);
							pstmt.setString(3, adCode);
							pstmt.setTimestamp(4,
									java.sql.Timestamp.valueOf(fromDate));
							pstmt.setString(5, siteCodeFrom);
							pstmt.setString(6, siteCodeTo);
							pstmt.setString(7, procGroupFrom);
							pstmt.setString(8, procGroupTo);
							pstmt.setString(9, resigned);
							pstmt.setTimestamp(10,
									java.sql.Timestamp.valueOf(claimDate1));

							System.out.println("sql" + sql);

							rs = pstmt.executeQuery();

							if (rs.next()) {
								count = rs.getInt("allow_count");
							}
							System.out.println("count:::::::::[" + count + "]");
							if (rs != null) {
								rs.close();
								rs = null;
							}
							if (pstmt != null) {
								pstmt.close();
								pstmt = null;
							}

							if (count <= 0) {
								System.out.println("lsAd1 code null");

								errList.add("INVINPFLD");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "INVINPFLD");
								if (msgType.equalsIgnoreCase("E")) {
									break;
								}
							} else {

								sql = "Select allowdedn_bal.emp_code, ad_code, start_date, end_date, "
										+ "amt_bal, emp_fname, emp_lname, pay_site, employee.cadre , employee.grade, employee.supp_code__con "
										+ "from allowdedn_bal,employee "
										+ "Where allowdedn_bal.emp_code = employee.emp_code "
										+ "and allowdedn_bal.emp_code between ? and ? "
										+ "and ad_code = ? "
										+ "and start_date = ? "
										+ "and amt_bal <> 0 "
										+ "and ref_type = 'K' "
										+ "and pay_site between ? and ? "
										+ "and proc_group between ? and ? "
										+ "and case when relieve_date is null then ' ' else 'S' end = ? "
										+ "and case when status is null then ' ' else status end <> 'S' "
										+ "and (exp_date is null or exp_date >= ? ) ";

								if (contVouch.equalsIgnoreCase("Y")) {
									System.out
											.println("contVouch.equalsIgnoreCase(Y)");
									sql = sql
											.concat(" and employee.supp_code__con is not null");
								} else {
									sql = sql
											.concat(" and employee.supp_code__con is null");
								}
								sql = sql
										.concat(" Order by allowdedn_bal.emp_code");

								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, empCodeFrom);
								pstmt.setString(2, empCodeTo);
								pstmt.setString(3, adCode);
								pstmt.setTimestamp(4,
										java.sql.Timestamp.valueOf(fromDate));
								pstmt.setString(5, siteCodeFrom);
								pstmt.setString(6, siteCodeTo);
								pstmt.setString(7, procGroupFrom);
								pstmt.setString(8, procGroupTo);
								pstmt.setString(9, resigned);
								pstmt.setTimestamp(10,
										java.sql.Timestamp.valueOf(claimDate1));

								System.out.println("sql" + sql);

								rs = pstmt.executeQuery();

								while (rs.next()) {
									lsEmp = checkNull(rs.getString("emp_code"));
									adCode = checkNull(rs.getString("ad_code"));
									startDate1 = rs.getDate("start_date");
									endDate1 = rs.getDate("end_date");
									amtBal = checkNull(rs.getString("amt_bal"));
									paySite = checkNull(rs
											.getString("pay_site"));
									cadre = checkNull(rs.getString("cadre"));
									grade = checkNull(rs.getString("grade"));
									suppCodeCon = checkNull(rs
											.getString("supp_code__con"));

									System.out.println("lsEmp....[" + lsEmp
											+ "]");
									System.out.println("adCode....[" + adCode + "]");
									System.out.println("startDate1....[" + startDate1 + "]");
									System.out.println("endDate1....[" + endDate1 + "]");
									System.out.println("amtBal....[" + amtBal + "]");
									System.out.println("paySite....[" + paySite + "]");
									System.out.println("cadre....[" + cadre + "]");
									System.out.println("grade....[" + grade + "]");
									System.out.println("suppCodeCon....[" + suppCodeCon + "]");

									
									startDate = sdf.format(startDate1);
									System.out.println("startDate....["
											+ startDate + "]");

									startDate = genericUtility
											.getValidDateTimeString(
													startDate,
													genericUtility
															.getApplDateFormat(),
													genericUtility
															.getDBDateFormat());
									System.out
											.println("DbFormat startDate....["
													+ startDate + "]");

									
									sql1 = "Select count(*) as li_count from allowdedn_bal Where emp_code = ? "
											+ "and ad_code = ? and start_date < ? and end_date < ? and amt_bal <> 0	";

									prestmt = conn.prepareStatement(sql1);

									prestmt.setString(1, lsEmp);
									prestmt.setString(2, adCode);
									prestmt.setTimestamp(3, java.sql.Timestamp
											.valueOf(startDate));
									prestmt.setTimestamp(4, java.sql.Timestamp
											.valueOf(startDate));

									System.out.println("sql1::::::" + sql1);

									rs1 = prestmt.executeQuery();

									if (rs1.next()) {
										count = rs1.getInt("li_count");
									}
									if (rs1 != null) {
										rs1.close();
										rs1 = null;
									}
									if (prestmt != null) {
										prestmt.close();
										prestmt = null;
									}
									System.out.println("count:::::::" + count);

									if (count > 0) {
										System.out.println("count :::" + count);
										if (!(errListEmp.contains(lsEmp))) {
											errListEmp.add(lsEmp);
										}
										if (!(errList.contains("VPNTCLAIM"))) {
											errList.add("VPNTCLAIM");
										}

										errFields.add(childNodeName
												.toLowerCase());

										msgType = errorType(conn, "VPNTCLAIM");
										if (msgType.equalsIgnoreCase("E")) {
											break;
										}
	
									}

									lsEnvName = adCode.toUpperCase()
											+ "_CLAIMCURRPRD";
									System.out.println("lsEnvName::::"
											+ lsEnvName);

									Timestamp claimDate2 = Timestamp
											.valueOf(claimDate1);

									canClaimInSameYear = checkNull(admCommon
											.getAdmEnv(paySite, cadre, grade,
													lsEnvName, claimDate2, conn));
									System.out
											.println("canClaimInSameYear::::::"
													+ canClaimInSameYear);

									if (canClaimInSameYear
											.equalsIgnoreCase("NULLFOUND")) {
										System.out
												.println("canClaimInSameYear  NULLFOUND::::::"
														+ canClaimInSameYear);

										canClaimInSameYear = checkNull(admCommon
												.getEnv("999999", lsEnvName,
														conn));
										System.out
												.println("canClaimInSameYear::::::"
														+ canClaimInSameYear);

										if (canClaimInSameYear
												.equalsIgnoreCase("NULLFOUND")) {
											System.out
													.println("canClaimInSameYear  null found ");

											errList.add("VSENVAR1");
											errFields.add(childNodeName
													.toLowerCase());

											msgType = errorType(conn,
													"VSENVAR1");
											if (msgType.equalsIgnoreCase("E")) {
												break;
											}

										}
									} 
									else {
										canClaimInSameYear = canClaimInSameYear
												.trim().toUpperCase();
										if (!(resigned.equalsIgnoreCase("S"))) {
											if (!(canClaimInSameYear
													.equalsIgnoreCase("Y"))
													&& (endDate1
															.after(claimDate2))) {
												System.out
														.println("(canClaimInSameYear.equalsIgnoreCase('Y')) && (endDate1.after(claimDate2)) :::");

												errList.add("VPCLAIM");
												errFields.add(childNodeName
														.toLowerCase());

												msgType = errorType(conn,
														"VPCLAIM");
												if (msgType
														.equalsIgnoreCase("E")) {
													break;
												}

											}
										}
									}

									if (unappLoans.equalsIgnoreCase("N")) {
										sql2 = " Select count(*) as li_count from loans Where emp_code = ? and (status = 'U' or (status = 'A' and start_dedn <> 'Y')) and accrual_amt > 0 ";

										pstmt2 = conn.prepareStatement(sql2);
										pstmt2.setString(1, lsEmp);

										rs2 = pstmt2.executeQuery();

										if (rs2.next()) {
											count = rs2.getInt("li_count");
										}
										if (rs2 != null) {
											rs2.close();
											rs2 = null;
										}
										if (pstmt2 != null) {
											pstmt2.close();
											pstmt2 = null;
										}
										System.out.println("count::::" + count);
									} else {
										count = 0;
									}

									if (count == 0) {
										if (paySite == null
												|| paySite.trim().length() == 0) {
											System.out
													.println("paySite  null :::: "
															+ paySite);

											errList.add("VMSITE1");
											errFields.add(childNodeName
													.toLowerCase());

											msgType = errorType(conn, "VMSITE1");
											if (msgType.equalsIgnoreCase("E")) {
												break;
											}
										}
									}
									
									//Modified by Ahmed on 14/Apr/2017[start]
									SimpleDateFormat sdfAppl = new SimpleDateFormat(getApplDateFormat());
									Date tranDate = sdfAppl.parse(claimDate);
									errCode = nfCheckPeriod("ADM", tranDate, paySite);
									System.out.println("paySite::ADM::" + paySite);
									System.out.println("errCode::ADM::" + errCode);
									if(errCode == null || errCode.trim().length() == 0)
									{
										errCode = nfCheckPeriod("FIN", tranDate, paySite);
										System.out.println("errCode::FIN::" + errCode);
										if(errCode != null && errCode.trim().length() > 0)
										{
											/*errString = getErrorString("claim_date", errCode, userId);
											return errString;*/
											errList.add(errCode);
											errFields.add(childNodeName.toLowerCase());

											msgType = errorType(conn, errCode);
											System.out.println("msgType::FIN::" + msgType);
											if (msgType.equalsIgnoreCase("E")) 
											{
												System.out.println("inside msgType::FIN::" + msgType);
												break detail1Loop;
											}
										}
									}
									else
									{
										/*errString = getErrorString("claim_date", errCode, userId);
										return errString;*/
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());

										msgType = errorType(conn, errCode);
										System.out.println("msgType::ADM::" + msgType);
										if (msgType.equalsIgnoreCase("E")) {
											System.out.println("inside msgType::ADM::" + msgType);
											break detail1Loop;
										}
									}
									//Modified by Ahmed on 14/Apr/2017[end]
								}
								System.out.println("outside while loop...");
								if (rs != null) {
									rs.close();
									rs = null;
								}
								if (pstmt != null) {
									pstmt.close();
									pstmt = null;
								}
							}
						}
					}
					System.out.println("site_code__from...");
					if (childNodeName.equalsIgnoreCase("site_code__from")) {

						int level = 0;

						String loginCode = checkNull(genericUtility
								.getValueFromXTRA_PARAMS(xtraParams,
										"loginCode"));
						sql = "SELECT USR_LEV FROM USERS WHERE CODE = ? ";

						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, loginCode);

						rs = pstmt.executeQuery();

						if (rs.next()) {
							level = rs.getInt("USR_LEV");
						}
						if (level > 1) {
							userId = genericUtility.getValueFromXTRA_PARAMS(
									xtraParams, "loginCode");
							siteCodeFrom = genericUtility.getColumnValue(
									"site_code__from", dom1, objContext);
							sql2 = " Select count(*) as CNT from SITE Where SITE_CODE = ?";

							pstmt2 = conn.prepareStatement(sql2);
							pstmt2.setString(1, siteCodeFrom);
							rs2 = pstmt2.executeQuery();

							if (rs2.next()) {
								count = rs2.getInt("CNT");
							}
							if (rs2 != null) {
								rs2.close();
								rs2 = null;
							}
							if (pstmt2 != null) {
								pstmt2.close();
								pstmt2 = null;
							}
							if (count == 0) {
								errList.add("VMPRKSTFR1");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMPRKSTFR1");
								if (msgType.equalsIgnoreCase("E")) {
									break;
								}
							}
							siteCodeFrom = genericUtility.getColumnValue(
									"site_code__from", dom1, objContext);
							sql2 = " Select count(*) as CNT from USER_SITE Where SITE_CODE = ? AND USER_ID=?";

							pstmt2 = conn.prepareStatement(sql2);
							pstmt2.setString(1, siteCodeFrom);
							pstmt2.setString(2, userId);
							rs2 = pstmt2.executeQuery();

							if (rs2.next()) {
								count = rs2.getInt("CNT");
							}
							if (rs2 != null) {
								rs2.close();
								rs2 = null;
							}
							if (pstmt2 != null) {
								pstmt2.close();
								pstmt2 = null;
							}
							if (count == 0) {
								errList.add("VMPRKSTFR2");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMPRKSTFR2");
								if (msgType.equalsIgnoreCase("E")) {
									break;
								}
							}

						}
					}
				}
				System.out.println("outside for loop...");
			}
				System.out.println("outside case 1...");
				break;
			}
			System.out.println("error code start...");
			System.out.println("errList..."+errList.toString());
			System.out.println("errFields..."+errFields.toString());
			String empCode = "";
			StringBuffer commaSepValueBuilder = new StringBuffer();
			int errListSize = errList.size();
			if (errList != null && errListSize > 0) {
				for (cnt = 0; cnt < errListSize; cnt++) {
					errCode = (String) errList.get(cnt);
					errFldName = (String) errFields.get(cnt);

					System.out.println("errFldName..."+errFldName);
					System.out.println("errCode .........." + errCode);

					errString = getErrorString(errFldName, errCode, userId);
					System.out.println("errString is : ::::>>>> " + errString);
					msgType = errorType(conn, errCode);
					System.out.println("msgType .........." + msgType);

					if (errString.length() > 0
							&& errCode.equalsIgnoreCase("VPNTCLAIM")) {
						int errListEmpSize = errListEmp.size();
						if (errListEmp != null && errListEmpSize > 0) {
							for (int listCnt = 0; listCnt < errListEmpSize; listCnt++) {
								empCode = (String) errListEmp.get(listCnt);
								commaSepValueBuilder.append(empCode);

								if (listCnt != errListEmpSize - 1) {
									commaSepValueBuilder.append(", ");
								}
							}
						}
						String msgDescr = "";
						msgDescr = errString.substring(
								errString.indexOf("<description>")
										+ ("<description>").length(),
								errString.indexOf("</description>"))
								+ " ( " + commaSepValueBuilder + " ) ";
						System.out.println("msgDescr:::::::::" + msgDescr);
						errString = errString.substring(0,
								errString.indexOf("<description>")
										+ ("<description>").length())
								+ msgDescr
								+ ""
								+ errString.substring(
										errString.indexOf("</description>"),
										errString.length());
						//Modified by Ahmed on 14/Apr/2017[start]
						String bifurErrString = errString.substring(
								errString.indexOf("<Errors>") + 8,
								errString.indexOf("<trace>"));
						System.out.println("bifurErrString:::::::"
								+ bifurErrString);
						bifurErrString = bifurErrString
								+ errString.substring(
										errString.indexOf("</trace>") + 8,
										errString.indexOf("</Errors>"));
						//errStringXml.append(errString);
						errStringXml.append(bifurErrString);
						//Modified by Ahmed on 14/Apr/2017[end]
					} else {
						if (errString.length() > 0) {
							String bifurErrString = errString.substring(
									errString.indexOf("<Errors>") + 8,
									errString.indexOf("<trace>"));
							System.out.println("bifurErrString:::::::"
									+ bifurErrString);
							bifurErrString = bifurErrString
									+ errString.substring(
											errString.indexOf("</trace>") + 8,
											errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							System.out.println("errStringXml .........."
									+ errStringXml);
							errString = "";
						}
					}
					if (msgType.equalsIgnoreCase("E")) {
						break;
					}

				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;

				errStringXml.append("</Errors></Root>\r\n");
			} else {
				errStringXml = new StringBuffer("");
			}
			errString = errStringXml.toString();
		} catch (Exception e) {
			System.out
					.println("Exception : [PerkClaimProcess][wfValData(String xmlString)] : ==>\n"
							+ e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (rs1 != null) {
					rs1.close();
					rs1 = null;
				}
				if (prestmt != null) {
					prestmt.close();
					prestmt = null;
				}
				if (rs2 != null) {
					rs2.close();
					rs2 = null;
				}
				if (pstmt2 != null) {
					pstmt2.close();
					pstmt2 = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} catch (Exception e1) {
				System.out
						.println("Exception : [PerkClaimProcess][wfValData] : ==>\n"
								+ e1.getMessage());
				throw new ITMException(e1);
			}
		}

		return errString;
	}

	private String checkNull(String input) {
		if (input == null) {
			input = "";
		} else {
			input = input.trim();
		}
		return input;
	}

	private String getObjName(Document dom, String objContext) {
		Node elementName = null;
		NodeList elementList = null;
		String objName = "";
		elementList = dom.getElementsByTagName("Detail" + objContext);
		elementName = elementList.item(0);
		if (elementName != null
				&& ("Detail" + objContext).equalsIgnoreCase(elementName
						.getNodeName())) {
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes != null) {
				if (etlAttributes.getNamedItem("objName") != null) {
					objName = etlAttributes.getNamedItem("objName")
							.getNodeValue();
				}
			}
		}
		return objName;
	}

	private String errorType(Connection conn, String errorCode)
			throws ITMException {
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try {
			String sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				msgType = rs.getString("MSG_TYPE");
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new ITMException(ex);
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}

	private String getDomId(Document dom2, String objContext) {
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		
		String domId = "";
		elementList = dom2.getElementsByTagName("Detail" + objContext);
		elementName = elementList.item(0);
		if (elementName != null
				&& ("Detail" + objContext).equalsIgnoreCase(elementName
						.getNodeName())) {
			NamedNodeMap etlAttributes = elementName.getAttributes();
			if (etlAttributes != null) {
				if (etlAttributes.getNamedItem("domID") != null) {
					domId = etlAttributes.getNamedItem("domID").getNodeValue();
				}
			}
		}
		return domId;
	}

}