
package ibase.webitm.ejb.adm;

import java.rmi.RemoteException;
import java.util.*;
import java.util.Date;
import java.text.DateFormat;
import java.sql.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import org.w3c.dom.*;
import javax.xml.parsers.*;
import java.text.SimpleDateFormat;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;
import ibase.utility.CommonConstants;

@javax.ejb.Stateless
public class EmpBasicInfoPos extends ValidatorEJB implements EmpBasicInfoPosLocal, EmpBasicInfoPosRemote
{	
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}

	public String postSave( String domString, String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		PreparedStatement pStmt = null;
		Document dom = null;		
		
		boolean isError = false;
		boolean isLocalConn = false;
		ResultSet rs = null; 
		int count;
        String empCode = "";
		String posCode = "";
		String deptCode = "";
		String posCodeOld ="";
		String deptCodeOld = "";
		String dateJoinOld = "";
		String sql = "";
		Date dateJoin = null;
		String errString = "";

		// Modified by Piyush on 27/01/2015.Start
		String empUpdSql = "";
		
		// Modified by Piyush on 27/01/2015.End
		try
		{
			conn.setAutoCommit( false );

			GenericUtility genericUtility = GenericUtility.getInstance();
			
			System.out.println("domString EmpBasicInfoPos ["+domString+"]");	
			dom = genericUtility.parseString(domString);
			
			String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			String chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			
			SimpleDateFormat sdf = new SimpleDateFormat(getApplDateFormat());
			
			
		    
			if(editFlag.equalsIgnoreCase("E"))
			{
				empCode =  checkNull(genericUtility.getColumnValue("emp_code", dom));
				posCode =  checkNull(genericUtility.getColumnValue("pos_code", dom));
				deptCode =  checkNull(genericUtility.getColumnValue("dept_code", dom));
				posCodeOld =  checkNull(genericUtility.getColumnValue("pos_code_old", dom));
				deptCodeOld =  checkNull(genericUtility.getColumnValue("dept_code_old", dom));
				dateJoinOld =  checkNull(genericUtility.getColumnValue("date_join_old", dom));
				
				System.out.println("empCode::::::"+empCode);
				System.out.println("posCode::::::"+posCode);
				System.out.println("deptCode::::::"+deptCode);
				System.out.println("posCodeOld::::::"+posCodeOld);
				System.out.println("deptCodeOld::::::"+deptCodeOld);
				System.out.println("dateJoinOld::::::"+dateJoinOld);
				
				sql = " SELECT DATE_JOIN FROM EMPLOYEE  WHERE EMP_CODE = ? ";
				pStmt = conn.prepareStatement(sql);
				pStmt.setString(1,empCode);
				rs = pStmt.executeQuery();
				if(rs.next())
				{
					dateJoin = rs.getDate("DATE_JOIN");
				}
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if ((((posCode != null && posCode.trim().length() > 0) || (posCodeOld != null && posCodeOld.trim().length() > 0)) && dateJoin != null ))
				{
					AdmCommon ad = new AdmCommon();
					errString = ad.updateOrgStructure( domString,  empCode,  posCode,  deptCode, dateJoin, posCodeOld, deptCodeOld,  dateJoinOld, userId, chgTerm,  "EMPMST" , conn ) ;
				}
			}
			// Modified by Piyush on 27/01/2015 [To set default values for other tabs - Based on Sun HR feedback].Start
			else
			{
				String citizen = "";
				String updSql = "";
				empUpdSql = "UPDATE EMPLOYEE SET CITIZEN = ? WHERE EMP_CODE = ? ";
				empCode =  checkNull(genericUtility.getColumnValue("emp_code", dom));

				sql = " SELECT CITIZEN FROM EMPLOYEE  WHERE EMP_CODE = ? ";
				pStmt = conn.prepareStatement(sql);
				pStmt.setString(1,empCode);
				rs = pStmt.executeQuery();
				if(rs.next())
				{
					citizen = checkNull(rs.getString("CITIZEN"));
				}
				if( rs != null)
				{
					rs.close();
					rs = null;
				}
				if( pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if (citizen.trim().length() == 0)
				{
					citizen = "Y";
				}
				pStmt = conn.prepareStatement(empUpdSql);
				pStmt.setString(1,citizen);
				pStmt.setString(2,empCode);
				pStmt.executeUpdate();
				if( pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}

			}
			// Modified by Piyush on 27/01/2015 [To set default values for other tabs - Based on Sun HR feedback].End
		}
		catch(Exception e)
		{
			System.out.println("Exception :EmpBasicInfoPos : :==>\n"+e.getMessage());
			e.printStackTrace();
			isError = true;
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError ["+isError+"]");
				System.out.println("isLocalConn ["+isLocalConn+"]");
				if( conn != null )
				{

					if( isError )
					{
						conn.rollback();
					}
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :EmpBasicInfoPos : :==>\n"+e.getMessage());
			
				try
				{
					System.out.println("Before rollback");
					conn.rollback();
				}
				catch(SQLException sqle)
				{
                    System.out.println(sqle);
				}
				throw new ITMException(e);
			
			}
		}
		System.out.println("Return Error string :"+errString);
		return errString;		
	}

	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	
}
