/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessLocal;
import ibase.webitm.ejb.EventManagerLocal;
import ibase.webitm.ejb.ITMXformLocal;
import ibase.webitm.ejb.ITMXformRemote;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.MetaDataObject;
import ibase.webitm.utility.ReCalculateTax;
import ibase.webitm.utility.XMLBuilder;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.PostActivate;
import javax.ejb.Remove;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class ITMXformEJB
implements ITMXformRemote,
ITMXformLocal {
    protected UserInfoBean userInfo = null;
    protected String objContext = "1";
    protected String pageContext;
    protected String editFlag;
    protected String localEditFlag;
    protected String wrkflwProcInstId = null;
    protected String qtyCol = null;
    protected int noOfForms = -1;
    protected String argFieldValues;
    protected String argFieldNames = null;
    protected String argFieldTypes = null;
    protected String headerPKFieldNames = null;
    protected String headerPKFieldValues = null;
    protected String objName;
    protected String viewDomId = "-1";
    protected String headerDomId = "1";
    protected String detailDomId = "-1";
    protected String taxDomId = "-1";
    protected String saveLevel = "";
    protected String rateCol = null;
    protected boolean isTaxChanged = false;
    protected ArrayList taxList = null;
    boolean isCurrentDetailValidated = true;
    transient Node currTaxNode = null;
    protected TreeMap changedDataMap = null;
    transient HashMap headerInfoMap;
    protected String overWriteDefault = "";
    protected transient Document detailDom = null;
    private transient Node currRecordNode = null;
    boolean isRecordValidated = true;
    protected String requestParamStr = null;
    protected String focussedColumn = "";
    protected String currentEventContext = "";
    protected transient Document headerListDom = null;
    final String COLUMN_SEPARATOR = ":";
    final String XTRA_PARAMS_SEPARATOR = "~~";
    protected int recCtr = -1;
    protected boolean isAuditTrailOn = false;
    protected HashMap auditDataMap = null;
    private String user_country = "US";
    private String user_lang = "en";
    private EventManagerLocal eventManager = null;
    private DBAccessLocal dbAccess = null;
    transient InitialContext initialContext = null;
    @Resource
    private SessionContext cSessionContext;

    @PostConstruct
    public void ejbCreate() {
        System.out.println("XfromEJB Created...");
        try {
            this.setInitialContext();
            System.out.println("XfromEJB Created...");
            this.eventManager = (EventManagerLocal)this.initialContext.lookup("ibase/EventManagerEJB/local");
            this.dbAccess = (DBAccessLocal)this.initialContext.lookup("ibase/DBAccessEJB/local");
            CommonConstants.setIBASEHOME();
        }
        catch (Exception exception) {
            System.out.println("Exception :XfromEJB :ejbCreate :==>" + exception);
            exception.printStackTrace();
        }
    }

    @Remove
    public void ejbRemove() {
        this.eventManager.remove();
        this.eventManager = null;
    }

    @PostActivate
    public void ejbActivate() {
        try {
            this.setInitialContext();
        }
        catch (Exception exception) {
            System.out.println("Exception :XfromEJB :ejbActivate :==>\n" + exception);
        }
    }

    public void ejbPassivate() {
    }

    private void setInitialContext() throws ITMException {
        try {
            AppConnectParm appConnectParm = new AppConnectParm();
            this.initialContext = new InitialContext(appConnectParm.getProperty());
        }
        catch (ITMException iTMException) {
            System.out.println("ITMException :XfromEJB :setInitialContext :");
            throw iTMException;
        }
        catch (Exception exception) {
            System.out.println("Exception :XfromEJB :setInitialContext :");
            throw new ITMException(exception);
        }
    }

    @Override
    public void setUserInfo(String string, String string2) throws RemoteException {
        try {
            this.userInfo = new UserInfoBean(string);
            if (string2 != null && string2.length() > 0) {
                this.detailDom = this.parseString(string2);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :XfromEJB :setUserInfo :==>" + exception);
            exception.printStackTrace();
        }
    }

    @Override
    public String getPopHelpFields(String string) throws RemoteException, Exception {
        System.out.println("[XfromEJB]Getting the PopHelp Field for objName:[" + string + "]");
        Connection connection = null;
        Statement statement = null;
        String string2 = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = "SELECT FIELD_NAME FROM POPHELP WHERE MOD_NAME = 'W_" + string.toUpperCase() + "'";
            System.out.println("Query:: [ " + string3 + " ]");
            ConnDriver connDriver = new ConnDriver();
            connection = connDriver.getConnectDB("DriverITM");
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                int n = resultSetMetaData.getColumnCount();
                for (int i = 1; i <= n; ++i) {
                    String string4 = resultSetMetaData.getColumnName(i);
                    if (resultSet.getString(string4) == null || resultSet.getString(string4).equalsIgnoreCase("null") || resultSet.getString(string4).length() <= 0) continue;
                    stringBuffer.append(resultSet.getString(string4).trim() + ":");
                }
            }
            string2 = stringBuffer.toString();
            if (string2 != null && string2.length() > 0) {
                string2 = string2.substring(0, string2.lastIndexOf(":"));
            } else {
                System.out.println("No entry for objName [" + string + "] in Pophelp ");
            }
            statement.close();
            statement = null;
        }
        catch (Exception exception) {
            System.out.println("Exception :ITMXformEJB :GETPOPHELPFIELD :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        finally {
            try {
                if (connection != null) {
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception exception) {
                System.err.println("Exception :ITMXformEJB :GETPOPHELPFIELD :\n" + exception.getMessage());
                throw new ITMException(exception);
            }
        }
        System.out.println("[XfromEJB]Returning the POPHELPFIELD :" + string2);
        return string2;
    }

    @Override
    public String getDetailXMLDomString(String string, String string2, String string3, String string4, String string5) throws RemoteException, ITMException {
        String string6 = null;
        this.objName = string;
        boolean bl = true;
        try {
            ArrayList arrayList = this.dbAccess.getObjFormsDetailList(string);
            this.noOfForms = arrayList.size();
            this.pageContext = "2";
            this.objContext = string3.equalsIgnoreCase("A") ? string2 : "1";
            if (Integer.parseInt(this.objContext.trim()) == 1) {
                if (string3 != null && string3.length() > 0) {
                    this.editFlag = string3;
                    this.localEditFlag = string3;
                }
            } else if (string3 != null && string3.length() > 0) {
                this.localEditFlag = string3;
            }
            if (Integer.parseInt(this.objContext.trim()) == 1) {
                if (this.editFlag.equalsIgnoreCase("A")) {
                    this.setArgFieldValues(string5);
                    this.headerPKFieldValues = null;
                }
                this.createDetailDom();
                string6 = this.serializeDom(this.detailDom);
                System.out.println("Creation of detail dom detailXMLStr [ " + string6 + " ]");
            } else {
                if (this.localEditFlag.equalsIgnoreCase("A")) {
                    this.addChildAddDom();
                }
                this.currRecordNode = this.searchNode(this.detailDom, this.objContext, this.detailDomId);
                string6 = this.getNormalizedString(this.serializeDom(this.currRecordNode));
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :XfromEJB :getXMLDataForDetail :==>\n" + exception);
            exception.printStackTrace();
            throw new ITMException(exception);
        }
        System.out.println("\t\tXXXXXXXEdit XML StartXXXXXXXXX");
        return string6;
    }

    private void createDetailDom() throws Exception {
        System.out.println("[ITMXFORMEJB]In createDetailDom  . . . . . . ");
        String string = null;
        if (this.editFlag.equalsIgnoreCase("A")) {
            string = this.getBlankDomForAdd(this.objName, "1", this.pageContext, this.taxList, this.userInfo.toString());
        }
        this.detailDom = null;
        this.currRecordNode = null;
        this.currTaxNode = null;
        this.detailDom = this.parseString(string);
        if (!this.editFlag.equalsIgnoreCase("V")) {
            this.updateNewDom(null);
        }
        System.out.println("[ITMXFORMEJB]createDetailDom  completed. . . . . . . . . " + string);
    }

    private void addChildAddDom() throws Exception {
        System.out.println("[ITMXFORMEJB]In addChildAddDom  . . . . . . ");
        Object var1_1 = null;
        String string = this.getBlankDomForAdd(this.objName, this.objContext, this.pageContext, this.taxList, this.userInfo.toString());
        this.currRecordNode = null;
        this.currTaxNode = null;
        this.appendToDom(this.detailDom, this.parseString(string), this.objContext);
        this.updateNewDom("A");
        this.isCurrentDetailValidated = false;
        System.out.println("[ITMXFORMEJB]addChildAddDom  completed . . . . . . ");
    }

    private void appendToDom(Document document, Document document2, String string) throws ITMException {
        try {
            NodeList nodeList = document.getElementsByTagName("Header0");
            Node node = nodeList.item(0);
            NodeList nodeList2 = document2.getElementsByTagName("Detail" + string);
            int n = nodeList2.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList2.item(i);
                Node node3 = document.importNode(node2, true);
                nodeList.item(0).appendChild(node3);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : ITMXFORMEJB : appendToDom :" + exception);
            throw new ITMException(exception);
        }
    }

    private void updateNewDom(String string) throws Exception {
        string = string == null ? this.localEditFlag : string;
        NodeList nodeList = null;
        int n = -1;
        ArrayList arrayList = this.dbAccess.getItemChangeElementList(this.objName, this.objContext);
        if (string.equalsIgnoreCase("A")) {
            nodeList = this.searchNodes(this.detailDom, this.objContext);
            n = nodeList.getLength();
            Node node = nodeList.item(n - 1);
            System.out.println("detailListLength :" + n);
            this.assignNewDomID(nodeList, node, n);
            if (Integer.parseInt(this.objContext) > 1) {
                this.assignPKFieldValues(node);
            }
            this.assignArgValues(node, arrayList);
            this.assignNewLineNo(nodeList, n);
        }
        this.assignITMDefaultValues(string, arrayList);
        if (Integer.parseInt(this.objContext) == 1 && string.equalsIgnoreCase("A")) {
            this.assignDefaultValues(this.userInfo.getUserType(), this.userInfo.getEntityCode(), arrayList);
        }
    }

    private void assignNewDomID(NodeList nodeList, Node node, int n) throws Exception {
        int n2 = 0;
        int n3 = -1;
        Node node2 = null;
        Object var7_7 = null;
        for (int i = 0; i < n; ++i) {
            node2 = nodeList.item(i);
            String string = node2.getAttributes().getNamedItem("domID").getNodeValue();
            System.out.println("currDomIDStr :" + string);
            if (string != null && !string.equals("")) {
                n3 = Integer.parseInt(string.trim());
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        if (Integer.parseInt(this.objContext) > 1) {
            this.detailDomId = String.valueOf(n2 + 1);
        }
        node.getAttributes().getNamedItem("domID").setNodeValue(String.valueOf(n2 + 1));
        System.out.println("Assigned new Dom id :[" + String.valueOf(n2 + 1) + "]");
    }

    private void assignPKFieldValues(Node node) throws Exception {
        System.out.println("[ITMXFORMEJB]this.headerPKFieldValues :" + this.headerPKFieldValues);
        if (this.headerPKFieldValues != null && this.headerPKFieldValues.length() > 0) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            StringTokenizer stringTokenizer = new StringTokenizer(this.headerPKFieldNames, ":");
            StringTokenizer stringTokenizer2 = new StringTokenizer(this.headerPKFieldValues, ":");
            block0: while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                String string2 = stringTokenizer2.nextToken();
                for (int i = 0; i < n; ++i) {
                    Node node2 = nodeList.item(i);
                    if (!node2.getNodeName().equalsIgnoreCase(string)) continue;
                    CDATASection cDATASection = node2.getOwnerDocument().createCDATASection(string2);
                    if (node2.getFirstChild() != null) {
                        node2.replaceChild(cDATASection, node2.getFirstChild());
                        continue block0;
                    }
                    node2.appendChild(cDATASection);
                    continue block0;
                }
            }
        }
        System.out.println("[ITMXFORMEJB]Assigned header pk field values....");
    }

    private void assignArgValues(Node node, ArrayList arrayList) throws Exception {
        if (this.argFieldValues != null && this.argFieldValues.length() > 0) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            StringTokenizer stringTokenizer = new StringTokenizer(this.argFieldNames, ":");
            StringTokenizer stringTokenizer2 = new StringTokenizer(this.argFieldValues, ":");
            StringTokenizer stringTokenizer3 = new StringTokenizer(this.argFieldTypes, ":");
            block0: while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                String string2 = stringTokenizer2.nextToken();
                String string3 = stringTokenizer3.nextToken();
                if (string == null || string.length() <= 0) continue;
                for (int i = 0; i < n; ++i) {
                    Node node2 = nodeList.item(i);
                    if (!node2.getNodeName().equalsIgnoreCase(string)) continue;
                    CDATASection cDATASection = node2.getOwnerDocument().createCDATASection(string2);
                    if (node2.getFirstChild() != null) {
                        node2.replaceChild(cDATASection, node2.getFirstChild());
                    } else {
                        node2.appendChild(cDATASection);
                    }
                    if (!arrayList.contains(string)) continue block0;
                    String string4 = "";
                    string4 = "<?xml version='1.0' encoding='utf-8'?><Root><header><objName><![CDATA[" + this.objName + "]]></objName>" + "<pageContext><![CDATA[" + this.pageContext + "]]></pageContext>" + "<objContext><![CDATA[" + this.objContext + "]]></objContext>" + "<editFlag><![CDATA[" + this.localEditFlag + "]]></editFlag>" + "<focusedColumn><![CDATA[" + string + "]]></focusedColumn>" + "<keyValue><![CDATA[" + (Integer.parseInt(this.objContext.trim()) == 1 ? this.headerDomId : this.detailDomId) + "]]></keyValue>" + "<saveLevel><![CDATA[0]]></saveLevel>" + "<forcedSave><![CDATA[false]]></forcedSave>" + "</header>" + "<Detail>" + "<" + string + ">" + string2 + "</" + string + ">" + "</Detail>" + "</Root>";
                    this.currentEventContext = this.objContext + ":" + string;
                    this.applyItemChange(string4);
                    continue block0;
                }
            }
        }
        System.out.println("[ITMXFORMEJB]Assigned arg field values....");
    }

    public String applyItemChange(String string) throws RemoteException, ITMException {
        System.out.println("[ITMXFORMEJB]In applyItemChange. . . . . . . with xmlStr :[" + string + "]");
        String string2 = "";
        try {
            String[] stringArray = new String[]{"INPUT_STR", string};
            this.debug("ItemChange", stringArray, "1");
            this.updateHeaderInfoMap(string);
            if (this.currRecordNode == null) {
                this.currRecordNode = this.searchNode(this.detailDom, this.objContext, Integer.parseInt(this.objContext.trim()) == 1 ? this.headerDomId : this.detailDomId);
            }
            this.changedDataMap = new TreeMap();
            Document document = this.parseString(string);
            if (((Boolean)this.headerInfoMap.get("taxInFocus")).booleanValue()) {
                this.handleItemChange(string);
                this.changedDataMap.clear();
                System.out.println("[ITMXFORMEJB] reCalculating tax  ...........");
                string2 = this.recalculateTax();
            } else {
                this.handleItemChange(string);
                this.changedDataMap.clear();
                this.overWriteDefault = "0";
                this.focussedColumn = (String)this.headerInfoMap.get("focusedColumn");
                this.currentEventContext = this.objContext + ":" + this.focussedColumn;
                if (this.focussedColumn != null && this.focussedColumn.length() > 0) {
                    string2 = this.eventManager.executeSystemEvent(this.objName, "post_item_change", this.currentEventContext, this.parseString(string), this.detailDom, this.getXtraParams(), Integer.parseInt(this.objContext.trim()) == 1 ? this.headerDomId : this.detailDomId);
                }
                if (string2 != null && string2.length() > 0) {
                    Document document2;
                    NodeList nodeList;
                    int n;
                    if (string2.indexOf("<Errors>") == -1) {
                        this.handleItemChange(string2);
                        string2 = this.getChangedXMLString();
                    }
                    if ((n = (nodeList = (document2 = this.parseString(string2 = string2 != null && string2.length() > 0 ? string2 : string)).getElementsByTagName("header").item(0) == null ? document2.getElementsByTagName("Header") : document2.getElementsByTagName("header")).getLength()) > 0) {
                        for (int i = 0; i < n; ++i) {
                            NodeList nodeList2 = document.getElementsByTagName("header");
                            int n2 = nodeList2.getLength();
                            for (int j = 0; j < n2; ++j) {
                                Node node = nodeList2.item(j);
                                Node node2 = document2.importNode(node, true);
                                document2.getDocumentElement().replaceChild(node2, nodeList.item(i));
                            }
                        }
                    } else {
                        NodeList nodeList3 = document.getElementsByTagName("header");
                        int n3 = nodeList3.getLength();
                        for (int i = 0; i < n3; ++i) {
                            Node node = nodeList3.item(i);
                            Node node3 = document2.importNode(node, true);
                            document2.getDocumentElement().appendChild(node3);
                        }
                    }
                    string2 = this.serializeDom(document2);
                }
                if (!((Boolean)this.headerInfoMap.get("taxInFocus")).booleanValue()) {
                    this.isRecordValidated = false;
                }
            }
            this.changedDataMap.clear();
        }
        catch (Exception exception) {
            System.out.println("Exception :MasterStatefulException :applyItemChange :==>\n" + exception.getMessage());
            exception.printStackTrace();
            this.debug("ItemChange :Exception", null, exception.getMessage());
            throw new ITMException(exception);
        }
        finally {
            this.debug("ItemChange", null, string2);
        }
        System.out.println("[ITMXFORMEJB]applyItemChange  completed . . . . . . ");
        return string2;
    }

    private void assignNewLineNo(NodeList nodeList, int n) throws Exception {
        Object object;
        Object object2;
        int n2;
        int n3;
        String string = "";
        int n4 = 0;
        int n5 = -1;
        Node node = null;
        NodeList nodeList2 = null;
        block0: for (n3 = 0; n3 < n - 1; ++n3) {
            node = nodeList.item(n3);
            nodeList2 = node.getChildNodes();
            n2 = nodeList2.getLength();
            for (int i = 0; i < n2; ++i) {
                object2 = nodeList2.item(i);
                if (!object2.getNodeName().equalsIgnoreCase("LINE_NO") || object2.getFirstChild() == null) continue;
                object = object2.getFirstChild().getNodeValue();
                if (object != null) {
                    n5 = Integer.parseInt(((String)object).trim());
                }
                if (n5 <= n4) continue;
                n4 = n5;
                continue block0;
            }
        }
        node = nodeList.item(n - 1);
        nodeList2 = node.getChildNodes();
        n3 = nodeList2.getLength();
        for (n2 = 0; n2 < n3; ++n2) {
            Node node2 = nodeList2.item(n2);
            if (!node2.getNodeName().equalsIgnoreCase("LINE_NO")) continue;
            string = String.valueOf(n4 + 1);
            object2 = this.getDWObject(this.objName, Integer.parseInt(this.objContext));
            object = ((MetaDataObject)object2).getColLogNameTypeMap();
            HashMap hashMap = ((MetaDataObject)object2).getColLogNameSizeMap();
            if (((String)((HashMap)object).get("line_no")).equalsIgnoreCase("char")) {
                int n6 = (Integer)hashMap.get("line_no");
                while (string.length() != n6) {
                    string = " " + string;
                }
            }
            CDATASection cDATASection = node.getOwnerDocument().createCDATASection(string);
            if (node2.getFirstChild() != null) {
                node2.replaceChild(cDATASection, node2.getFirstChild());
                break;
            }
            node2.appendChild(cDATASection);
            break;
        }
        System.out.println("Assigned new line no :[" + string + "]");
    }

    private void assignDefaultValues(String string, String string2, ArrayList arrayList) throws Exception {
        Connection connection = null;
        Statement statement = null;
        try {
            ConnDriver connDriver = null;
            connDriver = new ConnDriver();
            connection = connDriver.getConnectDB("DriverITM");
            String string3 = "SELECT SITE_ACC_COL,SALES_PERS_ACC_COL,CUST_ACC_COL,SUPP_ACC_COL,ITEM_SER_ACC_COL,EMP_ACC_COL FROM TRANSETUP WHERE TRAN_WINDOW='w_" + this.objName + "'";
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string3);
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            if (resultSet.next()) {
                string4 = resultSet.getString("SITE_ACC_COL");
                string5 = resultSet.getString("SALES_PERS_ACC_COL");
                string6 = resultSet.getString("CUST_ACC_COL");
                string7 = resultSet.getString("SUPP_ACC_COL");
                string8 = resultSet.getString("ITEM_SER_ACC_COL");
                string9 = resultSet.getString("EMP_ACC_COL");
            }
            statement.close();
            statement = null;
            boolean bl = false;
            if (this.userInfo.getUserLevel() != null && Integer.parseInt(this.userInfo.getUserLevel()) > 1) {
                bl = true;
            }
            String string10 = "<?xml version='1.0' encoding='" + this.userInfo.getCharEnc() + "'?>" + "<Root>" + "<header>" + "<objName><![CDATA[" + this.objName + "]]></objName>" + "<pageContext><![CDATA[" + this.pageContext + "]]></pageContext>" + "<objContext><![CDATA[" + this.objContext + "]]></objContext>" + "<editFlag><![CDATA[" + this.localEditFlag + "]]></editFlag>" + "<keyValue><![CDATA[" + (Integer.parseInt(this.objContext.trim()) == 1 ? this.headerDomId : this.detailDomId) + "]]></keyValue>" + "<saveLevel><![CDATA[0]]></saveLevel>" + "<forcedSave><![CDATA[false]]></forcedSave>";
            String string11 = "";
            if (string4 != null && string4.length() > 0) {
                string11 = string10 + "<focusedColumn><![CDATA[" + string4.toLowerCase() + "]]></focusedColumn>" + "</header>" + "<Detail>" + "<" + string4.toLowerCase() + (bl ? " protect='1'>" : ">") + this.userInfo.getSiteCode() + "</" + string4.toLowerCase() + ">" + "</Detail>" + "</Root>";
                this.currentEventContext = this.objContext + ":" + string4.toLowerCase();
                this.applyItemChange(string11);
            }
            if (this.userInfo.getUserType() != null) {
                if (this.userInfo.getUserType().trim().equalsIgnoreCase("P") && string5 != null && string5.length() > 0) {
                    string11 = string10 + "<focusedColumn><![CDATA[" + string5.toLowerCase() + "]]></focusedColumn>" + "</header>" + "<Detail>" + "<" + string5.toLowerCase() + (bl ? " protect='1'>" : ">") + this.userInfo.getEntityCode() + "</" + string5.toLowerCase() + ">" + "</Detail>" + "</Root>";
                    this.currentEventContext = this.objContext + ":" + string5.toLowerCase();
                    this.applyItemChange(string11);
                } else if (this.userInfo.getUserType().trim().equalsIgnoreCase("C") && string6 != null && string6.length() > 0) {
                    string11 = string10 + "<focusedColumn><![CDATA[" + string6.toLowerCase() + "]]></focusedColumn>" + "</header>" + "<Detail>" + "<" + string6.toLowerCase() + (bl ? " protect='1'>" : ">") + this.userInfo.getEntityCode() + "</" + string6.toLowerCase() + ">" + "</Detail>" + "</Root>";
                    this.currentEventContext = this.objContext + ":" + string6.toLowerCase();
                    this.applyItemChange(string11);
                } else if (this.userInfo.getUserType().trim().equalsIgnoreCase("S") && string7 != null && string7.length() > 0) {
                    string11 = string10 + "<focusedColumn><![CDATA[" + string7.toLowerCase() + "]]></focusedColumn>" + "</header>" + "<Detail>" + "<" + string7.toLowerCase() + (bl ? " protect='1'>" : ">") + this.userInfo.getEntityCode() + "</" + string7.toLowerCase() + ">" + "</Detail>" + "</Root>";
                    this.currentEventContext = this.objContext + ":" + string7.toLowerCase();
                    this.applyItemChange(string11);
                } else if (this.userInfo.getUserType().trim().equalsIgnoreCase("E") && string9 != null && string9.length() > 0) {
                    string11 = string10 + "<focusedColumn><![CDATA[" + string9.toLowerCase() + "]]></focusedColumn>" + "</header>" + "<Detail>" + "<" + string9.toLowerCase() + (bl ? " protect='1'>" : ">") + this.userInfo.getEntityCode() + "</" + string9.toLowerCase() + ">" + "</Detail>" + "</Root>";
                    this.currentEventContext = this.objContext + ":" + string9.toLowerCase();
                    this.applyItemChange(string11);
                } else if (string8 != null && string8.length() > 0) {
                    string11 = string10 + "<focusedColumn><![CDATA[" + string8.toLowerCase() + "]]></focusedColumn>" + "</header>" + "<Detail>" + "<" + string8.toLowerCase() + (bl ? " protect='1'>" : ">") + this.userInfo.getItemSer() + "</" + string8.toLowerCase() + ">" + "</Detail>" + "</Root>";
                    this.currentEventContext = this.objContext + ":" + string8.toLowerCase();
                    this.applyItemChange(string11);
                }
            }
            System.out.println("[ITMXFORMEJB]Assigned default values....");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            try {
                if (connection != null) {
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception exception) {
                System.err.println("Exception: ITMXFORMEJB: assignDefaultValues :finally" + exception);
                throw exception;
            }
        }
    }

    private void assignITMDefaultValues(String string, ArrayList arrayList) throws Exception {
        try {
            String string2;
            Object object;
            if (this.requestParamStr != null) {
                object = null;
                string2 = "";
                String string3 = "";
                if (!this.requestParamStr.equals("")) {
                    object = new StringTokenizer(this.requestParamStr, "~");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string4 = ((StringTokenizer)object).nextToken();
                        string2 = string4.substring(0, string4.indexOf("="));
                        string2 = string2.toLowerCase();
                        string3 = string4.substring(string4.indexOf("=") + 1);
                        this.setValueOnDom(this.objContext, string2, string3);
                        String string5 = "";
                        string5 = "<?xml version='1.0' encoding='" + this.userInfo.getCharEnc() + "'?>" + "<Root>" + "<header>" + "<objName><![CDATA[" + this.objName + "]]></objName>" + "<pageContext><![CDATA[" + this.pageContext + "]]></pageContext>" + "<objContext><![CDATA[" + this.objContext + "]]></objContext>" + "<editFlag><![CDATA[" + this.localEditFlag + "]]></editFlag>" + "<focusedColumn><![CDATA[" + string2 + "]]></focusedColumn>" + "<keyValue><![CDATA[" + (Integer.parseInt(this.objContext.trim()) == 1 ? this.headerDomId : this.detailDomId) + "]]></keyValue>" + "<saveLevel><![CDATA[0]]></saveLevel>" + "<forcedSave><![CDATA[false]]></forcedSave>" + "</header>" + "</Root>";
                        this.currentEventContext = this.objContext + ":" + string2;
                        this.applyItemChange(string5);
                    }
                }
            }
            object = "";
            if (string.equalsIgnoreCase("A")) {
                object = "itm_default";
            } else if (string.equalsIgnoreCase("E")) {
                object = "itm_defaultedit";
            }
            if (arrayList.contains(object)) {
                string2 = "";
                string2 = "<?xml version='1.0' encoding='" + this.userInfo.getCharEnc() + "'?>" + "<Root>" + "<header>" + "<objName><![CDATA[" + this.objName + "]]></objName>" + "<pageContext><![CDATA[" + this.pageContext + "]]></pageContext>" + "<objContext><![CDATA[" + this.objContext + "]]></objContext>" + "<editFlag><![CDATA[" + this.localEditFlag + "]]></editFlag>" + "<focusedColumn><![CDATA[" + (String)object + "]]></focusedColumn>" + "<keyValue><![CDATA[" + (Integer.parseInt(this.objContext.trim()) == 1 ? this.headerDomId : this.detailDomId) + "]]></keyValue>" + "<saveLevel><![CDATA[0]]></saveLevel>" + "<forcedSave><![CDATA[false]]></forcedSave>" + "</header>" + "</Root>";
                this.currentEventContext = this.objContext + ":" + (String)object;
                this.applyItemChange(string2);
            }
            System.out.println("[ITMXFORMEJB]Assigned itm default values....");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private Document parseString(String string) throws ITMException {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setIgnoringComments(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)System.err, this.userInfo.getCharEnc());
            System.out.println("userInfo.getCharEnc() [" + this.userInfo.getCharEnc() + "]");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(this.userInfo.getCharEnc()));
            document = documentBuilder.parse(byteArrayInputStream);
        }
        catch (Exception exception) {
            System.out.println("Exception : ITMXFORMEJB : parseString :" + exception);
            throw new ITMException(exception);
        }
        return document;
    }

    private Node searchNode(Document document, String string, String string2) throws ITMException {
        Node node = null;
        try {
            string = string == null || string.length() == 0 ? "1" : string;
            string2 = string2 == null || string2.length() == 0 ? "1" : string2;
            System.out.println("searchNode : objContext :" + string + "nodeID :" + string2 + ": dom :" + document);
            NodeList nodeList = document.getElementsByTagName("Detail" + string);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                if (!node2.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(string2)) continue;
                node = node2;
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception : ITMXFORMEJB : searchNode :" + exception);
            throw new ITMException(exception);
        }
        return node;
    }

    private String serializeDom(Node node) throws ITMException {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (node.getNodeType() == 1) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.setOutputProperty("encoding", this.userInfo.getCharEnc());
            transformer.transform(new DOMSource(node), new StreamResult(byteArrayOutputStream));
            string = byteArrayOutputStream.toString();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
        }
        catch (Exception exception) {
            System.out.println("Exception : ITMXFORMEJB : serializeDom :" + exception);
            throw new ITMException(exception);
        }
        return string;
    }

    private String getNormalizedString(String string) throws ITMException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("<DocumentRoot>");
            stringBuffer.append("<description>Datawindow Root</description>");
            stringBuffer.append("<group0>");
            stringBuffer.append("<description>Group0 description</description>");
            stringBuffer.append("<Header0>");
            stringBuffer.append("<description>Header0 members</description>");
            stringBuffer.append(string);
            stringBuffer.append("</Header0>");
            stringBuffer.append("</group0>");
            stringBuffer.append("</DocumentRoot>");
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
        return stringBuffer.toString();
    }

    private NodeList searchNodes(Document document, String string) throws ITMException {
        NodeList nodeList = null;
        try {
            string = string == null ? "1" : string;
            nodeList = document.getElementsByTagName("Detail" + string);
        }
        catch (Exception exception) {
            System.out.println("Exception : ITMXFORMEJB : searchNodes :" + exception);
            throw new ITMException(exception);
        }
        return nodeList;
    }

    private void updateHeaderInfoMap(String string) throws Exception {
        System.out.println("updateHeaderInfoMap : xmlStr :" + string);
        HashMap<String, Object> hashMap = null;
        Document document = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "false";
        hashMap = new HashMap<String, Object>();
        if (string != null && !string.equalsIgnoreCase("-1")) {
            document = this.parseString(string);
            if (document.getElementsByTagName("saveLevel").item(0) != null && document.getElementsByTagName("saveLevel").item(0).getFirstChild() != null) {
                this.saveLevel = document.getElementsByTagName("saveLevel").item(0).getFirstChild().getNodeValue().trim();
                hashMap.put("saveLevel", this.saveLevel);
            }
            if (document.getElementsByTagName("forcedSave").item(0) != null && document.getElementsByTagName("forcedSave").item(0).getFirstChild() != null) {
                string10 = document.getElementsByTagName("forcedSave").item(0).getFirstChild().getNodeValue().trim();
                hashMap.put("forcedSave", string10);
            }
            if (document.getElementsByTagName("focusedColumn").item(0) != null && document.getElementsByTagName("focusedColumn").item(0).getFirstChild() != null) {
                string3 = document.getElementsByTagName("focusedColumn").item(0).getFirstChild().getNodeValue().trim();
                hashMap.put("focusedColumn", string3);
            }
            if (document.getElementsByTagName("objName").item(0) != null && document.getElementsByTagName("objName").item(0).getFirstChild() != null) {
                string4 = document.getElementsByTagName("objName").item(0).getFirstChild().getNodeValue().trim();
                hashMap.put("objName", string4);
                if (this.objName == null) {
                    this.objName = string4;
                }
            }
            if (document.getElementsByTagName("editFlag").item(0) != null && document.getElementsByTagName("editFlag").item(0).getFirstChild() != null) {
                string5 = document.getElementsByTagName("editFlag").item(0).getFirstChild().getNodeValue().trim();
                hashMap.put("editFlag", string5);
                this.localEditFlag = string5;
            }
            if (document.getElementsByTagName("objContext").item(0) != null && document.getElementsByTagName("objContext").item(0).getFirstChild() != null) {
                string6 = document.getElementsByTagName("objContext").item(0).getFirstChild().getNodeValue().trim();
                hashMap.put("objContext", string6);
            }
            if (document.getElementsByTagName("keyValue").item(0) != null && document.getElementsByTagName("keyValue").item(0).getFirstChild() != null) {
                string7 = document.getElementsByTagName("keyValue").item(0).getFirstChild().getNodeValue().trim();
                hashMap.put("keyValue", Integer.parseInt(string6.trim()) == 1 ? this.headerDomId : string7);
            }
            if (document.getElementsByTagName("pkValues").item(0) != null && document.getElementsByTagName("pkValues").item(0).getFirstChild() != null) {
                string8 = document.getElementsByTagName("pkValues").item(0).getFirstChild().getNodeValue().trim();
                hashMap.put("pkValues", string8);
            }
            if (document.getElementsByTagName("action").item(0) != null && document.getElementsByTagName("action").item(0).getFirstChild() != null) {
                string9 = document.getElementsByTagName("action").item(0).getFirstChild().getNodeValue().trim();
                hashMap.put("action", string9);
            }
            if (document.getElementsByTagName("elementName").item(0) != null) {
                if (document.getElementsByTagName("elementName").item(0).getFirstChild() != null) {
                    string11 = document.getElementsByTagName("elementName").item(0).getFirstChild().getNodeValue().trim();
                    hashMap.put("elementName", string11);
                }
            } else {
                hashMap.put("elementName", string11);
            }
            if (document.getElementsByTagName("taxInFocus").item(0) != null) {
                if (document.getElementsByTagName("taxInFocus").item(0).getFirstChild() != null) {
                    string12 = document.getElementsByTagName("taxInFocus").item(0).getFirstChild().getNodeValue().trim();
                    hashMap.put("taxInFocus", Boolean.valueOf(string12));
                }
            } else {
                hashMap.put("taxInFocus", Boolean.valueOf(string12));
            }
            if (document.getElementsByTagName("taxKeyValue").item(0) != null && document.getElementsByTagName("taxKeyValue").item(0).getFirstChild() != null) {
                this.taxDomId = document.getElementsByTagName("taxKeyValue").item(0).getFirstChild().getNodeValue().trim();
                hashMap.put("taxKeyValue", this.taxDomId);
            }
            if (document.getElementsByTagName("transKeyValue").item(0) != null && document.getElementsByTagName("transKeyValue").item(0).getFirstChild() != null) {
                this.headerPKFieldValues = document.getElementsByTagName("transKeyValue").item(0).getFirstChild().getNodeValue().trim();
            }
            if (document.getElementsByTagName("wrkflwProcInstId").item(0) != null && document.getElementsByTagName("wrkflwProcInstId").item(0).getFirstChild() != null) {
                this.wrkflwProcInstId = document.getElementsByTagName("wrkflwProcInstId").item(0).getFirstChild().getNodeValue().trim();
                System.out.println("this.wrkflwProcInstId [" + this.wrkflwProcInstId + "]");
            }
            if (document.getElementsByTagName("isModeInteractive").item(0) != null && document.getElementsByTagName("isModeInteractive").item(0).getFirstChild() != null) {
                String string13 = document.getElementsByTagName("isModeInteractive").item(0).getFirstChild().getNodeValue().trim();
                hashMap.put("isModeInteractive", Boolean.valueOf(string13));
            }
        }
        if (Integer.parseInt(string6.trim()) == 1) {
            this.editFlag = this.localEditFlag;
        }
        if (!this.detailDomId.equals(string7) || !this.objContext.equals(string6)) {
            this.currRecordNode = null;
            this.currTaxNode = null;
        }
        this.detailDomId = string7;
        this.objContext = string6;
        this.headerInfoMap = hashMap;
    }

    private String handleItemChange(String string) throws ITMException {
        block10: {
            System.out.println("handleItemChange called for xmlStr :\n :" + string);
            try {
                Document document = null;
                if (string == null || string.equals("-1")) break block10;
                document = this.parseString(string);
                this.focussedColumn = (String)this.headerInfoMap.get("focusedColumn");
                this.saveLevel = (String)this.headerInfoMap.get("saveLevel");
                String string2 = (String)this.headerInfoMap.get("objContext");
                DWObject dWObject = this.getDWObject(this.objName, Integer.parseInt(string2.trim()));
                Hashtable hashtable = dWObject.getUpdateableLogNameColType();
                Node node = null;
                System.out.println("Creating domDetailDom for objContext :[" + this.objContext + "] this.headerDomId :[" + this.headerDomId + "] this.detailDomId :[" + this.detailDomId + "]");
                if (document.getElementsByTagName("Root").item(0) == null) break block10;
                Node node2 = document.getElementsByTagName("Root").item(0);
                NodeList nodeList = node2.getChildNodes();
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node3 = nodeList.item(i);
                    String string3 = node3.getNodeName();
                    String string4 = null;
                    String string5 = null;
                    System.out.println("tagName [" + string3 + "]");
                    if (!string3.startsWith("Detail")) continue;
                    String string6 = string4 = string3.length() > "Detail".length() ? string3.substring("Detail".length()) : this.objContext;
                    if (!string2.trim().equals(string4)) {
                        dWObject = this.getDWObject(this.objName, Integer.parseInt(string4));
                        hashtable = dWObject.getUpdateableLogNameColType();
                    }
                    String string7 = string5 = string4 != null && string4.equalsIgnoreCase("1") ? "1" : null;
                    if (node3.getAttributes().getNamedItem("domID") != null) {
                        string5 = node3.getAttributes().getNamedItem("domID").getNodeValue();
                    }
                    System.out.println("Searching corresponding data to which changes to be appied domIdStr :[" + string5 + "]");
                    System.out.println("is tax in focus :[" + (Boolean)this.headerInfoMap.get("taxInFocus") + "]");
                    if (((Boolean)this.headerInfoMap.get("taxInFocus")).booleanValue()) {
                        String string8 = string5 = string5 != null && string5.length() > 0 ? string5 : (String)this.headerInfoMap.get("taxKeyValue");
                        if (this.currTaxNode == null) {
                            this.currTaxNode = this.getCurrTaxNode();
                        }
                        NodeList nodeList2 = this.currTaxNode.getChildNodes();
                        int n2 = 0;
                        for (int j = 0; j < nodeList2.getLength(); ++j) {
                            Node node4 = nodeList2.item(j);
                            if (node4.getNodeType() != 1 || !string5.equalsIgnoreCase("" + ++n2)) continue;
                            node = node4;
                            break;
                        }
                    } else {
                        string5 = string5 != null && string5.length() > 0 ? string5 : (String)this.headerInfoMap.get("keyValue");
                        node = this.searchNode(this.detailDom, string4, string5);
                    }
                    this.applyDataToXML(node3, node, hashtable);
                }
                if (this.localEditFlag.equalsIgnoreCase("D")) {
                    node = this.searchNode(this.detailDom, this.objContext, (String)this.headerInfoMap.get("keyValue"));
                    this.applyDataToXML(document, node, hashtable);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception : ITMXFORMEJB : handleItemChange :" + exception);
                throw new ITMException(exception);
            }
        }
        return string;
    }

    private String recalculateTax() throws ITMException {
        String string = "";
        try {
            ReCalculateTax reCalculateTax = new ReCalculateTax();
            if (this.currTaxNode == null) {
                this.currTaxNode = this.getCurrTaxNode(this.objContext, this.detailDomId);
            }
            reCalculateTax.setTaxTranDom(this.currRecordNode, this.currTaxNode, this.objContext, this.detailDomId);
            string = reCalculateTax.reCalculate(this.rateCol, this.qtyCol);
            this.isTaxChanged = true;
        }
        catch (Exception exception) {
            System.out.println("Exception : ITMXFORMEJB : recalculateTax :" + exception);
            throw new ITMException(exception);
        }
        return string;
    }

    private Node getCurrTaxNode() throws Exception {
        Node node = null;
        try {
            NodeList nodeList = this.currRecordNode.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                if (!nodeList.item(i).getNodeName().equalsIgnoreCase("Taxes")) continue;
                node = nodeList.item(i);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception:ITMXFORMEJB: getCurrTaxNode:" + exception);
            throw new ITMException(exception);
        }
        return node;
    }

    private String getAllTaxesXMLString(String string, String string2) throws ITMException {
        System.out.println("[ITMXFORMEJB]Getting all taxes string for objContext :" + string + ":");
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "";
        try {
            NodeList nodeList = this.detailDom.getElementsByTagName("Detail" + string);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(string2)) continue;
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node2 = nodeList2.item(j);
                    if (!node2.getNodeName().equalsIgnoreCase("Taxes")) continue;
                    stringBuffer.append(this.serializeDom(node2)).append("\n");
                }
            }
            string3 = stringBuffer.toString();
        }
        catch (Exception exception) {
            System.out.println("Exception :ITMXFORMEJB :getAllTaxesString :==>" + exception);
            throw new ITMException(exception);
        }
        System.out.println("changed all taxesXmlString.length() :[" + string3.length() + "]");
        return string3;
    }

    private Node getCurrTaxNode(String string, String string2) throws Exception {
        Node node = null;
        try {
            System.out.println("ITMXFORMEJB : getCurrTaxNode : objContext :" + string + ": domID :" + string2 + ":");
            Node node2 = this.searchNode(this.detailDom, string, string2);
            if (node2 != null) {
                NodeList nodeList = node2.getChildNodes();
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    if (!nodeList.item(i).getNodeName().equalsIgnoreCase("Taxes")) continue;
                    node = nodeList.item(i);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception:ITMXFORMEJB: getCurrTaxNode(String objContext, String domID):" + exception);
            throw new ITMException(exception);
        }
        return node;
    }

    private String getChangedXMLString() throws ITMException {
        System.out.println("Building Changed XML String for ChaNge Data Map size :[" + this.changedDataMap.size() + "]");
        String string = "";
        try {
            StringBuffer stringBuffer = new StringBuffer("<?xml version='1.0' encoding='" + this.userInfo.getCharEnc() + "'?><Root>\n");
            if (this.changedDataMap.size() > 0) {
                int n;
                Object object;
                int n2;
                Set set = this.changedDataMap.keySet();
                Iterator iterator = set.iterator();
                Object var5_6 = null;
                Object var6_7 = null;
                boolean bl = true;
                ArrayList arrayList = new ArrayList(this.noOfForms);
                for (n2 = 0; n2 < this.noOfForms; ++n2) {
                    arrayList.add(null);
                }
                while (iterator.hasNext()) {
                    StringBuffer stringBuffer2;
                    int n3;
                    String string2 = (String)iterator.next();
                    object = string2.substring(0, string2.indexOf("_"));
                    n = string2.indexOf("_", string2.indexOf("_") + 1);
                    String string3 = string2.substring(string2.indexOf("_") + 1, n);
                    String string4 = string2.substring(n + 1);
                    Node node = (Node)this.changedDataMap.get(string2);
                    ArrayList<StringBuffer> arrayList2 = (ArrayList<StringBuffer>)arrayList.get(Integer.parseInt((String)object) - 1);
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<StringBuffer>();
                        arrayList.set(Integer.parseInt((String)object) - 1, arrayList2);
                    }
                    if (Integer.parseInt(string3) > n3) {
                        for (n3 = arrayList2.size(); n3 < Integer.parseInt(string3); ++n3) {
                            arrayList2.add(null);
                        }
                    }
                    if ((stringBuffer2 = (StringBuffer)arrayList2.get(Integer.parseInt(string3) - 1)) == null) {
                        stringBuffer2 = new StringBuffer();
                    }
                    arrayList2.set(Integer.parseInt(string3) - 1, stringBuffer2.append(this.serializeDom(node)));
                }
                for (n2 = 0; n2 < this.noOfForms; ++n2) {
                    object = (ArrayList)arrayList.get(n2);
                    if (object == null) continue;
                    n = ((ArrayList)object).size();
                    for (int i = 0; i < n; ++i) {
                        if (((ArrayList)object).get(i) == null) continue;
                        stringBuffer.append("<Detail" + (n2 + 1) + "  domID='" + (i + 1) + "'>");
                        stringBuffer.append(((ArrayList)object).get(i).toString());
                        if (this.isTaxChanged && n2 + 1 == Integer.parseInt(this.objContext) && i + 1 == Integer.parseInt(this.detailDomId)) {
                            stringBuffer.append(this.getAllTaxesXMLString(this.objContext, this.detailDomId));
                            this.isTaxChanged = false;
                        }
                        stringBuffer.append("</Detail" + (n2 + 1) + ">");
                    }
                }
            }
            if (this.isTaxChanged) {
                stringBuffer.append("<Detail" + this.objContext + "  domID='" + this.detailDomId + "'>");
                stringBuffer.append(this.getAllTaxesXMLString(this.objContext, this.detailDomId));
                stringBuffer.append("</Detail" + this.objContext + ">");
            }
            stringBuffer.append("</Root>\n");
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            System.out.println("Exception :ITMXFORMEJB : getChangedXMLString :" + exception);
            throw new ITMException(exception);
        }
        return string;
    }

    private DWObject getDWObject(String string, int n) throws ITMException {
        DWObject dWObject = null;
        try {
            String string2 = string + "2" + n;
            DWFactory dWFactory = DWFactory.getDWFactory();
            dWObject = dWFactory.getDataWindow(string2);
        }
        catch (Exception exception) {
            System.out.println("Exception : ITMXFORMEJB : getDWObject :" + exception);
            throw new ITMException(exception);
        }
        return dWObject;
    }

    private void setValueOnDom(String string, String string2, String string3) throws ITMException {
        try {
            System.out.println("Setting value for obj context :[" + string + "] element name :[" + string2 + "] value :[" + string3 + "]");
            if (string == null || string != null && string.length() > 0) {
                string = "1";
            }
            NodeList nodeList = this.detailDom.getElementsByTagName("Detail" + string);
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                NodeList nodeList2 = node.getChildNodes();
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node2 = nodeList2.item(j);
                    String string4 = node2.getNodeName();
                    if (node2.getNodeType() != 1 || string4 == null || !string4.equals(string2)) continue;
                    Node node3 = node2.getFirstChild();
                    if (node3 != null && node3.getNodeValue() != null) {
                        node3.setNodeValue(string3);
                        continue;
                    }
                    CDATASection cDATASection = this.detailDom.createCDATASection(string3);
                    node2.appendChild(cDATASection);
                }
            }
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
    }

    private void setFocus() throws Exception {
        Document document = null;
        String string = "1";
        if (this.objContext.equalsIgnoreCase("1")) {
            document = this.headerListDom;
            string = this.viewDomId;
        } else {
            document = this.detailDom;
            string = this.detailDomId;
        }
        NodeList nodeList = this.searchNodes(document, this.objContext);
        int n = nodeList.getLength();
        block0: for (int i = 0; i < n; ++i) {
            Node node;
            int n2;
            int n3;
            NodeList nodeList2;
            Node node2 = nodeList.item(i);
            if (node2.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(string)) {
                nodeList2 = node2.getChildNodes();
                n3 = nodeList2.getLength();
                for (n2 = 0; n2 < n3; ++n2) {
                    node = nodeList2.item(n2);
                    if (!node.getNodeName().equalsIgnoreCase("attribute") || node.getAttributes().getNamedItem("selected") == null) continue;
                    node.getAttributes().getNamedItem("selected").setNodeValue("Y");
                    continue block0;
                }
                continue;
            }
            nodeList2 = node2.getChildNodes();
            n3 = nodeList2.getLength();
            for (n2 = 0; n2 < n3; ++n2) {
                node = nodeList2.item(n2);
                if (!node.getNodeName().equalsIgnoreCase("attribute") || node.getAttributes().getNamedItem("selected") == null) continue;
                node.getAttributes().getNamedItem("selected").setNodeValue("N");
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debug(String string, String[] stringArray, String string2) {
        BufferedWriter bufferedWriter = null;
        try {
            if ("0".equals(CommonConstants.USER_LOG)) {
                return;
            }
            String string3 = CommonConstants.JBOSSHOME + File.separator + "log" + File.separator + this.userInfo.getLoginCode();
            bufferedWriter = new BufferedWriter(new FileWriter(string3, true));
            if ("1".equals(string2)) {
                bufferedWriter.newLine();
                bufferedWriter.write("===================[Start--" + string + "---Start]===================");
                bufferedWriter.newLine();
                if (this.detailDom != null) {
                    bufferedWriter.write("[" + new Date() + "]Detail dom before action :\n[\n" + this.serializeDom(this.detailDom) + "\n]\n");
                }
                bufferedWriter.newLine();
                for (int i = 0; i < stringArray.length; i += 2) {
                    bufferedWriter.write("[" + new Date() + "]" + string + "[arg name] :[arg value] :[" + stringArray[i] + "] :[" + stringArray[i + 1] + "]");
                    bufferedWriter.newLine();
                }
            } else {
                bufferedWriter.write("[" + new Date() + "]Response to action :[" + string + "] :[" + string2 + "]");
                bufferedWriter.newLine();
                if (this.detailDom != null) {
                    bufferedWriter.write("[" + new Date() + "]Detail dom after action :\n[\n" + this.serializeDom(this.detailDom) + "\n]\n");
                }
                bufferedWriter.newLine();
                bufferedWriter.write("===================[End--" + string + "--End]===================");
                bufferedWriter.newLine();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    bufferedWriter = null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bufferedWriter = null;
            }
        }
    }

    private String getXtraParams() throws Exception {
        Object object;
        String string;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("loginCode=" + this.userInfo.getLoginCode());
        stringBuffer.append("~~").append("loginEmpCode=" + this.userInfo.getEmpCode());
        stringBuffer.append("~~").append("loginSiteCode=" + this.userInfo.getSiteCode());
        stringBuffer.append("~~").append("entityCode=" + this.userInfo.getEntityCode());
        stringBuffer.append("~~").append("profileId=" + this.userInfo.getProfileId());
        stringBuffer.append("~~").append("userType=" + this.userInfo.getUserType());
        stringBuffer.append("~~").append("runMode=I");
        stringBuffer.append("~~").append("user_lang=" + this.user_lang);
        stringBuffer.append("~~").append("user_country=" + this.user_country);
        stringBuffer.append("~~").append("charEnc=" + this.userInfo.getCharEnc());
        stringBuffer.append("~~").append("termId=" + this.userInfo.getRemoteHost());
        stringBuffer.append("~~").append("chgTerm=" + this.userInfo.getRemoteHost());
        NodeList nodeList = this.searchNodes(this.detailDom, this.objContext);
        int n = nodeList != null ? nodeList.getLength() : 0;
        String string2 = this.objContext.equals("1") ? this.headerDomId : this.detailDomId;
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            object2 = nodeList.item(i);
            string = "";
            object = object2.getChildNodes();
            int n4 = object.getLength();
            for (int j = 0; j < n4; ++j) {
                Node node = object.item(j);
                if (!node.getNodeName().equalsIgnoreCase("attribute")) continue;
                string = node.getAttributes().getNamedItem("updateFlag").getNodeValue();
                break;
            }
            if (string.equalsIgnoreCase("D")) continue;
            ++n3;
            String string3 = object2.getAttributes().getNamedItem("domID").getNodeValue();
            if (!string3.equals(string2)) continue;
            n2 = n3;
        }
        stringBuffer.append("~~").append("detCnt=" + n3);
        stringBuffer.append("~~").append("focusRow=" + n2);
        if (this.argFieldValues != null && this.argFieldValues.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.argFieldNames, ":");
            object2 = new StringTokenizer(this.argFieldValues, ":");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                object = ((StringTokenizer)object2).nextToken();
                if (stringBuffer.toString().indexOf("~~" + string + "=") != -1) continue;
                stringBuffer.append("~~").append(string + "=" + (String)object);
            }
        }
        stringBuffer.append("~~").append("REC_CTR=" + this.recCtr);
        stringBuffer.append("~~").append("saveLevel=" + this.saveLevel);
        System.out.println("[ITMXFORMEJB]XTRA_PARAMS :" + stringBuffer.toString());
        return stringBuffer.toString();
    }

    private String applyDataToXML(Node node, Node node2, Hashtable hashtable) throws ITMException {
        String string;
        block34: {
            System.out.println("[ITMXFORMEJB]Applying Data To Xml ...........");
            string = "";
            try {
                Object object;
                String string2;
                Object object2;
                int n;
                String string3 = this.localEditFlag;
                boolean bl = false;
                NodeList nodeList = node2.getChildNodes();
                int n2 = nodeList.getLength();
                String string4 = (Boolean)this.headerInfoMap.get("taxInFocus") != false ? this.detailDomId : node2.getAttributes().getNamedItem("domID").getNodeValue();
                String string5 = (Boolean)this.headerInfoMap.get("taxInFocus") != false ? this.objContext : node2.getAttributes().getNamedItem("objContext").getNodeValue();
                NodeList nodeList2 = node.getChildNodes();
                int n3 = nodeList2.getLength();
                block2: for (n = 0; n < n3; ++n) {
                    if (nodeList2.item(n).getNodeType() != 1) continue;
                    object2 = nodeList2.item(n).getNodeName();
                    string2 = "";
                    object = nodeList2.item(n).getFirstChild();
                    String string6 = (String)hashtable.get(object2);
                    System.out.println("dataType" + string6);
                    if (object != null) {
                        string2 = string6 != null && string6.length() > 0 ? (string6.toUpperCase().indexOf("XMLTYPE") != -1 ? this.serializeDom((Node)object) : object.getNodeValue()) : object.getNodeValue();
                    }
                    NamedNodeMap namedNodeMap = nodeList2.item(n).getAttributes();
                    for (int i = 0; i < n2; ++i) {
                        String string7;
                        Object object3;
                        Object object4;
                        Object object5;
                        Node node3 = nodeList.item(i);
                        NamedNodeMap namedNodeMap2 = node3.getAttributes();
                        String string8 = node3.getNodeName();
                        if (!((String)object2).equals(string8)) continue;
                        CDATASection cDATASection = null;
                        if (string6 != null) {
                            String string9 = null;
                            object5 = null;
                            object4 = null;
                            if (string6.toUpperCase().indexOf("DATETIME") != -1 || string6.toUpperCase().indexOf("TIMESTAMP") != -1) {
                                string9 = string2;
                                object5 = this.getDispDateFormat();
                                object3 = new GenericUtility().getDispDateTimeFormat();
                                object4 = string9 != null && string9.length() > 0 ? new GenericUtility().getValidDateTimeString(string9, new GenericUtility().getApplDateTimeFormat()) : "";
                                cDATASection = this.detailDom.createCDATASection((String)object4);
                            } else if (string6.toUpperCase().indexOf("DATE") != -1) {
                                string9 = string2;
                                object5 = this.getDispDateFormat();
                                object4 = string9 != null && string9.length() > 0 ? new GenericUtility().getValidDateString(string9, new GenericUtility().getApplDateFormat()) : "";
                                cDATASection = this.detailDom.createCDATASection((String)object4);
                            } else if (string6.toUpperCase().indexOf("TIME") != -1) {
                                string9 = string2;
                                object5 = new GenericUtility().getDisplayTimeFormat();
                                object4 = string9 != null && string9.length() > 0 ? new GenericUtility().getValidDateString(string9, (String)object5, "hh:mm:ss") : "";
                                cDATASection = this.detailDom.createCDATASection((String)object4);
                            } else if (string6.toUpperCase().indexOf("XMLTYPE") == -1) {
                                cDATASection = this.detailDom.createCDATASection(string2);
                            }
                        } else {
                            cDATASection = this.detailDom.createCDATASection(string2);
                        }
                        int n4 = namedNodeMap2.getLength();
                        for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                            object4 = namedNodeMap.item(j);
                            object3 = object4.getNodeName().trim();
                            string7 = object4.getNodeValue().trim();
                            boolean bl2 = false;
                            for (int k = 0; k < n4; ++k) {
                                Node node4 = namedNodeMap2.item(k);
                                String string10 = node4.getNodeName().trim();
                                if (!((String)object3).equals(string10)) continue;
                                bl2 = true;
                                node4.setNodeValue(string7);
                            }
                            if (bl2) continue;
                            ((Element)node3).setAttribute((String)object3, string7);
                        }
                        if (nodeList.item(i).getFirstChild() != null) {
                            if (nodeList.item(i).getFirstChild().getNodeValue() != null) {
                                System.out.println("Values \t:" + nodeList.item(i).getFirstChild().getNodeValue() + ": BY :" + string2);
                            } else {
                                System.out.println("Values \t:" + this.serializeDom(nodeList.item(i).getFirstChild()) + ": BY :" + string2);
                            }
                        } else {
                            System.out.println("Values \t:: BY :" + string2);
                        }
                        object5 = node3.getFirstChild();
                        if (object5 != null) {
                            if (object5.getNodeValue() != null) {
                                object5.setNodeValue(string2);
                            } else if (string6 != null && string6.length() > 0 && string6.toUpperCase().indexOf("XMLTYPE") != -1) {
                                node3.replaceChild(node3.getOwnerDocument().importNode((Node)object, true), node3.getFirstChild());
                            }
                        } else {
                            node3.appendChild(cDATASection);
                        }
                        System.out.println("REPLACED.........");
                        object4 = string5 + "_" + string4 + "_" + (String)object2;
                        if (!this.changedDataMap.containsKey(object4)) {
                            System.out.println("key :" + (String)object4);
                            this.changedDataMap.put(object4, node3);
                        }
                        if (!this.isAuditTrailOn) continue block2;
                        object3 = this.auditDataMap.get(string5) != null ? (TreeMap)this.auditDataMap.get(string5) : new TreeMap();
                        string7 = string4 + "_" + (String)object2;
                        ((TreeMap)object3).put(string7, string2);
                        this.auditDataMap.put(string5, object3);
                        System.out.println("auditDataMap [" + this.auditDataMap + "]");
                        continue block2;
                    }
                }
                for (n = 0; n < n2; ++n) {
                    object2 = nodeList.item(n);
                    string2 = object2.getNodeName();
                    object = null;
                    if (!string2.equalsIgnoreCase("attribute")) continue;
                    if (object2.getAttributes().getNamedItem("status") != null && ((String)(object = object2.getAttributes().getNamedItem("status").getNodeValue())).equalsIgnoreCase("O")) {
                        bl = true;
                    }
                    if (object2.getAttributes().getNamedItem("updateFlag") == null || object2.getAttributes().getNamedItem("updateFlag").getNodeValue().equals("D")) break;
                    if (bl) {
                        if (string3.equalsIgnoreCase("D")) {
                            if (this.objContext.equals(string5) && this.headerInfoMap.get("keyValue").equals(string4)) {
                                object2.getAttributes().getNamedItem("updateFlag").setNodeValue(string3);
                                if (!this.isAuditTrailOn) break;
                                this.updateAuditDataMap(string5, string4, node2);
                                break;
                            }
                            object2.getAttributes().getNamedItem("updateFlag").setNodeValue("E");
                            break;
                        }
                        object2.getAttributes().getNamedItem("updateFlag").setNodeValue("E");
                        break;
                    }
                    if (!string3.equalsIgnoreCase("D") || !this.objContext.equals(string5) || !this.headerInfoMap.get("keyValue").equals(string4)) break;
                    System.out.println("Deleting newly added record from DOM........");
                    this.detailDom.getElementsByTagName("Header0").item(0).removeChild(node2);
                    break;
                }
                System.out.println("Is Tax in Focus :[" + (Boolean)this.headerInfoMap.get("taxInFocus") + "]");
                System.out.println("[currentRecordId==focussedRowId][" + string4 + "==" + this.headerInfoMap.get("keyValue") + "]");
                if (!((Boolean)this.headerInfoMap.get("taxInFocus")).booleanValue()) break block34;
                for (n = 0; n < n2; ++n) {
                    if (!this.objContext.equals(string5) || !this.headerInfoMap.get("keyValue").equals(string4) || !(string2 = (object2 = nodeList.item(n)).getNodeName()).equalsIgnoreCase("chg_stat")) continue;
                    System.out.println("Updating chg_stat as FROZEN for the edited Tax Record....");
                    if (object2.getFirstChild() != null) {
                        object2.getFirstChild().setNodeValue("F");
                    } else {
                        object = this.detailDom.createCDATASection("F");
                        object2.appendChild((Node)object);
                    }
                    System.out.println("Updated chg_stat as FROZEN....");
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("Exception : ITMXFORMEJB : applyDataToXML :" + exception);
                throw new ITMException(exception);
            }
        }
        return string;
    }

    private String getDispDateFormat() throws ITMException, Exception {
        String string = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(".." + File.separator + "setting" + File.separator + "DateFormat.xml");
            NodeList nodeList = document.getElementsByTagName("DISP_DATE_FORMAT");
            Node node = nodeList.item(0);
            string = node.getFirstChild().getNodeValue();
        }
        catch (Exception exception) {
            System.out.println("Exception :ITMXFORMEJB :getDispDateFormat :==>\n" + exception);
            throw new ITMException(exception);
        }
        return string;
    }

    private void updateAuditDataMap(String string, String string2, Node node) {
        try {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                String string3 = node2.getNodeName();
                String string4 = node2.getNodeValue();
                if ("attribute".equals(string3)) continue;
                String string5 = string2 + "_" + string3;
                if (this.auditDataMap.get(string) != null) {
                    System.out.println("auditDataMap old objContext [" + string + "] for key [" + string5 + "] Value [" + string4 + "]");
                    ((TreeMap)this.auditDataMap.get(string)).put(string5, string4);
                    continue;
                }
                System.out.println("auditDataMap new objContext [" + string + "] for key [" + string5 + "] Value [" + string4 + "]");
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                treeMap.put(string5, string4);
                this.auditDataMap.put(string, treeMap);
            }
            System.out.println("After updateAuditDataMap auditDataMap [" + this.auditDataMap + "]");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setArgFieldValues(String string) throws RemoteException, ITMException {
        try {
            String string2 = "";
            if (string != null && string.length() > 0) {
                System.out.println("[XfromEJB]this.argFieldTypes :" + this.argFieldTypes);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                StringTokenizer stringTokenizer2 = new StringTokenizer(this.argFieldTypes, ":");
                while (stringTokenizer2.hasMoreTokens() && stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    string2 = string3.equalsIgnoreCase("DATETIME") || string3.equalsIgnoreCase("DATE") ? string2 + (string4 != null && string4.length() > 0 ? this.getValidDateString(string4, this.getDispDateFormat(), this.getApplDateFormat()) : string4) : string2 + string4;
                    string2 = string2 + ":";
                }
                System.out.println("[XfromEJB]argFieldValuesNew :" + string2);
                this.argFieldValues = string2;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :XfromEJB :argFieldValues :==>");
            exception.printStackTrace();
            throw new ITMException(exception);
        }
    }

    private String getValidDateString(String string, String string2, String string3) throws ITMException {
        System.out.println("[XfromEJB]Converting dateStr :[" + string + "] From format :[" + string2 + "] To Format :[" + string3 + "]");
        Date date = null;
        String string4 = "";
        try {
            if (!string2.equalsIgnoreCase(string3)) {
                if (string2.indexOf("/") != -1) {
                    string.replace('/', '-');
                } else if (string2.indexOf(".") != -1) {
                    string.replace('.', '-');
                }
                date = new SimpleDateFormat(string2).parse(string);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
                string4 = simpleDateFormat.format((Object)date);
            } else {
                string4 = string;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception :XfromEJB :getValidDateString :==>" + exception.getMessage());
            throw new ITMException(exception);
        }
        System.out.println("[XfromEJB]Converted Datestr :[" + string4 + "]");
        return string4;
    }

    private String getApplDateFormat() throws ITMException, Exception {
        String string = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(".." + File.separator + "setting" + File.separator + "DateFormat.xml");
            NodeList nodeList = document.getElementsByTagName("APPL_DATE_FORMAT");
            Node node = nodeList.item(0);
            string = node.getFirstChild().getNodeValue();
        }
        catch (Exception exception) {
            System.out.println("Exception :DB2XMLGenerator :getApplDateFormat :==>\n" + exception);
            throw new ITMException(exception);
        }
        return string;
    }

    public String getBlankDomForAdd(String string, String string2, String string3, ArrayList arrayList, String string4) throws RemoteException, ITMException {
        String string5 = "";
        Object var7_7 = null;
        try {
            XMLBuilder xMLBuilder = new XMLBuilder();
            if (string4 != null && string4.length() > 0) {
                this.userInfo = new UserInfoBean(string4);
            }
            String string6 = "";
            System.out.println("Creating xml from bin metadata");
            string6 = CommonConstants.JBOSSHOME + File.separator + "bin" + File.separator + "metadata" + File.separator;
            String string7 = string + string3 + string2 + ".xml";
            string5 = xMLBuilder.getDomForAdd(string, string2, string6 + string7);
        }
        catch (ITMException iTMException) {
            System.out.println("ITMException: ITMXFORMEJB: getBlankDomForAdd: ==>\n");
            throw iTMException;
        }
        catch (Exception exception) {
            System.out.println("Exception: ITMXFORMEJB: getBlankDomForAdd: ==>\n" + exception);
            exception.printStackTrace();
            throw new ITMException(exception);
        }
        return string5;
    }
}

