<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/htmlWizard.css"/>

<body>

	<form name="sorderViewReport" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet">
		<div  style="height:90%; width:98%;overflow:-moz-scrollbars-vertical;overflow-x:auto;overflow-y:auto;white-space:nowrap;">	
			<table class="headertableClass" width = "100%" id="Details1" border="0" cellspacing="1" cellpadding="1">
					<tr>
						<th class="tHeader" align = "left" nowrap="true" valign="bottom" width="10%" >
							Sales Order
						</th>
						<th class="tHeader" align = "left" nowrap="true" valign="bottom" width="10%">
							Customer Code
						</th>
						<th class="tHeader" align = "left" nowrap="true" valign="bottom" width="30%">
							Customer Name
						</th>
						<th class="tHeader" align = "right" nowrap="true" valign="bottom" width="10%">
							Total Tax
						</th>
						<th class="tHeader" align = "left" nowrap="true" valign="bottom" width="20%">
							Remarks
						</th>	
					</tr>
					
					<tbody class="table-body"> 
						<xsl:for-each select="//Detail1">
							<xsl:variable name="sale_order"><xsl:value-of select="sale_order"/></xsl:variable>
							<xsl:variable name="cust_code"><xsl:value-of select="cust_code"/></xsl:variable>
							<xsl:variable name="cust_name"><xsl:value-of select="cust_name"/></xsl:variable>
							<xsl:variable name="tax_amt"><xsl:value-of select="tax_amt"/></xsl:variable>
							<xsl:variable name="remarks"><xsl:value-of select="remarks"/></xsl:variable>
							
							<tr class="trClass">
								<td class="td_leftAlign">
									<xsl:value-of select="sale_order"/>
								</td>
								<td class="td_leftAlign">
									<xsl:value-of select="cust_code"/>
								</td>
								<td class="td_leftAlign">
									<xsl:value-of select="cust_name"/>
								</td>
								<td class="td_rightAlign">
									<xsl:value-of select="tax_amt"/>
								</td>
								<td class="td_leftAlign">
									<xsl:value-of select="remarks"/>
								</td>
							</tr>
						</xsl:for-each>
					</tbody>		
			</table>
				<table class="headertableClass" width = "100%" style ="border-top:none" id="Details2" border="0" cellspacing="1" cellpadding="1">
						<tr>
							<th class="tHeader" align = "left" nowrap="true" valign="bottom" width="10%">
								Product Code
							</th>
							<th class="tHeader" align = "left" nowrap="true" valign="bottom" width="30%">
								Description
							</th>
							<th class="tHeader" align = "right" nowrap="true" valign="bottom" width="10%">
								Quantity
							</th>	
							<th class="tHeader" align = "right" nowrap="true" valign="bottom" width="10%">
								Total Amount
							</th>
							<th class="tHeader" align = "right" nowrap="true" valign="bottom" width="10%">
								Tax Amount
							</th>
							
							<th class="tHeader" align = "left" nowrap="true" valign="bottom" width="5%">
								Tax Class
							</th>
							<th class="tHeader" align = "left" nowrap="true" valign="bottom" width="5%">
								Tax Chap
							</th>
							<th class="tHeader" align = "left" nowrap="true" valign="bottom" width="5%">
								Tax Env
							</th>
						</tr>
					
					<tbody class="table-body"> 
						<xsl:for-each select="//Detail2">
							<xsl:variable name="item_code"><xsl:value-of select="item_code"/></xsl:variable>
							<xsl:variable name="quantity"><xsl:value-of select="quantity"/></xsl:variable>
							<xsl:variable name="net_amt"><xsl:value-of select="net_amt"/></xsl:variable>
							<xsl:variable name="tax_amt"><xsl:value-of select="tax_amt"/></xsl:variable>
							<xsl:variable name="tax_class"><xsl:value-of select="tax_class"/></xsl:variable>
							<xsl:variable name="tax_chap"><xsl:value-of select="tax_chap"/></xsl:variable>
							<xsl:variable name="tax_env"><xsl:value-of select="tax_env"/></xsl:variable>
							<xsl:variable name="item_descr"><xsl:value-of select="item_descr"/></xsl:variable>
							
							<tr class="trClass" width="100%">
								<td class="td_leftAlign">
									<xsl:value-of select="item_code"/>
								</td>
								<td class="td_leftAlign">
									<xsl:value-of select="item_descr"/>
								</td>
								<td class="td_rightAlign">
									<xsl:value-of select="quantity"/>
								</td>	
								<td class="td_rightAlign">
									<xsl:value-of select="net_amt"/>
								</td>
								<td class="td_rightAlign">
									<xsl:value-of select="tax_amt"/>
								</td>
								<td class="td_leftAlign">
									<xsl:value-of select="tax_class"/>
								</td>
								<td class="td_leftAlign">
									<xsl:value-of select="tax_chap"/>
								</td>
								<td class="td_leftAlign">
									<xsl:value-of select="tax_env"/>
								</td>
							</tr>
						</xsl:for-each>
					</tbody>		
			</table>
		</div>	
		<div style="width=20%;height:6px;margin-left=-12px;margin-top:1px;margin-bottom:0px;">
			<table>
				<tr>
					<td colspan="2">
						<input type="submit" style="cursor:hand" class="button" value="Home" title='Home' id="Home"/>
						<input type="hidden" value="1" name="FORM_NO" ID="FORM_NO" />
						<input type="hidden"  value="sorderWiz" name="OBJ_NAME" />
						<input type="hidden"  value="previous" name="action" id="action" />
						<input type="hidden" value="1:MP" name="formType" id="formType" />
					</td>
		        </tr>
		    </table>
		</div>		    
	</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>

