package ibase.webitm.ejb.gstclient;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.ejb.Stateless;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.InvAcct;
import ibase.webitm.ejb.fin.adv.CalculateCommission;
import ibase.webitm.ejb.fin.adv.RcvIbcaConf;
import ibase.webitm.ejb.sys.UtilMethods;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

@Stateless
public class RcpAdvTaxcalcConf extends ActionHandlerEJB implements RcpAdvTaxcalcConfLocal, RcpAdvTaxcalcConfRemote 
		{
	E12GenericUtility genericUtility = new E12GenericUtility();
	FinCommon finCommon = new FinCommon();
	ITMDBAccessEJB itmDBAccessEJB = null;

	@Override
	public String confirm(String tranId, String xtraParams, String forcedFlag)
			throws RemoteException, ITMException 
			{

		String errString = "";
		Connection conn = null;
		try {
			System.out
					.println("@@@@@@@@@@@  RcpAdvTaxcalcConfTest confirm() @@@@@@@@@@@@@@@ ");
			errString = confirm(tranId, xtraParams, forcedFlag, conn);

		} catch (Exception e) {
			// TODO: handle exception
			System.out.println("Exception in confirm() ==>" + e.getMessage());
			errString = genericUtility.createErrorString(e);
			System.out.println("errString in cofirm() ==>" + errString);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}

	public String confirm(String tranId, String xtraParams, String forcedFlag,
			Connection conn) throws RemoteException, ITMException {
		// Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		ConnDriver connDriver = null;

		String confirm = "", siteCode = "";
		String errString = "";
		boolean isLocal=false;	
		FinCommon finCommon = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		try {
			System.out
					.println("@@@@@@@@@@@ RcpAdvTaxcalcConfTest @@@@@@@@@@@@@@@ ");
			finCommon = new FinCommon();
			itmDBAccessEJB = new ITMDBAccessEJB();
			if (conn == null) 
			{
				connDriver = new ConnDriver();
				//conn = connDriver.getConnectDB("DriverITM");
				conn = getConnection();
				System.out.println("Connection[" + conn + "]");
				connDriver = null;
				conn.setAutoCommit(false);
          		isLocal=true;
			}

			sql = " select confirmed from adv_rcp_tax  where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				confirm = rs.getString("confirmed");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if (confirm != null && "Y".equalsIgnoreCase(confirm)) {
				System.out
						.println("The Selected transaction is already confirmed");
				errString = itmDBAccessEJB.getErrorString("", "VTMCONF1", "",
						"", conn);
				return errString;
			} else {
				errString = this.rcpAdvtaxCalcProcess(tranId, xtraParams, conn);
				if (errString != null && errString.trim().length() > 0) {
					if(errString.indexOf("CONFSUCCES") > -1)
					{
						if(isLocal)
						{
							conn.commit();
						}
						System.out.println("Committing..............");


					}
					else
					{
						if(isLocal)
						{
							conn.rollback();
						}
						System.out.println("Rollbacking..............");
					}
				}
			}
		} // end of try
		catch (Exception e) {
			System.out.println("Exception ::" + e.getMessage());
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			try {
				conn.rollback();
			} catch (Exception e1) {
				System.out.println("Exception while rollbackin.......");
			}
			throw new ITMException(e);
		} finally 
		{
			try
			{			
				if(conn!=null && isLocal)
				{
					System.out.println(" finally Rollbacking..............");
					conn.close();
					conn=null;
				}
				//conn = null;
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}

	public String rcpAdvtaxCalcProcess(String tranId, String xtraParams,
			Connection conn) throws ITMException {
		ArrayList rcpAdvList = new ArrayList();
		ArrayList DetailList = new ArrayList();
		ArrayList invoiceDetList = new ArrayList();
		HashMap detMapMain = null;
		String analysisStr[] = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String lineNoTemp = "", prevSordNo = "";
		String errString = "";
		HashMap RcpAcctMap = null;
		ArrayList RcpAcctList = new ArrayList();
		ArrayList RcpAcctScreenList = new ArrayList();
		HashMap detRcpadvList = new HashMap();
		long startTime = 0, endTime = 0, totalTime = 0, totalHrs = 0, totlMts = 0, totSecs = 0; // Added
		double totRecoAmt = 0;
		try {
			// invoiceDeapList=getDetail(tranId,conn);
			itmDBAccessEJB = new ITMDBAccessEJB();
			DetailList = getDetail(tranId, conn);
			if (DetailList.size() > 0) {
				int getLineNo = 0;
				String getsiteCode = "", finEntity = "", getCurrCode = "", getRefType = "";
				double exchRate = 0, getamount = 0;
				String remarks = "", sgstcr = "", sgstcracct = "", sgstcrcctr = "", sgstdr = "", sgstdracct = "", sgstdrcctr = "";
				String cgstcr = "", cgstcracct = "", cgstcrcctr = "";
				String cgstdr = "", cgstdracct = "", cgstdrcctr = "";
				String igstcr = "", igstcracct = "", igstcrcctr="";
				String igstdr = "", igstdracct = "", igstdrcctr="";
				String acctCodesgstadj = "", cctrCodesgstadj = "";
				double taxAmtSgst = 0, taxAmttemp = 0, taxAmtcgsttemp = 0;
				double taxAmtCgst = 0;
				Timestamp gettranDate = null;
				sgstdr = finCommon.getFinparams("999999", "SGST_RADV_ACCT_DR",conn);
				if (sgstdr != "NULLFOUND") 
				{
					String[] arry = sgstdr.split((","));
					System.out.println("@@@@@ arry[" + arry.length + "]");
					if (arry.length > 0) {
						sgstdracct = arry[0];
						System.out.println("sgstdracct[" + sgstcracct + "]");
					} else {
						sgstdracct = "";
					}
					if (arry.length > 1) {
						sgstdrcctr = arry[1];
						System.out.println("sgstdrcctr[" + sgstdrcctr + "]");
					} else {
						sgstdrcctr = "";
					}
				}
				sgstcr = finCommon.getFinparams("999999", "SGST_RADV_ACCT_CR",conn);
				if (sgstcr != "NULLFOUND") {
					String[] arry = sgstcr.split((","));
					System.out.println("@@@@@ arry[" + arry.length + "]");
					if (arry.length > 0) {
						sgstcracct = arry[0];
						System.out.println("sgstcracct[" + sgstcracct + "]");
					} else {
						sgstcracct = "";
					}
					if (arry.length > 1) {
						sgstcrcctr = arry[1];
						System.out.println("sgstcrcctr[" + sgstcrcctr + "]");
					} else {
						sgstcrcctr = "";
					}
				}
				//////////////////////////////////////////////////////////////////////////////////////////
				///////////////////////////////////CGST//////////////////////////////////////////////////
				cgstdr = finCommon.getFinparams("999999", "CGST_RADV_ACCT_DR",
						conn);
				if (cgstdr != "NULLFOUND") {
					String[] arry = cgstdr.split((","));
					System.out.println("@@@@@ arry[" + arry.length + "]");
					if (arry.length > 0) {
						cgstdracct = arry[0];
						System.out.println("cgstdracct[" + cgstdracct + "]");
					} else {
						cgstdracct = "";
					}
					if (arry.length > 1) {
						cgstdrcctr = arry[1];
						System.out.println("cgstdrcctr[" + cgstdrcctr + "]");
					} else {
						cgstdrcctr = "";
					}
				}
				cgstcr = finCommon.getFinparams("999999", "CGST_RADV_ACCT_CR",
						conn);
				if (cgstcr != "NULLFOUND") {
					String[] arry = cgstcr.split((","));
					System.out.println("@@@@@ arry[" + arry.length + "]");
					if (arry.length > 0) {
						cgstcracct = arry[0];
						System.out.println("cgstcracct[" + cgstcracct + "]");
					} else {
						cgstcracct = "";
					}
					if (arry.length > 1) {
						cgstcrcctr = arry[1];
						System.out.println("cgstcrcctr[" + cgstcrcctr + "]");
					} else {
						cgstcrcctr = "";
					}
				}
				///////////////////////////////////////////////////////////////////////////////////////////////
				////////////////////////////IGST
			/*	igstcr = finCommon.getFinparams("999999", "IGST_RADV_ACCT_CR",conn);
				if (igstcr != "NULLFOUND") 
				{
					String[] arry = igstcr.split((","));
					System.out.println("@@@@@ arry[" + arry.length + "]");
					if (arry.length > 0) 
					{
						igstcracct = arry[0];
						System.out.println("igstcracct[" + igstcracct + "]");
					} 
					else 
					{
						igstcracct = "";
					}
					if (arry.length > 1)
					{
						igstcrcctr = arry[1];
						System.out.println("igstcrcctr[" + igstcrcctr + "]");
					} else 
					{
						igstcrcctr = "";
					}
				}
				igstdr = finCommon.getFinparams("999999", "IGST_RADV_ACCT_DR",conn);
				if (igstdr != "NULLFOUND") 
				{
					String[] arry = igstdr.split((","));
					System.out.println("@@@@@ arry[" + arry.length + "]");
					if (arry.length > 0) 
					{
						igstdracct = arry[0];
						System.out.println("igstdracct[" + igstdracct + "]");
					} 
					else 
					{
						igstdracct = "";
					}
					if (arry.length > 1)
					{
						igstdrcctr = arry[1];
						System.out.println("igstdrcctr[" + igstdrcctr + "]");
					} else 
					{
						igstdrcctr = "";
					}
				}*/
				// ///////////////////////////////////////////////////////////////////////////////////
				// //////////////////////////////////////////////////////////////////////////////////
				String sgstdradj = "", sgstdracctadj = "", sgstdrcctradj = "";
				String sgstcradj = "", sgstcracctadj = "", sgstcrcctradj = "";
				String cgstdradj = "", cgstdracctadj = "", cgstdrcctradj = "";
				String cgstcradj = "", cgstcracctadj = "", cgstcrcctradj = "";
				String igstdradj = "", igstdracctadj = "", igstdrcctradj = "";
				String igstcradj = "", igstcracctadj = "", igstcrcctradj = "";
				
				sgstdradj = finCommon.getFinparams("999999","SGST_RADJ_ACCT_DR", conn);
				if (sgstdradj != "NULLFOUND")
				{
					String[] arry1 = sgstdradj.split((","));
					System.out.println("@@@@@ arry[" + arry1.length + "]");
					if (arry1.length > 0) 
					{
						sgstdracctadj = arry1[0];
						System.out.println("sgstdracctadj[" + sgstdracctadj
								+ "]");
					} 
					else
					{
						sgstdracctadj = "";
					}
					if (arry1.length > 1) 
					{
						sgstdrcctradj = arry1[1];
						System.out.println("sgstdrcctradj[" + sgstdrcctradj
								+ "]");
					} 
					else
					{
						sgstdrcctradj = "";
					}
				}
				sgstcradj = finCommon.getFinparams("999999","SGST_RADJ_ACCT_CR", conn);
				if (sgstcradj != "NULLFOUND") {
					String[] arry1 = sgstcradj.split((","));
					System.out.println("@@@@@ arry[" + arry1.length + "]");
					if (arry1.length > 0) {
						sgstcracctadj = arry1[0];
						System.out.println("sgstcracct[" + sgstcracctadj + "]");
					} else {
						sgstcracctadj = "";
					}
					if (arry1.length > 1) {
						sgstcrcctradj = arry1[1];
						System.out.println("sgstcrcctradj[" + sgstcrcctradj
								+ "]");
					} else {
						sgstcrcctradj = "";
					}
				}
				
				// sgstAcct.put("cctr_code",sgstdrcctr);
				cgstdradj = finCommon.getFinparams("999999",
						"CGST_RADJ_ACCT_DR", conn);
				if (cgstdradj != "NULLFOUND")
				{
					String[] arry1 = cgstdradj.split((","));
					System.out.println("@@@@@ arry[" + arry1.length + "]");
					if (arry1.length > 0) {
						cgstdracctadj = arry1[0];
						System.out.println("cgstdracctadj[" + cgstdracctadj
								+ "]");
					} else {
						cgstdracctadj = "";
					}
					if (arry1.length > 1) {
						cgstdrcctradj = arry1[1];
						System.out.println("cgstdrcctr[" + cgstdrcctradj + "]");
					} else {
						cgstdrcctradj = "";
					}
				}
				cgstcradj = finCommon.getFinparams("999999","CGST_RADJ_ACCT_CR", conn);
				if (cgstcradj != "NULLFOUND") 
				{
					String[] arry1 = cgstcradj.split((","));
					System.out.println("@@@@@ arry[" + arry1.length + "]");
					if (arry1.length > 0)
					{
						cgstcracctadj = arry1[0];
						System.out.println("cgstcracctadj[" + cgstcracctadj+ "]");
					}
					else
					{
						cgstcracctadj = "";
					}
					if (arry1.length > 1) 
					{
						cgstcrcctradj = arry1[1];
						System.out.println("cgstcrcctradj[" + cgstcrcctradj+ "]");
					} 
					else
					{
						cgstcrcctradj = "";
					}
				}
				igstcradj = finCommon.getFinparams("999999", "IGST_RADJ_ACCT_CR",conn);
				if (igstcradj != "NULLFOUND") 
				{
					String[] arry1 = igstcradj.split((","));
					System.out.println("@@@@@ arry[" + arry1.length + "]");
					if (arry1.length > 0) 
					{
						igstcracctadj = arry1[0];
						System.out.println("igstcracctadj[" + igstcracctadj+ "]");
					} 
					else 
					{
						igstcracctadj = "";
					}
					if (arry1.length > 1)
					{
						igstcrcctradj = arry1[1];
						System.out.println("igstcrcctradj[" + igstcrcctradj+ "]");
					}
					else
					{
						igstcrcctradj = "";
					}
				}
				igstdradj = finCommon.getFinparams("999999", "IGST_RADJ_ACCT_DR",conn);
				if (igstdradj != "NULLFOUND") 
				{
					String[] arry1 = igstdradj.split((","));
					System.out.println("@@@@@ arry[" + arry1.length + "]");
					if (arry1.length > 0) 
					{
						igstdracctadj = arry1[0];
						System.out.println("igstdracctadj[" + igstdracctadj
								+ "]");
					} 
					else 
					{
						igstdracctadj = "";
					}
					if (arry1.length > 1)
					{
						igstdrcctradj = arry1[1];
						System.out.println("igstdrcctradj[" + igstdrcctradj+ "]");
					}
					else
					{
						igstcrcctradj = "";
					}
				}

				for (int itr = 0; itr < DetailList.size(); itr++) {
					double taxAmt = 0;
					detMapMain = (HashMap) DetailList.get(itr);
					System.out.println(" detMapMain ctr [" + itr + "] ["+ detMapMain + "]");
					getRefType = checkNull((String) detMapMain.get("ref_type"));
					getLineNo = (Integer) detMapMain.get("line_no");
					if ("1".equalsIgnoreCase(getRefType))
					{
						System.out.println("Refrence Type is :["+getRefType+"]");
						sql = "select sum(ti.tax_amt) from taxtran ti, tax tm,adv_rcp_tax a "
								+ "where tm.tax_code = ti.tax_code and ti.tran_code = 'A-TAX' and ti.tran_id =a.tran_id  and tm.tax_type ='G' and  ti.tran_id = ? and ti.line_no= ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, tranId);
						pstmt.setInt(2, getLineNo);
						rs = pstmt.executeQuery();
						if (rs.next()) {
							taxAmttemp = rs.getDouble(1);
							System.out.println(" taxAmttemp [" + taxAmttemp
									+ "] ");

						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						RcpAcctMap = new HashMap();
						RcpAcctMap.put("tran_id", tranId);
						// invAcctMap.put("line_no",detLineNo);
						RcpAcctMap.put("acct_code", sgstdracct);
						RcpAcctMap.put("cctr_code", sgstdrcctr);
						taxAmt = getDebitAmt(taxAmttemp);
						System.out.println("taxAmt[" + taxAmt + "]");
						RcpAcctMap.put("amount", "" + taxAmt);
						RcpAcctList = modifyRcpAcctList(RcpAcctList,RcpAcctMap, sgstdracct, sgstdrcctr, taxAmt);
						System.out.println("RcpAcctList@@@@@@@@@@ 1["+ RcpAcctList + "]");
						
						RcpAcctMap = new HashMap();
						RcpAcctMap.put("tran_id", tranId);
						// invAcctMap.put("line_no",detLineNo);
						RcpAcctMap.put("acct_code", sgstcracct);
						RcpAcctMap.put("cctr_code", sgstcrcctr);
						System.out.println("Sgst Credit before taxAmt[" + taxAmt + "]");
						taxAmt = getCreditAmt(taxAmttemp);
						System.out.println("taxAmt[" + taxAmt + "]");
						RcpAcctMap.put("amount", "" + taxAmt);
						RcpAcctList = modifyRcpAcctList(RcpAcctList,RcpAcctMap, sgstcracct, sgstcrcctr, taxAmt);
						System.out.println("RcpAcctList@@@@@@@@@@ 2["+ RcpAcctList + "]");
						
						
						
						/*Added code-*/
						sql = "select sum(ti.tax_amt) from taxtran ti, tax tm,adv_rcp_tax a "
								+ "where tm.tax_code = ti.tax_code and ti.tran_code = 'A-TAX' and ti.tran_id =a.tran_id  and tm.tax_type ='H' and  ti.tran_id = ? and ti.line_no= ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, tranId);
						pstmt.setInt(2, getLineNo);
						rs = pstmt.executeQuery();
						if (rs.next()) {
							taxAmtcgsttemp = rs.getDouble(1);
							System.out.println(" taxAmtcgsttemp ["+ taxAmtcgsttemp + "] ");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						RcpAcctMap = new HashMap();
						RcpAcctMap.put("tran_id", tranId);
						// invAcctMap.put("line_no",detLineNo);
						RcpAcctMap.put("acct_code", cgstdracct);
						RcpAcctMap.put("cctr_code", cgstdrcctr);
						taxAmt = getDebitAmt(taxAmttemp);
						System.out.println("taxAmt[" + taxAmt + "]");
						RcpAcctMap.put("amount", "" + taxAmt);
						System.out.println("RcpAcctList@@@@@@@@@@ 3["+ RcpAcctList + "]");
						
						RcpAcctList = modifyRcpAcctList(RcpAcctList,RcpAcctMap, cgstdracct, cgstdrcctr,taxAmt);
						System.out.println("After Modify[" + taxAmttemp + "");
						RcpAcctMap = new HashMap();
						RcpAcctMap.put("tran_id", tranId);
						RcpAcctMap.put("acct_code", cgstcracct);
						RcpAcctMap.put("cctr_code", cgstcrcctr);
						taxAmt = getCreditAmt(taxAmttemp);
						System.out.println("taxAmt[" + taxAmt + "]");
						RcpAcctMap.put("amount", "" + taxAmt);
						RcpAcctList = modifyRcpAcctList(RcpAcctList,RcpAcctMap, cgstcracct, cgstcrcctr,taxAmt);
						System.out.println("RcpAcctList@@@@@@@@@@ 4["+ RcpAcctList + "]");
						
						//IGST
						sql = "select sum(ti.tax_amt) from taxtran ti, tax tm,adv_rcp_tax a "
							+ "where tm.tax_code = ti.tax_code and ti.tran_code = 'A-TAX' and ti.tran_id =a.tran_id  and tm.tax_type ='I' and  ti.tran_id = ? and ti.line_no= ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					pstmt.setInt(2, getLineNo);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						taxAmtcgsttemp = rs.getDouble(1);
						System.out.println(" taxAmtcgsttemp ["+ taxAmtcgsttemp + "] ");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					RcpAcctMap = new HashMap();
					RcpAcctMap.put("tran_id", tranId);
					// invAcctMap.put("line_no",detLineNo);
					RcpAcctMap.put("acct_code", igstdracct);
					RcpAcctMap.put("cctr_code", igstdrcctr);
					taxAmt = getDebitAmt(taxAmttemp);
					System.out.println("taxAmt[" + taxAmt + "]");
					RcpAcctMap.put("amount", "" + taxAmt);
					System.out.println("RcpAcctList@@@@@@@@@@ 5["+ RcpAcctList + "]");
					
					RcpAcctList = modifyRcpAcctList(RcpAcctList,RcpAcctMap, igstdracct, igstdrcctr,taxAmt);
					System.out.println("After Modify[" + taxAmttemp + "");
					RcpAcctMap = new HashMap();
					RcpAcctMap.put("tran_id", tranId);
					RcpAcctMap.put("acct_code", igstcracct);
					RcpAcctMap.put("cctr_code", igstcrcctr);
					taxAmt = getCreditAmt(taxAmttemp);
					System.out.println("taxAmt[" + taxAmt + "]");
					RcpAcctMap.put("amount", "" + taxAmt);
					RcpAcctList = modifyRcpAcctList(RcpAcctList,RcpAcctMap, igstcracct, igstcrcctr,taxAmt);
					System.out.println("RcpAcctList@@@@@@@@@@ 6["+ RcpAcctList + "]");
						
						
						
					}
					if ("2".equalsIgnoreCase(getRefType))
					{
						System.out.println("Refrence Type is 2:["+getRefType+"]");
						sql = "select sum(ti.tax_amt) from taxtran ti, tax tm,adv_rcp_tax a "
								+ "where tm.tax_code = ti.tax_code and ti.tran_code = 'A-TAX' and ti.tran_id =a.tran_id  and tm.tax_type ='G' and  ti.tran_id = ? and ti.line_no= ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, tranId);
						pstmt.setInt(2, getLineNo);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							taxAmttemp = rs.getDouble(1);
							System.out.println(" taxAmttemp ADJ [" + taxAmttemp+ "] ");

						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						RcpAcctMap = new HashMap();
						RcpAcctMap.put("tran_id", tranId);
						RcpAcctMap.put("acct_code", sgstdracctadj);
						RcpAcctMap.put("cctr_code", sgstdrcctradj);
						System.out.println("Adj sgst dr taxAmttemp["+taxAmttemp+"]");
						taxAmt = getDebitAmt(taxAmttemp);
						System.out.println("taxAmtADJ[" + taxAmt + "]");
						RcpAcctMap.put("amount", "" + taxAmt);
						RcpAcctList = modifyRcpAcctList(RcpAcctList,RcpAcctMap, sgstdracctadj, sgstdrcctradj,taxAmt);
						System.out.println("Sgst cr amount after " + taxAmttemp);
						System.out.println("RcpAcctListADJ@@@@@@@@@@ 1["+ RcpAcctList + "]");
						RcpAcctMap = new HashMap();
						RcpAcctMap.put("tran_id", tranId);
						// invAcctMap.put("line_no",detLineNo);
						RcpAcctMap.put("acct_code", sgstcracctadj);
						RcpAcctMap.put("cctr_code", sgstcrcctradj);
						System.out.println("Adj sgst cr taxAmttemp["+taxAmttemp+"]");
						taxAmt = getCreditAmt(taxAmttemp);
						System.out.println("taxAmtAdj[" + taxAmt + "]");
						RcpAcctMap.put("amount", "" + taxAmt);
						RcpAcctList = modifyRcpAcctList(RcpAcctList,RcpAcctMap, sgstcracctadj, sgstcrcctradj, taxAmt);
						System.out.println("RcpAcctListAdj@@@@@@@@@@ 2["+ RcpAcctList + "]");

						sql = "select sum(ti.tax_amt) from taxtran ti, tax tm,adv_rcp_tax a "
								+ "where tm.tax_code = ti.tax_code and ti.tran_code = 'A-TAX' and ti.tran_id =a.tran_id  and tm.tax_type ='H' and  ti.tran_id = ? and ti.line_no= ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, tranId);
						pstmt.setInt(2, getLineNo);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							taxAmtcgsttemp = rs.getDouble(1);
							System.out.println(" taxAmtcgsttempAdj ["+ taxAmtcgsttemp + "] ");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						RcpAcctMap = new HashMap();
						RcpAcctMap.put("tran_id", tranId);
						RcpAcctMap.put("acct_code", cgstdracctadj);
						RcpAcctMap.put("cctr_code", cgstdrcctradj);
						taxAmt = getDebitAmt(taxAmttemp);
						System.out.println("taxAmtadj[" + taxAmt + "]");
						RcpAcctMap.put("amount", "" + taxAmt);
						System.out.println("RcpAcctList@@@@@@@@@@ 3["+ RcpAcctList + "]");	
						RcpAcctList = modifyRcpAcctList(RcpAcctList,RcpAcctMap, cgstdracctadj, cgstdrcctradj,taxAmt);
						System.out.println("After Modify[" + taxAmttemp + "");
						RcpAcctMap = new HashMap();
						RcpAcctMap.put("tran_id", tranId);
						RcpAcctMap.put("acct_code", cgstcracctadj);
						RcpAcctMap.put("cctr_code", cgstcrcctradj);
						taxAmt = getCreditAmt(taxAmttemp);
						System.out.println("taxAmtAdj[" + taxAmt + "]");
						RcpAcctMap.put("amount", "" + taxAmt);
						RcpAcctList = modifyRcpAcctList(RcpAcctList,RcpAcctMap, cgstcracctadj, cgstcrcctradj,taxAmt);
						System.out.println("RcpAcctListADJ@@@@@@@@@@ 4["+ RcpAcctList + "]");
						
						
						sql = "select sum(ti.tax_amt) from taxtran ti, tax tm,adv_rcp_tax a "
							+ "where tm.tax_code = ti.tax_code and ti.tran_code = 'A-TAX' and ti.tran_id =a.tran_id  and tm.tax_type ='I' and  ti.tran_id = ? and ti.line_no= ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					pstmt.setInt(2, getLineNo);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						taxAmtcgsttemp = rs.getDouble(1);
						System.out.println(" taxAmtcgsttemp ["+ taxAmtcgsttemp + "] ");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					RcpAcctMap = new HashMap();
					RcpAcctMap.put("tran_id", tranId);
					// invAcctMap.put("line_no",detLineNo);
					RcpAcctMap.put("acct_code",igstcracctadj);
					RcpAcctMap.put("cctr_code", igstcrcctradj);
					taxAmt = getCreditAmt(taxAmttemp);
					System.out.println("taxAmt[" + taxAmt + "]");
					RcpAcctMap.put("amount", "" + taxAmt);
					System.out.println("RcpAcctList@@@@@@@@@@ 5["+ RcpAcctList + "]");
					
					RcpAcctList = modifyRcpAcctList(RcpAcctList,RcpAcctMap, igstcracctadj, igstcrcctradj,taxAmt);
					System.out.println("After Modify[" + taxAmttemp + "");
					
					RcpAcctMap = new HashMap();
					RcpAcctMap.put("tran_id", tranId);
					RcpAcctMap.put("acct_code", igstdracctadj);
					RcpAcctMap.put("cctr_code", igstdrcctradj);
					taxAmt = getDebitAmt(taxAmttemp);
					System.out.println("taxAmt[" + taxAmt + "]");
					RcpAcctMap.put("amount", "" + taxAmt);
					RcpAcctList = modifyRcpAcctList(RcpAcctList,RcpAcctMap, igstdracctadj, igstdrcctradj,taxAmt);
					System.out.println("RcpAcctList@@@@@@@@@@ 6["+ RcpAcctList + "]");
					}
				}

				errString = insertRcpAcctList(RcpAcctList, conn);
				if (errString == null || errString.trim().length() == 0) {
					RcpAcctScreenList = getRcpAcctDet(tranId, conn);
					System.out.println("RcpAcctScreenList.size()["+ RcpAcctScreenList + "]");
					detRcpadvList = getRcpDetailScreen(tranId, conn);
					System.out.println("detRcpadvList()[" + detRcpadvList + "]");
					errString = gbfPostRcpAdvDet(RcpAcctScreenList,detRcpadvList, conn);
					
				}
				if (errString == null || errString.trim().length() == 0) {
					errString = finCommon.checkGlTranDrCr("A-TAX", tranId, conn);
				}
				if (errString == null || errString.trim().length() == 0) {
					sql = " update adv_rcp_tax set confirmed = 'Y' , conf_date = ? where tran_id = ? ";
					System.out.println("SQL : " + sql);
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1, new Timestamp(System
							.currentTimeMillis()));
					pstmt.setString(2, tranId);
					pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
					conn.commit();
				}
				System.out.println("errString"+errString);
				if(errString !=null && errString.trim().length() > 0)
				{
					
		            return errString;
				}
				if(errString == null || errString.trim().length() == 0)
				{
					errString = itmDBAccessEJB.getErrorString("", "CONFSUCCES", "");
					System.out.println("Misc Drcr Confirmed .." + errString);
				}
				System.out.println("Errstring End.." + errString);
				
			}
		} catch (SQLException e) {
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e) {
				System.out.println("Exception : " + e);
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}

	private String insertRcpAcctList(ArrayList RcpAcctList, Connection conn)
			throws ITMException {
		int detLineNo = 1;
		String sql = "", errCode = "";
		PreparedStatement pstmt = null;
		try {
			System.out.println(" RcpAcctList [" + RcpAcctList + "]");
			System.out.println(" RcpAcctList [" + RcpAcctList.size() + "]");
			sql = "insert into adv_rcp_tax_acct (tran_id,line_no,acct_code,cctr_code,amount)"
					+ " values (?,?,?,?,?)";
			pstmt = conn.prepareStatement(sql);
			for (int i = 0; i < RcpAcctList.size(); i++) {
				HashMap tempMap = new HashMap();
				tempMap = (HashMap) RcpAcctList.get(i);
				if (tempMap != null) {
					System.out.println("detLineNo" + detLineNo);
					String amt = "";
					double amount = 0;
					amt = (String) tempMap.get("amount");
					amount = Double.parseDouble(amt);
					pstmt.setString(1, (String) tempMap.get("tran_id"));
					pstmt.setInt(2, detLineNo);
					pstmt.setString(3, (String) tempMap.get("acct_code"));
					pstmt.setString(4, (String) tempMap.get("cctr_code"));
					pstmt.setDouble(5, amount);
					pstmt.addBatch();
					pstmt.clearParameters();
					detLineNo++;
				}
			}
			pstmt.executeBatch();
			pstmt.clearBatch();
			pstmt.close();
			pstmt = null;

		} catch (SQLException e) {
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		}

		return errCode;
	}

	private ArrayList modifyRcpAcctList(ArrayList RcpAcctList,
			HashMap RcpAcctMap, String lsAcctCodeSal, String lsCctrCodeSal,
			double detAmount) {
		boolean findFlag = false;
		HashMap<String, String> tempMap = null;
		String acctTemp = "";
		String cctrTemp = "";
		String tempAmt = "";
		double amt = 0;
		for (int i = 0; i < RcpAcctList.size(); i++) {
			tempMap = (HashMap) RcpAcctList.get(i);
			System.out.println("lsAcctCodeSal[" + lsAcctCodeSal + "]");
			System.out.println("lsCctrCodeSal[" + lsCctrCodeSal + "]");
			acctTemp = tempMap.get("acct_code").trim();
			System.out.println("acctTemp[" + acctTemp + "]");
			cctrTemp = tempMap.get("cctr_code").trim();
			System.out.println("cctrTemp[" + cctrTemp + "]");
			if (lsAcctCodeSal.trim().equals(tempMap.get("acct_code").trim())&& lsCctrCodeSal.trim().equals(tempMap.get("cctr_code").trim())) {
				System.out.println("Inside equal");
				detAmount = detAmount+ Double.parseDouble(tempMap.get("amount"));
				System.out.println("detAmount is["+detAmount+"]");
				tempMap.put("amount", "" + detAmount);
				findFlag = true;
				RcpAcctList.set(i, tempMap);
				System.out.println("RcpAcctList.set(i,tempMap)@@{"
						+ RcpAcctList + "]");
				break;
			}
		}

		if (!findFlag) {
			RcpAcctList.add(RcpAcctMap);
			System.out.println("!findFlag RcpAcctList[" + RcpAcctList + "]");
		}
		return RcpAcctList;
	}

	private ArrayList getRcpAcctDet(String tranId, Connection conn)
			throws ITMException {
		// TODO Auto-generated method stub
		ArrayList<Object> DetList = new ArrayList<Object>();
		HashMap DetailMap = null;
		String sql = "", chgDtStr = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try {

			String acctCode = "", tranid = "", cctrCode = "";
			int lineNo = 0;
			double amount = 0;
			Timestamp refDate = null, tranDate = null;
			sql = "select tran_id,line_no,acct_code,cctr_code,amount from adv_rcp_tax_acct where tran_id=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				DetailMap = new HashMap();
				tranid = rs.getString(1);
				lineNo = rs.getInt(2);
				acctCode = rs.getString(3);
				cctrCode = rs.getString(4);
				amount = rs.getDouble(5);
				System.out.println("tranid[" + tranid + "] lineNo [" + lineNo
						+ "] acctCode [" + acctCode + "] cctrCode[" + cctrCode
						+ "]");
				System.out.println("amount[" + amount + "]");
				DetailMap.put("tran_id", tranid);
				DetailMap.put("line_no", lineNo);
				DetailMap.put("acct_code", acctCode);
				DetailMap.put("cctr_code", cctrCode);
				DetailMap.put("amount", amount);
				DetList.add(DetailMap);
				System.out.println("DetList::[" + DetList + "]");
				System.out.println("DetList Size::[" + DetList.size() + "]");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

		} catch (SQLException e) {
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		}

		return DetList;
	}

	private String gbfPostRcpAdvDet(ArrayList rcpAdvTaxCalcList,
			HashMap detRcpadvHashMap, Connection conn) throws Exception {
		// TODO Auto-generated method stub
		String retString = "", lsPostdate = "", ldPostdate = "", sql = "", lsProjCode = "", partyDocRef = "";
		PreparedStatement pstmt = null;
		String refType = "";
		ResultSet rs = null;
		HashMap glTraceMap = null;
		HashMap detMap = null;
		Timestamp ldPostdate2 = null;
		double getamount = 0;
		try {
			System.out.println("rcpAdvTaxCalcList[" + rcpAdvTaxCalcList + "]");
			System.out.println("rcpAdvTaxCalcList[" + rcpAdvTaxCalcList.size()
					+ "]");
			for (int itr = 0; itr < rcpAdvTaxCalcList.size(); itr++) {
				detMap = new HashMap();
				detMap = (HashMap) rcpAdvTaxCalcList.get(itr);
				getamount = (Double) detMap.get("amount");
				System.out.println(" detMapDrsgst [" + detMap + "]");
				glTraceMap = new HashMap();
				glTraceMap.put("tran_date", (Timestamp) detRcpadvHashMap
						.get("tran_date"));
				glTraceMap.put("eff_date", (Timestamp) detRcpadvHashMap
						.get("eff_date"));
				glTraceMap.put("fin_entity", (String) detRcpadvHashMap
						.get("fin_entity"));
				glTraceMap.put("site_code", (String) detRcpadvHashMap
						.get("site_code"));
				glTraceMap.put("sundry_type", "O");
				glTraceMap.put("sundry_code", " ");
				glTraceMap.put("acct_code", (String) detMap.get("acct_code"));
				glTraceMap.put("cctr_code", (String) detMap.get("cctr_code"));
				glTraceMap.put("emp_code", (String) detRcpadvHashMap
						.get("emp_code"));
				glTraceMap.put("anal_code", (String) detRcpadvHashMap
						.get("anal_code"));
				glTraceMap.put("curr_code", (String) detRcpadvHashMap
						.get("curr_code"));
				glTraceMap.put("exch_rate", (Double) detRcpadvHashMap
						.get("exch_rate"));

				if ((Double) detMap.get("amount") > 0)
				{
					
					glTraceMap.put("dr_amt", (Double) (detMap.get("amount")));
					glTraceMap.put("cr_amt", Double.parseDouble("0"));
				} 
				else
				{
					glTraceMap.put("cr_amt", (0 - (Double) (detMap.get("amount"))));
					glTraceMap.put("dr_amt", Double.parseDouble("0"));
				}
				glTraceMap.put("ref_type", "F");
				glTraceMap.put("ref_id", (String) detRcpadvHashMap
						.get("ref_id"));// Doubt
				glTraceMap.put("ref_ser", "A-TAX");
				String remarks = "These transaction is Advance Receipt and amount is "
						+ getamount + "";
				glTraceMap.put("remarks", remarks);
				retString = finCommon.glTraceUpdate((HashMap) glTraceMap, conn);
				System.out.println("After glTraceUpdate SGST debit---->["+ retString + "]");
				if (retString != null && retString.trim().length() > 0) {
					return retString;
				}

			}

		} catch (ITMException e) {
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		}
		return retString;
	}

	private ArrayList getDetail(String tranId, Connection conn)
			throws ITMException {

		ArrayList advPostList = new ArrayList();
		double ln_amount_dis = 0.00, ln_amount_sal = 0.00;
		String rateStd = "", qtyStd = "", discount = "", ls_cctr_code__sal = "", mfgDtStr = "", expDtStr = "", excDtStr = "";
		// TODO Auto-generated method stub
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		HashMap advPostMap = null;
		try {
			String custCode = "", refType = "", refSer = "", refId = "", refidadv = "", taxClass = "", taxChap = "", taxEnv = "", siteCode = "", currCode = "";
			int lineNo = 0;
			double amount = 0, taxAmt = 0;
			Timestamp refDate = null, tranDate = null;
			sql = "select d.line_no,d.cust_code,d.ref_type,d.ref_ser,d.ref_id,d.ref_date,d.amount, d.ref_id__adv,d.tax_class,d.tax_chap,d.tax_env, d.tax_amt ,"
					+ " h.tran_date,h.site_code, h.curr_code from adv_rcp_tax_det  d,adv_rcp_tax h where d.tran_id=h.tran_id and d.tran_id=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				lineNo = rs.getInt(1);
				custCode = rs.getString(2);
				refType = rs.getString(3);
				refSer = rs.getString(4);
				refId = rs.getString(5);
				refDate = rs.getTimestamp(6);
				amount = rs.getDouble(7);
				refidadv = rs.getString(8);
				taxClass = rs.getString(9);
				taxChap = rs.getString(10);
				taxEnv = rs.getString(11);
				taxAmt = rs.getDouble(12);
				tranDate = rs.getTimestamp(13);
				siteCode = rs.getString(14);
				currCode = rs.getString(15);
				System.out.println("lineNo[" + lineNo + "] custCode ["
						+ custCode + "] refType [" + refType + "] refSer["
						+ refSer + "]");
				System.out.println("ref_id[" + refId + "] ref_date [" + refDate
						+ "] amount [" + amount + "] refidadv[" + refidadv
						+ "]");
				System.out.println("taxClass[" + taxClass + "] taxChap ["
						+ taxChap + "] taxEnv [" + taxEnv + "] taxAmt["
						+ taxAmt + "]");
				System.out.println("tranDate[" + tranDate + "] siteCode ["
						+ siteCode + "]");
				advPostMap = new HashMap();
				advPostMap.put("line_no", lineNo);
				advPostMap.put("cust_code", custCode);
				advPostMap.put("ref_type", refType);
				advPostMap.put("ref_ser", refSer);
				advPostMap.put("ref_id", refId);
				advPostMap.put("ref_date", refDate);
				advPostMap.put("amount", amount);
				advPostMap.put("ref_id__adv", refidadv);
				advPostMap.put("tax_class", taxClass);
				advPostMap.put("tax_chap", taxChap);
				advPostMap.put("tax_env", taxEnv);
				advPostMap.put("tax_amt", taxAmt);
				advPostMap.put("tran_date", tranDate);
				advPostMap.put("site_code", siteCode);
				advPostList.add(advPostMap);
				System.out.println("advPostList::[" + advPostList + "]");
				System.out.println("advPostList Size::[" + advPostList.size()
						+ "]");
				amount = 0;
				taxAmt = 0;
				custCode = "";
				refType = "";
				refSer = "";
				refId = "";
				refidadv = "";
				taxClass = "";
				taxChap = "";
				taxEnv = "";
				refDate = null;
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

		} catch (SQLException e) {
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		}

		return advPostList;
	}

	private String checkNull(String inputStr) {
		// TODO Auto-generated method stub
		if (inputStr == null) {
			inputStr = "";
		}
		return inputStr;
	}

	private String checkNullSpace(String inputStr) {
		// TODO Auto-generated method stub
		if (inputStr == null || inputStr.trim().length() == 0) {
			inputStr = " ";
		}
		return inputStr;
	}

	private HashMap getRcpDetailScreen(String tranId, Connection conn)
			throws ITMException {
		// TODO Auto-generated method stub
		ArrayList DetailList = new ArrayList();
		HashMap advRcpDetMap = null;
		String sql = "", sql1 = "", chgDtStr = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		try {

			String custCode = "", refType = "", refSer = "", refId = "", refidadv = "", taxClass = "", taxChap = "", taxEnv = "", siteCode = "", currCode = "", finEntity = "";
			int lineNo = 0;
			double amount = 0, taxAmt = 0, exchRate = 0;
			Timestamp refDate = null, tranDate = null;
			sql = "select d.line_no,d.cust_code,d.ref_type,d.ref_ser,d.ref_id,d.ref_date,d.amount, d.ref_id__adv,d.tax_class,d.tax_chap,d.tax_env, d.tax_amt ,"
					+ " h.tran_date,h.site_code, h.curr_code from adv_rcp_tax_det  d,adv_rcp_tax h where d.tran_id=h.tran_id and d.tran_id=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				lineNo = rs.getInt(1);
				custCode = rs.getString(2);
				refType = rs.getString(3);
				refSer = rs.getString(4);
				refId = rs.getString(5);
				refDate = rs.getTimestamp(6);
				amount = rs.getDouble(7);
				refidadv = rs.getString(8);
				taxClass = rs.getString(9);
				taxChap = rs.getString(10);
				taxEnv = rs.getString(11);
				taxAmt = rs.getDouble(12);
				tranDate = rs.getTimestamp(13);
				siteCode = rs.getString(14);
				currCode = rs.getString(15);
				System.out.println("lineNo[" + lineNo + "] custCode ["
						+ custCode + "] refType [" + refType + "] refSer["
						+ refSer + "]");
				System.out.println("ref_id[" + refId + "] ref_date [" + refDate
						+ "] amount [" + amount + "] refidadv[" + refidadv
						+ "]");
				System.out.println("taxClass[" + taxClass + "] taxChap ["
						+ taxChap + "] taxEnv [" + taxEnv + "] taxAmt["
						+ taxAmt + "]");
				System.out.println("tranDate[" + tranDate + "] siteCode ["
						+ siteCode + "]");
				advRcpDetMap = new HashMap();
				advRcpDetMap.put("line_no", lineNo);
				advRcpDetMap.put("cust_code", custCode);
				advRcpDetMap.put("ref_type", refType);
				advRcpDetMap.put("ref_ser", refSer);
				advRcpDetMap.put("ref_id", tranId);
				advRcpDetMap.put("ref_date", refDate);
				advRcpDetMap.put("amount", amount);
				advRcpDetMap.put("ref_id__adv", refidadv);
				advRcpDetMap.put("tax_class", taxClass);
				advRcpDetMap.put("tax_chap", taxChap);
				advRcpDetMap.put("tax_env", taxEnv);
				advRcpDetMap.put("tax_amt", taxAmt);
				advRcpDetMap.put("tran_date", tranDate);
				advRcpDetMap.put("site_code", siteCode);
				advRcpDetMap.put("curr_code", currCode);
				// DetailList.add(advPostMap);
				sql1 = "select fin_entity from site where site_code = ?";

				pstmt1 = conn.prepareStatement(sql1);
				pstmt1.setString(1, siteCode);
				rs1 = pstmt1.executeQuery();

				if (rs1.next()) {
					finEntity = rs1.getString(1);
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;

				sql1 = "select std_exrt from currency where curr_code = ?";
				pstmt1 = conn.prepareStatement(sql1);
				pstmt1.setString(1, currCode);
				rs1 = pstmt1.executeQuery();
				if (rs1.next()) {
					exchRate = rs1.getDouble(1);
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
				advRcpDetMap.put("fin_entity", finEntity);
				advRcpDetMap.put("exch_rate", exchRate);
				advRcpDetMap.put("eff_date", tranDate);
				System.out.println("advRcpDetMap::[" + advRcpDetMap + "]");
				System.out.println("advPostList Size::[" + advRcpDetMap.size()
						+ "]");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

		} catch (SQLException e) {
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		}

		return advRcpDetMap;
	}

	private double getCreditAmt(Double input) {
		double inputTemp = 0;
		if (input < 0) {
			inputTemp = input;
		} else {
			inputTemp = (-1) * input;

		}
		System.out.println("inputTemp[" + inputTemp + "]");
		return inputTemp;
	}

	private double getDebitAmt(Double input) {
		double inputTemp = 0;
		if (input < 0) {
			inputTemp = (-1) * input;

		} else {
			inputTemp = input;
		}
		System.out.println("inputTemp[" + inputTemp + "]");
		return inputTemp;
	}

}
