package ibase.webitm.ejb.fin;
import ibase.webitm.utility.*;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.*;
import ibase.system.config.*;
import java.rmi.RemoteException;
import java.util.*;
import java.text.*;
import java.sql.*;
import javax.ejb.*;
import java.util.Calendar;
import java.util.Date;
import javax.naming.InitialContext;
import ibase.system.config.AppConnectParm;
//import ibase.webitm.ejb.MasterStatefulEJB;
//import ibase.webitm.ejb.MasterStatefulLocal;


@Stateless // added for ejb3
public class ConfirmAssetRegisterIC extends ActionHandlerEJB implements ConfirmAssetRegisterICRemote,ConfirmAssetRegisterICLocal

{
	GenericUtility genericUtility = GenericUtility.getInstance();
	String errorString = null;
	/* public void ejbCreate() throws RemoteException, CreateException
	{
		System.out.println("Create Method Called....");
	}
	public void ejbRemove()
	{
	}
	public void ejbActivate()
	{
	}
	public void ejbPassivate()
	{
	} */
	public String actionHandler() throws RemoteException,ITMException
	{
		System.out.println("actionHandler() Method Called....");
		return "";
	}
	// 11/06/10 manoharan hard-coded signature while calling from framework
	//public String actionHandler(String xmlString, String xtraParams, String objContext) throws RemoteException,ITMException
	public String confirm(String xmlString, String xtraParams, String objContext) throws RemoteException,ITMException
		{
		String  retString = null;
		System.out.println("Xtra Params : " + xtraParams);
		//genericUtility = GenericUtility.getInstance();
		try
		{
			retString = actionConfirm(xmlString, xtraParams);
		}
	   	catch(Exception e)
		{
			System.out.println("Exception :actionHandler(String xmlString):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning from  actionHandler"+retString);
	    return (retString);
	}
	private String actionConfirm(String tranID, String xtraParams) throws RemoteException,ITMException, Exception
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int cnt = 0;
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		ConnDriver connDriver = new ConnDriver();
		String sql = "";
        String userId ="";
		userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		java.sql.Timestamp currDate = null;
		String returnString = null;
		
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			
			sql = "SELECT count(1) from ASSET_SHIFTDET"
				  +" where tran_id = ? ";
			
			pstmt = conn.prepareStatement( sql );
			pstmt.setString(1,tranID);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				cnt = rs.getInt( 1 );
			} 
			System.out.println(" COUNT =====> [" + cnt + "]");
			if( cnt == 0 )
			{	  
				returnString = itmDBAccessEJB.getErrorString("","ASTNOTCONF",userId);
			}
			else
			{
				sql = " Update asset_shift set "
					+ " confirmed = 'Y',"
					+ " conf_date = ?"
					+ " where tran_id = ? " ;
				System.out.println("sql....."+sql);
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1,getCurrdateAppFormat() );
				pstmt.setString(2,tranID);
				pstmt.executeUpdate();
				conn.commit();
				returnString = itmDBAccessEJB.getErrorString("","CONFSUCC",userId);
			}
		}
		catch(Exception e)
		{
			System.out.println("ConfirmAssetRegisterICEJB..."+e.getMessage());
			e.printStackTrace();
			try
			{
				conn.rollback();
			}
			catch(Exception e1)
			{
			   System.out.println("ConfirmAssetRegisterICEJB..."+e1.getMessage());
			   e1.printStackTrace();
			}
		}
		finally
		{
			try
			{
				conn.commit();
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception ConfirmAssetRegisterICEJB....... :\n"+e.getMessage());
			}
		}
		System.out.println("retString ::"+returnString);
		return returnString;
	}
	private Timestamp getCurrdateAppFormat()
    {
        String s = "";	
		Timestamp timestamp = null;		
        GenericUtility genericUtility = GenericUtility.getInstance();
        try
        {
            java.util.Date date = null;
            timestamp = new Timestamp(System.currentTimeMillis());
            
			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
            date = simpledateformat.parse(timestamp.toString());
            timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
		}
        catch(Exception exception)
        {
            System.out.println("Exception in  getCurrdateAppFormat " + exception.getMessage());
        }
        return timestamp;
    }
}
