package ibase.webitm.servlet.wms;
import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.wms.ItemTypeWizEJB;
import ibase.webitm.ejb.wms.ItemTypeWizEJBRemote;
import ibase.webitm.servlet.Messages;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ItemTypeWizServlet extends HttpServlet
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	InitialContext ctx = null;
	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		doPost( request, response );
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		try
		{
			System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ ItemTypeWizServlet ]XXXXXXXXXXXXXXXXXXXX");
			request.setCharacterEncoding(CommonConstants.ENCODING);
			ItemTypeWizEJBRemote itemTypeWizEJBRemote = null;
			String htmlData = ""; //$NON-NLS-1$
			String retStr = "";
			String actionPrint = request.getParameter("ACTION");

			System.out.println("ItemTypeWizServlet ACTION ["+actionPrint+"]");
			ctx = getInitialContext();
			itemTypeWizEJBRemote = (ibase.webitm.ejb.wms.ItemTypeWizEJBRemote) ctx.lookup("ibase/ItemTypeWizEJB/remote");
			
			if("SAVE".equalsIgnoreCase(actionPrint))
			{
				String attCode = checkNullAndTrim(request.getParameter("attrib_code"));
				String attId = checkNullAndTrim(request.getParameter("attrib_id"));
				String desc 	= checkNullAndTrim(request.getParameter("descr"));
				String shDesc 	= checkNullAndTrim(request.getParameter("sh_descr"));
				String active 	= checkNullAndTrim(request.getParameter("active_yn"));
				String sortOrder 	= checkNullAndTrim(request.getParameter("sort_order"));
				String editFlag 	= checkNullAndTrim(request.getParameter("editflag"));
				String groupType 	= checkNullAndTrim(request.getParameter("group_type"));
				retStr = itemTypeWizEJBRemote.insertItmattVal(groupType,attCode,attId,desc,shDesc,active,sortOrder,editFlag);
				System.out.println("retStr ====>> ["+retStr+"]");
				response.setContentType("text/xml");

				if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
				{
					response.setHeader("Content-Encoding", "gzip");
					GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
					gzOutStream.write(retStr.toString().getBytes());
					gzOutStream.flush();
					gzOutStream.close();
				}
				else
				{
					response.setHeader("Content-Encoding", "");
					OutputStream outStream = response.getOutputStream();
					outStream.write(retStr.toString().getBytes());
					outStream.flush();
					outStream.close();
				}
			}
			else if("ITEMCHANGE".equalsIgnoreCase(actionPrint))
			{
				String itemType = checkNullAndTrim(request.getParameter("ITEM_TYPE"));
				retStr = itemTypeWizEJBRemote.getAttribute(itemType);
				System.out.println("retStr ====>> ["+retStr+"]");
				response.setContentType("text/xml");
				
				if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
				{
					response.setHeader("Content-Encoding", "gzip");
					GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
					gzOutStream.write(retStr.toString().getBytes());
					gzOutStream.flush();
					gzOutStream.close();
				}
				else
				{
					response.setHeader("Content-Encoding", "");
					OutputStream outStream = response.getOutputStream();
					outStream.write(retStr.toString().getBytes());
					outStream.flush();
					outStream.close();
				}
			}
			else
			{
				ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )request.getSession().getAttribute( "USER_INFO" ); //$NON-NLS-1$
				if(userInfo != null)
				{
					String objName 	= request.getParameter("OBJ_NAME");//Storing ObjectName //$NON-NLS-1$
					String formNo 	= request.getParameter("FORM_NO");//Storing Current FormNo //$NON-NLS-1$
					String action	= request.getParameter("action");//Which actions is performed e.g. 'Next','Previous','Finish' //$NON-NLS-1$

					String preFormVal = request.getParameter("PRE_FORM_VAL");
					System.out.println("preFormVal==========["+preFormVal+"]");

					String editorId = (String) request.getSession().getAttribute( "WIZARD_BEAN_ID_" + objName );
					System.out.println(" ITMWizardHandlerServlet :: editorId["+editorId+"]" );

					if (request.getSession().getAttribute("WIZARD_BEAN_" + editorId) != null) 
					{
						System.out.println(" Wizard Object Found ");

						if ("previous".equalsIgnoreCase(action) && "2".equalsIgnoreCase(formNo)) 
						{
							response.sendRedirect("/ibase/webitm/jsp/ItemTypeWiz.jsp?OBJ_NAME=" + objName + "&PRE_FORM_VAL=" + preFormVal);
						}
					}
				}
				else
				{
					htmlData = Messages.getString("ITMWizardHandlerServlet_notLoggedIn")+"\n"+Messages.getString("ITMWizardHandlerServlet_pleaseReLogin"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				}
			}	

		}
		catch (Exception e) {
			// TODO: handle exception
		}
	}

	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}

	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("CrossDockAllocServlet.getInitialContext()");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("CrossDockAllocServlet.getInitialContext()"+e.getMessage());
			throw new ITMException(e);
		}
		return ctx;
	}
}
