/**
* PURPOSE : Pre Save Logic implementation for Picking component.
* AUTHOR : Gulzar on 15/09/11
*/

package ibase.webitm.ejb.wms;

import ibase.utility.CommonConstants;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.ITMException;
import ibase.utility.E12GenericUtility;

import java.rmi.RemoteException;
import java.sql.*;
import java.util.ArrayList;

import org.w3c.dom.*;

import javax.ejb.*;

@javax.ejb.Stateless
public class MultiPickWizPrs extends ValidatorEJB implements MultiPickWizPrsLocal,MultiPickWizPrsRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String preSave() throws RemoteException,ITMException
	{
		return "";
	}

	public String preSave(String xmlString, String editFlag, String xtraParams, Connection conn)throws RemoteException,ITMException
	{

		System.out.println("MultiPickWizPrs EJB called");
		Document dom = null;
		String retString = "";
		try
		{
			System.out.println("xmlString in PickIssPrs : preSaveRec---->>["+xmlString+"]");			
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = genericUtility.parseString(xmlString);
				retString = executepreSave( dom, editFlag, xtraParams, conn );
			}			
		}
		catch(Exception e)
		{
			System.out.println("Exception :MultiPickWizPrs :" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("retString final------->>["+retString+"]");		
		return retString;
	}

	private String executepreSave( Document dom, String editFlag, String xtraParams, Connection conn ) throws RemoteException, ITMException
	{
		String sql = "";			
		String tranId = "";
		String transMode = "",errString = "",ptcn = "";		
		int pachDetCnt = 0;
		ArrayList<String> ptcnList = new ArrayList <String>();
		ResultSet rs = null;
		PreparedStatement pstmt = null;

		try
		{			
			conn.setAutoCommit(false); 
			E12GenericUtility genericUtility = new E12GenericUtility();			
			tranId = checkNull(genericUtility.getColumnValue( "tran_id", dom, "2" ));
			System.out.println("executepreSave tranId------>["+tranId+"]");
			ITMDBAccessEJB itmdbAccess=new ITMDBAccessEJB();
			//transMode = checkNull(genericUtility.getColumnValue( "trans_mode", dom, "1" ));
			
			//if( tranId.trim().length() > 0 && transMode.equalsIgnoreCase("E") )
			if(dom != null  )
			{
				System.out.println("------------Generate Error String-----------------");	
				NodeList nList = dom.getElementsByTagName("Detail2");
				System.out.println("Length111------>>"+nList.getLength());
				for (int temp = 0; temp < nList.getLength(); temp++) 
				{
					Node nNode = nList.item(temp);				
					if (nNode.getNodeType() == Node.ELEMENT_NODE) 
					{					 
						Element eElement = (Element) nNode;					
						Node node1 = eElement.getElementsByTagName("attribute").item(0);
						NamedNodeMap attrsMap = node1.getAttributes();
						int noOfAttrs = attrsMap.getLength();				
						for( int cnt = 0 ; cnt < noOfAttrs; cnt++ )
						{
							Node attr = attrsMap.item(cnt);
							String attrName =  attr.getNodeName() ;
							String attrValue = attr.getNodeValue() ;
							attrName = attrName == null ? "" : attrName.trim();
							attrValue = attrValue == null ? "" : attrValue.trim();
							System.out.println("attrName : [" + attrName+"]");
							System.out.println("attrValue : [" + attrValue+"]");
							if( "updateFlag".equalsIgnoreCase(attrName) && "D".equalsIgnoreCase(attrValue) )
							{
								ptcn = eElement.getElementsByTagName("ptcn").item(0).getTextContent();
								ptcnList.add(ptcn);
								System.out.println("Deleted ptcn : [" + ptcn+"]");		                    	
							}
							else
							{
								continue;
							}
						}					
					}
				}
				System.out.println("Deleted ptcnList: [" + ptcnList+"]");
				
				
				if(ptcnList != null && ptcnList.size() > 0)
				{
					
					//Changed by Manish on 10/09/2015 for mssql database [START]	
					String DB = CommonConstants.DB_NAME;
					if("mssql".equalsIgnoreCase(DB))
					{
					sql = "select count(*) from pack_det where RTRIM(LTRIM(carton_no)) in "
						+ "(select RTRIM(LTRIM(carton_no)) from carton_master where ptcn = ?)";
					}
					
					else
					{
						sql = "select count(*) from pack_det where trim(carton_no) in "
							+ "(select trim(carton_no) from carton_master where ptcn = ?)";
					}
						
					//Changed by Manish on 10/09/2015 for mssql database [END]	
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, ptcnList.get(0));					
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						pachDetCnt = rs.getInt(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					System.out.println("pachDetCnt------>>[" + pachDetCnt+"]");
					
					if(pachDetCnt > 0)
					{
						errString = itmdbAccess.getErrorString("", "VTCNDPTCN", "", "", conn);
						return errString;
					}
				}

				
			}
		}
		catch (SQLException sqe)
		{
			System.out.println("The SQLException occurs in PickIssPrs :"+sqe);
			sqe.printStackTrace();
			throw new ITMException(sqe);
		}
		catch(Exception e)
		{
			System.out.println("The Exception occurs in PickIssPrs :"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
			}
			catch(Exception e)
			{
				System.err.println("Exception :PickIssPrs :\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}		
}
