package ibase.webitm.ejb.fin;

import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.w3c.dom.Document;


@javax.ejb.Stateless
public class MiscVoucherPostSave extends ValidatorEJB implements MiscVoucherPostSaveLocal, MiscVoucherPostSaveRemote {

	FinCommon finCommon = new FinCommon();
	DistCommon distCommon = new DistCommon();

	public String postSave() throws RemoteException, ITMException {
		return "";
	}

	public String postSave(String domString, String editFlag,String xtraParams, Connection conn) throws RemoteException,ITMException {

		System.out.println("In VoucherPostSave ... ");

		PreparedStatement pstmt = null;
		Document dom = null;
		ResultSet rs = null;
		double diffAmtExch = 0, netAmt = 0, netAmtBc = 0, billAmt = 0, taxAmt = 0, totAmt = 0;
		double advAmt = 0;
		double advAmtAdj = 0, taxedAdjAmt = 0, advAmtDet = 0, taxAmtAdv = 0;
		String exchRate = "" ,tran_id = "", sql = "", sundryType = "", advAdjMthd = "", sundryCode = "", siteCode = "";
		int cnt = 0;
		try {

			GenericUtility genericUtility = GenericUtility.getInstance();
			dom = genericUtility.parseString(domString);

			// added by azhar [start](S16ESUN001)

			// Read Header Column Values
			tran_id = checkNullAndTrim(genericUtility.getColumnValue("tran_id",dom));
			sundryType = checkNullAndTrim(genericUtility.getColumnValue("sundry_type", dom));
			advAdjMthd = genericUtility.getColumnValue("adv_adj_mthd", dom);
			// totAmt1 = genericUtility.getColumnValue("supp_bill_amt", dom);
			String tempAmt = checkNullAndTrim(genericUtility.getColumnValue("supp_bill_amt", dom));
			totAmt = tempAmt.length() > 0 ? Double.parseDouble(tempAmt) : 0;
			siteCode = checkNullAndTrim(genericUtility.getColumnValue("site_code", dom));
			sundryCode = checkNullAndTrim(genericUtility.getColumnValue("sundry_code", dom));

			System.out.println("tran id from dom::: " + tran_id);
			System.out.println("supplier bill amt::" + totAmt);

			advAdjMthd = advAdjMthd == null ? "0" : advAdjMthd.trim();

			System.out.println();

			if ("1".equalsIgnoreCase(advAdjMthd) && totAmt > 0) 
			{
				insertIntoMiscVouchAdv(tran_id, sundryType, totAmt, siteCode,sundryCode, conn);
			}	
			

			// added by azhar[end](S16ESUN001)

			// Advance Screen Cross Update
			sql = "select exch_rate from misc_voucher where tran_id=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tran_id);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				exchRate = rs.getString("exch_rate");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			// To update diff_amt__exch for every line_no
			sql = "update misc_vouchadv set diff_amt__exch=((coalesce(adj_amt,0) * coalesce(exch_rate__vouch,0))-(coalesce(adj_amt,0)*?)) where tran_id= ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, exchRate);
			pstmt.setString(2, tran_id);
			pstmt.close();
			pstmt = null;

			/** Commented by Vallabh Kadam 28/NOV/14 */
			// sql="select coalesce(((mvadv.adj_amt * mvadv.exch_rate__vouch) - (mvadv.adj_amt * mv.exch_rate)),0) "
			// +
			// " from misc_vouchadv mvadv join misc_voucher mv on mvadv.tran_id = mv.tran_id WHERE  mvadv.tran_id = ? "
			// ;
			/** Commented by Vallabh Kadam 28/NOV/14 END */

			// SUM of all diff_amt__exch to update in header
			sql = "select coalesce(sum(diff_amt__exch),0) from misc_vouchadv where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tran_id);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				diffAmtExch = rs.getDouble(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			sql = "select coalesce(sum(adj_amt),0),  coalesce(sum(taxed_adj_amt),0), coalesce(sum(tax_amt),0) from misc_vouchadv WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tran_id);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				advAmtAdj = rs.getDouble(1);
				taxedAdjAmt = rs.getDouble(2);
				taxAmtAdv = rs.getDouble(3);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			sql = "select coalesce((adv_amt__adj + adv_amt__det),0), coalesce((coalesce((adv_amt__adj + adv_amt__det),0) + tot_amt),0), coalesce((coalesce((adv_amt__adj + adv_amt__det),0) + tot_amt),0) + coalesce(exch_rate,0) from misc_voucher WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tran_id);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				advAmt = rs.getDouble(1);
				netAmt = rs.getDouble(2);
				netAmtBc = rs.getDouble(3);

			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			/** Commented on 28/NOV/14 Vallabh Kadam */
			// sql="UPDATE misc_vouchadv set diff_amt__exch = ? "
			// +" WHERE  tran_id = ? ";
			// pstmt = conn.prepareStatement(sql);
			// pstmt.setDouble(1,diffAmtExch );
			// pstmt.setString(2,tran_id );
			// cnt = pstmt.executeUpdate();
			// pstmt.close();
			// pstmt = null;

			// if( cnt > 0)
			// {
			// System.out.println("update of advance Screen success ["+cnt+"]");
			// }
			/** Commented on 28/NOV/14 Vallabh Kadam END */

			sql = "UPDATE misc_voucher set adv_amt__adj = ?, adv_amt = ?, taxed_adj_amt = ?, diff_amt__exch = ?, net_amt = ?, net_amt__bc = ? " +
					" WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setDouble(1, advAmtAdj);
			pstmt.setDouble(2, advAmt);
			pstmt.setDouble(3, taxedAdjAmt);
			pstmt.setDouble(4, diffAmtExch);
			pstmt.setDouble(5, netAmt);
			pstmt.setDouble(6, netAmtBc);
			pstmt.setString(7, tran_id);
			cnt = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;

			if (cnt > 0) {
				System.out.println("update of advance Screen in misc_voucher success [" + cnt + "]");
			}
			// End Of advance Screen cross Update

			// Detail Screen Cross Update
			sql = "select case when mv.vouch_type = 'A' Then coalesce(sum(mvdet.amount),0) " + "ELSE 0 END, "
					+ "case when mv.vouch_type != 'A' Then coalesce(sum(mvdet.amount),0) " + "ELSE 0 END,"
					+ " coalesce(sum(mvdet.tax_amt),0) from misc_vouchdet mvdet join misc_voucher mv "
					+ "on mvdet.tran_id = mv.tran_id WHERE  mvdet.tran_id = ? group by mv.vouch_type";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tran_id);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				advAmtDet = rs.getDouble(1);
				billAmt = rs.getDouble(2);
				taxAmt = rs.getDouble(3);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			sql = "UPDATE misc_voucher set adv_amt__det = ? " +
					"  WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setDouble(1, advAmtDet);
			pstmt.setString(2, tran_id);
			cnt = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;
			

			sql = "select coalesce(adv_amt__adj + adv_amt__det,0) from misc_voucher WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tran_id);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				advAmt = rs.getDouble(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			

			totAmt = billAmt + (taxAmt + taxAmtAdv);
			netAmt = advAmt + totAmt;

			sql = "select coalesce(? * exch_rate,0) from misc_voucher WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setDouble(1, netAmt);
			pstmt.setString(2, tran_id);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				netAmtBc = rs.getDouble(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println("Taxy Amt = " + taxAmt + " totAmt = " + totAmt);

			sql = "UPDATE misc_voucher set adv_amt__det = ?, bill_amt = ?, adv_amt = ?, tax_amt = ?, tot_amt = ?, net_amt = ?, net_amt__bc = ?" +
					"  WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setDouble(1, advAmtDet);
			pstmt.setDouble(2, billAmt);
			pstmt.setDouble(3, advAmt);
			pstmt.setDouble(4, (taxAmt + taxAmtAdv));
			pstmt.setDouble(5, totAmt);
			pstmt.setDouble(6, netAmt);
			pstmt.setDouble(7, netAmtBc);
			pstmt.setString(8, tran_id);
			cnt = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;

		/*	sql = "update misc_vouchdet_cctr set net_amount = amount + tax_amt where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tran_id);
			cnt = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;
		*/

			sql = "update misc_vouchdet set net_amount = amount + tax_amt where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tran_id);
			cnt = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;

			if (cnt > 0) {
				System.out.println("update of Detail Screen success [" + cnt + "]");
			}

			// End Of Detail Screen Cross Update

		} catch (Exception e) {
			System.out.println("Exception : MiscVoucherPostSave -->[" + e.getMessage() + "]");
			e.printStackTrace();
			try {
			} catch (Exception e1) {
				System.out.println("Exception while rollbacking transaction....");
				e1.printStackTrace();
			}
		}
		System.out.println("Out MiscVoucherPostSaveEJB ... ");
		return "";
	}

	/*
	 * private java.math.BigDecimal round(int scale ,double round) { return new
	 * java.math.BigDecimal(round).setScale(scale,
	 * java.math.BigDecimal.ROUND_UP); }
	 * 
	 * private double roundVal(double round,int scale) { return
	 * Math.round(round*Math.pow(10, scale))/Math.pow(10, scale); }
	 */

	// added by azhar[start](S16ESUN001)

	private void insertIntoMiscVouchAdv(String tran_id, String sundryType,double totAmt,String siteCode, String sundryCode, Connection conn)
			throws ITMException {

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "", varValue = "",tranId = "", refSer = "", refNo = "";
		double totAmtPayAbs = 0.0, adjAmtPayAbs = 0.0, adjAmt = 0.0, totAmtTemp = 0.0;
		double totAmtPay = 0.0, adjAmtPay = 0.0, adjAmtAbs = 0.0;
		String currCodePay = "", acctCode = "",cctrCode = "", exchRate = "";
		int lineNo = 1;

		try {

			sql = "delete from misc_vouchadv where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tran_id);
			pstmt.executeUpdate();

			totAmtTemp = totAmt;

			sql = "select var_value from finparm where var_name = 'ADV_ADJ_ACCT_CODE' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next()) {

				varValue = rs.getString("var_value");
			}

			varValue = varValue == null ? "" : varValue.trim();

			System.out.println("var value ::: " + varValue);

			sql = "select tran_id,tran_ser,ref_no,tot_amt,adj_amt,curr_code,acct_code,cctr_code,exch_rate from misc_payables where site_code = ? and sundry_type = ? and sundry_code = ? " +
					"and tot_amt <> adj_amt and tot_amt < 0 and acct_code in ("+ varValue + ") order by tran_date";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			pstmt.setString(2, sundryType);
			pstmt.setString(3, sundryCode);
			rs = pstmt.executeQuery();

			while (rs.next()) {
				tranId = checkNullAndTrim(rs.getString("tran_id"));
				refSer = checkNullAndTrim(rs.getString("tran_ser"));
				refNo = checkNullAndTrim(rs.getString("ref_no"));
				totAmtPay = rs.getDouble("tot_amt");
				adjAmtPay = rs.getDouble("adj_amt");
				totAmtPayAbs = Math.abs(rs.getDouble("tot_amt"));
				adjAmtPayAbs = Math.abs(rs.getDouble("adj_amt"));
				currCodePay = checkNullAndTrim(rs.getString("curr_code"));
				acctCode = checkNullAndTrim(rs.getString("acct_code"));
				//cctrCode = checkNullAndTrim(rs.getString("cctr_code"));
				cctrCode = rs.getString("cctr_code");
				exchRate = checkNullAndTrim(rs.getString("exch_rate"));

				System.out.println("tran id :: " + tranId + " tran ser::: " + refSer + "ref no::: " + refNo + " ::tot amt " + totAmtPayAbs +
						"::adj amt pay:: " + adjAmtPayAbs + ":::curr code::" + currCodePay + "::acct code::" + acctCode + "cctr code::["+cctrCode+"]:: exch rate::["+exchRate+"]");
				

				if (totAmtTemp > 0) {
					adjAmt = totAmtPay - adjAmtPay - getUnconfirmedVouchValue(refNo, siteCode, sundryCode, sundryType, refSer, conn);
				}

				adjAmtAbs = Math.abs(adjAmt);

				System.out.println("adj amt to be set::: " + adjAmt);

				// if(totAmtTemp>=adjAmt && adjAmt > 0)
				if ((totAmtTemp >= adjAmtAbs && totAmtTemp > 0) || (totAmtTemp < adjAmtAbs && totAmtTemp > 0)) {
					if (totAmtTemp < adjAmtAbs) {
						if (adjAmt < 0) {
							adjAmt = -totAmtTemp;
							System.out.println("when adj amt is greater the amt to be set is::"+ adjAmt);
						} else {
							adjAmt = totAmtTemp;
						}
					}
					
					System.out.println("total amount temp:: " + totAmtTemp);

					if(adjAmtAbs > 0){
					sql = "Insert into misc_vouchadv(tran_id,ref_ser,ref_no,adj_amt,tot_amt,line_no,curr_code,acct_code,cctr_code,exch_rate__vouch) values(?,?,?,?,?,?,?,?,?,?)";// TODO insert
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tran_id);
					pstmt.setString(2, refSer);
					pstmt.setString(3, refNo);
					pstmt.setDouble(4, adjAmt);
					pstmt.setDouble(5, totAmtPay);
					pstmt.setInt(6, lineNo);
					pstmt.setString(7, currCodePay);
					pstmt.setString(8, acctCode);
					pstmt.setString(9, cctrCode);
					pstmt.setString(10, exchRate);
					pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
					}

					lineNo++;
					totAmtTemp -= adjAmtAbs;

				
				}
			}

		} catch (Exception e) {
			System.out.println(":::: " + this.getClass().getSimpleName() + "::: " + e.getMessage());
			e.printStackTrace();

		} finally {
			try {
				
				
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e) {
				System.out.println(":::: " + this.getClass().getSimpleName() + "::: " + e.getMessage());
				e.printStackTrace();

			}

		}

	}

	private double getUnconfirmedVouchValue(String refNo, String siteCode,String sundryCode, String sundryType, String refSer, Connection conn) {

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		double unconfirmedAmt = 0, totAmtMVouch1 = 0, totAmtVouch1 = 0;

		try {

			sql = "select nvl(sum(a.adj_amt),0) from misc_voucher v, misc_vouchadv  a where v.tran_id = a.tran_id and v.confirmed = 'N' "
					+ "and v.sundry_code = ? and v.site_code = ? and v.sundry_type = ? and a.ref_no = ? and a.ref_ser = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, sundryCode);
			pstmt.setString(2, siteCode);
			pstmt.setString(3, sundryType);
			pstmt.setString(4, refNo);
			pstmt.setString(5, refSer);
			rs = pstmt.executeQuery();

			if (rs.next()) {
				totAmtMVouch1 = rs.getDouble(1);
			}

			System.out.println("tot amt misc voucher::: " + totAmtMVouch1);

			closeResources(pstmt, rs);

			sql = "select nvl(sum(a.adj_amt),0) from voucher v, vouchadv  a where v.tran_id = a.tran_id and v.confirmed = 'N' "
					+ "and v.supp_code = ? and v.site_code = ? and a.ref_no = ? and a.ref_ser = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, sundryCode);
			pstmt.setString(2, siteCode);
			pstmt.setString(3, refNo);
			pstmt.setString(4, refSer);

			rs = pstmt.executeQuery();
			if (rs.next()) {
				totAmtVouch1 = rs.getDouble(1);
			}

			System.out.println("tot amt voucher::: " + totAmtVouch1);

			closeResources(pstmt, rs);

			unconfirmedAmt = totAmtMVouch1 + totAmtVouch1;

		} catch (Exception e) {
			System.out.println("::" + this.getClass().getSimpleName() + ":::" + e.getMessage());
			e.printStackTrace();
		}
		return unconfirmedAmt;
	}

	// added by azhar[end](S16ESUN001)
	private void closeResources(PreparedStatement pstmt, ResultSet rs) {

		try {
			if (pstmt != null) {

				pstmt.close();
				pstmt = null;
			}
			if (rs != null) {

				rs.close();
				rs = null;
			}
		} catch (Exception e) {
			System.out.println("::" + this.getClass().getSimpleName() + ":::" + e.getMessage());
			e.printStackTrace();
		}
	}

	private String checkNullAndTrim(String strValue) {
		return strValue == null ? "" : strValue.trim();
	}
}
