/********************************************************
	Title 	 : AutoFundTransferSch [F15CSUN017]
	Date  	 : 23/JUN/15
	Developer: Pankaj R.
 ********************************************************/

package ibase.webitm.ejb.fin;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import javax.xml.rpc.ParameterMode;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;


public class AutoFundTransferSch implements Schedule
{
	E12GenericUtility genericUtility=new E12GenericUtility();
	@Override
	public String schedule(String scheduleParamXML)throws Exception
	{	
		ibase.utility.UserInfoBean userInfo = null;
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		String loginSiteCode="";		
		String sysDate ="";
		String retString="";
		String xtraParams = "",sql="";   
		String siteCodeFr="",siteCodeTo="",bankCodeFr="",bankCodeTo="",receiptMode="",processType="",confirm="",rcpDishnr="";//The parameters from BaseApplication.xml
		String siteFrDesc="",siteToDesc="",bankFrDesc="",bankToDesc="",xmlString="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			System.out.println("********* In Scheduler try ***************");			
			Document dom = null;
			int noOfParam=0;			
			userInfo = new ibase.utility.UserInfoBean( scheduleParamXML );
			loginSiteCode = userInfo.getSiteCode();			
			xtraParams = "loginCode="+userInfo.getLoginCode()+"~~termId="+userInfo.getRemoteHost()+"~~loginSiteCode="
			+loginSiteCode+"~~loginEmpCode="+userInfo.getEmpCode();
			
			System.out.println("XTRAPARAMS contain :- ["+xtraParams+"]");
			
			System.out.println("ScheduleParamXML contains :- ["+scheduleParamXML+"]");
			dom=genericUtility.parseString(scheduleParamXML);
			
			java.util.Date today=new java.util.Date();
			Calendar cal = Calendar.getInstance(); 
			cal.setTime(today); 
			today = cal.getTime();
			SimpleDateFormat sdf=new SimpleDateFormat(genericUtility.getApplDateFormat());
			sysDate=sdf.format(today);
			
			NodeList paramList = dom.getElementsByTagName( "SCHEDULE" );
            noOfParam = paramList.getLength();            
            NodeList parentNodeList = null,childNodeList = null;
			Node parentNode = null,childNode = null;			
			int childNodeListLength = 0;
			String childNodeName = null;						
			parentNodeList = dom.getElementsByTagName("ACTUALPARAMETERS");
			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			System.out.println("childNodeListLength  !!!!!"+ childNodeListLength);
			System.out.println("Number of Param  !!!!!"+ noOfParam);
			for(int ctr = 0; ctr < childNodeListLength; ctr++)
			{
				childNode = childNodeList.item(ctr);
				childNodeName = childNode.getNodeName();
							
				if(childNodeName!=null && !"#text".equalsIgnoreCase(childNodeName))
				{
					if(ctr==0)
					{
						siteCodeFr = childNode.getFirstChild().getNodeValue();
					}
					if(ctr==1)
					{
						siteCodeTo = childNode.getFirstChild().getNodeValue();
					}
					if(ctr==2)
					{
						bankCodeFr = childNode.getFirstChild().getNodeValue();
					}
					if(ctr==3)
					{
						bankCodeTo = childNode.getFirstChild().getNodeValue();
					}
					if(ctr==4)
					{
						receiptMode = childNode.getFirstChild().getNodeValue();						
					}
					if(ctr==5)
					{
						processType = childNode.getFirstChild().getNodeValue();						
					}
					if(ctr==6)
					{
						confirm = childNode.getFirstChild().getNodeValue();						
					}
					if(ctr==7)
					{
						rcpDishnr = childNode.getFirstChild().getNodeValue();						
					}
				}
			}
			System.out.println("Site Code From>>>>>"+siteCodeFr);
			System.out.println("Site Code To>>>>>"+siteCodeTo);
			System.out.println("Bank Code From>>>>>"+bankCodeFr);
			System.out.println("Bank Code To>>>>>"+bankCodeTo);
			System.out.println("Receipt Mode>>>>>"+receiptMode);
			System.out.println("Process Type>>>>>"+processType);
			System.out.println("Confirm>>>>>"+confirm);
			System.out.println("Rcp Dishnr>>>>>"+rcpDishnr);
			
			sql = "Select descr from site where site_code = ? "; 
			pstmt =  conn.prepareStatement(sql);
			pstmt.setString(1,siteCodeFr);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				siteFrDesc=rs.getString("descr");
				System.out.println("Site From Descr>>>>"+siteFrDesc);
			}
			rs.close();
			rs = null;
			pstmt.close(); 
			pstmt = null;
			
			sql = "Select descr from site where site_code = ? "; 
			pstmt =  conn.prepareStatement(sql);
			pstmt.setString(1,siteCodeTo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				siteToDesc=rs.getString("descr");
				System.out.println("Site From Descr>>>>"+siteToDesc);
			}
			rs.close();
			rs = null;
			pstmt.close(); 
			pstmt = null;
			
			if(bankCodeFr.equalsIgnoreCase("00"))
			{
				bankFrDesc="";
				System.out.println("BankCode From Name>>>>>>>>> "+bankFrDesc);
			}
			else
			{
				sql = "select bank_name from bank where bank_code= ? "; 
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,bankCodeFr);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					bankFrDesc=rs.getString("bank_name");
					System.out.println("BankCode From Descr>>>>"+bankFrDesc);
				}
				rs.close();
				rs = null;
				pstmt.close(); 
				pstmt = null;
			}
			if(bankCodeTo.equalsIgnoreCase("ZZ"))
			{
				bankToDesc="";
				System.out.println("BankCode From Name>>>>>>>>> "+bankToDesc);
			}
			else
			{
				sql = "select bank_name from bank where bank_code = ? "; 
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,bankCodeTo);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					bankToDesc=rs.getString("bank_name");
					System.out.println("BankCode To Descr>>>>"+bankToDesc);
				}
				rs.close();
				rs = null;
				pstmt.close(); 
				pstmt = null;
			}
			
			StringBuffer recTabStrBuff = new StringBuffer();
			
			recTabStrBuff.append(siteCodeFr).append("\t");
			recTabStrBuff.append(siteCodeTo).append("\t");
			recTabStrBuff.append(bankCodeFr).append("\t");
			recTabStrBuff.append(bankCodeTo).append("\t");
			recTabStrBuff.append(sysDate).append("\t");
			recTabStrBuff.append(processType).append("\t");
			recTabStrBuff.append(confirm).append("\t");
			recTabStrBuff.append(rcpDishnr).append("\t");
			recTabStrBuff.append(siteFrDesc).append("\t");
			recTabStrBuff.append(siteToDesc).append("\t");
			recTabStrBuff.append(bankFrDesc).append("\t");
			recTabStrBuff.append(bankToDesc).append("\t");
			recTabStrBuff.append(receiptMode).append("\t");
			recTabStrBuff.append("").append("\t");
			recTabStrBuff.append("").append("\n");
			
			xmlString=recTabStrBuff.toString();
			System.out.println("XML toString>>>>>>>>>>>>>"+recTabStrBuff.toString());
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			System.out.println("==site code =="+loginSiteCode);
			System.out.println("Printing xmlString"+xmlString);
			System.out.println("After Creating xml");
	        if(xmlString != null && xmlString.trim().length()>0)
	        {
	           	retString = autoFundTransfer("receipt_fundtransfer",loginSiteCode,xmlString,xtraParams,conn);
	        }
				System.out.println("retString  :-"+retString);
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return retString;
	}
	
	/**
	 * This method is used to Transfer the Fund Automatically
	 * @param objName as Object Name [String]
	 * @param siteCode as Login Site Code [String]
	 * @param xmlString 
	 * @param xtraParams as extra parameters
	 * @param conn as Connection object
	 * @return the String [SUCCESS/NOROW FOUND]
	 * @throws ITMException
	 * @throws SQLException
	 */
	private String autoFundTransfer(String objName, String siteCode,String xmlString, String xtraParams, Connection conn) throws ITMException, SQLException
	{
		System.out.println("****** Auto Fund Transfer Process *****");
		String methodName = "",compName = "",compType="",retString = "",serviceCode = "",serviceURI = "",actionURI = "";
		String dummy="";
		String sql;
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		try
		{
			methodName = "gbf_process";
			actionURI = "http://NvoServiceurl.org/" + methodName;
			System.out.println("Action URI>>>>>"+actionURI);
			
			sql = "SELECT SERVICE_CODE,COMP_NAME,COMP_TYPE FROM SYSTEM_EVENTS WHERE OBJ_NAME = ? AND EVENT_CODE = 'process'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,objName);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				serviceCode = rs.getString("SERVICE_CODE");
				compName = rs.getString("COMP_NAME");
				compType = rs.getString("COMP_TYPE");
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			System.out.println("serviceCode = "+serviceCode+" compName "+compName+" compType "+compType);
			
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,serviceCode);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				serviceURI = rs.getString("SERVICE_URI");
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			System.out.println("serviceURI = "+serviceURI+" compName = "+compName);
			
			Service service = new Service();
			Call call = (Call)service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(serviceURI));
			call.setOperationName( new javax.xml.namespace.QName("http://NvoServiceurl.org", methodName ) );
			call.setUseSOAPAction(true);
			call.setSOAPActionURI(actionURI);
			Object[] aobj = new Object[5];
			
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "component_type"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "component_name"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "tab_xml_data_1"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "dummy"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "xtra_params"), XMLType.XSD_STRING, ParameterMode.IN);
				
			aobj[0] = new String(compType);
			aobj[1] = new String(compName);
			aobj[2] = new String(xmlString);
			aobj[3] = new String(dummy);
			aobj[4] = new String(xtraParams);
			
			System.out.println("@@@@@@ call.setReturnType(XMLType.XSD_STRING) Executing........");
			call.setReturnType(XMLType.XSD_STRING);
			retString = (String)call.invoke(aobj);
			System.out.println(">>>>Fund Transfer Completed.Return string from NVO is:==>["+retString+"]");			
		}	
		catch(Exception e)
		{
			conn.rollback();
			System.out.println(">>>>>>>>In catch:");
			e.printStackTrace();
			System.out.println(e);
		}
		finally
		{
			if(conn!=null)
			{
				conn.commit();
				conn.close();
				conn=null;
			}			
		}
		return retString;
	}
	public String schedule(HashMap arg0) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}
	@Override
	public String schedulePriority(String arg0) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}
}

