package ibase.client;

import java.util.ArrayList;

import java.util.ArrayList;

import com.google.gwt.core.client.Callback;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * This class is main class for create a dynamic E12DashBoard page. <BR>
 * Parse the xml value and create a DataSet. <BR>
 * This class hold the FilterContainer and GroupComponentContainer.
 */
/**
 * @author sachin shinde
 */
public class E12DashBoardPage extends Composite
{
	/** This is main container for show the GWTDashbaordReport */
	public static VerticalPanel mainReportContainer = new VerticalPanel();
	private static GraphComponent graphComponent = null;

	public JSONObject metaDataJsnObj = null;

	public E12DashBoardPage(ArrayList<String> parameterList, JSONObject metaDataJsnObj)
	{
		try
		{
			this.metaDataJsnObj = metaDataJsnObj;
			graphComponent = new GraphComponent(parameterList,metaDataJsnObj,"Y");
			graphComponent.setWidth("100%");
			mainReportContainer.setWidth("100%");
			mainReportContainer.add(graphComponent);
			initWidget(mainReportContainer);
			initaliseGraphNGrid(parameterList);
		} catch (Exception e)
		{
			Window.alert("Exception :: E12DashBoardPage parametarized constructor [" + e.getMessage() + "]");
		}
	}

	public static void initaliseGraphNGrid(ArrayList<String> parameterList)
	{
		graphComponent.getData(new Callback<JSONObject, String>()
		{
			@Override
			public void onSuccess(JSONObject jsnObj)
			{
			}
			@Override
			public void onFailure(String result)
			{
				Window.alert("Exception in  initaliseGraphNGrid():: E12DashBoardPage [" + result + "]");
			}
		}, parameterList);
	}

	public static void getJsonForFilterData(final Callback<JSONObject, String> callback, String fileName)
	{
		String objActionPath = null;
		final int STATUS_CODE_OK = 200;
		objActionPath = "/ibase/ParentMetaDataServlet?fileName=" + fileName;
		try
		{
			RequestBuilder reqBuilder = new RequestBuilder(RequestBuilder.POST, objActionPath);
			reqBuilder.sendRequest(null, new RequestCallback()
			{
				@Override
				public void onResponseReceived(Request request, Response response)
				{
					if (STATUS_CODE_OK == response.getStatusCode())
					{
						JSONObject jsonObjMetaData = null;
						jsonObjMetaData = (JSONObject) JSONParser.parseStrict(response.getText());
						callback.onSuccess(jsonObjMetaData);
					} else
					{
						Window.alert("Responce is null,case of metadata reading");
					}
				}

				@Override
				public void onError(com.google.gwt.http.client.Request request, Throwable exception)
				{
					Window.alert("Error occured in getJsonForFilterData() :E12DashBoardPage:" + exception.getMessage());
				}
			});
		} catch (RequestException e)
		{
			e.printStackTrace();
		}

	}
}
