package ibase.webitm.ejb.adm;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Session Bean implementation class FinEntAcctPrd
 */

@Stateless
public class FinEntAcctPrd extends ValidatorEJB implements FinEntAcctPrdRemote, FinEntAcctPrdLocal 
{
	// VALIDATION START
	public String wfValData() throws RemoteException, ITMException 
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try 
		{
			if (xmlString != null && xmlString.trim().length() != 0) 
			{
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) 
			{
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) 
			{
				dom2 = parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		} 
		catch (Exception e) 
		{
			System.out.println("Exception : FinEntAcctPrd : wfValData(String xmlString) : ==>" + e.getMessage());
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int currentFormNo = 0, childNodeListLength = 0;
		String userId = "";
		String childNodeName = null;
		String errString = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		SimpleDateFormat simpleDateFormat = null;

		String msgType = "";

		GenericUtility genericUtility = GenericUtility.getInstance();

		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();

		try 
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo) 
			{
				case 1:
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for (int ctr = 0; ctr < childNodeListLength; ctr++) 
					{
						childNode = childNodeList.item(ctr);
						if (childNode.getNodeType() != Node.ELEMENT_NODE) 
						{
							continue;
						}
						childNodeName = childNode.getNodeName();

						System.out.println("childNodeName.editFlag." + childNodeName + ".." + editFlag);

						if (childNodeName.equalsIgnoreCase("fin_entity")) 
						{
							String finEnt = checkNull(genericUtility.getColumnValue("fin_entity", dom));
							
							// FIN_ENTITY is mandatory
							if (finEnt.length() == 0) 
							{

								System.out.println("fin_entity is empty");

								errList.add("VMFENACP01");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMFENACP01");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}

							else 
							{
								// FIN_ENTITY must be present in FINENT table.
								int cnt = 0;
								String finent = checkNull(genericUtility.getColumnValue("fin_entity", dom));

								System.out.println("fin_entity invalid");

								String sql = " select count(1) as RowCount from finent where fin_entity = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, finent);
								rs = pstmt.executeQuery();

								if (rs.next()) 
								{
									cnt = rs.getInt("RowCount");
								}

								if (rs != null) 
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null) 
								{
									pstmt.close();
									pstmt = null;
								}

								if (cnt < 1) 
								{
									System.out.println("fin_entity error message");

									errList.add("VMFENACP02");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMFENACP02");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
							}
						} 
						else if (childNodeName.equalsIgnoreCase("acct_prd")) 
						{
							String acctPrd = checkNull(genericUtility.getColumnValue("acct_prd", dom));
							
							// ACCT_PRD is mandatory
							if (acctPrd.length() == 0) 
							{

								errList.add("VMFENACP03");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMFENACP03");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}

							// ACCT_PRD must be present in ACCTPRD table.
							else 
							{
								int cnt = 0;

								String sql = " select count(1) as RowCount from acctprd where code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, acctPrd);
								rs = pstmt.executeQuery();

								if (rs.next()) 
								{
									cnt = rs.getInt("RowCount");
								}

								if (rs != null) 
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null) 
								{
									pstmt.close();
									pstmt = null;
								}

								if (cnt < 1) 
								{
									errList.add("VMFENACP04");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMFENACP04");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}
							}
							
							
							// FIN_ENTITY AND ACCT_PRD SHOULD NOT EXIST IN FINENT_ACCTPRD TABLE
							if (editFlag.equalsIgnoreCase("A")) 
							{
								int cnt = 0;
								String finEnt = checkNull(genericUtility.getColumnValue("fin_entity", dom));

								String sql = " select count(1) as RowCount from finent_acctprd where fin_entity = ? and acct_prd = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, finEnt);
								pstmt.setString(2, acctPrd);
								rs = pstmt.executeQuery();
								
								if (rs.next()) 
								{
									cnt = rs.getInt("RowCount");
								}

								if (rs != null) 
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null) 
								{
									pstmt.close();
									pstmt = null;
								}

								if (cnt > 0) 
								{
									errList.add("VMFENACP05");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMFENACP05");
									if (msgType.equalsIgnoreCase("E")) 
									{
										break;
									}
								}

							}

						} 
						else if (childNodeName.equalsIgnoreCase("descr")) 
						{
							String descr = checkNull(genericUtility.getColumnValue("descr", dom));
							
							// DESCR is mandatory
							if (descr.length() == 0) 
							{
								errList.add("VMFENACP06");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMFENACP06");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}
						}

						else if (childNodeName.equalsIgnoreCase("fr_date")) 
						{
							String frDate = checkNull(genericUtility.getColumnValue("fr_date", dom));
							String toDate = checkNull(genericUtility.getColumnValue("to_date", dom));
							
							java.sql.Timestamp frDateSql = null;
							try
							{
								frDateSql = Timestamp.valueOf(genericUtility.getValidDateTimeString(frDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
							}
							catch(Exception e)
							{
								errList.add("VMFENACP07");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMFENACP07");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}
							
							java.sql.Timestamp toDateSql = null;
							try
							{
								toDateSql = Timestamp.valueOf(genericUtility.getValidDateTimeString(toDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
							}
							catch(Exception e)
							{
								errList.add("VMFENACP09");
								errFields.add("to_date");

								msgType = errorType(conn, "VMFENACP09");
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}
							
							// FR_DATE is mandatory
							if (frDate.length() == 0) 
							{
								errList.add("VMFENACP07");
								errFields.add(childNodeName.toLowerCase());

								msgType = errorType(conn, "VMFENACP07");
								if (msgType.equalsIgnoreCase("E")) 
								{
									break;
								}
							}
							

							// FR_DATE SHOULD NOT OVERLAP EXISTING ACCOUNT PERIOD
							else if(simpleDateFormat.parse(frDate).compareTo(simpleDateFormat.parse(toDate)) < 0)
							{
								int cnt = 0;
								String finEnt = checkNull(genericUtility.getColumnValue("fin_entity", dom));
								String acctPrd = checkNull(genericUtility.getColumnValue("acct_prd", dom));
								
								String sql = " select count(1) as RowCount from finent_acctprd where fin_entity = ? and acct_prd <> ? and ((fr_date <= ? and to_date >= ?) or ( fr_date >= ? and to_date <= ?))";
								System.out.println("sql for overlap from_date : " + sql);
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, finEnt);
								pstmt.setString(2, acctPrd);
								pstmt.setTimestamp(3, frDateSql);
								pstmt.setTimestamp(4, frDateSql);
								pstmt.setTimestamp(5, frDateSql);
								pstmt.setTimestamp(6, toDateSql);
								
								System.out.println("sql for overlap to_date : " + sql);

								rs = pstmt.executeQuery();
								System.out.println("fin_entity : " + finEnt);
								System.out.println("fr_date : " + frDate);

								if (rs.next()) 
								{
									cnt = rs.getInt("RowCount");
								}

								if (rs != null) 
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null) 
								{
									pstmt.close();
									pstmt = null;
								}

								if (cnt > 0) 
								{
									errList.add("VMFENACP08");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMFENACP08");
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
							}

						}
						
						else if (childNodeName.equalsIgnoreCase("to_date"))
						{
							String toDate = checkNull(genericUtility.getColumnValue("to_date", dom));
							System.out.println("Inside childNode to_date :: " + childNodeName + toDate);
							
							// TO_DATE is mandatory
							if (toDate.length() == 0)
							{
								errList.add("VMFENACP09");
								errFields.add(childNodeName.toLowerCase());
								msgType = errorType(conn, "VMFENACP09");
								if (msgType.equalsIgnoreCase("E"))
								{
									break;
								}
							}

							else
							{
								String frDate = checkNull(genericUtility.getColumnValue("fr_date", dom));
								
								java.sql.Timestamp toDateSql = null;
								try
								{
									toDateSql = Timestamp.valueOf(genericUtility.getValidDateTimeString(toDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));
								}
								catch(Exception e)
								{
									errList.add("VMFENACP09");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMFENACP09");
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								
								// TO_DATE SHOULD BE GREATER THAN FR_DATE
								if (simpleDateFormat.parse(frDate).compareTo(simpleDateFormat.parse(toDate)) >= 0) 
								{
									errList.add("VMFENACP10");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMFENACP10");
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}

								// TO_DATE SHOULD NOT OVERLAP EXISTING ACCOUNT PERIOD
								else
								{
									int cnt = 0;
									String finEnt = checkNull(genericUtility.getColumnValue("fin_entity", dom));
									String acctPrd = checkNull(genericUtility.getColumnValue("acct_prd", dom));
									String sql = " select count(1) as RowCount from finent_acctprd where fin_entity = ? and acct_prd <> ? and ((fr_date <= ? and to_date >= ?) or (fr_date >= ? and to_date <= ?)) ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, finEnt);
									pstmt.setString(2, acctPrd);
									pstmt.setTimestamp(3, toDateSql);
									pstmt.setTimestamp(4, toDateSql);
									pstmt.setTimestamp(5, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(frDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
									pstmt.setTimestamp(6, toDateSql);

									System.out.println("sql for overlap to_date : " + sql);

									System.out.println("fin_entity : " + finEnt);
									System.out.println("to_date : " + toDate);
									rs = pstmt.executeQuery();

									if (rs.next()) 
									{
										cnt = rs.getInt("RowCount");
									}

									if (rs != null) 
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null) 
									{
										pstmt.close();
										pstmt = null;
									}

									if (cnt > 0)
									{
										errList.add("VMFENACP11");
										errFields.add(childNodeName.toLowerCase());

										msgType = errorType(conn, "VMFENACP11");
										if (msgType.equalsIgnoreCase("E")) 
										{
											break;
										}
									}
								}
							}
						}
						else if (childNodeName.equalsIgnoreCase("it_fr_date")) 
						{				
							String itFrDate = checkNull(genericUtility.getColumnValue("it_fr_date", dom));
							String itToDate = checkNull(genericUtility.getColumnValue("it_to_date", dom));

							System.out.println("it_fr_date inside it_fr_date :: " + itFrDate);
							System.out.println("it_to_date inside it_fr_date :: " + itToDate);

							if(itFrDate != null && itFrDate.length() != 0)
							{
								// IT_TO_DATE IS MANDATORY IF IT_FR_DATE IS SPECIFIED
								if (itToDate.length() == 0)
								{
									errList.add("VMFENACP12");
									errFields.add("it_to_date");
									System.out.println("it_to_date cannot be left blank...");
									System.out.println("it_fr_date :: " + itFrDate + "it_to_date :: " + itToDate);

									msgType = errorType(conn, "VMFENACP12");
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}

								//IT_FR_DATE SHOULD NOT OVERLAP EXISTING IT ACCOUNT PERIOD
								else if(simpleDateFormat.parse(itFrDate).compareTo(simpleDateFormat.parse(itToDate)) < 0)
								{
									int cnt = 0;
									String finEnt = checkNull(genericUtility.getColumnValue("fin_entity", dom));
									String acctPrd = checkNull(genericUtility.getColumnValue("acct_prd", dom));

									String sql = " select count(1) as RowCount from finent_acctprd where fin_entity = ? and acct_prd <> ? and ((it_fr_date <= ? and it_to_date >= ?) or (it_fr_date >= ? and it_to_date <= ?))";
									System.out.println("sql for overlap from_date : " + sql);
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, finEnt);
									pstmt.setString(2, acctPrd);
									pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(itFrDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
									pstmt.setTimestamp(4, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(itFrDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
									pstmt.setTimestamp(5, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(itFrDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
									pstmt.setTimestamp(6, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(itToDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));

									System.out.println("sql for overlap it_fr_date : "	+ sql);

									rs = pstmt.executeQuery();
									System.out.println("fin_entity : " + finEnt);
									System.out.println("fr_date : " + itFrDate);

									if (rs.next()) 
									{
										cnt = rs.getInt("RowCount");
									}

									if (rs != null) 
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null) 
									{
										pstmt.close();
										pstmt = null;
									}

									if (cnt > 0)
									{
										errList.add("VMFENACP13");
										errFields.add(childNodeName.toLowerCase());

										msgType = errorType(conn, "VMFENACP13");
										if (msgType.equalsIgnoreCase("E")) 
										{
											break;
										}
									}
								}
							}
						}
						else if (childNodeName.equalsIgnoreCase("it_to_date")) 
						{
							String itToDate = checkNull(genericUtility.getColumnValue("it_to_date", dom));
							
							if(itToDate != null && itToDate.length() > 0)
							{
								String itFrDate = checkNull(genericUtility.getColumnValue("it_fr_date", dom));
								
								// TO_DATE SHOULD BE GREATER THAN FR_DATE
								if (simpleDateFormat.parse(itFrDate).compareTo(simpleDateFormat.parse(itToDate)) >= 0) 
								{
									errList.add("VMFENACP14");
									errFields.add(childNodeName.toLowerCase());

									msgType = errorType(conn, "VMFENACP14");
									if (msgType.equalsIgnoreCase("E"))
									{
										break;
									}
								}
								
								//IT_TO_DATE SHOULD NOT OVERLAP EXISTING IT ACCOUNT PERIOD
								else
								{
									int cnt = 0;
									String finEnt = checkNull(genericUtility.getColumnValue("fin_entity", dom));
									String acctPrd = checkNull(genericUtility.getColumnValue("acct_prd", dom));
								
									String sql = " select count(1) as RowCount from finent_acctprd where fin_entity = ? and acct_prd <> ? and ((it_fr_date <= ? and it_to_date >= ?) or (it_fr_date >=? and it_to_date <= ?))";
									System.out.println("sql for overlap from_date : " + sql);
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, finEnt);
									pstmt.setString(2, acctPrd);
									pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(itToDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
									pstmt.setTimestamp(4, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(itToDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
									pstmt.setTimestamp(5, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(itFrDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));
									pstmt.setTimestamp(6, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(itToDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat())));

									System.out.println("sql for overlap it_to_date : " + sql);

									rs = pstmt.executeQuery();
									System.out.println("fin_entity : " + finEnt);
									System.out.println("fr_date : " + itToDate);

									if (rs.next()) 
									{
										cnt = rs.getInt("RowCount");
									}

									if (rs != null) 
									{
										rs.close();
										rs = null;
									}
									if (pstmt != null) 
									{
										pstmt.close();
										pstmt = null;
									}

									if (cnt > 0) 
									{
										errList.add("VMFENACP15");
										errFields.add(childNodeName.toLowerCase());

										msgType = errorType(conn, "VMFENACP15");
										if (msgType.equalsIgnoreCase("E")) 
										{
											break;
										}
									}
								}
							}
						}
					}
					break;
				}

				int errListSize = errList.size();
				StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");

				//ERRORLIST
				if (errList != null && errListSize > 0) 
				{
					for (int cnt = 0; cnt < errListSize; cnt++) 
					{
						String errCode = (String) errList.get(cnt);
						String errFldName = (String) errFields.get(cnt);
						System.out.println("errCode .........." + errCode);

						errString = getErrorString(errFldName, errCode, userId);
						System.out.println("errString is : ::::>>>> " + errString);
						msgType = errorType(conn, errCode);
						if (errString.length() > 0)
						{
							String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
							bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							System.out.println("errStringXml .........." + errStringXml);
							errString = "";
						}
						if (msgType.equalsIgnoreCase("E")) 
						{
							break;
						}
					}
					errList.clear();
					errList = null;
					errFields.clear();
					errFields = null;

					errStringXml.append("</Errors></Root>\r\n");
				} 
				else 
				{
					errStringXml = new StringBuffer("");
				}
				errString = errStringXml.toString();
			} 
			
			catch (Exception e) 
			{
				System.out.println("Exception ::" + e);
				e.printStackTrace();
				errString = e.getMessage();
			} 
			finally 
			{
				try 
				{
					if (conn != null) 
					{
						conn.close();
					}
					conn = null;
				} 
				catch (Exception d) 
				{
					d.printStackTrace();
				}
			}
			System.out.println("ErrString ::" + errString);
			return errString;
		}// END OF VALIDATION

	// ITEMCHANGE START
	public String itemChanged() throws RemoteException, ITMException 
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";

		try 
		{
			if (xmlString != null && xmlString.trim().length() != 0) 
			{
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) 
			{
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) 
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		} 
		catch (Exception e) 
		{
			System.out.println("Exception : FinEntAcctPrd : [itemChanged(String,String)] :==>\n" + e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		GenericUtility genericUtility = null;

		Connection conn = null;
		int currentFormNo = 0;

		ResultSet rs = null;
		String finEnt = "", finDescr = "";
		String acctPrd = "", acctDescr = "";
		String frDate = "", toDate = "";
		String itFrDate = "", itToDate = "";
		Date frDateDB = null;
		Date toDateDB = null;
		Date itFrDateDB = null, itToDateDB = null;
		String sql = "";
		String query = "";
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString;
		String loginSiteCode = "";
		String finEntity = "";
		try 
		{
			valueXmlString = new StringBuffer();
			genericUtility = new GenericUtility();
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());

			valueXmlString = new StringBuffer(
					"<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");

			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}

			switch (currentFormNo) 
			{
				case 1:
					valueXmlString.append("<Detail1>");
					if (currentColumn.trim().equalsIgnoreCase("itm_default")) 
					{
						loginSiteCode = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
						if (loginSiteCode != null && loginSiteCode.trim().length() > 0) 
						{
							sql = " select a.fin_entity as fin_entity, b.descr as descr from site a , finent b where a.site_code = ? and b.fin_entity = a.fin_entity ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, loginSiteCode);
							rs = pstmt.executeQuery();
							if (rs.next()) 
							{
								finDescr = rs.getString("descr") == null ? "" : rs.getString("descr");
								finEntity = rs.getString("fin_entity") == null ? "" : rs.getString("fin_entity");
							}
							if (rs != null) 
							{
								rs.close();
								rs = null;
							}
							if (pstmt != null) 
							{
								pstmt.close();
								pstmt = null;
							}
							valueXmlString.append("<fin_entity>").append("<![CDATA[" + finEntity + "]]>").append("</fin_entity>\r\n");
							valueXmlString.append("<finent_descr>").append("<![CDATA[" + finDescr + "]]>").append("</finent_descr>\r\n");
						}
					} 
					else if (currentColumn.trim().equalsIgnoreCase("fin_entity")) 
					{
						finEnt = genericUtility.getColumnValue("fin_entity", dom);
						query = " select descr from finent where fin_entity = ? ";
						pstmt = conn.prepareStatement(query);
						pstmt.setString(1, finEnt);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							finDescr = rs.getString(1) == null ? "" : rs.getString(1);
						}
						if (rs != null) 
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null) 
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<finent_descr>").append("<![CDATA[" + finDescr + "]]>").append("</finent_descr>");
					} 
					else if (currentColumn.trim().equalsIgnoreCase("acct_prd")) 
					{
						int itDateCnt = 0;
						acctPrd = genericUtility.getColumnValue("acct_prd", dom);
						query = " select descr, fr_date, to_date, it_fr_date, it_to_date, case when it_fr_date is not null and it_to_date is not null then 1 else 0 end as itDateCnt from acctprd where code = ? ";
						pstmt = conn.prepareStatement(query);
						pstmt.setString(1, acctPrd);
						rs = pstmt.executeQuery();
						if (rs.next()) 
						{
							acctDescr = rs.getString("descr") == null ? "" : rs.getString("descr");
							frDateDB = rs.getDate("fr_date");
							toDateDB = rs.getDate("to_date");
							itFrDateDB = rs.getDate("it_fr_date");
							itToDateDB = rs.getDate("it_to_date");
							itDateCnt = rs.getInt("itDateCnt");
							frDate = simpleDateFormat.format(frDateDB);
							System.out.println(" from_date :: " + frDate);
							toDate = simpleDateFormat.format(toDateDB);
							System.out.println(" to_date :: " + toDate);
						}
						if (rs != null) 
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null) 
						{
							pstmt.close();
							pstmt = null;
						}
						valueXmlString.append("<descr>").append("<![CDATA[" + acctDescr + "]]>").append("</descr>");
						System.out.println(" from_date :: " + frDate);
						valueXmlString.append("<fr_date>").append("<![CDATA[" + frDate + "]]>").append("</fr_date>");
						System.out.println(" to_date :: " + toDate);
						valueXmlString.append("<to_date>").append("<![CDATA[" + toDate + "]]>").append("</to_date>");
						if(itDateCnt > 0)
						{
							itFrDate = simpleDateFormat.format(itFrDateDB);
							System.out.println(" it_from_date :: " + itFrDate);
							itToDate = simpleDateFormat.format(itToDateDB);
							System.out.println(" it_to_date :: " + itToDate);
							valueXmlString.append("<it_fr_date>").append("<![CDATA[" + itFrDate + "]]>").append("</it_fr_date>");
							valueXmlString.append("<it_to_date protect=\"0\">").append("<![CDATA[" + itToDate + "]]>").append("</it_to_date>");
						}
						else
						{
							valueXmlString.append("<it_fr_date>").append("<![CDATA[" + itFrDate + "]]>").append("</it_fr_date>");
							valueXmlString.append("<it_to_date protect=\"1\">").append("<![CDATA[" + itToDate + "]]>").append("</it_to_date>");
						}
					} 
					else if (currentColumn.trim().equalsIgnoreCase("it_fr_date")) 
					{
						itFrDate = genericUtility.getColumnValue("it_fr_date", dom);
						if (itFrDate != null) 
						{
							itToDate = checkNull(genericUtility.getColumnValue("it_to_date", dom));
							valueXmlString.append("<it_to_date protect=\"0\">").append("<![CDATA[" + itToDate + "]]>").append("</it_to_date>");
						} 
						else 
						{
							valueXmlString.append("<it_to_date protect=\"1\">").append("").append("</it_to_date>");
						}
					}

					valueXmlString.append("</Detail1>");

					break;
				}
				valueXmlString.append("</Root>");
			} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		} 
		finally 
		{
			try 
			{
				if (conn != null)
				{
					conn.close();
					conn = null;
				}
			} catch (Exception e1) 
			{
				e1.printStackTrace();
			}
		}
		System.out.println("valueXmlString:::::" + valueXmlString.toString());
		return valueXmlString.toString();
	}

	// END OF ITEMCHANGE

	private String errorType(Connection conn, String errorCode) throws ITMException 
	{
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try 
		{
			String sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next()) 
			{
				msgType = rs.getString("MSG_TYPE");
			}
		} 
		catch (Exception ex) 
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		finally 
		{
			try 
			{
				if (rs != null) 
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e) 
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}
	
	private String checkNull(String input) 
	{
		if (input == null) 
		{
			input = "";
		} 
		else 
		{
			input = input.trim();
		}
		return input;
	}
}
