<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>
<xsl:template match="/">

<html>

<body>
<script type="text/javascript" src="/ibase/webitm/js/GSTDataSubmitWiz.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/FixedTableHeader.js"></script>
<script language="Javascript" src="/ibase/webitm/js/jquery.datetimepicker.full.js"></script>
<script language="Javascript" src="/ibase/webitm/js/date.js"></script>

<link href="/ibase/webitm/css/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.core.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.widget.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.position.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.menu.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.autocomplete.js"></script>

<link href="/ibase/webitm/css/Galaxy/galaxy-theme.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/Standard/default.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/GSTDataSubmitWiz.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/jquery.datetimepicker.css" rel="stylesheet"/>

<script>
<![CDATA[
	$(function() 
	{
		var acc = document.getElementsByClassName("accordion1");
		var i;
		
		for (i = 0; i < acc.length; i++)
		{
		    acc[i].onclick = function()
		    {
		       	this.classList.toggle("active");
		        this.nextElementSibling.classList.toggle("show");
		  	}
		}
	});
	
	$(function() 
	{
		var acc = document.getElementsByClassName("accordion2");
		var i;
		
		for (i = 0; i < acc.length; i++)
		{
		    acc[i].onclick = function()
		    {
		    	this.classList.toggle("activeAccor");
		       	this.classList.toggle("active");
		        this.nextElementSibling.classList.toggle("show");
		        if(this.nextElementSibling.classList == "panel2")
		        {
		        	this.classList.remove("activeAccor");
		        }
		  	}
		}
	});
	
	$(function() 
	{
		var acc = document.getElementsByClassName("accordion3");
		var i;
		
		for (i = 0; i < acc.length; i++)
		{
		    acc[i].onclick = function()
		    {
		       	this.classList.toggle("active");
		        this.nextElementSibling.classList.toggle("show");
		  	}
		}
	});

	$(function() 
	{
		var panel = document.getElementsByClassName("panel2");

		for (var j = 0; j < panel.length; j++)
		{
			panel[j].onclick = function()
		    {
			    var acc = document.getElementsByClassName("accordion2");
	       		for(var i=0; i<acc.length; i++)
	       		{
	       			acc[i].classList.remove("activeAccor");
	       		}
	       		this.previousElementSibling.classList.add("activeAccor");
		  	}
		}
	});

	$(document).on("keydown", function (e) {
    if (e.which === 8 && !$(e.target).is("input, textarea, form")) {
        e.preventDefault();
    }
    else if(e.which ===13){
    	 e.preventDefault();
    }
});
]]>
</script>

<form name="gstdataSubmitForm2" id="gstdataSubmitForm2" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet">
	<div class="headerDiv">
		<div class="headerText">GSTR3B Data</div>
		<div class="closeIcon" onclick="hidePopupDiv();">X</div>
	</div>
	<div id="mainPageHeaderContatiner">
		<div class="detailPage-input-Container dataContainer">
			<xsl:for-each select="//section">
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
				<xsl:if test="$dbID='1'">
					<span style="height:25px; display:block;color:#5893bf;">1. Details of Outward Supplies and inward supplies liable to reverse charge</span>
					<xsl:choose>
						<xsl:when test='summary_data'>
							<table class="tableClass">
								<thead class="table-head">
									<tr class="titleRow">
										<th nowrap="true" align="left">Nature of Supplies</th>
										<th nowrap="true" align="right">Taxable amount</th>
										<th nowrap="true" align="right">IGST</th>
										<th nowrap="true" align="right">CGST</th>
										<th nowrap="true" align="right">SGST</th>
										<th nowrap="true" align="right">Cess</th>
									</tr>
								</thead>
								<tbody class="table-body data-table">
									<xsl:for-each select="summary_data">
										<tr>
											<td>
												<xsl:variable name="tran_type"><xsl:value-of select="tran_type"/></xsl:variable>
												<xsl:if test="$tran_type='01'">
													Outward taxable supplies (other than zero rated, nil rated and exempted)
												</xsl:if>
												<xsl:if test="$tran_type='02'">
													Outward taxable supplies (zero rated )
												</xsl:if>
												<xsl:if test="$tran_type='03'">
													Other outward supplies (Nil rated, exempted)
												</xsl:if>
												<xsl:if test="$tran_type='04'">
													Inward supplies (liable to reverse charge)
												</xsl:if>
												<xsl:if test="$tran_type='05'">
													 Non-GST outward supplies
												</xsl:if>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="taxable_amt">
														<xsl:value-of select="taxable_amt"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="igst_amt">
														<xsl:value-of select="igst_amt"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="cgst_amt">
														<xsl:value-of select="cgst_amt"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="sgst_amt">
														<xsl:value-of select="sgst_amt"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="cess_amt">
														<xsl:value-of select="cess_amt"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
										</tr>
									</xsl:for-each>
								</tbody>
							</table>
						</xsl:when>
						<xsl:otherwise>
							Outward supplies data not found
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="$dbID='2'">
					<span style="height:25px; display:block;margin-top:15px;color:#5893bf;">2. Details of inter-State supplies made to unregistered persons, composition taxable persons and UIN holders
					</span>
					<xsl:if test="unreg_data/data">
						<span style="height:25px; display:block;margin-left:15px;">2.1 Inter-State supplies made to unregistered persons</span>
						<table class="tableClass">
							<thead class="table-head">
								<tr class="titleRow">
									<th nowrap="true" align="left">Place of supply</th>
									<th nowrap="true" align="right">Taxable amount</th>
									<th nowrap="true" align="right">IGST</th>
									<th nowrap="true" align="right">Cess</th>
								</tr>
							</thead>
							<tbody class="table-body data-table">
								<xsl:for-each select="unreg_data/data">
									<tr>
										<td align="left">
											<xsl:choose>
												<xsl:when test="gst_code">
													<xsl:value-of select="gst_code"/>
												</xsl:when>
												<xsl:otherwise>
													
												</xsl:otherwise>
											</xsl:choose>
											-
											<xsl:choose>
												<xsl:when test="state_descr">
													<xsl:value-of select="state_descr"/>
												</xsl:when>
												<xsl:otherwise>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="taxable_amt">
													<xsl:value-of select="taxable_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="igst_amt">
													<xsl:value-of select="igst_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="cess_amt">
													<xsl:value-of select="cess_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
					</xsl:if>
					<xsl:if test="comp_data/data">
						<span style="height:25px; display:block;margin-top:10px;margin-left:15px;">2.2 Inter-State supplies made to composition taxable persons</span>
						<table class="tableClass">
							<thead class="table-head">
								<tr class="titleRow">
									<th nowrap="true" align="left">Place of supply</th>
									<th nowrap="true" align="right">Taxable amount</th>
									<th nowrap="true" align="right">IGST</th>
									<th nowrap="true" align="right">Cess</th>
								</tr>
							</thead>
							<tbody class="table-body data-table">
								<xsl:for-each select="comp_data/data">
									<tr>
										<td align="left">
											<xsl:choose>
												<xsl:when test="gst_code">
													<xsl:value-of select="gst_code"/>
												</xsl:when>
												<xsl:otherwise>
													
												</xsl:otherwise>
											</xsl:choose>
											-
											<xsl:choose>
												<xsl:when test="state_descr">
													<xsl:value-of select="state_descr"/>
												</xsl:when>
												<xsl:otherwise>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="taxable_amt">
													<xsl:value-of select="taxable_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="igst_amt">
													<xsl:value-of select="igst_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="cess_amt">
													<xsl:value-of select="cess_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
					</xsl:if>
					<xsl:if test="uin_data/data">
						<span style="height:25px; display:block;margin-top:10px;margin-left:15px;">2.3 Inter-State supplies made to composition UIN holders</span>
						<table class="tableClass">
							<thead class="table-head">
								<tr class="titleRow">
									<th nowrap="true" align="left">Place of supply</th>
									<th nowrap="true" align="right">Taxable amount</th>
									<th nowrap="true" align="right">IGST</th>
									<th nowrap="true" align="right">Cess</th>
								</tr>
							</thead>
							<tbody class="table-body data-table">
								<xsl:for-each select="comp_data/data">
									<tr>
										<td align="left">
											<xsl:choose>
												<xsl:when test="gst_code">
													<xsl:value-of select="gst_code"/>
												</xsl:when>
												<xsl:otherwise>
													
												</xsl:otherwise>
											</xsl:choose>
											-
											<xsl:choose>
												<xsl:when test="state_descr">
													<xsl:value-of select="state_descr"/>
												</xsl:when>
												<xsl:otherwise>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="taxable_amt">
													<xsl:value-of select="taxable_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="igst_amt">
													<xsl:value-of select="igst_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="cess_amt">
													<xsl:value-of select="cess_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</xsl:for-each>
							</tbody>
						</table>
					</xsl:if>
				</xsl:if>
				<xsl:if test="$dbID='3'">
					<span style="height:25px; display:block;margin-top:15px;color:#5893bf;">3. Eligible ITC</span>
					<table class="tableClass">
						<thead class="table-head">
							<tr class="titleRow">
								<th nowrap="true" align="left">Details</th>
								<th nowrap="true" align="right">Taxable amount</th>
								<th nowrap="true" align="right">IGST</th>
								<th nowrap="true" align="right">CGST</th>
								<th nowrap="true" align="right">SGST</th>
								<th nowrap="true" align="right">Cess</th>
							</tr>
						</thead>
						<tbody class="table-body data-table">
							<xsl:if test="itc_available">
								<tr>
									<td><b>ITC Available (whether in full or part)</b></td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
								</tr>
								<xsl:for-each select="itc_available">
									<tr>
										<td align="left">
											<xsl:variable name="tran_type"><xsl:value-of select="tran_type"/></xsl:variable>
											<xsl:if test="$tran_type='09'">
												Import of goods
											</xsl:if>
											<xsl:if test="$tran_type='10'">
												Import of services
											</xsl:if>
											<xsl:if test="$tran_type='11'">
												Inward supplies liable to reverse charge
											</xsl:if>
											<xsl:if test="$tran_type='12'">
												Inward supplies from ISD
											</xsl:if>
											<xsl:if test="$tran_type='13'">
												As per rule
											</xsl:if>
											<xsl:if test="$tran_type='14'">
												All other ITC
											</xsl:if>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="taxable_amt">
													<xsl:value-of select="taxable_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="igst_amt">
													<xsl:value-of select="igst_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="cgst_amt">
													<xsl:value-of select="cgst_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="sgst_amt">
													<xsl:value-of select="sgst_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="cess_amt">
													<xsl:value-of select="cess_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</xsl:for-each>
							</xsl:if>
							<xsl:if test="itc_reversed">
								<tr>
									<td><b>ITC Reversed</b></td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
								</tr>
								<xsl:for-each select="itc_reversed">
									<tr>
										<td align="left">
											<xsl:variable name="tran_type"><xsl:value-of select="tran_type"/></xsl:variable>
											<xsl:if test="$tran_type='15'">
												Import of goods
											</xsl:if>
											<xsl:if test="$tran_type='16'">
												Import of services
											</xsl:if>
											<xsl:if test="$tran_type='17'">
												Inward supplies liable to reverse charge
											</xsl:if>
											<xsl:if test="$tran_type='18'">
												Inward supplies from ISD
											</xsl:if>
											<xsl:if test="$tran_type='19'">
												As per rule
											</xsl:if>
											<xsl:if test="$tran_type='20'">
												All other ITC
											</xsl:if>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="taxable_amt">
													<xsl:value-of select="taxable_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="igst_amt">
													<xsl:value-of select="igst_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="cgst_amt">
													<xsl:value-of select="cgst_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="sgst_amt">
													<xsl:value-of select="sgst_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="cess_amt">
													<xsl:value-of select="cess_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</xsl:for-each>
							</xsl:if>
							<xsl:if test="itc_net">
								<xsl:for-each select="itc_net">
									<tr>
										<td><b>Net ITC Available</b></td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="taxable_amt">
													<xsl:value-of select="taxable_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="igst_amt">
													<xsl:value-of select="igst_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="cgst_amt">
													<xsl:value-of select="cgst_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="sgst_amt">
													<xsl:value-of select="sgst_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="cess_amt">
													<xsl:value-of select="cess_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</xsl:for-each>
							</xsl:if>
							<xsl:if test="itc_ineligible">
								<tr>
									<td><b>Ineligible ITC</b></td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
									<td></td>
								</tr>
								<xsl:for-each select="itc_ineligible">
									<tr>
										<td>
											<xsl:variable name="tran_type"><xsl:value-of select="tran_type"/></xsl:variable>
											<xsl:if test="$tran_type='22'">
												Import of goods
											</xsl:if>
											<xsl:if test="$tran_type='23'">
												Import of services
											</xsl:if>
											<xsl:if test="$tran_type='24'">
												Inward supplies liable to reverse charge
											</xsl:if>
											<xsl:if test="$tran_type='25'">
												Inward supplies from ISD
											</xsl:if>
											<xsl:if test="$tran_type='26'">
												As per rule
											</xsl:if>
											<xsl:if test="$tran_type='27'">
												All other ITC
											</xsl:if>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="taxable_amt">
													<xsl:value-of select="taxable_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="igst_amt">
													<xsl:value-of select="igst_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="cgst_amt">
													<xsl:value-of select="cgst_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="sgst_amt">
													<xsl:value-of select="sgst_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<td align="right">
											<xsl:choose>
												<xsl:when test="cess_amt">
													<xsl:value-of select="cess_amt"/>
												</xsl:when>
												<xsl:otherwise>
													0
												</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
								</xsl:for-each>
							</xsl:if>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="$dbID='4'">
					<span style="height:25px; display:block;margin-top:15px;color:#5893bf;">4. Values of exempt, nil-rated and non-GST inward supplies</span>
					<table class="tableClass">
						<thead class="table-head">
							<tr class="titleRow">
								<th nowrap="true" align="left">Nature of Supplies</th>
								<th nowrap="true" align="right">Inter-State value</th>
								<th nowrap="true" align="right">Intra-State value</th>
							</tr>
						</thead>
						<tbody class="table-body data-table">
							<xsl:for-each select="gst_data">
								<tr>
									<td>From a supplier under composition scheme, Exempt and Nil rated supplies</td>
									<td align="right">
										<xsl:choose>
											<xsl:when test="gst_data/inter">
												<xsl:value-of select="gst_data/inter"/>
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td align="right">
										<xsl:choose>
											<xsl:when test="gst_data/intra">
												<xsl:value-of select="gst_data/intra"/>
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</td>
								</tr>
							</xsl:for-each>
							<xsl:for-each select="non_gst_data">
								<tr>
									<td>Non GST supplies</td>
									<td align="right">
										<xsl:choose>
											<xsl:when test="non_gst_data/inter">
												<xsl:value-of select="gst_data/inter"/>
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</td>
									<td align="right">
										<xsl:choose>
											<xsl:when test="non_gst_data/intra">
												<xsl:value-of select="gst_data/intra"/>
											</xsl:when>
											<xsl:otherwise>
												0
											</xsl:otherwise>
										</xsl:choose>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</xsl:if>
				<xsl:if test="$dbID='5'">
					<span style="height:25px; display:block;margin-top:15px;color:#5893bf;">5. Interest and late fee</span>
					<xsl:choose>
						<xsl:when test='interest_latefee'>
							<table class="tableClass">
								<thead class="table-head">
									<tr class="titleRow">
										<th nowrap="true" align="left">Description</th>
										<th nowrap="true" align="right">IGST</th>
										<th nowrap="true" align="right">CGST</th>
										<th nowrap="true" align="right">SGST</th>
										<th nowrap="true" align="right">Cess</th>
									</tr>
								</thead>
								<tbody class="table-body data-table">
									<xsl:for-each select="interest_latefee">
										<tr>
											<td>Interest and late fee</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="igst_amt">
														<xsl:value-of select="igst_amt"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="cgst_amt">
														<xsl:value-of select="cgst_amt"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="sgst_amt">
														<xsl:value-of select="sgst_amt"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
											<td align="right">
												<xsl:choose>
													<xsl:when test="cess_amt">
														<xsl:value-of select="cess_amt"/>
													</xsl:when>
													<xsl:otherwise>
														0
													</xsl:otherwise>
												</xsl:choose>
											</td>
										</tr>
									</xsl:for-each>
								</tbody>
							</table>
						</xsl:when>
						<xsl:otherwise>
							Interest and late fee data not found.
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
			</xsl:for-each>
		</div>
	</div>
	<div id="buttonreplacement">
		<img src="/ibase/images/preload.gif" alt="Please wait" ></img>
		<span>Please wait......</span>
	</div>
</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
