package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.ITCData;
import ibase.webitm.bean.gst.ITCEligibilty;

public class ITCEligibiltySerailizer extends JsonSerializer<ITCEligibilty>
{
	@Override
	public void serialize(ITCEligibilty itcEligiblity, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
	{
		if(itcEligiblity != null)
		{
			json.writeStartObject();
			
			if(itcEligiblity.itcAvailable != null)
			{
				json.writeFieldName("itc_avl");
				json.writeStartArray();
				for(ITCData eachData : itcEligiblity.itcAvailable)
				{
					json.writeStartObject();
					json.writeStringField("ty", eachData.type);
					json.writeNumberField("iamt", eachData.igstAmount);
					json.writeNumberField("camt", eachData.cgstAmount);
					json.writeNumberField("samt", eachData.sgstAmount);
					json.writeNumberField("csamt", eachData.cessAmount);
					json.writeEndObject();
				}
				json.writeEndArray();
			}
			if(itcEligiblity.itcReversed != null)
			{
				json.writeFieldName("itc_rev");
				json.writeStartArray();
				for(ITCData eachData : itcEligiblity.itcReversed)
				{
					json.writeStartObject();
					json.writeStringField("ty", eachData.type);
					json.writeNumberField("iamt", eachData.igstAmount);
					json.writeNumberField("camt", eachData.cgstAmount);
					json.writeNumberField("samt", eachData.sgstAmount);
					json.writeNumberField("csamt", eachData.cessAmount);
					json.writeEndObject();
				}
				json.writeEndArray();
			}
			if(itcEligiblity.netITCAvailable != null)
			{
				json.writeFieldName("itc_net");
				json.writeStartObject();
				json.writeNumberField("iamt", itcEligiblity.netITCAvailable.igstAmount);
				json.writeNumberField("camt", itcEligiblity.netITCAvailable.cgstAmount);
				json.writeNumberField("samt", itcEligiblity.netITCAvailable.sgstAmount);
				json.writeNumberField("csamt", itcEligiblity.netITCAvailable.cessAmount);
				json.writeEndObject();
			}
			if(itcEligiblity.itcIneligible != null)
			{
				json.writeFieldName("itc_inelg");
				json.writeStartArray();
				for(ITCData eachData : itcEligiblity.itcIneligible)
				{
					json.writeStartObject();
					json.writeStringField("ty", eachData.type);
					json.writeNumberField("iamt", eachData.igstAmount);
					json.writeNumberField("camt", eachData.cgstAmount);
					json.writeNumberField("samt", eachData.sgstAmount);
					json.writeNumberField("csamt", eachData.cessAmount);
					json.writeEndObject();
				}
				json.writeEndArray();
			}
			
			json.writeEndObject();
		}
	}
}
