

/********************************************************
	Title : GenerateReceiptIC
	Date  : 19/07/12
	Developer: Kunal Mandhre

 ********************************************************/

package ibase.webitm.ejb.fin;
import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.text.SimpleDateFormat;
import java.util.*;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.ejb.Stateless; 
@Stateless 

public class GenerateReceiptIC extends ValidatorEJB implements GenerateReceiptICLocal, GenerateReceiptICRemote
{
//	GenericUtility genericUtility = GenericUtility.getInstance();
	E12GenericUtility genericUtility = new E12GenericUtility();

	//	method for item change
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		System.out.println("xmlString............."+xmlString);
		System.out.println("xmlString1............"+xmlString);
		System.out.println("xmlString2............"+xmlString);
		try
		{   
			if(xmlString != null && xmlString.trim().length() > 0)
			{
				dom = parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length() > 0)
			{
				dom1 = parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length() > 0)
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [GenerateReceiptIC][itemChanged( String, String )] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return valueXmlString;
	}

	// method for item change
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String bankCode = "",loginSite = "",custCodeFrom = "",custCodeTo = "",tranType = "";
		String chequeDate = "",chequeAmt = "",custBlank = "",chequeNo = "",udfStr2 = "";
		String defaultBankCode = "",defaultTranType = "",defaultRemarks = "";
		String childNodeName = null;
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer();
		int ctr = 0;
		int currentFormNo = 0;
		int childNodeListLength = 0;
		SimpleDateFormat simpleDateFormat1 = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
//		GenericUtility genericUtility = GenericUtility.getInstance();
		ConnDriver connDriver = new ConnDriver();
		FinCommon finCommon = new FinCommon();
		try
		{   
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			simpleDateFormat1 = new SimpleDateFormat(genericUtility.getApplDateFormat());
			//Changes and Commented By Bhushan on 06-06-2016 :START
//conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			conn.setAutoCommit(false);
			connDriver = null;
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");
			switch(currentFormNo)
			{

			case 1 : 
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail1>");
				childNodeListLength = childNodeList.getLength();
				do
				{   
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					ctr ++;
				}while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));
				
				if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					chequeDate  = checkNull(genericUtility.getColumnValue("cheque_date", dom));
					custBlank  = checkNull(genericUtility.getColumnValue("cust_bank_ref", dom));
					valueXmlString.append("<site_code>").append("<![CDATA[" + loginSite +"]]>").append("</site_code>");
					valueXmlString.append("<cheque_no protect='0'>").append("<![CDATA[  ]]>").append("</cheque_no>");
					valueXmlString.append("<cust_code__from>").append("<![CDATA[00]]>").append("</cust_code__from>");
					valueXmlString.append("<cust_code__to>").append("<![CDATA[ZZ]]>").append("</cust_code__to>");
					valueXmlString.append("<due_date>").append("<![CDATA[" + simpleDateFormat1.format(new Date()) +"]]>").append("</due_date>");
					valueXmlString.append("<due_date_to>").append("<![CDATA[" + simpleDateFormat1.format(new Date()) +"]]>").append("</due_date_to>");
					valueXmlString.append("<cheque_date protect='1'>").append("<![CDATA["+chequeDate+"]]>").append("</cheque_date>");
					valueXmlString.append("<cheque_amount protect='1'>").append("<![CDATA[]]>").append("</cheque_amount>");
					valueXmlString.append("<cust_bank_ref protect='1'>").append("<![CDATA["+custBlank+"]]>").append("</cust_bank_ref>");
					
					sql = "select bank_code from site where site_code = ? ";
					pstmt =  conn.prepareStatement(sql);
					pstmt.setString(1,loginSite);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						bankCode = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					//added by kunal on 8/03/13 set default value  
					defaultBankCode = checkNull(finCommon.getFinparams("999999", "DEFAULT_BANKCODE", conn));
					System.out.println("defaultBankCode="+defaultBankCode);
					if(defaultBankCode == null || defaultBankCode.trim().length() == 0 || defaultBankCode.trim().equalsIgnoreCase("NULLFOUND"))
					{
						defaultBankCode = "";
					}
					
					defaultRemarks = checkNull(finCommon.getFinparams("999999", "DEFAULT_REMARKS", conn));
					if(defaultRemarks == null || defaultRemarks.trim().length() == 0 || defaultRemarks.trim().equalsIgnoreCase("NULLFOUND"))
					{
						defaultRemarks = "";
					}
					defaultTranType = checkNull(finCommon.getFinparams("999999", "DEFAULT_TRANTYPE", conn));
					if(defaultTranType == null || defaultTranType.trim().length() == 0 || defaultTranType.trim().equalsIgnoreCase("NULLFOUND"))
					{
						defaultTranType = "";
					}
					
					if(defaultBankCode != null && defaultBankCode.trim().length() > 0)
					{
						valueXmlString.append("<bank_code>").append("<![CDATA["+defaultBankCode+"]]>").append("</bank_code>");
					}
					else
					{
						valueXmlString.append("<bank_code>").append("<![CDATA["+bankCode+"]]>").append("</bank_code>");
					}
					valueXmlString.append("<remarks>").append("<![CDATA["+defaultRemarks+"]]>").append("</remarks>");
					valueXmlString.append("<cheque_no>").append("<![CDATA["+defaultRemarks+"]]>").append("</cheque_no>");
					valueXmlString.append("<tran_type>").append("<![CDATA["+defaultTranType+"]]>").append("</tran_type>");
					//added by kunal on 8/03/13 set default value end
					

				}
				else if(currentColumn.trim().equalsIgnoreCase("cust_code__from"))
				{
					tranType  = checkNull(genericUtility.getColumnValue("tran_type", dom));
					custCodeFrom  = checkNull(genericUtility.getColumnValue("cust_code__from", dom));
					//Manoj dtd 27/11/2012 to set Default from value to CustCode to
					//custCodeTo  = checkNull(genericUtility.getColumnValue("cust_code__to", dom));
					custCodeTo=custCodeFrom;
					chequeNo  = checkNull(genericUtility.getColumnValue("cheque_no", dom));
					chequeDate  = checkNull(genericUtility.getColumnValue("cheque_date", dom));
					chequeAmt  = checkNull(genericUtility.getColumnValue("cheque_amount", dom));
					custBlank  = checkNull(genericUtility.getColumnValue("cust_bank_ref", dom));
					System.out.println("cust code frm ="+custCodeFrom);
					System.out.println("cust code to ="+custCodeTo);
					if(!custCodeFrom.trim().equalsIgnoreCase(custCodeTo.trim()))
					{
						valueXmlString.append("<cheque_no protect='1'>").append("<![CDATA[]]>").append("</cheque_no>");
						valueXmlString.append("<cheque_date protect='1'>").append("<![CDATA[]]>").append("</cheque_date>");
						valueXmlString.append("<cheque_amount protect='1'>").append("<![CDATA[]]>").append("</cheque_amount>");
						valueXmlString.append("<cust_bank_ref protect='1'>").append("<![CDATA[]]>").append("</cust_bank_ref>");
					}
					else
					{
						valueXmlString.append("<cheque_no protect='0'>").append("<![CDATA["+chequeNo+"]]>").append("</cheque_no>");
						valueXmlString.append("<cheque_date protect='0'>").append("<![CDATA["+chequeDate+"]]>").append("</cheque_date>");
						valueXmlString.append("<cheque_amount protect='0'>").append("<![CDATA["+chequeAmt+"]]>").append("</cheque_amount>");
						valueXmlString.append("<cust_bank_ref protect='0'>").append("<![CDATA["+custBlank+"]]>").append("</cust_bank_ref>");
						valueXmlString.append("<cust_code__to protect='0'>").append("<![CDATA["+custCodeTo+"]]>").append("</cust_code__to>");
					}
					//valueXmlString.append("<cust_code__from>").append("<![CDATA["+custCode+"]]>").append("</cust_code__from>");
					//valueXmlString.append("<cust_code__to>").append("<![CDATA["+custCode+"]]>").append("</cust_code__to>");
					sql = "select udf_str1,udf_str2 from gencodes where mod_name = 'W_RECEIPT_ADV' and fld_name = 'TRAN_TYPE' and fld_value = ?";
					pstmt =  conn.prepareStatement(sql);
					pstmt.setString(1,tranType);
					rs = pstmt.executeQuery();
					if(rs.next())
					{

						bankCode = rs.getString("udf_str1");
						udfStr2 = rs.getString("udf_str2") == null? " ":rs.getString("udf_str2");

					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					System.out.println("bank code = "+bankCode);
					if(bankCode == null || bankCode.trim().length() == 0)
					{
						sql = "select bank_code from site where site_code = ? ";
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1,loginSite);
						rs = pstmt.executeQuery();
						if(rs.next())
						{

							bankCode = rs.getString(1);

						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

					}
					
					valueXmlString.append("<bank_code>").append("<![CDATA[" + bankCode +"]]>").append("</bank_code>");
					System.out.println("udfStr2 = "+udfStr2);
					System.out.println(" bankcode   = "+bankCode);
					//bankCode  = checkNull(genericUtility.getColumnValue("bank_code", dom));
					if("J".equalsIgnoreCase(udfStr2.trim()))
					{
						valueXmlString.append("<bank_code protect='1'>").append("<![CDATA[" + bankCode +"]]>").append("</bank_code>");
						valueXmlString.append("<cheque_no protect='1'>").append("<![CDATA["+chequeNo+"]]>").append("</cheque_no>");
						valueXmlString.append("<cheque_date protect='1'>").append("<![CDATA["+chequeDate+"]]>").append("</cheque_date>");
						valueXmlString.append("<cust_bank_ref protect='1'>").append("<![CDATA["+custBlank+"]]>").append("</cust_bank_ref>");
						valueXmlString.append("<cheque_amount>").append("<![CDATA[0]]>").append("</cheque_amount>");
					}
					/*else
					{
						valueXmlString.append("<bank_code protect='0'>").append("<![CDATA[" + bankCode +"]]>").append("</bank_code>");
						valueXmlString.append("<cheque_no protect='0'>").append("<![CDATA["+chequeNo+"]]>").append("</cheque_no>");
						valueXmlString.append("<cheque_date protect='0'>").append("<![CDATA["+chequeDate+"]]>").append("</cheque_date>");
						valueXmlString.append("<cust_bank_ref protect='0'>").append("<![CDATA["+custBlank+"]]>").append("</cust_bank_ref>");
						valueXmlString.append("<cheque_amount protect='0'>").append("<![CDATA["+chequeAmt+"]]>").append("</cheque_amount>");
					}*/

					
					
				}
				else if(currentColumn.trim().equalsIgnoreCase("cust_code__to"))
				{
					System.out.println("Inside cust code to");
					tranType  = checkNull(genericUtility.getColumnValue("tran_type", dom));
					custCodeFrom  = checkNull(genericUtility.getColumnValue("cust_code__from", dom));
					custCodeTo  = checkNull(genericUtility.getColumnValue("cust_code__to", dom));
					chequeNo  = checkNull(genericUtility.getColumnValue("cheque_no", dom));
					chequeDate  = checkNull(genericUtility.getColumnValue("cheque_date", dom));
					chequeAmt  = checkNull(genericUtility.getColumnValue("cheque_amount", dom));
					custBlank  = checkNull(genericUtility.getColumnValue("cust_bank_ref", dom));
					System.out.println("cust code frm ="+custCodeFrom);
					System.out.println("cust code to ="+custCodeTo);
					if(!custCodeFrom.trim().equalsIgnoreCase(custCodeTo.trim()))
					{
						valueXmlString.append("<cheque_no protect='1'>").append("<![CDATA["+chequeNo+"]]>").append("</cheque_no>");
						valueXmlString.append("<cheque_date protect='1'>").append("<![CDATA["+chequeDate+"]]>").append("</cheque_date>");
						valueXmlString.append("<cheque_amount protect='1'>").append("<![CDATA[]]>").append("</cheque_amount>");
						valueXmlString.append("<cust_bank_ref protect='1'>").append("<![CDATA["+custBlank+"]]>").append("</cust_bank_ref>");
					}
					else
					{
						valueXmlString.append("<cheque_no protect='0'>").append("<![CDATA["+chequeNo+"]]>").append("</cheque_no>");
						valueXmlString.append("<cheque_date protect='0'>").append("<![CDATA["+chequeDate+"]]>").append("</cheque_date>");
						valueXmlString.append("<cheque_amount protect='0'>").append("<![CDATA["+chequeAmt+"]]>").append("</cheque_amount>");
						valueXmlString.append("<cust_bank_ref protect='0'>").append("<![CDATA["+custBlank+"]]>").append("</cust_bank_ref>");
					}
					sql = "select udf_str1,udf_str2 from gencodes where mod_name = 'W_RECEIPT_ADV' and fld_name = 'TRAN_TYPE' and fld_value = ?";
					pstmt =  conn.prepareStatement(sql);
					pstmt.setString(1,tranType);
					rs = pstmt.executeQuery();
					if(rs.next())
					{

						bankCode = rs.getString("udf_str1");
						udfStr2 = rs.getString("udf_str2") == null? " ":rs.getString("udf_str2");

					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					System.out.println("bank code = "+bankCode);
					if(bankCode == null || bankCode.trim().length() == 0)
					{
						sql = "select bank_code from site where site_code = ? ";
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1,loginSite);
						rs = pstmt.executeQuery();
						if(rs.next())
						{

							bankCode = rs.getString(1);

						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

					}
					
					valueXmlString.append("<bank_code>").append("<![CDATA[" + bankCode +"]]>").append("</bank_code>");
					System.out.println("udfStr2 = "+udfStr2);
					System.out.println("233 bankcode   = "+bankCode);
					//bankCode  = checkNull(genericUtility.getColumnValue("bank_code", dom));
					if("J".equalsIgnoreCase(udfStr2.trim()))
					{
						valueXmlString.append("<bank_code protect='1'>").append("<![CDATA[" + bankCode +"]]>").append("</bank_code>");
						valueXmlString.append("<cheque_no protect='1'>").append("<![CDATA["+chequeNo+"]]>").append("</cheque_no>");
						valueXmlString.append("<cheque_date protect='1'>").append("<![CDATA["+chequeDate+"]]>").append("</cheque_date>");
						valueXmlString.append("<cust_bank_ref protect='1'>").append("<![CDATA["+custBlank+"]]>").append("</cust_bank_ref>");
						valueXmlString.append("<cheque_amount>").append("<![CDATA[0]]>").append("</cheque_amount>");
					}
					/*else
					{
						valueXmlString.append("<bank_code protect='0'>").append("<![CDATA[" + bankCode +"]]>").append("</bank_code>");
						valueXmlString.append("<cheque_no protect='0'>").append("<![CDATA["+chequeNo+"]]>").append("</cheque_no>");
						valueXmlString.append("<cheque_date protect='0'>").append("<![CDATA["+chequeDate+"]]>").append("</cheque_date>");
						valueXmlString.append("<cust_bank_ref protect='0'>").append("<![CDATA["+custBlank+"]]>").append("</cust_bank_ref>");
						valueXmlString.append("<cheque_amount protect='0'>").append("<![CDATA["+chequeAmt+"]]>").append("</cheque_amount>");
					}*/

					
				}
				else if(currentColumn.trim().equalsIgnoreCase("tran_type"))
				{
					tranType  = checkNull(genericUtility.getColumnValue("tran_type", dom));
					chequeNo  = checkNull(genericUtility.getColumnValue("cheque_no", dom));
					chequeDate  = checkNull(genericUtility.getColumnValue("cheque_date", dom));
					chequeAmt  = checkNull(genericUtility.getColumnValue("cheque_amount", dom));
					custBlank  = checkNull(genericUtility.getColumnValue("cust_bank_ref", dom));
					custCodeFrom  = checkNull(genericUtility.getColumnValue("cust_code__from", dom));
					custCodeTo  = checkNull(genericUtility.getColumnValue("cust_code__to", dom));
					sql = "select udf_str1,udf_str2 from gencodes where mod_name = 'W_RECEIPT_ADV' and fld_name = 'TRAN_TYPE' and fld_value = ?";
					pstmt =  conn.prepareStatement(sql);
					pstmt.setString(1,tranType);
					rs = pstmt.executeQuery();
					if(rs.next())
					{

						bankCode = rs.getString("udf_str1");
						udfStr2 = rs.getString("udf_str2") == null? " ":rs.getString("udf_str2");

					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					System.out.println("bank code = "+bankCode);
					if(bankCode == null || bankCode.trim().length() == 0)
					{
						sql = "select bank_code from site where site_code = ? ";
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1,loginSite);
						rs = pstmt.executeQuery();
						if(rs.next())
						{

							bankCode = rs.getString(1);

						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

					}
					
					valueXmlString.append("<bank_code>").append("<![CDATA[" + bankCode +"]]>").append("</bank_code>");
					System.out.println("udfStr2 = "+udfStr2);
					System.out.println("233 bankcode   = "+bankCode);
					//bankCode  = checkNull(genericUtility.getColumnValue("bank_code", dom));
					if("J".equalsIgnoreCase(udfStr2.trim()))
					{
						valueXmlString.append("<bank_code protect='1'>").append("<![CDATA[" + bankCode +"]]>").append("</bank_code>");
						valueXmlString.append("<cheque_no protect='1'>").append("<![CDATA["+chequeNo+"]]>").append("</cheque_no>");
						valueXmlString.append("<cheque_date protect='1'>").append("<![CDATA["+chequeDate+"]]>").append("</cheque_date>");
						valueXmlString.append("<cust_bank_ref protect='1'>").append("<![CDATA["+custBlank+"]]>").append("</cust_bank_ref>");
						valueXmlString.append("<cheque_amount>").append("<![CDATA[0]]>").append("</cheque_amount>");
					}
					else
					{
						valueXmlString.append("<bank_code protect='0'>").append("<![CDATA[" + bankCode +"]]>").append("</bank_code>");
						valueXmlString.append("<cheque_no protect='0'>").append("<![CDATA["+chequeNo+"]]>").append("</cheque_no>");
						valueXmlString.append("<cheque_date protect='0'>").append("<![CDATA["+chequeDate+"]]>").append("</cheque_date>");
						valueXmlString.append("<cust_bank_ref protect='0'>").append("<![CDATA["+custBlank+"]]>").append("</cust_bank_ref>");
						valueXmlString.append("<cheque_amount protect='0'>").append("<![CDATA["+chequeAmt+"]]>").append("</cheque_amount>");
					}
					System.out.println("check for code code to and from ...");
					System.out.println("cust code frm ="+custCodeFrom);
					System.out.println("cust code to ="+custCodeTo);
					if(!custCodeFrom.trim().equalsIgnoreCase(custCodeTo.trim()))
					{
						valueXmlString.append("<cheque_no protect='1'>").append("<![CDATA["+chequeNo+"]]>").append("</cheque_no>");
						valueXmlString.append("<cheque_date protect='1'>").append("<![CDATA["+chequeDate+"]]>").append("</cheque_date>");
						valueXmlString.append("<cheque_amount protect='1'>").append("<![CDATA[]]>").append("</cheque_amount>");
						valueXmlString.append("<cust_bank_ref protect='1'>").append("<![CDATA["+custBlank+"]]>").append("</cust_bank_ref>");
					}
					/*else
					{
						valueXmlString.append("<cheque_no protect='0'>").append("<![CDATA["+chequeNo+"]]>").append("</cheque_no>");
						valueXmlString.append("<cheque_date protect='0'>").append("<![CDATA["+chequeDate+"]]>").append("</cheque_date>");
						valueXmlString.append("<cheque_amount protect='0'>").append("<![CDATA["+chequeAmt+"]]>").append("</cheque_amount>");
						valueXmlString.append("<cust_bank_ref protect='0'>").append("<![CDATA["+custBlank+"]]>").append("</cust_bank_ref>");
					}*/

				}
				valueXmlString.append("</Detail1>");
				break; 
			}
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(rs != null) 
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null) 
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;	
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}			
		}
		return valueXmlString.toString();
	}
	private String checkNull(String input) 
	{
		if(input == null)
		{
			input = "";
		}
		return input;
	}

}	