package ibase.webitm.ejb.dis;
import org.w3c.dom.Document;

import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

import javax.ejb.Stateless;

@Stateless
public class SaleOrderPostSave extends ValidatorEJB implements SaleOrderPostSaveLocal,SaleOrderPostSaveRemote {
	public String postSave(String xmlString,String tranId,String editFlag, String xtraParams,Connection conn) throws RemoteException,ITMException
	{

		System.out.println("------------ postSave method called-----------------SaleOrderPostSave : ");
		System.out.println("tranId111--->>["+tranId+"]");
		System.out.println("xml String--->>["+xmlString+"]");
		Document dom = null;
		String errString="";
		
		try
		{
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = parseString(xmlString);				
				errString = postSave(dom,tranId,xtraParams,conn);
			}
			
		}
		catch(Exception e)
		{
			System.out.println("Exception : SaleOrderPostSave.java : postSave : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}		
		return errString;
	}
	
	
	public String postSave(Document dom,String tranId,String xtraParams,Connection conn)
	{
		System.out.println("in SaleOrderPostSave postSave tran_id---->>["+tranId+"]");
		ResultSet rs=null,rs1=null;
		PreparedStatement pstmt=null,pstmt1=null;
		String sql="",sql1="",errorString="";
		double quantityStduom = 0,rateStduom=0,discount=0,taxAmt=0,netAmt=0,taxAmtH=0,totAmtH=0,
				ordAmtH=0,ordValueH=0,ordValue=0,totOrdValueH=0;
		int count=0,lineNo=0;
		try{
			GenericUtility genericUtility = GenericUtility.getInstance();	

			tranId = GenericUtility.getInstance().getColumnValue("sale_order",dom);
			System.out.println("sale_order--->>["+tranId+"]");
			sql="select quantity__stduom,rate__stduom,discount,tax_amt,line_no,ord_value "
					+ "from sorddet where sale_order = ?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs=pstmt.executeQuery();
			while(rs.next()){
				quantityStduom=rs.getDouble(1);
				rateStduom=rs.getDouble(2);
				discount=rs.getDouble(3);
				taxAmt=rs.getDouble(4);
				lineNo=rs.getInt(5);
				ordValue=rs.getDouble(6);
				System.out.println("quantityStduom-->["+quantityStduom+"]");
				System.out.println("rateStduom-->["+rateStduom+"]taxAmt-->["+taxAmt+"]");
				System.out.println("discount-->["+discount+"] lineNo-->["+lineNo+"]");
				
				netAmt=(quantityStduom*rateStduom)-((quantityStduom*rateStduom*discount)/100)+taxAmt;
				System.out.println("NetAmt--->>["+netAmt+"]");
				
				
				sql1="update sorddet set net_amt = ? where sale_order = ? and line_no = ?";
				pstmt1=conn.prepareStatement(sql1);
				pstmt1.setDouble(1, netAmt);
				pstmt1.setString(2, tranId);
				pstmt1.setInt(3, lineNo);
				count=pstmt1.executeUpdate();
				if (pstmt1 != null){
		    	pstmt1.close();
				pstmt1=null;
			    }
				
				taxAmtH=taxAmtH + taxAmt;
				totAmtH=totAmtH + netAmt;
				
				totOrdValueH=totOrdValueH + ordValue;
				
				
			} //end while
			if (pstmt != null){
	    	pstmt.close();
			pstmt=null;
		    }
			if (rs !=null){
			rs.close();
			rs=null;
			}
			ordAmtH=totAmtH - taxAmtH;
			System.out.println("pre count---->>["+count+"]");
			System.out.println("taxAmtH-->["+taxAmtH+"] totAmtH-->["+totAmtH+"]");
			System.out.println("ordAmtH-->["+ordAmtH+"] totOrdValueH-->["+totOrdValueH+"]");
			if(count >0){
			sql="update sorder set tax_amt = ? ,tot_amt= ? ,ord_amt = ?,tot_ord_value= ? where sale_order = ?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setDouble(1, taxAmtH);
			pstmt.setDouble(2, totAmtH);
			pstmt.setDouble(3, ordAmtH);
			pstmt.setDouble(4, totOrdValueH);	
			pstmt.setString(5, tranId);
			count=pstmt.executeUpdate();
			System.out.println("post count---->>["+count+"]");
			if(count >0 ){
				conn.commit();
			}
			}else{
				conn.rollback();
			}
			
		}
		catch(Exception e){
			System.out.println("Exception : SaleOrderPostSave -->["+e.getMessage()+"]");
			e.printStackTrace();
			try{
			conn.rollback();
			}catch(Exception e1){
				System.out.println("Exception while rollbacking transaction....");
				e1.printStackTrace();
			}
		}
		return errorString;
	}
}
