
/**
 *  PURPOSE  : DefaultItemChanged for Fright Updation process
 *  AUTHOR   : Samadhan On 21/04/2015  
 *  Obj_name : w_fright_upd
 *  Request Id:  D15AKAT011
 */

package ibase.webitm.ejb.wms;


import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.w3c.dom.Document;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

@javax.ejb.Stateless
public class FrightUpdIC extends ValidatorEJB implements FrightUpdICRemote, FrightUpdICLocal
{

	/**
	 * The method defined with no parameter and returns nothing
	 */
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}


	public String itemChanged(String currXmlDataStr, String hdrXmlDataStr, String allXmlDataStr, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			if (currXmlDataStr != null && currXmlDataStr.trim().length()!=0)
			{
				currDom = genericUtility.parseString(currXmlDataStr); 
			}
			if (hdrXmlDataStr != null && hdrXmlDataStr.trim().length()!=0)
			{
				hdrDom = genericUtility.parseString(hdrXmlDataStr); 
			}
			if (allXmlDataStr != null && allXmlDataStr.trim().length()!=0)
			{
				allDom = genericUtility.parseString(allXmlDataStr); 
			}
			errString = defaultItemChanged( currDom, hdrDom, allDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :FrightUpdIC :itemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from FrightUpdIC itemChanged" );
		return errString;
	}


	public String defaultItemChanged( Document currDom, Document hdrDom, Document allDom, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{	
		String siteCode = "";
		String errString = "";
		String suppCode = "";
		int currentFormNo = 0;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n" );
		E12GenericUtility genericUtility = new E12GenericUtility();

		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver(); 
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			
			siteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			System.out.println("site code ->["+siteCode+"]");
			System.out.println("Current Column> > > > ->["+currentColumn+"]");
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}

			valueXmlString.append("</Header>\r\n" );

			switch ( currentFormNo )
			{
			case 1:
			{
				if(currentColumn.trim()!=null)
				{
					if ( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						System.out.println("--------------item default --------------");
						valueXmlString.append( "<Detail1>\r\n" );
						valueXmlString.append( "<site_code><![CDATA[" ).append( siteCode ).append( "]]></site_code>\r\n" );
						String sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();

						if(rs.next())
						{
							valueXmlString.append("<site_desc>").append("<![CDATA[" + rs.getString("DESCR") + "]]>").append("</site_desc>");
						}
						else
						{
							valueXmlString.append("<site_desc>").append("<![CDATA[]]>").append("</site_desc>");
						}
						valueXmlString.append( "</Detail1>\r\n" );
						rs.close();
						pstmt.close();
						conn.close();
					}
					if ( currentColumn.trim().equalsIgnoreCase( "supp_code" ))
					{
						suppCode = genericUtility.getColumnValue("supp_code",hdrDom);
						valueXmlString.append( "<Detail1>\r\n" );
						String sql = "select supp_name from supplier where supp_code = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, suppCode);
						rs = pstmt.executeQuery();

						if(rs.next())
						{
							valueXmlString.append("<supp_name>").append("<![CDATA[" + rs.getString("supp_name") + "]]>").append("</supp_name>");
						}
						else
						{
							valueXmlString.append("<supp_name>").append("<![CDATA[]]>").append("</supp_name>");
						}
						valueXmlString.append( "</Detail1>\r\n" );
						rs.close();
						pstmt.close();
						conn.close();
					}

				}
			}
			break;
			}
			valueXmlString.append( "</Root>\r\n" );
		}
		catch(Exception e)
		{
			System.out.println("Exception: FrightUpdIC: defaultItemChanged(Document dom): " + e.getMessage() + ":");
			e.printStackTrace();
			errString = genericUtility.createErrorString(e);		
		}

		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;								
				}	
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception es)
			{
				es.printStackTrace();
				errString = genericUtility.createErrorString(es);
			}
		}

		return valueXmlString.toString();		
	}


	@Override
	public String wfValData(Document currFormDataDom, Document hdrDataDom,
			Document allFormDataDom, String objContext, String xtraParams)
	throws RemoteException, ITMException 
	{
		return null;
	}




}
