SET DEFINE OFF;

-- Request ID: A15FSUN002.Start --

CREATE TABLE BUSINESS_UNITS
(
	BU_CODE CHAR(5) NOT NULL,
	DESCR VARCHAR(120) NOT NULL,
	SH_DESCR VARCHAR(40),
	EMP_CODE__HEAD CHAR(10) NOT NULL,
	ADD_DATE DATE NOT NULL,
	ADD_USER CHAR(10) NOT NULL,
	ADD_TERM VARCHAR2(15) NOT NULL,
	CHG_DATE DATE NOT NULL,
	CHG_USER CHAR(10) NOT NULL,
	CHG_TERM VARCHAR2(15) NOT NULL
);
ALTER TABLE BUSINESS_UNITS ADD CONSTRAINT BUSINESS_UNITS_X PRIMARY KEY(BU_CODE);

INSERT INTO ITM2MENU 
(
	application,
	level_1,
	level_2,
	level_3,
	level_4,
	level_5,
	win_name,
	descr,
	comments,
	menu_path,
	icon_path,
	obj_type,
	mob_deploy,
	chg_user,
	chg_term,
	chg_date
) 
VALUES 
(
	'ADM',
	2,
	38,
	0,
	0,
	0,
	'w_businessunits',
	'Business Units',
	'Business Units',
	'ADM.2.38.0.0.0',
	'e12_logo.gif',
	'T',
	NULL,
	'BASE',
	'BASE',
	fn_sysdate()
);

INSERT INTO TRANSETUP 
(
	TRAN_WINDOW, SAVE_FLAG, VAL_FLAG, KEY_FLAG, KEY_STRING, UDF_1, UDF_2, UDF_3, UDF_4, UDF_5, REPEATE_ADD, CHG_DATE, CHG_USER, CHG_TERM, EDI_OPTION, SITE_ACC_COL, CONFIRM_COL, CONFIRM_VAL, REPEAT_ADD_DET, REPEATADDDET, LOAD_MODE, AUTO_CONFIRM, LEDG_POST_CONF, CHG_DATE_ON_CONF, TRAN_ID_COL, MAIL_OPTION, CONFIRM_MODE ,GARBAGE_OPT, VAL_FLAG_EDI, VERIFY_PASSWORD, CUST_ACC_COL, SALES_PERS_ACC_COL, SUPP_ACC_COL, ITEM_SER_ACC_CODE, EMP_ACC_COL, ITEM_SER_ACC_COL, WORKFLOW_OPT, TABLE_NAME, APPLICATION, TABLE_DESC, TRAN_DATE_COL, TRAN_ID__FROM, TRAN_ID__TO, TABLE_NAME_DET1, TABLE_NAME_DET2, TABLE_NAME_DET3, MULTITIRE_OPT, REF_SER, VIEW_MODE, TAX_FORMS, SIGN_STATUS, USER_TRAN_WINDOW, CUSTOM_PREVIEW_OBJ, IGNOREERRLIST_ONLOAD, CHILDDATA_ARGOPT, EDIT_TMPLT, WRKFLW_INIT, EDITTAX, FORMAL_ARGS, AUDIT_TRAIL_OPT, EDIT_OPT, CACHE_OPT, OPTIMIZE_MODE, EDIT_EXPR, RATE_COL, QTY_COL, EDIT_EXPR_INP, RCP_CACHE_STATUS, PRINT_CONTROL, TRANSFER_MODE, PROFILE_ID__RES, TRAN_COMPL_MSG, PERIOD_OPTION, WRKFLW_PRIORITY, EXEC_TYPE, DISP_META_DATA, START_FORM, ISATTACHMENT, HEADER_FORM_NO, ALLOW_ATTACH, MSG_ONSAVE, CONFIRM_DATE_COL, CONFIRM_BY_COL, WF_STATUS, ISGWTINITIATED, RESTART_FORM, BROW_DATA_DEF, CMS_PATH
)
VALUES 
(
	'w_businessunits', '2', '2', 'M', 'seq10', null, null, null, null, null, 'N', fn_sysdate(), 'BASE', 'BASE', '0', null, null, null, null, null, null, null, null, null, 'BU_CODE', '0', '0', 'N', null, null, null, null, null, null, null, null, null, 'BUSINESS_UNITS', 'ADM', null, null, null, null, null, null, null, null, null, 'F', null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null
);

INSERT INTO OBJ_FORMS
(
	WIN_NAME,
	TITLE,
	OBJ_BROW_NAME,
	OBJ_EDIT_NAME,
	FORM_NO
) 
VALUES
(
	'w_businessunits',
	'Business Units',
	'd_businessunits11',
	'd_businessunits21',
	'1'
);

INSERT INTO OBJ_ACTIONS 
(
	OBJ_NAME,
	LINE_NO,
	RIGHTS_CHAR,
	INTERACTIVE,
	SERVICE_CODE,
	DESCRIPTION,
	TITLE,
	IMAGE,
	FORM_NO,
	SERVICE_HANDLER,
	PLACEMENT,
	ACTION_TYPE
)
VALUES 
(
	'businessunits',
	1,
	'A',
	'a',
	'a',
	'Add New',
	'Add',
	'add.gif',
	'1',
	null,
	null,
	'S'
);

INSERT INTO OBJ_ACTIONS 
(
	OBJ_NAME,
	LINE_NO,
	RIGHTS_CHAR,
	INTERACTIVE,
	SERVICE_CODE,
	DESCRIPTION,
	TITLE,
	IMAGE,
	FORM_NO,
	SERVICE_HANDLER,
	PLACEMENT,
	ACTION_TYPE
)
VALUES 
(
	'businessunits',
	2,
	'E',
	'a',
	'a',
	'Edit',
	'Edit',
	'edit.gif',
	'1',
	null,
	null,
	'S'
);

INSERT INTO OBJ_ACTIONS 
(
	OBJ_NAME,
	LINE_NO,
	RIGHTS_CHAR,
	INTERACTIVE,
	SERVICE_CODE,
	DESCRIPTION,
	TITLE,
	IMAGE,
	FORM_NO,
	SERVICE_HANDLER,
	PLACEMENT,
	ACTION_TYPE
)
VALUES 
(
	'businessunits',
	3,
	'D',
	'a',
	'a',
	'Delete',
	'Delete',
	'delete.gif',
	'1',
	null,
	null,
	'S'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
) 
VALUES 
(
	'businessunits',
	'1',
	'emp_code__head',
	'Y'
);

INSERT INTO SYSTEM_EVENTS 
(
	OBJ_NAME,
	EVENT_CODE,
	EVENT_CONTEXT,
	SERVICE_CODE,
	METHOD_RULE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	RESULT_HANDLE,
	OVERWRITE_CORE,
	COMP_TYPE,
	COMP_NAME,
	COMM_FORMAT
) 
VALUES 
(
	'businessunits',
	'pre_validate',
	'1',
	'prv_businessunits',
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE',
	'2',
	'0',
	'EJB',
	'BusinessUnits',
	NULL
);

INSERT INTO SYSTEM_EVENT_SERVICES
(
	SERVICE_CODE,
	SERVICE_DESCR,
	SERVICE_URI,
	SERVICE_PROVIDER,
	METHOD_NAME,
	RETURN_VALUE,
	RETURN_TYPE,
	RETURN_DESCR,
	RETURN_XFRM,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
) 
VALUES 
(
	'prv_businessunits',
	'To validate the required fields',
	'http://localhost:9090/axis/services/ValidatorService',
	'base',
	'wfValData',
	'String',
	'S',
	NULL,
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE'
);


INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_businessunits',1,'COMPONENT_TYPE','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE','EJB');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_businessunits',2,'COMPONENT_NAME','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE','BusinessUnits');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_businessunits',3,'XML_DATA','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_businessunits',4,'XML_DATA_1','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_businessunits',5,'XML_DATA_ALL','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_businessunits',6,'OBJ_CONTEXT','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_businessunits',7,'EDIT_FLAG','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('prv_businessunits',8,'XTRA_PARAMS','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE',NULL);


INSERT INTO SYSTEM_EVENTS 
(
	OBJ_NAME,
	EVENT_CODE,
	EVENT_CONTEXT,
	SERVICE_CODE,
	METHOD_RULE,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	RESULT_HANDLE,
	OVERWRITE_CORE,
	COMP_TYPE,
	COMP_NAME,
	COMM_FORMAT
) 
VALUES 
(
	'businessunits',
	'post_item_change',
	'1',
	'poic_businessunits',
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE',
	'2',
	'0',
	'EJB',
	'BusinessUnits',
	NULL
);


INSERT INTO SYSTEM_EVENT_SERVICES
(
	SERVICE_CODE,
	SERVICE_DESCR,
	SERVICE_URI,
	SERVICE_PROVIDER,
	METHOD_NAME,
	RETURN_VALUE,
	RETURN_TYPE,
	RETURN_DESCR,
	RETURN_XFRM,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
) 
VALUES 
(
	'poic_businessunits',
	'For item change on the required fields',
	'http://localhost:9090/axis/services/ValidatorService',
	'base',
	'itemChanged',
	'String',
	'S',
	NULL,
	NULL,
	fn_sysdate(),
	'BASE',
	'BASE'
);


INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_businessunits',1,'COMPONENT_TYPE','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE','EJB');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_businessunits',2,'COMPONENT_NAME','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE','BusinessUnits');
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_businessunits',3,'XML_DATA','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_businessunits',4,'XML_DATA_1','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_businessunits',5,'XML_DATA_ALL','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_businessunits',6,'OBJ_CONTEXT','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_businessunits',7,'FOCUSED_COLUMN','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES ('poic_businessunits',8,'EDIT_FLAG','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE',NULL);
INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) VALUES('poic_businessunits',9,'XTRA_PARAMS','I',NULL,'S',NULL,fn_sysdate(),'BASE','BASE',NULL);


INSERT INTO POPHELP
(
	FIELD_NAME,
	MOD_NAME,
	SQL_STR,
	MSG_TITLE,
	WIDTH,
	HEIGHT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM,
	SQL_INPUT,
	DEFAULT_COL,
	HELP_OPTION
)
VALUES
(
	'EMP_CODE__HEAD',
	'W_BUSINESSUNITS',
	'SELECT EMP_CODE AS EMPLOYEE_CODE, EMP_FNAME||'' ''||EMP_MNAME||'' ''||EMP_LNAME as EMPLOYEE_NAME FROM EMPLOYEE',
	'EMPLOYEE CODE',
	0,
	0,
	fn_sysdate(),
	'BASE',
	'BASE',
	NULL,
	1,
	1
);


INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMBUSUNI01',
	'Unit code is empty',
	'Unit code is mandatory, please enter unit code',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMBUSUNI02',
	'Invalid unit code',
	'Entered value in unit code is existing in the system, please enter new unit code',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);

INSERT INTO MESSAGES
(	
	MSG_NO, 
	MSG_STR, 
	MSG_DESCR, 
	MSG_TYPE, 
	MSG_OPT, 
	CHG_DATE, 
	CHG_USER, 
	CHG_TERM
) 
VALUES 
(
	'VMBUSUNI03',
	'Description is empty',
	'Description is mandatory, please enter description',
	'E',
	'Y',
	fn_sysdate(),
	'BASE ',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMBUSUNI04',
	'Short description is empty',
	'Short description is mandatory, please enter short description',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMBUSUNI05',
	'Unit head is empty',
	'Unit head is mandatory, please enter unit head',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);


INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMBUSUNI06',
	'Invalid unit head',
	'Entered value in unit head is not existing in the system, please enter valid unit head',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMBUSUNI07',
	'Invalid unit head',
	'Entered value in unit head is about to be relieved, please enter valid unit head',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMBUSUNI08',
	'Invalid description',
	'Entered value in description is existing in the system, please enter another description',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);

INSERT INTO MESSAGES
(
	MSG_NO,
	MSG_STR,
	MSG_DESCR,
	MSG_TYPE,
	MSG_OPT,
	CHG_DATE,
	CHG_USER,
	CHG_TERM
)
VALUES
(
	'VMBUSUNI09',
	'Invalid short description',
	'Entered value in short description is existing in the system, please enter another short description',
	'E',
	'Y',
	fn_sysdate(),
	'BASE',
	'BASE'
);

COMMIT;

-- Request ID: A15FSUN002.End --
