package ibase.webitm.ejb.dis;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.FinCommonInvAcct;
import ibase.webitm.ejb.fin.InvAcct;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.ejb.Stateless;
//import javax.ejb.SessionBean;
// added for ejb3

@Stateless // added for ejb3
//public class DistOrderRcpConf extends ActionHandlerEJB //implements SessionBean
public class DistOrderRcpConf extends ActionHandlerEJB implements DistOrderRcpConfLocal, DistOrderRcpConfRemote
{
	
	DistCommon distCommon =new DistCommon();
    /*public void ejbCreate() throws RemoteException,CreateException{
    }
    public void ejbRemove(){

    }
    public void ejbActivate(){

    }
    public void ejbPassivate(){

    }
    public void setSessionContext(SessionContext se)
	{
    }*/
	//Changed by wasim on 18-07-2016 to add confirm method [START]
		public String confirm(String tranID, String xtraParams, String forcedFlag) throws RemoteException,ITMException
		{

			String  retString = null;
			Connection conn = null;
			
			try
			{
				retString = confirm(tranID, xtraParams, forcedFlag, conn );
			}

			catch(Exception e)
			{
				System.out.println("Exception :DistIssueConfirmActEJB :actionHandler :" + e.getMessage() + ":");
				e.printStackTrace();
				throw new ITMException(e);
			}

			return retString;
		}
	//Changed by wasim on 18-07-2016 to add confirm method [END]
	
	public String actionHandler(String tranID, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{

		String  retString = null;
		boolean isConn = false;
		Connection conn = null;
		
		try
		{
			retString = confirm(tranID, xtraParams, forcedFlag, conn);
		}

		catch(Exception e)
		{
			System.out.println("Exception :DistIssueConfirmActEJB :actionHandler :" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}

		return retString;
	}
    //public String actionConfirm(String tranID,String xtraParams, String forcedFlag) throws Exception,ITMException
	public String confirm(String tranID,String xtraParams, String forcedFlag,Connection conn) throws RemoteException,ITMException
    {
    	String errString = null;
        //Connection conn = null;
        ITMDBAccessEJB itmDBAccessEJB = null;
        boolean isError = false;
        boolean connStatus = false;
        try
        {
        	itmDBAccessEJB = new ITMDBAccessEJB();
			if (conn == null)
			{
				ConnDriver connDriver = new ConnDriver();
	            //conn = connDriver.getConnectDB("DriverITM");
				conn = getConnection();
	            conn.setAutoCommit(false);
	            connDriver = null;
	            connStatus = true;
			}
			
			errString = actionConfirm(tranID,xtraParams, forcedFlag, conn);
			
			 if(errString !=null && errString.indexOf("Error") != -1 && errString.indexOf("VTCONF") == -1)
			 {
	              isError = true;
			 }
        }
        catch(Exception ie)
		{
        	isError = true;
            System.out.println("ITMException : "+ie);
            try{conn.rollback();}catch(Exception t){}
            ie.printStackTrace();
            errString = itmDBAccessEJB.getErrorString("","VTDESNCONF","","",conn);
            System.out.println("Returnng String From DistOrderRcpConfEJB :"+errString);
            return errString;
		}
        finally
        {
        	System.out.println("isError in Finally"+isError);
        	try
        	{
        		if(connStatus)
        		{	
	        		if (conn != null && !isError)
					{
	        			conn.commit();
					}
	        		else
	        		{
	        			conn.rollback();
	        		}
	        		conn.close();
					conn = null;
        		}
        	}
        	catch(Exception ex)
        	{
        		ex.printStackTrace();
        	}
        }
		return errString;
    }
	
	 //Changes done by mayur on 3-1-18 [START]
    public String actionConfirm(String tranID,String xtraParams, String forcedFlag, Connection conn) throws Exception,ITMException
    {
        //Connection conn = null;
        PreparedStatement pstmt = null,pstmt1 = null;
        ResultSet rs = null,rs1 = null;
        PreparedStatement pstmtUpd = null;
        String sql = "",qcLockReqd = "",status = "",loginSiteCode = "",tranIdHoldTrace = "";
		String tranIdIss = "",siteCode = "",locCodeGit = "",siteCodeShip = "";
		String qcReqd = "",gpNo = "",orderType = "",tranType = "";
		String 	gengpno ="",errCode ="";
		String distOrder ="",itemCode ="",unit ="",locCode = "", packCode = "";
		String lotNo ="",lotSl = "",siteCodeMfg = "", packInstr ="",batchNo = "",grade ="";
		String dimension ="",suppCodeMfg = "",itemSer = "",grpCode ="";
		String acctCodeIss ="",	cctrCodeIss ="",acctDetrDistTtype = "",tranTypeParent ="";
		double quantity =0,rate =0,potencyPerc = 0,grossWeight =0,netWeight =0,holdQtyNew = 0;
		double tareWeight =0,netAmt =0;
		Timestamp mfgDate =null,expDate =null;
		String locCodeIss ="",invStat ="",acctCodeInv ="",unitAlt ="",quarLock = "";
		String cctrCodeInv ="",acctCodeOh ="",cctrCodeOh ="",acctDetrTtype ="",lockCode = "", holdLock = "";
		//Modified By Umakanta Das on 17-OCT-2016[]Start
		double batchSizeApprv = 0, batchSize = 0;
		String  keyString = "", remarks = "", userId = "", termId = "", jobWorkType = "", result = "", quarLockCode="";
		String siteCodeDRcp = "",  itemCodeDRcp = "", locCodeDRcp = "", lotNoDRcp = "", lotSlDRcp = "";
		double holdQty = 0;
		String bondTaxGroup = "", bondTaxArray[]=null,EOU = "";
		java.sql.Timestamp chgDate = null;
		java.util.Date date = null;
		int lineNoInv = 0, updCnt = 0, cnt = 0,countXfr = 0;
		//Modified By Umakanta Das on 17-OCT-2016[]Start
		double convQtyStduom =0,recoAmount =0;
		Timestamp retestDate =null;
		long noArt =0;
		double grossRate =0,palletWt =0;

        String errString = "";
        boolean lbQcLock = false;
        Timestamp tranDate = null;
        HashMap stkUpdMap = null;
		String tranDateStr ="";
		int upd =0;
		//lineNo =0,lineNoDistOrder =0;
		String lineNo ="";
		int lineNoDistOrder = 0;
        ITMDBAccessEJB itmDBAccessEJB = null;
        InvHoldGen invHoldGen = new InvHoldGen();//Modified By Umakanta Das On 17-OCT-2016
        ArrayList arrayList =new ArrayList();
        List<HashMap<String, String>> holdQtyList = new ArrayList<HashMap<String, String>>();// Modified By Umakanta Das On 17-OCT-2016
        ArrayList<HashMap<String, String>> stockList = new ArrayList<HashMap<String, String>>();// Modified By Umakanta Das On 17-OCT-2016
        HashMap  stockQtyMap = new HashMap();// Modified By Umakanta Das on 17-OCT-2016
        FinCommon finCommon = null;
        //GenericUtility genericUtility = null;
        ActionHandlerEJB itmDBAccessLocal =null;
        FinCommonInvAcct finCommonInvAcct = null;
		int count=0;
		//added by saurabh
		int bondTaxAmt=0,bondValue=0,bondNo=0,bankGuarantee=0,bondValueFinal=0;
		String holdTranId="", lockCodeNew = "";
		List<HashMap<String, String>> stockIssList = new ArrayList<HashMap<String, String>>();
		HashMap<String, String> stock_iss =new HashMap<String, String>();
		//added by saurabh
		Double holdQtyIss = 0.0;
		String siteCodeIss = "";
		String itemCodeIss ="";
		String locCodeIss1 = "";
		String lotNoIss ="";
		String lotSlIss ="";
        try{
        	System.out.println("in dr confirm::::");
            finCommon = new FinCommon();
           // finCommonInvAcct = new FinCommonInvAcct();
            itmDBAccessEJB = new ITMDBAccessEJB();
			//genericUtility = GenericUtility.getInstance();
            E12GenericUtility genericUtility = new E12GenericUtility();
            userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			termId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
            stkUpdMap = new HashMap();
			if (conn == null)
			{
				ConnDriver connDriver = new ConnDriver();
	            //conn = connDriver.getConnectDB("DriverITM");
				conn = getConnection();
	            conn.setAutoCommit(false);
	            connDriver = null;
			}
			SimpleDateFormat sdf = new  SimpleDateFormat(genericUtility.getApplDateFormat());
            sql = " select	 tran_id__iss,	site_code, loc_code__git, tran_date, "
				 +" site_code__ship, ( case when qc_reqd is null then 'N' else qc_reqd end ) qc_reqd, "
				 +" gp_no	, order_type  ,tran_type "
				 +" from distord_rcp  where tran_id = ?";
            //System.out.println("SQL : "+sql);
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranID);
			rs = pstmt.executeQuery();
            if(rs.next())
			{
                tranIdIss = rs.getString("tran_id__iss");
                siteCode = rs.getString("site_code");
				locCodeGit = rs.getString("loc_code__git");
				System.out.println("manohar locCodeGit : "+locCodeGit);
				tranDate = rs.getTimestamp("tran_date");
				siteCodeShip = rs.getString("site_code__ship");
				qcReqd = rs.getString("qc_reqd");
				gpNo = rs.getString("gp_no");
				orderType = rs.getString("order_type");
				tranType = rs.getString("tran_type");
            }
            rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			count = 0;
			
			gengpno  = distCommon.getDisparams("999999","STN_RCP_GPNO",conn);
			if("Y".equalsIgnoreCase(gengpno.trim()))
			{
				if(gpNo == null || gpNo.trim().length() ==0 )
				{
					tranDateStr = sdf.format(tranDate);
					String xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
					xmlValues = xmlValues + "<Header></Header>";
					xmlValues = xmlValues + "<Detail1>";
					xmlValues = xmlValues +	"<tran_id></tran_id>";
					xmlValues = xmlValues + "<site_code>"+siteCode.trim()+"</site_code>";
					xmlValues = xmlValues +  "<tran_date>"+tranDateStr.trim()+"</tran_date>";
					xmlValues = xmlValues +  "<tran_type>"+orderType.trim()+"</tran_type>";
					xmlValues = xmlValues + "</Detail1></Root>";
					gpNo = generateTranId("stn_rcp_gpno",xmlValues,conn);//function to generate NEW transaction id
					System.out.println("gpNo......"+gpNo);
					if(gpNo == null || gpNo.trim().length() ==0)
					{
						errCode = "VTTRANID";
						System.out.println("errcode......"+errCode);
						errString = itmDBAccessEJB.getErrorString("","VTTRANID","BASE","",conn);
						return errString;
					}
					else
					{
						sql =" update distord_rcp  set 	gp_no = ? where tran_id = ? " ;
						//System.out.println("sql-------------"+sql);
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,gpNo);
						pstmt.setString(2,tranID);
						upd = pstmt.executeUpdate();
						if(upd == 1)
						{
							System.out.println("distord_rcp update-------------"+upd);
						}
						rs.close();
						pstmt.close();
						pstmt=null;
						rs=null;
					}
				}
			}
			//Modified By Umakanta Das on 17-OCT-2016[]Start
			sql = "Select (case when eou is null then 'N' else eou end) eou From site Where site_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				EOU = rs.getString("eou");
			}
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;


			jobWorkType = distCommon.getDisparams("999999", "JOBWORK_TYPE", conn);
			if (jobWorkType == null)
			{
				jobWorkType = "";
			}

			if (! "".equalsIgnoreCase( jobWorkType ) )
			{
				bondTaxGroup = distCommon.getDisparams( "999999", "B17_BOND_TAX_GROUP", conn );
				if ( bondTaxGroup != null && bondTaxGroup.trim().length() > 0 )
				{
					bondTaxArray = bondTaxGroup.split(",");
					String orderNoTemp = "";
					bondTaxGroup = "";
					for ( int ctr = 0; ctr < bondTaxArray.length; ctr++ )
					{
						orderNoTemp = bondTaxArray[ctr];
						bondTaxGroup = bondTaxGroup + "'".concat(orderNoTemp).concat("',");
					}
				}
			}
			/*uomRound = distCommon.getDisparams("999999", "UOM_ROUND", conn);
			if ("NULLFOUND".equals(uomRound))
			{
				errString = itmDBAccessLocal.getErrorString("", "VTUOMVARPARM", "");
				return errString;
			}

			if ("Y".equals(EOU))
			{
				bondTaxGroup = distCommon.getDisparams("999999", "B17_BOND_TAX_GROUP", conn);
				if (bondTaxGroup != null && bondTaxGroup.trim().length() > 0)
				{
					bondTaxArray = bondTaxGroup.split(",");
					String orderNoTemp = "";
					bondTaxGroup = "";
					for (int ctr = 0; ctr < bondTaxArray.length; ctr++)
					{
						orderNoTemp = bondTaxArray[ctr];
						bondTaxGroup = bondTaxGroup + "'".concat(orderNoTemp).concat("',");
					}
				}
			}*/
			
			//Modified By Umakanta Das on 17-OCT-2016[]End
			
			sql ="select	line_no	,	dist_order	,line_no_dist_order,item_code, "
				+" quantity	,	unit	, 	loc_code	, 	pack_code	, "
				+" rate	, 	lot_no	, 	lot_sl		, 	mfg_date	, "
				+" exp_date	, 	site_code__mfg	, 	potency_perc	, 	gross_weight, "
				//Modified By Umakanta Das on 17-OCT-2016
				//+" net_weight,	tare_weight	, 	pack_instr	, 	batch_no	,"
				+" net_weight,	tare_weight	, 	pack_instr	, 	batch_no	, batch_size ,"
				+" grade	, 	dimension	, 	supp_code__mfg 	,	net_amt, no_art "
				+ " from 	distord_rcpdet where tran_id = ? order by line_no ";
			//System.out.println("sql-------------"+sql);
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranID);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				HashMap<String,String>  holdQtyMap = new HashMap();// Modified By Umakanta Das on 17-OCT-2016
				lineNo=rs.getString("line_no");
				distOrder=rs.getString("dist_order");
				lineNoDistOrder=rs.getInt("line_no_dist_order");
				itemCode=rs.getString("item_code");
				quantity=rs.getDouble("quantity");
				unit=rs.getString("unit");
				locCode=rs.getString("loc_code");
				packCode=rs.getString("pack_code");
				rate=rs.getDouble("rate");
				lotNo=rs.getString("lot_no");
				lotSl=rs.getString("lot_sl");
				mfgDate=rs.getTimestamp("mfg_date");
				expDate=rs.getTimestamp("exp_date");
				siteCodeMfg=rs.getString("site_code__mfg");
				potencyPerc=rs.getDouble("potency_perc");
				grossWeight=rs.getDouble("gross_weight");
				netWeight=rs.getDouble("net_weight");
				tareWeight=rs.getDouble("tare_weight");
				packInstr=rs.getString("pack_instr");
				batchNo=rs.getString("batch_no");
				batchSize = rs.getDouble("batch_size");
				grade=rs.getString("grade");
				dimension=rs.getString("dimension");
				suppCodeMfg=rs.getString("supp_code__mfg");
				netAmt=rs.getDouble("net_amt");
				noArt=rs.getLong("no_art");

				// Modified By umakanta Das on 17-OCT-2016[To check QC Required N]Start
				if ("N".equals(qcReqd))
				{
					if (batchSize > 0)//Need to Ask Manoj 15=OCT-2016
					{
						sql = "select batch_size from batchsize_aprv where item_code	= ? and site_code__mfg	= ? and eff_from <= ?  and valid_upto >= ? and confirmed = 'Y' ";
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1, itemCode);
						//pstmt1.setString(2, siteCodeMfg);//Commented by Manoj dtd 19/10/2016 sitecode to be set instead of siteCodeMfg
						pstmt1.setString(2, siteCode);
						pstmt1.setTimestamp(3, tranDate);
						pstmt1.setTimestamp(4, tranDate);
						rs1 = pstmt1.executeQuery();
						if (rs1.next())
						{
							batchSizeApprv = rs1.getDouble("batch_size");
						}
						
						pstmt1.close();
						pstmt1 = null;
						rs1.close();
						rs1 = null;

						if (batchSize > batchSizeApprv)
						{
							sql = "select key_string from transetup where upper(tran_window) = 'W_INV_HOLD'";
							pstmt1 = conn.prepareStatement(sql);
							rs1 = pstmt1.executeQuery();
							if (rs1.next())
							{
								keyString = rs1.getString("key_string");
								pstmt1.close();
								pstmt1 = null;
								rs1.close();
								rs1 = null;
							} 
							else
							{
								pstmt1.close();
								pstmt1 = null;
								rs1.close();
								rs1 = null;
								sql = "select key_string from transetup  where upper(tran_window) = 'GENERAL'";
								pstmt1 = conn.prepareStatement(sql);
								rs1 = pstmt1.executeQuery();
								if (rs1.next())
								{
									keyString = rs1.getString("key_string");
								}
								pstmt1.close();
								pstmt1 = null;
								rs1.close();
								rs1 = null;
							}
							// tranDate = getCurrdateAppFormat();
							String xmlValues = "", tempTranId = "";
							xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
							xmlValues = xmlValues + "<Header></Header>\r\n";
							xmlValues = xmlValues + "<Detail1>\r\n";
							xmlValues = xmlValues + "<tran_id></tran_id>\r\n";
							xmlValues = xmlValues + "<site_code>" + siteCode + "</site_code>\r\n";
							xmlValues = xmlValues + "<tran_date>" + getCurrdateAppFormat() + "</tran_date>\r\n";
							xmlValues = xmlValues + "</Detail1>\r\n</Root>";
							System.out.println("xmlValues  :[" + xmlValues + "]");
							TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
							tempTranId = tg.generateTranSeqID("INVHOL", "tran_id", keyString, conn);

							System.out.println("tempTranId [" + tempTranId + "]");

							sql = " insert into inv_hold (tran_id, tran_date, site_code, remarks,confirmed, chg_user, chg_date, chg_term) " 
									+ " values	( ?, ?, ?, ?, 'N', ?, ?, ? ) ";

							remarks = "Auto generated from Purchase Receipt	:" + tranID;
							chgDate = new java.sql.Timestamp( System.currentTimeMillis() );
							//java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
							date = sdf.parse(chgDate.toString());
							chgDate = java.sql.Timestamp.valueOf(sdf.format(date).toString() + " 00:00:00.0");

							pstmtUpd = conn.prepareStatement(sql);
							pstmtUpd.setString(1, tempTranId);
							pstmtUpd.setTimestamp(2, chgDate);
							chgDate = new java.sql.Timestamp( System.currentTimeMillis() );
							pstmtUpd.setString(3, siteCode);
							pstmtUpd.setString(4, remarks);
							pstmtUpd.setString(5, userId);
							pstmtUpd.setTimestamp(6, chgDate);
							pstmtUpd.setString(7, termId);

							updCnt = pstmtUpd.executeUpdate();
							pstmtUpd.close();
							pstmtUpd = null;

							lineNoInv++;

							sql = "insert into inv_hold_det (tran_id, line_no, item_code, site_code,loc_code, lot_no, lot_sl, remarks,	hold_status) "
							+ " values	(?, ?, ?,?,?,?,?,?,	'H') ";

							pstmtUpd = conn.prepareStatement(sql);
							pstmtUpd.setString(1, tempTranId);
							pstmtUpd.setInt(2, lineNoInv);
							pstmtUpd.setString(3, itemCode);
							pstmtUpd.setString(4, siteCode);
							pstmtUpd.setString(5, locCode);
							pstmtUpd.setString(6, lotNo);
							pstmtUpd.setString(7, lotSl);
							pstmtUpd.setString(8, remarks);

							updCnt = pstmtUpd.executeUpdate();
							pstmtUpd.close();
							pstmtUpd = null;
						} // batchSize > approved batch size
					} // batchSize > 0
				} 
				// Modified By umakanta Das on 17-OCT-2016[To check QC Required N]Start
				itemSer = getItemSer(itemCode,siteCode, tranDate,conn);
				sql ="select inv_stat from location where loc_code = ? "	;
				//System.out.println("sql-------------"+sql);

				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1,locCodeGit);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					invStat=rs1.getString("inv_stat");
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
				if(tranIdIss != null &&	tranIdIss.trim().length() > 0)
				{
					sql ="select loc_code from distord_issdet where tran_id = ? "
							+" and  	item_code = ? "
							+" and  	lot_no = ? "
							+" and  	lot_sl = ? " ;
					//System.out.println("sql-------------"+sql);

					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1,tranID);
					pstmt1.setString(2,itemCode);
					pstmt1.setString(3,lotNo);
					pstmt1.setString(4, lotSl);
					rs1 = pstmt1.executeQuery();
					if(rs1.next())
					{
						locCodeIss=rs1.getString("loc_code");
					}
					rs1.close();
					rs1 = null;
					pstmt1.close();
					pstmt1 = null;
				}
				else
				{
					locCodeIss = locCode;
				}
				sql ="select 	acct_code__inv	,	cctr_code__inv		, acct_code__oh	,	cctr_code__oh	, "
						+" unit__alt		, 	conv__qty_stduom	, retest_date"
						+" from 	stock a, invstat b "
						+" where a.inv_stat  = b.inv_stat "
						+" and 	a.item_code = ? "
						+" and	a.loc_code      = ? "
						+" and 	a.lot_no    = ? "
						+" and 	a.lot_sl    = ? "	  ;
				//System.out.println("sql-------------"+sql);
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1,itemCode);
				pstmt1.setString(2,locCodeIss);
				pstmt1.setString(3,lotNo);
				pstmt1.setString(4,lotSl);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					acctCodeInv = rs1.getString("acct_code__inv");
					cctrCodeInv = rs1.getString("cctr_code__inv");
					acctCodeOh  = rs1.getString("acct_code__oh");
					cctrCodeOh  = rs1.getString("cctr_code__oh");
					unitAlt      = rs1.getString("unit__alt");
					convQtyStduom = rs1.getDouble("conv__qty_stduom");
					retestDate    = rs1.getTimestamp("retest_date");
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
				if(unitAlt == null || unitAlt.trim().length() < 0 )
				{
					unitAlt = unit;
				}
				if(convQtyStduom < 1)
				{
					convQtyStduom = 1;
				}
				lineNo = "   "+lineNo.trim() ;
				lineNo = lineNo.substring(lineNo.length()-3);
				sql ="select case when sum(reco_amount) is null then 0 else sum(reco_amount) end "
						+" from   taxtran  where  tran_code = 'D-RCP' and    tran_id   = ? "
						+" and  line_no = ? ";
				//System.out.println("sql-------------"+sql);
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1,tranID);
				pstmt1.setString(2,lineNo);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					recoAmount=rs1.getDouble(1);

				}
				rs1.close();
				pstmt1.close();
				if((netAmt - recoAmount) > 0 && quantity > 0)
				{
					rate = ( (netAmt - recoAmount) / quantity  );
				}
				if(netAmt > 0 && quantity > 0)
				{
					grossRate = netAmt / quantity ;
				}
				sql ="select grp_code from item where item_code = ? " ;
				//System.out.println("sql-------------"+sql);
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1,itemCode);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					grpCode=rs1.getString("grp_code");
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
				acctDetrDistTtype = finCommon.getAcctDetrDistTtype(siteCodeShip,siteCode,itemSer,grpCode,itemCode,"D-ISS", tranType,conn) ;
				if (acctDetrDistTtype != null && acctDetrDistTtype.trim().length() > 0)
				{
					acctCodeIss = acctDetrDistTtype.substring(0,acctDetrDistTtype.indexOf(","));
					cctrCodeIss = acctDetrDistTtype.substring(acctDetrDistTtype.indexOf(",")+1);
				}
				System.out.println("acctCodeIss.....D-ISS........" + acctCodeIss);
				System.out.println("cctrCodeIss.....D-ISS........" + cctrCodeIss);
				if(acctCodeInv ==null || acctCodeInv.trim().length() ==0 )
				{
					acctDetrDistTtype = finCommon.getAcctDetrDistTtype(siteCodeShip,siteCode,itemSer,grpCode,itemCode,"D-INV", tranType,conn) ;
					if (acctDetrDistTtype != null && acctDetrDistTtype.trim().length() > 0)
					{
						acctCodeInv = acctDetrDistTtype.substring(0,acctDetrDistTtype.indexOf(","));
						cctrCodeInv = acctDetrDistTtype.substring(acctDetrDistTtype.indexOf(",")+1);
					}
					System.out.println("acctCodeInv.....D-INV........" + acctCodeInv);
					System.out.println("cctrCodeInv.....D-INV........" + cctrCodeInv);
				}
				if(acctCodeInv ==null || acctCodeInv.trim().length() ==0 )
				{
					acctDetrTtype = finCommon.getAcctDetrTtype(itemCode,itemSer,"STKINV", tranType,conn) ;
					if (acctDetrTtype != null && acctDetrTtype.trim().length() > 0)
					{
						acctCodeInv = acctDetrTtype.substring(0,acctDetrTtype.indexOf(","));
						cctrCodeInv = acctDetrTtype.substring(acctDetrTtype.indexOf(",")+1);
					}
					System.out.println("acctCodeInv.....STKINV........" + acctCodeInv);
					System.out.println("cctrCodeInv.....STKINV........" + cctrCodeInv);
				}
				if(acctCodeInv ==null || acctCodeInv.trim().length() ==0 )
				{
					acctCodeInv =" ";
					cctrCodeInv = " ";
				}
				
				
				//added by azhar [31/JAN/2017][START]
				 quarLock = distCommon.getDisparams("999999", "QUARNTINE_LOCKCODE", conn);//TODO migrate from pb
				System.out.println("quarantine lock code befor trantype I::" + quarLock);
				
				sql = "select hold_qty from stock where item_code = ? and site_code = ? and loc_code = ?" +
						"and lot_no  = ? and lot_sl = ?";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, itemCode);
				pstmt1.setString(2, siteCode);
				pstmt1.setString(3, locCodeGit);
				pstmt1.setString(4, lotNo);
				pstmt1.setString(5, lotSl);
				rs1 = pstmt1.executeQuery();
				if(rs1.next()){
					 holdQtyNew = rs1.getDouble("hold_qty");
				}
				closeResources(pstmt1, rs1);
				
				System.out.println("new hold qty::" + holdQtyNew);
				if(holdQtyNew > 0){
					
					sql = "select a.lock_code ,a.tran_id from inv_hold a, inv_hold_det b , inv_hold_rel_trace c where a.tran_id = b.tran_id and" +
						" b.tran_id = c.ref_no and c.item_code  = ? and ( c.site_code = ? or c.site_code is null ) " +
						"and ( c.loc_code  = ? or c.loc_code is null ) and c.lot_no = ? and" +
						" ( c.lot_sl = ? or c.lot_sl is null ) and b.lot_no = ? and (b.lot_sl = ? or b.lot_sl is null ) " +
						"and (b.line_no_sl = 0 or b.line_no_sl is null) and a.confirmed='Y' and b.hold_status ='H'";
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1, itemCode);
					pstmt1.setString(2, siteCode);
					pstmt1.setString(3, locCodeGit);
					pstmt1.setString(4, lotNo);
					pstmt1.setString(5, lotSl);
					pstmt1.setString(6, lotNo);
					pstmt1.setString(7, lotSl);
					rs1 = pstmt1.executeQuery();
					while(rs1.next()){
						
						 lockCode = checkNullAndTrim(rs1.getString("lock_code"));
						System.out.println("lock code::" + lockCode);
						
						if(lockCode.length()>0 && quarLock.equalsIgnoreCase(lockCode)){
							holdLock = "Y";
						}else{
							holdLock  = "N";
						}
					}
				}
				closeResources(pstmt1, rs1);
				//added by azhar [31/JAN/2017][END]
				stkUpdMap.put("hold_lock", holdLock);//added by azhar[31/JAN/2017]
				stkUpdMap.put("site_code",siteCode);
				stkUpdMap.put("item_code",itemCode);
				stkUpdMap.put("sorderno",distOrder);
				stkUpdMap.put("loc_code",locCodeGit);
				stkUpdMap.put("lot_no",lotNo);
				stkUpdMap.put("lot_sl",lotSl);
				stkUpdMap.put("unit",unit);
				stkUpdMap.put("quantity",Double.toString(quantity));
				stkUpdMap.put("qty_stduom",Double.toString(quantity));
				stkUpdMap.put("tran_type","I");
				stkUpdMap.put("tran_date",tranDate);
				stkUpdMap.put("tran_ser","D-RCP");
				stkUpdMap.put("tran_id",tranID);
				stkUpdMap.put("line_no",lineNo);
				System.out.println("manohar locCodeGit 1 : "+locCodeGit);
				stkUpdMap.put("locationcode",locCodeGit);
				stkUpdMap.put("rate",Double.toString(rate));
				stkUpdMap.put("gross_rate",Double.toString(grossRate));
				stkUpdMap.put("gross_weight",Double.toString(grossWeight));
				stkUpdMap.put("net_weight",Double.toString(netWeight));
				stkUpdMap.put("tare_weight",Double.toString(tareWeight));
				stkUpdMap.put("exp_date",expDate);
				stkUpdMap.put("item_ser",itemSer);
				//added by azhar[START][29-APR-2017]
				siteCodeMfg = siteCodeMfg == null ? "" : siteCodeMfg;
				stkUpdMap.put("site_code__mfg",siteCodeMfg); 
				stkUpdMap.put("unit__alt",unitAlt);
				//added by azhar[END][29-APR-2017]
				stkUpdMap.put("pack_code",packCode);
				stkUpdMap.put("pack_instr",packInstr);
				stkUpdMap.put("potency_perc",Double.toString(potencyPerc));
				stkUpdMap.put("inv_stat",invStat);
				stkUpdMap.put("batch_no",batchNo);
				stkUpdMap.put("dimension",dimension);
				//stkUpdMap.put("supp_code__mfg",siteCodeMfg); // commented by azhar[28-APR-2017] supp code mfg should be set instead of site code mfg
				stkUpdMap.put("supp_code__mfg",checkNullAndTrim(suppCodeMfg)); // changed by azhar[28-APR-2017] supp code mfg should be set instead of site code mfg
				stkUpdMap.put("mfg_date",mfgDate);
				stkUpdMap.put("acct_code_inv",acctCodeInv);
				stkUpdMap.put("cctr_code_inv",cctrCodeInv);
				stkUpdMap.put("rate_oh",Double.toString(0));
				stkUpdMap.put("acct_code_oh",acctCodeOh);
				stkUpdMap.put("cctr_code_oh",cctrCodeOh);
				stkUpdMap.put("no_art",Double.toString(noArt));
				stkUpdMap.put("conv__qty_stduom",Double.toString(convQtyStduom));
				stkUpdMap.put("retest_date",retestDate);
				stkUpdMap.put("grade",grade);
				stkUpdMap.put("acctcodecr",acctCodeIss);
				stkUpdMap.put("cctrcodecr",cctrCodeIss);
				StockUpdate stkUpd =  new StockUpdate();
				// Uncommented By Umakanta Das on 17-OCT-2016[ For stock update ]Start
				errString = stkUpd.updateStock(stkUpdMap,xtraParams,conn);
				if (errString != null && errString.trim().length() > 0 )
				{
					System.out.println("Returning Result "+errString);
					return errString;
				}

				// Uncommented By Umakanta Das on 17-OCT-2016[ For stock update ]End
				stkUpd =  null;
				stkUpdMap.clear();
				//Added By umakanta on 17-OCT-2016[ To hold Stock information ]Start
				sql ="Select hold_qty  From stock Where item_code = ? And site_code =? And loc_code = ? "
						+ "	And lot_no = ? And lot_sl = ? "; 
				//System.out.println("sql-------------"+sql);
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString( 1, itemCode );
				pstmt1.setString( 2, siteCode );
				pstmt1.setString( 3, locCodeGit );
				pstmt1.setString( 4, lotNo );
				pstmt1.setString( 5, lotSl );
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					holdQty = rs1.getDouble("hold_qty");
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;				
				
				//if ( holdQty > 0 ) // commented by azhar[31/JAN/2017]
				
				if ( holdQty > 0 && holdLock.equalsIgnoreCase("Y")) //added by azhar[31/JAN/2017]
				{
					holdQtyMap.put( "hold_qty", Double.toString(holdQty) );
					holdQtyMap.put( "site_code", siteCodeShip );
					holdQtyMap.put( "item_code", itemCode );
					holdQtyMap.put( "loc_code", locCodeGit );
					holdQtyMap.put( "lot_no", lotNo );
					holdQtyMap.put( "lot_sl", lotSl );
					holdQtyList.add( holdQtyMap );

					sql ="update stock set hold_qty = case when hold_qty is null then 0 else hold_qty end - ? Where item_code = ? And site_code =? And loc_code = ? "
							+ "	And lot_no = ? And lot_sl = ? "; 
					//System.out.println("sql-------------"+sql);
					pstmt1 = conn.prepareStatement(sql);
					//pstmt1.setDouble( 1, holdQty );//commented by azhar[31/JAN/2017]
					pstmt1.setDouble( 1, quantity); //added by azhar[31/JAN/2017]
					pstmt1.setString( 2, itemCode );
					pstmt1.setString( 3, siteCode );
					pstmt1.setString( 4, locCodeGit );
					pstmt1.setString( 5, lotNo );
					pstmt1.setString( 6, lotSl );
					upd = pstmt1.executeUpdate();
					pstmt1.close();
					pstmt1 = null;
				}
				//added by saurabh-18/10/16[Start]
				if("Y".equalsIgnoreCase(EOU) && ((jobWorkType.trim()).equalsIgnoreCase(orderType.trim())) && (bondTaxGroup!=null && bondTaxGroup.trim().length()>0))
        		{
        			bondTaxAmt=0;//Need to ask-saurabh
        			sql = "select Sum(case when tax_amt is null then 0 else tax_amt end) as bond_tax_amt " + 
    						"from   taxtran Where  tran_code = 'D-RCP' " + 
    						" and tran_id = '" + tranID + "' " + 
    						" and line_no = '" + lineNo + "' " + 
    						" and tax_code IN ( select tax_code from tax where tax_group in ( " + bondTaxGroup + ")) ";
        			pstmt1 = conn.prepareStatement(sql);
            		rs1 = pstmt1.executeQuery();
            		if(rs1.next())
            		{
            			bondTaxAmt = rs1.getInt("bond_tax_amt");
            		}
            		rs1.close();
            		rs1 = null;
            		pstmt1.close();
            		pstmt1 = null;
            		if(bondTaxAmt!=0)
            		{
            			bondValue=0;
            			sql= "select bond_no, case when bond_value is null then 0 else bond_value end as bond_value, " +
            					"case when bank_guarantee is null then 0 else bank_guarantee end as bank_guarantee " +
            					"from b17_bond where site_code = ? and ? >= eff_from and ? <= valid_upto " +
            					"and case when confirmed is null then 'N' else confirmed end = 'Y' and bond_type = 'B' ";
            			pstmt1 = conn.prepareStatement(sql);
            			pstmt1.setString( 1, siteCode );
            			pstmt1.setTimestamp(2, tranDate);
            			pstmt1.setTimestamp(3, tranDate);
                		rs1 = pstmt1.executeQuery();
                		if(rs1.next())
                		{
                			bondNo = rs1.getInt("bond_no");
                			bondValue = rs1.getInt("bond_value");
                			bankGuarantee = rs1.getInt("bank_guarantee");
                		}
                		rs1.close();
                		rs1 = null;
                		pstmt1.close();
                		pstmt1 = null;
                			//if( bankGuarantee < (bondNo + bondTaxAmt) ) //commented by azhar[31/JAN/2017]
                		if( bankGuarantee < (bondValue + bondTaxAmt) ) //added by azhar[31/JAN/2017]
                			{
                				//TODO
                				//errString = itmDBAccessLocal.getErrorString("", "VTB17ERR2", ""); // commented by azhar[31/JAN/2017]
                			errString = itmDBAccessEJB.getErrorString("", "VTB17ERR2", "");  //added by azhar[31/JAN/2017]
                				return errString;
                			}
                			else
                			{
                				bondValueFinal = bondValue + bondTaxAmt;
                				sql="update b17_bond set bond_value = "+bondValueFinal+" where bond_no = "+bondNo+" ";
                				pstmt1 = conn.prepareStatement(sql);
                				upd = pstmt1.executeUpdate();
            					System.out.println("b17_bond upd::::::"+upd);
            					pstmt1.close();
            					pstmt1 = null;
                			}
                		
                		
            		}
        		}
				//added by saurabh-18/10/16[end]
				//Added By umakanta on 17-OCT-2016[ To hold Stock information ]Start
			}
            rs.close();
			pstmt.close();
            stkUpdMap.clear();
			if("Y".equalsIgnoreCase(qcReqd))
			{
				errString = createQCOrder(tranID,siteCode,xtraParams,conn);
			}

			/////////////////////////////////////////
		   if(errString ==null || errString.indexOf("Error") == -1)
			{
				sql ="select 	line_no	,	dist_order	,line_no_dist_order,item_code, "
					+" quantity	,	unit, loc_code	, pack_code	, "
					+" rate	, 	lot_no	, 	lot_sl		, 	mfg_date, "
					+" exp_date	, site_code__mfg	, 	potency_perc, gross_weight, "
					+" net_weight,tare_weight	, pack_instr,batch_no, "
					+" grade	, 	dimension	, 	supp_code__mfg 	,	net_amt, no_art ,pallet_wt"
					+ " from 	distord_rcpdet where tran_id = ? order by line_no" ;
				//System.out.println("sql-------------"+sql);
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranID);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					lineNo=rs.getString("line_no");
					distOrder=rs.getString("dist_order");
					lineNoDistOrder=rs.getInt("line_no_dist_order");
					itemCode=rs.getString("item_code");
					quantity=rs.getDouble("quantity");
					unit=rs.getString("unit");
					locCode=rs.getString("loc_code");
					packCode=rs.getString("pack_code");
					rate=rs.getDouble("rate");
					lotNo=rs.getString("lot_no");
					lotSl=rs.getString("lot_sl");
					mfgDate=rs.getTimestamp("mfg_date");
					expDate=rs.getTimestamp("exp_date");
					siteCodeMfg=rs.getString("site_code__mfg");
					potencyPerc=rs.getDouble("potency_perc");
					grossWeight=rs.getDouble("gross_weight");
					netWeight=rs.getDouble("net_weight");
					tareWeight=rs.getDouble("tare_weight");
					packInstr=rs.getString("pack_instr");
					batchNo=rs.getString("batch_no");
					grade=rs.getString("grade");
					dimension=rs.getString("dimension");
					suppCodeMfg=rs.getString("supp_code__mfg");
					netAmt=rs.getDouble("net_amt");
					noArt=rs.getLong("no_art");
					palletWt=rs.getDouble("pallet_wt");

					itemSer = getItemSer(itemCode,siteCode, tranDate,conn);
					sql ="select inv_stat from location where loc_code = ? " ;
					//System.out.println("sql-------------"+sql);

					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1,locCodeGit);
					rs1 = pstmt1.executeQuery();
					if(rs1.next())
					{
						invStat=rs1.getString("inv_stat");
					}
					rs1.close();
					rs1 = null;
					pstmt1.close();
					pstmt1 = null;
					if(tranIdIss != null &&	tranIdIss.trim().length() > 0)
					{
						sql ="select loc_code from distord_issdet where tran_id = ? "
							 +" and  	item_code = ? "
							 +" and  	lot_no = ? "
							 +" and  	lot_sl = ? " ;
						//System.out.println("sql-------------"+sql);

						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1,tranID);
						pstmt1.setString(2,itemCode);
						pstmt1.setString(3,lotNo);
						pstmt1.setString(4,lotSl);
						rs1 = pstmt1.executeQuery();
						if(rs1.next())
						{
							locCodeIss=rs1.getString("loc_code");
						}
						rs1.close();
						rs1 = null;
						pstmt1.close();
						pstmt1 = null;
					}
					else
					{
						locCodeIss = locCode;
					}
					sql ="select acct_code__inv	,	cctr_code__inv		, acct_code__oh	,	cctr_code__oh	, "
						 +" unit__alt		, 	conv__qty_stduom	, retest_date"
						 +" from  stock a "
						 +" where a.item_code = ? "
						 +" and	a.loc_code = ? "
						 +" and a.lot_no = ? "
						 +" and a.lot_sl = ? " ;
					//System.out.println("sql-------------"+sql);
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1,itemCode);
					pstmt1.setString(2,locCodeIss);
					pstmt1.setString(3,lotNo);
					pstmt1.setString(4,lotSl);
					rs1 = pstmt1.executeQuery();

					if(rs1.next())
					{
						acctCodeInv = rs1.getString("acct_code__inv");
						cctrCodeInv = rs1.getString("cctr_code__inv");
						acctCodeOh  = rs1.getString("acct_code__oh");
						cctrCodeOh  = rs1.getString("cctr_code__oh");
						unitAlt      = rs1.getString("unit__alt");
						convQtyStduom = rs1.getDouble("conv__qty_stduom");
						retestDate    = rs1.getTimestamp("retest_date");
					}
					rs1.close();
					rs1 = null;
					pstmt1.close();
					pstmt1 = null;
					if(unitAlt == null|| unitAlt.trim().length() < 0 )
					{
						unitAlt = unit;
					}
					if(convQtyStduom < 1)
					{
						convQtyStduom = 1;
					}
					lineNo = "   "+lineNo.trim() ;
					lineNo = lineNo.substring(lineNo.length()-3);
					sql ="select case when sum(reco_amount) is null then 0 else sum(reco_amount) end "
						 +" from   taxtran  where  tran_code = 'D-RCP' and    tran_id   = ? "
						 +" and line_no = ? ";
					//System.out.println("sql-------------"+sql);
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1,tranID);
					pstmt1.setString(2,lineNo);
					rs1 = pstmt1.executeQuery();
					if(rs1.next())
					{
						recoAmount=rs1.getDouble(1);

					}
					rs1.close();
					pstmt1.close();
					if((netAmt - recoAmount) > 0 && quantity > 0)
					{
						rate = ( (netAmt - recoAmount) / quantity  ) ;
					}
					if(netAmt > 0 && quantity > 0)
					{
						grossRate = netAmt / quantity ;
					}
					sql ="select grp_code from item where item_code = ? " ;
					//System.out.println("sql-------------"+sql);
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1,itemCode);
					rs1 = pstmt1.executeQuery();
					if(rs1.next())
					{
						grpCode=rs1.getString("grp_code");
					}
					rs1.close();
					rs1 = null;
					pstmt1.close();
					pstmt1 = null;
					
					acctDetrDistTtype = finCommon.getAcctDetrDistTtype(siteCodeShip,siteCode,itemSer,grpCode,itemCode,"D-ISS", tranType,conn) ;
					if (acctDetrDistTtype != null && acctDetrDistTtype.trim().length() > 0)
					{
						acctCodeIss = acctDetrDistTtype.substring(0,acctDetrDistTtype.indexOf(","));
						cctrCodeIss = acctDetrDistTtype.substring(acctDetrDistTtype.indexOf(",")+1);
					}
					System.out.println("acctCodeIss.....D-ISS........" + acctCodeIss);
					System.out.println("cctrCodeIss.....D-ISS........" + cctrCodeIss);
					if(acctCodeInv ==null || acctCodeInv.trim().length() ==0 )
					{
						acctDetrDistTtype = finCommon.getAcctDetrDistTtype(siteCodeShip,siteCode,itemSer,grpCode,itemCode,"D-INV", tranType,conn) ;
						if (acctDetrDistTtype != null && acctDetrDistTtype.trim().length() > 0)
						{
							acctCodeInv = acctDetrDistTtype.substring(0,acctDetrDistTtype.indexOf(","));
							cctrCodeInv = acctDetrDistTtype.substring(acctDetrDistTtype.indexOf(",")+1);
						}
						System.out.println("acctCodeInv.....D-INV........" + acctCodeInv);
						System.out.println("cctrCodeInv.....D-INV........" + cctrCodeInv);
					}
					if(acctCodeInv ==null || acctCodeInv.trim().length() ==0 )
					{
						acctDetrTtype = finCommon.getAcctDetrTtype(itemCode,itemSer,"STKINV", tranType,conn) ;
						if (acctDetrTtype != null && acctDetrTtype.trim().length() > 0)
						{
							acctCodeInv = acctDetrTtype.substring(0,acctDetrTtype.indexOf(","));
							cctrCodeInv = acctDetrTtype.substring(acctDetrTtype.indexOf(",")+1);
						}
						System.out.println("acctCodeInv.....STKINV........" + acctCodeInv);
						System.out.println("cctrCodeInv.....STKINV........" + cctrCodeInv);
					}
					if(acctCodeInv ==null || acctCodeInv.trim().length() ==0 )
					{
						acctCodeInv =" ";
						cctrCodeInv = " ";
					}

					stkUpdMap.put("site_code",siteCode);
					stkUpdMap.put("item_code",itemCode);
					stkUpdMap.put("sorderno",distOrder);
					stkUpdMap.put("loc_code",locCode);
					stkUpdMap.put("lot_no",lotNo);
					stkUpdMap.put("lot_sl",lotSl);
					stkUpdMap.put("unit",unit);
					stkUpdMap.put("quantity",Double.toString(quantity));
					stkUpdMap.put("qty_stduom",Double.toString(quantity));
					stkUpdMap.put("tran_type","R");
					stkUpdMap.put("tran_date",tranDate);
					stkUpdMap.put("tran_ser","D-RCP");
					stkUpdMap.put("tran_id",tranID);
					stkUpdMap.put("line_no",lineNo);
					stkUpdMap.put("locationcode",locCodeGit);
					stkUpdMap.put("rate",Double.toString(rate));
					stkUpdMap.put("gross_rate",Double.toString(grossRate));
					stkUpdMap.put("gross_weight",Double.toString(grossWeight));
					stkUpdMap.put("net_weight",Double.toString(netWeight));
					stkUpdMap.put("tare_weight",Double.toString(tareWeight));
					stkUpdMap.put("pallet_wt",Double.toString(palletWt));
					stkUpdMap.put("exp_date",expDate);
					stkUpdMap.put("item_ser",itemSer);
					//added by azhar[START][29-APR-2017]
					siteCodeMfg = siteCodeMfg == null ? "" : siteCodeMfg;
					stkUpdMap.put("site_code__mfg",siteCodeMfg); 
					stkUpdMap.put("unit__alt",unitAlt);
					//added by azhar[END][29-APR-2017]
					stkUpdMap.put("pack_code",packCode);
					stkUpdMap.put("pack_instr",packInstr);
					stkUpdMap.put("potency_perc",Double.toString(potencyPerc));
					stkUpdMap.put("inv_stat",invStat);
					stkUpdMap.put("batch_no",batchNo);
					stkUpdMap.put("dimension",dimension);
					//stkUpdMap.put("supp_code__mfg",siteCodeMfg); // commented by azhar[28-APR-2017] supp code mfg should be set instead of site code mfg
					stkUpdMap.put("supp_code__mfg",checkNullAndTrim(suppCodeMfg)); // changed by azhar[28-APR-2017] supp code mfg should be set instead of site code mfg
					stkUpdMap.put("mfg_date",mfgDate);
					stkUpdMap.put("acct_code_inv",acctCodeInv);
					stkUpdMap.put("cctr_code_inv",cctrCodeInv);
					stkUpdMap.put("rate_oh",Double.toString(0));
					stkUpdMap.put("acct_code_oh",acctCodeOh);
					stkUpdMap.put("cctr_code_oh",cctrCodeOh);
					stkUpdMap.put("no_art",Double.toString(noArt));
					stkUpdMap.put("conv__qty_stduom",Double.toString(convQtyStduom));
					stkUpdMap.put("retest_date",retestDate);
					stkUpdMap.put("grade",grade);
					stkUpdMap.put("acctcodecr",acctCodeIss);
					stkUpdMap.put("cctrcodecr",cctrCodeIss);
					// Modified  By Umakanta Das on 17-OCT-2016[]Start
					stkUpdMap.put( "hold_lock","N" );
					
					if ( holdQtyList != null && holdQtyList.size() > 0 )
					{
						for ( HashMap<String, String> resultMap : holdQtyList ) 
						{
						
		                     holdQtyIss = Double.parseDouble( (String) resultMap.get("hold_qty") );
		                     siteCodeIss = (String) resultMap.get("site_code");
		                     itemCodeIss = (String) resultMap.get("item_code");
		                     locCodeIss1 = (String) resultMap.get("loc_code");
		                     lotNoIss = (String) resultMap.get("lot_no");
		                     lotSlIss = (String) resultMap.get("lot_sl");
		                    if ( itemCodeIss.equals( itemCode ) &&  lotNoIss.equals( lotNo ) ) 
		                    {
		                    	if ( holdQtyIss > 0 )
		                    	{
		                    		stkUpdMap.put("hold_qty", Double.toString( quantity ) );
		                    		// Doubt Need to Discuss with Manoj.
		                    		//sql =" Select a.tran_id as holdTranId From inv_hold a, inv_hold_det b , inv_hold_rel_trace c " //commented by azhar[31/JAN/2017]
		                    		sql =" select a.tran_id as holdTranId,a.lock_code as lock_code From inv_hold a, inv_hold_det b , inv_hold_rel_trace c " //added by azhar[31/JAN/2017]
		                    				+ " Where a.tran_id = b.tran_id "
		                    				+ " And b.tran_id = c.ref_no "
		                    				+ " And c.item_code  = ? "
		                    				+ " And (c.site_code = ? OR c.site_code is null ) "
		                    				+ " And c.loc_code  = ? "
		                    				+ " And c.lot_no    = ? "
		                    				+ " And c.lot_sl    = ? "
		                    				+ " And b.lot_no    = ? "
		                    				+ " And (b.line_no_sl = 0 or b.line_no_sl is null) "
		                    				+ " And a.confirmed='Y' "
		                    				+ " And b.hold_status ='H' " ;
		                    		//System.out.println("sql-------------"+sql);
		                    		pstmt1 = conn.prepareStatement(sql);
		                    		pstmt1.setString(1,itemCodeIss);
		                    		
		                    		//commented by azhar[31/JAN/2017][START]
		                    		//pstmt1.setString(2,siteCodeIss);//Changed by manoj dtd 19/10/2016 to use siteCodeIss instead of siteCode
		                    		//commented by azhar[31/JAN/2017][END]
		                    		
		                    		pstmt1.setString(2,siteCode);//added by azhar[31/JAN/2017][START]
		                    		
		                    		pstmt1.setString(3,locCodeIss1);
		                    		pstmt1.setString(4,lotNoIss);
		                    		pstmt1.setString(5,lotSlIss);
		                    		pstmt1.setString(6,lotNoIss);
		                    		rs1 = pstmt1.executeQuery();
		                    		if(rs1.next())
		                    		{
		                    			holdTranId= checkNullAndTrim(rs1.getString("holdTranId"));
		                    			lockCodeNew =  checkNullAndTrim(rs1.getString("lock_code"));//added by azhar[31/JAN/2017]
		                    		}
		                    		closeResources(pstmt1, rs1);
		                    		// Doubt Need to Discuss with Manoj.
		                    		//Added by saurabh 18/10/16[Start]
		                    		/* Commented by Manoj dtd 19/10/2016 as per PB component
									sql=" update inv_hold_det set loc_code = ?, site_code = ? Where tran_id = ? " +
		                    				"And item_code = ? And lot_no = ? And lot_sl = ? " +
		                    				"And loc_code = ? And hold_status ='H' ";
		                    		pstmt1 = conn.prepareStatement(sql);
		                    		pstmt1.setString( 1, locCode );
		                    		pstmt1.setString( 2, siteCode );
		                    		pstmt1.setString( 3, holdTranId );
		                    		pstmt1.setString( 4, itemCodeIss );
		                    		pstmt1.setString( 5, lotNoIss );
		                    		pstmt1.setString( 6, lotSlIss );
		                    		pstmt1.setString( 7, locCodeIss1 );
		                    		upd = pstmt1.executeUpdate();
		                    		pstmt1.close();
		                    		pstmt1 = null;*/
		                    		//Added by saurabh 18/10/16[end]
		                    		
		                    		//commented by azhar[31/JAN/2017][START]
		                    		/*sql ="update inv_hold_rel_trace set loc_code = ?, site_code = ? Where ref_no = ? "
		                    				+ " And site_code   = ? " 
		                    				+ " And item_code   = ? "
		                    				+ " And lot_no      = ? "
		                    				+ " And lot_sl      = ? "
		                    				+ " And loc_code    = ? "
		                    				+ " And hold_qty    > 0 " ;
		                    		
		                    		pstmt1 = conn.prepareStatement(sql);
		                    		pstmt1.setString( 1, locCode );
		                    		pstmt1.setString( 2, siteCode );
		                    		pstmt1.setString( 3, holdTranId );//Need to Discuss with Manoj
		                    		pstmt1.setString( 4, siteCodeIss );
		                    		pstmt1.setString( 5, itemCodeIss );
		                    		pstmt1.setString( 6, lotNoIss );
		                    		pstmt1.setString( 7, lotSlIss );
		                    		pstmt1.setString( 8, locCodeIss1 );
		                    		upd = pstmt1.executeUpdate();
		                    		pstmt1.close();
		                    		pstmt1 = null;*/
		                    		
		                    		//commented by azhar[31/JAN/2017][END]
		                    		
		                    		//added by azhar[31/JAN/2017][START]
		                    		sql = "update inv_hold_rel_trace set hold_qty = hold_qty - ? where ref_no = ? " +
		                    				"and site_code = ? and item_code = ? and lot_no = ?" +
		                    				" and lot_sl = ? and loc_code = ? and hold_qty > 0 ";
		                    		
		                    		pstmt1 = conn.prepareStatement(sql);
		                    		pstmt1.setDouble( 1, quantity);
		                    		pstmt1.setString( 2, holdTranId );
		                    		pstmt1.setString( 3, siteCode );
		                    		pstmt1.setString( 4, itemCodeIss);
		                    		pstmt1.setString( 5, lotNoIss );
		                    		pstmt1.setString( 6, lotSlIss );
		                    		pstmt1.setString( 7, locCodeIss1 );
		                    		upd = pstmt1.executeUpdate();
		                    		pstmt1.close();
		                    		pstmt1 = null;
		                    		//added by azhar [31/JAN/2017][END]
		                    		
		                    		stkUpdMap.put( "hold_lock","Y" );
		                    	}
		                    	else
		                    	{
		                    		stkUpdMap.put( "hold_qty", 0 );
		                    	}
		                    }
						}        
					}
					// Modified By Umakanta Das on 17-OCT-2016[]End
					StockUpdate stkUpd =  new StockUpdate();
					errString = stkUpd.updateStock(stkUpdMap,xtraParams,conn);
					System.out.println("Returning Result "+errString);
					if (errString != null && errString.trim().length() > 0 && errString.indexOf("Error") != -1 )
					{
						return errString;
					}
					
					//added by azhar[31/JAN/2017][START]
					
					int countHold = 0,updHold = 0;
					loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "site_code");
					System.out.println("login site ocde:::" + loginSiteCode);
					if(stkUpdMap.get("hold_lock").toString().equalsIgnoreCase("Y")){
						System.out.println("inside hold lock loop::");
						sql = "select count (*) as count from inv_hold a, inv_hold_det b , inv_hold_rel_trace c where a.tran_id = b.tran_id and " +
								"b.tran_id = c.ref_no and c.item_code  = ? and c.site_code = ? and c.loc_code = ? and c.lot_no = ? and c.lot_sl = ?" +
								" and (b.line_no_sl = 0 or b.line_no_sl is null) and a.confirmed='Y' and b.hold_status ='H' and a.lock_code =?";
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1, itemCode);
						pstmt1.setString(2, siteCode);
						pstmt1.setString(3, locCode);
						pstmt1.setString(4, lotNo);
						pstmt1.setString(5, lotSl);
						pstmt1.setString(6, lockCodeNew);
						rs1= pstmt1.executeQuery();
						if(rs1.next()){
							countHold = rs1.getInt("count");
						}
						System.out.println("count hold ::" + countHold);
						closeResources(pstmt1, rs1);
						 
						if(countHold > 0){
							sql = "update inv_hold_rel_trace set hold_qty = hold_qty + ? where ref_no = ? and item_code = ? and site_code = ? and loc_code = ? " +
									"and lot_no = ? and lot_sl = ?";
							pstmt1 = conn.prepareStatement(sql);
							pstmt1.setDouble(1, quantity);
							pstmt1.setString(2, holdTranId);
							pstmt1.setString(3, itemCode);
							pstmt1.setString(4, siteCode);
							pstmt1.setString(5, locCode);
							pstmt1.setString(6, lotNo);
							pstmt1.setString(7, lotSl);
							updHold = pstmt1.executeUpdate();
						}else{
							String xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
							xmlValues = xmlValues + "<Header></Header>";
							xmlValues = xmlValues + "<Detail1>";
							xmlValues = xmlValues + "<tran_id></tran_id>";
							xmlValues = xmlValues + "<site_code>"+loginSiteCode+"</site_code>";
							xmlValues = xmlValues + "<tran_date>"+getCurrdateAppFormat()+"</tran_date>";
							xmlValues = xmlValues + "</Detail1></Root>";
							  tranIdHoldTrace = generateTranId("w_inv_hold_rel_trace",xmlValues,conn);//function to generate NEW transaction id
							System.out.println("tranIdHoldTrace......"+tranIdHoldTrace);
							if(tranIdHoldTrace == null || tranIdHoldTrace.trim().length() ==0)
							{
								errCode = "VTTRANID";
								System.out.println("errcode......"+errCode);
								errString = itmDBAccessEJB.getErrorString("","VTTRANID","BASE","",conn);
								return errString;
							}else{
								sql = "insert into inv_hold_rel_trace(tran_id,item_code,site_code,loc_code,lot_no,lot_sl,ref_no,hold_qty,lock_code)" +
								   "values(?,?,?,?,?,?,?,?,?)";
								pstmt1 = conn.prepareStatement(sql);
								pstmt1.setString(1, tranIdHoldTrace);
								pstmt1.setString(2, itemCode);
								pstmt1.setString(3, siteCode);
								pstmt1.setString(4, locCode);
								pstmt1.setString(5, lotNo);
								pstmt1.setString(6, lotSl);
								pstmt1.setString(7, holdTranId);
								pstmt1.setDouble(8, quantity);
								pstmt1.setString(9, lockCodeNew);
								pstmt1.executeUpdate();
							}
						}	
					}
					closeResources(pstmt1, rs1);
					//added by azhar[31/JAN/2017][END]
					
					stkUpd =  null;
					stkUpdMap.clear();
					sql ="select tran_type__parent from distorder_type where tran_type = ? ";
					//System.out.println("sql-------------"+sql);
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1,tranType);
					rs1 = pstmt1.executeQuery();
					if(rs1.next())
					{
						tranTypeParent=rs1.getString("tran_type__parent");
					}
					rs1.close();
					rs1 = null;
					pstmt1.close();
					pstmt1 = null;
					if(tranType.trim().equalsIgnoreCase(tranTypeParent))
					{
						sql ="update distorder_det set qty_received = case when qty_received is null then 0 else qty_received end + '"+quantity+"' "
							 +" where  dist_order = ? "
							 +" and    line_no = ? ";
						//System.out.println("sql-------------"+sql);
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1,distOrder);
						pstmt1.setInt(2,lineNoDistOrder);
						upd = pstmt1.executeUpdate();
						pstmt1.close();
						pstmt1 = null;
					}
				}
				rs.close();
				pstmt.close();
				stkUpdMap.clear();
				//Modified By Umakanta on 17-OCT-2016[ To get QUARNTINE_LOCKCODE and generateHoldTrans ]Start
				System.out.println("qcReqd:::::"+qcReqd+"holdQty:::"+holdQty);
				if ( "Y".equalsIgnoreCase(qcReqd) && holdQty > 0 )
				{
					quarLockCode = checkNullAndTrim(distCommon.getDisparams("999999", "QUARNTINE_LOCKCODE", conn));
					System.out.println("quarLockCode:::::::"+quarLockCode);
					//if( quarLockCode.length() > 0 ) //commented by azhar[31/JAN/2017]
					if( quarLockCode.length() > 0 && !quarLockCode.equalsIgnoreCase("NULLFOUND")) // added by azhar[31/JAN/2017]
					{
						sql ="select count(*) as count from distord_rcpdet where tran_id = ? ";
						//System.out.println("sql-------------"+sql);
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString( 1, tranID);
						rs1 = pstmt1.executeQuery();
						if(rs1.next())
						{
							cnt = rs1.getInt("count");
						}
						System.out.println("cnt::::"+cnt);
						rs1.close();
						rs1 = null;
						pstmt1.close();
						pstmt1 = null;
						if ( cnt > 0 )
						{
							sql ="select a.site_code, b.item_code, b.loc_code, b.lot_no, b.lot_sl from distord_rcp a , distord_rcpdet b "
									+ " where a.tran_id = ? and a.tran_id = b.tran_id ";
							//System.out.println("sql-------------"+sql);
							pstmt1 = conn.prepareStatement(sql);
							pstmt1.setString( 1, tranID );
							rs1 = pstmt1.executeQuery();
							while( rs1.next() )
							{
								siteCodeDRcp = rs1.getString("site_code");
								itemCodeDRcp = rs1.getString("item_code");
								locCodeDRcp = rs1.getString("loc_code");
								lotNoDRcp = rs1.getString("lot_no");
								lotSlDRcp = rs1.getString("lot_sl");
								
								//added by azhar[31/JAN/2017][START]
								sql = "select qc_lock_reqd from qc_xfr_ctrl where item_code = ? and site_code = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,itemCode);
								pstmt.setString(2,siteCode);
								rs = pstmt.executeQuery();
								if(rs.next()){
									qcLockReqd = checkNullAndTrim(rs.getString("qc_lock_reqd"));
								}
								
								closeResources(pstmt, rs);
								
								if(qcLockReqd.equalsIgnoreCase("Y")) {
									
								sql = "select count(*) as count from qc_xfr_ctl_det where site_code = ? and item_code = ? and" +
										" (? >= lot_no__from and ? <= lot_no__to ) and (? >= from_date and ? <= to_date  ) ";
								
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,siteCode);
								pstmt.setString(2,itemCode);
								pstmt.setString(3, lotNo);
								pstmt.setString(4, lotNo);
								pstmt.setTimestamp(5, tranDate);
								pstmt.setTimestamp(6, tranDate);
								rs = pstmt.executeQuery();
								if(rs.next()){
									countXfr = rs.getInt("count");
								}
								
								closeResources(pstmt, rs);
								
								}
								if(countXfr > 0){
									lbQcLock = true;
									stockQtyMap.put( "hold_qty", holdQty );
									stockQtyMap.put( "site_code", siteCodeDRcp );
									stockQtyMap.put( "item_code", itemCodeDRcp );
									stockQtyMap.put( "loc_code", locCodeDRcp );
									stockQtyMap.put( "lot_no", lotNoDRcp );
									stockQtyMap.put( "lot_sl", lotSlDRcp );
									stockList.add( stockQtyMap );
								}
								//added by azhar[31/JAN/2017][END]
								
								
								//commented by azhar[31/JAN/2017][START]
								
								/*stockQtyMap.put( "hold_qty", holdQty );
								stockQtyMap.put( "site_code", siteCodeDRcp );
								stockQtyMap.put( "item_code", itemCodeDRcp );
								stockQtyMap.put( "loc_code", locCodeDRcp );
								stockQtyMap.put( "lot_no", lotNoDRcp );
								stockQtyMap.put( "lot_sl", lotSlDRcp );
								stockList.add( stockQtyMap );*/
								
								//commented by azhar[31/JAN/2017][END]
							}
							closeResources(pstmt1, rs1);							
							//errString = invHoldGen.generateHoldTrans(quarLockCode, tranID, "P-RCP", siteCode, stockList, xtraParams, conn); //commented by azhar[31/JAN/2017]
							
							//added by azhar[31/JAN/2017][START]
							if(lbQcLock){
							errString = invHoldGen.generateHoldTrans(quarLockCode, tranID, "D-RCP", siteCode, stockList, xtraParams, conn);
							}
							//added by azhar[31/JAN/2017][END]
						}
					}
				}
				//Modified By Umakanta on 17-OCT-2016[]End
			}
		 //Modified by mayur on 03-JAN-2018[START]
			
			if(errString ==null || errString.indexOf("Error") == -1)
			{
				InvAcct invacct =  new InvAcct();
				errString = invacct.acctDisRcptPost(tranID,conn);	
				System.out.println("Returning Result "+errString);
			}			
			//Modified by mayur on 03-JAN-2018[END]
			
		   
            if(errString !=null && errString.indexOf("Error") != -1)
			{
                System.out.println("Returning Result "+errString);
                conn.rollback();
                return errString;
            }

            System.out.println("errString : "+errString);
			String empCodeAprv = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			System.out.println("empCodeAprv ................ "+empCodeAprv);
			sql = "update distord_rcp set confirmed = 'Y',conf_date = ? ,emp_code__aprv = ? where tran_id = ? ";
			//System.out.println("SQL : "+sql);
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1,new Timestamp(System.currentTimeMillis()));
			pstmt.setString(2,empCodeAprv);
			pstmt.setString(3,tranID);
			upd =0;
			upd = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;
			System.out.println("distord_rcp Confirm :: "+upd);
			int countDet = 0;
			if(upd > 0)
			{
				//added by azhar[31/JAN/17][START]
				sql = "select count(*) as count from distorder_det where dist_order = ? and (qty_confirm > qty_shipped or qty_confirm > qty_received)";
				pstmt= conn.prepareStatement(sql);
				pstmt.setString(1, distOrder);
				rs = pstmt.executeQuery();
				if(rs.next()){
					countDet = rs.getInt("count");
				}

				if(countDet > 0){
					status = "P";
				}else{
					status = "C";
				}
				
				sql = "update distorder set status = ? where dist_order = ? ";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,status);
				pstmt.setString(2,distOrder);
				upd =0;
				upd = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				System.out.println("distorder status update :: "+upd);
				
				//added by azhar[31/JAN/17][END]
				
				//commented by azhar[31/JAN/2017][START]
				
				/*sql = "update distorder set status = 'C' where dist_order = ? ";
				//System.out.println("SQL : "+sql);
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,distOrder);
				upd =0;
				upd = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				System.out.println("distorder status update :: "+upd);*/
				
				//commented by azhar[31/JAN/2017][END]
				
				//errString = itmDBAccessEJB.getErrorString("","VTDIST30","");
				//System.out.println("distord_rcp Confirmed .."+errString);

			}
			
			
			//added by azhar[31/JAN/2017][START]
			sql = "select count(*) as count from distorder_alloc where dist_order = '"+distOrder+"'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next()){
				count = rs.getInt("count");
			}
			
			if(count > 0){
				errString = allocateStockWorkOrder(distOrder,xtraParams,tranID,conn);
				 System.out.println("Error String after errString"+errString);
			}
			//added by azhar[31/JAN/2017][END]
			
			//Changed by wasim on 20-11-2015 for work order allocation for AWMS [START]
			//commented by azhar[31/JAN/2017][START]
			 /*errString = allocateStockWorkOrder(distOrder,xtraParams,tranID,conn);
			 System.out.println("Error String after errString"+errString);*/
			//commented by azhar[31/JAN/2017][END]
			
			 /*if(errString !=null && errString.indexOf("Error") != -1)
			 {
	              conn.rollback();
	              return errString;
			 }
			 
			 else
			 {
				 errString = itmDBAccessEJB.getErrorString("","VTCONF","","",conn);
			 }*/
			//Changed by wasim on 20-11-2015 for work order allocation for AWMS [START]
			 if((errString !=null && errString.indexOf("Error") != -1) || (errString != null && errString.trim().length() > 0))
			 {
	              conn.rollback();
	              return errString;
			 }
			 else
			 {
				 errString = itmDBAccessEJB.getErrorString("","VTCONF","","",conn);
			 }
			
			
			
        }catch(ITMException ie)
		{
            System.out.println("ITMException : "+ie);
            try{conn.rollback();}catch(Exception t){}
            ie.printStackTrace();
            errString = itmDBAccessEJB.getErrorString("","VTDESNCONF","","",conn);
            System.out.println("Returnng String From DistOrderRcpConfEJB :"+errString);
            return errString;
        }catch(Exception e){
            System.out.println("Exception in Confirm [DistOrderRcpConfEJB]"+e);
            try{conn.rollback();}catch(Exception t){}
            e.printStackTrace();
            errString = itmDBAccessEJB.getErrorString("","VTDESNCONF","","",conn);
            System.out.println("Returnng String From DistOrderRcpConfEJB :"+errString);
            return errString;
        }
		finally
		{
            try{
                stkUpdMap = null;
                if(rs != null){rs.close();rs = null;}
                if(rs1 != null){rs1.close();rs1 = null;}
				/*if(conn != null)
				{
					conn = null;
				}*/
            }catch(Exception e){System.out.println("Exception : "+e);e.printStackTrace();}
        }
        System.out.println("Returnng String From DistOrderRcpConfEJB :"+errString);
        return errString;
	}
    //Changes done by mayur on 3-1-18 [END]
	private String getItemSer(String itemCode,String siteCode,Timestamp tranDate,Connection conn)
	{
		String itemSer ="",sql ="";
		PreparedStatement pstmt =null;
		ResultSet rs =null;
		try
		{
			sql ="select item_ser from siteitem where site_code = ? and  "
				 +" item_code = ?  ";
			//System.out.println("sql-------------"+sql);
			pstmt =   conn.prepareStatement(sql);
			pstmt.setString(1,siteCode);
			pstmt.setString(2,itemCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemSer=rs.getString("item_ser");
			}
			rs.close();
			pstmt.close();
			if(itemSer == null || itemSer.trim().length() == 0)
			{
				sql ="select item_ser from itemser_change where  "
					 +" item_code = ? and "
					 +"	eff_date <= ? and (	valid_upto > = ? or valid_upto is null )	";
				//System.out.println("sql-------------"+sql);
				pstmt =   conn.prepareStatement(sql);
				pstmt.setString(1,itemCode);
				pstmt.setTimestamp(2,tranDate);
				pstmt.setTimestamp(3,tranDate);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					itemSer=rs.getString("item_ser");
				}
				rs.close();
				pstmt.close();
			}
			if(itemSer == null || itemSer.trim().length() == 0)
			{
				sql ="select item_ser__old from itemser_change where  "
					 +" item_code = ? and "
					 +"	eff_date <= ? and (	valid_upto > =? or valid_upto is null )	"
					 +" and eff_date = ( select min(eff_date) from itemser_change where item_code = ? )";
				//System.out.println("sql-------------"+sql);
				pstmt =   conn.prepareStatement(sql);
				pstmt.setString(1,itemCode);
				pstmt.setTimestamp(2,tranDate);
				pstmt.setTimestamp(3,tranDate);
				pstmt.setString(4,itemCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					itemSer=rs.getString("item_ser");
				}
				rs.close();
				pstmt.close();
			}
			if(itemSer == null || itemSer.trim().length() == 0)
			{
				sql ="select item_ser from item where  "
					 +" item_code = ? ";
				//System.out.println("sql-------------"+sql);
				pstmt =   conn.prepareStatement(sql);
				pstmt.setString(1,itemCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					itemSer=rs.getString("item_ser");
				}
				rs.close();
				pstmt.close();
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception ::" +sql+ e.getMessage() + ":");
			e.printStackTrace();
		}

	   return itemSer;

	}
	private String generateTranId(String windowName,String xmlValues,Connection conn)
	{
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			String sql = "",errCode ="",errString ="";
			String tranId = null;
			String newKeystring = "";
			String srType = "RS";
			boolean found =false;
		    ITMDBAccessEJB itmDBAccessEJB = null;
			 try
			 {
				itmDBAccessEJB = new ITMDBAccessEJB();
				sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE UPPER(TRAN_WINDOW)=UPPER(?)";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,windowName);
				rs = pstmt.executeQuery();
				System.out.println("keyString :"+rs.toString());
				String tranSer1 = "";
				String keyString = "";
				String keyCol = "";
				if (rs.next())
				{
					found =true;
					keyString = rs.getString(1);
					keyCol = rs.getString(2);
					tranSer1 = rs.getString(3);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(!found)
				{
					  sql ="SELECT key_string,TRAN_ID_COL, REF_SER from transetup where tran_window = 'GENERAL' ";
					  pstmt	=  conn.prepareStatement(sql);
					  rs = pstmt.executeQuery();
					  if (rs.next())
					  {
						keyString = rs.getString(1);
						keyCol = rs.getString(2);
						tranSer1 = rs.getString(3);
					  }
					  rs.close();
					  rs = null;
					  pstmt.close();
					  pstmt = null ;
				}
				if(keyString ==null || keyString.trim().length() ==0)
				{
					errCode = "VTSEQ";
					System.out.println("errcode......"+errCode);
					errString = itmDBAccessEJB.getErrorString("","VTSEQ","BASE","",conn);

				}
				System.out.println("keyString=>"+keyString);
				System.out.println("keyCol=>"+keyCol);
				System.out.println("tranSer1"+tranSer1);

				System.out.println("xmlValues  :["+xmlValues+"]");

				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
				tranId = tg.generateTranSeqID(tranSer1, keyCol, keyString, conn);

				System.out.println(" new tranId :"+tranId);
				if(rs!=null)
				 {
					rs.close();
				 }
				 if(pstmt!=null)
				 {
					pstmt.close();
				 }
			}
			catch(SQLException ex)
			{
				System.out.println("Exception ::" +sql+ ex.getMessage() + ":");
				ex.printStackTrace();
				tranId=null;
			}
			catch(Exception e)
			{
				System.out.println("Exception ::" + e.getMessage() + ":");
				e.printStackTrace();
				tranId=null;
			}
			return tranId;
	}//generateTranTd()
	private String createQCOrder(String tranId,String SiteCode,String xtraParams,Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null,pstmt1 = null,pstmt2 = null;
		ResultSet rs = null,rs1 = null,rs2 = null;
		Timestamp expDate = null,mfgDate = null,dueDate =null, retestDate = null;;
		String itemCode ="",lotSl = "",	unit = "",locCode ="",lotNo = "",batchNo = "",suppCodeMfg = "",generateLotNo = "",lotNoOld = "",batchNoOld = "";
		String qcReqd ="",itemSer = "",sql ="",errString ="",userId ="",errCode = "",suppCode = "";
		String qcNo ="",locCodeAprv ="",locCodeRej ="",empCode ="",sqlInsert ="",siteCodeShip = "";
		HashMap qcUpdMap = null	;
		double quantity =0,qtySample =0,qcLeadTime =0;
		double qcleadtimeSiteitem =0,qcCycleTime =0,qcLeadTimeItem =0;
		int ctr = 0,upd =0,count = 0;
		String geneLotNo = "";
		String generateLot= "";
		String lineNo = "";
		ITMDBAccessEJB itmDBAccessEJB = null;
		String tranSer = "D-RCP";
		//GenericUtility genericUtility = null;
		try
		{
			itmDBAccessEJB = new ITMDBAccessEJB();
			//genericUtility = GenericUtility.getInstance();
			E12GenericUtility genericUtility = new E12GenericUtility();
			
			//added by azhar[31/JAN/2017][START]
			sql = "select site_code__ship from distord_rcp where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if(rs.next()){
				siteCodeShip = checkNullAndTrim(rs.getString("site_code__ship"));
			}
			System.out.println("sitecode ship::" + siteCodeShip);
			
			closeResources(pstmt, rs);
			
			sql = "select supp_code from site where site_code = '" +siteCodeShip+"'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next()){
				suppCode = checkNullAndTrim(rs.getString("supp_code"));
			}
			System.out.println("supp code::" + suppCode);
			
			closeResources(pstmt, rs);
			
			//added by azhar[31/JAN/2017][END]
			
			//commented by azhar[31/JAN/2017][START]
			/*sql = "select  item_code, sum(quantity) ,count(1), max(lot_sl),  max(unit), loc_code, "
				 +" (CASE		WHEN lot_no IS NULL THEN ' '		ELSE lot_no 	END ) as lot_no, "
				 +" min(exp_date),(CASE 	WHEN batch_no IS NULL THEN ' '	ELSE batch_no 	End ) as batch_no,  "
				 +" Min(line_no), min(mfg_date) from distord_rcpdet where  tran_id = ? "
				 +" Group by loc_code, item_code, lot_no, batch_no"
				 +" Order by loc_code, item_code, lot_no, batch_no";*/
			
			//commented by azhar[31/JAN/2017][END]
			
			//added by azhar[31/JAN/2017][START]
			sql = "select item_code,sum(quantity) ,count(1), max(lot_sl), max(unit),loc_code," +
				"(CASE WHEN lot_no IS NULL THEN ' '	ELSE lot_no END ) as lot_no," +
				" min(exp_date)," +
				"(CASE 	WHEN batch_no IS NULL THEN ' ' ELSE batch_no End) as batch_no," +
				" Min(line_no), min(mfg_date) , min(retest_date), supp_code__mfg from distord_rcpdet where  tran_id = ?" +
				" Group by loc_code, item_code, lot_no, batch_no , supp_code__mfg" +
				" Order by loc_code, item_code, lot_no, batch_no , supp_code__mfg";
			
			//added by azhar[31/JAN/2017][END]
			
			//System.out.println("sql..........."+sql);
			pstmt =  conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				itemCode = rs.getString(1);
				quantity = rs.getDouble(2);
				ctr = rs.getInt(3);
				lotSl = rs.getString(4);
				unit = rs.getString(5);
				locCode = rs.getString(6);
				lotNo = rs.getString(7);
				expDate = rs.getTimestamp(8);
				batchNo = rs.getString(9);
				lineNo = rs.getString(10);
				mfgDate = rs.getTimestamp(11);
				retestDate = rs.getTimestamp(12);  // added by azhar[31/JAN/2017]
				suppCodeMfg = checkNullAndTrim(rs.getString("supp_code__mfg")); // added by azhar[31/JAN/2017]
				
				lotNoOld = lotNo; //added by azhar[02/MAR/2017]
				batchNoOld = batchNo; //added by azhar[02/MAR/2017]
				System.out.println("lot no old::" + lotNoOld+":;batch no old["+batchNoOld+"]");
				
				
				
				if(ctr > 0)
				{
					lotSl ="";
				}
				
				//added by azhar[31/JAN/2017][START]
				sql = "select  QTY_SAMPLE, QC_REQD ,PROC_MTH ,spec_ref from siteitem where site_code = ? and item_code = ?" ;
				pstmt1 =  conn.prepareStatement(sql);
				pstmt1.setString(1,SiteCode);
				pstmt1.setString(2,itemCode);
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					  qtySample	 = rs1.getDouble("QTY_SAMPLE");
					 
				}else{
					sql = "select  qty_sample,qc_reqd,proc_mth from item where item_code = ?";
					pstmt2 =  conn.prepareStatement(sql);
					pstmt2.setString(1,itemCode);
					rs2 = pstmt1.executeQuery();
					if (rs2.next())
					{
						  qtySample	 = rs2.getDouble("QTY_SAMPLE");
						  //qcReqd = rs1.getString("QC_REQD");
					}
					
				}
				closeResources(pstmt1,rs1);
				closeResources(pstmt2,rs2);
				
				
				
				if(suppCodeMfg.length() == 0){
					sql = "select count(*) as count from item_lot_info where item_code = ? and lot_no = ?";
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1, itemCode);
					pstmt1.setString(2, lotNo);
					rs1 = pstmt1.executeQuery();
					if(rs1.next()){
//						count = rs.getInt("count");
						count = rs1.getInt("count");
					}
					closeResources(pstmt1, rs1);
					if(count > 0){
						
						sql = "select supp_code__mfg,supp_code from item_lot_info where item_code = ? and lot_no = ?";
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1, itemCode);
						pstmt1.setString(2, lotNo);
						rs1 = pstmt1.executeQuery();
						if(rs1.next()){
							suppCodeMfg = checkNullAndTrim(rs.getString("supp_code__mfg"));
							System.out.println("supp code mfg:::" + suppCodeMfg);
						}
						
						closeResources(pstmt1, rs1);
						
						if(suppCodeMfg.length() == 0){
						sql = "select supp_code__mfg from stock where item_code = ? and site_code = ? and loc_code  = ? and lot_no =? and lot_sl = ?";	
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1, itemCode);
						pstmt1.setString(2, SiteCode);
						pstmt1.setString(3, locCode);
						pstmt1.setString(4, lotNo);
						pstmt1.setString(5, lotSl);
						rs1 = pstmt1.executeQuery();
						if(rs1.next()){
							suppCodeMfg = checkNullAndTrim(rs.getString("supp_code__mfg"));
							System.out.println("supp code mfg from stock in if condition:::" + suppCodeMfg);
						}
						}
						closeResources(pstmt1, rs1);
					}else{
						
						sql = "select supp_code__mfg from stock where item_code = ? and site_code = ? and loc_code  = ? and lot_no =? and lot_sl = ?";	
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1, itemCode);
						pstmt1.setString(2, SiteCode);
						pstmt1.setString(3, locCode);
						pstmt1.setString(4, lotNo);
						pstmt1.setString(5, lotSl);
						rs1 = pstmt1.executeQuery();
						if(rs1.next()){
							suppCodeMfg = checkNullAndTrim(rs.getString("supp_code__mfg"));
							System.out.println("supp code mfg from stock in if condition:::" + suppCodeMfg);
						}
						}
					closeResources(pstmt1, rs1);
					}
				//added by azhar[31/JAN/2017][END]
				
				
				//commented by azhar[31/JAN/2017][START]
				
				/*sql = "select  QTY_SAMPLE, QC_REQD  "
				 +" from siteitem "
				 +" where site_code = ? "
				 +" and  item_code  = ? "  ;
				pstmt1 =  conn.prepareStatement(sql);
				pstmt1.setString(1,SiteCode);
				pstmt1.setString(2,itemCode);
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					  qtySample	 = rs1.getDouble("QTY_SAMPLE");
					  //qcReqd = rs1.getString("QC_REQD");
				}
				else
				{
					sql = "select  QTY_SAMPLE, QC_REQD  "
					 +" from item "
					 +" Where item_code  = ? " ;
					pstmt1 =  conn.prepareStatement(sql);
					pstmt1.setString(1,itemCode);
					rs1 = pstmt1.executeQuery();
					if (rs1.next())
					{
						  qtySample	 = rs1.getDouble("QTY_SAMPLE");
						  //qcReqd = rs1.getString("QC_REQD");
					}
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;*/
				
				//commented by azhar[31/JAN/2017][END]
				if(batchNo == null || batchNo.trim().length() ==0)
				{
					batchNo = lotNo;
				}
				
				sql = "select qc_reqd from distorder_type where tran_type in " +
					"(select tran_type from distorder where dist_order in(select dist_order from distord_rcp where tran_id = ?))"; //TODO
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, tranId);
				rs1 = pstmt1.executeQuery();
				if(rs1.next()){
					qcReqd = rs1.getString("qc_reqd");
				}
				qcReqd = qcReqd == null ? "N" : qcReqd.trim();
				
				System.out.println("qcReqd ........"+qcReqd);
				
				closeResources(pstmt1, rs1);
				
				if("Y".equalsIgnoreCase(qcReqd))
				{
					lineNo = "   "+lineNo.trim() ;
					lineNo = lineNo.substring(lineNo.length()-3);

					Calendar rightNow = Calendar.getInstance();
					java.util.Date today =new java.util.Date();
					System.out.println("today..........."+today);
					rightNow.setTime(today);
					/*sql = "select case when qc_lead_time is null then 0 else qc_lead_time end "
					 +" from item "
					 +" where  item_code  = ? " ;
					pstmt1 =  conn.prepareStatement(sql);
					pstmt1.setString(1,itemCode);
					rs1 = pstmt1.executeQuery();
					if (rs1.next())
					{
						  qcLeadTime = rs1.getDouble(1);
					}
					rs1.close();
					rs1 = null;
					pstmt1.close();
					pstmt1 = null;
					*/

					sql = "select qc_cycle_time, qc_lead_time "
					 +" from item "
					 +" where  item_code  = ? " ;
					pstmt1 =  conn.prepareStatement(sql);
					pstmt1.setString(1,itemCode);
					rs1 = pstmt1.executeQuery();
					if (rs1.next())
					{
						  qcCycleTime	 = rs1.getDouble("qc_cycle_time");
						  qcLeadTimeItem	 = rs1.getDouble("qc_lead_time");
						  qcLeadTime = qcLeadTimeItem;
					}
					rs1.close();
					rs1 = null;
					pstmt1.close();
					pstmt1 = null;

					
					rightNow.add(Calendar.DATE,(int)qcLeadTime);
					dueDate = new Timestamp(rightNow.getTimeInMillis());

					sql = "select qc_lead_time "
					 +" from siteitem "
					 +" where  item_code  = ? "
					 +" and site_code = ? " ;
					pstmt1 =  conn.prepareStatement(sql);
					pstmt1.setString(1,itemCode);
					pstmt1.setString(2,SiteCode);
					rs1 = pstmt1.executeQuery();
					if (rs1.next())
					{
						 qcleadtimeSiteitem	 = rs1.getDouble("qc_lead_time");
					}
					rs1.close();
					rs1 = null;
					pstmt1.close();
					pstmt1 = null;
					
					if(qcleadtimeSiteitem == 0)
					{
						qcLeadTime = qcLeadTimeItem;
					}
					else
					{
						qcLeadTime = qcleadtimeSiteitem;
					}
					today =new java.util.Date();
					System.out.println("today..........."+today);
					rightNow.add(Calendar.DATE,(int)qcLeadTime);
					dueDate = new Timestamp(rightNow.getTimeInMillis())	;

					sql = "select  item_ser,loc_code__aprv,loc_code__rej  "
					 +" from siteitem "
					 +" where site_code = ? "
					 +" and  item_code  = ? " ;
					pstmt1 =  conn.prepareStatement(sql);
					pstmt1.setString(1,SiteCode);
					pstmt1.setString(2,itemCode);
					rs1 = pstmt1.executeQuery();
					if (rs1.next())
					{
						  itemSer	 = rs1.getString("item_ser");
						  locCodeAprv	 = rs1.getString("loc_code__aprv") == null ? "":rs1.getString("loc_code__aprv").trim();
						  locCodeRej	 = rs1.getString("loc_code__rej") == null ? "" :rs1.getString("loc_code__rej").trim();
					}
					rs1.close();
					rs1 = null;
					pstmt1.close();
					pstmt1 = null;
					if(itemSer == null || itemSer.trim().length() ==0)
					{
						sql = "select  item_ser  "
							 +" from item "
							 +" Where item_code  = ? "	;
						pstmt1 =  conn.prepareStatement(sql);
						pstmt1.setString(1,itemCode);
						rs1 = pstmt1.executeQuery();
						if (rs1.next())
						{
							  itemSer	 = rs1.getString("item_ser");
						}
						rs1.close();
						rs1 = null;
						pstmt1.close();
						pstmt1 = null;
					}
					
					
					
					userId = genericUtility.getValueFromXTRA_PARAMS("loginCode",xtraParams);
					String xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
					xmlValues = xmlValues + "<Header></Header>";
					xmlValues = xmlValues + "<Detail1>";
					xmlValues = xmlValues + "<tran_id></tran_id>";
					xmlValues = xmlValues + "<site_code>"+SiteCode+"</site_code>";
					xmlValues = xmlValues + "<qorder_type>"+ "I" + "</qorder_type>";
					xmlValues = xmlValues + "<qorder_date>"+getCurrdateAppFormat()+"</qorder_date>";
					xmlValues = xmlValues + "<lot_no>"+lotNo+"</lot_no>";
					xmlValues = xmlValues + "<item_ser>"+itemSer+"</item_ser>";
					xmlValues = xmlValues + "</Detail1></Root>";
					qcNo = generateTranId("w_qcorder_new",xmlValues,conn);//function to generate NEW transaction id
					System.out.println("qcNo......"+qcNo);
					if(qcNo == null || qcNo.trim().length() ==0)
					{
						errCode = "VTTRANID";
						System.out.println("errcode......"+errCode);
						errString = itmDBAccessEJB.getErrorString("","VTTRANID","BASE","",conn);
						return errString;
					}
				    /*sql = "select loc_code__aprv,loc_code__rej "
						 +" from siteitem "
						 +" where site_code = '"+SiteCode+"' "
						 +" and  item_code  ='"+itemCode+"' " ;
					pstmt1 =  conn.prepareStatement(sql);
					rs1 = pstmt1.executeQuery();
					if (rs1.next())
					{
						  locCodeAprv	 = rs1.getString("loc_code__aprv") == null ? "":rs1.getString("loc_code__aprv").trim();
						  locCodeRej	 = rs1.getString("loc_code__rej") == null ? "" :rs1.getString("loc_code__rej").trim();
					}
					rs1.close();
					rs1 = null;
					pstmt1.close();
					pstmt1 = null;
					*/
					if(lotNo == null ||lotNo.trim().length() == 0 )
					{
						lotNo = qcNo;
					}
					if("W-RCP".equalsIgnoreCase(tranSer)){
						sql = "update workorder_receipt set lot_no = ? where tran_id = ?";
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1, lotNo);
						pstmt1.setString(2, tranId);
						pstmt1.executeUpdate();
					}
					if(pstmt1 != null){
					pstmt1.close();
					pstmt1 = null;
					}
					
					//added by azhar[14/FEB/2017][START]
					
					sql = "select generate_lot_no from siteitem where site_code = ? and item_code = ?";
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1, SiteCode);
					pstmt1.setString(2, itemCode);
					rs1 = pstmt1.executeQuery();
					if(rs1.next()){
						geneLotNo = checkNullAndTrim(rs1.getString("generate_lot_no"));
					}
					System.out.println("generate lot no::" + geneLotNo);
					if(geneLotNo.length() == 0){
						
						geneLotNo = "1";
					}
					
					generateLot = distCommon.getDisparams("999999","GENERATE_LOT_NO_AUTO",conn);
					System.out.println("value from disparm:::" + generateLot);
					
					if("D-RCP".equalsIgnoreCase(tranSer)){
						
						if(("Y".equalsIgnoreCase(generateLot) || "M".equalsIgnoreCase(generateLot)) && "1".equalsIgnoreCase(geneLotNo)){
							lotNo = qcNo;
						}
					}
					
					//added by azhar[14/FEB/2017][END]
					sql = "select emp_code "
						 +" from users "
						 +" where code = '"+userId+"' "	;
					pstmt1 =  conn.prepareStatement(sql);
					rs1 = pstmt1.executeQuery();
					if (rs1.next())
					{
						  empCode	 = rs1.getString("emp_code") == null ? "" :rs1.getString("emp_code").trim();
					}
					rs1.close();
					rs1 = null;
					pstmt1.close();
					pstmt1 = null;
					sqlInsert ="insert into qc_order (qorder_no,qorder_type,qorder_date,site_code,item_code, " +
						"route_code,quantity,qty_passed,qty_rejected," +
						"start_date,due_date,rel_date,porcp_no,porcp_line_no, " +
						"lot_no,lot_sl,chg_date,chg_user,chg_term,loc_code," +
						"qty_sample,status, unit,qc_create_type, batch_no,expiry_date," +
						"loc_code__aprv,loc_code__rej,unit__sample,lot_no__new,retest_date,emp_code,item_code__new ) " +
						"values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
					pstmt1 = conn.prepareStatement(sqlInsert);
					pstmt1.setString(1,qcNo);
					pstmt1.setString(2,"I");
					pstmt1.setTimestamp(3,new Timestamp(System.currentTimeMillis()));
					pstmt1.setString(4,SiteCode);
					pstmt1.setString(5,itemCode);
					pstmt1.setString(6," ");
					pstmt1.setDouble(7,quantity);
					pstmt1.setDouble(8,qtySample);
					pstmt1.setDouble(9,0);
					pstmt1.setTimestamp(10,new Timestamp(System.currentTimeMillis()));
					pstmt1.setTimestamp(11,dueDate);
					pstmt1.setTimestamp(12,new Timestamp(System.currentTimeMillis()));
					pstmt1.setString(13,tranId);
					pstmt1.setString(14,lineNo);
					pstmt1.setString(15,lotNo);
					pstmt1.setString(16,lotSl);
					pstmt1.setTimestamp(17,new Timestamp(System.currentTimeMillis()));
					pstmt1.setString(18,userId);
					pstmt1.setString(19,userId);
					pstmt1.setString(20,locCode);
					pstmt1.setDouble(21,qtySample);
					pstmt1.setString(22,"U");
					pstmt1.setString(23,unit);
					pstmt1.setString(24,"A");
					pstmt1.setString(25,batchNo);
					if(expDate == null){
						pstmt1.setNull(26,Types.TIMESTAMP);
					}else{
						pstmt1.setTimestamp(26,expDate);
					}
					pstmt1.setString(27,locCodeAprv);
					pstmt1.setString(28,locCodeRej);
					pstmt1.setString(29,unit);
					pstmt1.setString(30,lotNo);
					pstmt1.setNull(31,Types.TIMESTAMP);
					pstmt1.setString(32,empCode);
					pstmt1.setString(33,itemCode);

					int intCount = pstmt1.executeUpdate();
					System.out.println("Inserting Qc_order :"+intCount);
					pstmt1.clearParameters();
					sql = "update distord_rcpdet set lot_no = ?, batch_no = ?"
						 +" where tran_id = ? and loc_code = ? "
						 +" and item_code = ? "
						 +" and CASE  WHEN  LOT_NO IS NULL  THEN ' ' ELSE LOT_NO END  = ? "
						 +" and CASE  WHEN  BATCH_NO IS NULL  THEN ' ' ELSE BATCH_NO END  = ?";
					pstmt1 =  conn.prepareStatement(sql);
					pstmt1.setString(1,lotNo);
					pstmt1.setString(2,batchNo);
					pstmt1.setString(3,tranId);
					pstmt1.setString(4,locCode);
					pstmt1.setString(5,itemCode);
					pstmt1.setString(6,lotNoOld);
					pstmt1.setString(7,batchNoOld);

					upd = pstmt1.executeUpdate();
					pstmt1.close();
					pstmt1 = null;
				}
			} //end while
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

	}
	catch(Exception e)
	{
		errString = "Error";
		System.out.println("Exception ........"+e);
		e.printStackTrace();
		throw new ITMException(e);
	}
	return  errString;
}
private String getCurrdateAppFormat()
	{
		String s = "";
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			java.util.Date date = null;
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());
			System.out.println(genericUtility.getDBDateFormat());

			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = simpledateformat.parse(timestamp.toString());
			timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
			s = (new SimpleDateFormat(genericUtility.getApplDateFormat())).format(timestamp).toString();
		}
		catch(Exception exception)
		{
			System.out.println("Exception in  getCurrdateAppFormat " + exception.getMessage());
		}
		return s;
	}

//Changed by wasim on 20-11-2015 for work order allocation for AWMS [START]
	public String allocateStockWorkOrder(String distOrder,String xtraParams,String tranID,Connection conn) throws Exception
	{
		String saleOrder=" ", siteCode=" ", lotNo=" ", locCode="", lotSl="",sqlStock = "",expLev = "";
		double runningSupply=0,qtyReqd=0;
		String tranId="",refId="",refLineNo="",tranIdCrossDock = "",unit="",errString="",workOrder = "",sqlUpdate = "",siteCodeAlloc = "";
		double quantity=0,qtyAllocated=0,totAllocQty=0,allocQty=0, potAdj = 0;
		String sql = "",itemCode = "",remarks = "",chgTerm = "",chgUser = "",previousItem = "",refWorkOrder = "",locCodeTo = "",acctCodeInv = "",
				cctrCodeInv = "",noArt = "",siteCodeShip = "",itemCodeWorder = "", siteCodeRcp = "";
		PreparedStatement pstmt = null,pstmtStock = null,pstmtUpdate = null,pstmtInsert = null,pstmt1 = null;
		ResultSet rs= null,rsStock = null,rs1 = null;
		java.util.Date currentDate = new java.util.Date();
		java.sql.Date date = new java.sql.Date(currentDate.getTime());
		GenericUtility genericUtility = null;
		int lineNo = 0,detCnt = 0;
		String refNo = "", rcpTranId = "",siteCodeLogin = "",status = "";
		InvAllocTraceBean invAllocTrace = null;
		boolean isError = false;
		Timestamp currDate = null;
		ArrayList worderList = new ArrayList();
		HashMap hm = null;
		try
		{
			System.out.println("@@Inside allocateStockWorkOrder");
			
			currDate = getCurrtDate();
			
			genericUtility = GenericUtility.getInstance();
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			siteCodeLogin = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSite");
			
			String tranType = "AUT";
			
			
			sql = "SELECT DISTINCT H.REF_NO,h.site_code FROM CROSS_DOCK_ALLOC H, cross_dock_alloc_det d WHERE h.tran_id = d.tran_id and D.ORDER_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, distOrder);
			rs= pstmt.executeQuery();
			if(rs.next()){
				refNo = rs.getString("REF_NO");
				siteCode = rs.getString("site_code");
			}
			refNo = refNo == null ? "":refNo.trim();
			siteCode = siteCode == null ? "":siteCode.trim();
			
			//hm.put("SITE_CODE", siteCode);
			
			sql = "select work_order from workorder where work_order = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, refNo);
			rs= pstmt.executeQuery();
			if(rs.next())
			{	
				System.out.println("is workorder:::");
			//Changed by wasim on 30-06-2016 to update sql to consider  SITE_CODE, SITE_CODE__SHIP 
			sql = "SELECT DISTINCT H.REF_NO,W.ITEM_CODE FROM CROSS_DOCK_ALLOC H,CROSS_DOCK_ALLOC_DET D,WORKORDER W WHERE"
				+ " H.TRAN_ID = D.TRAN_ID AND H.REF_NO = W.WORK_ORDER AND D.ORDER_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,distOrder);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				workOrder = checkNullAndTrim(rs.getString("REF_NO"));
				
				itemCodeWorder = checkNullAndTrim(rs.getString("ITEM_CODE"));
				hm = new HashMap();
				hm.put("SITE_CODE", siteCode);
				hm.put("WORK_ORDER", workOrder);
				hm.put("ITEM_CODE", itemCodeWorder);
				
				worderList.add(hm);
			}
			}else{
				System.out.println("is campaign no:::");
				sql = "select work_order,item_code from workorder where campgn_no = ?";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, refNo);
				rs1= pstmt1.executeQuery();
				while(rs1.next()){
				
					workOrder = "";itemCodeWorder = "";
					workOrder = checkNullAndTrim(rs1.getString("work_order"));
					itemCodeWorder = checkNullAndTrim(rs1.getString("ITEM_CODE"));
					
					System.out.println("work order::::" + workOrder);
					hm = new HashMap();
					hm.put("SITE_CODE", siteCode);
					hm.put("WORK_ORDER", workOrder);
					hm.put("ITEM_CODE", itemCodeWorder);
					
					System.out.println(":::hash map:::" + hm.toString());
					worderList.add(hm);
					System.out.println(":::: array list"+worderList.toString());
				}
				
			}
			
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if(rs1 != null){rs1.close();
			rs1 = null;}
			if(pstmt != null){

				pstmt1.close();
				pstmt1 = null;	
			}
			System.out.println("firmplam changes arraylist:::" + worderList.toString());
			Iterator itr = worderList.iterator();
			System.out.println("Array List size="+worderList.size());
	
			if(worderList.size() > 0)
			{	
				while(itr.hasNext())
				{  
					HashMap detail = new HashMap();
					detail = (HashMap) itr.next();
					
					workOrder = (String) detail.get("WORK_ORDER");
					siteCode = (String) detail.get("SITE_CODE");
					itemCodeWorder = (String) detail.get("ITEM_CODE");
					
					sql = "select status from workorder where work_order = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, workOrder);
					rs = pstmt.executeQuery();
					while(rs.next()){
						 status = rs.getString("status");
					}
					System.out.println("workorder status::" + status + "for workorder::" +workOrder);
					
					if("F".equalsIgnoreCase(status) || "R".equalsIgnoreCase(status)){
					
					
					sql = " SELECT MAX(TRAN_ID) AS TRAN_ID ,max(site_code) as site_code FROM INV_ALLOCATE WHERE WORK_ORDER = ? "
							+ " AND TRAN_TYPE = 'AUT' AND CONFIRMED = 'Y' ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, workOrder);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							tranId = checkNullAndTrim(rs.getString("TRAN_ID"));
							siteCodeAlloc = checkNullAndTrim(rs.getString("site_code"));
						}
						rs.close();rs = null;
						pstmt.close();pstmt = null;
						
						System.out.println("Max Tran ID ["+tranId+"]");
						System.out.println("site_code ["+siteCodeAlloc+"]");
						
						if(tranId.length() == 0)//Insert into header if tran id not found
						{
							String xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
							xmlValues = xmlValues + "<Header></Header>";
							xmlValues = xmlValues + "<Detail1>";
							xmlValues = xmlValues +	"<tran_id></tran_id>";
							xmlValues = xmlValues + "<site_code>"+siteCode.trim()+"</site_code>";
							xmlValues = xmlValues +  "<tran_date>"+getCurrdateAppFormat()+"</tran_date>";
							xmlValues = xmlValues +  "<tran_type></tran_type>";
							xmlValues = xmlValues + "</Detail1></Root>";
							
							tranId = generateTranId( "w_inv_allocate",xmlValues, conn );
							
							sql = " INSERT INTO INV_ALLOCATE ( TRAN_ID,TRAN_DATE,TRAN_TYPE,WORK_ORDER,SITE_CODE,ITEM_CODE," +
									" CHG_DATE,CHG_USER,CHG_TERM,REMARKS,CONFIRMED,CONF_DATE,STATUS,STATUS_DATE )" +
									" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
									pstmtInsert = conn.prepareStatement(sql);
									pstmtInsert.setString(1,tranId);
									pstmtInsert.setTimestamp(2, currDate);  
									pstmtInsert.setString(3, tranType);                                                                                                                                                                                                     
									pstmtInsert.setString(4, workOrder); 
									pstmtInsert.setString(5, siteCode);                                                                                                                                                                          
									pstmtInsert.setString(6, itemCodeWorder);                                                                                                                                                                           
									pstmtInsert.setTimestamp(7, currDate);                                                                                                                                                                      
									pstmtInsert.setString(8, chgUser);                                                                                                                                                                       
									pstmtInsert.setString(9, chgTerm );                                                                                                                                                    
									pstmtInsert.setString(10, remarks);                                                                                                                                                                
									pstmtInsert.setString(11, "Y");                                                                                                                                                                         
									pstmtInsert.setTimestamp(12, currDate);                                                                                                                                                                 
									pstmtInsert.setString(13, "O");                                                                                                                                                         
									pstmtInsert.setTimestamp(14, currDate); //it should be timestamp
		
									int hdrCnt = pstmtInsert.executeUpdate();
									pstmtInsert.close();pstmtInsert = null;
						}	
						else
						{
							sql = " SELECT MAX(LINE_NO) AS LINE_NO FROM INV_ALLOCATE H,INV_ALLOC_DET D "
								 +"	WHERE H.TRAN_ID = D.TRAN_ID AND H.TRAN_ID = ? AND H.TRAN_TYPE = 'AUT' AND H.CONFIRMED = 'Y' ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tranId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									lineNo = rs.getInt("LINE_NO");
									//siteCode = rs.getString("site_code");
								}
								rs.close();rs = null;
								pstmt.close();pstmt = null;
								
						int upd = 0;
						sql = "update inv_allocate set site_code = ? where tran_id = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						pstmt.setString(2, tranId);
						 upd = pstmt.executeUpdate();
						if(upd > 0){
							System.out.println("site code updated successfully::" + upd);
						}
						}
						
						
						
						System.out.println("Max Line No ["+lineNo+"]");
						
						
						
						
						/*sql = "select d.tran_id from distord_rcp d , distord_rcpdet dt where d.tran_id = dt.tran_id and d.dist_order = ? and ";
						pstmt= conn.prepareStatement(sql);
						pstmt.setString(1, distOrder);
						rs = pstmt.executeQuery();
						while(rs.next()){
							rcpTranId = rs.getString("tran_id");
						
						rcpTranId = rcpTranId == null ? "" : rcpTranId.trim();
						System.out.println("rcp tran id:::" + rcpTranId);*/
						
						//rcp site code = cross doc det site code
						  //sqlStock = " SELECT H.REF_NO,D.EXP_LEV,D.ITEM_CODE,RCP.SITE_CODE,RCPDET.LOC_CODE,D.LOT_NO,D.LOT_SL,D.QUANTITY,D.REQ_QTY"
						  sqlStock = " SELECT H.REF_NO,D.EXP_LEV,D.ITEM_CODE,RCPDET.LOC_CODE, D.LOT_NO, D.LOT_SL," +
						  		     //"RCPDET.LOT_NO," + //changed by azhar
						  		   //" RCPDET.LOT_SL" +//changed by azhar
						  		   "D.QUANTITY,D.REQ_QTY, D.POTENCY_ADJ,D.SITE_CODE"
									+" FROM CROSS_DOCK_ALLOC H, CROSS_DOCK_ALLOC_DET D, DISTORD_RCP RCP,DISTORD_RCPDET RCPDET"
									+" WHERE H.TRAN_ID = D.TRAN_ID"
									+" AND RCP.TRAN_ID = RCPDET.TRAN_ID"
									+" AND RCP.SITE_CODE = H.SITE_CODE"
									+" AND RCPDET.LINE_NO_DIST_ORDER = D.LINE_NO__ORD " //changed by azhar
									//+" AND RCPDET.LINE_NO = D.LINE_NO__ORD "
									+" AND D.ORDER_NO = RCPDET.DIST_ORDER"
									+" AND H.REF_NO = ? and rcp.tran_id = ? and d.order_ref = ? " +
									" and d.item_code=RCPDET.item_code and d.lot_no=RCPDET.lot_no " +
									" and d.lot_sl=RCPDET.lot_sl ";
						pstmtStock = conn.prepareStatement(sqlStock);
						pstmtStock.setString(1,refNo);
						pstmtStock.setString(2,tranID);
						pstmtStock.setString(3, workOrder);
						rsStock = pstmtStock.executeQuery();
						while(rsStock.next())
						{
							expLev = rsStock.getString("EXP_LEV");
							itemCode = rsStock.getString("ITEM_CODE");
							siteCodeRcp = rsStock.getString("SITE_CODE");//rcp site code
							locCode = rsStock.getString("LOC_CODE");//rcp loc code
							lotNo = rsStock.getString("LOT_NO");
							lotSl = rsStock.getString("LOT_SL");
							qtyReqd = rsStock.getDouble("REQ_QTY");
							potAdj = rsStock.getDouble("POTENCY_ADJ");
							//quantity = rsStock.getDouble("QUANTITY");
							
							sql = "select quantity from stock where item_code = ? and site_code = ? and loc_code = ? and lot_no = ? and lot_sl = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, itemCode);
							pstmt.setString(2, siteCode);
							pstmt.setString(3, locCode);
							pstmt.setString(4, lotNo);
							pstmt.setString(5, lotSl);
							rs = pstmt.executeQuery();
							while(rs.next()){
								quantity = rs.getDouble("quantity");
							}
							System.out.println("quantity to be set:::" + quantity);
							sql = " INSERT INTO INV_ALLOC_DET ( TRAN_ID,LINE_NO,SITE_CODE,ITEM_CODE,LOT_NO,LOT_SL,QUANTITY,REMARKS,REAS_CODE," +//9
							" LOC_CODE,EXP_LEV,POTENCY_ADJ,ALLOC_QTY )" +//16
							" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?) ";
							pstmtInsert = conn.prepareStatement(sql);
	
							lineNo++;
							pstmtInsert.setString(1,tranId);
							pstmtInsert.setInt(2,lineNo);                                                                                                                                                                                
							//pstmtInsert.setString(3, siteCodeAlloc);
							//pstmtInsert.setString(3, siteCodeRcp);
							pstmtInsert.setString(3, siteCode);
							pstmtInsert.setString(4, itemCode );                                                                                                                                                                              
							pstmtInsert.setString(5, lotNo );                                                                                                                                                                       
							pstmtInsert.setString(6, lotSl );                                                                                                                                                                        
							pstmtInsert.setDouble(7, quantity);   //need to ask with sir                                                                                                                                                                           
							pstmtInsert.setString(8, remarks );                                                                                                                                                                            
							pstmtInsert.setString(9, "" );                                                                                                                                                                            
							pstmtInsert.setString(10, locCode);                                                                                                                                                                    
							pstmtInsert.setString(11, expLev);                                                                                                                                                                           
							pstmtInsert.setDouble(12, potAdj);                                                                                                                                                                     
							//pstmtInsert.setDouble(13, 0 );                                                                                                                                                                       
							//pstmtInsert.setDouble(14, 0 );                                                                                                                                                                    
							pstmtInsert.setDouble(13, qtyReqd );                                                                                                                                                                
							//pstmtInsert.setString(16, "N" ); 
	
							 detCnt = pstmtInsert.executeUpdate();
							pstmtInsert.close();
							pstmtInsert = null;	
							
							System.out.println("Data inserted in inv_alloc_det="+detCnt); 
							
							String refSer = "W-RIN" ; 
							HashMap hashMap = null;
							hashMap = new HashMap();
							hashMap.put("tran_date",date);
							hashMap.put("ref_ser",refSer);
							hashMap.put("ref_id",tranId); 
							hashMap.put("ref_line",""+lineNo);					
							hashMap.put("site_code",siteCode);
							hashMap.put("item_code",itemCode);
							hashMap.put("loc_code",locCode);
							hashMap.put("lot_no",lotNo);
							hashMap.put("lot_sl",lotSl);
							hashMap.put("alloc_qty",qtyReqd);
							hashMap.put("chg_user",chgUser);
							hashMap.put("chg_term",chgTerm);
							hashMap.put("chg_date", date );
							invAllocTrace = new InvAllocTraceBean();
							
							errString = invAllocTrace.updateInvallocTrace(hashMap, conn);
							
							System.out.println("updateInvallocTrace  1....."+errString);
	
							if ( errString != null && errString.trim().length() > 0 )
							{
								System.out.println("Rollbacking connection:");
								conn.rollback();
								return errString;
							}
							else
							{
								System.out.println("Inventory allocated successfully");
							}
						}
					}
				}
				}//End while iterator	
			if(detCnt == 0){
				errString = "Insert failed::"; 
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new Exception (e);
		}
		finally
		{
			try
			{
	    		if(pstmt != null){pstmt.close();pstmt=null;}
	    		if(pstmtInsert != null){pstmtInsert.close();pstmtInsert=null;}
				if(pstmtStock != null){pstmtStock.close();pstmtStock=null;}
				if(rs != null){rs.close();rs=null;}
				if(rsStock != null){rsStock.close();rsStock=null;}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return errString;
	}
	 private String checkNullAndTrim( String inputVal )
	 {
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	 private java.sql.Timestamp getCurrtDate() throws RemoteException,ITMException
	 {
			String currAppdate = "";
			java.sql.Timestamp currDate = null;
			GenericUtility genericUtility = GenericUtility.getInstance();
			try
			{
				Object date = null;
				currDate = new java.sql.Timestamp(System.currentTimeMillis());
				java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
				date = sdf.parse(currDate.toString());
				currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
			return (currDate);
	 }
	//Changed by wasim on 20-11-2015 for work order allocation for AWMS [END]


	 private void closeResources(PreparedStatement pstmt, ResultSet rs ){
		try {
			if(rs != null){
				rs.close();
				rs = null;
			}
			if(pstmt != null){
				pstmt.close();
				pstmt = null;
			}
		} catch (Exception e) {
			System.out.println("Exception::" + e.getMessage());
		}	
		
		
	 }
}


