package ibase.dashboard.common.hibernate.dao;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.security.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.hql.ast.origin.hql.parse.HQLParser.new_key_return;
import org.hibernate.query.Query;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.dashboard.common.hibernate.bean.Employee;
import ibase.dashboard.common.hibernate.bean.LoginTrace;
import ibase.dashboard.common.hibernate.bean.UserProfile;
import ibase.dashboard.common.hibernate.utility.HibernateUtil;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;

//6DBC5A495F0F2C5371D59DC89EB06F41
public class AccountActivityDao 
{
	private static String siteTranDB = "DEFAULT";


	public String getUserActivityData(String loginCode, String profileId)throws Exception
	{
		JSONArray activityDataFinal = new JSONArray();
		
		System.out.println("getUserActivityData>>>");
		profileId=profileId.trim();
		DateTimeFormatter formatter = DateTimeFormatter.ofPattern("YYYYMMdd");
		String today = LocalDate.now().format(formatter);
		System.out.println("today date ["+today+"]");

		DateTimeFormatter formatter1 = DateTimeFormatter.ofPattern("dd-MM-YY");
		String todayFormat = LocalDate.now().format(formatter1);
		System.out.println("today1 date ["+todayFormat+"]");
		

/*      FOR MIN MAX LOGIN TIME , LOGOUT TIME AND BATTERY STATUS
		List<Object[]> minMaxTimeList= getMinMaxTime(todayFormat);
		System.out.println("minMaxTimeList::::::: ["+minMaxTimeList+"]");
		List<Object[]> batteryStatus = getBatteryStatus(todayFormat);
		System.out.println("batteryStatus::::::: ["+batteryStatus+"]");
*/		
		if( "ADMIN".equalsIgnoreCase(profileId) || "ADM".equalsIgnoreCase(profileId)  )
		{
			List<JSONObject> fileDataList= getUserActivityFileData(null,today);
			System.out.println("getUserActivityData>>>"+ fileDataList);
			
			HashMap<String, JSONObject> minMaxTimeList= getMinMaxTime(todayFormat,null);
			
			for(JSONObject fileDataObj : fileDataList )
			{
				String userId = fileDataObj.optString("userId");
				String activityDate = fileDataObj.optString("activityDate");
				String fileContents = fileDataObj.optString("fileContents");
				System.out.println("fileName::::::::: ["+userId+"]["+activityDate+"]");

				JSONObject activityData = createActivityData(userId, fileContents);
				activityData = updateMinMaxTime(activityData, minMaxTimeList.get(userId)) ;
				activityDataFinal.put(activityData);
			}
			
			activityDataFinal = prepareAllUsersData(activityDataFinal);
			
		}
		else
		{
			List<String> userDataList = getUserDetails(loginCode,profileId);
			System.out.println("userDataList AFTER>>>"+userDataList);
			
			HashMap<String, JSONObject> minMaxTimeList= getMinMaxTime(todayFormat,userDataList);
			
			System.out.println("minMaxTimeList AFTER>>>"+minMaxTimeList);
			
			List<JSONObject> fileDataList= getUserActivityFileData(userDataList, today);
			
			JSONObject selfActivityData = null;
			JSONArray teamActivityData = new JSONArray();
			
			System.out.println("userDataList AFTER>>>"+userDataList);
			for(JSONObject fileDataObj : fileDataList )
			{
				String userId = fileDataObj.optString("userId");
				String activityDate = fileDataObj.optString("activityDate");
				String fileContents = fileDataObj.optString("fileContents");
				System.out.println("fileName::::::::: ["+userId+"]["+activityDate+"]");

				if( userId.equalsIgnoreCase(loginCode) )
				{
					selfActivityData = createActivityData(userId, fileContents);
					selfActivityData = updateMinMaxTime(selfActivityData, minMaxTimeList.get(loginCode)) ;
				}
				else
				{
					JSONObject teamMemberActivityData = createActivityData(userId, fileContents);
					teamMemberActivityData = updateMinMaxTime(teamMemberActivityData, minMaxTimeList.get(loginCode)) ;
					teamActivityData.put(teamMemberActivityData);
				}
				System.out.println("selfActivityData::::::::: ["+selfActivityData+"]");
			}
			if(fileDataList != null && fileDataList.size() > 0 )
			{
				if( selfActivityData == null )
				{
					selfActivityData = getUserDetail(new JSONObject(), loginCode);
					selfActivityData = updateMinMaxTime(selfActivityData, minMaxTimeList.get(loginCode)) ;
				}
				if(teamActivityData.length()>0){
					selfActivityData.put("TEAM", teamActivityData);				
				}
				activityDataFinal.put(selfActivityData);
			}
			
			activityDataFinal = prepareTeamUsersData(activityDataFinal);
		}
		
		System.out.println("activityDataFinal data " + activityDataFinal.toString());
		return activityDataFinal.toString();
	}

	private JSONArray prepareAllUsersData(JSONArray activityDataFinal) {
		System.out.println("Inside prepareAllUsersData ");
		
		//TO GET All Login User Data 
		return activityDataFinal;
	}

	private JSONArray prepareTeamUsersData(JSONArray activityDataFinal) {

		//TO GET Team Login User Data 
		
		return activityDataFinal;
	}

	private JSONObject updateMinMaxTime(JSONObject activityData, JSONObject minMaxTimeObj) throws JSONException
	{
		if(minMaxTimeObj != null)
	    {
	    	activityData.put("LOGIN_TIME", minMaxTimeObj.opt("loginTime"));
	    	activityData.put("LOGOUT_TIME", minMaxTimeObj.opt("logoutTime"));
			System.out.println("minMaxTimeList query result:::::::"+minMaxTimeObj);
	    }	
		return activityData;
	}
	
	private JSONObject getUserDetail(JSONObject activityData, String userCode) throws JSONException
	{
		Employee employee= getEmployeeDetail(userCode);
		if( employee != null )
		{
			activityData.put("NAME", employee.getEmpFname());
			activityData.put("DESIGNATION", employee.getDesignation());
			activityData.put("USER_ID", userCode);
		}
//	    if(minMaxTimeObj != null)
//	    {
//	    	activityData.put("LOGIN_TIME", minMaxTimeObj.opt("loginTime"));
//	    	activityData.put("LOGOUT_TIME", minMaxTimeObj.opt("logoutTime"));
//			System.out.println("minMaxTimeList query result:::::::"+minMaxTimeObj);
//	    }
		return activityData;
	}
	
	private JSONObject createActivityData(String userCode, String activityLogXml)
	{
		E12GenericUtility e12GenericUtility = new E12GenericUtility();
		ArrayList<String> objNameList = new ArrayList<String>();
		JSONObject activityData = new JSONObject();
		try 
		{
			System.out.println("Inside create activity data");
			Document activityDoc = e12GenericUtility.parseString(activityLogXml);
			
			NodeList activitySessIdNL = activityDoc.getElementsByTagName("ACTIVITY_SESSION_ID");
			
			activityData = processSessionIds( userCode, activitySessIdNL );
			
			JSONArray sessionArray = activityData.optJSONArray("ALL_SESSIONS");
			System.out.println("sessionArrayList"+sessionArray);
			
			activityData.remove("ALL_SESSIONS");
			
			NodeList activityNL = activityDoc.getElementsByTagName("ACTIVITY");

			//System.out.println("Inside getUserActivityData" + activityNL +" >> "+ activityNL.getLength() );
			if( activityNL != null && activityNL.getLength() > 0 )
			{
				int len = activityNL.getLength();
				for( int j = 0; j < len; j++)
				{
					String activityObj = "";
					String activityTitle = "";
					String activitySeesionId = "";
					String activityIcon="";
					NodeList activityChildNL = activityNL.item(j).getChildNodes();
					//System.out.println("processActivityAction i" + i);
					System.out.println("==");
					int actChLen = activityChildNL.getLength();
					//System.out.println("processActivityAction actChLen" + actChLen);
					for( int actCh = 0; actCh < actChLen; actCh++)
					{
						Node activityChildNode = activityChildNL.item(actCh);
						if( activityChildNode.getNodeType() == Node.ELEMENT_NODE)
						{
							String activityChName = activityChildNode.getNodeName();
							String activityChValue = activityChildNode.getFirstChild() != null ?  activityChildNode.getFirstChild().getNodeValue() : activityChildNode.getNodeValue();
							
							System.out.println("Inside getUserActivityData >> ["+ activityChName + "] activityChValue >>" + activityChValue + "]" );
							activityChValue = activityChValue == null ? "NA" : activityChValue;
							System.out.println("After activityChValue >>" + activityChValue + "]" );
							if( "ACTIVITY_OBJECT".equalsIgnoreCase( activityChName ) )
							{
								activityObj = activityChValue;
								//activityObj = activityChildNode.getFirstChild().getNodeValue();
								System.out.println( "activityObj[" + activityObj + "]");
								
								if(activityObj != null && objNameList.indexOf(activityObj) == -1 )
								{
									objNameList.add(activityObj);
								}
							}
							else if("ACTIVITY_ICON".equalsIgnoreCase( activityChName ))
							{
								System.out.println("inside activity icon");
								activityIcon = activityChValue.equalsIgnoreCase("NA") ?  "e12Menu.png" : activityChValue;
								System.out.println( "activityIcon [" + activityIcon +"]");
							}

							else if("ACTIVITY_TITLE".equalsIgnoreCase( activityChName ))
							{
								activityTitle = activityChValue;
								//activityTitle = activityChildNode.getFirstChild().getNodeValue();
								System.out.println( "activityTitle [" + activityTitle +"]");
							}
							else if( "ACTIVITY_SESSION_ID".equalsIgnoreCase( activityChName ) )
							{
								activitySeesionId = activityChValue;
								
								//activitySeesionId = activityChildNode.getFirstChild().getNodeValue();
     							//System.out.println(activityChName + "[" + activitySeesionId + "]");
							}
							else if( "ACTIVITY_ACTION".equalsIgnoreCase( activityChName ) )
							{
								System.out.println( "ACTIVITY_OBJECT[" + activityObj + "]");
								System.out.println( "activityTitle[" + activityTitle + "]");
								System.out.println( "ACTIVITY_SESSION_ID[" + activitySeesionId + "]");
								//System.out.println("[" + activityChildNode.getChildNodes() + "]");
								//System.out.println( processActivityAction(activityChildNode) );
								
								JSONObject activityObjData = activityData.optJSONObject(activitySeesionId);
								if( activityObjData == null )
								{
									activityObjData = new JSONObject();
								}
								
								JSONObject prevActivityObj = activityObjData.optJSONObject(activityObj);
								if( prevActivityObj == null )
								{
									prevActivityObj = new JSONObject();
								}
								
								JSONArray prevArray = prevActivityObj.optJSONArray("DATA");
								if( prevArray == null )
								{
									prevArray = new JSONArray();
								}
								//System.out.println(prevArray);
								
								prevActivityObj.put("DESCR", activityTitle);
								prevActivityObj.put("ICON", activityIcon);
								prevActivityObj.put("DATA", processActivityAction(activityChildNode, prevArray) );
								
								activityObjData.put(activityObj, prevActivityObj);
								
								activityData.put(activitySeesionId, activityObjData);
								
							}
						}
					}
				}
			}

			//System.out.println( activityData );
			JSONArray allSeesionArray = new JSONArray();
			int arrayLen = sessionArray.length();
			System.out.println("Object data "+arrayLen);
			for( int sessIdx = 0; sessIdx < arrayLen; sessIdx ++ )
			{
				String sessionId = sessionArray.optString(sessIdx);
				System.out.println("inside sessionid>>"+sessionId);
				JSONObject activityObjData = activityData.optJSONObject(sessionId);
				
				if( activityObjData == null )
				{
					activityObjData = new JSONObject();
				}
				
				JSONArray allObjectArray = new JSONArray();
				
				ArrayList<ActivityTime> objTimeArray = new ArrayList<ActivityTime>();
				for( String objName : objNameList )
				{
					JSONObject prevActivityObj = activityObjData.optJSONObject(objName);
					if( prevActivityObj != null )
					{
						JSONArray prevArray = prevActivityObj.optJSONArray("DATA");
						if( prevArray.length() > 0 )
						{
							ActivityTime totalTime = calcTotalTime(prevArray);
							
							prevActivityObj.remove("DATA");
							prevActivityObj.put("ACCESS_TIME", totalTime.toJSON());
							
							objTimeArray.add(totalTime);
						}
						prevActivityObj.put("OBJ_NAME", objName);
						
						activityObjData.remove(objName);
						allObjectArray.put(prevActivityObj);
					}
				}
				
				int len = objTimeArray.size();
		        if( len > 0 )
		        {
		        	ActivityTime objTotalTime = objTimeArray.get(0);
		        	System.out.println(" objTotalTime >>" + objTotalTime);
		        	for(int idx = 1; idx < len; idx++)
		        	{
		        		ActivityTime actTime = objTimeArray.get(idx);
		        		objTotalTime.addTime(actTime);
		        		System.out.println(" totalTime >" + idx + ">" + objTotalTime);
		        	}
		        	activityObjData.put("ACCESS_TIME", objTotalTime.toJSON());
		        }
		        
		        activityObjData.put("OBJECTS", allObjectArray);
				
				activityData.remove(sessionId);
				
				allSeesionArray.put( activityObjData );
			}
			activityData.put("SESSIONS", allSeesionArray);
			activityData.put("TEAM", new JSONArray());
			
			activityData = getUserDetail(activityData, userCode);
			
			System.out.println("activity data " + activityData.toString());
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		
		return activityData;
	}
	
/*
	private ActivityTime calcTotalTime(JSONArray prevArray) throws JSONException 
	{
		ActivityTime firstTime = null;
		
		ArrayList<ActivityTime> timeArray = new ArrayList<ActivityTime>();
		System.out.println("DATA>>>"+prevArray);
        for( int i = 0; i < prevArray.length(); i++ )
        {
        	System.out.println(i);
            JSONObject jsonObject1 = prevArray.getJSONObject(i);
            String startTime = jsonObject1.getString("ACCESS_START_TIME");
            String endTime = jsonObject1.optString("ACCESS_END_TIME");
            System.out.println("ACCESS_END_TIME>>"+endTime);
            System.out.println("ACCESS_START_TIME>>"+startTime);

            ActivityTime actTime = new ActivityTime(startTime, endTime);
            timeArray.add(actTime);
            System.out.println( "ActivityTime >> " + actTime );
        }
        
        int len = timeArray.size();
        if( len > 0 )
        {
        	firstTime = timeArray.get(0);
        	System.out.println(" firstTime >>" + firstTime);
        	for(int idx = 1; idx < len; idx++)
        	{
        		ActivityTime actTime = timeArray.get(idx);
        		firstTime.addTime(actTime);
        		System.out.println(" firstTime >" + idx + ">" + firstTime);
        	}
        }
        
		return firstTime;
	}
*/
	
	private ActivityTime calcTotalTime(JSONArray prevArray) throws JSONException 
	{

	String startTime, endTime="";
	ActivityTime actTime = new ActivityTime();
	System.out.println("Inside calcTotalTime");
	int len = prevArray.length();

	       if( len > 0 )
	       {
	       	JSONObject jsonObjectStart = prevArray.getJSONObject(0);
	       	startTime = jsonObjectStart.getString("ACCESS_START_TIME");

	       	JSONObject jsonObjectEnd = prevArray.getJSONObject( len - 1 );
	       	endTime = jsonObjectEnd.optString("ACCESS_END_TIME");

	       	System.out.println("ACCESS_START_TIME>>"+startTime);
	       	System.out.println("ACCESS_END_TIME>>"+endTime);
	       	actTime = new ActivityTime(startTime, endTime);
	       	
	       }
	       System.out.println( "ActivityTime calcTotalTime >> " + actTime );
	return actTime;
	}

	public JSONObject processSessionIds(String userCode, NodeList activitySessIdNL) throws JSONException
	{
		JSONObject activityData = new JSONObject();
		StringBuffer  sessionIds = new StringBuffer();
		JSONArray sessionArray = new JSONArray ();
		if( activitySessIdNL != null && activitySessIdNL.getLength() > 0 )
		{
			int len = activitySessIdNL.getLength();
			for( int i = 0; i < len; i++)
			{
				String activitySeesionId = null;
				
				Node activityChildNode = activitySessIdNL.item(i);
				if( activityChildNode.getNodeType() == Node.ELEMENT_NODE)
				{
					String activityChName = activityChildNode.getNodeName();
					activitySeesionId = activityChildNode.getFirstChild().getNodeValue();
					System.out.println("Inside processSessionIds >> "+ activityChName );
				}

				if(activitySeesionId != null && sessionIds.indexOf(activitySeesionId) == -1 )
				{
					sessionIds.append("'").append(activitySeesionId).append("',");
					sessionArray.put(activitySeesionId);
				}
			}
			sessionIds.append(" '' ");
			System.out.println("SessionIds::::"+sessionIds);
		}
		
		//Get Data from Logintrace
		List<LoginTrace> loginTraceList = getLogDetails(userCode, sessionIds.toString() );
		System.out.println("loginTraceList::::"+loginTraceList);
		
		for( LoginTrace loginTrace : loginTraceList )
		{
			 JSONObject activityObjData = new JSONObject();
			 System.out.println("loginTrace.getClass()>>>>"+loginTrace.getClass());
			 String activitySeesionId = loginTrace.getSessionId();

			 activityObjData.put("SESSION_ID", activitySeesionId);
			 activityObjData.put("DEVICE_TYPE", checkNull(loginTrace.getDeviceType()));
			 activityObjData.put("OS_NAME", checkNull(loginTrace.getOsName()));
			 activityObjData.put("HOST_IP", checkNull(loginTrace.getHostIp()));
			 activityObjData.put("CURRENT_GEO_POS", checkNull(loginTrace.getCurrentGeoPos()));
			 activityObjData.put("OS_VERSION", checkNull(loginTrace.getOsVersion()));
			 activityObjData.put("CLIENT_APP", checkNull(loginTrace.getClientApp()));
			 activityObjData.put("CLIENT_APP_VER",checkNull(loginTrace.getClientAppVer()));
			 activityObjData.put("LOGIN_TIME", checkNullDate(loginTrace.getLoginTime()));
			 activityObjData.put("LOGOUT_TIME", checkNullDate(loginTrace.getLogoutTime()));
			 activityObjData.put("LOGIN_BATTERY_STAT", checkNull(loginTrace.getLoginBatteryStat()));
			 activityObjData.put("LOGOUT_BATTERY_STAT",checkNull(loginTrace.getLogoutBatteryStat()));
			 
			 ActivityTime loginTime = new ActivityTime(loginTrace.getLoginTime(), loginTrace.getLogoutTime());
			 
			// int batteryStatus =loginTrace.getLoginBatteryStat()- loginTrace.getLogoutBatteryStat();
			 activityObjData.put("TOTAL_TIME", loginTime.toJSON());
			 System.out.println("TOTAL_TIME loginTime ["+ loginTime + "]");
			 System.out.println("activityData processSessionIds"+activityData);
			 activityData.put(activitySeesionId, activityObjData);
		}
		
		activityData.put("ALL_SESSIONS", sessionArray);
		System.out.println("activityData processSessionIds"+activityData);
		
		return activityData;
	}

    private  Object checkNull(Object data) {
    	if(data==null){
    		return "NA";
    	}
    	else 
    	{
    		return data;
    	}
    }
    private  Object checkNullDate(Object data) {
    	if(data==null){
    		return  new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    	}
    	else 
    	{
    		return data;
    	}
    }
    
	public List<LoginTrace> getLogDetails(String userCode, String sessionIds) 
	{
		List<LoginTrace> loginTraceList = null;
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			System.out.println("Inside getLogDetails sessionId: [" + sessionIds + "] USER CODE ["+userCode+"]");

			Query query = session.createQuery("FROM LoginTrace where userId='" + userCode + "' AND sessionId IN ( " + sessionIds + " ) ");

			System.out.println("Inside getLogDetails query: [" + query + "]");
			loginTraceList = query.getResultList();
			System.out.println("getLogDetails: loginTraceList [" + loginTraceList + "]");

			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return loginTraceList;
	}
	
	private Employee getEmployeeDetail(String userCode) 
	{
		System.out.println("Inside getUserDesignation");
		Employee employee = null;
		Employee result = new Employee();
		try {
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query

//			Query query = session.createQuery("FROM Employee WHERE empCode IN ( "
//					+ " SELECT empCode FROM UserProfile WHERE userCode='BASE'");

			
			Query query = session.createQuery("FROM Employee e WHERE e.empCode IN ( "
					+ " SELECT u.empCode "
					+ " FROM UserProfile u "
					+ " WHERE u.userCode ='"+userCode+"'"
					+ " )");
			
			System.out.println("Inside getLogDetails query: [" + query + "]");

			List<Employee> employeeDataList = query.getResultList();
			System.out.println("getLogDetails: loginTraceList [" + employeeDataList + "]");
			if( employeeDataList != null && employeeDataList.size() > 0 )
			{
				employee = employeeDataList.get(0);
			}
			
			session.close();
		} catch (HibernateException e) {
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}

		return employee;
	}
	
	public List<String> getUserDetails(String userId, String profileId) 
	{
		List<String> userDetailList = null;
		try 
		{
			// 1. Get Session object

			System.out.println("Inside getUserDetails userId: [" + userId + "]");
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select trim(CODE) from users where EMP_CODE in (SELECT emp_code FROM employee START WITH emp_code = (SELECT emp_code FROM users WHERE code = '"+userId+"') CONNECT BY prior emp_code = report_to)");
			
			System.out.println("query result>>>>>"+query);
			userDetailList = query.getResultList();
			System.out.println("query result:::::::"+userDetailList);
			System.out.println("query result:::::::"+userDetailList.size());
			
			
/*			Query query = session.createQuery("FROM UserProfile WHERE empCode IN ( "
					+ " SELECT empCode"
					+ " FROM Employee START WITH empCode =  "
					+ " ( SELECT empCode FROM UserProfile  "
					+ " WHERE userCode='"+userId+"'"
					+ " )"
					+ " CONNECT BY prior empCode = reportTo ) ");
			
			
			System.out.println("Inside getUserDetails query: [" + query + "]");
			userDetailList = query.getResultList();
			System.out.println("getLogDetails: getUserDetails [" + userDetailList + "]"); */

			session.close();

		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		System.out.println("userDetailList >>>>>>>>>"+userDetailList);
		return userDetailList;
	}

	public HashMap<String, JSONObject>  getMinMaxTime(String today, List<String> userDataList ) 
	{
		HashMap<String, JSONObject> minMaxTimeMap = new HashMap<String, JSONObject>();
		try 
		{
			// 1. Get Session object
			String whereClausePart = "";
			if(userDataList != null)
			{
				String userList = getEnclosedString(userDataList);
				whereClausePart = " and userid in("+ userList +")";
			}
			System.out.println("Inside getUserDetails userId: [" + today + "]");
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select userid, min(LOGINTIME) as LOGINTIME , max(LOGOUTTIME)as LOGOUTTIME"
					+ " from logintrace"
					+ " where to_char(LOGINTIME,'dd-MM-yy') = '"+today+"'"
					+ " and LOGIN_STATUS = 'T'"
					+ whereClausePart
					+ " group by userid");
			System.out.println("query result>>>>>"+query);
			List<Object[]>  minMaxTimeList= (List<Object[]>)query.list();
		     for(Object[] minMaxTime: minMaxTimeList){
		    	String userId = (String)minMaxTime[0];
		    	Date loginTime = (Date) minMaxTime[1];
		    	Date logoutTime = (Date) minMaxTime[2];
		    	JSONObject jsonObject = new JSONObject();
		    	jsonObject.put("loginTime", loginTime);
		    	jsonObject.put("logoutTime", logoutTime);
		    	minMaxTimeMap.put(userId, jsonObject);
		    	
				System.out.println("minMaxTimeList query result:::::::"+minMaxTimeList.size());
				System.out.println("minMaxTimeList query id::::::: ["+userId+"] jsonObject ["+jsonObject+"]");
		     }
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println("minMaxTimeMap >>>>>>>>>"+minMaxTimeMap);
		return minMaxTimeMap;
	}

	public List<Object[]> getBatteryStatus(String today) 
	{
		List<Object[]> batteryStatusList = null;
		try 
		{
			// 1. Get Session object

			System.out.println("Inside getUserDetails userId: [" + today + "]");
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select A.userid, to_char(A.LOGINTIME,'dd-MM-yy hh24:mi:ss') IN_TIME, "
					+ " to_char(A.LOGOUTTIME,'dd-MM-yy hh24:mi:ss') OUT_TIME, "
					+ " A.LOGIN_BATTERY_STAT, "
					+ " A.LOGOUT_BATTERY_STAT"
					+ " from logintrace A,"
					+ " ("
					+ " select userid, min(LOGINTIME) as LOGINTIME , max(LOGOUTTIME)as LOGOUTTIME"
					+ " from logintrace"
					+ " where to_char(LOGINTIME,'dd-MM-yy') = '"+today+"'"
					+ " and LOGIN_BATTERY_STAT is not null "
					+ " and LOGOUT_BATTERY_STAT is not null"
					+ " group by userid"
					+ " )B"
					+ " where A.userid= B.userid"
					+ " and ( A.LOGINTIME = B.LOGINTIME"
					+ " or A.LOGOUTTIME = B.LOGOUTTIME )"
					+ " order by A.userid, A.LOGINTIME"
					+ "");

			batteryStatusList= (List<Object[]>)query.list();
		     for(Object[] batteryStatus: batteryStatusList){
		    	 String id = (String)batteryStatus[0];
		    	 String loginTime = (String) batteryStatus[1];
		    	 System.out.println("batteryStatusList query result:::::::"+batteryStatusList.size()+"] userid ["+id);
		    	 System.out.println("batteryStatusList query result ID ["+id+"] loginTime ["+loginTime+"]");
		     }

			session.close();

		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		System.out.println("batteryStatusList >>>>>>>>>"+batteryStatusList.toString());
		return batteryStatusList;
	}
	
	public JSONArray processActivityAction(Node activityChildNode, JSONArray eventArray) throws JSONException
	{
		if( activityChildNode != null )
		{
			NodeList activityActionNL = activityChildNode.getChildNodes();
			
			int actActionLen = activityActionNL.getLength();
			for( int actActionCh = 0; actActionCh < actActionLen; actActionCh++)
			{
				Node activityActionNode = activityActionNL.item(actActionCh);
				if( activityActionNode.getNodeType() == Node.ELEMENT_NODE)
				{
					String activityActionName = activityActionNode.getNodeName();
					//System.out.println("Inside processActivityAction >> "+ activityActionName );
					if( "EVENT_ID".equalsIgnoreCase( activityActionName ) )
					{
						eventArray.put( processEvent(activityActionNode) );
					}
				}
			}
		}
		return eventArray;
	}

	public  JSONObject processEvent(Node activityActionNode) throws JSONException
	{
		JSONObject eventObj = new JSONObject();
		if( activityActionNode != null )
		{
			NodeList eventNL = activityActionNode.getChildNodes();
			
			int eventLen = eventNL.getLength();
			for( int eventId = 0; eventId < eventLen; eventId++)
			{
				Node eventChNode = eventNL.item(eventId);
				if( eventChNode.getNodeType() == Node.ELEMENT_NODE)
				{
					String eventChName = eventChNode.getNodeName();
					String eventChValue = eventChNode.getFirstChild() != null ?  eventChNode.getFirstChild().getNodeValue() : eventChNode.getNodeValue();
					//System.out.println("Inside getUserActivityData >1212> "+ eventChNode.getNodeName() );
					if( "ACCESS_START_TIME".equalsIgnoreCase( eventChName ) )
					{
						//System.out.println( new Date (eventChValue));
						//System.out.println( eventChName + "[" + eventChValue + "]");
						eventObj.put(eventChName, eventChValue);
					}
					else if( "ACCESS_END_TIME".equalsIgnoreCase( eventChName ) )
					{
						//System.out.println(eventChName + "[" + eventChValue + "]");
						eventObj.put(eventChName, eventChValue);
					}
				}
			}
		}
		return eventObj;
	}
	
//	public List<JSONObject> getUserActivityFileData(List<String> users, String fromDate, String toDate) throws IOException, JSONException
//	{
	public List<JSONObject> getUserActivityFileData(List<String> users, String today) throws IOException, JSONException
	{		
		List<JSONObject> filesArrayList = new ArrayList<JSONObject>();
		String jbossPath=CommonConstants.JBOSSHOME;
		System.out.println("CommonConstants.JBOSSHOME ["+CommonConstants.JBOSSHOME+"]");
		File userActivityFolder = new File(jbossPath+"/server/default/UserActivity");
		System.out.println("userActivityFolder ["+userActivityFolder+"] Users "+users+"]");
		if( userActivityFolder.isDirectory() )
		{
			File[] userActivityFiles = userActivityFolder.listFiles(new FileFilter() {
				@Override
				public boolean accept(File pathname) {
					return pathname.getName().endsWith(today+".txt");
				}
			});
			
			for(File userActivityFile: userActivityFiles )
			{
				String fileName = userActivityFile.getName();
				//System.out.println("userActivityFile[" + fileName + "]");
				
				fileName = fileName.replace(".txt", "");
				
				//System.out.println("userActivityFile[" + fileName + "]");
				
				String[] fileArr = fileName.split("_");
				String userId = ( fileArr.length > 0 ) ? fileArr[0] : "SYSTEM";
				String activityDate = ( fileArr.length > 1 ) ? fileArr[1] : today;
				System.out.println("userActivityFile[" + userId + "]["+activityDate+"]");
				
				JSONObject fileData = new JSONObject();
				fileData.put("userId", userId);
				fileData.put("activityDate", activityDate);
				
				if( users == null || ( users != null && users.contains(userId) ) )
				{
					String fileContents =  FileUtils.readFileToString(userActivityFile);
					StringBuffer fileContentsBuff = new StringBuffer();
					fileContentsBuff.append("<ROOT>");
					fileContentsBuff.append(fileContents);
					fileContentsBuff.append("</ROOT>");
					fileData.put("fileContents", fileContentsBuff.toString());
					
					filesArrayList.add(fileData);
				}
				
				System.out.println(fileData.toString().length() + "\n");
			}
		}
		return filesArrayList;
	}

	private String getEnclosedString(List<String> docIdList) 
	{
		StringBuffer buffer = new StringBuffer();
		int len = 0;
		for(String docId : docIdList)
		{
			buffer.append("'").append(docId.trim()).append("'");
			len++;
			if( len < docIdList.size() )
			{
				buffer.append(",");
			}
		}
		if( buffer.length() == 0 )
		{
			buffer.append("''");
		}
		System.out.println("Inside getEnclosedString buffer: [" + buffer +"]");
		
		return buffer.toString();
	}

/*
	private JSONArray processData(JSONArray activityDataFinal)
	{
	   for( var activity of accData )
	   {
	       processActData(activity);
	   }
	   return activityDataFinal;
	}

	private void processActData(JSONObject activity)
	{
	   //CLIENT_APP , DEVICE_TYPE
	   //console.log('activity', activity);
	   if( activity.optJSONArray("SESSIONS") != null && activity.optJSONArray("SESSIONS").length() > 0)
	   {
	       //console.log('SESSIONS', activity.SESSIONS.length);
		   int len = activity.optJSONArray("SESSIONS").length();
	       for(int idx = 0; idx < len; idx ++)
	       {
	    	   JSONObject session = activity.optJSONArray("SESSIONS").optJSONObject(idx);
	           String deviceType = session.DEVICE_TYPE.toUpperCase();
	           String clientApp = session.CLIENT_APP.toUpperCase();
	           //console.log('activity.NAME', activity.NAME,'session.DEVICE_TYPE', session.DEVICE_TYPE,'session.CLIENT_APP', session.CLIENT_APP);
	           DATA[deviceType].TOTAL = checkIntNull( DATA[deviceType].TOTAL ) + 1;
	           DATA[deviceType][clientApp] = checkIntNull( DATA[deviceType][clientApp] ) + 1;
	           //console.log('DATA',deviceType, clientApp, DATA[deviceType].TOTAL, DATA[deviceType][clientApp]);
	       }
	   }
	   if( activity.TEAM && activity.TEAM.length > 0)
	   {
	       //console.log('TEAM', activity.TEAM.length);
	       processData(activity.TEAM);
	   }
	}
	*/

}

class ActivityTime implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;
	
	long seconds = 0;
    long minutes = 0;
    long hours = 0;
	
    public ActivityTime()
    {
    	
    }
    
	public ActivityTime(String startTime, String endTime) 
	{
		 SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.");
		 Date d1 = null;
         Date d2 = null;
         
         try 
         {
             d1 = format.parse(startTime);
             d2 = format.parse(endTime);
             long diff = d2.getTime() - d1.getTime();

             this.seconds = diff / 1000 % 60;
             this.minutes = diff / (60 * 1000) % 60;
             this.hours = diff / (60 * 60 * 1000);
             //System.out.println("diff: " + diff );
         } 
         catch (ParseException e) 
         {
             e.printStackTrace();
         }
         
         //System.out.println("Time in : " + this.seconds + " seconds.");
         //System.out.println("Time in : " + this.minutes + " minutes.");
         //System.out.println("Time in : " + this.hours + " hours.");
         
	}
	
	public ActivityTime(Date startTime, Date endTime) 
	{
         try 
         {
             long diff = endTime.getTime() - startTime.getTime();

             this.seconds = diff / 1000 % 60;
             this.minutes = diff / (60 * 1000) % 60;
             this.hours = diff / (60 * 60 * 1000);
             //System.out.println("diff: " + diff );
         } 
         catch (Exception e) 
         {
             e.printStackTrace();
         }
         
         //System.out.println("Time in : " + this.seconds + " seconds.");
         //System.out.println("Time in : " + this.minutes + " minutes.");
         //System.out.println("Time in : " + this.hours + " hours.");
         
	}
	
	public void addTime(ActivityTime time)
	{
		System.out.println("addTime :1:time[" + time + "]this[" + this + "]" ); 
		this.seconds = this.seconds + time.seconds;
		if(this.seconds > 59)
		{
			this.seconds = this.seconds % 60;
			long mins = this.seconds / 60;
			this.minutes = this.minutes + mins;
			System.out.println("this.seconds > 59 ::" + this.seconds ); 
		}
		
		this.minutes = this.minutes + time.minutes;
		if(this.minutes > 59)
		{
			this.minutes = this.minutes % 60;
			long hrs = this.minutes / 60;
			this.hours = this.hours + hrs;
			System.out.println("this.minutes > 59 ::" + this.minutes ); 
		}
		
		this.hours = this.hours + time.hours;
		if(this.hours >= 23) //Should not come here
		{
			System.out.println("this.hours >= 23 ::" + this.hours ); 
		}
		
		System.out.println("addTime :2:time[" + time + "]this[" + this + "]" ); 
	}
	
	public JSONObject toJSON()
	{
		JSONObject jObj = new JSONObject();
		try 
		{
			jObj.put("hours", this.hours);
			jObj.put("minutes", this.minutes);
			jObj.put("seconds", this.seconds);
		}
		catch (JSONException e) 
		{
			e.printStackTrace();
		}
		return jObj;
	}
	
	public String toString()
	{
		return this.toJSON().toString();
	}
}

// select designation from employee where emp_code in(SELECT emp_code FROM USERS
// WHERE CODE='BASE');
// http://192.168.0.220:9090/ibase/plugin/api/logintrace/6DBC5A495F0F2C5371D59DC89EB06F41
