/**
 * 
 */
package ibase.webitm.webService;

import java.io.BufferedReader;
import java.io.Console;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import NetComponents.SocketOutputStream;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import ibase.webitm.webService.ejb.ExtServiceRemote;
import jdk.nashorn.internal.ir.BreakableNode;
import ibase.webitm.webService.ejb.GmailPluginEJBRemote;


/** provide services to gmail chrome extension plugin
 * @author Samadhan pawar
 *
 */
@Path("/gmailplugin")
public class GmailPluginService 
{
	private UserInfoBean userInfo = null;
	private E12GenericUtility genericUtility = new E12GenericUtility();
	String redirectUri = "";
	String clientId = "";
	String clientSecret = "";
	
	/**
	 * Get External Service Data
	 * 
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getemailcontext")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getEmailContext(@QueryParam("refresh_token") String refreshToken,@QueryParam("thread_id") String threadId,@QueryParam("is_msg_id") String isMsgId,@Context HttpServletRequest request) throws BaseException, Exception
	{
		JSONObject responseJson = new JSONObject();
		JSONObject resultJson = new  JSONObject();
		try 
		{
			String result = "";
			String authStatus = "";

			//authStatus = getAuthStatus( request, userCode, password, "", "I", isPwdEncrypt );
			authStatus = "VALID";
			if ( "VALID".equalsIgnoreCase( authStatus ) )
			{
				System.out.println("Refresh token:"+refreshToken);
				System.out.println("Thread id:"+threadId);
				System.out.println("Message id:"+isMsgId);


				String accessToken = getAccTknFrmRfreshTkn(refreshToken);

				if(isMsgId.equalsIgnoreCase("True"))
				{
					threadId = getThreadId(threadId,accessToken);
					System.out.println("thread id of mulitple mseesges"+threadId);
				}
				System.out.println("get Email json");         
				resultJson = getEmailJson(threadId, accessToken);
				System.out.println("get Email json");
				org.json.JSONArray messagesArr = (org.json.JSONArray) resultJson.get("messages");
				System.out.println("Meassge length "+messagesArr.length());
				for (int j = 0; j < messagesArr.length(); j++) 
				{
					JSONObject currentMsg = (JSONObject) messagesArr.get(j);
					System.out.println("currentMsg"+currentMsg);
					String body = currentMsg.getString("body");
					System.out.println("body    "+body);
					String beforeWrote;
				 	String afterWrote;
				  
					if(body.contains("wrote"))
					{
						String[] abc=body.split("wrote");
					 	 beforeWrote = abc[0];
					 	 afterWrote = abc[1];
					 	 
					 	System.out.println("beforeWrote "+beforeWrote);
					 	System.out.println("Afterroten "+afterWrote);
					}else
					{
						beforeWrote=body;
					}
					if(beforeWrote.contains("E12ERPTrasnaction"))
					{
						String[] splited = beforeWrote.split("=");
					/*	System.out.println("splited (0)      "+splited[0]);
						System.out.println("splited  (1)      "+splited[1]);*/
						String splitString = splited[1];
						String removeQuotes = splitString.replace("\"", "").trim();
						System.out.println("removeQuotes      "+removeQuotes);
						String[] colonSplit = removeQuotes. split("\\s+");
					/*	System.out.println("colonSplit[0]      "+colonSplit[0]);
						System.out.println("colonSplit[1]      "+colonSplit[1]);
						System.out.println("colonSplit[2]      "+colonSplit[2]);*/
						String action = colonSplit[0] ;
						String objName = colonSplit[1];
						String pkValues ;
						String objAction;
						System.out.println("action      "+action);
						System.out.println("objName      "+objName);
					
						if(action.equalsIgnoreCase("Add"))
						{
							objAction="A";
							pkValues="";

						}else
							if(action.equalsIgnoreCase("View")){
								objAction="V";
								pkValues = colonSplit[2];
							}else
							{
								objAction="E";
								pkValues = colonSplit[2];
							}
						System.out.println("objAction      "+objAction);
						System.out.println("pkValues      "+pkValues);
						System.out.println("start of  form action add sales order" );
						currentMsg.put("action", action);
						currentMsg.put("objName",objName);
						currentMsg.put("objType","T");
						currentMsg.put("objAction",objAction);
						currentMsg.put("pkValues",pkValues);
						currentMsg.put("actionLabel", action + " " + objName);
						//System.out.println("end of  form action add sales order" );

					}
					else
					{
     					System.out.println("start of  form action add Add to Customer" );
						currentMsg.put("action", "Add");
						currentMsg.put("objName","strg_customer");
						currentMsg.put("objType","T");
						currentMsg.put("objAction","A");
						currentMsg.put("pkValues","");
						currentMsg.put("actionLabel","Add to Customer");
						System.out.println("end of  form action add Add to Customer" );



					}	
					
				
			}
			System.out.println("reaching to successs");

			responseJson.put( "status", "success" );


		}
			else
			{
				responseJson.put( "status", "error" );
			}
			System.out.println("returing result");
			responseJson.put("result", resultJson);
			
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : GmailPluginService : "+ e.getMessage() );
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("result json in get Emailcontex "+responseJson);
		return Response.status(200).entity( responseJson.toString() ).build();
	}
	
	
	
	@GET
	@Path("/getContactDetail")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getDetail(@QueryParam("refresh_token") String refreshToken,@QueryParam("email_id") String emailId,@QueryParam("name") String name,@Context HttpServletRequest request) throws BaseException, Exception
	{
		JSONObject responseJson = new JSONObject();
		JSONObject resultJson = new JSONObject();
		try 
		{
			String result = "";
			String authStatus = "";

			//authStatus = getAuthStatus( request, userCode, password, "", "I", isPwdEncrypt );
			authStatus = "VALID";
			if ( "VALID".equalsIgnoreCase( authStatus ) )
			{
				String accessToken = getAccTknFrmRfreshTkn(refreshToken);

				resultJson =getConatctDetail(emailId,name,accessToken);
				responseJson.put( "status", "success" );
			
				}
			else
			{
				responseJson.put( "status", "error" );
			}
			responseJson.put("result", resultJson);
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : GmailPluginService : "+ e.getMessage() );
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("result in get contact details" +responseJson);
		return Response.status(200).entity( responseJson.toString() ).build();
		
		
	}
	
	
	@GET
	@Path("/GoogleApiReceiveAuthCode")
	@Produces(MediaType.APPLICATION_JSON)
	public String googleApiReceiveAuthCode(@QueryParam("code") String authCode,@Context HttpServletRequest request,@Context HttpServletResponse response) throws BaseException, Exception
	{
		String refreshToken = "";
		String accessToken = "";
		JSONObject tokenResJson = null;
		String hostUrl = request.getRequestURL().toString();
		try 
		{
			System.out.println("googleApiReceiveAuthCode:authCode:"+authCode);
			hostUrl = hostUrl.substring(0,hostUrl.indexOf("/gmailplugin/GoogleApiReceiveAuthCode"));
			redirectUri = hostUrl+"/gmailplugin/GoogleApiReceiveAuthCode";
			clientId = CommonConstants.GOOGLE_API_CLIENT_ID;
			clientSecret = CommonConstants.GOOGLE_API_CLIENT_SECRET;
			try 
			{
				if(authCode != null)
				{
					tokenResJson = getRfrechTknFrmAthCode(authCode);
					if(tokenResJson.has("refresh_token"))
					{
						refreshToken = tokenResJson.getString("refresh_token");
						System.out.println("refresh token in google api"+refreshToken);
					}
					if(tokenResJson.has("access_token"))
					{
						accessToken = tokenResJson.getString("access_token");
					}
				}
			} catch (JSONException e) 
			{
					e.printStackTrace();
			}
			request.getSession().setAttribute("REFRESH_TOKEN", refreshToken);
			request.getSession().setAttribute("ACCESS_TOKEN", accessToken);
		/*	PrintWriter out = response.getWriter();
		    out.println("<html><body>");
		    out.println("<script type=\"text/javascript\">");
		    out.println("window.close()");
		    out.println("</script>");
		    out.println("</body></html>");*/
		    
			/*response.getWriter().print("<script type='text/javascript'> " +
                    "window.close(); " +
                    "</script>");*/
			//chrome-extension://efkblfijbklmfbnbchapkpllhajaobom/sidebar.html?SENDER=rakesh.naik@baseinformation.com&NAME=Rakesh%20Naik&THREADID=15c20ba0930465bc
			//response.sendRedirect("chrome-extension://efkblfijbklmfbnbchapkpllhajaobom/AccessToken.html");
			hostUrl = hostUrl.substring(0,hostUrl.indexOf("/ibase/rest"));
			String redirectPage = hostUrl+"/ibase/GmailPlugin/jsp/GoogleAPIAccessToken.jsp?refresh_token="+refreshToken;
			response.sendRedirect(redirectPage);
			
			return "SUCCESS";
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : GmailPluginService : "+ e.getMessage() );
			e.printStackTrace();
			throw new ITMException(e);
		}
	}
	
	@GET
	@Path("/saveGoogleRefreshToken")
	@Produces(MediaType.APPLICATION_JSON)
	public String SaveGoogleRefreshTokens( @QueryParam("refresh_token")String RefreshToken, @QueryParam("email_id") String emailId ) throws BaseException, Exception
	{
		String returnString = "";
		try 
		{
			GmailPluginEJBRemote GmailServices = (GmailPluginEJBRemote)  getInitialContext().lookup("ibase/GmailPluginEJB/remote");
			String resultMap = GmailServices.SaveGoogleRefreshToken(RefreshToken, emailId);
		//	System.out.println(" in savegooglerefreshtokens ");
			
		}
		catch (Exception e) 
		{
			System.out.println("Exception in savegooglerefreshtokens "+e.getMessage());
			e.printStackTrace();
		}
		
		return returnString.toString();
	}
	
	@GET
	@Path("/getRefreshToken")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getGoogleRefreshTokens(@QueryParam("email_id") String emailId) throws BaseException, Exception
	{
		String returnString = "";
		String googleRefreshToken = "";
		JSONObject responseJson = new JSONObject();
		
		
		    
		try 
		{   

			GmailPluginEJBRemote GmailServices = (GmailPluginEJBRemote)  getInitialContext().lookup("ibase/GmailPluginEJB/remote");
			googleRefreshToken = GmailServices.getGoogleRefreshToken(emailId);
			System.out.println("google refresh token in ge "+googleRefreshToken);
		}
			
		
		catch (Exception e) 
		{
			System.out.println("Exception in getgooglerefreshtokens "+e.getMessage());
			e.printStackTrace();
		}
		String accessToken = getAccTknFrmRfreshTkn(googleRefreshToken);
		
		if(accessToken != null && accessToken.length() > 0)
		{
           System.out.println("in true google refresh token");  
			responseJson.put("googleRefreshToken", googleRefreshToken);

		}
		else
		{
			System.out.println("google refresh token error");
			
			responseJson.put("googleRefreshToken", "");
			
		}	 
		
	
		return Response.status(200).entity( responseJson.toString() ).build();
		//if(googleRefreshToken == null || googleRefreshToken.length() == 0)
		//{
		//	googleRefreshToken = "NOT_FOUND";
		//}
		
		
		
	//	responseJson.put("googleRefreshToken", googleRefreshToken);
		//return googleRefreshToken;
	    
		
		
	//	System.out.println("response json="+responseJson);
		
	//	return Response.status(200).entity( responseJson.toString() ).build();
		
	}
	

	public InitialContext getInitialContext() throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext( appConnect.getProperty() );
		}
		catch( ITMException itme )
		{
			System.out.println( "ITMException : getInitialContext : "+ itme.getMessage() );
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println( "Exception : getInitialContext : "+ e.getMessage() );
			throw new ITMException(e);
		}
		return ctx;
	}
	
	
	public JSONObject getRfrechTknFrmAthCode(String authCode) 
	{
		String refreshToken = "";
		String accessToken = "";
		JSONObject tokenResJson = null;
		String url="https://www.googleapis.com/oauth2/v4/token";
		try 
		{
			String code = authCode;
			String grant_type = "authorization_code";
					
			String urlParameters = "code="+code+"&client_id="+clientId+"&client_secret="+clientSecret+"&redirect_uri="+redirectUri+"&scope=&grant_type="+grant_type+"&access_type:offline&approval_prompt=force";
			
			String tokenRes = sendPost(url, urlParameters);
			tokenResJson = new JSONObject(tokenRes);
			
		} catch (Exception e) 
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
        System.out.println("token refresh= "+tokenResJson);
		return tokenResJson;
	}
	
	public String sendPost(String url,String urlParameters) throws Exception 
	{
		URL obj = new URL(url);
		HttpsURLConnection con = (HttpsURLConnection) obj.openConnection();

		con.setRequestMethod("POST");
		con.setRequestProperty("User-Agent", "Mozilla/5.0");
		con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");

		con.setDoOutput(true);
		DataOutputStream wr = new DataOutputStream(con.getOutputStream());
		wr.writeBytes(urlParameters);
		wr.flush();
		wr.close();

		int responseCode = con.getResponseCode();
		System.out.println("\nSending 'POST' request to URL : " + url);
		System.out.println("Post parameters : " + urlParameters);
		System.out.println("Response Code : " + responseCode);

		BufferedReader in = new BufferedReader(
				new InputStreamReader(con.getInputStream()));
		String inputLine;
		StringBuffer response = new StringBuffer();

		while ((inputLine = in.readLine()) != null) 
		{
			response.append(inputLine);
		}
		in.close();

		System.out.println(response.toString());
		return response.toString();
	}
	public String sendGet(String url)throws IOException 
	{
		URL obj = new URL(url);
		HttpURLConnection con = (HttpURLConnection) obj.openConnection();

		con.setRequestMethod("GET");

		con.setRequestProperty("User-Agent", "Mozilla/5.0");

		int responseCode = con.getResponseCode();
		
		BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
		String inputLine;
		StringBuffer response = new StringBuffer();

		while ((inputLine = in.readLine()) != null) 
		{
			response.append(inputLine);
		}
		in.close();

		System.out.println("SendGet:"+response.toString());
		return response.toString();
	}
	
	

	public  JSONObject getEmailJson(String emailThreadId,String accessToken ) throws IOException, ParseException {
		String snippet="";
		String from="";
		String fromValue="";
		String fromSplitValue="";
        String to="";
		String toValue="";
		String cc="";
		String ccValue="";
		String bcc="";
		String bccValue="";
		String subject="";
		String subjectValue="";
		String[] parts;
		String fromName = "";
		String url = "";
		
	    JSONObject resEmailJson = null;
		try {
			url = "https://www.googleapis.com/gmail/v1/users/me/threads/"+emailThreadId+"?access_token="+accessToken+"";
			
			String emailUrl = sendGet(url);
			org.json.simple.JSONObject json = (org.json.simple.JSONObject)new JSONParser().parse(emailUrl);
			JSONArray jsonArr = (JSONArray) json.get("messages");
			org.json.JSONArray currThreadEmails = new org.json.JSONArray();
			for (int i = 0; i < jsonArr.size(); i++) 
			{
				org.json.simple.JSONObject jsonObj = (org.json.simple.JSONObject) jsonArr.get(i);
				JSONObject emailData = new JSONObject();
			 	snippet= (String) jsonObj.get("snippet");
			    org.json.simple.JSONObject payloadObj = (org.json.simple.JSONObject) jsonObj.get("payload");
			    JSONArray hh = (JSONArray) payloadObj.get("headers");

				  for (int j = 0; j < hh.size(); j++) 
				  {
					  	org.json.simple.JSONObject jsonObj1 = (org.json.simple.JSONObject) hh.get(j);
						String headerName = "";
						String headerValue = "";
					  	if(jsonObj1.get("name") != null)
						{
							headerName = jsonObj1.get("name").toString();
						}
					  	if(jsonObj1.get("value") != null)
						{
					  		headerValue=jsonObj1.get("value").toString();
						}
					  	if(headerName.equalsIgnoreCase("From"))
						{
					      // from=jsonObj1.get("name").toString();
					       fromValue=headerValue;
						   parts = fromValue.split("<");
						   fromName = parts[0];
						   if (fromValue.contains("<")) 
						   {
						   fromValue = fromValue.substring(fromValue.indexOf("<") + 1);
			               fromValue = fromValue.substring(0, fromValue.indexOf(">"));
						   }
						   else
						   {
							   fromValue=fromName;
						   }
						   
			     	 	}
						if(headerName.equalsIgnoreCase("To"))
						{
					       //to=jsonObj1.get("name").toString();
							toValue = headerValue;
						}
						if(headerName.equalsIgnoreCase("Cc"))
						{
						    //cc=jsonObj1.get("name").toString();
						    ccValue = headerValue;
										    
						}
						if(headerName.equalsIgnoreCase("Bcc"))
						{

						  //  bcc=jsonObj1.get("name").toString();
						    bccValue=headerValue;
						}
						if(headerName.equalsIgnoreCase("Subject"))
						{
							//subject=jsonObj1.get("name").toString();
						    subjectValue=headerValue;
					     
						}
			        }
				  
				  	JSONArray FirstPartsArray = (JSONArray) payloadObj.get("parts");
				  	org.json.simple.JSONObject FirstpartObject = null;
				  	org.json.simple.JSONObject FirstBodyObject = null;
				  	org.json.simple.JSONObject BodyObject = null;

				  	org.json.simple.JSONObject nextPartsObject = null;
				  	org.json.simple.JSONObject SecondBodyObject = null;
				  	String encodedBody="";

				  	if(FirstPartsArray != null)
				  	{
				  		FirstpartObject = (org.json.simple.JSONObject) FirstPartsArray.get(0);
				  		BodyObject = (org.json.simple.JSONObject)FirstpartObject.get("body");
				  		System.out.println("size"+BodyObject.get("size"));
				  			
				  		
					    if(BodyObject.get("size").toString().equalsIgnoreCase("0"))
						{
							System.out.println("body has attchemnet");
						        /*JSONArray SecondPartsArray = (JSONArray) FirstpartObject.get("parts");
							SecondPartsObject = (org.json.simple.JSONObject) SecondPartsArray.get(0);
					  		SecondBodyObject = (org.json.simple.JSONObject)SecondPartsObject.get("body");
					  		System.out.println("SecondBodyObject"+SecondBodyObject);
					  		      encodedBody=SecondBodyObject.get("data").toString();
				     	                  System.out.println("encodedbody"+encodedBody);*/
				     	          
							org.json.simple.JSONObject tempPartObject = FirstpartObject;
				     	    while(true)
				     	    {
				     	    	JSONArray SecondPartsArray = (JSONArray) tempPartObject.get("parts");
				     	    	nextPartsObject = (org.json.simple.JSONObject) SecondPartsArray.get(0);
						  		SecondBodyObject = (org.json.simple.JSONObject)nextPartsObject.get("body");
						  		System.out.println("SecondBodyObject"+SecondBodyObject);
						  		if(SecondBodyObject.get("size").toString().equalsIgnoreCase("0"))
						  		{
						  			tempPartObject = nextPartsObject;
						  			continue;
						  		}
						  		encodedBody=SecondBodyObject.get("data").toString();
					     	    System.out.println("encodedbody"+encodedBody);
					     	    break;
				     	    }
				     	                 
					 	     
						}
				  		 
				  		 else{
				  			 
				  			FirstBodyObject = (org.json.simple.JSONObject)FirstpartObject.get("body");
				     	                encodedBody=FirstBodyObject.get("data").toString();

				  		    }
				  						  		
				  	}
				  	
				  	else
				  	{
				  		FirstBodyObject = (org.json.simple.JSONObject)payloadObj.get("body");
			     	                 encodedBody=FirstBodyObject.get("data").toString();

				  	}
				  
				  	
		            	    byte[] decodedBody = null;

		     	    
		     	            decodedBody = Base64.getUrlDecoder().decode(encodedBody.getBytes(StandardCharsets.UTF_8));

		     	    
		         //	byte[] decodedBody = Base64.getDecoder().decode(encodedBody);
		         	String emailBody = new String(decodedBody);
		         	   
		         	System.out.println("decoded  body  is  :   "+emailBody);

					emailData.put("from_emailid",fromValue);
					emailData.put("from_name", fromName);
					emailData.put("to", toValue);
					emailData.put("cc", ccValue);
					emailData.put("bcc", bccValue);
		        	emailData.put("subject", subjectValue);
		        	emailData.put("body",emailBody);
				
		        	currThreadEmails.put(i, emailData);  
			}

			resEmailJson = new JSONObject();
			resEmailJson.put("messages", currThreadEmails);
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println(" in get email json "+resEmailJson);
		return resEmailJson;
		
	}
	
	
	
	
	public  JSONObject getConatctDetail(String usrEmailId,String usrName,String accessToken ) throws IOException, ParseException, BaseException, JSONException {
        String url = "https://www.google.com/m8/feeds/contacts/default/full?q="+usrEmailId+"&v=3.0&access_token="+accessToken+"";
		
		String contactsXml = sendGet(url);
		System.out.println("Contact Xml:"+contactsXml);
		GenericUtility utility = new GenericUtility();
		Document contactDom = utility.parseString(contactsXml);
		NodeList entryList = null;
		Node entryNode = null;
		Document entryDom = null;
		JSONObject emailData = new JSONObject();
		
		String name = usrName;
		String emailId = usrEmailId;
		String phoneNo = "";
		String imageUrl = "";

		if(contactDom != null)
		{
			entryList = contactDom.getElementsByTagName("entry");
			System.out.println("Entry List: "+entryList);
			if(entryList!=null && entryList.getLength() != 0)
			{
			
			System.out.println("Contact XML Parsing Start...............");
			for( int i = 0; i < entryList.getLength(); i++ )
			{
				entryNode = entryList.item(i);
				entryDom = utility.parseString(utility.serializeDom(entryNode));
				
				if(entryDom != null)
				{
					NodeList titleNodeList = entryDom.getElementsByTagName("title");
					NodeList emailIdNodeList = entryDom.getElementsByTagName("gd:email");
					NodeList phoneNoNodeList = entryDom.getElementsByTagName("gd:phoneNumber");
					NodeList linkNodeList = entryDom.getElementsByTagName("link");
    				
    				
					if(titleNodeList != null)
					{
						if(titleNodeList.item(0) != null)
						{
							name = titleNodeList.item(0).getTextContent();
						}
					}
					if(emailIdNodeList != null)
					{
						if(emailIdNodeList.item(0) != null)
						{
							if(emailIdNodeList.item(0).getAttributes() != null)
							{
								if(emailIdNodeList.item(0).getAttributes().getNamedItem("address") != null)
								{
									emailId = emailIdNodeList.item(0).getAttributes().getNamedItem("address").getNodeValue();
								}
							}
						}
					}
					if(phoneNoNodeList != null)
					{
						if(phoneNoNodeList.item(0) != null)
						{
							phoneNo = phoneNoNodeList.item(0).getTextContent();
						}
					}
					if(linkNodeList != null)
    				{
						
						for(int cnt = 0; cnt < linkNodeList.getLength(); cnt++)
    					{
    						if(linkNodeList.item(cnt) != null)
    						{
							
    							if(linkNodeList.item(cnt).getAttributes() != null)
    							{
    								if(linkNodeList.item(cnt).getAttributes().getNamedItem("rel") != null)
    								{
    									if(linkNodeList.item(cnt).getAttributes().getNamedItem("rel").getNodeValue().contains("#photo"))
    									{
    										if(linkNodeList.item(cnt).getAttributes().getNamedItem("href") != null)
    										{
    											imageUrl = linkNodeList.item(cnt).getAttributes().getNamedItem("href").getNodeValue();
    										
    										}
    									}
    								}
    							}		
    						}
    					}
						imageUrl = imageUrl+"?access_token="+accessToken+"";
						System.out.println("imageUrl:"+imageUrl);
						
    				}
				
					
                  }
				
		       }
			}
			

			System.out.println("Contact XML Parsing End...............");
		}

		emailData.put("email_id",emailId);
		emailData.put("name",name);
		emailData.put("mobile_no",phoneNo);
		emailData.put("img_url", imageUrl);
		
		System.out.println("EmailData"+emailData);
	
		return emailData;
		
	}
	
	private String getThreadId(String isMsgId, String accessToken) throws IOException, ParseException {
     // isMsgId="15c29e3b668d66d5";
	  String thread_Id="";
	  //a3s aXjCH m15c5d0f75e5ca3ce
	    String	url = "https://www.googleapis.com/gmail/v1/users/me/messages/"+isMsgId+"?access_token="+accessToken+"";
	  //https://www.googleapis.com/gmail/v1/users/me/messages/15ba500f0142821b
	  
		String emailUrl = sendGet(url);
		//org.json.simple.JSONObject json = (JSONObject)new JSONParser().parse(contactsXml);
		org.json.simple.JSONObject json = (org.json.simple.JSONObject)new JSONParser().parse(emailUrl);
		thread_Id = (String) json.get("threadId");			
		return thread_Id;
	}

	
	
	public String getAccTknFrmRfreshTkn(String refreshToken) throws Exception 
	{
	
	String accessToken = "";
	
	System.out.println("refresh toktn in get acc"+refreshToken);
	try 
	{
	String grant_type = "refresh_token";
	
	JSONObject tokenResJson = null;
	String url="https://www.googleapis.com/oauth2/v4/token";
	
		 
	clientId = CommonConstants.GOOGLE_API_CLIENT_ID;
	clientSecret = CommonConstants.GOOGLE_API_CLIENT_SECRET;
	
	String urlParameters = "refresh_token="+refreshToken+"&client_id="+clientId+"&client_secret="+clientSecret+"&grant_type="+grant_type+"";
    
	String tokenRes = sendPost(url, urlParameters);
	
	tokenResJson = new JSONObject(tokenRes);
	accessToken = tokenResJson.getString("access_token");
	System.out.println("in try access token");

	}

	catch (Exception e) {
	// TODO Auto-generated catch block
	System.out.println("in catch access token");	
	return "";
	//e.printStackTrace();
	//throw e;
	}
	
	
	System.out.println("acess token"+accessToken);
	return accessToken;
	
	
	}
	
	@GET
	@Path("/getvalidemail")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getValidEmail(@QueryParam("refresh_token") String refreshToken) throws BaseException, Exception
	{

		JSONObject responseJson = new JSONObject();
		JSONObject resultJson = new  JSONObject();
		try 
		{
			String result = "";
			String authStatus = "";
			
			//authStatus = getAuthStatus( request, userCode, password, "", "I", isPwdEncrypt );
				System.out.println("Refresh token:"+refreshToken);
								
			   String accessToken = getAccTknFrmRfreshTkn(refreshToken);
			   
			   System.out.println("accessToken in getValidEmail"+accessToken);
			 //  JSONObject resultJson = new JSONObject();
			   resultJson = JsongetValidEmail( accessToken);
		//		org.json.JSONArray messagesArr = (org.json.JSONArray) resultJson.get("emailData");
				
		     	System.out.println("resultJson in get valid email"+resultJson);
		     
				
				
			
			responseJson.put("email_id", resultJson);
			
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : GmailPluginService : "+ e.getMessage() );
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("responseJson in getvalidemail"+responseJson);
		return Response.status(200).entity( responseJson.toString() ).build();
	
	}
	
	public  JSONObject JsongetValidEmail(String accessToken) throws IOException, ParseException, JSONException, BaseException {
	 String url= "https://www.googleapis.com/oauth2/v1/userinfo?access_token="+accessToken+"";
	 	System.out.println("In JsongetValidEmail"+url);
		JSONObject resultJson = new  JSONObject();
		String email="";
		String contactsXml = sendGet(url);
		org.json.simple.JSONObject json = (org.json.simple.JSONObject)new JSONParser().parse(contactsXml);
		
		System.out.println("In JsongetValidEmail contact XML"+json);
		JSONObject emailData = new JSONObject();
		//JSONObject json = (JSONObject)new JSONParser().parse(contactsXml);
		 
		emailData.put("email_id",json.get("email"));
		
		return emailData;
		
	}
	
	
}