package proteus.ecm.hibernate.bean;

import java.math.BigDecimal;
import java.util.HashMap;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Digits;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONObject;

@Indexed
@Entity
@Table(name = "ITEM")
@XmlRootElement(name = "item")
public class ItemMaster implements java.io.Serializable  {
	
	private static final long serialVersionUID = 1L;
	@Id
	@Field(store = Store.YES, analyze = Analyze.NO)
	@Column(name="ITEM_CODE")
	private String item_code;
	
	@Column(name="DESCR")
	private String item_descr;
	
	@Column(name="SH_DESCR")
	private String item_sh_descr;
	
	@Digits(integer=14, fraction=3)
	@Column(name = "LENGTH")
	private BigDecimal length;

	@Digits(integer=14, fraction=3)
	@Column(name = "WIDTH")
	private BigDecimal width;

	@Digits(integer=14, fraction=3)
	@Column(name = "HEIGHT")
	private BigDecimal height;

	@Digits(integer=14, fraction=3)
	@Column(name = "GROSS_WEIGHT")
	private BigDecimal gross_weight;
 	
	@Column(name="PRODUCT_CODE")
	private String product_code;
 	
	@Column(name="PRICE_LIST")
	private String price_list;
 	
	@Column(name="ITEM_TYPE")
	private String item_type;
 	
	@Column(name="PHY_ATTRIB_1") //PHY_ATTRIB_1	VARCHAR2(15)  
	private String phyAttribId1;
	
	@Column(name="PHY_ATTRIB_2") //PHY_ATTRIB_2	VARCHAR2(15)
	private String phyAttribId2;
	
	@Column(name="PHY_ATTRIB_3") //PHY_ATTRIB_3	VARCHAR2(15)
	private String phyAttribId3;
	
	@Column(name="PHY_ATTRIB_4") //PHY_ATTRIB_4	VARCHAR2(30)  
	private String phyAttribId4;
	
	@Column(name="PHY_ATTRIB_5") //PHY_ATTRIB_5	VARCHAR2(250) 
	private String phyAttribId5;
	 
	@Column(name="PHY_ATTRIB_6") //PHY_ATTRIB_6	VARCHAR2(50) 
	private String phyAttribId6;
	
	@Column(name="PHY_ATTRIB_7") //PHY_ATTRIB_7	VARCHAR2(15)
	private String phyAttribId7;
	
	@Column(name="PHY_ATTRIB_8") //PHY_ATTRIB_8	VARCHAR2(15)
	private String phyAttribId8;
	
	@Column(name="PHY_ATTRIB_9") //PHY_ATTRIB_9	VARCHAR2(15)
	private String phyAttribId9;
	
	@Column(name="PHY_ATTRIB_10") //PHY_ATTRIB_10	VARCHAR2(15)
	private String phyAttribId10;
	
	@Column(name="PHY_ATTRIB_11") //PHY_ATTRIB_11	VARCHAR2(15) 
	private String phyAttribId11;
	 
	@Column(name="PHY_ATTRIB_12") //PHY_ATTRIB_12	VARCHAR2(15)
	private String phyAttribId12;
	
	@Column(name="PHY_ATTRIB_13") //PHY_ATTRIB_13	VARCHAR2(15)
	private String phyAttribId13;
	
	@Column(name="PHY_ATTRIB_14") //PHY_ATTRIB_14	VARCHAR2(15)
	private String phyAttribId14;
	
	@Column(name="PHY_ATTRIB_15") //PHY_ATTRIB_15	VARCHAR2(15)
	private String phyAttribId15;
	 
	@Column(name="PHY_ATTRIB_16") //PHY_ATTRIB_16	VARCHAR2(15) 
	private String phyAttribId16;
	
	@Column(name="PHY_ATTRIB_17") //PHY_ATTRIB_17	VARCHAR2(15) 
	private String phyAttribId17;
	
	@Column(name="PHY_ATTRIB_18") //PHY_ATTRIB_18	VARCHAR2(15)
	private String phyAttribId18;
	
	@Column(name="PHY_ATTRIB_19") //PHY_ATTRIB_19	VARCHAR2(15)
	private String phyAttribId19;
	
	@Column(name="PHY_ATTRIB_20") //PHY_ATTRIB_20	VARCHAR2(15)
	private String phyAttribId20;
	
	@Column(name="PHY_ATTRIB_21") //PHY_ATTRIB_21	VARCHAR2(15) 
	private String phyAttribId21;
	
	@Column(name="PHY_ATTRIB_22") //PHY_ATTRIB_22	VARCHAR2(15)
	private String phyAttribId22;
	
	@Column(name="PHY_ATTRIB_23") //PHY_ATTRIB_23	VARCHAR2(250)
	private String phyAttribId23;
	
	@Column(name="PHY_ATTRIB_24") //PHY_ATTRIB_24	VARCHAR2(50) 
	private String phyAttribId24;
	
	@Transient
	private String itemQuantity;
	
	public ItemMaster() {
		
	}

	public String getItemCode() {
		return item_code;
	}

	@XmlElement
	public void setItemCode(String itemCode) {
		this.item_code = itemCode;
	}

	public String getDescr() {
		return item_descr;
	}
    
	@XmlElement
	public void setDescr(String descr) {
		this.item_descr = descr;
	}

	public String getShDescr() {
		return item_sh_descr;
	}
    
	@XmlElement
	public void setShDescr(String shDescr) {
		this.item_sh_descr = shDescr;
	}

	public String getProductCode() {
		return product_code;
	}

	@XmlElement
	public void setProductCode(String product_code) {
		this.product_code = product_code;
	}

	public String getPriceList() {
		return price_list;
	}

	@XmlElement
	public void setPriceList(String price_list) {
		this.price_list = price_list;
	}

	public String getItemType() {
		return item_type;
	}

	@XmlElement
	public void setItemType(String item_type) {
		this.item_type = item_type;
	}

	public BigDecimal getLength() {
		return length;
	}

	public void setLength(BigDecimal length) {
		this.length = length;
	}

	public BigDecimal getWidth() {
		return width;
	}

	public void setWidth(BigDecimal width) {
		this.width = width;
	}

	public BigDecimal getHeight() {
		return height;
	}

	public void setHeight(BigDecimal height) {
		this.height = height;
	}

	public BigDecimal getGrossWeight() {
		return gross_weight;
	}

	public void setGrossWeight(BigDecimal gross_weight) {
		this.gross_weight = gross_weight;
	}

	public String getPhyAttribId1() {
		return phyAttribId1;
	}

	@XmlElement
	public void setPhyAttribId1(String phyAttribId1) {
		this.phyAttribId1 = phyAttribId1;
	}

	public String getPhyAttribId2() {
		return phyAttribId2;
	}

	@XmlElement
	public void setPhyAttribId2(String phyAttribId2) {
		this.phyAttribId2 = phyAttribId2;
	}

	public String getPhyAttribId3() {
		return phyAttribId3;
	}

	@XmlElement
	public void setPhyAttribId3(String phyAttribId3) {
		this.phyAttribId3 = phyAttribId3;
	}

	public String getPhyAttribId4() {
		return phyAttribId4;
	}

	@XmlElement
	public void setPhyAttribId4(String phyAttribId4) {
		this.phyAttribId4 = phyAttribId4;
	}

	public String getPhyAttribId5() {
		return phyAttribId5;
	}

	@XmlElement
	public void setPhyAttribId5(String phyAttribId5) {
		this.phyAttribId5 = phyAttribId5;
	}

	public String getPhyAttribId6() {
		return phyAttribId6;
	}

	@XmlElement
	public void setPhyAttribId6(String phyAttribId6) {
		this.phyAttribId6 = phyAttribId6;
	}
	
	public String getItemQuantity() {
		return itemQuantity;
	}
	
	@XmlElement
	public void setItemQuantity(String itemQuantity) {
		this.itemQuantity = itemQuantity;
	}
	
	public String getPhyAttribId7() {
		return phyAttribId7;
	}

	@XmlElement
	public void setPhyAttrib7(String phyAttribId7) {
		this.phyAttribId7 = phyAttribId7;
	}

	public String getPhyAttribId8() {
		return phyAttribId8;
	}

	@XmlElement
	public void setPhyAttribId8(String phyAttribId8) {
		this.phyAttribId8 = phyAttribId8;
	}

	public String getPhyAttribId9() {
		return phyAttribId9;
	}

	@XmlElement
	public void setPhyAttribId9(String phyAttribId9) {
		this.phyAttribId9 = phyAttribId9;
	}
	
	public String getPhyAttribId10() {
		return phyAttribId10;
	}

	@XmlElement
	public void setPhyAttribId10(String phyAttribId10) {
		this.phyAttribId10 = phyAttribId10;
	}

	public String getPhyAttribId11() {
		return phyAttribId11;
	}

	@XmlElement
	public void setPhyAttribId11(String phyAttribId11) {
		this.phyAttribId11 = phyAttribId11;
	}

	public String getPhyAttribId12() {
		return phyAttribId12;
	}

	@XmlElement
	public void setPhyAttribId12(String phyAttribId12) {
		this.phyAttribId12 = phyAttribId12;
	}

	public String getPhyAttribId13() {
		return phyAttribId13;
	}

	@XmlElement
	public void setPhyAttribId13(String phyAttribId13) {
		this.phyAttribId13 = phyAttribId13;
	}

	public String getPhyAttribId14() {
		return phyAttribId14;
	}

	@XmlElement
	public void setPhyAttribId14(String phyAttribId14) {
		this.phyAttribId14 = phyAttribId14;
	}

	public String getPhyAttribId15() {
		return phyAttribId15;
	}

	@XmlElement
	public void setPhyAttribId15(String phyAttribId15) {
		this.phyAttribId15 = phyAttribId15;
	}

	public String getPhyAttribId16() {
		return phyAttribId16;
	}

	@XmlElement
	public void setPhyAttribId16(String phyAttribId16) {
		this.phyAttribId16 = phyAttribId16;
	}

	public String getPhyAttribId17() {
		return phyAttribId17;
	}

	@XmlElement
	public void setPhyAttribId17(String phyAttribId17) {
		this.phyAttribId17 = phyAttribId17;
	}

	public String getPhyAttribId18() {
		return phyAttribId18;
	}

	@XmlElement
	public void setPhyAttribId18(String phyAttribId18) {
		this.phyAttribId18 = phyAttribId18;
	}

	public String getPhyAttribId19() {
		return phyAttribId19;
	}

	@XmlElement
	public void setPhyAttribId19(String phyAttribId19) {
		this.phyAttribId19 = phyAttribId19;
	}

	public String getPhyAttribId20() {
		return phyAttribId20;
	}

	@XmlElement
	public void setPhyAttribId20(String phyAttribId20) {
		this.phyAttribId20 = phyAttribId20;
	}

	public String getPhyAttribId21() {
		return phyAttribId21;
	}

	@XmlElement
	public void setPhyAttribId21(String phyAttribId21) {
		this.phyAttribId21 = phyAttribId21;
	}

	public String getPhyAttribId22() {
		return phyAttribId22;
	}

	@XmlElement
	public void setPhyAttribId22(String phyAttribId22) {
		this.phyAttribId22 = phyAttribId22;
	}

	public String getPhyAttribId23() {
		return phyAttribId23;
	}

	@XmlElement
	public void setPhyAttribId23(String phyAttribId23) {
		this.phyAttribId23 = phyAttribId23;
	}

	public String getPhyAttribId24() {
		return phyAttribId24;
	}

	@XmlElement
	public void setPhyAttribId24(String phyAttribId24) {
		this.phyAttribId24 = phyAttribId24;
	}

	@Override
	public String toString(){
		return "\n ItemMaster.toString >> [" + new JSONObject(this).toString() + "]";
	}
	
	public HashMap<String, String> getPhyAttribMap()
	{
		HashMap<String, String> phyAttribMap = new HashMap<String, String>();
		if( checkNull(this.phyAttribId1) )
		{
			phyAttribMap.put("PH1", this.phyAttribId1);
		}
		if( checkNull(this.phyAttribId2) )
		{
			phyAttribMap.put("PH2", this.phyAttribId2);
		}
		if( checkNull(this.phyAttribId3) )
		{
			phyAttribMap.put("PH3", this.phyAttribId3);
		}
		if( checkNull(this.phyAttribId4) )
		{
			phyAttribMap.put("PH4", this.phyAttribId4);
		}
		if( checkNull(this.phyAttribId5) )
		{
			phyAttribMap.put("PH5", this.phyAttribId5);
		}
		if( checkNull(this.phyAttribId6) )
		{
			phyAttribMap.put("PH6", this.phyAttribId6);
		}
		if( checkNull(this.phyAttribId7) )
		{
			phyAttribMap.put("PH7", this.phyAttribId7);
		}
		if( checkNull(this.phyAttribId8) )
		{
			phyAttribMap.put("PH8", this.phyAttribId8);
		}
		if( checkNull(this.phyAttribId9) )
		{
			phyAttribMap.put("PH9", this.phyAttribId9);
		}

		if( checkNull(this.phyAttribId10) )
		{
			phyAttribMap.put("PH10", this.phyAttribId10);
		}
		if( checkNull(this.phyAttribId11) )
		{
			phyAttribMap.put("PH11", this.phyAttribId11);
		}
		if( checkNull(this.phyAttribId12) )
		{
			phyAttribMap.put("PH12", this.phyAttribId12);
		}
		if( checkNull(this.phyAttribId13) )
		{
			phyAttribMap.put("PH13", this.phyAttribId13);
		}
		if( checkNull(this.phyAttribId14) )
		{
			phyAttribMap.put("PH14", this.phyAttribId14);
		}
		if( checkNull(this.phyAttribId15) )
		{
			phyAttribMap.put("PH15", this.phyAttribId15);
		}
		if( checkNull(this.phyAttribId16) )
		{
			phyAttribMap.put("PH16", this.phyAttribId16);
		}
		if( checkNull(this.phyAttribId17) )
		{
			phyAttribMap.put("PH17", this.phyAttribId17);
		}
		if( checkNull(this.phyAttribId18) )
		{
			phyAttribMap.put("PH18", this.phyAttribId18);
		}
		if( checkNull(this.phyAttribId19) )
		{
			phyAttribMap.put("PH19", this.phyAttribId19);
		}
		if( checkNull(this.phyAttribId20) )
		{
			phyAttribMap.put("PH20", this.phyAttribId20);
		}
		if( checkNull(this.phyAttribId21) )
		{
			phyAttribMap.put("PH21", this.phyAttribId21);
		}
		if( checkNull(this.phyAttribId22) )
		{
			phyAttribMap.put("PH22", this.phyAttribId22);
		}
		if( checkNull(this.phyAttribId23) )
		{
			phyAttribMap.put("PH23", this.phyAttribId23);
		}
		if( checkNull(this.phyAttribId24) )
		{
			phyAttribMap.put("PH24", this.phyAttribId24);
		}
		return phyAttribMap;
	}
	
	private boolean checkNull(String value) 
	{
		if( value != null && value.trim().length() > 0 )
		{
			return true;
		}
		return false;
	}
}
