-----------------------------------------------------------------------------------------------------------------------------------------
-- ECM_CATEGORY : This is a new table to define category for example in a Fashion Industry Accessories, Brands, Costumes etc.
-----------------------------------------------------------------------------------------------------------------------------------------
CREATE TABLE ECM_CATEGORY(
CAT_CODE       VARCHAR2(10) NOT NULL,
DESCR	       VARCHAR2(120),
SH_DESCR       VARCHAR2(60),
CUR_RANK       NUMBER(3),
CHG_USER       CHAR(10),
CHG_TERM       VARCHAR2(15),
CHG_DATE       DATE
);
ALTER TABLE ECM_CATEGORY ADD ( CONSTRAINT ECM_CATEGORY_PK PRIMARY KEY ( CAT_CODE )) ;

-----------------------------------------------------------------------------------------------------------------------------------------


-----------------------------------------------------------------------------------------------------------------------------------------
-- ECM_SUB_CATEGORY : This is a new table to define sub category 
--                    for example in a Fashion Industry Brands -> Nike, Puma etc.; Leotards -> Children Leotards, Tights etc.
-----------------------------------------------------------------------------------------------------------------------------------------
CREATE TABLE ECM_SUB_CATEGORY(
SCAT_CODE	VARCHAR2(10) NOT NULL,
CAT_CODE	VARCHAR2(10) NOT NULL,
DESCR		VARCHAR2(120),
SH_DESCR	VARCHAR2(60),
CUR_RANK	NUMBER(3),
CHG_USER	CHAR(10),
CHG_TERM	VARCHAR2(15),
CHG_DATE	DATE
);
ALTER TABLE ECM_SUB_CATEGORY ADD ( CONSTRAINT ECM_SUB_CATEGORY_PK PRIMARY KEY ( SCAT_CODE ) ) ;
ALTER TABLE ECM_SUB_CATEGORY ADD ( CONSTRAINT ECM_SUB_CATEGORY_FK FOREIGN KEY ( CAT_CODE ) REFERENCES ECM_CATEGORY(CAT_CODE) );

-----------------------------------------------------------------------------------------------------------------------------------------


-----------------------------------------------------------------------------------------------------------------------------------------
-- ECMPARM : This is a new table to define ECM params
-----------------------------------------------------------------------------------------------------------------------------------------
CREATE TABLE ECMPARM(
	VAR_NAME   VARCHAR2(30) NOT NULL ,  
	VAR_TYPE   CHAR(1) NOT NULL ,        
	VAR_VALUE  VARCHAR2(1200), 
	DESCR      VARCHAR2(120),    
	CHG_USER   CHAR(10) NOT NULL ,
	CHG_TERM   VARCHAR2(15) NOT NULL ,
	CHG_DATE   DATE NOT NULL 
);
ALTER TABLE ECMPARM ADD ( CONSTRAINT ECMPARM_PK PRIMARY KEY ( VAR_NAME ) ) ;

-----------------------------------------------------------------------------------------------------------------------------------------


