import { Component, OnInit, ViewChildren, QueryList} from '@angular/core';
import { Address } from './address-manager/address.model';
import { AddressEditor } from './address-manager';
import { AppState } from '../ecm-store/reducers';
import { Store } from '@ngrx/store';
import { ProfileActions} from '../ecm-store/actions';
import { Observable } from 'rxjs/Observable';
import { AdressAction} from '../ecm-store/actions';

@Component({
  selector: 'user-address',
  templateUrl: './user-address.component.html',
  styleUrls: ['./user-address.component.css']
})
export class UserAddressComponent implements OnInit {

    @ViewChildren(AddressEditor) addressEditors: QueryList<AddressEditor>
    addressList : any;
    newAddress: Address = new Address();
    

    constructor(private store: Store<AppState>, private addressActions: AdressAction){}
    
    ngOnInit() {
        localStorage.removeItem('editorId');
        this.store.dispatch(this.addressActions.loadAddress());
        this.loadUserAddress();
    }

    onSaveClick(address: Address)
    {
        console.log('On Save Click ', address);
        
        if( address.isDefault == 'Y' ){
            this.updateDefaultStatus(address);
        }
        address.userName = address.firstName + " " + address.lastName;
        console.log('On Save Click the userAddress name is ', this.addressList, address);

        //Call POST service (address)
        this.store.dispatch(this.addressActions.updateAddress(address));
    }

    onAddNew(address: Address)
    {

        let lineNo = this.getMaxLineNo();
        console.log( 'loadUser addressList >> ', lineNo);
        address.lineNo = lineNo+'';
        
        if( address.isDefault == 'Y' ){
            this.updateDefaultStatus(address);
        }
        address.userName = address.firstName + " " + address.lastName;
        console.log('On Add new Click the userAddress name is ', address.userName);
        this.addressList.push( address );
        console.log('On Save Click From Add New ', address);
        this.store.dispatch(this.addressActions.addNewAdddress(address));
    }
    
    deleteUserAddress(address: Address){
        this.store.dispatch(this.addressActions.deleteAddressSuccess(address));
    }
    

    onDiscard(editorId: string)
    {
        console.log('On Discard Click ', editorId);
        //Call POST service (address)
        this.addressEditors.forEach(addressEditor => {
            if( editorId == addressEditor.editorId ) {
                console.log(addressEditor);
                addressEditor.cancel();
            }
        });
    }
    
    loadUserAddress() {
        this.store.select( 'Address' ).subscribe( addressList => {
            console.log( 'loadUser addressList >> ', addressList );
            this.addressList = addressList;
        });
    }
    
    getMaxLineNo() : number {
        let maxLineNo = 0;
        
        for( let address of this.addressList){
            let addrLineNo : number = Number(address.lineNo);
            if(addrLineNo > maxLineNo){
                maxLineNo = addrLineNo;
            }
        }
        console.log('maxLineno--',maxLineNo);
        return maxLineNo + 1;
   }
    
    updateDefaultStatus(address:Address){
        let _address :Address;
        for( _address of this.addressList){
            
            if( _address.lineNo == address.lineNo )
            {
                _address.isDefault = 'Y';
            }
            else
            {
                _address.isDefault = 'N';
            }
        }
    }

}
