import { Directive, Input } from '@angular/core';
import { NG_VALIDATORS } from '@angular/forms';
export class PasswordValidator {
    constructor() {
        this.expression = /^(?=.*\d)(?=.*[!@#$%^&*])(?=.*[a-z])(?=.*[A-Z]).{8,}$/;
        this.validation = false;
    }
    validate(c) {
        console.log('-------', c.value);
        if (!this.validation) {
            return null;
        }
        const isValidPassword = this.expression.test(c.value);
        const message = {
            'password': {
                'message': this.invalidMessage
            }
        };
        return isValidPassword ? null : message;
    }
}
PasswordValidator.decorators = [
    { type: Directive, args: [{
                selector: '[password-validator]',
                providers: [
                    { provide: NG_VALIDATORS, useExisting: PasswordValidator, multi: true }
                ]
            },] },
];
/** @nocollapse */
PasswordValidator.ctorParameters = () => [];
PasswordValidator.propDecorators = {
    'expression': [{ type: Input, args: ['expression',] },],
    'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
    'validation': [{ type: Input, args: ['validation',] },],
};
//# sourceMappingURL=password-validator.js.map