"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var core_1 = require("@angular/core");
var credit_card_1 = require("../shared/credit-card");
var CvcFormatDirective = (function () {
    function CvcFormatDirective(el) {
        this.el = el;
        this.target = this.el.nativeElement;
    }
    CvcFormatDirective.prototype.onKeypress = function (e) {
        if (!credit_card_1.CreditCard.restrictNumeric(e) && !credit_card_1.CreditCard.restrictCvc(e.which, this.target)) {
            e.preventDefault();
        }
    };
    CvcFormatDirective.prototype.onPaste = function (e) {
        this.reformatCvc(e);
    };
    CvcFormatDirective.prototype.onChange = function (e) {
        this.reformatCvc(e);
    };
    CvcFormatDirective.prototype.onInput = function (e) {
        this.reformatCvc(e);
    };
    CvcFormatDirective.prototype.reformatCvc = function (e) {
        var _this = this;
        setTimeout(function () {
            var val = credit_card_1.CreditCard.replaceFullWidthChars(_this.target.value);
            val = val.replace(/\D/g, '').slice(0, 4);
            _this.target.selectionStart = _this.target.selectionEnd = credit_card_1.CreditCard.safeVal(val, _this.target);
        });
    };
    CvcFormatDirective.decorators = [
        { type: core_1.Directive, args: [{
                    selector: '[ccCVC]'
                },] },
    ];
    CvcFormatDirective.ctorParameters = function () { return [
        { type: core_1.ElementRef, },
    ]; };
    CvcFormatDirective.propDecorators = {
        'onKeypress': [{ type: core_1.HostListener, args: ['keypress', ['$event'],] },],
        'onPaste': [{ type: core_1.HostListener, args: ['paste', ['$event'],] },],
        'onChange': [{ type: core_1.HostListener, args: ['change', ['$event'],] },],
        'onInput': [{ type: core_1.HostListener, args: ['input', ['$event'],] },],
    };
    return CvcFormatDirective;
}());
exports.CvcFormatDirective = CvcFormatDirective;
//# sourceMappingURL=cvc-format.directive.js.map