/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.handler.stateless;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.metadata.MetaDataResolver;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.asynch.AsynchMixin;
import org.jboss.aspects.asynch.AsynchProvider;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.proxy.JBossProxy;
import org.jboss.ejb3.proxy.ProxyUtils;
import org.jboss.ejb3.proxy.handler.BaseProxyInvocationHandlerRemote;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;

public class StatelessClusteredInvocationHandler
extends BaseProxyInvocationHandlerRemote {
    private static final long serialVersionUID = -4100015258079818357L;
    protected FamilyWrapper family;
    protected LoadBalancePolicy lbPolicy;
    protected AsynchProvider provider;
    protected String partitionName;
    protected Object originTarget;

    public StatelessClusteredInvocationHandler(Container container, Interceptor[] interceptors, FamilyWrapper family, LoadBalancePolicy lbPolicy, String partitionName, Object originTarget, String businessInterfaceClassName) {
        super(container, interceptors, businessInterfaceClassName);
        this.family = family;
        this.lbPolicy = lbPolicy;
        this.partitionName = partitionName;
        this.originTarget = originTarget;
    }

    public StatelessClusteredInvocationHandler(AsynchProvider provider, String containerId, String containerGuid, Interceptor[] interceptors, FamilyWrapper family, LoadBalancePolicy lbPolicy, String partitionName, Object originTarget, String businessInterfaceClassName) {
        super(containerId, containerGuid, interceptors, businessInterfaceClassName);
        this.provider = provider;
        this.family = family;
        this.lbPolicy = lbPolicy;
        this.partitionName = partitionName;
        this.originTarget = originTarget;
    }

    public StatelessClusteredInvocationHandler() {
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == AsynchProvider.class) {
            return this.provider.getFuture();
        }
        long hash = MethodHashing.calculateHash((Method)method);
        Object ret = ProxyUtils.handleCallLocally(hash, (JBossProxy)proxy, this, method, args);
        if (ret != null) {
            return ret;
        }
        MethodInvocation sri = new MethodInvocation(this.interceptors, hash, method, method, null);
        sri.setArguments(args);
        sri.setInstanceResolver((MetaDataResolver)this.metadata);
        sri.getMetaData().addMetaData((Object)"DISPATCHER", (Object)"OID", (Object)this.containerId, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILY_WRAPPER", (Object)this.family, PayloadKey.TRANSIENT);
        sri.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"LOADBALANCE_POLICY", (Object)this.lbPolicy, PayloadKey.TRANSIENT);
        sri.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"HA_TARGET", this.originTarget, PayloadKey.TRANSIENT);
        sri.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"PARTITION_NAME", (Object)this.partitionName, PayloadKey.TRANSIENT);
        sri.getMetaData().addMetaData((Object)"REMOTING", (Object)"SUBSYSTEM", (Object)"AOP", PayloadKey.AS_IS);
        sri.getMetaData().addMetaData((Object)"IS_LOCAL", (Object)"GUID", (Object)this.containerGuid, PayloadKey.AS_IS);
        if (this.provider != null) {
            sri.getMetaData().addMetaData((Object)"ASYNCH", (Object)"INVOKE_ASYNCH", (Object)"YES", PayloadKey.AS_IS);
        }
        return sri.invokeNext();
    }

    public Object getAsynchronousProxy(Object proxy) {
        Class<?>[] infs = proxy.getClass().getInterfaces();
        if (!ProxyUtils.isAsynchronous(infs)) {
            Class<?>[] interfaces = ProxyUtils.addAsynchProviderInterface(infs);
            AsynchMixin mixin = new AsynchMixin();
            Interceptor[] newInterceptors = ProxyUtils.addAsynchProxyInterceptor(mixin, this.interceptors);
            StatelessClusteredInvocationHandler handler = new StatelessClusteredInvocationHandler((AsynchProvider)mixin, this.containerId, this.containerGuid, newInterceptors, this.family, this.lbPolicy, this.partitionName, this.originTarget, this.getBusinessInterfaceType());
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)handler);
        }
        return proxy;
    }

    public String toString() {
        return this.containerId.toString();
    }
}

