/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ClusterLoaderConfiguration;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.parsing.XmlConfigHelper;

public class ClusterLoaderConfigurationBuilder
extends AbstractStoreConfigurationBuilder<ClusterLoaderConfiguration, ClusterLoaderConfigurationBuilder> {
    private long remoteCallTimeout = TimeUnit.SECONDS.toMillis(15L);

    public ClusterLoaderConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
    }

    public ClusterLoaderConfigurationBuilder self() {
        return this;
    }

    public ClusterLoaderConfigurationBuilder remoteCallTimeout(long remoteCallTimeout) {
        this.remoteCallTimeout = remoteCallTimeout;
        return this;
    }

    public ClusterLoaderConfigurationBuilder remoteCallTimeout(long remoteCallTimeout, TimeUnit unit) {
        this.remoteCallTimeout = unit.toMillis(remoteCallTimeout);
        return this;
    }

    @Override
    public ClusterLoaderConfigurationBuilder withProperties(Properties p) {
        this.properties = p;
        XmlConfigHelper.setValues(this, this.properties, false, true);
        return this;
    }

    @Override
    public void validate() {
    }

    public ClusterLoaderConfiguration create() {
        return new ClusterLoaderConfiguration(this.purgeOnStartup, this.fetchPersistentState, this.ignoreModifications, this.async.create(), this.singletonStore.create(), this.preload, this.shared, this.properties, this.remoteCallTimeout);
    }

    public ClusterLoaderConfigurationBuilder read(ClusterLoaderConfiguration template) {
        super.read(template);
        this.remoteCallTimeout = template.remoteCallTimeout();
        this.properties = template.properties();
        return this;
    }
}

