package ibase.e12ria.e12table.client;

import ibase.e12ria.e12table.client.E12CustomTextCell.CellData;

import java.util.HashMap;

import com.google.gwt.cell.client.Cell.Context;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;

public class E12CustomColumn extends Column<DataGridTableRowModel, String> 
{
	private int index;
	private double totalValue;
	private AbstractDataGrid<DataGridTableRowModel> e12AdvDataGrid;
	private ItemChanger<DataGridTableRowModel, String> itemChanger;
	private FieldUpdater<DataGridTableRowModel, String> fieldUpdater;
	private PophelpInvoker<DataGridTableRowModel, String> pophelpInvoker;
	
	public E12CustomColumn( int index, boolean isEditable )
	{
		super( new E12CustomTextCell( isEditable ) );
		this.index = index;
		this.totalValue = 0.0;
	}

	public E12CustomColumn( int index, boolean isEditable, AbstractDataGrid<DataGridTableRowModel> e12AdvDataGrid )
	{
		super( new E12CustomTextCell( isEditable ) );
		this.index = index;
		this.totalValue = 0;
		this.e12AdvDataGrid = e12AdvDataGrid;
	}

	public E12CustomColumn( int index, HashMap<String, String> options )
	{
		super( new E12SelectionCell(options) );
		this.index = index;
	}

	//Added By Prashant Chavan on 11-Mar-15 [For Dashboard report cell with Link option ] Start
	public E12CustomColumn( int index, boolean isEditable ,String linkName )
	{
		super( new E12CustomTextCell( isEditable,linkName ) );
		this.index = index;
		this.totalValue = 0.0;
	}
	//Added By Prashant Chavan on 11-Mar-15 [For Dashboard report cell with Link option ] Start
	
	
	@Override
	public String getValue( DataGridTableRowModel dataGridTRModel ) 
	{
		return dataGridTRModel.getCellText(index);
	}

	public double getTotalValue() {
		return totalValue;
	}

	public void setTotalValue( double totalValue ) {
		this.totalValue = totalValue;
	}

	public ItemChanger<DataGridTableRowModel, String> getItemChanger() {
		return itemChanger;
	}

	public void setItemChanger(ItemChanger<DataGridTableRowModel, String> itemChanger) {
		this.itemChanger = itemChanger;
	}

	public PophelpInvoker<DataGridTableRowModel, String> getPophelpInvoker() {
		return pophelpInvoker;
	}

	public void setPophelpInvoker(PophelpInvoker<DataGridTableRowModel, String> pophelpInvoker) {
		this.pophelpInvoker = pophelpInvoker;
	}

	@Override
	public void onBrowserEvent(Context context, Element parent, DataGridTableRowModel dataGridTRModel, NativeEvent event) 
	{
		fieldUpdater = getFieldUpdater();
	    final int index = context.getIndex();
	    final DataGridTableRowModel object = dataGridTRModel;
	    ValueUpdater<String> valueUpdater =  new E12CellUpdater<String>() {
	    	@Override
		    public void update(String value) 
	    	{
	    	  if(fieldUpdater != null)
	    	  {
	    		  fieldUpdater.update(index, object, value);
	    	  }
		    }

	      	@Override
			public void doItemChange(String value) 
	      	{
	      		if(itemChanger != null)
	      		{
	      			itemChanger.itemChanged(index, object, value);
	      		}
			}
	
			@Override
			public void showPophelp(String value) 
			{
				if(pophelpInvoker != null)
				{
					pophelpInvoker.invokePophelp(index, object, value);
				}
			}
	    };
	    if( e12AdvDataGrid != null )
	    {
	    	( (E12CustomTextCell)getCell() ).setParent( e12AdvDataGrid );
	    }
	    getCell().onBrowserEvent(context, parent, getValue(object), event, valueUpdater);
	}
	
	@Override
	public void render( Context context, DataGridTableRowModel object, SafeHtmlBuilder sb ) 
	{
		//Changed By Mahesh Patidar on 28/MAY/13[to change for default data calculation]
		try
		{
			// To restrict totaling on Checkbox selection
//			E12CommonUtils.printOnConsole("isPerformTotaling[" + e12AdvDataGrid.isPerformTotaling() + "]");
			if( e12AdvDataGrid != null && e12AdvDataGrid.isPerformTotaling() )
			{
				int firstdomId = e12AdvDataGrid.getVisibleItems().get(0).getIntDomID();
				if(firstdomId == object.getIntDomID())
				{
					this.totalValue = 0.0;
				}
				CellData cellData = object.getCellData(index);
				if( cellData!= null && cellData.isNumber() && cellData.getSummationFormat().indexOf("sum(") != -1 )
				{
					double oldValue = 0.0;
					try
					{
						oldValue = Double.parseDouble( cellData.getOriginalText() );
					}
					catch (Exception e) 
					{
						oldValue = 0.0;
					}
					this.totalValue += oldValue ;
//					E12CommonUtils.printOnConsole( "E12CustomColumn render: oldValue[" + oldValue + "]newValue[" + cellData.getData() + "]totalValue[" + totalValue + "]" );
					e12AdvDataGrid.redrawFooters();
				}
			}
		}
		catch(Exception e)
		{
		}
		//Ended By Mahesh Patidar
		super.render(context, object, sb);
	}
	
	
}