package ibase.e12ria.e12widgets.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;

public class AndroidDownloader {
	
	public static class Params {
		protected String dirName;
		protected String fileName;
		protected boolean overwrite;
		protected String storeFileName;
		
		public void setDirName(String dirName) {
			this.dirName = dirName;
		}
		
		public String getDirName() {
			return dirName;
		}
		
		public void setFileName(String fileName) {
			this.fileName = fileName;
		}
		
		public String getFileName() {
			return fileName;
		}
		
		public void setOverwrite(boolean overwrite) {
			this.overwrite = overwrite;
		}
		
		public boolean isOverwrite() {
			return overwrite;
		}
		
		public void setStoreFileName( String storeFileName )
		{
			this.storeFileName = storeFileName;
		}
		
		public String getStoreFileName()
		{
			return storeFileName;
		}
		
		
		
		
		protected List<String> toJsonStringList() {
			List<String> list = new ArrayList<String>();
			if (dirName != null) {
				list.add("\"dirName\":\"" + dirName + "\"");
			}
			if (fileName != null) {
				list.add("\"fileName\":\"" + fileName + "\"");
			}
			list.add("\"overwrite\":\"" + overwrite + "\"");
			return list;
		}
		
		protected String toJsonString() {
			StringBuilder s = new StringBuilder();
			s.append("{");
			for (String string : toJsonStringList()) {
				s.append(string + ",");
			}
			if (s.charAt(s.length() - 1) == ',') {
				s.deleteCharAt(s.length() - 1);
			}
			s.append("}");
			return s.toString();
		}
	}
	
	public static class Result extends JavaScriptObject {
		protected Result() {
			
		}
		
		public final native boolean getStatus() /*-{
			if (this.status == 1) {
				return true;
			} else {
				return false;
			}
		}-*/;
		
		public final native int getProgress() /*-{
			return this.progress;
		}-*/;
		
		public final native int getTotal() /*-{
			return this.total;
		}-*/;
		
		public final native String getFile() /*-{
			return this.file;
		}-*/;
	}
	
	public static interface Callback {
		void onError(Exception e);
		void onSuccess(Result result);
	}
	
	public void downloadFile(String url, Params params, final Callback callback) {
		setLoading(true);
		downloadFile(url, params, true, new Callback() {
			@Override
			public void onSuccess(Result result) {
				setLoading(false);
				callback.onSuccess(result);
			}
			@Override
			public void onError(Exception e) {
				setLoading(false);
				callback.onError(e);
			}
		});
	}
	
	public native void downloadFile(String url, Params params, boolean dummy, Callback callback) /*-{
		if ($wnd.plugins === undefined) {
			this.@ibase.e12ria.e12widgets.client.AndroidDownloader::throwPluginNotFoundException(Libase/e12ria/e12widgets/client/AndroidDownloader$Callback;)(callback);
			return;
		}
		var successCallback = function(result) {
			callback.@ibase.e12ria.e12widgets.client.AndroidDownloader.Callback::onSuccess(Libase/e12ria/e12widgets/client/AndroidDownloader$Result;)(result);
		};
		var errorCallback = function(error) {
			callback.@ibase.e12ria.e12widgets.client.AndroidDownloader.Callback::onError(Ljava/lang/Exception;)(error);
		};
		var paramsJson = eval("(" + params.@ibase.e12ria.e12widgets.client.AndroidDownloader.Params::toJsonString()() + ")");
		$wnd.plugins.downloader.downloadFile(url, paramsJson, successCallback, errorCallback);
	}-*/;
	
	protected void throwPluginNotFoundException(Callback callback) {
		NullPointerException nullPointerException = new NullPointerException("window.plugins is undefined");
		callback.onError(nullPointerException);
	}

	// Loading panel look & feel
	private Stack<Object> loadingStack = new Stack<Object>();
	private PopupPanel loadingPnl = null;
	public void setLoading( boolean flag ) 
	{
		if( loadingPnl == null )
		{
			loadingPnl = new PopupPanel();
			loadingPnl.add(new Image("large-loading.gif"));
			loadingPnl.setModal(true);
			loadingPnl.setGlassEnabled(true);
			loadingPnl.center();
		}
		if( flag )
		{
			loadingStack.push(new Object());
			loadingPnl.show();
		}
		else
		{
			loadingStack.pop();
			if( loadingStack.isEmpty() )
			{
				loadingPnl.hide();
			}
		}
	}

}
