/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 $
//  type=lu
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "lu" locale.
 */
public class LocalizedNamesImpl_lu extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "ZA",
        "AF",
        "AZ",
        "SA",
        "DE",
        "AR",
        "DZ",
        "AL",
        "AM",
        "US",
        "AD",
        "GB",
        "AI",
        "AO",
        "AG",
        "AN",
        "AQ",
        "AW",
        "AX",
        "HT",
        "BS",
        "BH",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BD",
        "BM",
        "BG",
        "BL",
        "BQ",
        "BN",
        "BF",
        "BI",
        "BT",
        "BV",
        "BY",
        "CC",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "CF",
        "CZ",
        "DO",
        "CD",
        "DJ",
        "DM",
        "EA",
        "EH",
        "EC",
        "ER",
        "EE",
        "ET",
        "EU",
        "FI",
        "FO",
        "FJ",
        "GM",
        "GG",
        "GQ",
        "GF",
        "GS",
        "HK",
        "HM",
        "IC",
        "IM",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "UY",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "GI",
        "JO",
        "GE",
        "NC",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "CR",
        "CI",
        "KW",
        "HR",
        "CU",
        "LA",
        "AE",
        "RE",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LU",
        "LI",
        "LT",
        "CV",
        "KY",
        "CK",
        "FK",
        "MP",
        "MH",
        "NF",
        "SB",
        "TC",
        "VI",
        "VG",
        "IO",
        "MG",
        "MV",
        "MW",
        "MY",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MK",
        "YT",
        "BO",
        "BA",
        "BW",
        "ME",
        "MX",
        "MF",
        "FM",
        "BR",
        "MO",
        "MD",
        "MC",
        "MN",
        "MU",
        "MR",
        "MZ",
        "PL",
        "PR",
        "PT",
        "MS",
        "EG",
        "MM",
        "NA",
        "NR",
        "NP",
        "FR",
        "PH",
        "GA",
        "GH",
        "GR",
        "GD",
        "GN",
        "GW",
        "GY",
        "GL",
        "GP",
        "GU",
        "GT",
        "NE",
        "NG",
        "NI",
        "NO",
        "CS",
        "ES",
        "VA",
        "NU",
        "NL",
        "OM",
        "HN",
        "HU",
        "AU",
        "AT",
        "PK",
        "PY",
        "PW",
        "PS",
        "PA",
        "PG",
        "PE",
        "PN",
        "PF",
        "QO",
        "RU",
        "RO",
        "RS",
        "RW",
        "WS",
        "AS",
        "SH",
        "KN",
        "LC",
        "SM",
        "PM",
        "VC",
        "ST",
        "SV",
        "SN",
        "SC",
        "CL",
        "CN",
        "CY",
        "SL",
        "SK",
        "SI",
        "SG",
        "SY",
        "LK",
        "SJ",
        "SO",
        "SS",
        "SD",
        "SR",
        "SE",
        "SZ",
        "CH",
        "SX",
        "TA",
        "TW",
        "TZ",
        "TH",
        "TJ",
        "TF",
        "TL",
        "TT",
        "TN",
        "TG",
        "TK",
        "TO",
        "TD",
        "TM",
        "TR",
        "TV",
        "UG",
        "UA",
        "UM",
        "UZ",
        "VU",
        "VE",
        "VN",
        "WF",
        "YE",
        "ZM",
        "NZ",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andore");
    namesMap.put("AE", "Lemila alabu");
    namesMap.put("AF", "Afuganisita");
    namesMap.put("AG", "Antiga ne Barbuda");
    namesMap.put("AI", "Angiye");
    namesMap.put("AL", "Alubani");
    namesMap.put("AM", "Ameni");
    namesMap.put("AN", "Antiye wa Olande");
    namesMap.put("AR", "Alijantine");
    namesMap.put("AS", "Samoa wa Ameriki");
    namesMap.put("AT", "Otilisi");
    namesMap.put("AU", "Ositali");
    namesMap.put("AZ", "Ajelbayidja");
    namesMap.put("BA", "Mbosini ne Hezegovine");
    namesMap.put("BB", "Barebade");
    namesMap.put("BD", "Benguladeshi");
    namesMap.put("BE", "Belejiki");
    namesMap.put("BF", "Bukinafaso");
    namesMap.put("BG", "Biligari");
    namesMap.put("BH", "Bahrene");
    namesMap.put("BJ", "Bene");
    namesMap.put("BN", "Brineyi");
    namesMap.put("BO", "Mbolivi");
    namesMap.put("BR", "Mnulezile");
    namesMap.put("BS", "Bahamase");
    namesMap.put("BT", "Butani");
    namesMap.put("BW", "Mbotswana");
    namesMap.put("BY", "Byelorisi");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Ditunga wa Kongu");
    namesMap.put("CF", "Ditunga dya Afrika wa munkatshi");
    namesMap.put("CG", "Kongu");
    namesMap.put("CH", "Swise");
    namesMap.put("CI", "Kotedivuale");
    namesMap.put("CK", "Lutanda lua Kookɛ");
    namesMap.put("CL", "Shili");
    namesMap.put("CM", "Kamerune");
    namesMap.put("CN", "Shine");
    namesMap.put("CO", "Kolombi");
    namesMap.put("CR", "Kositarika");
    namesMap.put("CS", "Nsebi ne Montenegro");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Lutanda lua Kapevele");
    namesMap.put("CY", "Shipele");
    namesMap.put("CZ", "Ditunga dya Tsheka");
    namesMap.put("DE", "Alemanu");
    namesMap.put("DJ", "Djibuti");
    namesMap.put("DK", "Danemalaku");
    namesMap.put("DM", "Duminiku");
    namesMap.put("DO", "Ditunga wa Duminiku");
    namesMap.put("DZ", "Alijeri");
    namesMap.put("EC", "Ekwatele");
    namesMap.put("EE", "Esitoni");
    namesMap.put("EG", "Mushidi");
    namesMap.put("ER", "Elitele");
    namesMap.put("ES", "Nsipani");
    namesMap.put("ET", "Etshiopi");
    namesMap.put("FI", "Filande");
    namesMap.put("FJ", "Fuji");
    namesMap.put("FK", "Lutanda lua Maluni");
    namesMap.put("FM", "Mikronezi");
    namesMap.put("FR", "Nfalanse");
    namesMap.put("GA", "Ngabu");
    namesMap.put("GB", "Angeletele");
    namesMap.put("GD", "Ngelenade");
    namesMap.put("GE", "Joriji");
    namesMap.put("GF", "Giyane wa Nfalanse");
    namesMap.put("GH", "Ngana");
    namesMap.put("GI", "Jibeletale");
    namesMap.put("GL", "Ngowelande");
    namesMap.put("GM", "Gambi");
    namesMap.put("GN", "Ngine");
    namesMap.put("GP", "Ngwadelupe");
    namesMap.put("GQ", "Gine Ekwatele");
    namesMap.put("GR", "Ngeleka");
    namesMap.put("GT", "Ngwatemala");
    namesMap.put("GU", "Ngwame");
    namesMap.put("GW", "Nginebisau");
    namesMap.put("GY", "Ngiyane");
    namesMap.put("HN", "Ondurase");
    namesMap.put("HR", "Krowasi");
    namesMap.put("HT", "Ayiti");
    namesMap.put("HU", "Ongili");
    namesMap.put("ID", "Indonezi");
    namesMap.put("IE", "Irelande");
    namesMap.put("IL", "Isirayele");
    namesMap.put("IN", "Inde");
    namesMap.put("IO", "Lutanda lwa Angeletele ku mbu wa Indiya");
    namesMap.put("IQ", "Iraki");
    namesMap.put("IR", "Ira");
    namesMap.put("IS", "Isilande");
    namesMap.put("IT", "Itali");
    namesMap.put("JM", "Jamaiki");
    namesMap.put("JO", "Jodani");
    namesMap.put("JP", "Japu");
    namesMap.put("KG", "Kigizisita");
    namesMap.put("KH", "Kambodza");
    namesMap.put("KM", "Komoru");
    namesMap.put("KN", "Santu krístofe ne Neves");
    namesMap.put("KP", "Kore wa muulu");
    namesMap.put("KR", "Kore wa mwinshi");
    namesMap.put("KW", "Koweti");
    namesMap.put("KY", "Lutanda lua Kayima");
    namesMap.put("KZ", "Kazakusita");
    namesMap.put("LA", "Lawosi");
    namesMap.put("LB", "Liba");
    namesMap.put("LC", "Santu lisi");
    namesMap.put("LI", "Lishuteni");
    namesMap.put("LK", "Sirilanka");
    namesMap.put("LR", "Liberiya");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litwani");
    namesMap.put("LU", "Likisambulu");
    namesMap.put("LV", "Letoni");
    namesMap.put("LY", "Libi");
    namesMap.put("MA", "Maroke");
    namesMap.put("MC", "Monaku");
    namesMap.put("MD", "Molidavi");
    namesMap.put("MG", "Madagasikari");
    namesMap.put("MH", "Lutanda lua Marishale");
    namesMap.put("MK", "Masedwane");
    namesMap.put("MM", "Myamare");
    namesMap.put("MN", "Mongoli");
    namesMap.put("MP", "Lutanda lua Mariane wa muulu");
    namesMap.put("MQ", "Martiniki");
    namesMap.put("MR", "Moritani");
    namesMap.put("MS", "Musera");
    namesMap.put("MT", "Malite");
    namesMap.put("MU", "Morise");
    namesMap.put("MV", "Madive");
    namesMap.put("MX", "Meksike");
    namesMap.put("MY", "Malezi");
    namesMap.put("MZ", "Mozambiki");
    namesMap.put("NA", "Namibi");
    namesMap.put("NC", "Kaledoni wa mumu");
    namesMap.put("NE", "Nijere");
    namesMap.put("NF", "Lutanda lua Norfok");
    namesMap.put("NG", "Nijerya");
    namesMap.put("NI", "Nikaragwa");
    namesMap.put("NL", "Olandɛ");
    namesMap.put("NO", "Noriveje");
    namesMap.put("NP", "Nepálɛ");
    namesMap.put("NU", "Nyue");
    namesMap.put("NZ", "Zelanda wa mumu");
    namesMap.put("OM", "Omane");
    namesMap.put("PF", "Polinezi wa Nfalanse");
    namesMap.put("PG", "Papwazi wa Nginɛ wa mumu");
    namesMap.put("PH", "Nfilipi");
    namesMap.put("PK", "Pakisita");
    namesMap.put("PL", "Mpoloni");
    namesMap.put("PM", "Santu pététo ne Mikelu");
    namesMap.put("PN", "Pikairni");
    namesMap.put("PR", "Mpotoriku");
    namesMap.put("PS", "Palesine");
    namesMap.put("PT", "Mputulugeshi");
    namesMap.put("PY", "Palagwei");
    namesMap.put("QA", "Katari");
    namesMap.put("RE", "Lenyo");
    namesMap.put("RO", "Romani");
    namesMap.put("RU", "Risi");
    namesMap.put("SA", "Alabu Nsawudi");
    namesMap.put("SB", "Lutanda lua Solomu");
    namesMap.put("SC", "Seshele");
    namesMap.put("SD", "Suda");
    namesMap.put("SE", "Suwedi");
    namesMap.put("SG", "Singapure");
    namesMap.put("SH", "Santu eleni");
    namesMap.put("SI", "Siloveni");
    namesMap.put("SK", "Silovaki");
    namesMap.put("SL", "Siera Leone");
    namesMap.put("SM", "Santu Marine");
    namesMap.put("SN", "Senegale");
    namesMap.put("SO", "Somali");
    namesMap.put("ST", "Sao Tome ne Presipɛ");
    namesMap.put("SV", "Savadore");
    namesMap.put("SY", "Siri");
    namesMap.put("SZ", "Swazilandi");
    namesMap.put("TC", "Lutanda lua Tuluki ne Kaiko");
    namesMap.put("TD", "Tshadi");
    namesMap.put("TG", "Togu");
    namesMap.put("TH", "Tayilanda");
    namesMap.put("TJ", "Tazikisita");
    namesMap.put("TL", "Timoru wa diboku");
    namesMap.put("TM", "Tukemenisita");
    namesMap.put("TN", "Tinizi");
    namesMap.put("TR", "Tuluki");
    namesMap.put("TT", "Tinidade ne Tobago");
    namesMap.put("TW", "Taiwani");
    namesMap.put("TZ", "Tanzani");
    namesMap.put("UA", "Ukreni");
    namesMap.put("US", "Ameriki");
    namesMap.put("UY", "Irigwei");
    namesMap.put("UZ", "Uzibekisita");
    namesMap.put("VA", "Nvatika");
    namesMap.put("VC", "Santu vesa ne Ngelenadine");
    namesMap.put("VG", "Lutanda lua Vierzi wa Angeletele");
    namesMap.put("VI", "Lutanda lua Vierzi wa Ameriki");
    namesMap.put("VN", "Viyetiname");
    namesMap.put("WF", "Walise ne Futuna");
    namesMap.put("YE", "Yemenu");
    namesMap.put("YT", "Mayote");
    namesMap.put("ZA", "Afrika ya Súdi");
    namesMap.put("ZM", "Zambi");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andore",
        "AE": "Lemila alabu",
        "AF": "Afuganisita",
        "AG": "Antiga ne Barbuda",
        "AI": "Angiye",
        "AL": "Alubani",
        "AM": "Ameni",
        "AN": "Antiye wa Olande",
        "AR": "Alijantine",
        "AS": "Samoa wa Ameriki",
        "AT": "Otilisi",
        "AU": "Ositali",
        "AZ": "Ajelbayidja",
        "BA": "Mbosini ne Hezegovine",
        "BB": "Barebade",
        "BD": "Benguladeshi",
        "BE": "Belejiki",
        "BF": "Bukinafaso",
        "BG": "Biligari",
        "BH": "Bahrene",
        "BJ": "Bene",
        "BN": "Brineyi",
        "BO": "Mbolivi",
        "BR": "Mnulezile",
        "BS": "Bahamase",
        "BT": "Butani",
        "BW": "Mbotswana",
        "BY": "Byelorisi",
        "CA": "Kanada",
        "CD": "Ditunga wa Kongu",
        "CF": "Ditunga dya Afrika wa munkatshi",
        "CG": "Kongu",
        "CH": "Swise",
        "CI": "Kotedivuale",
        "CK": "Lutanda lua Kookɛ",
        "CL": "Shili",
        "CM": "Kamerune",
        "CN": "Shine",
        "CO": "Kolombi",
        "CR": "Kositarika",
        "CS": "Nsebi ne Montenegro",
        "CU": "Kuba",
        "CV": "Lutanda lua Kapevele",
        "CY": "Shipele",
        "CZ": "Ditunga dya Tsheka",
        "DE": "Alemanu",
        "DJ": "Djibuti",
        "DK": "Danemalaku",
        "DM": "Duminiku",
        "DO": "Ditunga wa Duminiku",
        "DZ": "Alijeri",
        "EC": "Ekwatele",
        "EE": "Esitoni",
        "EG": "Mushidi",
        "ER": "Elitele",
        "ES": "Nsipani",
        "ET": "Etshiopi",
        "FI": "Filande",
        "FJ": "Fuji",
        "FK": "Lutanda lua Maluni",
        "FM": "Mikronezi",
        "FR": "Nfalanse",
        "GA": "Ngabu",
        "GB": "Angeletele",
        "GD": "Ngelenade",
        "GE": "Joriji",
        "GF": "Giyane wa Nfalanse",
        "GH": "Ngana",
        "GI": "Jibeletale",
        "GL": "Ngowelande",
        "GM": "Gambi",
        "GN": "Ngine",
        "GP": "Ngwadelupe",
        "GQ": "Gine Ekwatele",
        "GR": "Ngeleka",
        "GT": "Ngwatemala",
        "GU": "Ngwame",
        "GW": "Nginebisau",
        "GY": "Ngiyane",
        "HN": "Ondurase",
        "HR": "Krowasi",
        "HT": "Ayiti",
        "HU": "Ongili",
        "ID": "Indonezi",
        "IE": "Irelande",
        "IL": "Isirayele",
        "IN": "Inde",
        "IO": "Lutanda lwa Angeletele ku mbu wa Indiya",
        "IQ": "Iraki",
        "IR": "Ira",
        "IS": "Isilande",
        "IT": "Itali",
        "JM": "Jamaiki",
        "JO": "Jodani",
        "JP": "Japu",
        "KG": "Kigizisita",
        "KH": "Kambodza",
        "KM": "Komoru",
        "KN": "Santu krístofe ne Neves",
        "KP": "Kore wa muulu",
        "KR": "Kore wa mwinshi",
        "KW": "Koweti",
        "KY": "Lutanda lua Kayima",
        "KZ": "Kazakusita",
        "LA": "Lawosi",
        "LB": "Liba",
        "LC": "Santu lisi",
        "LI": "Lishuteni",
        "LK": "Sirilanka",
        "LR": "Liberiya",
        "LS": "Lesoto",
        "LT": "Litwani",
        "LU": "Likisambulu",
        "LV": "Letoni",
        "LY": "Libi",
        "MA": "Maroke",
        "MC": "Monaku",
        "MD": "Molidavi",
        "MG": "Madagasikari",
        "MH": "Lutanda lua Marishale",
        "MK": "Masedwane",
        "MM": "Myamare",
        "MN": "Mongoli",
        "MP": "Lutanda lua Mariane wa muulu",
        "MQ": "Martiniki",
        "MR": "Moritani",
        "MS": "Musera",
        "MT": "Malite",
        "MU": "Morise",
        "MV": "Madive",
        "MX": "Meksike",
        "MY": "Malezi",
        "MZ": "Mozambiki",
        "NA": "Namibi",
        "NC": "Kaledoni wa mumu",
        "NE": "Nijere",
        "NF": "Lutanda lua Norfok",
        "NG": "Nijerya",
        "NI": "Nikaragwa",
        "NL": "Olandɛ",
        "NO": "Noriveje",
        "NP": "Nepálɛ",
        "NU": "Nyue",
        "NZ": "Zelanda wa mumu",
        "OM": "Omane",
        "PF": "Polinezi wa Nfalanse",
        "PG": "Papwazi wa Nginɛ wa mumu",
        "PH": "Nfilipi",
        "PK": "Pakisita",
        "PL": "Mpoloni",
        "PM": "Santu pététo ne Mikelu",
        "PN": "Pikairni",
        "PR": "Mpotoriku",
        "PS": "Palesine",
        "PT": "Mputulugeshi",
        "PY": "Palagwei",
        "QA": "Katari",
        "RE": "Lenyo",
        "RO": "Romani",
        "RU": "Risi",
        "SA": "Alabu Nsawudi",
        "SB": "Lutanda lua Solomu",
        "SC": "Seshele",
        "SD": "Suda",
        "SE": "Suwedi",
        "SG": "Singapure",
        "SH": "Santu eleni",
        "SI": "Siloveni",
        "SK": "Silovaki",
        "SL": "Siera Leone",
        "SM": "Santu Marine",
        "SN": "Senegale",
        "SO": "Somali",
        "ST": "Sao Tome ne Presipɛ",
        "SV": "Savadore",
        "SY": "Siri",
        "SZ": "Swazilandi",
        "TC": "Lutanda lua Tuluki ne Kaiko",
        "TD": "Tshadi",
        "TG": "Togu",
        "TH": "Tayilanda",
        "TJ": "Tazikisita",
        "TL": "Timoru wa diboku",
        "TM": "Tukemenisita",
        "TN": "Tinizi",
        "TR": "Tuluki",
        "TT": "Tinidade ne Tobago",
        "TW": "Taiwani",
        "TZ": "Tanzani",
        "UA": "Ukreni",
        "US": "Ameriki",
        "UY": "Irigwei",
        "UZ": "Uzibekisita",
        "VA": "Nvatika",
        "VC": "Santu vesa ne Ngelenadine",
        "VG": "Lutanda lua Vierzi wa Angeletele",
        "VI": "Lutanda lua Vierzi wa Ameriki",
        "VN": "Viyetiname",
        "WF": "Walise ne Futuna",
        "YE": "Yemenu",
        "YT": "Mayote",
        "ZA": "Afrika ya Súdi",
        "ZM": "Zambi"
    };
  }-*/;
}
