/*  PURPOSE  : Scan loc_code and lon_no OR LOT_SL then Display Detail information of stock.
 *  AUTHOR   : Created By Dhanraj Thakare On 05/09/2014 W14FSUN004 
 *  
 */

package ibase.webitm.bean.wms;
import ibase.system.config.AppConnectParm;
import ibase.webitm.ejb.wms.InventoryDispInfoDBRemote;
import ibase.webitm.utility.ITMException;

import java.io.Serializable;
//import java.util.HashMap;

import javax.naming.InitialContext;

@SuppressWarnings("serial")
public class InventoryDispInfoBean  implements Serializable{

	private String locationCode ;                                                                                                                                                                                        
	private String qty;   
	private String lonNo;
	private String lotSl;
	private String location ;                                                                                                                                                                                        
	private String allQty;   
	private String holdQty;
	private String noArt;
	private String grossWt;
	
    InventoryDispInfoDBRemote inventoryDispInfoRemote = null;                                                                                                                                                                                
	
    public InventoryDispInfoBean()
	{
		System.out.println("inside InventoryDispInfoBean Created");
		InitialContext ctx  = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			inventoryDispInfoRemote = (InventoryDispInfoDBRemote) ctx.lookup("ibase/InventoryDispInfoDB/remote");
			System.out.println("instance created");
			
		}
		catch(Exception e)
		{
			System.out.println("Exception in creating InventoryDispInfoRemote");
			e.printStackTrace();
		}
	
	}
	public InventoryDispInfoBean(String locationCode, String qty, String lonNo,
			String lotSl, String location, String allQty, String holdQty,
			String noArt, String grossWt) {
		super();
		this.locationCode = locationCode;
		this.qty = qty;
		this.lonNo = lonNo;
		this.lotSl = lotSl;
		this.location = location;
		this.allQty = allQty;
		this.holdQty = holdQty;
		this.noArt = noArt;
		this.grossWt = grossWt;
		
	}
	
	public String getLocationCode() {
		return locationCode;
	}
	public void setLocationCode(String locationCode) {
		this.locationCode = locationCode;
	}
	public String getQty() {
		return qty;
	}
	public void setQty(String qty) {
		this.qty = qty;
	}
	public String getLonNo() {
		return lonNo;
	}
	public void setLonNo(String lonNo) {
		this.lonNo = lonNo;
	}
	public String getLotSl() {
		return lotSl;
	}
	public void setLotSl(String lotSl) {
		this.lotSl = lotSl;
	}
	public String getLocation() {
		return location;
	}
	public void setLocation(String location) {
		this.location = location;
	}
	public String getAllQty() {
		return allQty;
	}
	public void setAllQty(String allQty) {
		this.allQty = allQty;
	}
	public String getHoldQty() {
		return holdQty;
	}
	public void setHoldQty(String holdQty) {
		this.holdQty = holdQty;
	}
	public String getNoArt() {
		return noArt;
	}
	public void setNoArt(String noArt) {
		this.noArt = noArt;
	}
	public String getGrossWt() {
		return grossWt;
	}
	public void setGrossWt(String grossWt) {
		this.grossWt = grossWt;
	}


	public String getStocklDataLoc(String location,String lotNo,String lpn,String site) throws ITMException
	{
		String stockData = "";
		try
		{
			stockData = inventoryDispInfoRemote.getStocklDataLoc( location,lotNo,lpn,site) ;
			System.out.println("  bean stockData1=====>"+stockData);
			
		}
		catch(Exception e)
		{
			System.out.println("Exception in InventoryDispInfoDB.getStocklDataLoc() in accessing EJB");
			e.printStackTrace();
			stockData = null;
		}
		
		System.out.println("  bean stockData2=====>"+stockData);
		return stockData;
	}	
	
	/*public String getStocklDataLpn(String lpnNo) throws ITMException
	{
		String stockData = "";
		try
		{
			stockData = inventoryDispInfoRemote.getStocklDataLpn( lpnNo) ;
		}
		catch(Exception e)
		{
			System.out.println("Exception in InventoryDispInfoDB.getStocklDataLpn() in accessing EJB");
			e.printStackTrace();
			stockData = null;
		}
		return stockData;
	}*/
	

}
