package ibase.webitm.util.gst;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

import javax.crypto.KeyGenerator;
import javax.xml.bind.DatatypeConverter;

import ibase.planner.utility.ITMException;

public class GSPSignature 
{
	private static KeyGenerator KEYGEN;
	final String CHARACTER_ENCODING = "UTF-8";
	final String AES_ALGORITHM = "AES";
    final int ENC_BITS = 256;
	
	public GSPSignature()
	{
		try 
		{
			KEYGEN = KeyGenerator.getInstance(AES_ALGORITHM);
			KEYGEN.init(ENC_BITS);
		} 
		catch (Exception e) 
		{
			System.out.println("GSPSignature.GSPSignature()["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}
	
	public PrivateKey loadPrivateKey(InputStream privateKeyInputStream) throws IOException, GeneralSecurityException, ITMException 
    {
        PrivateKey key = null;
        try 
        {
            BufferedReader br = new BufferedReader(new InputStreamReader(privateKeyInputStream));
            StringBuilder builder = new StringBuilder();
            boolean inKey = false;
            for (String line = br.readLine(); line != null; line = br.readLine()) 
            {
                if (!inKey) 
                {
                    if (line.startsWith("-----BEGIN ") && line.endsWith(" PRIVATE KEY-----")) 
                    {
                        inKey = true;
                    }
                    continue;
                }
                else 
                {
                    if (line.startsWith("-----END ") && line.endsWith(" PRIVATE KEY-----"))
                    {
                        inKey = false;
                        break;
                    }
                    builder.append(line);
                }
            }
            byte[] encoded = DatatypeConverter.parseBase64Binary(builder.toString());
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            key = kf.generatePrivate(keySpec);
        } 
        catch (Exception e) 
        {
			System.out.println("GSPSignature.loadPrivateKey()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
			
		}
        return key;
    }
	
	public String sign(String message, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException 
    {
        Signature sig = Signature.getInstance("SHA1WithRSA");
        sig.initSign(privateKey);
        sig.update(message.getBytes());
        byte[] signatureBytes = sig.sign();
        String signature = Base64.getEncoder().encodeToString(signatureBytes);
        System.out.println("Signature:" + signature);
        return signature;
    }
	

}
