<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />
	<xsl:decimal-format NaN="0" />

	<xsl:template match="/">

		<html>

			<link id="userThemeLink" type="text/css" rel="stylesheet" href="" />

			<script type="text/javascript" src="/ibase/webitm/js/splitter/jquery.js"></script>
			<script type="text/javascript" src="/ibase/webitm/js/splitter/splitter-152.js"></script>

			<link href="/ibase/webitm/js/fixed-header/fixed_table_rc.css"
				rel="stylesheet" />

			<script language="JavaScript" type="text/javascript">
<![CDATA[
	$(function() {
	
	});
]]>
			</script>

			<body>
				<div class="mainPage-Container">
					<div id="splitter">

						<xsl:variable name="noofattach">
							<xsl:value-of select="count(//VOUCHER_DET)" />
						</xsl:variable>

						<div id="splitterLeftPane">
							<div class="detailPage-Container">

								<div style="width: 100%,height: 40%;" align="center">
								<xsl:if test=" $noofattach &gt; 2 ">
									<div style="width: 5%; float: left; margin-top: 3px;">
										<input type="button" value="&lt;" onclick="scrollDivLeft()" />
									</div>
									<div style="width: 5%; float: right; margin-top: 3px;">
										<input type="button" value="&gt;" onclick="scrollDivRight()" />
									</div>
									</xsl:if>
								<xsl:if test=" $noofattach &lt;= 2 ">
									<div style="width: 5%; float: left; margin-top: 3px;" disabled="true">
										<input type="button" value="&lt;" onclick="scrollDivLeft()" disabled="true"/>
									</div>
									<div style="width: 5%; float: right; margin-top: 3px;" disabled="true">
										<input type="button" value="&gt;" onclick="scrollDivRight()" disabled="true"/>
									</div>
									</xsl:if>

									<div id="dataDivID" class="pophelp-Contents" style="width: 90%; overflow: hidden;"
										align="center">
										<table id="Details" border="0" cellspacing="5"
											cellpadding="5" style="width: 18%">
											<tbody class="attach-table-body">
												<tr>
													<xsl:for-each select="//VOUCHER_DET">
														<xsl:variable name="voucher_no">
															<xsl:value-of select="voucher_no" />
														</xsl:variable>
														<xsl:variable name="purc_order">
															<xsl:value-of select="purc_order" />
														</xsl:variable>
														<xsl:variable name="confirmed">
															<xsl:value-of select="confirmed" />
														</xsl:variable>
														<xsl:variable name="ref_id">
															<xsl:value-of select="ref_id" />
														</xsl:variable>
														<xsl:variable name="status">
															<xsl:value-of select="status" />
														</xsl:variable>
														<xsl:variable name="tran_date">
															<xsl:value-of select="tran_date" />
														</xsl:variable>
														<xsl:variable name="dbID">
															<xsl:value-of select="@domID" />
														</xsl:variable>
														<td id="Details-{normalize-space($dbID)}"
															onclick="viewAttachments('{normalize-space($ref_id)}'),selectedRowsHighlight( this.id );">
															<table name="Details-tab" border="0" cellspacing="1"
																cellpadding="1" style="width: 220px;">
																<tbody>
																	<tr>
																		<td>
																			<label style="font-size: 17px;">
																				<b>Purchase&#160;Voucher&#160;:&#160;</b>
																				<xsl:value-of select="voucher_no" />
																			</label>
																		</td>
																	</tr>
																	<tr>
																		<td colspan="2">
																			<label>
																				<b>Purchase&#160;Order&#160;:&#160;</b>
																				<xsl:value-of select="purc_order" />
																			</label>
																		</td>
																	</tr>
																	<tr>
																		<td colspan="2">
																			<label>
																				<b>Confirmed&#160;:&#160;</b>
																				<xsl:value-of select="confirmed" />
																			</label>
																		</td>
																	</tr>
																	<tr>
																		<td>
																			<label>
																				<b>Bank&#160;Guarantee&#160;:&#160;</b>
																				<xsl:value-of select="ref_id" />
																			</label>
																		</td>
																		<!-- <td style="text-align: right;"> -->
																		<!-- <label><b>Due&#160;On&#160;:&#160;</b><xsl:value-of 
																			select="due_date" /></label> -->
																		<!-- </td> -->
																	</tr>
																	<tr>
																		<td>
																			<label>
																				<b>Bank&#160;Guarantee&#160;Status&#160;:&#160;</b>
																				<xsl:value-of select="status" />
																			</label>
																		</td>
																	</tr>
																	<tr>
																		<td>
																			<label>
																				<b>Date&#160;:&#160;</b>
																				<xsl:value-of select="tran_date" />
																			</label>
																		</td>
																	</tr>
																</tbody>
															</table>
														</td>
													</xsl:for-each>
												</tr>

												<xsl:if test=" $noofattach = 0 ">
													<TR>
														<TD colspan='5'>
															<span class='no-attach-text'>No records found.</span>
														</TD>
													</TR>
												</xsl:if>

											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div> <!-- #LeftPane -->

						<div id="splitterRightPane">

							<!-- Commented to remove Report part. VALLABH KADAM <div id="splitterTopPane"> 
								<div id="loadingReportDiv" align="center" class="loadingImg"> <span style="vertical-align: 
								middle">Loading...</span> </div> <iframe id='reportSrc' style='height: 99.8%; 
								width: 99.8%; float: left;' frameborder="0" scrolling="no"></iframe> </div> -->

							<!-- #TopPane -->

							<!--VALLABH KADAM The Repoer DIV is removed Made following chnages 
								in splitterBottomPane align="center" style="margin-left:160px; height: 630px; 
								width: 300px" also in iframe style='height: 99.8%; width: 99%; float: left;' 
								In CSS #splitterBottomPane min-height: 100px;min-width: 1200px; -->

<!-- 							<div id="splitterBottomPane" align="center" -->
<!-- 								style="margin-left:50px; height: 500px; width: 275px"> -->
							<div id="splitterBottomPane" align="left"
								style="height: 98%; width: 99%;">
								<div id="loadingAttachDiv" align="center" class="loadingImg">

									<xsl:if test=" $noofattach != 0 ">

										<span style="vertical-align: middle">Loading...</span>

									</xsl:if>
									<xsl:if test=" $noofattach = 0 ">

										<span class='no-attach-text'>No attachments found.</span>

									</xsl:if>

								</div>
								<iframe id='attachSrc' style='height: 99.8%; width: 100%; float: left;'
									frameborder="0" scrolling="no">
								</iframe>
							</div> <!-- #BottomPane -->

						</div> <!-- #RightPane -->

					</div> <!-- #MySplitter -->
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>