/********************************************************
	Title : EcollectionSubIC[F14ISUN014]
	Date  : 18/11/15
	Developer: Chandrashekar

 ********************************************************/
package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
@SuppressWarnings("unused")
@Stateless
public class EcollectionSubIC extends ValidatorEJB implements
		EcollectionSubICLocal, EcollectionSubICRemote {

	static E12GenericUtility genericUtility = new E12GenericUtility();

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try {
			if (xmlString != null && xmlString.trim().length() > 0) {
				dom = parseString(xmlString);
				printMessage("xmlString", xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0) {
				dom1 = parseString(xmlString1);
				printMessage("xmlString1", xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) {
				dom2 = parseString(xmlString2);
				printMessage("xmlString2", xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag,
					xtraParams);
		} catch (Exception e) {
			printMessage("Exception wfValData[S]", e.getMessage());
			throw new ITMException(e);
		}
		return errString;
	}

	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
		String childNodeName = "", errString = "", errCode = "", userId = "", sql = "", errorType = "", custCode = "", bankCode = "", lineNo = "", rfDate = "", tranIdRcp = "", tranId = "", stmt_id = "", siteCode = "", rcpAmtStr = "", refSer = "", refNo = "", prdCode = "";
		int cnt = 0, ctr = 0, rcpFormCnt = 0, bankTranCnt = 0, childNodeListLength = 0, currentFormNo = 0;
		NodeList parentNodeList = null, childNodeList = null;
		Node parentNode = null, childNode = null;
		ArrayList<String> errList = new ArrayList<String>(), errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer(
				"<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		java.util.Date tranDate = null;
		double rcpAmt = 0, rcpAmtNew = 0, isInvAmt = 0;
		SimpleDateFormat dateFormat2 = null;
		Timestamp rfDatetmstmp = null;
		Date currentDate = new Date();
		try {
			dateFormat2 = new SimpleDateFormat(
					genericUtility.getApplDateFormat());
			printMessage("call to wfValdata[D]", "Started");
			// Changes and Commented By Bhushan on 06-06-2016 :START
			// conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			// Changes and Commented By Bhushan on 06-06-2016 :END
			connDriver = null;
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo) {
			case 1: {
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				for (ctr = 0; ctr < childNodeListLength; ctr++) {
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equalsIgnoreCase("ref_no")) {
						refNo = checkNull(genericUtility.getColumnValue(
								"ref_no", dom));
						rfDate = checkNull(genericUtility.getColumnValue(
								"ref_date", dom));
						bankCode = checkNull(genericUtility.getColumnValue(
								"bank_code", dom));
						siteCode = checkNull(genericUtility.getColumnValue(
								"site_code", dom));
						tranId = checkNull(genericUtility.getColumnValue(
								"tran_id", dom));
						custCode = checkNull(genericUtility.getColumnValue(
								"cust_code", dom));
						System.out.println("refNo -- -- " + refNo);
						
							if (refNo != null && refNo.trim().length() > 0) {
								sql = "	select count(*) as cnt from  receipt_form where site_code = ?  and bank_code=? and ref_no=? and status !='X' ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, siteCode);
								pstmt.setString(2, bankCode);
								pstmt.setString(3, refNo);
								rs = pstmt.executeQuery();
								if (rs.next()) {
									rcpFormCnt = rs.getInt("cnt");
								}
								rs.close();
								rs = null;
								pstmt.close();
								if (rcpFormCnt > 1) {
									errCode = "VTINVREF";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}

								/*
								 * sql =
								 * "	select count(*) as cnt from  bank_statement where site_code = ?  and bank_code=? and ref_no=? "
								 * ; pstmt = conn.prepareStatement(sql);
								 * pstmt.setString(1, siteCode);
								 * pstmt.setString(2, bankCode);
								 * pstmt.setString(3, refNo); rs =
								 * pstmt.executeQuery(); if (rs.next()) {
								 * bankTranCnt = rs.getInt("cnt"); } rs.close();
								 * rs = null; pstmt.close(); pstmt = null;
								 * 
								 * if (bankTranCnt == 0) { errCode =
								 * "VTINREFNO1"; errList.add(errCode);
								 * errFields.add(childNodeName.toLowerCase()); }
								 */

								if (rfDate != null && rfDate.trim().length() > 0) {
									rfDatetmstmp = java.sql.Timestamp.valueOf(genericUtility.getValidDateString(rfDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
									sql = "select tran_id from receipt where cust_code=? and ref_no=? and ref_date=? and tran_id <> ?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, custCode);
									pstmt.setString(2, refNo);
									pstmt.setTimestamp(3, rfDatetmstmp);
									pstmt.setString(4, tranId);
									rs = pstmt.executeQuery();
									if (rs.next()) {
										tranIdRcp = checkNull(rs.getString("tran_id"));
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;

									if (tranIdRcp != null && tranIdRcp.trim().length() > 0) {
										/**
										 * Existing receipt found for above
										 * combination check the record from
										 * table rcpdishnr where
										 * receipt_no=tranIdRcp
										 * */
										sql = "select count(*) as cnt from rcpdishnr where receipt_no=? and confirmed='N' ";
										pstmt = conn.prepareStatement(sql);
										pstmt.setString(1, tranIdRcp);
										rs = pstmt.executeQuery();
										if (rs.next()) {
											cnt = rs.getInt("cnt");
										}
										rs.close();
										rs = null;
										pstmt.close();
										pstmt = null;
										
										System.out.println("@V@ Dishponer cnt :- [" + cnt + "]");
										if (cnt == 0) {
											// Unconfirmed record found ERROR (Duplicate utr_no found)
											errCode = "VTUTRDUPL";
											errList.add(errCode);
											errFields.add(childNodeName
													.toLowerCase());
										}

									}
								}
							} else {
								errCode = "VTNULREFNO";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
					} else if (childNodeName.equalsIgnoreCase("ref_date")) {
						rfDate = checkNull(genericUtility.getColumnValue("ref_date", dom));
						if (rfDate == null || rfDate.trim().length() == 0) {
							errCode = "VTNULREFDT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						} else {
							rfDatetmstmp = java.sql.Timestamp.valueOf(genericUtility.getValidDateString(rfDate,genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
							if (currentDate.before(rfDatetmstmp)) {
								System.out.println("rfDatetmstmp < currentDate : " + rfDatetmstmp + " < " + currentDate);
								errCode = "VTREFDTLE";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					} else if (childNodeName.equalsIgnoreCase("stmt_id")) {
						stmt_id = checkNull(genericUtility.getColumnValue("stmt_id", dom));
						if (stmt_id.trim().length() > 0) {
							
							siteCode = checkNull(genericUtility.getColumnValue("site_code", dom));
							String finEntity = "", bankGroup = "";

							sql = "	select fin_entity from site where site_code=? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, siteCode);
							rs = pstmt.executeQuery();
							if (rs.next()) {
								finEntity = checkNull(rs.getString("fin_entity"));
							}
							printMessage("finEntity", finEntity);
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							sql = "select group_code from bank where bank_code= ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, bankCode);
							rs = pstmt.executeQuery();
							if (rs.next()) {
								bankGroup = checkNull(rs.getString("group_code"));
							}
							printMessage("bankGroup", bankGroup);
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							
							String colFormRef = "";
							//sql = "select collection_form_ref from bank_statement where tran_id = ?";
							sql = "select b.collection_form_ref from bank_statement b,site s,bank bank where s.fin_entity=? "
									+ " and  s.site_code=b.site_code "
									+ " and bank.bank_code=b.bank_code and bank.group_code= ? "
									+ " and b.tran_id = ?";
							
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, finEntity);
							pstmt.setString(2, bankGroup);
							pstmt.setString(3, stmt_id);
							rs = pstmt.executeQuery();
							
							if(rs.next()) {
								colFormRef = checkNull(rs.getString(1));
							} else {
								errCode = "VTINVSTMID";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							if(colFormRef.trim().length() > 0){
								errCode = "VTECSREFID";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
				}// end for
			}
				break; // case 1 end
			}

			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if (errList != null && errListSize > 0) {
				for (cnt = 0; cnt < errListSize; cnt++) {
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType = errorType(conn, errCode);
					if (errString.length() > 0) {
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if (errorType.equalsIgnoreCase("E")) {
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			} else {
				errStringXml = new StringBuffer("");
			}
		} catch (Exception e) {
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		} finally {
			try {
				if (conn != null) {
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			} catch (Exception d) {
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}

	// end of validation

	private void printMessage(String fieldname, String value) {
		System.out.println(this.getClass().getSimpleName().toUpperCase() + " : [" + fieldname + "][" + value + "]");
	}

	private String checkNull(String input) {
		return input == null ? "" : input;
	}

	public String getRequiredDecimal(double actVal, int prec) {
		String fmtStr = "############0";
		if (prec > 0) {
			fmtStr = fmtStr + "." + "000000000".substring(0, prec);
		}
		DecimalFormat decFormat = new DecimalFormat(fmtStr);
		return decFormat.format(actVal);
	}

	public static java.util.Date relativeDate(java.util.Date date, int days) {
		java.util.Date calculatedDate = null;
		if (date != null) {
			final GregorianCalendar calendar = new GregorianCalendar();
			calendar.setTime(date);
			calendar.add(Calendar.DATE, days);
			calculatedDate = new java.util.Date(calendar.getTime().getTime());
		}
		return calculatedDate;
	}

	private String errorType(Connection conn, String errorCode)
			throws ITMException {
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try {
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				msgType = rs.getString("MSG_TYPE");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new ITMException(ex);
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}
}
