/*
 * Decompiled with CFR 0.152.
 */
package ibase.e12ria.client;

import ibase.e12ria.client.E12Constants;
import ibase.e12ria.client.E12Global;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class TNCWrapper {
    private HashMap<String, String> tncHMap = new HashMap();
    private String termsAndCondInfo;
    private String certificationInfo;
    private boolean isAgreed;
    private String finentDescr = "";

    public void setTNCAttrib(String key, String value) {
        this.tncHMap.put(this.checkNull(key).toLowerCase(), value);
    }

    public String getTNCAttrib(String key) {
        return this.tncHMap.get(this.checkNull(key).toLowerCase());
    }

    public boolean isAgreed() {
        return this.isAgreed;
    }

    public void setAgreed(boolean isAgreed) {
        this.isAgreed = isAgreed;
    }

    public String getTermsAndCondInfo() {
        String pdfUrl;
        String pdfUrlSettings = "?zoom=85&scrollbar=1&toolbar=0&navpanes=0";
        String termsAndCondStr = "";
        this.termsAndCondInfo = this.getTNCAttrib("TNC_DOC_NAME");
        if (this.termsAndCondInfo == null) {
            this.termsAndCondInfo = "Code_of_Conduct.pdf";
        }
        termsAndCondStr = pdfUrl = String.valueOf(E12Global.getHostUrl()) + "/ibase/resource/TNCDocument/" + this.termsAndCondInfo + pdfUrlSettings;
        return termsAndCondStr;
    }

    public void setTermsAndCondInfo(String termsAndCondInfo) {
        this.termsAndCondInfo = termsAndCondInfo;
    }

    public String getCertificationInfo(String empName) {
        if (this.certificationInfo == null) {
            if (this.checkNull(this.getTNCAttrib("date_accept")).length() == 0) {
                Date currentDate = new Date(System.currentTimeMillis());
                SimpleDateFormat sdf = new SimpleDateFormat(E12Constants.dispDate);
                this.setTNCAttrib("date_accept", sdf.format(currentDate));
            }
            this.certificationInfo = "<table cellpadding='2' ><tr >   <th colspan='2' align='center'> CERTIFICATION </th> </tr> <tr>   <td colspan='2' > I, &nbsp;&nbsp; <u><b>" + empName + "</b></u> &nbsp;&nbsp;do hereby certify that:  </td> " + "</tr> " + "<tr>" + "   <td  vertical-align: >1. </td>" + "   <td >     I have received and carefully read the Code of Conduct of " + this.finentDescr + " </td>" + "</tr> " + "<tr>" + "   <td >2. </td>" + "   <td >     I understand the Company\u2019s Code of Conduct.</td>" + "</tr> " + "<tr>" + "   <td >3. </td>" + "   <td >     I have complied and will continue to comply with the terms of the Code of Conduct and " + "\t\t\t\thave reported or will report any known violations of the Code according to the procedures " + " \t\t\t\toutlined in the Code." + "\t </td>" + "</tr> " + "<tr>" + "   <td colspan='2' > Date: " + this.getTNCAttrib("date_accept") + " </td> " + "</tr> ";
        }
        return this.certificationInfo;
    }

    public void setCertificationInfo(String certificationInfo) {
        this.certificationInfo = certificationInfo;
    }

    public String toString() {
        String str = "termsAndCondInfo[" + this.termsAndCondInfo + "]\ncertificationInfo[" + this.certificationInfo + "]\nisAgreed[" + this.isAgreed + "]";
        return str;
    }

    public String checkNull(String value) {
        if (value == "undefined" || value == null) {
            value = "";
        }
        return value;
    }

    public String getFinentDescr() {
        return this.finentDescr;
    }

    public void setFinentDescr(String finentDescr) {
        this.finentDescr = finentDescr;
    }
}

