package ibase.webitm.ejb.gst;

import java.io.InputStream;
import java.rmi.RemoteException;
import java.security.PrivateKey;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

import javax.annotation.PostConstruct;

import org.apache.commons.io.IOUtils;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.HttpRequest;
import com.sun.jmx.snmp.Timestamp;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.bean.gst.APICallData;
import ibase.webitm.bean.gst.AT;
import ibase.webitm.bean.gst.ATA;
import ibase.webitm.bean.gst.B2B;
import ibase.webitm.bean.gst.B2CL;
import ibase.webitm.bean.gst.B2CLA;
import ibase.webitm.bean.gst.B2CS;
import ibase.webitm.bean.gst.B2CSA;
import ibase.webitm.bean.gst.CDNDetails;
import ibase.webitm.bean.gst.CDNR;
import ibase.webitm.bean.gst.CDNRA;
import ibase.webitm.bean.gst.CDNUR;
import ibase.webitm.bean.gst.DocDetails;
import ibase.webitm.bean.gst.DocIssued;
import ibase.webitm.bean.gst.EXP;
import ibase.webitm.bean.gst.GSTR1;
import ibase.webitm.bean.gst.HSN;
import ibase.webitm.bean.gst.HSNDetails;
import ibase.webitm.bean.gst.InvLineItem;
import ibase.webitm.bean.gst.Invoice;
import ibase.webitm.bean.gst.Nil;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.util.gst.AESEncryption;
import ibase.webitm.util.gst.GSPSignature;
import ibase.webitm.util.gst.GSTCommonUtil;
import ibase.webitm.util.gst.PubKeyEncryption;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

@javax.ejb.Stateless
public class GSTDataSubmitWizPos extends ValidatorEJB implements GSTDataSubmitWizPosLocal, GSTDataSubmitWizPosRemote
{
	private String GSP_API_URL = "";
	private String GST_API_URL = "";
	private String AUTH_TOKEN_URL_V2 = "";
	private String GSTR1_URL_V2 = "";
	private String GSTR2_URL_V2 = "";
	private String GSTR_URL_V3 = "";
	private String GSTR1_URL_V3 = "";
	private String GSTR2_URL_V3 = "";
	private final String APPLICATION_JSON = "application/json";
	private String appKey = "";
	String ipAddress = "";
	private byte[] appKeyInBytes = null;
	private String appKeyEncryptedAndCoded = "";
	private String clientId = "";
	private String clientSecret = "";
	AESEncryption aesEncryption = null;
	PubKeyEncryption pubKeyEncryption = null;
	Connection conn = null;
	GSPSignature gspSignature;
	PrivateKey aspPrivateKey = null;
	
	E12GenericUtility e12GenericUtility = new E12GenericUtility();
	GSTCommonUtil gstCommonUtil = new GSTCommonUtil();
	
	@PostConstruct
	public void postConstruct()
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try(java.util.Scanner sc = new java.util.Scanner(new java.net.URL("https://api.ipify.org").openStream(), "UTF-8").useDelimiter("\\A"))
		{
			System.out.println("GSTDataSubmitWizPos PostConstruct called!");
			InputStream pubKeyInpStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("ibase/webitm/resources/gst/GSTN_Public_Key.cer");
			conn = getConnection();
			FinCommon finCommon = new FinCommon();
			clientId = finCommon.getFinparams("999999", "GST_CLIENT_ID", conn);
			clientSecret = finCommon.getFinparams("999999", "GST_CLIENT_SECRET", conn);
			aesEncryption = new AESEncryption();
			pubKeyEncryption = new PubKeyEncryption(pubKeyInpStream);
			ipAddress = sc.next();
			System.out.println("host ipAddress["+ipAddress+"]");
			gspSignature = new GSPSignature();
			String privateKeyPath = "/ibase/webitm/resources/gst/privatekey.pem";
			aspPrivateKey = gspSignature.loadPrivateKey(Thread.currentThread().getContextClassLoader().getResourceAsStream(privateKeyPath));
			
			sql = "SELECT SERVICE_CODE, SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE METHOD_NAME = 'GST_API_URL'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				switch(rs.getString("SERVICE_CODE"))
				{
					case "gsp_base_url" :
					{
						GSP_API_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gst_base_url" :
					{
						GST_API_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr_auth_url_v2" :
					{
						AUTH_TOKEN_URL_V2 = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr1_url_v2" :
					{
						GSTR1_URL_V2 = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr2_url_v2" :
					{
						GSTR2_URL_V2 = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr_url_v3" :
					{
						GSTR_URL_V3 = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr1_url_v3" :
					{
						GSTR1_URL_V3 = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr2_url_v3" :
					{
						GSTR2_URL_V3 = rs.getString("SERVICE_URI");
					}
					break;
				}
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			
			System.out.println("GST_API_URL["+GST_API_URL+"]");
			System.out.println("AUTH_TOKEN_URL_V2["+AUTH_TOKEN_URL_V2+"]");
			System.out.println("GSTR1_URL_V2["+GSTR1_URL_V2+"]");
			System.out.println("GSTR2_URL_V2["+GSTR2_URL_V2+"]");
			System.out.println("GSTR1_URL_V3["+GSTR1_URL_V3+"]");
			System.out.println("GSTR2_URL_V3["+GSTR2_URL_V3+"]");
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizPos.postConstruct()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(conn!= null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizPos.postConstruct()["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		
	}
	@Override
	public String postSave(String xmlStringAll, String dcrId, String editFlag, String xtraParams, Connection conn) throws RemoteException,ITMException
	{
		Document allXMLDom = null;
		NodeList detail1NList = null, detail1ChildNList = null, detail2NList = null, detail2ChildNList = null;
		String retString = "", nodeName = "", otp = "", stateCode = "", sek = "", returnsType = "", gstin = "", periodCode = "", grossTurnover = "",
			   action = "", siteCode = "", gspAuthString = "", gspAuthSignature = "", currentYearTurnover = "";
		String loginCode = "", chgTerm = "", callStatus = "", responseId = "", responseJsonStr= "";
		byte[] authSEK = null;
		
		try
		{
			String userName = "", authToken = "";
			String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
			
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			System.out.println("xmlStringAll["+xmlStringAll+"]");
			System.out.println("dcrId["+dcrId+"]");
			System.out.println("editFlag["+editFlag+"]");
			
			allXMLDom = e12GenericUtility.parseString(xmlStringAll);
			
			detail1NList = allXMLDom.getElementsByTagName("Detail1");
			detail1ChildNList = detail1NList.item(0).getChildNodes();
			
			for(int i=0; i<detail1ChildNList.getLength();i++)
			{
				Node eachDetail1Element = detail1ChildNList.item(i);
				nodeName = eachDetail1Element.getNodeName();
				
				if(!"#text".equalsIgnoreCase(nodeName) && !"attribute".equals(nodeName))
				{
					if("username".equalsIgnoreCase(nodeName))
					{
						userName = eachDetail1Element.getTextContent();
					}
					else if("state_code".equalsIgnoreCase(nodeName))
					{
						stateCode = eachDetail1Element.getTextContent();;
					}
					else if("app_key".equalsIgnoreCase(nodeName))
					{
						appKey = eachDetail1Element.getTextContent();
					}
					else if("otp".equalsIgnoreCase(nodeName))
					{
						otp = eachDetail1Element.getTextContent();
					}
					else if("returns_type".equalsIgnoreCase(nodeName))
					{
						returnsType = eachDetail1Element.getTextContent();
					}
					else if("gstin".equalsIgnoreCase(nodeName))
					{
						gstin = eachDetail1Element.getTextContent();
					}
					else if("period_code".equalsIgnoreCase(nodeName))
					{
						periodCode = eachDetail1Element.getTextContent();
					}
					else if("gross_turnover".equalsIgnoreCase(nodeName))
					{
						grossTurnover = eachDetail1Element.getTextContent();
					}
					else if("action".equalsIgnoreCase(nodeName))
					{
						action = eachDetail1Element.getTextContent();
					}
					else if("site_code".equalsIgnoreCase(nodeName))
					{
						siteCode = eachDetail1Element.getTextContent();
					}
					else if("cur_gross_turnover".equalsIgnoreCase(nodeName))
					{
						currentYearTurnover = eachDetail1Element.getTextContent();
					}
				}
			}
			
			System.out.println("returnsType["+returnsType+"] action ["+action+"]");
			
			if("SUBMIT".equalsIgnoreCase(action) || "FILE".equalsIgnoreCase(action))
			{
				detail2NList = allXMLDom.getElementsByTagName("Detail2");
				detail2ChildNList = detail2NList.item(0).getChildNodes();
				
				for(int i=0; i<detail2ChildNList.getLength();i++)
				{
					Node eachDetail2Element = detail2ChildNList.item(i);
					nodeName = eachDetail2Element.getNodeName();
					
					if(!"#text".equalsIgnoreCase(nodeName) && !"attribute".equals(nodeName))
					{
						if("auth_token".equalsIgnoreCase(nodeName))
						{
							authToken = eachDetail2Element.getTextContent();
						}
						else if("auth_sek".equalsIgnoreCase(nodeName))
						{
							sek = eachDetail2Element.getTextContent();
						}
					}
				}
				
				System.out.println("authToken["+authToken+"] sek["+sek+"]");
			}
			
			appKeyInBytes = aesEncryption.decodeBase64StringTOByte(appKey);
			appKeyEncryptedAndCoded = pubKeyEncryption.encrypt(appKeyInBytes);
			
			if(authToken.trim().length() > 0 && sek.trim().length() > 0)
			{
				System.out.println("authToken and authSEK from detail2");
				
				authSEK = aesEncryption.decrypt(sek, appKeyInBytes);
                System.out.println("AuthSEK = "+ aesEncryption.encodeBase64String(authSEK));
			}
			else
			{
				String encryptedOTP = aesEncryption.encryptEK(otp.getBytes(), appKeyInBytes);
				
				JSONObject authTokenReq = new JSONObject();
		        authTokenReq.put("action", "AUTHTOKEN");
		        authTokenReq.put("username", userName);
		        authTokenReq.put("app_key", appKeyEncryptedAndCoded);
		        authTokenReq.put("otp", encryptedOTP);
		        
		        long timeStamp = new Timestamp().getDateTime();
		        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
				gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
				
				System.out.println("AUTHTOKEN request url ["+String.format("%s%s", GSP_API_URL, AUTH_TOKEN_URL_V2)+"]");

		        HttpResponse<JsonNode> authTokenResp = Unirest.post(String.format("%s%s", GSP_API_URL, AUTH_TOKEN_URL_V2))
													   .header("Content-Type",APPLICATION_JSON)
													   .header("clientid", clientId)
													   .header("client-secret", clientSecret)
													   .header("state-cd", stateCode)
													   .header("ip-usr", ipAddress)
													   .header("txn", transactionId)
													   //.header("app_key", appKeyEncryptedAndCoded)
													   .header("X-Asp-Auth-Token", gspAuthString)
								    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
													   .body(new JsonNode(authTokenReq.toString()))
													   .asJson();

		        System.out.println(String.format("authTokenResp Request : Status[%s] Response[%s]", authTokenResp.getStatus(), authTokenResp.getBody()));
		        if (authTokenResp.getStatus() == 200) 
		        {
		            JSONObject object = authTokenResp.getBody().getObject();
		            if (object.has("auth_token") && object.has("sek") && object.has("status_cd") && Objects.equals(object.getString("status_cd"), "1")) 
		            {
		                authToken = object.getString("auth_token");
		                sek = object.getString("sek");

		                authSEK = aesEncryption.decrypt(sek, appKeyInBytes);
		                System.out.println("AuthSEK = "+ aesEncryption.encodeBase64String(authSEK));
		                
		            }
		            else
		            {
		            	JSONObject errorJSON = authTokenResp.getBody().getObject().getJSONObject("error");
		            	
		            	if("AUTH4033".equalsIgnoreCase(errorJSON.getString("error_cd")))
		            	{
		            		retString = new ITMDBAccessEJB().getErrorString("","VTINVOTP","","",conn);
		            	}
		            	else
		            	{
		            		String errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		            		retString = getError(errMsg, "GSTAPIERR", conn);
		            	}
		            }
		        }
		        else if(authTokenResp.getStatus() == 500)
		        {
		        	callStatus = "2";
		        	String errMsg = "Message : Error occurred at GSTN server \nResponse code : "+authTokenResp.getStatus();
		        	responseJsonStr = errMsg;
		        	retString = getError(errMsg, "GSTAPIERR", conn);
		        }
		        else
		        {
		        	JSONObject errorJSON = authTokenResp.getBody().getObject().getJSONObject("error");
		        	String errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
		        }
		        
		        APICallData apiCallData = new APICallData();
		        apiCallData.setPeriodCode(periodCode);
		        apiCallData.setCallDate(new Date());
		        apiCallData.setSiteCode(siteCode);
		        apiCallData.setUserId(loginCode);
		        apiCallData.setCallType("AUTHTOKEN");
		        apiCallData.setRecType("1");
		        apiCallData.setNoOfRecords(0);
		        apiCallData.setCallStatus(callStatus);
		        apiCallData.setResponseId(responseId);
		        apiCallData.setResponseJsonStr(responseJsonStr);
		        apiCallData.setChgUser(loginCode);
		        apiCallData.setChgDate(new Date());
		        apiCallData.setChgTerm(chgTerm);
		        
		        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
			}
	        
	        if("GSTR1".equalsIgnoreCase(returnsType))
            {
            	if("SAVE".equalsIgnoreCase(action))
            	{
            		retString = saveGstr1(authToken, siteCode, stateCode, userName, gstin, periodCode, grossTurnover, currentYearTurnover, authSEK, xtraParams, conn);
            	}
            	else if ("RETSUM".equalsIgnoreCase(action) || "FILE".equalsIgnoreCase(action))
            	{
            		retString = getGstr1Summary(authToken, stateCode, userName, gstin, periodCode, authSEK, action, xtraParams, conn);
            	}
            	else if ("SUBMIT".equalsIgnoreCase(action))
            	{
            		retString = submitGstr1(authToken, stateCode, userName, gstin, periodCode, authSEK, xtraParams, conn);
            	}
            }
            else if("GSTR2".equalsIgnoreCase(returnsType))
            {
            	if("GETINV".equalsIgnoreCase(action))
            	{
            		retString = downloadGstr2Invoices(authToken, stateCode, userName, gstin, periodCode, siteCode, authSEK, xtraParams, conn);
            	}
            }
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.postSave()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		return retString;
	}
	
	private String saveGstr1(String authToken, String siteCode, String stateCode, String userName, String gstin, String periodCode, String grossTurnover, String currentYearTurnover, byte[] authSek, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "", errMsg = "";
		String gstr1Data = "", gstr1Rek = "";
		String retStatsData = "", retStatsRek = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		int num = 0, noOfRecords = 0;
		
		boolean isDataFound = false;
		
		String udfStr1 = "", udfStr2 = "", udfStr3 = "";
		String sql = "", lineSql = "", refDataSql = "";
		PreparedStatement pstmt = null, linePstmt = null, refDataPstmt = null;
		ResultSet rs = null, lineRs = null, refDataRs = null;
		
		String tranId = "", tranType = "", tranIdRef = "", ctin = "", posStateCode = "";
		String loginCode = "", chgTerm = "", callStatus = "", responseId = "", responseJsonStr= "", retStatusCallStatus = "", retStatusResponseJsonStr = "";
		
		ArrayList<String> tranIdList = new ArrayList<String>();
		
		Map<String, ArrayList<Invoice>> invoicesHMap = new HashMap<String, ArrayList<Invoice>>();
		Map<String, Object> invTypObjHMap = new HashMap<String, Object>();
		ArrayList<B2B> b2bInvoiceList = new ArrayList<B2B>();
		ArrayList<B2CL> b2clInvoiceList = new ArrayList<B2CL>();
		ArrayList<B2CLA> b2claInvoiceList = new ArrayList<B2CLA>();
		ArrayList<B2CS> b2csInvoiceList = new ArrayList<B2CS>();
		ArrayList<B2CSA> b2csaInvoiceList = new ArrayList<B2CSA>();
		ArrayList<CDNR> cdnrList = new ArrayList<CDNR>();
		ArrayList<CDNRA> cdnraList = new ArrayList<CDNRA>();
		ArrayList<AT> atList = new ArrayList<AT>();
		ArrayList<ATA> ataList = new ArrayList<ATA>();
		ArrayList<EXP> expInvoiceList = new ArrayList<EXP>();
		ArrayList<AT> atPaidList = new ArrayList<AT>();
		ArrayList<CDNUR> cdnurList = new ArrayList<CDNUR>();
		ArrayList<DocIssued> docIssuedList = new ArrayList<DocIssued>();
		

		ArrayList<InvLineItem> invLineItems = null;
		ArrayList<Invoice> invoices = null;
		ArrayList<CDNDetails> cdnDetailsList = null;
		ArrayList<HSNDetails> hsnList = new ArrayList<HSNDetails>();
		ArrayList<DocDetails> docDetailsList = new ArrayList<DocDetails>();
		
		GSTR1 gstr1 = null;
		Invoice invoice = null;
		InvLineItem invLineItem = null;
		B2B b2b = null;
		B2CL b2cl = null;
		B2CS b2cs = null;
		CDNR cdnr = null;
		CDNDetails cdnDetails = null;
		AT at = null;
		EXP exp = null;
		CDNUR cdnur = null;
		Nil nil = null;
		HSN hsn = null;	
		HSNDetails hsnDetails = null;
		DocIssued docIssued = null;
		DocDetails docDetails = null;
		
		try
		{
			sql = "SELECT * FROM GST_DATA_HDR WHERE PRD_CODE = ? AND SITE_CODE = ? AND SUBMIT_STATUS = 'P' AND REC_TYPE ='1'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, periodCode);
			pstmt.setString(2, siteCode);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				++noOfRecords;
				isDataFound = true;
				tranId = checkNullandTrim(rs.getString("TRAN_ID"));
				tranType = checkNullandTrim(rs.getString("TRAN_TYPE"));
				ctin = checkNullandTrim(rs.getString("TAX_REG_NO"));
				posStateCode = checkNullandTrim(rs.getString("GST_CODE"));
				tranIdRef = checkNullandTrim(rs.getString("TRAN_ID__REF"));
				
				System.out.println("tranId["+tranId+"] tranType["+tranType+"] ctin["+ctin+"] posStateCode["+posStateCode+"] tranIdRef["+tranIdRef+"]");
				
				invoices = new ArrayList<Invoice>();
				invoice = new Invoice();
				invLineItems = new ArrayList<InvLineItem>();
				cdnDetailsList = new ArrayList<CDNDetails>();
				
				lineSql = "SELECT UDF_STR1, UDF_STR2, UDF_STR3 FROM GENCODES WHERE MOD_NAME='W_GSTR' AND FLD_NAME='TRAN_TYPE' AND FLD_VALUE = ? ";
				linePstmt = conn.prepareStatement(lineSql);
				linePstmt.setString(1, tranType);
				
				lineRs = linePstmt.executeQuery();
				
				if(lineRs.next())
				{
					udfStr1 = checkNullandTrim(lineRs.getString("UDF_STR1"));
					udfStr2 = checkNullandTrim(lineRs.getString("UDF_STR2"));
					udfStr3 = checkNullandTrim(lineRs.getString("UDF_STR3"));
				}
				if(linePstmt!=null)
				{
					linePstmt.close();
					linePstmt=null;
				}
				if(lineRs!=null)
				{
					lineRs.close();
					lineRs=null;
				}
				
				if(invoicesHMap.containsKey(ctin+"~"+udfStr1))
				{
					invoices = invoicesHMap.get(ctin+"~"+udfStr1);
				}
				
				//tran_type : 01,02,03,08,09,10 = B2B invoices
				if("B2B".equalsIgnoreCase(udfStr1))
				{
					lineSql = " SELECT (CASE WHEN IGST_PERC IS NULL THEN 0 ELSE IGST_PERC END + CASE WHEN CGST_PERC IS NULL THEN 0 ELSE CGST_PERC END + CASE WHEN SGST_PERC IS NULL THEN 0 ELSE SGST_PERC END) AS RATE,SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
							+ " FROM GST_DATA_DET "
							+ " WHERE TRAN_ID = ? "
							+ " GROUP BY (CASE WHEN IGST_PERC IS NULL THEN 0 ELSE IGST_PERC END + CASE WHEN CGST_PERC IS NULL THEN 0 ELSE CGST_PERC END + CASE WHEN SGST_PERC IS NULL THEN 0 ELSE SGST_PERC END)";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					int lineNum = 0;
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = ++lineNum;
						invLineItem.rate = lineRs.getDouble("RATE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					invoice.inum = rs.getString("DOC_NO");
					invoice.idt = rs.getDate("DOC_DATE");
					invoice.val = rs.getDouble("AMOUNT");
					invoice.invoiceType = udfStr2;
					invoice.pos = posStateCode;
					invoice.rchrg = "Y".equalsIgnoreCase(rs.getString("REVERSE_CHRG"));
					invoice.etin = rs.getString("ECOM_REG_NO");
					invoice.items = invLineItems;
					
					invoices.add(invoice);
					
					invoicesHMap.put(ctin+"~"+udfStr1, invoices);
					
					if("B2B".equalsIgnoreCase(udfStr1))
					{
						b2b = new B2B();
						if(invTypObjHMap.containsKey(ctin+"~"+udfStr1))
						{
							b2b = (B2B)invTypObjHMap.get(ctin+"~"+udfStr1);
							if(b2bInvoiceList.contains(b2b))
							{
								int index = b2bInvoiceList.indexOf(b2b);
								b2bInvoiceList.remove(index);
							}
						}
						b2b.ctin = ctin;
						b2b.isReverseCharge = true;
						b2b.invoices = invoices;
						
						invTypObjHMap.put(ctin+"~"+udfStr1, b2b);
						b2bInvoiceList.add(b2b);
					}
				}
				//tran_type : 04, 05 = B2CL invoices
				if("B2CL".equalsIgnoreCase(udfStr1))
				{
					invoices = new ArrayList<Invoice>();
					invoice = new Invoice();
					invLineItems = new ArrayList<InvLineItem>();
					
					lineSql = " SELECT (CASE WHEN IGST_PERC IS NULL THEN 0 ELSE IGST_PERC END + CASE WHEN CGST_PERC IS NULL THEN 0 ELSE CGST_PERC END + CASE WHEN SGST_PERC IS NULL THEN 0 ELSE SGST_PERC END) AS RATE,SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
							+ " FROM GST_DATA_DET "
							+ " WHERE TRAN_ID = ? "
							+ " GROUP BY (CASE WHEN IGST_PERC IS NULL THEN 0 ELSE IGST_PERC END + CASE WHEN CGST_PERC IS NULL THEN 0 ELSE CGST_PERC END + CASE WHEN SGST_PERC IS NULL THEN 0 ELSE SGST_PERC END)";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					int lineNum = 0;
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = ++lineNum;
						invLineItem.rate = lineRs.getDouble("RATE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					invoice.inum = checkNullandTrim(rs.getString("DOC_NO"));
					invoice.idt = rs.getDate("DOC_DATE");
					invoice.val = rs.getDouble("AMOUNT");
					invoice.etin = rs.getString("ECOM_REG_NO");
					invoice.items = invLineItems;
					
					invoices.add(invoice);
					
					if("B2CL".equalsIgnoreCase(udfStr1))
					{
						b2cl = new B2CL();
						b2cl.isReverseCharge = false;
						b2cl.stateCode = posStateCode;
						b2cl.invoices = invoices;
						
						b2clInvoiceList.add(b2cl);
					}
				}
				//tran_type : 11,12,13,14 = B2CS invoices, 37,38,39,40 = B2CSA invoices
				if("B2CS".equalsIgnoreCase(udfStr1) || "B2CSA".equalsIgnoreCase(udfStr1))
				{
					
					lineSql = "SELECT * FROM GST_DATA_DET WHERE TRAN_ID = ? ORDER BY LINE_NO ";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					
					while(lineRs.next())
					{
						if("05".equalsIgnoreCase(udfStr1))
						{
							b2cs = new B2CS();
							
							b2cs.supplyType = udfStr2;
							b2cs.txval = lineRs.getDouble("TAXABLE_AMT");
							b2cs.typ = udfStr3;
							b2cs.etin = rs.getString("ECOM_REG_NO");
							b2cs.pos = posStateCode;
							b2cs.rate = lineRs.getDouble("IGST_PERC")+lineRs.getDouble("CGST_PERC")+lineRs.getDouble("SGST_PERC");
							b2cs.iamt = lineRs.getDouble("IGST_AMT");
							b2cs.camt = lineRs.getDouble("CGST_AMT");
							b2cs.samt = lineRs.getDouble("SGST_AMT");
							b2cs.csamt = lineRs.getDouble("CESS_AMT");
							
							b2csInvoiceList.add(b2cs);
						}
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
				}
				//tran_type : 29,30 = CDNR, 33,34 = CDNRA
				if("CDNR".equalsIgnoreCase(udfStr1) || "CDNRA".equalsIgnoreCase(udfStr1))
				{
					String reason = "";
					Calendar calendar = Calendar.getInstance();
					calendar.set(2017, 06, 01);
					Date gstStartDate = calendar.getTime();
					
					refDataSql = "SELECT DESCR FROM GENCODES WHERE MOD_NAME = 'W_GSTR' AND FLD_NAME = 'REAS_CODE' AND FLD_VALUE = ?";
					refDataPstmt = conn.prepareStatement(refDataSql);
					refDataPstmt.setString(1, checkNullandTrim(rs.getString("REAS_CODE")));
					refDataRs = refDataPstmt.executeQuery();
					
					if(refDataRs.next())
					{
						reason = checkNullandTrim(refDataRs.getString("DESCR"));
					}
					if(refDataPstmt != null)
					{
						refDataPstmt.close();
						refDataPstmt = null;
					}
					if(refDataRs != null)
					{
						refDataRs.close();
						refDataRs = null;
					}
					
					if("CDNR".equalsIgnoreCase(udfStr1))
					{
						lineSql = " SELECT (CASE WHEN IGST_PERC IS NULL THEN 0 ELSE IGST_PERC END + CASE WHEN CGST_PERC IS NULL THEN 0 ELSE CGST_PERC END + CASE WHEN SGST_PERC IS NULL THEN 0 ELSE SGST_PERC END) AS RATE,SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
								+ " FROM GST_DATA_DET "
								+ " WHERE TRAN_ID = ? "
								+ " GROUP BY (CASE WHEN IGST_PERC IS NULL THEN 0 ELSE IGST_PERC END + CASE WHEN CGST_PERC IS NULL THEN 0 ELSE CGST_PERC END + CASE WHEN SGST_PERC IS NULL THEN 0 ELSE SGST_PERC END)";
						linePstmt = conn.prepareStatement(lineSql);
						linePstmt.setString(1, tranId);
						lineRs = linePstmt.executeQuery();
						int lineNum = 0;
						while(lineRs.next())
						{
							invLineItem = new InvLineItem();
							invLineItem.num = ++lineNum;
							invLineItem.rate = lineRs.getDouble("RATE");
							invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
							invLineItem.iamt = lineRs.getDouble("IGST_AMT");
							invLineItem.camt = lineRs.getDouble("CGST_AMT");
							invLineItem.samt = lineRs.getDouble("SGST_AMT");
							invLineItem.csamt = lineRs.getDouble("CESS_AMT");
							
							invLineItems.add(invLineItem);
						}
						if(linePstmt != null)
						{
							linePstmt.close();
							linePstmt = null;
						}
						if(lineRs != null)
						{
							lineRs.close();
							lineRs = null;
						}
						
						cdnDetails = new CDNDetails();
						
						cdnDetails.cdnNoteType = udfStr2;
						cdnDetails.cdNoteNumber = checkNullandTrim(rs.getString("DOC_NO"));
						cdnDetails.cdNoteDate = rs.getDate("DOC_DATE");
						cdnDetails.invoiceNumber = checkNullandTrim(rs.getString("REF_ID__INV"));
						cdnDetails.invoiceDate = rs.getDate("REF_DATE__INV");
						cdnDetails.val = rs.getDouble("AMOUNT");
						cdnDetails.reason = reason;
						if(rs.getDate("REF_DATE__INV").before(gstStartDate))
						{
							cdnDetails.isPreGSTInvoice = true;
						}
						cdnDetails.items = invLineItems;
						
						cdnDetailsList.add(cdnDetails);
						
						cdnr = new CDNR();
						cdnr.isReverseCharge = false;
						cdnr.ctin = ctin;
						cdnr.cdnDetails = cdnDetailsList;
						
						cdnrList.add(cdnr);
					}
				}
				//tran_type : 15,16,17,18,19,20,21,22,23,24,25,26 = Nil Supplies
				/*if("NIL".equalsIgnoreCase(udfStr1))
				{
					
					invoice.supplyType = "INTRB2B"; 
					invoice.totalNilAmount = rs.getDouble("AMOUNT");
					invoice.totalExemptedAmount = 123.45;
					invoice.totalNonGSTAmout = 1258.5;
					
					invoices.add(invoice);
					
					nil = new Nil();
					nil.invoices = invoices;
				}*/
				//tran_type : 06,07 = Exports and tran_type : 27,28 = Exports amendments
				if("EXP".equalsIgnoreCase(udfStr1) || "EXPA".equalsIgnoreCase(udfStr1))
				{
					invoices = new ArrayList<Invoice>();
					invoice = new Invoice();
					invLineItems = new ArrayList<InvLineItem>();
					
					if("EXP".equalsIgnoreCase(udfStr1))
					{
						
						lineSql = " SELECT (CASE WHEN IGST_PERC IS NULL THEN 0 ELSE IGST_PERC END + CASE WHEN CGST_PERC IS NULL THEN 0 ELSE CGST_PERC END + CASE WHEN SGST_PERC IS NULL THEN 0 ELSE SGST_PERC END) AS RATE,SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
								+ " FROM GST_DATA_DET "
								+ " WHERE TRAN_ID = ? "
								+ " GROUP BY (CASE WHEN IGST_PERC IS NULL THEN 0 ELSE IGST_PERC END + CASE WHEN CGST_PERC IS NULL THEN 0 ELSE CGST_PERC END + CASE WHEN SGST_PERC IS NULL THEN 0 ELSE SGST_PERC END)";
						linePstmt = conn.prepareStatement(lineSql);
						linePstmt.setString(1, tranId);
						lineRs = linePstmt.executeQuery();
						
						while(lineRs.next())
						{
							invLineItem = new InvLineItem();
							invLineItem.rate = lineRs.getDouble("RATE");
							invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
							invLineItem.iamt = lineRs.getDouble("IGST_AMT");
							invLineItem.camt = lineRs.getDouble("CGST_AMT");
							invLineItem.samt = lineRs.getDouble("SGST_AMT");
							invLineItem.csamt = lineRs.getDouble("CESS_AMT");
							
							invLineItems.add(invLineItem);
						}
						if(linePstmt != null)
						{
							linePstmt.close();
							linePstmt = null;
						}
						if(lineRs != null)
						{
							lineRs.close();
							lineRs = null;
						}
						
						invoice.inum = rs.getString("DOC_NO");
						invoice.idt = rs.getDate("DOC_DATE");
						invoice.val = rs.getDouble("AMOUNT");
						invoice.shippingPortCode = checkNullandTrim(rs.getString("ORDER_NO"));
						invoice.shippingBillNum = checkNullandTrim(rs.getString("LR_NO"));
						invoice.shippingBillDt = rs.getDate("LR_DATE");
						invoice.items = invLineItems;
						
						invoices.add(invoice);
						
						exp = new EXP();
						exp.isReverseCharge = false;
						exp.exportType = udfStr2;
						exp.invoices = invoices;
						
						expInvoiceList.add(exp);
					}
				}
				//tran_type : 41,42 = Advance Tax and tran_type : 45,46 = Adv. Tax amendments
				if("AT".equalsIgnoreCase(udfStr1) || "ATA".equalsIgnoreCase(udfStr1))
				{
					invLineItems = new ArrayList<InvLineItem>();
					
					if("AT".equalsIgnoreCase(udfStr1))
					{
						lineSql = " SELECT (CASE WHEN IGST_PERC IS NULL THEN 0 ELSE IGST_PERC END + CASE WHEN CGST_PERC IS NULL THEN 0 ELSE CGST_PERC END + CASE WHEN SGST_PERC IS NULL THEN 0 ELSE SGST_PERC END) AS RATE,SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
								+ " FROM GST_DATA_DET "
								+ " WHERE TRAN_ID = ? "
								+ " GROUP BY (CASE WHEN IGST_PERC IS NULL THEN 0 ELSE IGST_PERC END + CASE WHEN CGST_PERC IS NULL THEN 0 ELSE CGST_PERC END + CASE WHEN SGST_PERC IS NULL THEN 0 ELSE SGST_PERC END)";
						linePstmt = conn.prepareStatement(lineSql);
						linePstmt.setString(1, tranId);
						lineRs = linePstmt.executeQuery();
						
						while(lineRs.next())
						{
							invLineItem = new InvLineItem();
							
							invLineItem.rate = lineRs.getDouble("RATE");
							invLineItem.taxval = rs.getDouble("AMOUNT");
							invLineItem.iamt = lineRs.getDouble("IGST_AMT");
							invLineItem.camt = lineRs.getDouble("CGST_AMT");
							invLineItem.samt = lineRs.getDouble("SGST_AMT");
							invLineItem.csamt = lineRs.getDouble("CESS_AMT");
							
							invLineItems.add(invLineItem);
						}
						if(linePstmt != null)
						{
							linePstmt.close();
							linePstmt = null;
						}
						if(lineRs != null)
						{
							lineRs.close();
							lineRs = null;
						}
						
						at = new AT();
						at.isReverseCharge = false;
						
						at.pos = posStateCode;
						at.supplyType = udfStr2;
						at.itms = invLineItems;
						
						atList.add(at);
					}
				}
				//tran_type : 43,44 = Advance Tax paid and tran_type : 47,48 Advance Tax paid amendments
				if("AT".equalsIgnoreCase(udfStr1))
				{
					invLineItems = new ArrayList<InvLineItem>();
					
					lineSql = " SELECT (CASE WHEN IGST_PERC IS NULL THEN 0 ELSE IGST_PERC END + CASE WHEN CGST_PERC IS NULL THEN 0 ELSE CGST_PERC END + CASE WHEN SGST_PERC IS NULL THEN 0 ELSE SGST_PERC END) AS RATE,SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
							+ " FROM GST_DATA_DET "
							+ " WHERE TRAN_ID = ? "
							+ " GROUP BY (CASE WHEN IGST_PERC IS NULL THEN 0 ELSE IGST_PERC END + CASE WHEN CGST_PERC IS NULL THEN 0 ELSE CGST_PERC END + CASE WHEN SGST_PERC IS NULL THEN 0 ELSE SGST_PERC END)";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						
						invLineItem.rate = lineRs.getDouble("RATE");
						invLineItem.taxval = rs.getDouble("AMOUNT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					at = new AT();
					at.isReverseCharge = false;
					
					at.pos = posStateCode;
					at.supplyType = udfStr2;
					at.itms = invLineItems;
					
					atPaidList.add(at);
				}
				//tran_type : 31,32 = CDNUR and tran_type : 35,36 = CDNURA
				if("CDNUR".equalsIgnoreCase(udfStr1))
				{
					String reason = "", customerType = "", refTranType = "";
					Calendar calendar = Calendar.getInstance();
					calendar.set(2017, 06, 01);
					Date gstStartDate = calendar.getTime();
					
					refDataSql = "SELECT DESCR FROM GENCODES WHERE MOD_NAME = 'W_GSTR' AND FLD_NAME = 'REAS_CODE' AND FLD_VALUE = ?";
					refDataPstmt = conn.prepareStatement(refDataSql);
					refDataPstmt.setString(1, checkNullandTrim(rs.getString("REAS_CODE")));
					refDataRs = refDataPstmt.executeQuery();
					
					if(refDataRs.next())
					{
						reason = checkNullandTrim(refDataRs.getString("DESCR"));
					}
					if(refDataPstmt != null)
					{
						refDataPstmt.close();
						refDataPstmt = null;
					}
					if(refDataRs != null)
					{
						refDataRs.close();
						refDataRs = null;
					}
					
					lineSql = " SELECT (CASE WHEN IGST_PERC IS NULL THEN 0 ELSE IGST_PERC END + CASE WHEN CGST_PERC IS NULL THEN 0 ELSE CGST_PERC END + CASE WHEN SGST_PERC IS NULL THEN 0 ELSE SGST_PERC END) AS RATE,SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
							+ " FROM GST_DATA_DET "
							+ " WHERE TRAN_ID = ? "
							+ " GROUP BY (CASE WHEN IGST_PERC IS NULL THEN 0 ELSE IGST_PERC END + CASE WHEN CGST_PERC IS NULL THEN 0 ELSE CGST_PERC END + CASE WHEN SGST_PERC IS NULL THEN 0 ELSE SGST_PERC END)";
					linePstmt = conn.prepareStatement(lineSql);
					linePstmt.setString(1, tranId);
					lineRs = linePstmt.executeQuery();
					int lineNum = 0;
					while(lineRs.next())
					{
						invLineItem = new InvLineItem();
						invLineItem.num = ++lineNum;
						invLineItem.rate = lineRs.getDouble("RATE");
						invLineItem.taxval = lineRs.getDouble("TAXABLE_AMT");
						invLineItem.iamt = lineRs.getDouble("IGST_AMT");
						invLineItem.camt = lineRs.getDouble("CGST_AMT");
						invLineItem.samt = lineRs.getDouble("SGST_AMT");
						invLineItem.csamt = lineRs.getDouble("CESS_AMT");
						
						invLineItems.add(invLineItem);
					}
					if(linePstmt != null)
					{
						linePstmt.close();
						linePstmt = null;
					}
					if(lineRs != null)
					{
						lineRs.close();
						lineRs = null;
					}
					
					cdnur = new CDNUR();
					cdnur.isReverseCharge = false;
					if(rs.getDate("REF_DATE__INV").after(gstStartDate))
					{
						refDataSql = "SELECT TRAN_TYPE FROM GST_DATA_HDR WHERE DOC_NO = ? ";
						refDataPstmt = conn.prepareStatement(refDataSql);
						refDataPstmt.setString(1, checkNullandTrim(rs.getString("REF_ID__INV")));
						refDataRs = refDataPstmt.executeQuery();
						
						if(refDataRs.next())
						{
							refTranType = checkNullandTrim(refDataRs.getString("TRAN_TYPE"));
						}
						if(refDataPstmt != null)
						{
							refDataPstmt.close();
							refDataPstmt = null;
						}
						if(refDataRs != null)
						{
							refDataRs.close();
							refDataRs = null;
						}
						if(refTranType != null && refTranType.trim().length() > 0)
						{
							if("04".equalsIgnoreCase(refTranType) || "05".equalsIgnoreCase(refTranType))
							{
								customerType = "B2CL";
							}
							else if("06".equalsIgnoreCase(refTranType))
							{
								customerType = "EXPWP";
							}
							else if("07".equalsIgnoreCase(refTranType))
							{
								customerType = "EXPWOP";
							}
						}
					}
					cdnur.customerType = customerType;
					cdnur.cdnNoteType = udfStr2;
					cdnur.cdNoteNumber = checkNullandTrim(rs.getString("DOC_NO"));
					cdnur.cdNoteDate = rs.getDate("DOC_DATE");
					cdnur.invoiceNumber = checkNullandTrim(rs.getString("REF_ID__INV"));
					cdnur.invoiceDate = rs.getDate("REF_DATE__INV");
					cdnur.val = rs.getDouble("AMOUNT");
					cdnur.reason = reason;
					if(rs.getDate("REF_DATE__INV").before(gstStartDate))
					{
						cdnur.isPreGSTInvoice = true;
					}
					cdnur.items = invLineItems;
					
					cdnurList.add(cdnur);
				}
				
				tranIdList.add(tranId);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			
			if(isDataFound)
			{
				//NIL data summary
				//tran_type : 15,16,17,18,19,20,21,22,23,24,25,26 = Nil Supplies
				invoices = new ArrayList<Invoice>();
				
				Invoice interB2BNilInv = getNilRateSummary("INTRB2B", "15", "16", "17", siteCode, periodCode, conn);
				Invoice intraB2BNilInv = getNilRateSummary("INTRAB2B", "18", "19", "20", siteCode, periodCode, conn);
				Invoice interB2CNilInv = getNilRateSummary("INTRB2C", "21", "22", "23", siteCode, periodCode, conn);
				Invoice intraB2CNilInv = getNilRateSummary("INTRAB2C", "24", "25", "26", siteCode, periodCode, conn);
				
				if(interB2BNilInv != null)
				{
					invoices.add(interB2BNilInv);
				}
				if(intraB2BNilInv != null)
				{
					invoices.add(intraB2BNilInv);
				}
				if(interB2CNilInv != null)
				{
					invoices.add(interB2CNilInv);
				}
				if(intraB2CNilInv != null)
				{
					invoices.add(intraB2CNilInv);
				}
				
				if(invoices.size() > 0)
				{
					nil = new Nil();
					nil.invoices = invoices;
				}
				
				//HSN summary data will be sent every time
				sql = " SELECT GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT, SUM(GDD.QUANTITY) AS TOT_QTY, SUM(GDD.TAXABLE_AMT) AS TOT_TAXVAL,"
					+ " SUM(GDD.IGST_AMT) AS TOT_IAMT, SUM(CGST_AMT) AS TOT_CAMT, SUM(SGST_AMT) AS TOT_SAMT, SUM(CESS_AMT) AS TOT_CSAMT"
					+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD"
					+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDD.GS_CODE IS NOT NULL AND GDH.REC_TYPE='1'"
					+ " AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ?"
					+ " GROUP BY GDD.GS_CODE, GDD.GS_DESCR, GDD.UNIT";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				pstmt.setString(2, periodCode);
				rs = pstmt.executeQuery();
				
				while (rs.next()) 
				{
					hsnDetails = new HSNDetails();
					
					hsnDetails.num = ++num;
					hsnDetails.itemOrServiceCode = checkNullandTrim(rs.getString("GS_CODE"));
					hsnDetails.description = checkNullandTrim(rs.getString("GS_DESCR"));
					hsnDetails.unitOfMeasure = checkNullandTrim(rs.getString("UNIT"));
					hsnDetails.quantity = rs.getDouble("TOT_QTY");
					hsnDetails.totalAmount = rs.getDouble("TOT_TAXVAL");
					hsnDetails.totalTaxableAmount = rs.getDouble("TOT_TAXVAL");
					hsnDetails.totalIGSTAmount = rs.getDouble("TOT_IAMT");
					hsnDetails.totalCGSTAmount = rs.getDouble("TOT_CAMT");
					hsnDetails.totalSGSTAmount = rs.getDouble("TOT_SAMT");
					hsnDetails.totalCESSAmount = rs.getDouble("TOT_CSAMT");
					
					hsnList.add(hsnDetails);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				
				if(hsnList.size() > 0)
				{
					hsn = new HSN();
					hsn.hsnDetails = hsnList;
				}
				
				//TODO need to change START
				/*docDetails = new DocDetails();
				
				docDetails.docNum = 1;
				docDetails.fromSerialNo = "1";
				docDetails.toSerialNo = "20";
				docDetails.totalNo = 20;
				docDetails.cancelNo = 3;
				docDetails.toatlNetIssued = 17;
				
				docDetailsList.add(docDetails);
				
				docIssued = new DocIssued();
				
				docIssued.serialNumber = 1;
				docIssued.docDescr = "Invoices for outward supply";
				docIssued.docDetails = docDetailsList;
				
				docIssuedList.add(docIssued);*/
				//TODO need to change END
				
				gstr1 = new GSTR1();
				gstr1.gstin = gstin;
				gstr1.financialPeriod = periodCode;
				gstr1.grossTurnOver = Double.valueOf(grossTurnover);
				gstr1.currentGrossTurnOver = Double.valueOf(currentYearTurnover);
				
				if(b2bInvoiceList.size() > 0)
				{
					gstr1.b2b = b2bInvoiceList;
				}
				if(b2clInvoiceList.size() > 0)
				{
					gstr1.b2cl = b2clInvoiceList;
				}
				if(b2claInvoiceList.size() > 0)
				{
					gstr1.b2cla = b2claInvoiceList;
				}
				if(b2csInvoiceList.size() > 0)
				{
					gstr1.b2cs = b2csInvoiceList;
				}
				if(b2csaInvoiceList.size() > 0)
				{
					gstr1.b2csa = b2csaInvoiceList;
				}
				if(cdnrList.size() > 0)
				{
					gstr1.cdnr = cdnrList;
				}
				if(cdnraList.size() > 0)
				{
					gstr1.cdnra = cdnraList;
				}
				if(atList.size() > 0)
				{
					gstr1.at = atList;
				}
				if(ataList.size() > 0)
				{
					gstr1.ata = ataList;
				}
				if(expInvoiceList.size() > 0)
				{
					gstr1.exp = expInvoiceList;
				}
				if(atPaidList.size() > 0)
				{
					gstr1.txpd = atPaidList;
				}
				if(cdnurList.size() > 0)
				{
					gstr1.cdnur = cdnurList;
				}
				if(nil != null)
				{
					gstr1.nil = nil;
				}
				if(hsn != null)
				{
					gstr1.hsn = hsn;
				}
				if(docIssuedList.size() > 0)
				{
					gstr1.docIssued = docIssuedList;
				}
			
				String gspAuthString = "", gspAuthSignature = "", gspAuthStringRet = "", gspAuthSignatureRet = "";
				
				loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
				chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
				
				ObjectMapper objectMapper = new ObjectMapper();
				
				String json = objectMapper.writeValueAsString(gstr1);
				
				System.out.println("jsonPayload to SAVE GSTR1["+json+"]");
				
				byte[] jsonBase64 = Base64.getEncoder().encode(json.getBytes());
				String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSek);
				 
				HMac hmac = new HMac(new SHA256Digest());
				byte[] resBuf = new byte[hmac.getMacSize()];
				
				hmac.init(new KeyParameter(authSek));
				hmac.update(jsonBase64, 0, jsonBase64.length);
				hmac.doFinal(resBuf, 0);
				
				JSONObject gstr1HeaderObj = new JSONObject();
				gstr1HeaderObj.put("action", "RETSAVE");
				gstr1HeaderObj.put("data", encryptedPayload);
				gstr1HeaderObj.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
				
				long timeStamp = new Timestamp().getDateTime();
		        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
				gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
				
				HttpRequest saveGstr1Req = Unirest.put(String.format("%s%s", GSP_API_URL, GSTR1_URL_V3))
										   .header("Content-Type", APPLICATION_JSON)
										   .header("clientid", clientId)
										   .header("client-secret", clientSecret)
										   .header("txn",transactionId)
										   .header("state-cd", stateCode)
										   .header("auth-token", authToken)
										   .header("gstin", gstin)
										   .header("username", userName)
										   .header("ret_period", periodCode)
										   .header("ip-usr", ipAddress)
										   .header("X-Asp-Auth-Token", gspAuthString)
					    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
										   .body(new JsonNode(gstr1HeaderObj.toString()))
										   .getHttpRequest();
				 
				 System.out.println("SAVE GSTR1 url["+saveGstr1Req.getUrl()+"]");
				 System.out.println("SAVE GSTR1 method["+saveGstr1Req.getHttpMethod()+"]");
				 System.out.println("SAVE GSTR1 request header["+saveGstr1Req.getHeaders()+"]");
				 System.out.println("SAVE GSTR1 request payload["+IOUtils.toString(saveGstr1Req.getBody().getEntity().getContent())+"]");
				 
				 HttpResponse<JsonNode> gstr1Resp = saveGstr1Req.asJson();
				
				System.out.println(String.format("gstr1Resp Request : Status[%s] Response[%s]", gstr1Resp.getStatus(), gstr1Resp.getBody()));
				
				if (gstr1Resp.getStatus() == 200) 
		        {
					JSONObject gstr1RespObj = gstr1Resp.getBody().getObject();
					
					if(gstr1RespObj.has("data") && gstr1RespObj.has("rek"))
					{
						callStatus = "1";
						gstr1Data = gstr1RespObj.getString("data");
						gstr1Rek = gstr1RespObj.getString("rek");
						
						byte[] apiEKGstr1 = aesEncryption.decrypt(gstr1Rek, authSek);
						String Gstr1RespJsoninBase64 = new String(aesEncryption.decrypt(gstr1Data, apiEKGstr1));
						
						byte[] Gstr1RespJsonInBytes = aesEncryption.decodeBase64StringTOByte(Gstr1RespJsoninBase64);
						
						JSONObject Gstr1RespObj = new JSONObject(new String(Gstr1RespJsonInBytes));
						String transId = Gstr1RespObj.getString("reference_id");
						
						responseId = transId;
						
						System.out.println("transId to getStatus["+transId+"]");
						
						boolean isRetStatusError = false;
						
						while(true)
						{
							long timeStampRet = new Timestamp().getDateTime();
					        gspAuthStringRet = clientId + ":" + transactionId + ":" + timeStampRet + ":" + gstin;
							gspAuthSignatureRet = gspSignature.sign(gspAuthStringRet, aspPrivateKey);
							
							HttpRequest retStatusReq = Unirest.get(String.format("%s%s", GSP_API_URL, GSTR_URL_V3))
													   .queryString("action","RETSTATUS")
													   .queryString("gstin", gstin)
													   .queryString("ret_period", periodCode)
													   .queryString("ref_id",transId)
													   .header("Content-Type", APPLICATION_JSON)
													   .header("state-cd", stateCode)
													   .header("clientid", clientId)
													   .header("client-secret", clientSecret)
													   .header("ip-usr", ipAddress)
													   .header("username", userName)
													   .header("auth-token", authToken)
													   .header("txn", transactionId)
													   .header("ret_period", periodCode)
													   .header("gstin", gstin)
													   .header("X-Asp-Auth-Token", gspAuthStringRet)
								    	               .header("X-Asp-Auth-Signature", gspAuthSignatureRet)
													   .getHttpRequest();
							
							System.out.println("RETSTATUS url["+retStatusReq.getUrl()+"]");
							System.out.println("RETSTATUS method["+retStatusReq.getHttpMethod()+"]");
							System.out.println("RETSTATUS request header["+retStatusReq.getHeaders()+"]");
							
							HttpResponse<JsonNode> retStatusResp = retStatusReq.asJson();

							System.out.println(String.format("retStatusResp Request : Status[%s] Response[%s]", retStatusResp.getStatus(), retStatusResp.getBody()));

							if (retStatusResp.getStatus() == 200) 
							{
								JSONObject retStatsRespObj = retStatusResp.getBody().getObject();
								if(retStatsRespObj.has("data") && retStatsRespObj.has("rek"))
								{
									retStatsData = retStatsRespObj.getString("data");
									retStatsRek = retStatsRespObj.getString("rek");

									byte[] apiEKRetstats = aesEncryption.decrypt(retStatsRek, authSek);

									String retStatsRespJsoninBase64 = new String(aesEncryption.decrypt(retStatsData, apiEKRetstats));

									byte[] retStatsRespJsonInBytes = aesEncryption.decodeBase64StringTOByte(retStatsRespJsoninBase64);

									JSONObject retStatsJsonData = new JSONObject(new String(retStatsRespJsonInBytes));
									System.out.println( "retStatsJsonData["+retStatsJsonData+"]");
									
									if("IP".equalsIgnoreCase((String)retStatsJsonData.get("status_cd")))
									{
										retStatusCallStatus = "0";
										continue;
									}
									else if("P".equalsIgnoreCase((String)retStatsJsonData.get("status_cd")))
									{
										retStatusCallStatus = "1";
										if(tranIdList.size() > 0)
										{
											updateSubmissionStatus(tranIdList, conn);
										}
										isRetStatusError = true;
									}
									else if("PE".equalsIgnoreCase((String)retStatsJsonData.get("status_cd")))
									{
										retStatusCallStatus = "2";
										errMsg = getRetStatusErrMsg(retStatsJsonData);
										retStatusResponseJsonStr = errMsg;
										retString = getError(errMsg, "GSTAPIERR", conn);
										isRetStatusError = true;
									}
									else if("ER".equalsIgnoreCase(retStatsJsonData.getString("status_cd")))
									{
										retStatusCallStatus = "2";
										if(retStatsJsonData.has("error_report"))
										{
											JSONObject errorJSON = retStatsJsonData.getJSONObject("error_report");
											if(errorJSON.has("error_msg") && errorJSON.has("error_cd"))
											{
												errMsg = "Message : "+errorJSON.getString("error_msg")+" \nError code : "+errorJSON.getString("error_cd");
											}
										}
										
										retStatusResponseJsonStr = errMsg;
										retString = getError(errMsg, "GSTAPIERR", conn);
										isRetStatusError = true;
									}
								}
								else
								{
									retStatusCallStatus = "2";
									JSONObject errorJSON = retStatusResp.getBody().getObject().getJSONObject("error");
									retStatusResponseJsonStr = errorJSON.toString();
									errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
									retString = getError(errMsg, "GSTAPIERR", conn);
									isRetStatusError = true;
								}
							}
							else if(retStatusResp.getStatus() == 500)
					        {
								retStatusCallStatus = "2";
					        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+retStatusResp.getStatus();
					        	retStatusResponseJsonStr = errMsg;
					        	retString = getError(errMsg, "GSTAPIERR", conn);
					        	isRetStatusError = true;
					        }
							else
							{
								retStatusCallStatus = "2";
								JSONObject errorJSON = retStatusResp.getBody().getObject().getJSONObject("error");
								retStatusResponseJsonStr = errorJSON.toString();
								errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
								retString = getError(errMsg, "GSTAPIERR", conn);
								isRetStatusError = true;
							}
							
							APICallData apiCallData = new APICallData();
					        apiCallData.setPeriodCode(periodCode);
					        apiCallData.setCallDate(new Date());
					        apiCallData.setSiteCode(siteCode);
					        apiCallData.setUserId(loginCode);
					        apiCallData.setCallType("RETSTATUS");
					        apiCallData.setRecType("1");
					        apiCallData.setNoOfRecords(0);
					        apiCallData.setCallStatus(retStatusCallStatus);
					        apiCallData.setResponseId("");
					        apiCallData.setResponseJsonStr(retStatusResponseJsonStr);
					        apiCallData.setChgUser(loginCode);
					        apiCallData.setChgDate(new Date());
					        apiCallData.setChgTerm(chgTerm);
					        
					        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
					        
					        if(isRetStatusError)
					        {
					        	break;
					        }
						}
					}
					else
		            {
						callStatus = "2";
						JSONObject errorJSON = gstr1Resp.getBody().getObject().getJSONObject("error");
						responseJsonStr = errorJSON.toString();
			        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
			        	retString = getError(errMsg, "GSTAPIERR", conn);
		            }
		        }
				else if(gstr1Resp.getStatus() == 500)
		        {
		        	callStatus = "2";
		        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+gstr1Resp.getStatus();
		        	responseJsonStr = errMsg;
		        	retString = getError(errMsg, "GSTAPIERR", conn);
		        }
				else
	            {
					callStatus = "2";
	            	JSONObject errorJSON = gstr1Resp.getBody().getObject().getJSONObject("error");
	            	responseJsonStr = errorJSON.toString();
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
	            }
				
				APICallData apiCallData = new APICallData();
		        apiCallData.setPeriodCode(periodCode);
		        apiCallData.setCallDate(new Date());
		        apiCallData.setSiteCode(siteCode);
		        apiCallData.setUserId(loginCode);
		        apiCallData.setCallType("RETSAVE");
		        apiCallData.setRecType("1");
		        apiCallData.setNoOfRecords(noOfRecords);
		        apiCallData.setCallStatus(callStatus);
		        apiCallData.setResponseId(responseId);
		        apiCallData.setResponseJsonStr(responseJsonStr);
		        apiCallData.setChgUser(loginCode);
		        apiCallData.setChgDate(new Date());
		        apiCallData.setChgTerm(chgTerm);
		        
		        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
			}
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizPos.saveGstr1()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String getGstr1Summary(String authToken, String stateCode, String userName, String gstin, String periodCode, byte[] authSek, String action, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String loginCode = "", chgTerm = "", siteCode = "", callStatus = "", responseJsonStr = "", retFileCallStatus = "", retFileResponseJsonStr = "";
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			System.out.println("RETSUM request url ["+String.format("%s%s", GSP_API_URL, GSTR1_URL_V3)+"]");
			
			HttpResponse<JsonNode> getGstr1SumryResp = Unirest.get(String.format("%s%s", GSP_API_URL, GSTR1_URL_V3))
													   .queryString("action","RETSUM")
													   .queryString("gstin", gstin)
													   .queryString("ret_period", periodCode)
													   .header("Content-Type", APPLICATION_JSON)
													   .header("state-cd", stateCode)
													   .header("clientid", clientId)
													   .header("client-secret", clientSecret)
													   .header("ip-usr", ipAddress)
													   .header("username", userName)
													   .header("auth-token", authToken)
													   .header("txn", transactionId)
													   .header("ret_period", periodCode)
													   .header("gstin", gstin)
													   .header("X-Asp-Auth-Token", gspAuthString)
								    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
													   .asJson();
			
			System.out.println(String.format("getGstr1SumryResp Request : Status[%s] Response[%s]", getGstr1SumryResp.getStatus(), getGstr1SumryResp.getBody()));
			
			if (getGstr1SumryResp.getStatus() == 200) 
	        {
				JSONObject getGstr1SumryRespObj = getGstr1SumryResp.getBody().getObject();
				if(getGstr1SumryRespObj.has("data") && getGstr1SumryRespObj.has("rek"))
				{
					callStatus = "1";
					
					String gstr1Sumrydata = getGstr1SumryRespObj.getString("data");
					String gstr1Sumryrek = getGstr1SumryRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstr1Sumryrek, authSek);
					
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstr1Sumrydata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					JSONObject gstr1SumryJsonObj = new JSONObject(new String(respJsonInBytes));
					
					System.out.println(gstr1SumryJsonObj);
					
					if("FILE".equalsIgnoreCase(action))
					{
						String gspAuthStringFile = "", gspAuthSignatureFile = "";
						
						byte[] jsonBase64 = Base64.getEncoder().encode(gstr1SumryJsonObj.toString().getBytes());
						String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSek);
						
						HMac hmac = new HMac(new SHA256Digest());
						byte[] resBuf = new byte[hmac.getMacSize()];
						
						hmac.init(new KeyParameter(authSek));
						hmac.update(jsonBase64, 0, jsonBase64.length);
						hmac.doFinal(resBuf, 0);
						
						JSONObject fileGstr1DataJsonObj = new JSONObject();
						fileGstr1DataJsonObj.put("action", "RETFILE");
						fileGstr1DataJsonObj.put("data", encryptedPayload);
						fileGstr1DataJsonObj.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
						fileGstr1DataJsonObj.put("sign", "asfasfasfu3dsfkj3kjdv=");
						fileGstr1DataJsonObj.put("st", "DSC");
						fileGstr1DataJsonObj.put("sid", "AMAPT8269L");
						
						long timeStampFile = new Timestamp().getDateTime();
				        gspAuthStringFile = clientId + ":" + transactionId + ":" + timeStampFile + ":" + gstin;
						gspAuthSignatureFile = gspSignature.sign(gspAuthStringFile, aspPrivateKey);
						
						System.out.println("RETFILE request url ["+String.format("%s%s", GSP_API_URL, GSTR1_URL_V3)+"]");
						
						HttpResponse<JsonNode> fileGstr1Resp = Unirest.post(String.format("%s%s", GSP_API_URL, GSTR1_URL_V3))
															   .header("Content-Type", APPLICATION_JSON)
															   .header("state-cd", stateCode)
															   .header("clientid", clientId)
															   .header("client-secret", clientSecret)
															   .header("ip-usr", ipAddress)
															   .header("username", userName)
															   .header("auth-token", authToken)
															   //.header("app_key", appKeyEncryptedAndCoded)
															   .header("txn", transactionId)
															   .header("ret_period", periodCode)
															   .header("gstin", gstin)
															   .header("X-Asp-Auth-Token", gspAuthStringFile)
										    	               .header("X-Asp-Auth-Signature", gspAuthSignatureFile)
															   .body(new JsonNode(fileGstr1DataJsonObj.toString()))
															   .asJson();
						
						System.out.println(String.format("fileGstr1Resp Request : Status[%s] Response[%s]", fileGstr1Resp.getStatus(), fileGstr1Resp.getBody()));
						if (fileGstr1Resp.getStatus() == 200) 
				        {
							JSONObject fileGstr1RespObj = fileGstr1Resp.getBody().getObject();
							if(fileGstr1RespObj.has("data") && fileGstr1RespObj.has("rek"))
							{
								retFileCallStatus = "1";
								String fileGstr1Data = fileGstr1RespObj.getString("data");
								String fileGstr1Rek = fileGstr1RespObj.getString("rek");
								
								byte[] fileGstr1ApiEK = aesEncryption.decrypt(fileGstr1Rek, authSek);
								
								String fileGstr1JsoninBase64 = new String(aesEncryption.decrypt(fileGstr1Data, fileGstr1ApiEK));
								
								byte[] fileGstr1JsonInBytes = aesEncryption.decodeBase64StringTOByte(fileGstr1JsoninBase64);
								
								retFileResponseJsonStr = new String(fileGstr1JsonInBytes);
								
								System.out.println(new String(fileGstr1JsonInBytes));
							}
							else
							{
								retFileCallStatus = "2";
								JSONObject errorJSON = fileGstr1Resp.getBody().getObject().getJSONObject("error");
								retFileResponseJsonStr = errorJSON.toString();
					        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
					        	retString = getError(errMsg, "GSTAPIERR", conn);
							}
				        }
						else
						{
							retFileCallStatus = "2";
							JSONObject errorJSON = fileGstr1Resp.getBody().getObject().getJSONObject("error");
							retFileResponseJsonStr = errorJSON.toString();
				        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
				        	retString = getError(errMsg, "GSTAPIERR", conn);
						}
						
						APICallData apiCallData = new APICallData();
				        apiCallData.setPeriodCode(periodCode);
				        apiCallData.setCallDate(new Date());
				        apiCallData.setSiteCode(siteCode);
				        apiCallData.setUserId(loginCode);
				        apiCallData.setCallType("RETFILE");
				        apiCallData.setRecType("1");
				        apiCallData.setNoOfRecords(0);
				        apiCallData.setCallStatus(retFileCallStatus);
				        apiCallData.setResponseId("");
				        apiCallData.setResponseJsonStr(retFileResponseJsonStr);
				        apiCallData.setChgUser(loginCode);
				        apiCallData.setChgDate(new Date());
				        apiCallData.setChgTerm(chgTerm);
				        
				        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
					}
				}
				else
	            {
					callStatus = "2";
					JSONObject errorJSON = getGstr1SumryResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
	            }
	        }
			else
            {
				callStatus = "2";
            	JSONObject errorJSON = getGstr1SumryResp.getBody().getObject().getJSONObject("error");
            	responseJsonStr = errorJSON.toString();
            	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
	        	retString = getError(errMsg, "GSTAPIERR", conn);
            }
			
			APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("RETSUM");
	        apiCallData.setRecType("1");
	        apiCallData.setNoOfRecords(0);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId("");
	        apiCallData.setResponseJsonStr(responseJsonStr);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getGstr1Summary()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	
	private String submitGstr1(String authToken, String stateCode, String userName, String gstin, String periodCode, byte[] authSEK, String xtraParams,Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String loginCode = "", chgTerm = "", siteCode = "", callStatus = "", responseJsonStr = "", responseId = "";
		
		String sql = "";
		PreparedStatement pstmt = null;
		int updateCnt = 0;
		
		try
		{
			
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			String json = "{\"gstin\":\""+gstin+"\",\"ret_period\":\""+periodCode+"\"}";
            
            byte[] jsonBase64 = Base64.getEncoder().encode(json.getBytes());
			String encryptedPayload = aesEncryption.encryptEK(jsonBase64, authSEK);
			 
			HMac hmac = new HMac(new SHA256Digest());
			byte[] resBuf = new byte[hmac.getMacSize()];
			
			hmac.init(new KeyParameter(authSEK));
			hmac.update(jsonBase64, 0, jsonBase64.length);
			hmac.doFinal(resBuf, 0);
            
			JSONObject reqBody = new JSONObject();
            reqBody.put("action", "RETSUBMIT");
            reqBody.put("data", encryptedPayload);
            reqBody.put("hmac", new String(Base64.getEncoder().encode(resBuf)));
            
            long timeStamp = new Timestamp().getDateTime();
	        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			System.out.println("RETSUBMIT request url ["+String.format("%s%s", GSP_API_URL, GSTR1_URL_V3)+"]");
            
            HttpResponse<JsonNode> gstr1SubmitResp = Unirest.post(String.format("%s%s", GSP_API_URL, GSTR1_URL_V3))
            										.header("Content-Type", APPLICATION_JSON)
            										.header("action", "RETSUBMIT")
            				                        .header("state-cd", stateCode)
            				                        .header("clientid", clientId)
            				                        .header("client-secret", clientSecret)
            				                        .header("ip-usr", ipAddress)
            				                        .header("username", userName)
            				                        .header("auth-token", authToken)
            				                        .header("txn", transactionId)
            				                        .header("ret_period", periodCode)
            				                        .header("gstin", gstin)
            				                        .header("X-Asp-Auth-Token", gspAuthString)
            				                        .header("X-Asp-Auth-Signature", gspAuthSignature)
            				                        .body(new JsonNode(reqBody.toString()))
            				                        .asJson();
            
            System.out.println(String.format("gstr1SubmitResp Request : Status[%s] Response[%s]", gstr1SubmitResp.getStatus(), gstr1SubmitResp.getBody()));
            
            if (gstr1SubmitResp.getStatus() == 200) 
	        {
				JSONObject gstr1SubmitRespObj = gstr1SubmitResp.getBody().getObject();
				if(gstr1SubmitRespObj.has("data") && gstr1SubmitRespObj.has("rek"))
				{
					callStatus = "1";
					String gstr1Submitdata = gstr1SubmitRespObj.getString("data");
					String gstr1Submitrek = gstr1SubmitRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstr1Submitrek, authSEK);
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstr1Submitdata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					JSONObject gstr1SubmitObj = new JSONObject(new String(respJsonInBytes));
					String transId = gstr1SubmitObj.getString("reference_id");
					responseId = transId;
					System.out.println("transId to getStatus after SUBMIT call["+transId+"]");
					
					sql = "UPDATE GST_DATA_HDR SET SUBMIT_STATUS = ? AND SUBMIT_DATE = ? WHERE PRD_CODE = ? AND SITE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					
					pstmt.setString(1, "S");
					pstmt.setString(2, new SimpleDateFormat(new E12GenericUtility().getApplDateFormat()).format(new Date()));
					pstmt.setString(3, periodCode);
					pstmt.setString(4, siteCode);
					
					updateCnt = pstmt.executeUpdate();
					
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					System.out.println("submit status updated of ["+siteCode+"] for ["+periodCode+"] update count ["+updateCnt+"]");
					
				}
				else
	            {
					callStatus = "2";
					JSONObject errorJSON = gstr1SubmitResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	retString = getError(errMsg, "GSTAPIERR", conn);
	            }
	        }
            else if(gstr1SubmitResp.getStatus() == 500)
	        {
	        	callStatus = "2";
	        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+gstr1SubmitResp.getStatus();
	        	responseJsonStr = errMsg;
	        	retString = getError(errMsg, "GSTAPIERR", conn);
	        }
			else
            {
				callStatus = "2";
            	JSONObject errorJSON = gstr1SubmitResp.getBody().getObject().getJSONObject("error");
            	responseJsonStr = errorJSON.toString();
            	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
	        	retString = getError(errMsg, "GSTAPIERR", conn);
            }
            
            APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("RETSUBMIT");
	        apiCallData.setRecType("1");
	        apiCallData.setNoOfRecords(0);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId(responseId);
	        apiCallData.setResponseJsonStr(responseJsonStr);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.submitGstr1()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	
	private String downloadGstr2Invoices(String authToken, String stateCode, String userName, String gstin, String periodCode, String siteCode, byte[] authSEK, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String[] gstr2Section = {"B2B","IMPG","IMPS","CDN","NIL","TXLI","TXP","B2BUR","ITCRVSL","CDNUR"};
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String loginCode = "", chgTerm = "", callStatus = "", responseJsonStr = "", responseId = "";
		
		try
		{
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			for(String action : gstr2Section)
			{
				System.out.println("calling for ["+action+"]");
				long timeStamp = new Timestamp().getDateTime();
		        gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
				gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
				
				System.out.println("GET "+action+" request url ["+String.format("%s%s", GSP_API_URL, GSTR2_URL_V3)+"]");
				
				 HttpResponse<JsonNode> getGstr2InvoicesResp = Unirest.get(String.format("%s%s", GSP_API_URL, GSTR2_URL_V3))
							     				  		   	   .queryString("action", action)
							     				  		   	   .queryString("gstin", gstin)
							     				  		   	   .queryString("ret_period", periodCode)
							     				  		   	   .header("Content-Type", APPLICATION_JSON)
							     				  		   	   .header("state-cd", stateCode)
							     				  		   	   .header("clientid", clientId)
							     				  		   	   .header("client-secret", clientSecret)
							     				  		   	   .header("ip-usr", ipAddress)
							     				  		   	   .header("username", userName)
							     				  		   	   .header("auth-token", authToken)
							     				  		   	   //.header("app_key", appKeyEncryptedAndCoded)
							     				  		   	   .header("txn", transactionId)
							     				  		   	   .header("ret_period", periodCode)
							     				  		   	   .header("gstin", gstin)
							     				  		   	   .header("X-Asp-Auth-Token", gspAuthString)
										    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
							     				  		   	   .asJson();
				 
				 System.out.println(String.format("getGstr2InvoicesResp Request : Status[%s] Response[%s]", getGstr2InvoicesResp.getStatus(), getGstr2InvoicesResp.getBody()));
				 
				 if (getGstr2InvoicesResp.getStatus() == 200) 
				 {
					 JSONObject getGstr2InvoicesRespObj = getGstr2InvoicesResp.getBody().getObject();
					 if(getGstr2InvoicesRespObj.has("data") && getGstr2InvoicesRespObj.has("rek"))
					 {
						 callStatus = "1";
						 String gstr2InvoicesData = getGstr2InvoicesRespObj.getString("data");
						 String gstr2InvoicesRek = getGstr2InvoicesRespObj.getString("rek");

						 byte[] apiEK = aesEncryption.decrypt(gstr2InvoicesRek, authSEK);
						 String respJsoninBase64 = new String(aesEncryption.decrypt(gstr2InvoicesData, apiEK));

						 byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
						 
						 JSONObject gstr2InvoiceJsonObj = new JSONObject(new String(respJsonInBytes));
						 
						 System.out.println("respJsonInBytes["+new String(respJsonInBytes)+"]");
						 
						 if("B2B".equalsIgnoreCase(action))
						 {
							 insertB2BInvoiceData(stateCode, siteCode, gstr2InvoiceJsonObj, conn);
						 }
						 else if("IMPG".equalsIgnoreCase(action))
						 {
							 insertIMGInvoiceData(stateCode, siteCode, gstr2InvoiceJsonObj, conn);
						 }
						 

					 }
					 else
					 {
						 callStatus = "2";
						 JSONObject errorJSON = getGstr2InvoicesResp.getBody().getObject().getJSONObject("error");
						 responseJsonStr = errorJSON.toString();
						 errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
						 retString = getError(errMsg, "GSTAPIERR", conn);
					 }
				 }
				 else if(getGstr2InvoicesResp.getStatus() == 500)
				 {
		        	callStatus = "2";
		        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+getGstr2InvoicesResp.getStatus();
		        	responseJsonStr = errMsg;
		        	retString = getError(errMsg, "GSTAPIERR", conn);
				 }
				 else
				 {
					 callStatus = "2";
					 JSONObject errorJSON = getGstr2InvoicesResp.getBody().getObject().getJSONObject("error");
					 responseJsonStr = errorJSON.toString();
					 errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
					 retString = getError(errMsg, "GSTAPIERR", conn);
				 }
				 
				 APICallData apiCallData = new APICallData();
		         apiCallData.setPeriodCode(periodCode);
		         apiCallData.setCallDate(new Date());
		         apiCallData.setSiteCode(siteCode);
		         apiCallData.setUserId(loginCode);
		         apiCallData.setCallType("GET_"+action);
		         apiCallData.setRecType("2");
		         apiCallData.setNoOfRecords(0);
		         apiCallData.setCallStatus(callStatus);
		         apiCallData.setResponseId(responseId);
		         apiCallData.setResponseJsonStr(responseJsonStr);
		         apiCallData.setChgUser(loginCode);
		         apiCallData.setChgDate(new Date());
		         apiCallData.setChgTerm(chgTerm);
		        
		         gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getGstr2Invoices()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	
	private void insertB2BInvoiceData(String stateCode, String siteCode, JSONObject gstr2InvoiceJsonObj, Connection conn) throws ITMException
	{
		JSONArray b2bInvArry = new JSONArray();
		JSONObject b2bJsonObj = new JSONObject();
		JSONArray b2bInvJsonArry = new JSONArray();
		JSONObject b2bInvJsonObj = new JSONObject();
		JSONArray b2bInvLineItmsArry = new JSONArray();
		JSONObject b2bInvLineItemObj = new JSONObject();
		String tranId = "", cptyGSTIN = "", iNum = "", iDate = "", reversCharge = "", docCheckSum = "", pos = "", invType = "", tranType = ""; 
		String itcType = "";
		
		int lineNo;
		double amount = 0.0, lineAmt = 0.0, irt = 0.0, iamt = 0.0, crt = 0.0, camt = 0.0, srt = 0.0, samt = 0.0, csrt = 0.0, csamt = 0.0, rate = 0.0; 
	 	double itcIGSTTaxAmt = 0.0, itcCGSTTaxAmt = 0.0, itcSGSTTaxAmt = 0.0, itcCSGSTTaxAmt =0.0;
	 	
	 	List<String> hdrColumnList = new ArrayList<String>(), hdrDataTypeList = new ArrayList<String>(), hdrDataList = null;
	 	List<String> detColumnList = new ArrayList<String>(),  detDataTypeList = new ArrayList<String>();
	 	List<List<String>> detDataList = null;
		
		try
		{
			hdrColumnList.add("TRAN_ID");
			hdrColumnList.add("TRAN_DATE");
			hdrColumnList.add("REC_TYPE");
			hdrColumnList.add("TRAN_TYPE");
			hdrColumnList.add("GST_CODE");
			hdrColumnList.add("SUBMIT_STATUS");
			hdrColumnList.add("DOC_CHECKSUM");
			hdrColumnList.add("DOC_NO");
			hdrColumnList.add("DOC_DATE");
			hdrColumnList.add("AMOUNT");
			hdrColumnList.add("REVERSE_CHRG");
			hdrColumnList.add("TAX_REG_NO");
			hdrColumnList.add("SITE_CODE");
			hdrColumnList.add("DOC_TYPE");
			
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("TIMESTAMP");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("TIMESTAMP");
			hdrDataTypeList.add("DOUBLE");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			
			detColumnList.add("TRAN_ID");
			detColumnList.add("LINE_NO");
			detColumnList.add("TAXABLE_AMT");
			detColumnList.add("IGST_PERC");
			detColumnList.add("IGST_AMT");
			detColumnList.add("CGST_PERC");
			detColumnList.add("CGST_AMT");
			detColumnList.add("SGST_PERC");
			detColumnList.add("SGST_AMT");
			detColumnList.add("CESS_PERC");
			detColumnList.add("CESS_AMT");
			detColumnList.add("ITC_TYPE");
			detColumnList.add("ITC_IGST");
			detColumnList.add("ITC_CGST");
			detColumnList.add("ITC_SGST");
			detColumnList.add("ITC_CESS");
			
			detDataTypeList.add("STRING");
			detDataTypeList.add("INT");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("STRING");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			
			b2bInvArry = gstr2InvoiceJsonObj.getJSONArray("b2b");
			
			for(int i = 0; i < b2bInvArry.length(); i++)
			{
				
				b2bJsonObj = b2bInvArry.getJSONObject(i);
				cptyGSTIN = b2bJsonObj.getString("ctin");
				
				b2bInvJsonArry = b2bJsonObj.getJSONArray("inv");
				
				for(int j=0; j<b2bInvJsonArry.length(); j++)
				{
					hdrDataList = new ArrayList<String>();
					b2bInvJsonObj = b2bInvJsonArry.getJSONObject(j);
					
					iNum = b2bInvJsonObj.getString("inum");
					iDate = b2bInvJsonObj.getString("idt");
					amount = b2bInvJsonObj.getDouble("val");
					docCheckSum = b2bInvJsonObj.getString("chksum");
					reversCharge = b2bInvJsonObj.getString("rchrg");
					pos = b2bInvJsonObj.getString("pos");
					invType = b2bInvJsonObj.getString("inv_typ");
					
					if("Y".equalsIgnoreCase(reversCharge))
					{
						tranType = "02";
					}
					else 
					{
						tranType = "01";
					}
										
					tranId = generateTranId("w_gstr_purc","","",conn);
					
					hdrDataList.add(tranId);
					hdrDataList.add(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateFormat()));
					hdrDataList.add("2");
					hdrDataList.add(tranType);
					hdrDataList.add(pos);
					hdrDataList.add("D");
					hdrDataList.add(docCheckSum);
					hdrDataList.add(iNum);
					hdrDataList.add(iDate);
					hdrDataList.add(String.valueOf(amount));
					hdrDataList.add(reversCharge);
					hdrDataList.add(cptyGSTIN);
					hdrDataList.add(siteCode);
					hdrDataList.add(invType);
					
					detDataList = new ArrayList<List<String>>();
					List<String> tempList = new ArrayList<String>();
					
					b2bInvLineItmsArry = b2bInvJsonObj.getJSONArray("itms");
					
					for(int k=0; k<b2bInvLineItmsArry.length(); k++)
					{
						b2bInvLineItemObj = b2bInvLineItmsArry.getJSONObject(k);
						
						lineNo = b2bInvLineItemObj.getInt("num");
						
						JSONObject tempJSONObj = b2bInvLineItemObj.getJSONObject("itm_det");
						
						rate = tempJSONObj.getDouble("rt");
						lineAmt = tempJSONObj.getDouble("txval");
						iamt = tempJSONObj.getDouble("iamt");
						camt = tempJSONObj.getDouble("camt");
						samt = tempJSONObj.getDouble("samt");
						csamt = tempJSONObj.getDouble("csamt");
						
						if(stateCode.trim().equalsIgnoreCase(pos.trim()))
						{
							irt = rate;
						}
						else
						{
							crt = rate/2;
							srt = rate/2;
						}
						
						tempJSONObj = b2bInvLineItemObj.getJSONObject("itc");
						
						itcType = tempJSONObj.getString("elg");
						itcIGSTTaxAmt = tempJSONObj.getDouble("tx_i");
						itcCGSTTaxAmt = tempJSONObj.getDouble("tx_c");
						itcSGSTTaxAmt = tempJSONObj.getDouble("tx_s");
						itcCSGSTTaxAmt = tempJSONObj.getDouble("tx_cs");
						
						tempList = new ArrayList<String>();
						tempList.add(tranId);
						tempList.add(String.valueOf(lineNo));
						tempList.add(String.valueOf(lineAmt));
						tempList.add(String.valueOf(irt));
						tempList.add(String.valueOf(iamt));
						tempList.add(String.valueOf(crt));
						tempList.add(String.valueOf(camt));
						tempList.add(String.valueOf(srt));
						tempList.add(String.valueOf(samt));
						tempList.add(String.valueOf(csrt));//TODO computation of cess rate is pending as data is summarised on rate 
						tempList.add(String.valueOf(csamt));
						tempList.add(itcType);
						tempList.add(String.valueOf(itcIGSTTaxAmt));
						tempList.add(String.valueOf(itcCGSTTaxAmt));
						tempList.add(String.valueOf(itcSGSTTaxAmt));
						tempList.add(String.valueOf(itcCSGSTTaxAmt));
						
					}
					
					detDataList.add(tempList);
				}
				
				insertGSTHdrDetData(hdrColumnList, hdrDataTypeList, hdrDataList, detColumnList, detDataTypeList, detDataList, conn);
			}
			
			
		}
		catch (Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.insertB2BInvoiceData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
	}
	
	private void insertIMGInvoiceData(String stateCode, String siteCode, JSONObject gstr2InvoiceJsonObj, Connection conn) throws ITMException
	{
		JSONArray imgInvoiceArry = new JSONArray();
		JSONObject imgJsonObj = new JSONObject();
		JSONArray imgInvLineItmsArry = new JSONArray();
		JSONObject imgInvLineItemObj = new JSONObject();
		
		String tranId = "", isSezImport = "", supplierGSTIN = "", billOfEntry = "", billOfEntryDtStr = "", checkSum = "", portCode = "", itcType = "",
			   tranType = "", docType = "";
		int lineNo = 0;
		double billOfEntryAmt = 0.0, rate = 0.0, igstAmt = 0.0, taxableValue = 0.0, cessAmt = 0.0, itcIGSTAmt = 0.0, itcCessAmt = 0.0, cessrt = 0.0;
		
		List<String> hdrColumnList = new ArrayList<String>(), hdrDataTypeList = new ArrayList<String>(), hdrDataList = null;
	 	List<String> detColumnList = new ArrayList<String>(),  detDataTypeList = new ArrayList<String>();
	 	List<List<String>> detDataList = null;
		
		try
		{
			hdrColumnList.add("TRAN_ID");
			hdrColumnList.add("TRAN_DATE");
			hdrColumnList.add("REC_TYPE");
			hdrColumnList.add("TRAN_TYPE");
			hdrColumnList.add("SUBMIT_STATUS");
			hdrColumnList.add("DOC_CHECKSUM");
			hdrColumnList.add("LR_NO");
			hdrColumnList.add("LR_DATE");
			hdrColumnList.add("AMOUNT");
			hdrColumnList.add("TAX_REG_NO");
			hdrColumnList.add("SITE_CODE");
			hdrColumnList.add("DOC_TYPE");
			hdrColumnList.add("ORDER_NO");
			
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("TIMESTAMP");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("DOUBLE");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			hdrDataTypeList.add("STRING");
			
			detColumnList.add("TRAN_ID");
			detColumnList.add("LINE_NO");
			detColumnList.add("TAXABLE_AMT");
			detColumnList.add("IGST_PERC");
			detColumnList.add("IGST_AMT");
			detColumnList.add("CESS_PERC");
			detColumnList.add("CESS_AMT");
			detColumnList.add("ITC_TYPE");
			detColumnList.add("ITC_IGST");
			detColumnList.add("ITC_CESS");
			
			detDataTypeList.add("STRING");
			detDataTypeList.add("INT");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("STRING");
			detDataTypeList.add("DOUBLE");
			detDataTypeList.add("DOUBLE");
			
			imgInvoiceArry = gstr2InvoiceJsonObj.getJSONArray("imp_g");
			
			for(int i=0; i<imgInvoiceArry.length(); i++)
			{
				imgJsonObj = imgInvoiceArry.getJSONObject(i);
				
				isSezImport = imgJsonObj.getString("is_sez");
				supplierGSTIN = imgJsonObj.getString("stin");
				billOfEntry = imgJsonObj.getString("boe_num");
				billOfEntryDtStr = imgJsonObj.getString("boe_dt");
				billOfEntryAmt = imgJsonObj.getDouble("boe_val");
				checkSum = imgJsonObj.getString("chksum");
				portCode = imgJsonObj.getString("port_code");
				
				if("Y".equalsIgnoreCase(isSezImport))
				{
					tranType = "06";
				}
				else
				{
					tranType = "05";
				}
				
				tranId = generateTranId("w_gstr_purc","","",conn);
				
				detDataList = new ArrayList<List<String>>();
				List<String> tempList = new ArrayList<String>();
				
				imgInvLineItmsArry = imgJsonObj.getJSONArray("itms");
				
				for(int j=0; j< imgInvLineItmsArry.length(); j++)
				{
					imgInvLineItemObj = imgInvLineItmsArry.getJSONObject(j);
					
					lineNo = imgInvLineItemObj.getInt("num");
					rate = imgInvLineItemObj.getDouble("rt");
					taxableValue = imgInvLineItemObj.getDouble("txval");
					igstAmt = imgInvLineItemObj.getDouble("iamt");
					cessAmt = imgInvLineItemObj.getDouble("csamt");
					itcType = imgInvLineItemObj.getString("elg");
					itcIGSTAmt = imgInvLineItemObj.getDouble("tx_i");
					itcCessAmt = imgInvLineItemObj.getDouble("tx_cs");
					
					if(igstAmt > 0)
					{
						docType = "SEWP";
					}
					else
					{
						docType = "SEWOP";
					}
					
					tempList.add(tranId);
					tempList.add(String.valueOf(lineNo));
					tempList.add(String.valueOf(taxableValue));
					tempList.add(String.valueOf(rate));
					tempList.add(String.valueOf(igstAmt));
					tempList.add(String.valueOf(cessrt));//TODO computation of cess rate is pending as data is summarised on rate 
					tempList.add(String.valueOf(cessAmt));
					tempList.add(itcType);
					tempList.add(String.valueOf(itcIGSTAmt));
					tempList.add(String.valueOf(itcCessAmt));
					
				}
				
				detDataList.add(tempList);
				
				hdrDataList = new ArrayList<String>();
				
				hdrDataList.add(tranId);
				hdrDataList.add(e12GenericUtility.getValidDateString(new Date(), e12GenericUtility.getDBDateFormat()));
				hdrDataList.add("2");
				hdrDataList.add(tranType);
				hdrDataList.add("D");
				hdrDataList.add(checkSum);
				hdrDataList.add(billOfEntry);
				hdrDataList.add(billOfEntryDtStr);
				hdrDataList.add(String.valueOf(billOfEntryAmt));
				hdrDataList.add(supplierGSTIN);
				hdrDataList.add(siteCode);
				hdrDataList.add(docType);
				hdrDataList.add(portCode);
			}
			
			insertGSTHdrDetData(hdrColumnList, hdrDataTypeList, hdrDataList, detColumnList, detDataTypeList, detDataList, conn);
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.insertIMGInvoiceData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
	}
	
	private void updateSubmissionStatus(ArrayList<String> tranIdList, Connection conn) throws ITMException
	{
		String updateSql = "";
		PreparedStatement pstmtUpd = null;
		
		try
		{
			updateSql = "UPDATE GST_DATA_HDR SET SUBMIT_STATUS = ?, SUBMIT_DATE = ? WHERE TRAN_ID = ?";
			pstmtUpd = conn.prepareStatement(updateSql);
			
			for(String tranId : tranIdList)
			{
				pstmtUpd.setString(1, "T");
				pstmtUpd.setString(2, new SimpleDateFormat(new E12GenericUtility().getApplDateFormat()).format(new Date()));
				pstmtUpd.setString(3, tranId);
				
				pstmtUpd.addBatch();
				pstmtUpd.clearParameters();
			}
			
			int[] updateCount = pstmtUpd.executeBatch();
			
			System.out.print("GST_DATA_HSR Update count");
			
			for(int eachRowCnt : updateCount)
			{
				System.out.print(eachRowCnt + ",");
			}
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizPos.updateSubmissionStatus()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
	}
	
	private String getError(String errMsg, String Code, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			
			String begPart = errString.substring(0,errString.indexOf("</description>"));
			String endDesc = errString.substring(errString.indexOf("</description>"),errString.length());
			mainStr = checkNullandTrim(begPart) + "<![CDATA[" +errMsg+ " ]]>" + checkNullandTrim(endDesc);
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
	
	private String getRetStatusErrMsg(JSONObject retStatusJsonObj) throws ITMException
	{
		String retString = "";
		JSONObject errorJsonObj = null;
		JSONArray eachInvErrorJsonArry = null;
		
		try
		{
			errorJsonObj = retStatusJsonObj.getJSONObject("error_report");
			
			if(errorJsonObj.has("b2b"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2b");
			}
			else if(errorJsonObj.has("b2ba"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2ba");
			}
			else if(errorJsonObj.has("b2cl"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2cl");
			}
			else if(errorJsonObj.has("b2cla"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2cla");
			}
			else if(errorJsonObj.has("b2cs"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2cs");
			}
			else if(errorJsonObj.has("b2csa"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("b2csa");
			}
			else if(errorJsonObj.has("cdnr"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("cdnr");
			}
			else if(errorJsonObj.has("cdnra"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("cdnra");
			}
			else if(errorJsonObj.has("at"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("at");
			}
			else if(errorJsonObj.has("ata"))
			{
				eachInvErrorJsonArry = errorJsonObj.getJSONArray("ata");
			}
			
			
			for(int i=0; i<eachInvErrorJsonArry.length(); i++)
			{
				JSONObject tempJsonObj = (JSONObject) eachInvErrorJsonArry.get(i); 
				retString += tempJsonObj.getString("error_msg")+"\n";
				if(tempJsonObj.has("ty") && tempJsonObj.has("hsn_sc"))
				{
					retString += " Line Type : "+tempJsonObj.optString("ty")+ " Item/Service Code : "+tempJsonObj.optString("hsn_sc")+"\n";
				}
				else if(tempJsonObj.has("nt_num") && tempJsonObj.has("nt_dt"))
				{
					retString += " Credit/Debit No. : "+tempJsonObj.optString("nt_num")+ " Credit/Debit Dt. : "+tempJsonObj.optString("nt_dt")+"\n";
				}
				else if(tempJsonObj.has("doc_num") && tempJsonObj.has("doc_dt") && tempJsonObj.has("typ"))
				{
					retString += " Doc No. : "+tempJsonObj.optString("doc_num")+ " Doc Dt. : "+tempJsonObj.optString("doc_dt")+ " Inv Type : "+tempJsonObj.optString("typ")+"\n";
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getRetStatusErrMsg()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		return retString;
	}
	
	private Invoice getNilRateSummary(String supplyType, String nilAmtTranType, String exmptAmtTranType, String nonGSTAmtTranType, String siteCode, String periodCode, Connection conn)
	{
		Invoice invoice = null;
		double nilAmount = 0.0, exemtAmount = 0.0, nonGSTAmount = 0.0;
		
		String sql= "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			sql = " SELECT TRAN_TYPE,SUM(AMOUNT) AS AMOUNT FROM GST_DATA_HDR "
				+ " WHERE REC_TYPE = '1' AND TRAN_TYPE  in (?,?,?) AND SITE_CODE = ? AND PRD_CODE = ?"
				+ " GROUP BY TRAN_TYPE";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, nilAmtTranType);
			pstmt.setString(2, exmptAmtTranType);
			pstmt.setString(3, nonGSTAmtTranType);
			pstmt.setString(4, siteCode);
			pstmt.setString(5, periodCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				if(invoice == null)
				{
					invoice = new Invoice();
				}
				if(nilAmtTranType.equalsIgnoreCase(rs.getString("TRAN_TYPE")))
				{
					nilAmount = rs.getDouble("AMOUNT");
				}
				if(exmptAmtTranType.equalsIgnoreCase(rs.getString("TRAN_TYPE")))
				{
					exemtAmount = rs.getDouble("AMOUNT");
				}
				if(nonGSTAmtTranType.equalsIgnoreCase(rs.getString("TRAN_TYPE")))
				{
					nonGSTAmount = rs.getDouble("AMOUNT");
				}
			}
			
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			
			if(invoice != null)
			{
				invoice.supplyType = supplyType;
				invoice.totalNilAmount = nilAmount;
				invoice.totalExemptedAmount = exemtAmount;
				invoice.totalNonGSTAmout = nonGSTAmount;
			}
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizPos.getNilRateSummary()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		
		return invoice;
	}
	
	private void insertGSTHdrDetData(List<String> hdrColumnList, List<String> hdrDataTypeList, List<String> hdrDataList, List<String> detColumnList, List<String> detDataTypeList, List<List<String>> detDataList, Connection conn) throws ITMException
	{
		boolean isError = false;
		PreparedStatement hdrPstmt = null, detPstmt = null;
		int hdrInsertCnt = 0;
		int[] detInsertCntArray = null;
		
		String hdrInsertSql = "", detInsertSql = "";
		
		StringBuffer hdrInsertSqlBuff = new StringBuffer();
		StringBuffer detInsertSqlBuff = new StringBuffer();
		
		try
		{
			hdrInsertSqlBuff.append("INSERT INTO GST_DATA_HDR (");
			
			for(String columnName : hdrColumnList)
			{
				hdrInsertSqlBuff.append(columnName+",");
			}
			hdrInsertSqlBuff.deleteCharAt(hdrInsertSqlBuff.length()-1);
			hdrInsertSqlBuff.append(") VALUES (");
			
			for(int i=0; i<hdrColumnList.size(); i++)
			{
				hdrInsertSqlBuff.append("?,");
			}
			hdrInsertSqlBuff.deleteCharAt(hdrInsertSqlBuff.length()-1);
			hdrInsertSqlBuff.append(")");
			
			hdrInsertSql = hdrInsertSqlBuff.toString();
			System.out.println("hdrInsertSql["+hdrInsertSql+"]");
			
			hdrPstmt = conn.prepareStatement(hdrInsertSql);
			
			for(int i=0; i<hdrDataTypeList.size(); i++)
			{
				
				String dataType = hdrDataTypeList.get(i);

				if("STRING".equalsIgnoreCase(dataType))
				{
					hdrPstmt.setString(i+1, hdrDataList.get(i));
				}
				else if("TIMESTAMP".equalsIgnoreCase(dataType))
				{
					String timestampStr = hdrDataList.get(i);
					java.sql.Timestamp timestamp = java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(timestampStr, e12GenericUtility.getDBDateFormat()));
					hdrPstmt.setTimestamp(i+1, timestamp);
				}
				else if("DOUBLE".equalsIgnoreCase(dataType))
				{
					hdrPstmt.setDouble(i+1, Double.valueOf(hdrDataList.get(i)));
				}
				else if("INT".equalsIgnoreCase(dataType))
				{
					hdrPstmt.setInt(i+1, Integer.valueOf(hdrDataList.get(i)));
				}
			}
			
			hdrInsertCnt = hdrPstmt.executeUpdate();
			
			System.out.println("GST_DATA_HDR insert count["+hdrInsertCnt+"]");
			
			if(hdrPstmt != null)
			{
				hdrPstmt.close();
				hdrPstmt = null;
			}
			
			detInsertSqlBuff.append("INSERT INTO GST_DATA_DET (");
			
			for(String columnName : detColumnList)
			{
				detInsertSqlBuff.append(columnName+",");
			}
			detInsertSqlBuff.deleteCharAt(detInsertSqlBuff.length()-1);
			detInsertSqlBuff.append(") VALUES (");
			
			for(int i=0; i<detColumnList.size(); i++)
			{
				detInsertSqlBuff.append("?,");
			}
			detInsertSqlBuff.deleteCharAt(detInsertSqlBuff.length()-1);
			detInsertSqlBuff.append(")");
			
			detInsertSql = detInsertSqlBuff.toString();
			System.out.println("detInsertSql["+detInsertSql+"]");
			
			detPstmt = conn.prepareStatement(detInsertSql);
			
			for(List<String> eachDetList : detDataList)
			{
				for(int i=0; i<detDataTypeList.size(); i++)
				{
					String dataType = detDataTypeList.get(i);

					if("STRING".equalsIgnoreCase(dataType))
					{
						detPstmt.setString(i+1, eachDetList.get(i));
					}
					else if("TIMESTAMP".equalsIgnoreCase(dataType))
					{
						String timestampStr = eachDetList.get(i);
						java.sql.Timestamp timestamp = java.sql.Timestamp.valueOf(e12GenericUtility.getValidDateString(timestampStr, e12GenericUtility.getDBDateFormat()));
						detPstmt.setTimestamp(i+1, timestamp);
					}
					else if("DOUBLE".equalsIgnoreCase(dataType))
					{
						detPstmt.setDouble(i+1, Double.valueOf(eachDetList.get(i)));
					}
					else if("INT".equalsIgnoreCase(dataType))
					{
						detPstmt.setInt(i+1, Integer.valueOf(eachDetList.get(i)));
					}
				}
				
				detPstmt.addBatch();
				detPstmt.clearParameters();
			}
			
			detInsertCntArray = detPstmt.executeBatch();
			
			System.out.print("GST_DATA_DET insert count");
			
			for(int eachRowCnt : detInsertCntArray)
			{
				System.out.print(eachRowCnt + ",");
			}
			
			if(detPstmt != null)
			{
				detPstmt.close();
				detPstmt = null;
			}
			
		}
		catch(SQLException se)
		{
			isError = true;
			System.out.println("GSTDataSubmitWizPos.insertGSTHdrDetData()["+se.getMessage()+"]");
			se.printStackTrace();
			throw new ITMException(se);
		} 
		catch (Exception e) 
		{
			isError = true;
			System.out.println("GSTDataSubmitWizPos.insertGSTHdrDetData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(isError)
				{
					if(hdrPstmt != null)
					{
						hdrPstmt.close();
						hdrPstmt = null;
					}
					if(detPstmt != null)
					{
						detPstmt.close();
						detPstmt = null;
					}
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizPos.insertGSTHdrDetData()["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
	}
	
	private static String checkNullandTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	private String generateTranId( String windowName, String siteCode, String tranDateStr, Connection conn )throws ITMException,Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";	

		try
		{
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +		"<tran_id></tran_id>";
			xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +		"<tran_date>" + tranDateStr + "</tran_date>"; 
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);

		}
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		return tranId;
	}

}
