/*	
		Developed by	: Hatim Laxmidhar
		Started On		: 07/01/2006
		Purpose  		: Cancel Button
		Window			: w_emp_separation

*/

package ibase.webitm.ejb.adm.adv;

import java.rmi.RemoteException;
import java.sql.*;
import javax.ejb.*;

import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.system.config.*;
import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3

public class EmpSeparationCnc extends ActionHandlerEJB implements EmpSeparationCncLocal,EmpSeparationCncRemote //SessionBean
{
	/*public void ejbCreate() throws RemoteException, CreateException 
	{
	}

	public void ejbRemove()
	{
	}

	public void ejbActivate() 
	{
	}

	public void ejbPassivate() 
	{
	}
	*/
    public String actionHandler() throws RemoteException,ITMException
	{
		return "";
	}
	
	public String actionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{

		String  retString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			retString = actionCancel(tranId, xtraParams, forcedFlag);
		}
		catch(Exception e)
		{
			System.out.println("Exception :EmpSeparationCncEJB :actionHandler :" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning String from EmpSeparationCncEJB :actionHandler :"+retString);
		return retString;
	}

	private String actionCancel(String tranId, String xtraParams, String forcedFlag) throws Exception
	{
		String status = "", sql = "";
		String errCode = "", errString = "";
		String empCode = "";
		String resiDateStr = "";
		java.sql.Date resiDate = null;
		String loginCode = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		GenericUtility genericUtility = GenericUtility.getInstance();
		int cnt = 0;
		try
		{
			conn = connDriver.getConnectDB("DriverITM");

			System.out.println("########### Inside EmpSeparationCncEJB[actionCancel]  ###########");
			System.out.println("Tran ID : "+ tranId);

			resiDateStr = tranId.substring(tranId.indexOf(":")+1);
			System.out.println("resiDateStr : " + resiDateStr);
			// Modified by Piyush on 30/01/2016 [To make compliance with appl and db date format setting - Req ID: A15JSUN006].Start
			/*
			resiDateStr = genericUtility.getValidDateString(resiDateStr, "dd/MM/yy", "yyyy-MM-dd");
			resiDate = java.sql.Date.valueOf(resiDateStr);
			*/
			java.sql.Timestamp resiTimeStamp = java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(resiDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())); 
			// Modified by Piyush on 30/01/2016 [To make compliance with appl and db date format setting - Req ID: A15JSUN006].End

			empCode = tranId.substring(0,tranId.indexOf(":"));
			System.out.println("empCode : " + empCode);
		
			sql = "SELECT STATUS FROM SEPARATION WHERE EMP_CODE = ? AND RESI_DATE = ?";
			System.out.println("sql :\n" + sql +"\n");
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,empCode);
			// Modified by Piyush on 30/01/2016 [To make compliance with appl and db date format setting - Req ID: A15JSUN006]
			//pstmt.setDate(2,resiDate);
			pstmt.setTimestamp(2,resiTimeStamp);

			rs = pstmt.executeQuery();
			pstmt.clearParameters();
			if (rs.next())
			{
				status = rs.getString(1);
			}
			
			System.out.println("Status :"+status);
			
			if (!status.equalsIgnoreCase("C"))
			{
				sql = "UPDATE SEPARATION SET STATUS = 'X' WHERE EMP_CODE = ? AND RESI_DATE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,empCode);
				// Modified by Piyush on 30/01/2016 [To make compliance with appl and db date format setting - Req ID: A15JSUN006]
				//pstmt.setDate(2,resiDate);
				pstmt.setTimestamp(2,resiTimeStamp);

				cnt = pstmt.executeUpdate();
				if (cnt > 0)
				{
					errCode = "VTCANC1";
				}
			}
			else 
			{
				errCode = "VTRCONF1";
			}
		}
		catch (Exception e)
		{
			System.out.println("The Exception occure in EmpSeparationCncEJB :"+e);
			throw e;
		}
		finally
		{
			errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);			
			try
			{	
				if (conn!=null)
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception in finally: " + e);
			}
		}
		return errString;
	}
}
