package ibase.webitm.ejb.adm;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;


import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.sql.Timestamp;
import org.w3c.dom.Document;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.ejb.Stateless; 



@Stateless 
public class EmpBondDefinition extends ValidatorEJB implements EmpBondDefinitionLocal,EmpBondDefinitionRemote 
{
	
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String itemChanged() throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = null;
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = "";
	
		System.out.println("\n\n xmlString in wfValData \n:" + xmlString + "\n");
		System.out.println("\n\n xmlString1 in wfValData \n :" + xmlString1 +"\n");
		System.out.println("\n\n xmlString2 in wfValData \n :" + xmlString2 +"\n");
	
		try
		{
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0)
			{
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			
			//ADDED FOR INVOIKING VALIDATION IN WORKFLOW
			if( objContext != null && Integer.parseInt(objContext) == 1 )
			{
				parentNodeList = dom2.getElementsByTagName("Header0");
				parentNode = parentNodeList.item(1);
				childNodeList = parentNode.getChildNodes();						
				for(int x=0;x<childNodeList.getLength();x++)
				{				
					childNode = childNodeList.item(x);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("Detail1"))
					{
						errString = wfValData(dom,dom1,dom2,"1",editFlag,xtraParams);
						if(errString != null && errString.trim().length() > 0)
							break;
					}
					else if(childNodeName.equalsIgnoreCase("Detail2"))
					{						
						errString = wfValData(dom,dom1,dom2,"2",editFlag,xtraParams);
						if(errString != null && errString.trim().length() > 0)
							break;
					}	
					else if(childNodeName.equalsIgnoreCase("Detail3"))
					{
						errString = wfValData(dom,dom1,dom2,"3",editFlag,xtraParams);
						if(errString != null && errString.trim().length() > 0)
							break;
					}
				}
			}
			else
			{	
				
				errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
			
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : ChangecontrolEJB : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		return (errString);
	}
	public String wfValData(Document dom, Document dom1, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag) throws RemoteException,ITMException
	{
		return "";
	}
	public String itemChanged(Document dom, Document dom1,String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		return "";
	}
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag) throws RemoteException,ITMException
	{
		return "";
	}
		
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr = 0,cnt = 0;
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		//Modified by RAHUL SHENOY on 11/08/2015 [Declaring Necessary Variables].Start
		String empStatus = "",lineNoRef="",loginSite = "",empSiteDB = "";;
		int bondprdInt = 0, lineNoRefInt = 0;
		Double bondamtDouble = 0.0;
		//Modified by RAHUL SHENOY on 11/08/2015 [Declaring Necessary Variables].End
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String userId = "";
		int currentFormNo=0,i=0;
		int childNodeListLength;		
		
		String empCode="",bondamt="",bondprd="",siteCode = "";
		SimpleDateFormat simpleDateFormat = null;		
		
		
		try
		{
			ConnDriver connDriver = new ConnDriver();
			GenericUtility genericUtility = GenericUtility.getInstance();
			simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			//Modified by RAHUL SHENOY on 12/08/2015 [Obtaining Login Site code].Start
			loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			//Modified by RAHUL SHENOY on 12/08/2015 [Obtaining Login Site code].End
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			switch(currentFormNo)
			{
				case 1 :
					System.out.println("in switch.....");
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						
						if (childNodeName.equalsIgnoreCase("emp_code"))
						{
							empCode = getColumnValue("emp_code",dom);							

							if (empCode == null || empCode.trim().length() == 0 )
							{							
									errCode = "VNULEMPC";
									errString = getErrorString("emp_code",errCode,userId);
									break;
								
							}

							else 
							{
								
								sql = "select count(1) from employee where  emp_code = ? ";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1,empCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt(1);
								}
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
								if(cnt == 0)
								{
									errCode = "VMEMPCD1";
									errString = getErrorString("emp_code",errCode,userId);
									
									break;
								}
								
								//Modified by RAHUL SHENOY on 11/08/2015 [Validations on Employee Code].Start
								

								sql = "select emp_site , count(1) from employee where  emp_code = ? group by emp_site";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1,empCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									empSiteDB = rs.getString("emp_site") == null ? "" : rs.getString("emp_site").trim();
									cnt = rs.getInt(2);
								}
								
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!= null)
								{
									pstmt.close();
									pstmt= null;
								}
								
								if(cnt == 0)
								{
									errCode = "VMEMPCD1";
									errString = getErrorString("emp_code",errCode,userId);
									break;
								}

								
								siteCode = getColumnValue("site_code",dom);		
								
								if(! siteCode.trim().equalsIgnoreCase(loginSite.trim()))
								{	
									System.out.println("Value of Site Code is : " + siteCode.trim());
									System.out.println("Value of Login Site is : " + loginSite.trim());
									errCode = "VMEMPBND01";
									errString = getErrorString("emp_code",errCode,userId);
									break;
								}
									
								
								sql ="select status from employee where emp_code = ? ";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1,empCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									empStatus = rs.getString("status") == null ? "" : rs.getString("status").trim();
								}
								
								if(rs != null)
								{
									rs.close();
									rs = null;
								}
								if(pstmt!= null)
								{
									pstmt.close();
									pstmt= null;
								}
								
								if(empStatus != null && empStatus.equalsIgnoreCase("S"))
								{
									errCode ="VMEMPBND08";
									errString = getErrorString("emp_code",errCode,userId);
									break;
								}
								
						//Modified by RAHUL SHENOY on 11/08/2015 [Validations on Employee Code].End
							}
						}
					
						//Modified by RAHUL SHENOY on 11/08/2015 [Site Code validation to happen in Employee code field].Start
						/*
						else if (childNodeName.equalsIgnoreCase("site_code"))
						{
							siteCode = getColumnValue("site_code",dom);							


							if (siteCode == null || siteCode.trim().length() == 0 )
							{
									errCode = "VMSITENULL";
									errString = getErrorString("site_code",errCode,userId);
									break;
							}
							else
							{
								sql = "select count(1) from site where  site_code = ? ";
								pstmt=conn.prepareStatement(sql);
								pstmt.setString(1,siteCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt(1);
								}
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
								if(cnt == 0)
								{
									errCode = "VMSITENVAL";
									errString = getErrorString("site_code",errCode,userId);
									break;
								}
							}
						}
						*/
						//Modified by RAHUL SHENOY on 11/08/2015 [Site Code validation to happen in Employee code field].End
					}// for loop end
					break;
				case 2:
					parentNodeList = dom.getElementsByTagName("Detail2");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						//Modified by RAHUL SHENOY on 11/08/2015 [Reference Line Number validation].Start
						if (childNodeName.equalsIgnoreCase("line_no__ref"))
						{
							lineNoRef = genericUtility.getColumnValue("line_no__ref",dom);
							lineNoRef = lineNoRef == null ? "0" : lineNoRef.trim();
							lineNoRef = lineNoRef == "null" ? "0" : lineNoRef.trim();
							
							try
							{
								System.out.println("The value of lineNoRef is : " + lineNoRef);
								lineNoRefInt = Integer.parseInt(lineNoRef);
								System.out.println("The value of lineNoRefInt is : " + lineNoRefInt);
								
							}catch(Exception e)
							{
								errCode = "VMEMPBND13";
								errString = getErrorString("line_no__ref",errCode,userId);
								
								break;	
							}
							
							if(lineNoRefInt < 0)
							{
								errCode = "VMEMPBND11";
								errString = getErrorString("line_no__ref",errCode,userId);
								
								break;
							}else if(lineNoRefInt > 0 )
							{
								empCode = genericUtility.getColumnValue("emp_code",dom1);
								sql = "select count(1) from employee_bond where line_no= ? and emp_code = ? ";
								pstmt=conn.prepareStatement(sql);
								pstmt.setInt(1, lineNoRefInt);
								pstmt.setString(2,empCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt(1);
								}
								pstmt.close();
								rs.close();
								pstmt = null;
								rs = null;
								if(cnt == 0)
								{
									errCode = "VMEMPBND12";
									errString = getErrorString("line_no__ref",errCode,userId);
									break;
								}
								
							}
							//Modified by RAHUL SHENOY on 18/08/2015 [Checking duplicate records from lineNoRef in dom].Start
							if(checkDuplicateRecordsfromDom(dom2,"line_no__ref"))
							{
								errCode = "VMEMPBND14";
								errString = getErrorString("line_no__ref",errCode,userId);
								break;
							}//Modified by RAHUL SHENOY on 18/08/2015 [Checking duplicate records from lineNoRef in dom].End
							
						}//Modified by RAHUL SHENOY on 11/08/2015 [Reference Line Number validation].End
						
						
						 if (childNodeName.equalsIgnoreCase("bond_amt"))
						{
							bondamt = genericUtility.getColumnValue("bond_amt",dom);	

							
							if (bondamt == null )
							{
									errCode = "VMBAMTNULL";
									errString = getErrorString("bond_amt",errCode,userId);
									
									break;
							}	
							//Modified by Rahul Shenoy on 11/08/2015 [Revised Bond Amount Validations].Start	
							try
							{
								bondamtDouble = Double.parseDouble(bondamt);
							}
							
							 catch(Exception e)
							{
								errCode = "VMEMPBND06";	
								errString = getErrorString("bond_amt", errCode, userId);
								break;
							}
							
							if(bondamtDouble < 0)
							{
								errCode = "VMEMPBND04";
								errString = getErrorString("bond_amt", errCode, userId);
								break;
							}
							
							
							if(bondamtDouble == 0.0 && lineNoRefInt == 0)
							{	
								errCode = "VMEMPBND10";
								errString = getErrorString("bond_amt", errCode, userId);
								break;
							}
							//Modified by Rahul Shenoy on 11/08/2015 [Revised Bond Amount Validations].End							
							
						}
						
						 if (childNodeName.equalsIgnoreCase("bond_prd"))
						{
							bondprd = genericUtility.getColumnValue("bond_prd",dom);
							
							bondprd = (bondprd == null ) ? "0" : bondprd.trim() ;
							
							

							if (bondprd == null || bondprd.trim().length() == 0 )
							{
								errCode = "VMBPRDNULL";
								errString = getErrorString("bond_prd",errCode,userId);
								break;
							}
							
						//Modified by Rahul Shenoy on 11/08/2015 [Revised Bond period Validations].Start
							try
							{
								bondprdInt = Integer.parseInt(bondprd);
							}
							catch(Exception e)
							{
								errCode = "VMEMPBND05";
								errString = getErrorString("bond_prd", errCode, userId);
								break;
							}
							if(bondprdInt < 1)
							{
								errCode = "VMEMPBND03";
								errString = getErrorString("bond_prd", errCode, userId);
								break;
							}
							
							boolean isDupRecordInDom = checkDuplicateRecordsfromDom(dom2,"bond_prd");
							System.out.println("Duplicate records available in dom ---"+isDupRecordInDom);
							if(isDupRecordInDom)
							{
								System.out.println("***Duplicate records available in DOM ***");
							
								errCode = "VMEMPBND09";
								errString = getErrorString("bond_prd", errCode, userId);
								break;
								
							}

							
								int cntBondPrd = 0;
								empCode = genericUtility.getColumnValue("emp_code",dom1);							
								lineNoRef = genericUtility.getColumnValue("line_no__ref",dom);	
								System.out.println("lineNoRef..["+lineNoRef+"]");
								lineNoRef = lineNoRef == null || lineNoRef.trim().length() == 0?"0":lineNoRef.trim();
								try
								{
									lineNoRefInt = Integer.parseInt(lineNoRef);
								}
								catch (Exception e)
								{
									lineNoRefInt = 0;
								}
								
							 	sql = "select count(1) from employee_bond where emp_code = ? and bond_prd = ? and line_no <> ?";
								pstmt= conn.prepareStatement(sql);
								pstmt.setString(1, empCode);
								pstmt.setString(2, bondprd);
								pstmt.setInt(3, lineNoRefInt);
								rs = pstmt.executeQuery();
								
								if(rs.next())
								{
									cntBondPrd = rs.getInt(1);
								}
						
								if (rs != null)
								{
									rs.close();
									rs = null;
								}
								if (pstmt != null)
								{
									pstmt.close();
									pstmt = null;
								}

								if(cntBondPrd > 0)
								{
									errCode = "VMEMPBND02";
									errString = getErrorString("bond_prd", errCode, userId);
									break;
								}
						//Modified by Rahul Shenoy on 11/08/2015 [Revised Bond period Validations].End
						
							
							}
						
						
					}// for loop end
					break;					
			} //end switch
			
		}//end try
		catch(Exception e)
		{			
			e.printStackTrace();
			errString = e.getMessage();
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}				
				if(pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null )
				{
					rs.close();
					rs = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}
		}		
		return errString;
	}
	
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		
		try
		{
			dom = parseString(xmlString);			
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [ChangeControlEJB][itemChanged(String,String)] :==>\n"+e.getMessage());
		}
		return valueXmlString;
	}
	
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		
		Node childNode = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		int ctr=0;
		String childNodeName = null;
		String columnValue = null;
		
		//Modified by RAHUL SHENOY on 11/08/2015 [Declaring required variables].Start
		int childNodeListLength = 0;
		int currentFormNo = 0;
		String deptCode="",empCode="";
		String sql = "",descr = "",empfname = "", empmname = "", emplname = "";
		String siteCode ="";
		//Modified by RAHUL SHENOY on 11/08/2015 [Declaring required variables].End
		
		ConnDriver connDriver = new ConnDriver();
		String tranDate="";
		
		try
		{
			GenericUtility genericUtility = GenericUtility.getInstance();
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver=null;
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");

			switch(currentFormNo)
			{
			case 1 :
				valueXmlString.append("<Detail1>");
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				
				childNodeListLength = childNodeList.getLength();
				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
				
				if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					String confirmed="N";
					tranDate = simpleDateFormat.format(timestamp).toString();
					System.out.println("Tran Date 111: "+tranDate.toString());
					valueXmlString.append("<tran_date>").append("<![CDATA["+tranDate.trim()+"]]>").append("</tran_date>");  
					valueXmlString.append("<confirmed>").append("<![CDATA["+confirmed+"]]>").append("</confirmed>");
					
				}
				//Modified by RAHUL SHENOY on 18/08/2015 [Disabling empCode on Edit if records found for the employee code and transaction ID ].Start
				System.out.println("*** Protecting EmpCode if records Exist ***");
				if(currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
				{
					String tranId ="";
					int count1 = 0;
					tranId = genericUtility.getColumnValue("tran_id", dom1);
					empCode = genericUtility.getColumnValue("emp_code", dom1);
					
					sql ="select count(1) from employee_bond_def_det where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						count1 = rs.getInt(1);						
					}
					
					System.out.println("The value of count1 --->>> "+ count1);
					
					if(count1 > 0)
					{
						valueXmlString.append("<emp_code protect=\"1\">").append("<![CDATA["+empCode+"]]>").append("</emp_code>");
					}
				}
				//Modified by RAHUL SHENOY on 18/08/2015 [Disabling empCode on Edit if records found for the employee code and transaction ID ].End
				
				//Modified by RAHUL SHENOY on 11/08/2015 [siteCode to be fetched by Employee Code since site_code field is non-editable in Form].Start
				/*
				else if(currentColumn.trim().equalsIgnoreCase("site_code"))
				{
					
					//Modified by RAHUL SHENOY on 11/08/2015 [Declaring siteCode outside so it can be used at other places]
					//String siteCode = getColumnValue("site_code",dom);
					siteCode = getColumnValue("site_code",dom);
					sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ? ";
					pstmt= conn.prepareStatement(sql);
					pstmt.setString(1,siteCode);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						descr = rs.getString(1) == null ? "" : rs.getString(1);
					}

					pstmt.close();
					rs.close();
					pstmt = null;
					rs = null;
					valueXmlString.append("<site_descr>").append("<![CDATA["+descr.trim()+"]]>").append("</site_descr>");
				}*/
				//Modified by RAHUL SHENOY on 11/08/2015 [siteCode to be fetched by Employee Code since site_code field is non-editable in Form].End
				else if(currentColumn.trim().equalsIgnoreCase("emp_code"))
				{
					
					empCode = genericUtility.getColumnValue("emp_code",dom);
					//Modified by RAHUL SHENOY on 11/08/2015 [Fetching Employee Site for Employee Code from Employee Master Table]
					//	sql = " Select e.emp_fname,e.emp_mname,e.emp_lname,e.dept_code,d.descr from "+ 
					//" employee e,department d "+
					//" where e.dept_code = d.dept_code and e.emp_code = ? ";
					sql = " Select  e.emp_fname,e.emp_mname,e.emp_lname,e.dept_code,d.descr,e.emp_site from "+ 
							" employee e,department d "+
							" where e.dept_code = d.dept_code and e.emp_code = ? ";
					
					pstmt= conn.prepareStatement(sql);
					pstmt.setString(1,empCode);
					rs = pstmt.executeQuery();
					
					if(rs.next())
					{
						empfname = rs.getString(1) == null ? "" : rs.getString(1);
						empmname = rs.getString(2) == null ? "" : rs.getString(2);
						emplname = rs.getString(3) == null ? "" : rs.getString(3);							 
						deptCode = rs.getString(4) == null ? "" : rs.getString(4);
						descr = rs.getString(5) == null ? "" : rs.getString(5);
					//Modified by RAHUL SHENOY on 11/08/2015 [Fetching emp_site from emp_code from employee table]
						siteCode = rs.getString("emp_site") == null ? "" : rs.getString("emp_site");				
					}
					
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!= null)
					{
						pstmt.close();
						pstmt= null;
					}
					
					
				
					//Modified by RAHUL SHENOY in 11/08/2015 [Fetching Description for siteCode obtained].Start
					sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ? ";
					pstmt= conn.prepareStatement(sql);
					pstmt.setString(1,siteCode);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						descr = rs.getString(1) == null ? "" : rs.getString(1);
					}
					
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!= null)
					{
						pstmt.close();
						pstmt= null;
					}
					//Modified by RAHUL SHENOY in 11/08/2015 [Fetching Description for siteCode obtained].End
					
					valueXmlString.append("<emp_fname>").append("<![CDATA["+empfname+"]]>").append("</emp_fname>");
					valueXmlString.append("<emp_mname>").append("<![CDATA["+empmname+"]]>").append("</emp_mname>");
					valueXmlString.append("<emp_lname>").append("<![CDATA["+emplname+"]]>").append("</emp_lname>");
					valueXmlString.append("<dept_code>").append("<![CDATA["+deptCode+"]]>").append("</dept_code>");
					
					//Modified by RAHUL SHENOY on 11/08/2015 [Displaying Site Code and its Description].Start
					valueXmlString.append("<site_code>").append("<![CDATA["+siteCode+"]]>").append("</site_code>");
					valueXmlString.append("<site_descr>").append("<![CDATA["+descr.trim()+"]]>").append("</site_descr>");
					//Modified by RAHUL SHENOY on 11/08/2015 [Displaying Site Code and its Description].End
					
					valueXmlString.append("<department_descr>").append("<![CDATA["+descr+"]]>").append("</department_descr>");
					System.out.println("First Name :"+empfname+" Middle Name :"+empmname+" Last Name :"+emplname);
					System.out.println("Dept code -->>"+deptCode+" descr : "+descr);
					
					
				}	
				valueXmlString.append("</Detail1>");
				break;
				//Modified by RAHUL SHENOY on 11/08/2015 [Case 2 for item changes in Form 2].Start
			case 2 :
				//Modified by RAHUL SHENOY on 18/08/2015 [Disable editing in employee code on loading Detail2].Start

				empCode = genericUtility.getColumnValue("emp_code",dom1 );
				
				System.out.println("*** Protecting EmpCode ***");
				
				valueXmlString.append("<Detail1>\r\n");
				valueXmlString.append("<emp_code protect=\"1\">").append("<![CDATA["+empCode+"]]>").append("</emp_code>"); 
				valueXmlString.append("</Detail1>\r\n");
				
				
				
				//Modified by RAHUL SHENOY on 18/08/2015 [Disable editing in employee code on loading Detail2].End
				
				valueXmlString.append("<Detail2>");
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				String bondPrd="",bondAmt = "",lineNoRef = "";
				ctr = 0;
				childNodeListLength = childNodeList.getLength();
				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
				
				if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					valueXmlString.append("<line_no__ref>").append("<![CDATA[0]]>").append("</line_no__ref>");
				}
				
				if(currentColumn.trim().equalsIgnoreCase("line_no__ref"))
				{
					lineNoRef = genericUtility.getColumnValue("line_no__ref",dom);
					empCode = genericUtility.getColumnValue("emp_code",dom1);
					//
					int lineNoRefInt = Integer.parseInt(lineNoRef);
					if(lineNoRefInt != 0)
					{
						sql = "select bond_prd,bond_amt from employee_bond where emp_code = ? and line_no = ? ";
						pstmt= conn.prepareStatement(sql);
						pstmt.setString(1,empCode);
						pstmt.setString(2,lineNoRef);
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							bondPrd = rs.getString("bond_prd") == null ? "" : rs.getString("bond_prd");
							bondAmt = rs.getString("bond_amt") == null ? "" : rs.getString("bond_amt");
						}
						
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!= null)
						{
							pstmt.close();
							pstmt= null;
						}
					}
					else if(lineNoRefInt == 0)
					{
						bondPrd = "0";
						bondAmt = "0";
					}
					
					valueXmlString.append("<bond_prd__curr>").append("<![CDATA["+bondPrd+"]]>").append("</bond_prd__curr>");
					valueXmlString.append("<bond_prd>").append("<![CDATA["+bondPrd+"]]>").append("</bond_prd>");
					
					valueXmlString.append("<bond_amt__curr>").append("<![CDATA["+bondAmt+"]]>").append("</bond_amt__curr>");
					valueXmlString.append("<bond_amt>").append("<![CDATA["+bondAmt+"]]>").append("</bond_amt>");
					
				}
				valueXmlString.append("</Detail2>");
				break;
				//Modified by RAHUL SHENOY on 11/08/2015 [Case 2 for item changes in Form 2].End
			}// end switch
			valueXmlString.append("</Root>");
			
		}
		catch(Exception e)
		{
			e.printStackTrace();			
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn!=null)
				{	
					conn.close();
					conn = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		System.out.println("Return xml ---->>>>"+valueXmlString.toString());
		return valueXmlString.toString();
	}

	//Modified by RAHUL SHENOY on 21/08/2015 [Validation for duplicate value in the same transaction].Start
  private boolean checkDuplicateRecordsfromDom(Document dom,String field)
	 
	{
		
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		
		String domValue= "";
		ArrayList<String> arrayList = new ArrayList<String>();
		
		
		boolean isDuplRecord = false;
		
		try {
			System.out.println("********---- Entering the Method : checkDuplicateRecordsfromDom for the field ["+field +"] ---- ********");
			parentList = dom.getElementsByTagName("Detail2");
			int parentNodeListLength = parentList.getLength();
			
			System.out.println(" getValidDateFromDom parentList.getLength() ["+parentList.getLength()+"]");
			int prntCtrRec = 0;
			for (int prntCtr = parentNodeListLength; prntCtr > 0; prntCtr-- )
			{	
				parentNode = parentList.item(prntCtr-1);
				System.out.println(" getValidDateFromDom parentNode["+parentNode+"]");	
				prntCtrRec++;
				childList = parentNode.getChildNodes();
				System.out.println(" getValidDateFromDom childList.getLength() ["+childList.getLength()+"]");		
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					System.out.println("childNode.getNodeName() ....["+childNode.getNodeName()+"]");
				
					if ( childNode != null && childNode.getFirstChild() != null &&  
					childNode.getNodeName().equalsIgnoreCase(field) )
					{
						System.out.println("*** The field for checking duplicate records is ["+ field +"] ***");
						
						domValue= childNode.getFirstChild().getNodeValue().trim();
						System.out.println("Value in Dom......["+domValue+"]");
						System.out.println("Values in ArrayList..... ["+ arrayList +"]");
					
						if (arrayList .contains(domValue))
						{
							return true;					
						}
						else 
						{
							System.out.println("***Value added to ArrayList*** \n"+
												"Value is  :" + " ["+domValue+"] ");
							if(field.equalsIgnoreCase("line_no__ref"))
								{
									if(!(domValue.equalsIgnoreCase("0") ||domValue.equalsIgnoreCase("00")||domValue.equalsIgnoreCase("000")) )
									{
										{
											arrayList.add(domValue);
										}
									}
								}
								else
								{
									arrayList.add(domValue);
								}
						}
					}
				}//End Inner For loop
			}//End Outer For loop
			System.out.println("lineNoRefList ["+arrayList+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		return isDuplRecord;
	}
	//Modified by RAHUL SHENOY on 21/08/2015 [Validation for duplicate value in the same transaction].End

		

	  
	  }//end class
