<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>
<body >

<script type="text/javascript" src="/ibase/webitm/js/ITMWizard.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/ITMWizardCalendar.js"></script>

<script>
	var calendertop = 100;
	var calenderleft = 200;
	var selectedObj = null;
	var global_date_format ="dd/MM/yy";
	var global_date_type= "date";

	function assignDate( date )
	{
	document.getElementById( selectedObj ).value = date;
	document.getElementById( selectedObj ).focus();
	}


	function checkForactFinish()
	{
	var actCode = "";
	if ( document.getElementById("Detail1..activity_code") != null )
	{
	actCode = document.getElementById("Detail1..activity_code").value;
	}
	else
	{
	actCode = document.getElementById("Detail1.1.activity_code").value;
	}
	var finishButton = document.getElementById("ActFinish");
	var nextButton = document.getElementById("ActNext");

	if(actCode != null &amp; (actCode == "CL" || actCode == "SL" || actCode == "TL"
	|| actCode == "PL" || actCode == "BD" || actCode == "HL" || actCode ==
	"SD" || actCode == "OH" || actCode == "CO" || actCode == "ED"))
	{
	finishButton.disabled = false;
	nextButton.disabled = true;
	}
	else
	{
	finishButton.disabled = true;
	nextButton.disabled = false;

	}
	}
	function addLoadEvent(func)
	{
	var oldonload = window.onload;
	if (typeof window.onload != 'function')
	{
	window.onload = func;
	}
	else
	{
	window.onload = function()
	{
	if (oldonload)
	{
	oldonload();
	}
	func();
	}
	}
	}
	addLoadEvent(checkForactFinish);
</script>

<style type="text/css">

.tableClass
{margin-left:10px;margin-top:20px}

.header_td
{border:inset 0;background:#FFCCCC;font-family:verdana;font-size:11pt;text-align:center}

.input_editable
{border:inset 2;color:#102132;background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

.td_leftAlign
{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

.td_rightAlign
{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

.hide
{display:none }


</style>

<form name = "Wizard_activity" METHOD="POST" ACTION="/ibase/ITMWizardHandlerServlet" onSubmit="javascript:return validateActivity('1');">


	
	<table id="activityTable" class="tableClass" border="0" cellSpacing="2" cellPadding="1">
		<tr>
			<td class="header_td" colspan="4">
				<strong>Run MRP </strong>
			</td>
		</tr>
		
		
		<xsl:for-each select="//Detail1">
			<xsl:variable name="date_from"><xsl:value-of select="date_from"/></xsl:variable>
			<xsl:variable name="date_to"><xsl:value-of select="date_to"/></xsl:variable>
			<xsl:variable name="site_code__from"><xsl:value-of select="site_code__from"/></xsl:variable>
			<xsl:variable name="site_code__to"><xsl:value-of select="site_code__to"/></xsl:variable>
			
			<xsl:variable name="chg_user"><xsl:value-of select="chg_user"/></xsl:variable>
			<xsl:variable name="chg_term"><xsl:value-of select="chg_term"/></xsl:variable>
			<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			<xsl:variable name="viewby_date"><xsl:value-of select="viewby_date"/></xsl:variable>
			
			<tr>
				<td class="td_leftAlign" nowrap="true">
					<strong>Period From :</strong>
				</td>
				<td class="td_leftAlign">
				<!--	<input type="text" class="input_editable" size="15" value="{$date_from}" name="Detail1.{normalize-space($dbID)}.event_date" id="Detail1.{normalize-space($dbID)}.event_date" maxlength="8"  ISCHANGED="false" onblur="checkDate(this)"/> ( DD/MM/YY )-->
                                        <input type="text" class="input_editable" size="15" value="{$date_from}" name="Detail1.{normalize-space($dbID)}.date_from" id="Detail1.{normalize-space($dbID)}.date_from" maxlength="8"  ISCHANGED="false" /> ( DD/MM/YY )
					<img src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" onClick="selectedObj = 'Detail1.{normalize-space($dbID)}.date_from'; javascript:show_calendar('Detail1.{normalize-space($dbID)}.date_from','','','DD/MM/YY');"/>
				</td>
				<td class="td_leftAlign" nowrap="true">
					<strong>Period To :</strong>
				</td>
				<td class="td_leftAlign">
                    <input type="text" class="input_editable" size="15" value="{$date_to}" name="Detail1.{normalize-space($dbID)}.date_to" id="Detail1.{normalize-space($dbID)}.date_to" maxlength="8"  ISCHANGED="false" /> ( DD/MM/YY )
					<img src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" onClick="selectedObj = 'Detail1.{normalize-space($dbID)}.date_to'; javascript:show_calendar('Detail1.{normalize-space($dbID)}.date_to','','','DD/MM/YY');"/>
				</td>
			</tr>
			
			<tr>
				<td class="td_leftAlign" nowrap="true">
					<strong>Site Code From :</strong>
				</td>
				<td class="td_leftAlign">
					<input type="text" class="input_editable" size="15" value="{$site_code__from}" name="Detail1.{normalize-space($dbID)}.site_code__from" id="Detail1.{normalize-space($dbID)}.site_code__from" maxlength="05" ISCHANGED="false"/>
					<a href="javascript:callActivityTypeJSP( '{normalize-space($dbID)}','{normalize-space($site_code__from)}' );"> <img src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" border="0"/> </a>
				</td>
				
				<td class="td_leftAlign" nowrap="true">
					<strong>Site Code To :</strong>
				</td>
				<td class="td_leftAlign">
					<input type="text" class="input_editable" size="15" value="{$site_code__to}" name="Detail1.{normalize-space($dbID)}.site_code__to" id="Detail1.{normalize-space($dbID)}.site_code__to" maxlength="05" ISCHANGED="false"/>
					<a href="javascript:callActivityTypeJSP( '{normalize-space($dbID)}','{normalize-space($site_code__to)}' );"> <img src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" border="0"/> </a>
				</td>
				
				
				<td class="hide">
				<!--  
					<input type="text" class="input_editable" size="15" value="{$chg_user}" name="Detail1.{normalize-space($dbID)}.chg_user" id="Detail1.{normalize-space($dbID)}.chg_user" maxlength="05" ISCHANGED="false"/>
				-->	
				<input type="text" class="input_editable" size="15" value="{$chg_user}" name="Detail1.{normalize-space($dbID)}.chg_user" id="Detail1.{normalize-space($dbID)}.chg_user" maxlength="10" ISCHANGED="false"/>
				</td>
				<td class="hide">
				<!--
					<input type="text" class="input_editable" size="15" value="{$chg_term}" name="Detail1.{normalize-space($dbID)}.chg_term" id="Detail1.{normalize-space($dbID)}.chg_term" maxlength="05" ISCHANGED="false"/>
				-->
				<input type="text" class="input_editable" size="15" value="{$chg_term}" name="Detail1.{normalize-space($dbID)}.chg_term" id="Detail1.{normalize-space($dbID)}.chg_term" maxlength="10" ISCHANGED="false"/>
				</td>
			</tr>
		
			<tr>
				<td class="td_rightAlign" nowrap="true" colspan="2">
				<strong>View By:</strong>
				</td>
				<td class="td_leftAlign" colspan="2">
				<!--<span style="background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt"> -->
				<select name="Detail1.{normalize-space($dbID)}.viewby_date"
					id="Detail1.{normalize-space($dbID)}.viewby_date" class="input_editable"
					value="{$viewby_date}" onChange="javascript:OnSelectionChange(this)">
					<option value="order_date">Order Date</option>
					<option value="due_date">Due Date</option>
					<option value="both">Both</option>
				</select>
				<!--</span> -->
				</td>
			</tr>
			
			<tr>
			<td class="td_leftAlign">
				<div id = "teamCodes{normalize-space($dbID)}" name="teamCodes{normalize-space($dbID)}" style="display:none"><span id = "teamSpanCodes{normalize-space($dbID)}" ><font  face="Verdana">
				<xsl:choose>
				<xsl:when test="//Detail6[. != '']">
					<xsl:for-each select="//Detail6">
						<xsl:variable name="strg_code"><xsl:value-of select="strg_code"/></xsl:variable>
						<xsl:variable name="Detail6_sales_pers"><xsl:value-of select="sales_pers"/></xsl:variable>
						<xsl:variable name="Detail6_line_no"><xsl:value-of select="line_no"/></xsl:variable>
						<xsl:variable name="Detail6_strg_code"><xsl:value-of select="strg_code"/></xsl:variable>
						<xsl:variable name="Detail6_role_code"><xsl:value-of select="role_code"/></xsl:variable>
						<xsl:variable name="Detail6_design_code"><xsl:value-of select="design_code"/></xsl:variable>
						<xsl:variable name="Detail6_dbID"><xsl:value-of select="$dbID"/></xsl:variable>
						<xsl:choose>
							<xsl:when test="$strg_code = $Detail6_strg_code">
								<INPUT TYPE="hidden" name="Detail6.{normalize-space($strg_code)}{normalize-space($Detail6_line_no)}.sales_pers" id="Detail6.{normalize-space($strg_code)}{normalize-space($Detail6_line_no)}.sales_pers" value="{$Detail6_sales_pers}"/>
								<INPUT TYPE="hidden" name="Detail6.{normalize-space($strg_code)}{normalize-space($Detail6_line_no)}.line_no" id="Detail6.{normalize-space($strg_code)}{normalize-space($Detail6_line_no)}.line_no" value="{$Detail6_line_no}"/>
								<INPUT TYPE="hidden" name="Detail6.{normalize-space($strg_code)}{normalize-space($Detail6_line_no)}.role_code" id="Detail6.{normalize-space($strg_code)}{normalize-space($Detail6_line_no)}.role_code" value="{$Detail6_role_code}"/>
								<INPUT TYPE="hidden" name="Detail6.{normalize-space($strg_code)}{normalize-space($Detail6_line_no)}.design_code" id="Detail6.{normalize-space($strg_code)}{normalize-space($Detail6_line_no)}.design_code" value="{$Detail6_design_code}"/>
								<INPUT TYPE="hidden" name="Detail6.{normalize-space($strg_code)}{normalize-space($Detail6_line_no)}.strg_code" id="Detail6.{normalize-space($strg_code)}{normalize-space($Detail6_line_no)}.strg_code" value="{$Detail6_strg_code}"/>
								<xsl:value-of select="name"/>[<xsl:value-of select="designation"/> - 
								<xsl:value-of select="sales_pers"/>]
								<br/>
							</xsl:when>
						<xsl:otherwise>
							
						</xsl:otherwise>
						</xsl:choose>
							
					</xsl:for-each>
				</xsl:when>
					<xsl:otherwise>
					</xsl:otherwise>
				</xsl:choose>			
				</font></span></div>
			</td>
			</tr>
		</xsl:for-each>
		<tr>
		<td colspan="2">
			<input  type="hidden" value="1" name="FORM_NO" ID="FORM_NO" />
			<input  type="hidden"  value="mrp_run_wiz" name="OBJ_NAME" />
			<input  type="hidden"  value="" name="action" id="action" />
			
			<!---Added By Shahu Mali -->
			<input type="submit" style="cursor:hand" value="Finish" name = "ActFinish" id = "ActFinish" title='' onclick="return setActionVal('finish')"/> 
<!--			<input type="submit" style="cursor:hand"  value="Next" name = "ActNext" id = "ActNext" title=''  onclick="javascript:setActionVal('next')"/> commented by Shahu mali on 10-01-13-->
                        <input type="submit" style="cursor:hand"  value="Next" name = "ActNext" id = "ActNext" title=''  onclick="return setActionVal('next')"/>  
		</td>
               </tr>
	</table>
	<table id="errorActivityTable" class="tableClass" border="0" cellSpacing="2" cellPadding="1">
			
			<xsl:for-each select="//error">
			    			    
				<xsl:if test="position() = 1">
					<tr>	
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Message :
						</td>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Description :
						</td>
					</tr>
				</xsl:if>
				<xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
				<xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
				<xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
				<tr>
					<td class="td_leftAlign" nowrap="true">
						<xsl:value-of select="message"/>
					</td>
					<td class="td_leftAlign" nowrap="true">
						<xsl:value-of select="description"/>
					</td>
				</tr>
			</xsl:for-each>
			<xsl:for-each select="//error">
				<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
				<xsl:if test="position() = 1">
					<xsl:if test="$type = 'W'">
					<tr>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Override Warnings :
						</td>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							<input  type="checkbox"  name="forceSave"  value="false" onClick="setChecked(this)"/>
						</td>
					</tr>
					</xsl:if>
				</xsl:if>	
			</xsl:for-each>
			
	</table>
</form>
</body>

</html>
</xsl:template>
</xsl:stylesheet>