package ibase.webitm.util.gst;

import java.io.IOException;
import java.text.SimpleDateFormat;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.CDNDetails;
import ibase.webitm.bean.gst.CDNRA;

public class CDNRASerializer extends JsonSerializer<CDNRA>
{
	final SimpleDateFormat gstFmt = new SimpleDateFormat("dd-MM-yyyy");
	@Override
	public void serialize(CDNRA cdnra, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
	{
		json.writeStartObject();
		json.writeStringField("ctin", cdnra.ctin);
		
		json.writeFieldName("nt");
        json.writeStartArray();

        for(CDNDetails cdnDetails : cdnra.cdnDetails)
        {
        	writeCDNDetails(cdnra, json, cdnDetails);
        }
        
        json.writeEndArray();
        
        json.writeEndObject();
	}
	
	private void writeCDNDetails(CDNRA cdnra, JsonGenerator json, CDNDetails cdnDetails)
	{
		try
		{
			json.writeStartObject();
			
			json.writeStringField("ntty", cdnDetails.cdnNoteType);
			json.writeStringField("nt_num", cdnDetails.cdNoteNumber);
			json.writeStringField("nt_dt", gstFmt.format(cdnDetails.cdNoteDate));
			
			json.writeStringField("inum", cdnDetails.invoiceNumber);
			json.writeStringField("idt", gstFmt.format(cdnDetails.invoiceDate));
			
			json.writeNumberField("val", cdnDetails.val);

			json.writeEndObject();
		}
		catch(Exception e)
		{
			System.out.println("CDNRASerializer.writecdnDetails()["+e.getMessage()+"]");
			e.printStackTrace();
		}
	}

}
