package ibase.dashboard.ssc.ejb;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;

/**
 * Session Bean implementation class CustomerInfoEJB
 */
@Stateless
public class PendingPurcOrder extends ValidatorEJB implements PendingPurcOrderRemote, PendingPurcOrderLocal {

    /**
     * Default constructor. 
     */
    public PendingPurcOrder() {
        
    }
    GenericUtility genericUtility = GenericUtility.getInstance();
    SimpleDateFormat gridDateFormat=null;
	SimpleDateFormat convrtToTimStmDate=null;
    
	/*Last*/
	@SuppressWarnings("unchecked")
    public JSONObject getPendingPO(String loginCode, String dataSourceName) throws RemoteException, ITMException
    {
		JSONObject rawDataPaymentDet = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		try
		{
			
			if(loginCode!=null && loginCode.trim().length()>0)
			{
		 
			gridDateFormat     = new SimpleDateFormat( genericUtility.getApplDateFormat());
			convrtToTimStmDate = new SimpleDateFormat(genericUtility.getDBDateFormat());			
			System.out.println(" Inside PendingPurcOrder for getPendingPO Method Data Soruc Name ="+dataSourceName+" loginCode comming from seesion  =" + loginCode);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;			
			
			sql = " select m.tran_id,m.tran_date, m.net_amt,m.ref_no,m. bank_code,b.bank_name  " +
				  "from misc_payment m inner join bank b on m.bank_code=b.bank_code " +
				  " where  Rownum <= 5 and m.sundry_type = 'S'and m.net_amt>0 " +
				  " and m.sundry_code in (select entity_code  from entity_contact where entity_type = 'S' " +
				  " and User_id__portal  = '"+loginCode+"' ) "+
				  " and tran_date >= (select fr_date from acctprd where to_date(sysdate) " +
				  " between fr_date and to_date) and confirmed = 'Y'order by tran_date desc ";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("tran_id",   checkNull(rs.getString("tran_id")));
				String tranDate          =checkNull(rs.getString("tran_date"));
				if(tranDate.trim().length()>0)
				{
					rowData.put("tran_date", gridDateFormat.format((convrtToTimStmDate.parse(tranDate))));
				}
				else
				{							
					rowData.put("tran_date",checkNull(rs.getString("tran_date")));
				}	
				rowData.put("net_amt", checkNull(rs.getString("net_amt")));
				rowData.put("cheque_no",checkNull (rs.getString("ref_no")));
				rowData.put("bank_code", checkNull(rs.getString("bank_name")));	
				rawDataPaymentDet.put(count, rowData);
				count++;
			}
		  }
		}		
			
			
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :PendingPurcOrder for getPendingPurcOrder Method :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataPaymentDet;
		
	}
    
    @SuppressWarnings("unchecked")
	public JSONObject getPendingPOValue(String loginCode, String dataSourceName) throws RemoteException, ITMException
    {

		JSONObject rawDataPOValueDet = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();		
		try
		{
			
			System.out.println(" Inside PendingPurcOrderEJB for getPOValueData Method Data Soruc Name ="+dataSourceName+" logincode comming from session =" + loginCode);
			
			if(loginCode!=null && loginCode.trim().length()>0)
			{
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			sql = " select  to_char(ORD_DATE, 'MON-YY') as month, sum(tot_amt) as povalue,to_char(ORD_DATE,'MMYY'),count(1) as no_of_po "+
                  " from porder where ORD_DATE >= (SELECT ADD_MONTHS(SYSDATE,-5) FROM DUAL  ) "+
                  " and case when confirmed is null then 'N' else confirmed end = 'Y' "+
                  " and case when status is null then 'O' else status end <> 'X' "+
                  " and supp_code in (select entity_code from entity_contact where entity_type = 'S' " +
                  " and User_id__portal  ='"+loginCode+"')"+
                  " group by to_char(ORD_DATE, 'MON-YY') ,to_char(ORD_DATE,'MMYY') "+
                  " order by to_char(ORD_DATE,'MMYY') asc ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("month", (rs.getString("month")));
				rowData.put("povalue", (rs.getString("povalue")));	
				rowData.put("no_of_po", (rs.getString("no_of_po")));
				rawDataPOValueDet.put(count, rowData);
				count++;
			}
		  }
		}		
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :PendingPurcOrder for getPendingPOValue Method :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataPOValueDet;
    }
    
    @SuppressWarnings("unchecked")
  	public JSONObject getPendingInvoice(String loginCode,String fromDate,String toDate, String dataSourceName) throws RemoteException, ITMException
      {

  		JSONObject rawDataPendingInvoice = new JSONObject();
  		JSONObject rowData = null;
  		String sql = "";
  		ResultSet rs = null;
  		PreparedStatement pstmt = null;
  		Connection conn = null;
  		ConnDriver connDriver = new ConnDriver();
  		Calendar calendar=null;
  		String currentDate="";
  		String varValue="";
  		String[] lotNoList=null;
  		try
  		{
  			
  			System.out.println(" Inside PendingPurcOrder for getPendingInvoice Method Data Soruc Name ="+dataSourceName+" logincode is =" + loginCode+"fromDate==="+fromDate+"ToDate==="+toDate);
  			if(loginCode!=null && loginCode.trim().length()>0)
			{
  			conn = connDriver.getConnectDB(dataSourceName);
  			connDriver = null;	
  		    // This is old sql for pending invoice detail.Changes by Birendra Pandey on dated :13/10/2015
  			sql ="select var_value from disparm where prd_code = '999999' and var_name = 'BILL_STATUS_REAS'";
  			pstmt = conn.prepareStatement(sql);
			rs   = pstmt.executeQuery();
					
			if (rs.next())
			{
				varValue = rs.getString("var_value");	 
			}
			System.out.println(" Inside PendingPurcOrder for getPendingInvoice Method Data var_value ="+varValue);
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					 String lotNoIssueTemp = "";
	                    if (varValue != null && varValue.trim().length() > 0)
	                    {
	                        lotNoList = varValue.split(",");
	                        varValue = "";
	                        for(int ctr = 0;ctr < lotNoList.length;ctr++)
	                        {
	                            lotNoIssueTemp = lotNoList[ctr];
	                            if (varValue.trim().length() > 0)
	                            {
	                            	varValue    = varValue + ",'".concat(lotNoIssueTemp).concat("'");
	                            }
	                            else
	                            {
	                            	varValue    = varValue + "'".concat(lotNoIssueTemp).concat("'");
	                            }

	                        }
	                    }

	          System.out.println("varValue after ["+varValue + "]");
	          if (varValue=="" || varValue==null)
	          {
	        	  varValue ="'Y'";
	          }
			
  			//SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
  			 if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
  		        {
  		         				
  				SimpleDateFormat simpleDateFormat   = new SimpleDateFormat( genericUtility.getApplDateFormat());
  	  			calendar                            = Calendar.getInstance();
  	  		   	currentDate                        = simpleDateFormat.format(calendar.getTime());
  	  			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
  	  			toDate          = simpleDateFormat.format(calendar.getTime());	
  	  			
  	  			calendar       = Calendar.getInstance();
  	  			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
  	  			fromDate        = simpleDateFormat.format(calendar.getTime());
  	  			System.out.println("get default date ,when user not entering date from GUI:"+"currentDate="+currentDate+"fromDate="+fromDate+"toDate="+toDate);
  	  			
  			}  	 				
  			  			  			 
  			 sql =  "SELECT SB.SUPP_CODE , S.SUPP_NAME , SUM(CASE WHEN SB.REAS_CODES IN ("+varValue+") " +
  			 		"THEN 1 ELSE 0 END ) AS HARD_COPY_NOT_RECD, " +
  			 		"SUM(CASE WHEN SB.STATUS !='Y' And SB.Voucher_No Is Null And SB.Reas_Codes Is Null Then 1 else 0 end) as In_Process, " +
  			 		"SUM( case when (select count(1) FROM MISC_PAYDET WHERE TRAN_SER in ('VOUCH','P-IBCA','P-IBC1','P-IBC2','P-IBC3') AND VOUCH_NO = SB.VOUCHER_NO ) = 0 THEN 1 ELSE 0  END  ) AS COMPLETE " +
  			 		"FROM SUPPLIER_BILL SB INNER JOIN SUPPLIER S ON S.SUPP_CODE = SB.SUPP_CODE " +
  			 		"WHERE TO_CHAR(SB.TRAN_DATE,'DD/MM/YY') >= '"+fromDate+"' " +
  			 		"AND   TO_CHAR(SB.TRAN_DATE,'DD/MM/YY') <= '"+toDate+"' " +
  			 		"AND   SB.SUPP_CODE IN (SELECT ENTITY_CODE FROM ENTITY_CONTACT WHERE ENTITY_TYPE = 'S' " +
  			 		"AND USER_ID__PORTAL  = '"+loginCode+"') " +
  			 		"GROUP BY SB.SUPP_CODE,S.SUPP_NAME   ORDER BY  S.SUPP_NAME ";
  			
  					
			pstmt = conn.prepareStatement(sql);
			rs   = pstmt.executeQuery();
			int count = 0;			
			while (rs.next())
			{
				  rowData = new JSONObject();				
				  rowData.put("supplier_code",      checkNull (rs.getString("SUPP_CODE"))); 
				  rowData.put("supplier_name",      checkNull (rs.getString("SUPP_NAME")));
				  rowData.put("hard_copy_not_recd", checkNull (rs.getString("HARD_COPY_NOT_RECD"))); 
				  rowData.put("in_process",         checkNull (rs.getString("In_Process")));
				  rowData.put("complete",           checkNull (rs.getString("COMPLETE")));				
				  rawDataPendingInvoice.put(count, rowData);
				 count++;
			 }
			  
  		   }
  		}		
  		catch (Exception e)
  		{
  			e.printStackTrace();
  			throw new ITMException(e);
  		}
  		finally
  		{
  			try
  			{
  				if (conn != null)
  				{
  					if (rs != null)
  					rs.close();
  					rs = null;
  					if (pstmt != null)
  					pstmt.close();
  					pstmt = null;
  					conn.close();
  					conn = null;
  				}
  				conn = null;
  			} catch (Exception d)
  			{
  				d.printStackTrace();
  				System.out.println("Exception in :PendingPurcOrder for getPendingInvoice Method :" + d.getMessage());
  				throw new ITMException(d);
  			}
  		}
  		return rawDataPendingInvoice;
      }
    //POOrderSummary Method
    @SuppressWarnings("unchecked")
    public JSONObject getPendingPOSummary(String loginCode, String dataSourceName) throws RemoteException, ITMException
    {
	JSONObject rawDataPaymentDet = new JSONObject();
	JSONObject rowData = null;
	String sql = "";
	ResultSet rs = null;
	PreparedStatement pstmt = null;
	Connection conn = null;
	ConnDriver connDriver = new ConnDriver();
	//String processOrder="",completed="",open="";
	try
	{
		 gridDateFormat     = new SimpleDateFormat( genericUtility.getApplDateFormat());
		 convrtToTimStmDate = new SimpleDateFormat(genericUtility.getDBDateFormat());
		 if(loginCode!=null && loginCode.trim().length()>0)
			{
		System.out.println(" Inside PendingPurcOrder for getPendingPOSummary Method Data Soruc Name ="+dataSourceName+" loginCode is =" + loginCode);
		conn = connDriver.getConnectDB(dataSourceName);
		connDriver = null;	
		/*to get P Order summary data */
		sql = " select  sum(tot_amt) as process_orders,count(1) as no_of_po "
				+" from porder where ORD_DATE >= (SELECT ADD_MONTHS(SYSDATE,-5) FROM DUAL ) "
				+" and case when confirmed is null then 'N' else confirmed end = 'N' "
				+" and case when status is null then 'O' else status end not in ('X','C') "
				+" and supp_code in (select entity_code from entity_contact where entity_type = 'S' " 
				+" and User_id__portal  = '"+loginCode+"') ";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;			
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("status", "In Process ");
				rowData.put("process_orders",checkDoubleNull(rs.getString("process_orders")));
				rowData.put("no_of_po", rs.getString("no_of_po"));
				rawDataPaymentDet.put(count, rowData);
				count++;
			}
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			sql = " select  sum(tot_amt) as completed,count(1) as no_of_po  "
					+" from porder where ORD_DATE >= (SELECT ADD_MONTHS(SYSDATE,-5) FROM DUAL ) "
					+" and case when confirmed is null then 'N' else confirmed end = 'Y' "
					+" and case when status is null then 'O' else status end = 'C' "
					+" and supp_code in (select entity_code from entity_contact where entity_type = 'S' " 
					+"and User_id__portal  = '"+loginCode+"') ";
				
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					rowData = new JSONObject();
					rowData.put("status", "Completed");
					rowData.put("process_orders", checkDoubleNull(rs.getString("completed")));
					rowData.put("no_of_po", rs.getString("no_of_po"));
					rawDataPaymentDet.put(count, rowData);
					count++;
				}
				pstmt.close();
				pstmt = null;
				rs.close();
				rs = null;
				sql = "  select  sum(tot_amt) as open,count(1) as no_of_po  "
						+" from porder where ORD_DATE >= (SELECT ADD_MONTHS(SYSDATE,-5) FROM DUAL ) "
						+" and case when confirmed is null then 'N' else confirmed end = 'Y' "
						+" and case when status is null then 'O' else status end not in ('X','C') "
					    +" and supp_code in (select entity_code from entity_contact where entity_type = 'S'"
					    +" and User_id__portal  = '"+loginCode+"' ) ";
						
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					while (rs.next())
					{
						rowData = new JSONObject();
						rowData.put("status", "Open");
						rowData.put("process_orders",checkDoubleNull(rs.getString("open")));
						rowData.put("no_of_po", rs.getString("no_of_po"));
						rawDataPaymentDet.put(count, rowData);
						count++;
					}
			}//close if block
	}//close try block
	catch (Exception e)
	{
		e.printStackTrace();
		throw new ITMException(e);
	}
	finally
	{
		try
		{
			if (conn != null)
			{
				if (rs != null)
				rs.close();
				rs = null;
				if (pstmt != null)
				pstmt.close();
				pstmt = null;
				conn.close();
				conn = null;
			}
			conn = null;
		} catch (Exception d)
		{
			d.printStackTrace();
			System.out.println("Exception in :PendingPurcOrder for getPendingPOSummary Method :" + d.getMessage());
			throw new ITMException(d);
		}
	}
	return rawDataPaymentDet;
    }
	

   //check null functionallity for required component
    private double checkDoubleNull(String str)
	{
		if(str == null || str.trim().length() == 0 || str.trim().equalsIgnoreCase("null"))
		{
			return 0.0;
		}
		else
		{
			return Math.round(Double.parseDouble(str)* Math.pow(10, 2)) / Math.pow(10, 2); 
		}
	}

    private String checkNull(String str)
	{
		if(str == null || str.trim().equalsIgnoreCase("null"))
		{
			return "";
		}
		else
		{
			return str.trim() ;
		}

	}
    
}
