INSERT INTO ITM2MENU (application ,level_1 ,level_2 ,level_3 ,level_4 ,level_5 ,win_name ,descr ,comments ,menu_path ,icon_path ,obj_type ,mob_deploy ,chg_user ,chg_term ,open_icon ,close_icon ,chg_date ) 
VALUES ('SCG',3,9,0,0,0,'w_gstdata_prc','Populate GST Data','Populate GST Data','SCG.3.9.0.0.0','','P','','BASE','BASE',NULL,NULL,sysdate);

INSERT into OBJ_FORMS(win_name,title,form_no,scr_flag) values('w_gstdata_prc','populate data','1','F');

INSERT into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME) values ('gstdata_prc','1','itm_default');

INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,RIGHTS_CHAR,INTERACTIVE,SERVICE_CODE,DESCRIPTION,TITLE,IMAGE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE)
VALUES ('gstdata_prc',1,'P','a','a','Action Button for processing the data','Process','','2','3','','U');

-----------------------------------------------------------------------------------------------------------------------------------------------------

INSERT into SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,COMP_TYPE,COMP_NAME,COMM_FORMAT) 
values ('gstdata_prc','post_item_change','1','poic_gstdata_prc',null,sysdate,'BASE','BASE','2','0','EJB','GstDataIC',null);


INSERT into SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,COMP_TYPE,COMP_NAME,COMM_FORMAT) 
values ('gstdata_prc','pre_validate','1','prv_default_ejb',null,sysdate,'BASE','BASE','2','0','EJB','GstDataIC',null);


INSERT into SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,OVERWRITE_CORE,COMP_TYPE,COMP_NAME,COMM_FORMAT) 
values ('gstdata_prc','process','1','pr_gstdata',null,sysdate,'BASE','BASE','2','0','EJB','GstDataIC',null);

----------------------------------------------------------------------------------------------------------------------------------------------------

INSERT into SYSTEM_EVENT_SERVICES (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) 
values ('poic_gstdata_prc','gstdata_prc','http://localhost:9090/axis/services/ValidatorService','base','itemChanged','String','S',null,null,sysdate,'BASE','BASE');

INSERT into SYSTEM_EVENT_SERVICES (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) 
values ('pr_gstdata','process','http://localhost:9090/axis/services/ValidatorService','base','process','String','S',null,null,sysdate,'BASE','BASE');

----------------------------------------------------------------------------------------------------------------------------------------------------

INSERT into SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_gstdata_prc',1,'COMPONENT_TYPE','I',null,'S',null,sysdate,'BASE  ','BASE','EJB');
INSERT into SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_gstdata_prc',2,'COMPONENT_NAME','I',null,'S',null,sysdate,'BASE ','BASE','GstDataIC');
INSERT into SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_gstdata_prc',3,'XML_DATA','I',null,'S',null,sysdate,'BASE ','BASE',null);
INSERT into SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_gstdata_prc',4,'XML_DATA_1','I',null,'S',null,sysdate,'BASE  ','BASE',null);
INSERT into SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_gstdata_prc',5,'XML_DATA_ALL','I',null,'S',null,sysdate,'BASE  ','BASE',null);
INSERT into SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_gstdata_prc',6,'OBJ_CONTEXT','I',null,'S',null,sysdate,'BASE  ','BASE ',null);
INSERT into SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_gstdata_prc',7,'FOCUSED_COLUMN','I',null,'S',null,sysdate,'BASE  ','BASE',null);
INSERT into SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_gstdata_prc',8,'EDIT_FLAG','I',null,'S',null,sysdate,'BASE  ','BASE',null);
INSERT into SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_gstdata_prc',9,'XTRA_PARAMS','I',null,'S',null,sysdate,'BASE  ','BASE ',null);


INSERT into SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('pr_gstdata',1,'COMPONENT_TYPE','l','COMPONENT_TYPE','C.String',null,sysdate,'BASE  ','BASE','EJB');
INSERT into SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('pr_gstdata',2,'COMPONENT_NAME','l','Component Name','C.String',null,sysdate,'BASE ','BASE','GstDataPrc');
INSERT into SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('pr_gstdata',3,'XML_DATA_1','l','XML data of form no 1','S',null,sysdate,'BASE ','BASE',null);
INSERT into SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('pr_gstdata',4,'XML_DATA__ALL','l','XML data of form all','S',null,sysdate,'BASE  ','BASE',null);
INSERT into SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('pr_gstdata',5,'OBJ_CONTEXT','l','Object Context','S',null,sysdate,'BASE  ','BASE',null);
INSERT into SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('pr_gstdata',6,'XTRA_PARAMS','l','Extra Arguments','S',null,sysdate,'BASE  ','BASE ',null);

----------------------------------------------------------------------------------------------------------------------------------------------------
DROP TABLE GST_DATA_HDR;

CREATE TABLE GST_DATA_HDR
  (
    TRAN_ID         CHAR(12) NOT NULL,
    TRAN_DATE       DATE,
    TRAN_ID__REF    CHAR(12),
    SITE_CODE       CHAR(5),
    PRD_CODE        CHAR(6),
    REC_TYPE        CHAR(1),
    TRAN_TYPE       CHAR(2),
    CUST_CODE       CHAR(10),
    CUST_NAME       VARCHAR2(90),
    SUBMISSION_TYPE CHAR(1),
    DOC_CHECKSUM    VARCHAR2(100),
    DOC_TYPE        CHAR(5),
    DOC_NO          VARCHAR2(50),
    DOC_DATE        DATE,
    AMOUNT          NUMBER(15,2),
    REVERSE_CHRG    CHAR(1),
    LR_NO           VARCHAR2(50),
    LR_DATE         DATE,
    REAS_CODE       CHAR(5),
    REF_ID__INV     VARCHAR2(50),
    REF_DATE__INV   DATE,
    PROV_ASSMNT     CHAR(1),
    ORDER_NO        VARCHAR2(30),
    ORDER_DATE      DATE,
    REMARKS         VARCHAR2(100),
    SUBMIT_STATUS   CHAR(1),
    SUBMIT_DATE     DATE,
    ADD_USER        CHAR(10),
    ADD_DATE        DATE,
    ADD_TERM        VARCHAR2(15),
    CHG_USER        CHAR(10),
    CHG_DATE        DATE,
    CHG_TERM        VARCHAR2(15),
    TAX_REG_NO      VARCHAR2(15),
    RECO_STATUS     VARCHAR2(1),
    ECOM_REG_NO     VARCHAR2(15),
    REF_SER         CHAR(6),
    GST_CODE        CHAR(2),
    GST_TYPE        CHAR(1),
    REF_ID          CHAR(10)
  ) tablespace ITM_data;

   ALTER TABLE GST_DATA_HDR ADD CONSTRAINT GST_DATA_HDR_X PRIMARY KEY (TRAN_ID) USING INDEX TABLESPACE ITM_index;
   CREATE INDEX IDX_REF_ID ON GST_DATA_HDR ( REF_ID,REF_SER ) ;

   DROP TABLE GST_DATA_DET;
   
   CREATE TABLE GST_DATA_DET
  (
    TRAN_ID     CHAR(12) NOT NULL,
    LINE_NO     NUMBER(3,0) NOT NULL,
    STATUS      CHAR(1),
    SR_NO__OLD  NUMBER(3,0),
    LINE_TYPE   CHAR(1),
    GS_CODE     VARCHAR2(10),
    TAXABLE_AMT NUMBER(15,2),
    IGST_PERC   NUMBER(5,2),
    IGST_AMT    NUMBER(15,2),
    CGST_PERC   NUMBER(5,2),
    CGST_AMT    NUMBER(15,2),
    SGST_PERC   NUMBER(5,2),
    SGST_AMT    NUMBER(15,2),
    GS_DESCR    VARCHAR2(30),
    UNIT        VARCHAR2(30),
    QUANTITY    NUMBER(15,3),
    SUPPLY_TYPE CHAR(2),
    CESS_PERC   NUMBER(15,2),
    CESS_AMT    NUMBER(15,2),
    REMARKS     VARCHAR2(10),
    ITC_TYPE    CHAR(2),
    ITC_IGST    NUMBER(15,3),
    ITC_CGST    NUMBER(15,3),
    ITC_SGST    NUMBER(15,3),
    ITC_CESS    NUMBER(15,3),
    GST_RATE    NUMBER(5,2) 
  ) tablespace ITM_data;

 ALTER TABLE GST_DATA_DET ADD CONSTRAINT GST_DATA_DET_X PRIMARY KEY (TRAN_ID, LINE_NO) USING INDEX TABLESPACE ITM_index;
 ALTER TABLE GST_DATA_DET ADD CONSTRAINT FK_GST_DATA_DET FOREIGN KEY (TRAN_ID) REFERENCES GST_DATA_HDR (TRAN_ID) ON DELETE CASCADE ENABLE;  
  
 
INSERT INTO transetup (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,
REF_SER,VIEW_MODE,AUDIT_TRAIL_OPT,PERIOD_OPTION,TRAN_ID_COL,APPLICATION,TABLE_NAME)
VALUES ('w_gstr','2','2', 'A', 'site_code,month,_seq05', sysdate,'BASE','BASE','0','R_GST','F','','M','tran_id','','gst_data_hdr');

INSERT INTO REFSER (REF_SER,DESCR,TYPE,SYS_SER,PREFIX,CHG_DATE,CHG_USER,CHG_TERM,SEQ_NAME,TAX_FORM_REQD,TRANS_TYPE,SKILL_CODE) VALUES 
('R_GST','Seq. to generate tran id for GST Tran Id','S',NULL,NULL,SYSDATE,'BASE','BASE','GST_TRAN_ID_SEQ',NULL,NULL,NULL);

CREATE SEQUENCE GST_TRAN_ID_SEQ
MINVALUE 1
MAXVALUE 999999999999999
START WITH     100
INCREMENT BY   1
CACHE  20
NOCYCLE
NOORDER;

------------------------------------------------------------------------------------------------------------------------------------------------

INSERT into FINPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,CHG_DATE,CHG_USER,CHG_TERM,DESCR,VAR_SUBS,ADDL_VALUE) 
values ('999999','GST_B2CL_INV_VAL','S',250000,SYSDATE,'BASE','BASE','Gst B2CL Target Invoice value',null,null);

Insert into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','GST_EXPWP_TAXCLASS','S','','EXP Exports with payment Tax Class',0,SYSDATE,'BASE','BASE');

Insert into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','GST_EXPWOP_TAXCLASS','S','','EXP Exports without payment Tax Class',0,SYSDATE,'BASE','BASE');

Insert into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','GST_SEZWP_TAXCLASS','S','','B2B Export to SEZ with payment Tax Class',0,SYSDATE,'BASE','BASE');

Insert into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','GST_SEZWOP_TAXCLASS','S','','B2B Export to SEZ without payment Tax Class',0,SYSDATE,'BASE','BASE');

Insert into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','GST_DE_TAXCLASS','S','','B2B Deemed Exports Tax Class',0,SYSDATE,'BASE','BASE');

Insert into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','GST_NIL_TAXCLASS','S','','Inter-State NIL rated supplies Tax Class',0,SYSDATE,'BASE','BASE');

Insert into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','GST_EXE_TAXCLASS','S','','Export supplies Tax Class',0,SYSDATE,'BASE','BASE');

Insert into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','GST_EXPWP_TAXENV','S','','EXP Exports with payment Tax Environment',0,SYSDATE,'BASE','BASE');

Insert into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','GST_EXPWOP_TAXENV','S','','EXP Exports without payment Tax Environment',0,SYSDATE,'BASE','BASE');

Insert into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','GST_SEZWP_TAXENV','S','','B2B Export to SEZ with payment Tax Environment',0,SYSDATE,'BASE','BASE');

Insert into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','GST_SEZWOP_TAXENV','S','','B2B Export to SEZ without payment Tax Environment',0,SYSDATE,'BASE','BASE');

Insert into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','GST_DE_TAXENV','S','','B2B Deemed Exports Tax Environment',0,SYSDATE,'BASE','BASE');

Insert into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','GST_NIL_TAXENV','S','','Inter-State NIL rated supplies Tax Environment',0,SYSDATE,'BASE','BASE');

Insert into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','GST_EXE_TAXENV','S','','Export supplies Tax Environment',0,SYSDATE,'BASE','BASE');

-------------------------------------------------------------------------------------------------------------------------------------------------

INSERT into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
values ('VTBLNKPRD','Please enter period','Please enter period, it can not be left blank','E','Y',SYSDATE,'BASE','BASE');

INSERT into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
values ('VTPRDLEN','Invalid Period entered','Invalid period entered, please enter valid six digit period code in MMYYYY format','E','Y',SYSDATE,'BASE','BASE');

INSERT into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
values ('VTPRDMONTH','Invalid Period entered','Please check month, it should not be more than 12 or less than 1, period should be in MMYYYY format','E','Y',SYSDATE,'BASE','BASE');
  
INSERT into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
values ('VTBLNKTYPE','Please select GST Type','Please select GST Type, it can not be left blank','E','Y',SYSDATE,'BASE','BASE');

-------------------------------------------------------------------------------------------------------------------------------------------------
  
INSERT into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','GST_DATA_SYNC','S','Y','Parameter to Sync GST data Yes-Y/ No-N',0,SYSDATE,'BASE','BASE');

INSERT into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
values ('URLNTFND','URL not found','URL not found for gst data server synchronization','E','Y',SYSDATE,'BASE','BASE');

INSERT into SYSTEM_EVENT_SERVICES (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM) 
values ('GST_SYNC_SERVER_URI','URL','http://192.168.0.225:9090/ibase/rest/service/insertdata','base','actionHandler','String','S',null,null,sysdate,'BASE','BASE');


-------------------------------------------------------------------------------------------------------------------------------------------------
/*added by kaustubh*/
update system_event_services set service_uri ='http://52.221.100.13:9090/ibase/rest/service/insertdata'  where service_code ='GST_SYNC_SERVER_URI';

--------------------------------------------------------------------------------------------------------------------------------------------------


create or replace function fn_get_gst_rate(as_trancode in taxtran.tran_code%type,as_tranid in taxtran.tran_id%type, al_lineno number)
return number is
lc_gstrate number(6,2) := 0;
ls_lineno char(3);
begin

	begin
		-- get IGST rate
		select lpad(trim(to_char(al_lineno)),3, ' ') into ls_lineno from dual;
	exception when others then
		ls_lineno := ' ';
	end;

	begin
		-- get IGST rate
		select tax_perc into lc_gstrate from taxtran tt, tax tm
		where tm.tax_code = tt.tax_code
		and tm.tax_type = 'I'
		and tt.tran_code = as_trancode
		and tt.tran_id = as_tranid
		and tt.line_no = ls_lineno;
  exception when others then
	 lc_gstrate := 0;
  end;
  if lc_gstrate = 0 then
	-- if IGST rate is 0 then get sum of SGST and CGST rate
		begin
			select sum(tax_perc) into lc_gstrate from taxtran tt, tax tm
			where tm.tax_code = tt.tax_code
			and tm.tax_type in ('G','H')
			and tt.tran_code = as_trancode
			and tt.tran_id = as_tranid
			and tt.line_no = ls_lineno;
	  exception when others then
		 lc_gstrate := 0;
	  end;
	
  end if;
  return lc_gstrate;
end;
/

create or replace function fn_get_hsn_no(as_sitecode in site.site_code%type,as_itemcode in item.item_code%type)
return varchar is
ls_hsnno varchar2(20);
begin


	begin
		select hsn_no into ls_hsnno from siteitem
		where site_code = as_sitecode
		and item_code = as_itemcode;
  exception when others then
	 ls_hsnno := '';
  end;
  if ls_hsnno is null or length(trim(ls_hsnno)) = 0 then
		begin
			select hsn_no into ls_hsnno from item
			where item_code = as_itemcode;
	  exception when others then
		 ls_hsnno := '';
	  end;
	
  end if;
  return ls_hsnno;
end;
/


create or replace function fn_get_hsn_sac(as_sitecode in site.site_code%type,as_itemcode in item.item_code%type,as_acctcode in accounts.acct_code%type)
return varchar is
ls_hsnno varchar2(20);
begin

	if as_itemcode is null or length(trim(as_itemcode)) then 
	    begin
			select sac_code into ls_hsnno from accounts
			where acct_code = as_acctcode;
			
	       exception when others then
		 ls_hsnno := '';
	   end;
  
	else
	
	begin
		select hsn_no into ls_hsnno from siteitem
		where site_code = as_sitecode
		and item_code = as_itemcode;
  exception when others then
	 ls_hsnno := '';
  end;
  if ls_hsnno is null or length(trim(ls_hsnno)) = 0 then
		begin
			select hsn_no into ls_hsnno from item
			where item_code = as_itemcode;
	  exception when others then
		 ls_hsnno := '';
	  end;
	
  end if;
  end if;
  return ls_hsnno;
end;
/





create or replace function fn_gst_rate_amt(as_trancode in taxtran.tran_code%type,as_tranid in taxtran.tran_id%type, al_lineno number, as_type in char, as_rateoramt in char)
return number is
lc_rateoramt number(16,2) := 0;
ls_lineno char(3);

-- as_type  : G (sgst), H (cgst), I (igst) and J (cess)
-- as_rateoramt : R or A 
begin

	begin
		-- get IGST rate
		select lpad(trim(to_char(al_lineno)),3, ' ') into ls_lineno from dual;
	exception when others then
		ls_lineno := ' ';
	end;

	if as_rateoramt = 'T' then
		begin
			-- taxable amount
			select taxable_amt into lc_rateoramt from taxtran tt, tax tm
			where tm.tax_code = tt.tax_code
			and tm.tax_type in ('G','H','I')
			and tt.tran_code = as_trancode
			and tt.tran_id = as_tranid
			and tt.line_no = ls_lineno
			and taxable_amt <> 0
			and rownum = 1;
		exception when others then
		 lc_rateoramt := 0;
		end;
	else
		if as_rateoramt = 'R' then
			begin
				-- rate
				select tax_perc into lc_rateoramt from taxtran tt, tax tm
				where tm.tax_code = tt.tax_code
				and tm.tax_type = as_type
				and tt.tran_code = as_trancode
				and tt.tran_id = as_tranid
				and tt.line_no = ls_lineno;
			exception when others then
			 lc_rateoramt := 0;
			end;
		else
			begin
				-- rate
				select sum(tax_amt) into lc_rateoramt from taxtran tt, tax tm
				where tm.tax_code = tt.tax_code
				and tm.tax_type = as_type
				and tt.tran_code = as_trancode
				and tt.tran_id = as_tranid
				and tt.line_no = ls_lineno;
			exception when others then
			 lc_rateoramt := 0;
			end;
		end if;
	end if;
  return lc_rateoramt;
end;
/

/* added by kaustubh on 6 sep
 * 
 */



create or replace 
function fn_gst_rate_gp_amt(as_trancode in taxtran.tran_code%type,as_tranid in taxtran.tran_id%type, al_lineno number, as_type in char, as_rateoramt in char,as_taxgroup in char)
return number is
lc_rateoramt number(16,2) := 0;
ls_lineno char(3);

-- as_type  : G (sgst), H (cgst), I (igst) and J (cess)
-- as_rateoramt : R or A 
begin

	begin
		-- get IGST rate
		select lpad(trim(to_char(al_lineno)),3, ' ') into ls_lineno from dual;
	exception when others then
		ls_lineno := ' ';
	end;

	if as_rateoramt = 'T' then
		begin
			-- taxable amount
			select taxable_amt into lc_rateoramt from taxtran tt, tax tm
			where tm.tax_code = tt.tax_code
			and tm.tax_type in ('G','H','I')
			and tt.tran_code = as_trancode
			and tt.tran_id = as_tranid
			and tt.line_no = ls_lineno
			and tm.tax_group = as_taxgroup
			and taxable_amt <> 0
			and rownum = 1;
		exception when others then
		 lc_rateoramt := 0;
		end;
	else
		if as_rateoramt = 'R' then
			begin
				-- rate
				select tax_perc into lc_rateoramt from taxtran tt, tax tm
				where tm.tax_code = tt.tax_code
				and tm.tax_type = as_type
				and tt.tran_code = as_trancode
				and tt.tran_id = as_tranid
				and tm.tax_group = as_taxgroup
				and tt.line_no = ls_lineno;
			exception when others then
			 lc_rateoramt := 0;
			end;
		else
			begin
				-- rate
				select sum(tax_amt) into lc_rateoramt from taxtran tt, tax tm
				where tm.tax_code = tt.tax_code
				and tm.tax_type = as_type
				and tt.tran_code = as_trancode
				and tt.tran_id = as_tranid
				and tm.tax_group = as_taxgroup
				and tt.line_no = ls_lineno;
			exception when others then
			 lc_rateoramt := 0;
			end;
		end if;
	end if;
  return lc_rateoramt;
end;




create or replace 
function fn_get_gst_gp_rate(as_trancode in taxtran.tran_code%type,as_tranid in taxtran.tran_id%type, al_lineno number,as_taxgroup in char)
return number is
lc_gstrate number(6,2) := 0;
ls_lineno char(3);
begin

	begin
		-- get IGST rate
		select lpad(trim(to_char(al_lineno)),3, ' ') into ls_lineno from dual;
	exception when others then
		ls_lineno := ' ';
	end;

	begin
		-- get IGST rate
		select tax_perc into lc_gstrate from taxtran tt, tax tm
		where tm.tax_code = tt.tax_code
		and tm.tax_type = 'I'
		and tt.tran_code = as_trancode
		and tm.tax_group = as_taxgroup
		and tt.tran_id = as_tranid
		and tt.line_no = ls_lineno;
  exception when others then
	 lc_gstrate := 0;
  end;
  if lc_gstrate = 0 then
	-- if IGST rate is 0 then get sum of SGST and CGST rate
		begin
			select sum(tax_perc) into lc_gstrate from taxtran tt, tax tm
			where tm.tax_code = tt.tax_code
			and tm.tax_type in ('G','H')
			and tt.tran_code = as_trancode
			and tm.tax_group = as_taxgroup
			and tt.tran_id = as_tranid
			and tt.line_no = ls_lineno;
	  exception when others then
		 lc_gstrate := 0;
	  end;
	
  end if;
  return lc_gstrate;
end;


create or replace FUNCTION fn_sundry_gst_info (as_sundrytype varchar2, as_code varchar2, as_coltype varchar2) 
RETURN varchar2 AS
ls_strsql varchar2 (2000);
ls_colname varchar2(30);
ls_colval varchar2(2000);
BEGIN
	begin
		-- as_coltype   'N' - name , 'S' state_code 'G' - tax_reg_2
		IF as_sundrytype = 'S' THEN
		  IF as_coltype='N' then
			ls_colname := 'SUPP_NAME' ;
		  elsif as_coltype='S' then
			ls_colname := 'STATE_CODE' ;
		  else
			ls_colname := 'TAX_REG_2' ;
		  END if;
		   ls_strsql := 'select '||ls_colname||' from supplier Where supp_code= '''||as_code||'''' ;
		  
		elsif as_sundrytype = 'T' then
		  IF as_coltype='N' then
			ls_colname := 'TRAN_NAME' ;
		  elsif as_coltype='S' then
			ls_colname := 'STATE_CODE' ;
		  else
			ls_colname := 'TAX_REG_2' ;
		  END if;
		  ls_strsql := 'select '||ls_colname||' from transporter Where tran_code= '''||as_code||'''' ;
		else
			ls_strsql := 'select '''' from dual' ;
		end if;

		EXECUTE IMMEDIATE ls_strsql into ls_colval;
	exception when others then
		ls_colval := ' ';
	end;

	RETURN ls_colval ;
END; 
/
 
-------------------------------------------------------------------------------------------------------------
/* updated by kaustubh on 25-07-2017*/ 
--- db2 function


create  function fn_get_gst_rate(as_trancode varchar(6),as_tranid varchar(10), al_lineno decimal(3,0))
returns decimal(14,3) 
deterministic
begin atomic

	declare lc_gstrate decimal(6,2);
	declare ls_lineno char(3);

	set ls_lineno = (select right('   '|| rtrim(cast(al_lineno as char(3))),3) from dual);
	set lc_gstrate = (select tax_perc  from taxtran tt, tax tm
	where tm.tax_code = tt.tax_code
	and tm.tax_type = 'I'
	and tt.tran_code = as_trancode
	and tt.tran_id = as_tranid
	and tt.line_no = ls_lineno );
  if lc_gstrate = 0 then
	set lc_gstrate = (select sum(tax_perc) from taxtran tt, tax tm
	where tm.tax_code = tt.tax_code
	and tm.tax_type in ('G','H')
	and tt.tran_code = as_trancode
	and tt.tran_id = as_tranid
	and tt.line_no = ls_lineno);
	
  end if;
  return lc_gstrate;

end
@


drop function fn_get_hsn_no@

create  function fn_get_hsn_no(as_sitecode varchar(5),as_itemcode varchar(10))
returns varchar(20) 
deterministic
begin atomic
declare ls_hsnno varchar(20);

	set ls_hsnno = (select hsn_no  from siteitem
	where site_code = as_sitecode
	and item_code = as_itemcode);
  if ls_hsnno is null or length(trim(ls_hsnno)) = 0 then
	set ls_hsnno = (select hsn_no  from item
	where item_code = as_itemcode);
  end if;
  return ls_hsnno;

end
@


drop function fn_get_hsn_sac@

create  function fn_get_hsn_sac(as_sitecode varchar(5),as_itemcode varchar(10),as_acctcode varchar(10))
returns varchar(20) 
deterministic
begin atomic
declare ls_hsnno varchar(20);

 if as_itemcode is null or length(trim(as_itemcode)) = 0 then
	set ls_hsnno = (select sac_code  from accounts
	where acct_code = as_acctcode);

	else
	
	set ls_hsnno = (select hsn_no  from siteitem
	where site_code = as_sitecode
	and item_code = as_itemcode);
  if ls_hsnno is null or length(trim(ls_hsnno)) = 0 then
	set ls_hsnno = (select hsn_no  from item
	where item_code = as_itemcode);
  end if;
  end if;
  return ls_hsnno;

end
@


drop function fn_gst_rate_amt@

create  function fn_gst_rate_amt(as_trancode varchar(6),as_tranid varchar(10), al_lineno decimal(3,0), as_type char(1), as_rateoramt char(1))
returns decimal(14,3) 
deterministic
begin atomic
declare lc_rateoramt decimal(16,2);
declare ls_lineno char(3);

 set ls_lineno = right('   '|| rtrim(cast(al_lineno as char(3))),3);

	if as_rateoramt = 'T' then
		set lc_rateoramt = (select taxable_amt from taxtran tt, tax tm
		where tm.tax_code = tt.tax_code
		and tm.tax_type in ('G','H','I')
		and tt.tran_code = as_trancode
		and tt.tran_id = as_tranid
		and tt.line_no = ls_lineno
		and tt.taxable_amt <> 0 fetch first row only );
	else
		if as_rateoramt = 'R' then
			set lc_rateoramt = (select tax_perc from taxtran tt, tax tm
			where tm.tax_code = tt.tax_code
			and tm.tax_type = as_type
			and tt.tran_code = as_trancode
			and tt.tran_id = as_tranid
			and tt.line_no = ls_lineno);
		else
			set lc_rateoramt = (select sum(tax_amt) from taxtran tt, tax tm
			where tm.tax_code = tt.tax_code
			and tm.tax_type = as_type
			and tt.tran_code = as_trancode
			and tt.tran_id = as_tranid
			and tt.line_no = ls_lineno);
		end if;
	end if;
  return lc_rateoramt;

end
@


/*added by kaustubh on 6 sep 2017*/

CREATE FUNCTION fn_get_gst_gp_rate(as_trancode VARCHAR(6),as_tranid VARCHAR(10),al_lineno CHAR(3),as_taxgrouop  char(5))
    returns DECIMAL(6,2)
BEGIN
  ATOMIC
  DECLARE
    lc_gstrate DECIMAL(6,2);
  DECLARE
    ls_lineno CHAR(3);
  IF(
      LENGTH(
        LTRIM(
          RTRIM(
            al_lineno))) = 1) THEN
    SET ls_lineno        = concat(
      '  ',
      LTRIM(
        RTRIM(
          al_lineno)));
  END IF;
  IF (LENGTH(LTRIM(RTRIM(al_lineno))) = 2) THEN
    SET ls_lineno                     = concat(' ',LTRIM(RTRIM(al_lineno)));
  END IF;
  IF (LENGTH(LTRIM(RTRIM(al_lineno))) = 3) THEN
    SET ls_lineno                     = LTRIM(RTRIM(al_lineno));
  END IF;
  SET (lc_gstrate) =
  (
    SELECT
      COALESCE(MAX(tax_perc),0)
    FROM
      taxtran tt,
      tax tm
    WHERE
      tm.tax_code    = tt.tax_code
    AND tm.tax_type  = 'I'
    AND tt.tran_code = as_trancode
    and tm.tax_group = as_taxgrouop
    AND tt.tran_id   = as_tranid
    AND tt.line_no   = ls_lineno
  )
  ;
  IF lc_gstrate    = 0 THEN
    SET lc_gstrate =
    (
      SELECT
        COALESCE(SUM(tax_perc),0)
      FROM
        taxtran tt,
        tax tm
      WHERE
        tm.tax_code    = tt.tax_code
      AND tm.tax_type IN ('G','H')
      and tm.tax_group = as_taxgrouop
      AND tt.tran_code = as_trancode
      AND tt.tran_id   = as_tranid
      AND tt.line_no   = ls_lineno
    )
    ;
  END IF;
  RETURN lc_gstrate;
END


CREATE FUNCTION FN_GST_RATE_gp_AMT(as_trancode VARCHAR(6),as_tranid VARCHAR(10),al_lineno CHAR(3),as_type VARCHAR(1),as_rateoramt VARCHAR(1),as_taxgrouop char(5)) 
returns DECIMAL(17,6)
BEGIN
  ATOMIC
  DECLARE
    lc_rateoramt DECIMAL(17,6);
  DECLARE
    ls_lineno CHAR(3);
  IF(
      LENGTH(
        LTRIM(
          RTRIM(
            al_lineno))) = 1) THEN
    SET ls_lineno        = concat(
      '  ',
      LTRIM(
        RTRIM(
          al_lineno)));
  END IF;
  IF (LENGTH(LTRIM(RTRIM(al_lineno))) = 2) THEN
    SET ls_lineno                     = concat(' ',LTRIM(RTRIM(al_lineno)));
  END IF;
  IF (LENGTH(LTRIM(RTRIM(al_lineno))) = 3) THEN
    SET ls_lineno                     = LTRIM(RTRIM(al_lineno));
  END IF;
  IF as_rateoramt      = 'T' THEN
    SET (lc_rateoramt) =
    (
      SELECT
        COALESCE(taxable_amt,0)
      FROM
        taxtran tt,
        tax tm
      WHERE
        tm.tax_code       = tt.tax_code
      AND tm.tax_type    IN ('G','H','I')
      and tm.tax_group = as_taxgrouop
      AND tt.tran_code    = as_trancode
      AND tt.tran_id      = as_tranid
      AND tt.line_no      = ls_lineno
      AND tt.taxable_amt <> 0
      FETCH
        FIRST row only
    )
    ;
  END IF;
  IF as_rateoramt      = 'R' THEN
    SET (lc_rateoramt) =
    (
      SELECT
        COALESCE(MAX(tax_perc),0)
      FROM
        taxtran tt,
        tax tm
      WHERE
        tm.tax_code    = tt.tax_code
      AND tm.tax_type  = as_type
      and tm.tax_group = as_taxgrouop
      AND tt.tran_code = as_trancode
      AND tt.tran_id   = as_tranid
      AND tt.line_no   = ls_lineno
    )
    ;
  END IF;
  IF as_rateoramt      = 'A' THEN
    SET (lc_rateoramt) =
    (
      SELECT
        COALESCE(SUM(tax_amt),0)
      FROM
        taxtran tt,
        tax tm
      WHERE
        tm.tax_code    = tt.tax_code
      AND tm.tax_type  = as_type
      and tm.tax_group = as_taxgrouop
      AND tt.tran_code = as_trancode
      AND tt.tran_id   = as_tranid
      AND tt.line_no   = ls_lineno
    )
    ;
  END IF;
  RETURN lc_rateoramt;
END


create FUNCTION fn_sundry_gst_info (as_sundrytype char(1), as_code varchar(10), as_coltype char(1)) 
RETURNS varchar(2000) 
deterministic
begin atomic
    declare ls_strsql varchar(2000);
    declare ls_colname varchar(30);
    declare ls_colval varchar(2000);
        -- as_coltype   'N' - name , 'S' state_code 'G' - tax_reg_2
        if as_sundrytype = 'S' then
        
          if as_coltype='N' then
            set ls_colval = (select supp_name from supplier where supp_code = as_code) ;
          else 
              if as_coltype='S' then
                set ls_colval = (select STATE_CODE from supplier where supp_code = as_code) ;
              else
                set ls_colval = (select TAX_REG_2 from supplier where supp_code = as_code) ;
              end if;
          end if;
          
        else 
            if as_sundrytype = 'T' then
              if as_coltype='N' then
                set ls_colval = (select tran_name from transporter where tran_code = as_code) ;
              else 
                  if as_coltype='S' then
                    set ls_colval = (select STATE_CODE from transporter where tran_code = as_code) ;
                  else
                    set ls_colval = (select TAX_REG_2 from transporter where tran_code = as_code) ;
                  end if;
              end if;
            else
                set ls_colval = ' ';
            end if;
        end if;

    RETURN ls_colval ;
END
@
------------------------------------------------------
/*added by kaustubh on 2 sep 2017*/
INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) VALUES ('gstdata_prc','1  ','prd_code',NULL);

Insert into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) values ('VMDTGTR   ','greater date','from date greater than to date','E',null,null,null,null,to_date('27-04-06','DD-MM-RR'),'BASE      ','BASE           ',null,null);

Insert into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) values ('VMDATNULL ','Date empty','From / to date cannot be null','E','Y',null,null,null,to_date('12-02-09','DD-MM-RR'),'pankaj    ','pankaj         ',null,null);

Insert into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) values ('CNDIPRDINV','Invalid period!','Period does not exist','E','Y',null,null,null,to_date('01-04-09','DD-MM-RR'),'BIPIN     ','SUN            ',null,null);
------------------------------------------------------
/* added by kaustubh on 7 sep 2017*/

insert into MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) 
values ('VMSYNNULL','Invalid Operation !','No Data found for Sync','E','Y',null,null,null,to_date('01-04-09','DD-MM-RR'),'BIPIN     ','SUN            ',null,null);

/* added by kaustubh on 18 oct 2017*/
Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION)
values ('VNINVDATA','Invalide Operation','No Data Found For Sync Operation.','E','Y',null,null,null,to_date('18-10-17','DD-MM-RR'),'Kaustubh','BASE',null,null);

/* added by kaustubh on 23 oct 2017 */

Insert into DISPARM (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,DESCR,VAR_SUBS,CHG_DATE,CHG_USER,CHG_TERM) 
values ('999999','NO_OF_SLOT','S','50','TO SET SYNC DATA LIMIT',0,SYSDATE,'BASE','BASE');


