<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!--<xsl:output method="html" indent="no" version="4.0" /> -->

	<xsl:output omit-xml-declaration="yes" method="html"
		encoding="utf-8" indent="yes" />


	<xsl:template match="/">
		<html>
			<head>
				<title>Generate Receipt</title>
				<script type="text/javascript" src="../js/supp_info_upd.js"></script>
				<script type="text/javascript" src="../js/datetimepicker.js"></script>
				<link rel="stylesheet" href="../css/supp_info_upd.css" type="text/css" />
				<script type="text/javascript" src="/ibase/webitm/js/ITMWizardCalendar.js"></script>

				<script>
					var calendertop = 100;
					var calenderleft = 200;
					var selectedObj
					= null;
					var global_date_format ="MM/dd/yy";
					var global_date_type=
					"date";

					function assignDate( date )
					{
					document.getElementById(
					selectedObj ).value = date;
					document.getElementById( selectedObj
					).focus();
					}
				</script>

			</head>

			<xsl:for-each select="//Detail1">
				<!-- <xsl:variable name="tran_mode"> <xsl:value-of select="tran_mode" 
					/> </xsl:variable> -->

				<xsl:variable name="updateFlagHeader">
					<xsl:value-of select="attribute/@updateFlag" />
				</xsl:variable>

				<body onload="windowOnLoad();">
					<form name="form1" method="POST" action="">
						<div class="heading">
							<table width="100%" border="0" cellspacing="0" cellpadding="10">
								<tr>
									<td width="50%">Details</td>
									<td width="50%">
										<table align="right" border="0" width="30%">
											<tbody>
												<tr>
													<td style="text-align:right">
														<span class="buttondata" style="text-align:right">
															<!-- <input onclick="return saveData(this)" class="button"
																value="Save" type="button" /> -->
																<input onclick="return saveData1(this)" class="button"
																value="Save" type="button" />
														</span>
													</td>
													<td style="text-align:right">
														<input onclick="window.close();" class="button"
															value="Close" type="button" />
													</td>
												</tr>
											</tbody>
										</table>
									</td>
								</tr>
								<tr>
									<td width="50%">CURRENT</td>
									<td width="50%">CHANGED TO</td>
								</tr>
							</table>
						</div>
						<xsl:variable name="domIDHeader">
							<xsl:value-of select="@domID" />
						</xsl:variable>

						<xsl:variable name="statusHeader">
							<xsl:value-of select="attribute/@status" />
						</xsl:variable>
						<xsl:variable name="dbIDHeader">
							<xsl:value-of select="@dbID" />
						</xsl:variable>
						<xsl:variable name="pkNamesHeader">
							<xsl:value-of select="attribute/@pkNames" />
						</xsl:variable>
						<xsl:variable name="objNameHeader">
							<xsl:value-of select="@objName" />
						</xsl:variable>


						<!--End the static part -->

						<!-- This section for the properties purpose -->
						<xsl:variable name="tran_id">
							<xsl:value-of select="tran_id" />
						</xsl:variable>
						<xsl:variable name="tran_date">
							<xsl:value-of select="tran_date" />
						</xsl:variable>

						<xsl:variable name="supp_code">
							<xsl:value-of select="supp_code" />
						</xsl:variable>
						<xsl:variable name="supp_name">
							<xsl:value-of select="supp_name" />
						</xsl:variable>

						<xsl:variable name="pan_no_o">
							<xsl:value-of select="pan_no_o" />
						</xsl:variable>
						<xsl:variable name="pan_no">
							<xsl:value-of select="pan_no" />
						</xsl:variable>

						<xsl:variable name="chq_name_o">
							<xsl:value-of select="chq_name_o" />
						</xsl:variable>
						<xsl:variable name="chq_name">
							<xsl:value-of select="chq_name" />
						</xsl:variable>

						<xsl:variable name="alt_addr1_o">
							<xsl:value-of select="alt_addr1_o" />
						</xsl:variable>
						<xsl:variable name="alt_addr1">
							<xsl:value-of select="alt_addr1" />
						</xsl:variable>


						<xsl:variable name="alt_addr2_o">
							<xsl:value-of select="alt_addr2_o" />
						</xsl:variable>
						<xsl:variable name="alt_addr2">
							<xsl:value-of select="alt_addr2" />
						</xsl:variable>

						<xsl:variable name="alt_addr3_o">
							<xsl:value-of select="alt_addr3_o" />
						</xsl:variable>
						<xsl:variable name="alt_addr3">
							<xsl:value-of select="alt_addr3" />
						</xsl:variable>

						<xsl:variable name="alt_pin_o">
							<xsl:value-of select="alt_pin_o" />
						</xsl:variable>
						<xsl:variable name="alt_pin">
							<xsl:value-of select="alt_pin" />
						</xsl:variable>

						<xsl:variable name="alt_city_o">
							<xsl:value-of select="alt_city_o" />
						</xsl:variable>
						<xsl:variable name="alt_city">
							<xsl:value-of select="alt_city" />
						</xsl:variable>

						<xsl:variable name="state_code__alt_o">
							<xsl:value-of select="state_code__alt_o" />
						</xsl:variable>
						<xsl:variable name="state_code__alt">
							<xsl:value-of select="state_code__alt" />
						</xsl:variable>

						<xsl:variable name="alt_tele1_o">
							<xsl:value-of select="alt_tele1_o" />
						</xsl:variable>
						<xsl:variable name="alt_tele1">
							<xsl:value-of select="alt_tele1" />
						</xsl:variable>

						<xsl:variable name="tele1_o">
							<xsl:value-of select="tele1_o" />
						</xsl:variable>
						<xsl:variable name="tele1">
							<xsl:value-of select="tele1" />
						</xsl:variable>

						<xsl:variable name="tele2_o">
							<xsl:value-of select="tele2_o" />
						</xsl:variable>
						<xsl:variable name="tele2">
							<xsl:value-of select="tele2" />
						</xsl:variable>

						<xsl:variable name="fax_o">
							<xsl:value-of select="fax_o" />
						</xsl:variable>
						<xsl:variable name="fax">
							<xsl:value-of select="fax" />
						</xsl:variable>

						<xsl:variable name="tax_reg_o">
							<xsl:value-of select="tax_reg_o" />
						</xsl:variable>
						<xsl:variable name="tax_reg">
							<xsl:value-of select="tax_reg" />
						</xsl:variable>

						<xsl:variable name="excise_ref_o">
							<xsl:value-of select="excise_ref_o" />
						</xsl:variable>
						<xsl:variable name="excise_ref">
							<xsl:value-of select="excise_ref" />
						</xsl:variable>

						<xsl:variable name="ser_tax_reg_o">
							<xsl:value-of select="ser_tax_reg_o" />
						</xsl:variable>
						<xsl:variable name="ser_tax_reg">
							<xsl:value-of select="ser_tax_reg" />
						</xsl:variable>

						<xsl:variable name="contact_purc_o">
							<xsl:value-of select="contact_purc_o" />
						</xsl:variable>
						<xsl:variable name="contact_purc">
							<xsl:value-of select="contact_purc" />
						</xsl:variable>

						<xsl:variable name="email_addr_o">
							<xsl:value-of select="email_addr_o" />
						</xsl:variable>
						<xsl:variable name="email_addr">
							<xsl:value-of select="email_addr" />
						</xsl:variable>

						<xsl:variable name="email_purc_o">
							<xsl:value-of select="email_purc_o" />
						</xsl:variable>
						<xsl:variable name="email_purc">
							<xsl:value-of select="email_purc" />
						</xsl:variable>

						<xsl:variable name="tax_reg_st_o">
							<xsl:value-of select="tax_reg_st_o" />
						</xsl:variable>
						<xsl:variable name="tax_reg_st">
							<xsl:value-of select="tax_reg_st" />
						</xsl:variable>

						<xsl:variable name="ecc_no_o">
							<xsl:value-of select="ecc_no_o" />
						</xsl:variable>
						<xsl:variable name="ecc_no">
							<xsl:value-of select="ecc_no" />
						</xsl:variable>

						<xsl:variable name="cst_no_o">
							<xsl:value-of select="cst_no_o" />
						</xsl:variable>
						<xsl:variable name="cst_no">
							<xsl:value-of select="cst_no" />
						</xsl:variable>

						<xsl:variable name="ssi_o">
							<xsl:value-of select="ssi_o" />
						</xsl:variable>
						<xsl:variable name="ssi">
							<xsl:value-of select="ssi" />
						</xsl:variable>

						<xsl:variable name="pf_no_o">
							<xsl:value-of select="pf_no_o" />
						</xsl:variable>
						<xsl:variable name="pf_no">
							<xsl:value-of select="pf_no" />
						</xsl:variable>

						<xsl:variable name="wf_status">
							<xsl:value-of select="wf_status" />
						</xsl:variable>
						<xsl:variable name="status_date">
							<xsl:value-of select="status_date" />
						</xsl:variable>
						<xsl:variable name="count_code">
							<xsl:value-of select="count_code" />
						</xsl:variable>
						<xsl:variable name="count_code_1">
							<xsl:value-of select="count_code_1" />
						</xsl:variable>






						<!--Start the static input field hidden -->
						<input type="hidden" value="{$dbIDHeader}"
							name="Detail1.{normalize-space($domIDHeader)}.dbID" id="Detail1.{normalize-space($domIDHeader)}.dbID" />
						<input type="hidden" value="{$objNameHeader}"
							name="Detail1.{normalize-space($domIDHeader)}.objName" id="Detail1.{normalize-space($domIDHeader)}.objName" />
						<input type="hidden" value="{$pkNamesHeader}"
							name="Detail1.{normalize-space($domIDHeader)}.pkNames" id="Detail1.{normalize-space($domIDHeader)}.pkNames" />
						<input type="hidden" value="{$statusHeader}"
							name="Detail1.{normalize-space($domIDHeader)}.status" id="Detail1.{normalize-space($domIDHeader)}.status" />
						<input type="hidden" value="{$updateFlagHeader}"
							name="Detail1.{normalize-space($domIDHeader)}.updateFlag" id="Detail1.{normalize-space($domIDHeader)}.updateFlag" />
						<input type="hidden" value="{$objNameHeader}" name="OBJ_NAME"
							id="OBJ_NAME" />
						<input type="hidden" value="{$dbIDHeader}" name="pkValues"
							id="pkValues" />
						<input type="hidden" value="{$updateFlagHeader}" name="updateFlag"
							id="updateFlag" />
						<!--End the static input field -->

						<table id="headerTable" class="headerTable question1" align="center"
							border="0" cellpadding="0" cellspacing="0">
							<tbody>

								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.tran_id" name="Detail1.{normalize-space($domIDHeader)}.tran_id"
											value="{$tran_id}" size="12" tabindex="-1" style="margin-left:10px; width:350px;" 
											maxlength="10" readonly="readonly"
											required="true"  />
										<label style="margin-top: -45px; transform:none;" >Transaction Id</label>
									</td>
									

									<td width="31%" class="headerTextCol9">
										<input tabindex="-1" class="headerInputField" size="10" 
											onBlur="return onBlurFunction(this),setDefaultDateFormat(this)"
											isservercallonchange="true" onKeyDown="return onKeyDownFun(this,event)"
											value="{$tran_date}" name="Detail1.{normalize-space($domIDHeader)}.tran_date" style="margin-left:10px; width:350px;"  
											id="Detail1.{normalize-space($domIDHeader)}.tran_date" type="text" readonly="readonly"/>
										<!-- <img src="/ibase/webitm/images/Standard/e12_pophelp_16.jpg" 
											onClick="selectedObj= 'Detail1.{normalize-space($domIDHeader)}.tran_date'; 
											javascript:show_calendar('Detail1.{normalize-space($domIDHeader)}.tran_date','','','{normalize-space(date_format)}');"/> -->
										<label style="margin-top: -45px; transform:none;" >Transaction Date</label>
									</td>
								</tr>


								<tr>

									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.supp_code" name="Detail1.{normalize-space($domIDHeader)}.supp_code"
											value="{$supp_code}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="10"
											required="true" readonly="readonly"/>
										<label style="margin-top: -45px; transform:none;" >Supplier</label>
									</td>

									<td class="headerTextCol8">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.supp_name" name="Detail1.{normalize-space($domIDHeader)}.supp_name"
											value="{$supp_name}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="50"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Supplier Name</label>
									</td>
								</tr>

								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.pan_no_o" name="Detail1.{normalize-space($domIDHeader)}.pan_no_o"
											value="{$pan_no_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="30"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >PAN Number</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                               <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.pan_no" name="Detail1.{normalize-space($domIDHeader)}.pan_no"
															value="{$pan_no}" size="12" tabindex="1" style="margin-left:10px; width:350px;"   maxlength="30"
															required="true" readonly="readonly" />
														<label  style="margin-top: -45px; transform:none;">PAN Number</label>
												</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="headerTextCol6">
												<input type="text"
														id="Detail1.{normalize-space($domIDHeader)}.pan_no" name="Detail1.{normalize-space($domIDHeader)}.pan_no"
														value="{$pan_no}" size="12" tabindex="1" style="margin-left:10px; width:350px;"   maxlength="30"
													required="true" />
												<label>PAN Number</label>
											</td>
                                            </xsl:otherwise>
                                        </xsl:choose>
										 <td class="headerTextCol6">
										       <img src="/ibase/webitm/images/Standard/attachment.png" width="30" height="25"  onclick="callAttachment('{normalize-space($tran_id)}.pan_no','supp_info_upd','Y') "/>  
										</td>
								</tr>

								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.chq_name_o" name="Detail1.{normalize-space($domIDHeader)}.chq_name_o"
											value="{$chq_name_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="160"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Cheque Name</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.chq_name" name="Detail1.{normalize-space($domIDHeader)}.chq_name"
															value="{$chq_name}" size="12" tabindex="2" style="margin-left:10px; width:350px;"   maxlength="160"
															required="true"   readonly="readonly"/>
														<label style="margin-top: -45px; transform:none;">Cheque Name</label>
												</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.chq_name" name="Detail1.{normalize-space($domIDHeader)}.chq_name"
															value="{$chq_name}" size="12" tabindex="2" style="margin-left:10px; width:350px;"   maxlength="160"
															required="true" />
													<label>Cheque Name</label>
												</td>
                                            </xsl:otherwise>
                                        </xsl:choose>
								</tr>

								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.alt_addr1_o"
											name="Detail1.{normalize-space($domIDHeader)}.alt_addr1_o"
											value="{$alt_addr1_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="50"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Alternate Address1</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.alt_addr1" name="Detail1.{normalize-space($domIDHeader)}.alt_addr1"
															value="{$alt_addr1}" size="12" tabindex="3" style="margin-left:10px; width:350px;"   maxlength="50"
															required="true" readonly="readonly"/>
													<label style="margin-top: -45px; transform:none;">Alternate Address1</label>
												</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="headerTextCol6">
														<input type="text"
																id="Detail1.{normalize-space($domIDHeader)}.alt_addr1" name="Detail1.{normalize-space($domIDHeader)}.alt_addr1"
																value="{$alt_addr1}" size="12" tabindex="3" style="margin-left:10px; width:350px;"   maxlength="50"
																required="true" />
														<label>Alternate Address1</label>
												</td>
                                            </xsl:otherwise>
                                        </xsl:choose>
								</tr>

								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.alt_addr2_o"
											name="Detail1.{normalize-space($domIDHeader)}.alt_addr2_o"
											value="{$alt_addr2_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="50"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Alternate Address2</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.alt_addr2" name="Detail1.{normalize-space($domIDHeader)}.alt_addr2"
															value="{$alt_addr2}" size="12" tabindex="4" style="margin-left:10px; width:350px;"   maxlength="50"
															required="true"  readonly="readonly" />
													<label style="margin-top: -45px; transform:none;" >Alternate Address2</label>
											</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="headerTextCol6">
														<input type="text"
																id="Detail1.{normalize-space($domIDHeader)}.alt_addr2" name="Detail1.{normalize-space($domIDHeader)}.alt_addr2"
																value="{$alt_addr2}" size="12" tabindex="4" style="margin-left:10px; width:350px;"   maxlength="50"
																required="true"  />
														<label>Alternate Address2</label>
												</td>
                                            </xsl:otherwise>
                                        </xsl:choose>
								</tr>

								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.alt_addr3_o"
											name="Detail1.{normalize-space($domIDHeader)}.alt_addr3_o"
											value="{$alt_addr3_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="50"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Alternate Address3</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.alt_addr3" name="Detail1.{normalize-space($domIDHeader)}.alt_addr3"
															value="{$alt_addr3}" size="12" tabindex="5" style="margin-left:10px; width:350px;"   maxlength="50"
															required="true" readonly="readonly" />
													<label style="margin-top: -45px; transform:none;">Alternate Address3</label>
											</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.alt_addr3" name="Detail1.{normalize-space($domIDHeader)}.alt_addr3"
															value="{$alt_addr3}" size="12" tabindex="5" style="margin-left:10px; width:350px;"   maxlength="50"
															required="true"  />
													<label>Alternate Address3</label>
												</td>
                                            </xsl:otherwise>
                                        </xsl:choose>
								</tr>

								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.alt_pin_o" name="Detail1.{normalize-space($domIDHeader)}.alt_pin_o"
											value="{$alt_pin_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="10"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Alternate Pin</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.alt_pin" name="Detail1.{normalize-space($domIDHeader)}.alt_pin"
															value="{$alt_pin}" size="12" tabindex="6" style="margin-left:10px; width:350px;"   maxlength="10"
															required="true" readonly="readonly" />
														<label style="margin-top: -45px; transform:none;">Alternate Pin</label>
											</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.alt_pin" name="Detail1.{normalize-space($domIDHeader)}.alt_pin"
															value="{$alt_pin}" size="12" tabindex="6" style="margin-left:10px; width:350px;"   maxlength="10"
															required="true" />
													<label>Alternate Pin</label>
												</td>
                                            </xsl:otherwise>
                                        </xsl:choose>
								</tr>
								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.alt_city_o" name="Detail1.{normalize-space($domIDHeader)}.alt_city_o"
											value="{$alt_city_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="20"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Alternate City</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.alt_city" name="Detail1.{normalize-space($domIDHeader)}.alt_city"
															value="{$alt_city}" size="12" tabindex="7" style="margin-left:10px; width:350px;"   maxlength="20"
															required="true" readonly="readonly"/>
													<label style="margin-top: -45px; transform:none;">Alternate City</label>
												</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.alt_city" name="Detail1.{normalize-space($domIDHeader)}.alt_city"
															value="{$alt_city}" size="12" tabindex="7" style="margin-left:10px; width:350px;"   maxlength="20"
															required="true" />
													<label>Alternate City</label>
												</td>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        
								</tr>
								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.state_code__alt_o"
											name="Detail1.{normalize-space($domIDHeader)}.state_code__alt_o"
											value="{$state_code__alt_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"  
											maxlength="5" required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Alternate State Code</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.state_code__alt"
															name="Detail1.{normalize-space($domIDHeader)}.state_code__alt"
															value="{$state_code__alt}" size="12" tabindex="8" style="margin-left:10px; width:350px;"   maxlength="5"
															required="true" readonly="readonly" />
													<label style="margin-top: -45px; transform:none;">Alternate State Code</label>
												</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.state_code__alt"
															name="Detail1.{normalize-space($domIDHeader)}.state_code__alt"
															value="{$state_code__alt}" size="12" tabindex="8" style="margin-left:10px; width:350px;"   maxlength="5"
															required="true" />
													<label>Alternate State Code</label>
												</td>
                                            </xsl:otherwise>
                                        </xsl:choose>
								</tr>
								
								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.count_code"
											name="Detail1.{normalize-space($domIDHeader)}.count_code"
											value="{$count_code}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"  
											maxlength="5" required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Alternate Country Code</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.count_code_1"
															name="Detail1.{normalize-space($domIDHeader)}.count_code_1"
															value="{$count_code_1}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"  
															maxlength="5" required="true" readonly="readonly" />
													<label style="margin-top: -45px; transform:none;" >Alternate Country Code</label>
												</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.count_code_1"
															name="Detail1.{normalize-space($domIDHeader)}.count_code_1"
															value="{$count_code_1}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"  
															maxlength="5" required="true" readonly="readonly" />
													<label style="margin-top: -45px; transform:none;" >Alternate Country Code</label>
												</td>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        
								</tr>

								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.alt_tele1_o"
											name="Detail1.{normalize-space($domIDHeader)}.alt_tele1_o"
											value="{$alt_tele1_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="20"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Alternate Telphone Number1</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.alt_tele1" name="Detail1.{normalize-space($domIDHeader)}.alt_tele1"
															value="{$alt_tele1}" size="12" tabindex="9" style="margin-left:10px; width:350px;"   maxlength="20"
															required="true" readonly="readonly"/>
													<label  style="margin-top: -45px; transform:none;">Alternate Telphone Number1</label>
											</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.alt_tele1" name="Detail1.{normalize-space($domIDHeader)}.alt_tele1"
															value="{$alt_tele1}" size="12" tabindex="9" style="margin-left:10px; width:350px;"   maxlength="20"
															required="true" />
													<label>Alternate Telphone Number1</label>
												</td>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        
								</tr>

								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.tele1_o" name="Detail1.{normalize-space($domIDHeader)}.tele1_o"
											value="{$tele1_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="25"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Telphone Number1</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.tele1" name="Detail1.{normalize-space($domIDHeader)}.tele1"
															value="{$tele1}" size="12" tabindex="10" style="margin-left:10px; width:350px;"   maxlength="25"
															required="true" readonly="readonly"/>
													<label style="margin-top: -45px; transform:none;" >Telphone Number1</label>
											</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.tele1" name="Detail1.{normalize-space($domIDHeader)}.tele1"
															value="{$tele1}" size="12" tabindex="10" style="margin-left:10px; width:350px;"   maxlength="25"
															required="true" />
													<label>Telphone Number1</label>
												</td>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        
								</tr>

								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.tele2_o" name="Detail1.{normalize-space($domIDHeader)}.tele2_o"
											value="{$tele2_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="25"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Telphone Number2</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.tele2" name="Detail1.{normalize-space($domIDHeader)}.tele2"
															value="{$tele2}" size="12" tabindex="11" style="margin-left:10px; width:350px;"   maxlength="25"
															required="true" readonly="readonly" />
													<label style="margin-top: -45px; transform:none;">Telphone Number2</label>
											</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.tele2" name="Detail1.{normalize-space($domIDHeader)}.tele2"
															value="{$tele2}" size="12" tabindex="11" style="margin-left:10px; width:350px;"   maxlength="25"
															required="true" />
													<label>Telphone Number2</label>
												</td>
                                            </xsl:otherwise>
                                      </xsl:choose>
									
								</tr>

								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.fax_o" name="Detail1.{normalize-space($domIDHeader)}.fax_o"
											value="{$fax_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="15"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Fax</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.fax" name="Detail1.{normalize-space($domIDHeader)}.fax"
															value="{$fax}" size="12" tabindex="12" style="margin-left:10px; width:350px;"   maxlength="15"
															required="true" readonly="readonly" />
													<label  style="margin-top: -45px; transform:none;" >Fax</label>
											</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.fax" name="Detail1.{normalize-space($domIDHeader)}.fax"
															value="{$fax}" size="12" tabindex="12" style="margin-left:10px; width:350px;"   maxlength="15"
															required="true" />
													<label>Fax</label>
												</td>
                                            </xsl:otherwise>
                                      </xsl:choose>
									
								</tr>


								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.tax_reg_o" name="Detail1.{normalize-space($domIDHeader)}.tax_reg_o"
											value="{$tax_reg_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="30"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Tax Registration</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.tax_reg" name="Detail1.{normalize-space($domIDHeader)}.tax_reg"
															value="{$tax_reg}" size="12" tabindex="13" style="margin-left:10px; width:350px;"   maxlength="30"
															required="true" readonly="readonly" />
													<label  style="margin-top: -45px; transform:none;">Tax Registration</label>
											</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <td class="headerTextCol6">
														<input type="text"
																id="Detail1.{normalize-space($domIDHeader)}.tax_reg" name="Detail1.{normalize-space($domIDHeader)}.tax_reg"
																value="{$tax_reg}" size="12" tabindex="13" style="margin-left:10px; width:350px;"   maxlength="30"
																required="true" />
														<label>Tax Registration</label>
												</td>
                                            </xsl:otherwise>
                                      </xsl:choose>
									
									 <td class="headerTextCol6">
										       <img src="/ibase/webitm/images/Standard/attachment.png" width="30" height="25"  onclick="callAttachment('{normalize-space($tran_id)}.tax_reg','supp_info_upd','Y') "/>  
										</td>
								</tr>


								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.excise_ref_o"
											name="Detail1.{normalize-space($domIDHeader)}.excise_ref_o"
											value="{$excise_ref_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="200"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Excise Reference</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.excise_ref" name="Detail1.{normalize-space($domIDHeader)}.excise_ref"
															value="{$excise_ref}" size="12" tabindex="14" style="margin-left:10px; width:350px;"   maxlength="200"
															required="true"  readonly="readonly"/>
													<label style="margin-top: -45px; transform:none;">Excise Reference</label>
												</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                               <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.excise_ref" name="Detail1.{normalize-space($domIDHeader)}.excise_ref"
															value="{$excise_ref}" size="12" tabindex="14" style="margin-left:10px; width:350px;"   maxlength="200"
															required="true" />
													<label>Excise Reference</label>
												</td>
                                            </xsl:otherwise>
                                      </xsl:choose>
									
								</tr>


								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.ser_tax_reg_o"
											name="Detail1.{normalize-space($domIDHeader)}.ser_tax_reg_o"
											value="{$ser_tax_reg_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="30"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Service Tax Regs</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.ser_tax_reg"
															name="Detail1.{normalize-space($domIDHeader)}.ser_tax_reg"
															value="{$ser_tax_reg}" size="12" tabindex="15" style="margin-left:10px; width:350px;"   maxlength="30"
															required="true" readonly="readonly" />
													<label style="margin-top: -45px; transform:none;" >Service Tax Regs</label>
												</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                               <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.ser_tax_reg"
															name="Detail1.{normalize-space($domIDHeader)}.ser_tax_reg"
															value="{$ser_tax_reg}" size="12" tabindex="15" style="margin-left:10px; width:350px;"   maxlength="30"
															required="true" />
													<label>Service Tax Regs</label>
												</td>
                                            </xsl:otherwise>
                                      </xsl:choose>
                                      
									
								</tr>


								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.contact_purc_o"
											name="Detail1.{normalize-space($domIDHeader)}.contact_purc_o"
											value="{$contact_purc_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="40"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Contact Person</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.contact_purc"
															name="Detail1.{normalize-space($domIDHeader)}.contact_purc"
															value="{$contact_purc}" size="12" tabindex="16" style="margin-left:10px; width:350px;"   maxlength="40"
															required="true" readonly="readonly" />
													<label  style="margin-top: -45px; transform:none;">Contact Person</label>
												</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                               <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.contact_purc"
															name="Detail1.{normalize-space($domIDHeader)}.contact_purc"
															value="{$contact_purc}" size="12" tabindex="16" style="margin-left:10px; width:350px;"   maxlength="40"
															required="true" />
														<label>Contact Person</label>
												</td>
                                            </xsl:otherwise>
                                      </xsl:choose>
									
								</tr>


								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.email_addr_o"
											name="Detail1.{normalize-space($domIDHeader)}.email_addr_o"
											value="{$email_addr_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="40"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Email Address</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.email_addr" name="Detail1.{normalize-space($domIDHeader)}.email_addr"
															value="{$email_addr}" size="12" tabindex="17" style="margin-left:10px; width:350px;"   maxlength="40"
															required="true" readonly="readonly" />
														<label  style="margin-top: -45px; transform:none;">Email Address</label>
											</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                               <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.email_addr" name="Detail1.{normalize-space($domIDHeader)}.email_addr"
															value="{$email_addr}" size="12" tabindex="17" style="margin-left:10px; width:350px;"   maxlength="40"
															required="true" />
													<label>Email Address</label>
												</td>
                                            </xsl:otherwise>
                                      </xsl:choose>
									
								</tr>


								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.email_purc_o"
											name="Detail1.{normalize-space($domIDHeader)}.email_purc_o"
											value="{$email_purc_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="40"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Purchasing Email</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.email_purc" name="Detail1.{normalize-space($domIDHeader)}.email_purc"
															value="{$email_purc}" size="12" tabindex="18" style="margin-left:10px; width:350px;"   maxlength="40"
															required="true" readonly="readonly" />
													<label style="margin-top: -45px; transform:none;" >Purchasing Email</label>
												</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                               <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.email_purc" name="Detail1.{normalize-space($domIDHeader)}.email_purc"
															value="{$email_purc}" size="12" tabindex="18" style="margin-left:10px; width:350px;"   maxlength="40"
															required="true" />
														<label>Purchasing Email</label>
												</td>
                                            </xsl:otherwise>
                                      </xsl:choose>
									
								</tr>


								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.tax_reg_st_o"
											name="Detail1.{normalize-space($domIDHeader)}.tax_reg_st_o"
											value="{$tax_reg_st_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="30"
											required="true"  readonly="readonly"/>
										<label style="margin-top: -45px; transform:none;" >Tax Registration St</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.tax_reg_st" name="Detail1.{normalize-space($domIDHeader)}.tax_reg_st"
															value="{$tax_reg_st}" size="12" tabindex="19" style="margin-left:10px; width:350px;"   maxlength="30"
															required="true" readonly="readonly" />
													<label style="margin-top: -45px; transform:none;">Tax Registration St</label>
												</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                               <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.tax_reg_st" name="Detail1.{normalize-space($domIDHeader)}.tax_reg_st"
															value="{$tax_reg_st}" size="12" tabindex="19" style="margin-left:10px; width:350px;"   maxlength="30"
															required="true" />
													<label>Tax Registration St</label>
												</td>
                                            </xsl:otherwise>
                                      </xsl:choose>
									
								</tr>


								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.ecc_no_o" name="Detail1.{normalize-space($domIDHeader)}.ecc_no_o"
											value="{$ecc_no_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="30"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >ECC No</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.ecc_no" name="Detail1.{normalize-space($domIDHeader)}.ecc_no"
															value="{$ecc_no}" size="12" tabindex="20" style="margin-left:10px; width:350px;"   maxlength="30"
															required="true" readonly="readonly" />
													<label style="margin-top: -45px; transform:none;">ECC No</label>
												</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                               <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.ecc_no" name="Detail1.{normalize-space($domIDHeader)}.ecc_no"
															value="{$ecc_no}" size="12" tabindex="20" style="margin-left:10px; width:350px;"   maxlength="30"
															required="true" />
													<label>ECC No</label>
												</td>
                                            </xsl:otherwise>
                                      </xsl:choose>
									<td class="headerTextCol6">
										       <img src="/ibase/webitm/images/Standard/attachment.png" width="30" height="25"  onclick="callAttachment('{normalize-space($tran_id)}.ecc_no','supp_info_upd','Y') "/>  
										</td>
									
								</tr>


								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.cst_no_o" name="Detail1.{normalize-space($domIDHeader)}.cst_no_o"
											value="{$cst_no_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="30"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >CST No</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.cst_no" name="Detail1.{normalize-space($domIDHeader)}.cst_no"
															value="{$cst_no}" size="12" tabindex="21" style="margin-left:10px; width:350px;"   maxlength="30"
															required="true" readonly="readonly" />
													<label style="margin-top: -45px; transform:none;">CST No</label>
												</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                               <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.cst_no" name="Detail1.{normalize-space($domIDHeader)}.cst_no"
															value="{$cst_no}" size="12" tabindex="21" style="margin-left:10px; width:350px;"   maxlength="30"
															required="true" />
													<label>CST No</label>
												</td>
                                            </xsl:otherwise>
                                      </xsl:choose>
									<td class="headerTextCol6">
										       <img src="/ibase/webitm/images/Standard/attachment.png" width="30" height="25"  onclick="callAttachment('{normalize-space($tran_id)}.cst_no','supp_info_upd','Y') "/>  
										</td>
								</tr>

								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.ssi_o" name="Detail1.{normalize-space($domIDHeader)}.ssi_o"
											value="{$ssi_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="1"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >Small Scale Industry</label>
									</td>
									<td class="headerTextCol6">
										<label style="margin-top: -20px; transform:none;">Small Scale Industry</label>
										<select tabindex="22"  class="headerInputField" 
										style="height: 20px; width:350px; color:#999;" value="{$ssi}" 
										name="Detail1.{normalize-space($domIDHeader)}.ssi" 
										id="Detail1.{normalize-space($domIDHeader)}.ssi">
										
										<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                            <xsl:choose>
                                            <xsl:when test="ssi = 'Y'">
                                                <option value="Y" selected="selected">Yes</option>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <option value="N">No</option>
                                            </xsl:otherwise>
                                        	</xsl:choose>
                                            </xsl:when>
                                            <xsl:otherwise>
                                            <xsl:choose>
                                            <xsl:when test="ssi = 'Y'">
                                                <option value="Y" selected="selected">Yes</option>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <option value="Y">Yes</option>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <xsl:choose>
                                            <xsl:when test="ssi = 'N'">
                                                <option value="N" selected="selected">No</option>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <option value="N">No</option>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                            
                                            </xsl:otherwise>
                                            
                                         </xsl:choose>
										
   										<!-- <xsl:choose>
                                            <xsl:when test="ssi = 'Y'">
                                                <option value="Y" selected="selected">Yes</option>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <option value="Y">Yes</option>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <xsl:choose>
                                            <xsl:when test="ssi = 'N'">
                                                <option value="N" selected="selected">No</option>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <option value="N">No</option>
                                            </xsl:otherwise>
                                        </xsl:choose> -->
   										
   											</select>
									</td>
								</tr>


								<tr>
									<td class="headerTextCol6">
										<input type="text"
											id="Detail1.{normalize-space($domIDHeader)}.pf_no_o" name="Detail1.{normalize-space($domIDHeader)}.pf_no_o"
											value="{$pf_no_o}" size="12" tabindex="-1" style="margin-left:10px; width:350px;"   maxlength="10"
											required="true" readonly="readonly" />
										<label style="margin-top: -45px; transform:none;" >PF Number</label>
									</td>
									<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                              <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.pf_no" name="Detail1.{normalize-space($domIDHeader)}.pf_no"
															value="{$pf_no}" size="12" tabindex="23" style="margin-left:10px; width:350px;"   maxlength="10"
															required="true" readonly="readonly" />
													<label style="margin-top: -45px; transform:none;">PF Number</label>
												</td>
                                            </xsl:when>
                                            <xsl:otherwise>
                                               <td class="headerTextCol6">
													<input type="text"
															id="Detail1.{normalize-space($domIDHeader)}.pf_no" name="Detail1.{normalize-space($domIDHeader)}.pf_no"
															value="{$pf_no}" size="12" tabindex="23" style="margin-left:10px; width:350px;"   maxlength="10"
															required="true" />
												<label>PF Number</label>
												</td>
                                            </xsl:otherwise>
                                      </xsl:choose>
									<td class="headerTextCol6">
										       <img src="/ibase/webitm/images/Standard/attachment.png" width="30" height="25"  onclick="callAttachment('{normalize-space($tran_id)}.pf_no','supp_info_upd','Y') "/>  
										</td>
								</tr>
								<tr>
									<td class="headerTextCol6">
										<label style="margin-top: -20px; transform:none;">Status</label>
										<select tabindex="24"  class="headerInputField" 
										style="height: 20px; width:350px; color:#999;" value="{$wf_status}" 
										name="Detail1.{normalize-space($domIDHeader)}.wf_status" 
										id="Detail1.{normalize-space($domIDHeader)}.wf_status">
										<xsl:choose>
                                            <xsl:when test="normalize-space($wf_status) = 'S'">
                                            <xsl:choose>
                                            <xsl:when test="wf_status = 'O'">
                                                <option value="O" selected="selected">Open</option>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <option value="S">Submit</option>
                                            </xsl:otherwise>
                                        	</xsl:choose>
                                            </xsl:when>
                                            <xsl:otherwise>
                                            <xsl:choose>
                                            <xsl:when test="wf_status = 'O'">
                                                <option value="O" selected="selected">Open</option>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <option value="O">Open</option>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <xsl:choose>
                                            <xsl:when test="wf_status = 'S'">
                                                <option value="S" selected="selected">Submit</option>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <option value="S">Submit</option>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                            
                                            </xsl:otherwise>
                                            
                                           </xsl:choose> 
                                           
                                           
   												<!-- <xsl:choose>
                                            <xsl:when test="wf_status = 'O'">
                                                <option value="O" selected="selected">Open</option>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <option value="O">Open</option>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <xsl:choose>
                                            <xsl:when test="wf_status = 'S'">
                                                <option value="S" selected="selected">Submit</option>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <option value="S">Submit</option>
                                            </xsl:otherwise>
                                        </xsl:choose> -->
   										
   											</select>
									</td>
									<td class="headerTextCol6">
										<input tabindex="-10" class="headerInputField" size="10"
											value="{$status_date}" name="Detail1.{normalize-space($domIDHeader)}.status_date"
											id="Detail1.{normalize-space($domIDHeader)}.status_date"
											type="text" style="margin-left:10px; width:350px;"  readonly="readonly"   />
										<label style="margin-top: -45px; transform:none;">Status Date</label>
										
									</td>
								</tr>
							</tbody>
						</table>


					</form>

					<table class="detail3Table" id="detail3Table" width="100%">

					</table>


				</body>
			</xsl:for-each>

		</html>
	</xsl:template>
</xsl:stylesheet>
