/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.protocol.HttpAsyncClientExchangeHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimalClientExchangeHandlerImpl<T>
implements HttpAsyncClientExchangeHandler,
Cancellable {
    private static final AtomicLong COUNTER = new AtomicLong(1L);
    private final Log log;
    private final long id;
    private final HttpAsyncRequestProducer requestProducer;
    private final HttpAsyncResponseConsumer<T> responseConsumer;
    private final HttpClientContext localContext;
    private final BasicFuture<T> resultFuture;
    private final NHttpClientConnectionManager connmgr;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final ConnectionKeepAliveStrategy keepaliveStrategy;
    private volatile boolean closed;
    private volatile boolean completed;
    private HttpRoute route;
    private NHttpClientConnection managedConn;
    private HttpRequestWrapper request;
    private HttpResponse response;
    private boolean reusable;
    private long validDuration;

    public MinimalClientExchangeHandlerImpl(Log log, HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpClientContext localContext, BasicFuture<T> resultFuture, NHttpClientConnectionManager connmgr, HttpProcessor httpProcessor, ConnectionReuseStrategy connReuseStrategy, ConnectionKeepAliveStrategy keepaliveStrategy) {
        this.log = log;
        this.id = COUNTER.getAndIncrement();
        this.requestProducer = requestProducer;
        this.responseConsumer = responseConsumer;
        this.localContext = localContext;
        this.resultFuture = resultFuture;
        this.connmgr = connmgr;
        this.httpProcessor = httpProcessor;
        this.connReuseStrategy = connReuseStrategy;
        this.keepaliveStrategy = keepaliveStrategy;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.abortConnection();
        try {
            this.requestProducer.close();
        }
        catch (IOException ex) {
            this.log.debug((Object)"I/O error closing request producer", (Throwable)ex);
        }
        try {
            this.responseConsumer.close();
        }
        catch (IOException ex) {
            this.log.debug((Object)"I/O error closing response consumer", (Throwable)ex);
        }
    }

    public synchronized void start() throws HttpException, IOException {
        RequestConfig config;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Start execution"));
        }
        HttpHost target = this.requestProducer.getTarget();
        HttpRequest original = this.requestProducer.generateRequest();
        if (original instanceof HttpExecutionAware) {
            ((HttpExecutionAware)original).setCancellable((Cancellable)this);
        }
        if (original instanceof Configurable && (config = ((Configurable)original).getConfig()) != null) {
            this.localContext.setRequestConfig(config);
        }
        this.request = HttpRequestWrapper.wrap((HttpRequest)original);
        this.route = new HttpRoute(target);
        this.localContext.setAttribute("http.request", (Object)this.request);
        this.localContext.setAttribute("http.target_host", (Object)target);
        this.localContext.setAttribute("http.route", (Object)this.route);
        this.httpProcessor.process((HttpRequest)this.request, (HttpContext)this.localContext);
        this.requestConnection();
    }

    public boolean isDone() {
        return this.completed;
    }

    public synchronized HttpRequest generateRequest() throws IOException, HttpException {
        if (!this.connmgr.isRouteComplete(this.managedConn)) {
            this.connmgr.initialize(this.managedConn, this.route, (HttpContext)this.localContext);
            this.connmgr.routeComplete(this.managedConn, this.route, (HttpContext)this.localContext);
        }
        return this.request;
    }

    public synchronized void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Produce content"));
        }
        this.requestProducer.produceContent(encoder, ioctrl);
        if (encoder.isCompleted()) {
            this.requestProducer.resetRequest();
        }
    }

    public synchronized void requestCompleted() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Request completed"));
        }
        this.requestProducer.requestCompleted((HttpContext)this.localContext);
    }

    public synchronized void responseReceived(HttpResponse response) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Response received " + response.getStatusLine()));
        }
        this.localContext.setAttribute("http.response", (Object)response);
        this.httpProcessor.process(response, (HttpContext)this.localContext);
        this.responseConsumer.responseReceived(response);
        this.response = response;
    }

    public synchronized void consumeContent(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Consume content"));
        }
        this.responseConsumer.consumeContent(decoder, ioctrl);
    }

    public synchronized void responseCompleted() throws IOException, HttpException {
        if (this.resultFuture.isDone()) {
            this.completed = true;
            this.releaseConnection();
            return;
        }
        if (this.connReuseStrategy.keepAlive(this.response, (HttpContext)this.localContext)) {
            this.validDuration = this.keepaliveStrategy.getKeepAliveDuration(this.response, (HttpContext)this.localContext);
            if (this.log.isDebugEnabled()) {
                String s = this.validDuration > 0L ? "for " + this.validDuration + " " + (Object)((Object)TimeUnit.MILLISECONDS) : "indefinitely";
                this.log.debug((Object)("[exchange: " + this.id + "] Connection can be kept alive " + s));
            }
            this.reusable = true;
        } else {
            this.validDuration = 0L;
            this.reusable = false;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[exchange: " + this.id + "] Connection cannot be kept alive"));
            }
        }
        this.responseConsumer.responseCompleted((HttpContext)this.localContext);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Response processed"));
        }
        this.releaseConnection();
        Object result = this.responseConsumer.getResult();
        Exception ex = this.responseConsumer.getException();
        if (ex == null) {
            this.resultFuture.completed(result);
        } else {
            this.resultFuture.failed(ex);
        }
        this.completed = true;
    }

    public void inputTerminated() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void failed(Exception ex) {
        try {
            this.requestProducer.failed(ex);
            this.responseConsumer.failed(ex);
        }
        finally {
            try {
                this.resultFuture.failed(ex);
            }
            finally {
                this.close();
            }
        }
    }

    public synchronized boolean cancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Cancelled"));
        }
        try {
            boolean cancelled = this.responseConsumer.cancel();
            Object result = this.responseConsumer.getResult();
            Exception ex = this.responseConsumer.getException();
            if (ex != null) {
                this.resultFuture.failed(ex);
            } else if (result != null) {
                this.resultFuture.completed(result);
            } else {
                this.resultFuture.cancel();
            }
            boolean bl = cancelled;
            return bl;
        }
        catch (RuntimeException runex) {
            this.resultFuture.failed((Exception)runex);
            throw runex;
        }
        finally {
            this.close();
        }
    }

    private synchronized void connectionAllocated(NHttpClientConnection managedConn) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("[exchange: " + this.id + "] Connection allocated: " + managedConn));
            }
            this.managedConn = managedConn;
            if (this.closed) {
                this.releaseConnection();
                return;
            }
            this.localContext.setAttribute("http.connection", (Object)managedConn);
            if (!managedConn.isOpen()) {
                this.failed((Exception)new ConnectionClosedException("Connection closed"));
            } else {
                this.managedConn.getContext().setAttribute("http.nio.exchange-handler", (Object)this);
                this.managedConn.requestOutput();
            }
        }
        catch (RuntimeException runex) {
            this.failed(runex);
            throw runex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void connectionRequestFailed(Exception ex) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Connection request failed"));
        }
        try {
            this.resultFuture.failed(ex);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void connectionRequestCancelled() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Connection request cancelled"));
        }
        try {
            this.resultFuture.cancel();
        }
        finally {
            this.close();
        }
    }

    private void requestConnection() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("[exchange: " + this.id + "] Request connection for " + this.route));
        }
        Object userToken = this.localContext.getUserToken();
        RequestConfig config = this.localContext.getRequestConfig();
        this.connmgr.requestConnection(this.route, userToken, config.getConnectionRequestTimeout(), TimeUnit.MILLISECONDS, new FutureCallback<NHttpClientConnection>(){

            public void completed(NHttpClientConnection managedConn) {
                MinimalClientExchangeHandlerImpl.this.connectionAllocated(managedConn);
            }

            public void failed(Exception ex) {
                MinimalClientExchangeHandlerImpl.this.connectionRequestFailed(ex);
            }

            public void cancelled() {
                MinimalClientExchangeHandlerImpl.this.connectionRequestCancelled();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnection() {
        if (this.managedConn != null) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[exchange: " + this.id + "] Releasing connection"));
                }
                this.managedConn.getContext().removeAttribute("http.nio.exchange-handler");
                if (this.reusable) {
                    this.connmgr.releaseConnection(this.managedConn, this.localContext.getUserToken(), this.validDuration, TimeUnit.MILLISECONDS);
                    this.managedConn = null;
                }
            }
            finally {
                this.abortConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortConnection() {
        if (this.managedConn != null) {
            try {
                this.managedConn.shutdown();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[exchange: " + this.id + "] Connection discarded"));
                }
            }
            catch (IOException ex) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            finally {
                this.connmgr.releaseConnection(this.managedConn, null, 0L, TimeUnit.MILLISECONDS);
            }
        }
        this.managedConn = null;
    }
}

